/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    static final Object treeLock = new String("AWT_TREE_LOCK");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean ignoreRepaint;
    boolean visible;
    boolean enabled;
    boolean valid;
    DropTarget dropTarget;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    boolean focusable;
    int isFocusTraversableOverridden;
    Set[] focusTraversalKeys;
    boolean focusTraversalKeysEnabled;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    AccessibleContext accessibleContext;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentOrientation orientation;
    transient GraphicsConfiguration graphicsConfig;
    transient BufferStrategy bufferStrategy;
    private transient FocusEvent pendingFocusRequest;
    private static transient boolean incrementalDraw = Boolean.getBoolean("awt.image.incrementalDraw");
    private static transient Long redrawRate = Long.getLong("awt.image.redrawrate");

    private /* synthetic */ void finit$() {
        this.locale = Locale.getDefault();
        this.visible = true;
        this.enabled = true;
        this.focusable = true;
        this.focusTraversalKeysEnabled = true;
        this.eventMask = 4096;
        this.componentSerializedDataVersion = 4;
        this.orientation = ComponentOrientation.UNKNOWN;
        this.pendingFocusRequest = null;
    }

    protected Component() {
        this.finit$();
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.nameExplicitlySet = true;
        this.name = string;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public void setDropTarget(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit toolkit;
        if (this.peer != null && (toolkit = this.peer.getToolkit()) != null) {
            return toolkit;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        return this.peer != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        this.enabled = true;
        if (this.peer != null) {
            this.peer.setEnabled(true);
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        this.enabled = false;
        if (this.peer != null) {
            this.peer.setEnabled(false);
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl) {
        this.eventMask = bl ? (this.eventMask |= (long)4096) : (this.eventMask &= (long)-4097);
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (!this.isVisible()) {
            Container container;
            this.visible = true;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null) {
                componentPeer.setVisible(true);
            }
            if (this.isShowing()) {
                this.repaint();
            }
            if ((container = this.parent) != null) {
                container.invalidate();
            }
            ComponentEvent componentEvent = new ComponentEvent(this, 102);
            this.getToolkit().getSystemEventQueue().postEvent(componentEvent);
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.isVisible()) {
            Container container;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null) {
                componentPeer.setVisible(false);
            }
            boolean bl = this.isShowing();
            this.visible = false;
            if (bl) {
                this.repaint();
            }
            if ((container = this.parent) != null) {
                container.invalidate();
            }
            ComponentEvent componentEvent = new ComponentEvent(this, 103);
            this.getToolkit().getSystemEventQueue().postEvent(componentEvent);
        }
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getForeground();
    }

    public void setForeground(Color color) {
        if (this.peer != null) {
            this.peer.setForeground(color);
        }
        Color color2 = this.foreground;
        this.foreground = color;
        this.firePropertyChange("foreground", color2, color);
    }

    public boolean isForegroundSet() {
        return this.foreground != null;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackground();
    }

    public void setBackground(Color color) {
        if (color != null && color.equals(this.background)) {
            return;
        }
        if (color == null && this.parent != null) {
            color = this.parent.getBackground();
        }
        if (this.peer != null && color != null) {
            this.peer.setBackground(color);
        }
        Color color2 = this.background;
        this.background = color;
        this.firePropertyChange("background", color2, color);
    }

    public boolean isBackgroundSet() {
        return this.background != null;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFont();
        }
        if (this.peer != null) {
            return this.peer.getGraphics().getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (font != null && (this.font == null || !this.font.equals(font)) || font == null) {
            Font font2 = this.font;
            this.font = font;
            if (this.peer != null) {
                this.peer.setFont(this.font);
            }
            this.firePropertyChange("font", font2, font);
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        return this.font != null;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: can't determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component " + this.getClass().getName() + " not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.resize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Serializable serializable;
        Rectangle rectangle2;
        int n5 = this.x;
        int n6 = this.y;
        int n7 = this.width;
        int n8 = this.height;
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        this.invalidate();
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.peer != null) {
            this.peer.setBounds(n, n2, n3, n4);
        }
        if (this.isLightweight() && this.isShowing() && this.parent != null && !(rectangle2 = ((Rectangle)(serializable = new Rectangle(n5, n6, n7, n8))).union(rectangle = new Rectangle(n, n2, n3, n4))).isEmpty()) {
            this.parent.repaint(0L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        if (this.isShowing() && (n5 != n || n6 != n2)) {
            serializable = new ComponentEvent(this, 100);
            this.getToolkit().getSystemEventQueue().postEvent((AWTEvent)serializable);
        }
        if (this.isShowing() && (n7 != n3 || n8 != n4)) {
            serializable = new ComponentEvent(this, 101);
            this.getToolkit().getSystemEventQueue().postEvent((AWTEvent)serializable);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.x;
        rectangle.y = this.y;
        rectangle.width = this.width;
        rectangle.height = this.height;
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.width = this.width;
        dimension.height = this.height;
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.x = this.x;
        point.y = this.y;
        return point;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.prefSize == null) {
            if (this.peer == null) {
                return new Dimension(this.width, this.height);
            }
            this.prefSize = this.peer.getPreferredSize();
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.minSize == null) {
            this.minSize = this.peer != null ? this.peer.getMinimumSize() : new Dimension(this.width, this.height);
        }
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    public void validate() {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
        this.prefSize = null;
        this.minSize = null;
        if (this.parent != null && this.parent.isValid()) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics graphics = this.peer.getGraphics();
            if (graphics == null && this.parent != null) {
                graphics = this.parent.getGraphics();
                Rectangle rectangle = this.getBounds();
                graphics.setClip(rectangle);
                graphics.translate(rectangle.x, rectangle.y);
                return graphics;
            }
            graphics.setFont(this.font);
            return graphics;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.peer == null) {
            return this.getToolkit().getFontMetrics(font);
        }
        return this.peer.getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        if (this.peer != null) {
            this.peer.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        if (this.parent != null) {
            return this.parent.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    public boolean isCursorSet() {
        return this.cursor != null;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        if (this.isLightweight() || this.getParent() == null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                graphics.clearRect(0, 0, this.width, this.height);
            } else {
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.paint(graphics);
    }

    public void repaint() {
        if (this.isShowing()) {
            this.repaint(0L, 0, 0, this.width, this.height);
        }
    }

    public void repaint(long l) {
        if (this.isShowing()) {
            this.repaint(l, 0, 0, this.width, this.height);
        }
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            this.repaint(0L, n, n2, n3, n4);
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        ComponentPeer componentPeer;
        if (this.isShowing() && (componentPeer = this.peer) != null) {
            componentPeer.repaint(l, n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        this.paintAll(graphics);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.repaint();
        } else if ((n & 8) != 0 && incrementalDraw) {
            if (redrawRate != null) {
                long l = redrawRate;
                if (l < 0L) {
                    l = 0L;
                }
                this.repaint(l);
            } else {
                this.repaint(100);
            }
        }
        return (n & 0xE0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        if (this.peer != null) {
            return this.peer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        Image image = null;
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.isLightweight() && this.parent != null) {
                image = this.parent.createImage(n, n2);
            } else if (this.peer != null) {
                image = this.peer.createImage(n, n2);
            }
        }
        return image;
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        return graphicsConfiguration.createCompatibleVolatileImage(n, n2);
    }

    public VolatileImage createVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return null;
        }
        return graphicsConfiguration.createCompatibleVolatileImage(n, n2, imageCapabilities);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.peer != null) {
            return this.peer.prepareImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.peer != null) {
            return this.peer.checkImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public void setIgnoreRepaint(boolean bl) {
        this.ignoreRepaint = bl;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component locate(int n, int n2) {
        if (this.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    public boolean postEvent(Event event) {
        boolean bl = this.handleEvent(event);
        if (!bl && this.getParent() != null) {
            bl = this.getParent().postEvent(event);
        }
        return bl;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        return (ComponentListener[])AWTEventMulticaster.getListeners(this.componentListener, Component.class$("java.awt.event.ComponentListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return (FocusListener[])AWTEventMulticaster.getListeners(this.focusListener, Component.class$("java.awt.event.FocusListener"));
    }

    public synchronized void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])AWTEventMulticaster.getListeners(this.hierarchyListener, Component.class$("java.awt.event.HierarchyListener"));
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(65536L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return (HierarchyBoundsListener[])AWTEventMulticaster.getListeners(this.hierarchyBoundsListener, Component.class$("java.awt.event.HierarchyBoundsListener"));
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        if (this.keyListener != null) {
            this.enableEvents(8);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])AWTEventMulticaster.getListeners(this.keyListener, Component.class$("java.awt.event.KeyListener"));
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        if (this.mouseListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])AWTEventMulticaster.getListeners(this.mouseListener, Component.class$("java.awt.event.MouseListener"));
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        if (this.mouseMotionListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])AWTEventMulticaster.getListeners(this.mouseMotionListener, Component.class$("java.awt.event.MouseMotionListener"));
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, mouseWheelListener);
        if (this.mouseWheelListener != null) {
            this.enableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, mouseWheelListener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return (MouseWheelListener[])AWTEventMulticaster.getListeners(this.mouseWheelListener, Component.class$("java.awt.event.MouseWheelListener"));
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])AWTEventMulticaster.getListeners(this.inputMethodListener, Component.class$("java.awt.event.InputMethodListener"));
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Component.class$("java.awt.event.ComponentListener")) {
            return this.getComponentListeners();
        }
        if (clazz == Component.class$("java.awt.event.FocusListener")) {
            return this.getFocusListeners();
        }
        if (clazz == Component.class$("java.awt.event.HierarchyListener")) {
            return this.getHierarchyListeners();
        }
        if (clazz == Component.class$("java.awt.event.HierarchyBoundsListener")) {
            return this.getHierarchyBoundsListeners();
        }
        if (clazz == Component.class$("java.awt.event.KeyListener")) {
            return this.getKeyListeners();
        }
        if (clazz == Component.class$("java.awt.event.MouseListener")) {
            return this.getMouseListeners();
        }
        if (clazz == Component.class$("java.awt.event.MouseMotionListener")) {
            return this.getMouseMotionListeners();
        }
        if (clazz == Component.class$("java.awt.event.MouseWheelListener")) {
            return this.getMouseWheelListeners();
        }
        if (clazz == Component.class$("java.awt.event.InputMethodListener")) {
            return this.getInputMethodListeners();
        }
        if (clazz == Component.class$("java.beans.PropertyChangeListener")) {
            return this.getPropertyChangeListeners();
        }
        return (EventListener[])Array.newInstance(clazz, 0);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getInputContext();
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(l);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ (long)-1;
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        switch (aWTEvent.id) {
            case 503: 
            case 506: {
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)aWTEvent, (PaintEvent)aWTEvent2);
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseWheelEvent) {
            this.processMouseWheelEvent((MouseWheelEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.id == 503 || aWTEvent.id == 506) {
                this.processMouseMotionEvent((MouseEvent)aWTEvent);
            } else {
                this.processMouseEvent((MouseEvent)aWTEvent);
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            if (aWTEvent.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)aWTEvent);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.componentListener == null) {
            return;
        }
        switch (componentEvent.id) {
            case 103: {
                this.componentListener.componentHidden(componentEvent);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(componentEvent);
                break;
            }
            case 101: {
                this.componentListener.componentResized(componentEvent);
                break;
            }
            case 102: {
                this.componentListener.componentShown(componentEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener == null) {
            return;
        }
        switch (focusEvent.id) {
            case 1004: {
                this.focusListener.focusGained(focusEvent);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(focusEvent);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener == null) {
            return;
        }
        switch (keyEvent.id) {
            case 401: {
                this.keyListener.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(keyEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 500: {
                this.mouseListener.mouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(mouseEvent);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(mouseEvent);
            }
        }
        mouseEvent.consume();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(mouseEvent);
            }
        }
        mouseEvent.consume();
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.mouseWheelListener != null && mouseWheelEvent.id == 507) {
            this.mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            mouseWheelEvent.consume();
        }
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (inputMethodEvent.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(inputMethodEvent);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(inputMethodEvent);
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (hierarchyEvent.id == 1400) {
            this.hierarchyListener.hierarchyChanged(hierarchyEvent);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (hierarchyEvent.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(hierarchyEvent);
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
        this.peer.setEventMask(this.eventMask);
    }

    public void removeNotify() {
        ComponentPeer componentPeer = this.peer;
        this.peer = null;
        if (componentPeer != null) {
            componentPeer.hide();
            componentPeer.dispose();
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.enabled && this.visible && (this.peer == null || this.isLightweight() || this.peer.isFocusTraversable());
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean bl) {
        this.firePropertyChange("focusable", this.focusable, bl);
        this.focusable = bl;
        this.isFocusTraversableOverridden = 1;
    }

    public void setFocusTraversalKeys(int n, Set set) {
        Set set2;
        Set set3;
        Object object;
        if (set == null) {
            for (object = this.getParent(); object != null; object = ((Component)object).getParent()) {
                if (!((Container)object).areFocusTraversalKeysSet(n)) continue;
                set = ((Container)object).getFocusTraversalKeys(n);
                break;
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                object = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                set3 = this.getFocusTraversalKeys(0);
                set2 = this.getFocusTraversalKeys(2);
                object = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                set3 = this.getFocusTraversalKeys(0);
                set2 = this.getFocusTraversalKeys(1);
                object = "upCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object2 = iterator.next();
            if (object2 instanceof AWTKeyStroke && !set3.contains(object2) && !set2.contains(object2) && ((AWTKeyStroke)object2).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange((String)object, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    public Set getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        Set set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        if (set == null) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
        }
        return set;
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    public void setFocusTraversalKeysEnabled(boolean bl) {
        this.firePropertyChange("focusTraversalKeysEnabled", this.focusTraversalKeysEnabled, bl);
        this.focusTraversalKeysEnabled = bl;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    public void requestFocus() {
        if (this.isDisplayable() && this.isShowing() && this.isFocusable()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                KeyboardFocusManager keyboardFocusManager;
                block12: {
                    try {
                        Container container;
                        Container container2 = container = this instanceof Container ? (Container)this : this.getParent();
                        while (container != null && !(container instanceof Window)) {
                            container = container.getParent();
                        }
                        if (container == null) {
                            Object var6_3 = null;
                            return;
                        }
                        Window window = (Window)container;
                        if (window.isFocusableWindow()) {
                            EventQueue eventQueue;
                            if (this.peer != null && !this.isLightweight()) {
                                this.peer.requestFocus();
                                break block12;
                            }
                            EventQueue eventQueue2 = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                            synchronized (eventQueue2) {
                                block13: {
                                    try {
                                        keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                        Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                        if (component != null) {
                                            eventQueue.postEvent(new FocusEvent(component, 1005, false, this));
                                            eventQueue.postEvent(new FocusEvent(this, 1004, false, component));
                                            break block13;
                                        }
                                        eventQueue.postEvent(new FocusEvent(this, 1004, false));
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_5 = null;
                                        throw throwable;
                                    }
                                }
                                keyboardFocusManager = null;
                                break block12;
                            }
                        }
                        this.pendingFocusRequest = new FocusEvent(this, 1004);
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        throw throwable;
                    }
                }
                keyboardFocusManager = null;
            }
        }
    }

    protected boolean requestFocus(boolean bl) {
        if (this.isDisplayable() && this.isShowing() && this.isFocusable()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                KeyboardFocusManager keyboardFocusManager;
                block11: {
                    try {
                        Container container;
                        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                        }
                        Window window = (Window)container;
                        if (window.isFocusableWindow()) {
                            EventQueue eventQueue;
                            if (this.peer != null && !this.isLightweight()) {
                                this.peer.requestFocus();
                                break block11;
                            }
                            EventQueue eventQueue2 = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                            synchronized (eventQueue2) {
                                block12: {
                                    try {
                                        keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                        Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                        if (component != null) {
                                            eventQueue.postEvent(new FocusEvent(component, 1005, bl, this));
                                            eventQueue.postEvent(new FocusEvent(this, 1004, bl, component));
                                            break block12;
                                        }
                                        eventQueue.postEvent(new FocusEvent(this, 1004, bl));
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_8 = null;
                                        throw throwable;
                                    }
                                }
                                keyboardFocusManager = null;
                                break block11;
                            }
                        }
                        this.pendingFocusRequest = new FocusEvent(this, 1004, bl);
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        throw throwable;
                    }
                }
                keyboardFocusManager = null;
            }
        }
        boolean bl2 = true;
        return bl2;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean bl) {
        block13: {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getFocusedWindow();
            if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block13;
            if (window != null) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    block11: {
                        try {
                            Container container;
                            for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                            }
                            Window window2 = (Window)container;
                            if (window == window2) {
                                EventQueue eventQueue;
                                if (this.peer != null && !this.isLightweight() && !(this instanceof Window)) {
                                    this.peer.requestFocus();
                                    break block11;
                                }
                                EventQueue eventQueue2 = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                                synchronized (eventQueue2) {
                                    Component component;
                                    block12: {
                                        try {
                                            component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                            if (component != null) {
                                                eventQueue.postEvent(new FocusEvent(component, 1005, bl, this));
                                                eventQueue.postEvent(new FocusEvent(this, 1004, bl, component));
                                                break block12;
                                            }
                                            eventQueue.postEvent(new FocusEvent(this, 1004, bl));
                                        }
                                        catch (Throwable throwable) {
                                            Object var9_10 = null;
                                            throw throwable;
                                        }
                                    }
                                    component = null;
                                    break block11;
                                }
                            }
                            boolean bl2 = false;
                            Object var10_15 = null;
                            return bl2;
                        }
                        catch (Throwable throwable) {
                            Object var10_17 = null;
                            throw throwable;
                        }
                    }
                    Object var10_16 = null;
                }
            }
            boolean bl3 = true;
            return bl3;
        }
        boolean bl4 = false;
        return bl4;
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        Container container;
        if (this instanceof Window && ((Container)this).isFocusCycleRoot()) {
            return (Container)this;
        }
        for (container = this.getParent(); container != null && !container.isFocusCycleRoot(); container = container.getParent()) {
        }
        return container;
    }

    public boolean isFocusCycleRoot(Container container) {
        return container == this.getFocusCycleRootAncestor();
    }

    public void nextFocus() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.focusNextComponent(this);
    }

    public void transferFocusBackward() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.focusPreviousComponent(this);
    }

    public void transferFocusUpCycle() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.upFocusCycle(this);
    }

    public boolean hasFocus() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        return this == component;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.add(popupMenu);
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        popupMenu.parent = this;
        if (this.peer != null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        if (this.popups != null) {
            this.popups.remove(menuComponent);
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        if (string != null) {
            stringBuffer.append(string).append(",");
        }
        stringBuffer.append(this.x).append(",").append(this.y).append(",").append(this.width).append("x").append(this.height);
        if (!this.isValid()) {
            stringBuffer.append(",invalid");
        }
        if (!this.isVisible()) {
            stringBuffer.append(",invisible");
        }
        if (!this.isEnabled()) {
            stringBuffer.append(",disabled");
        }
        if (!this.isOpaque()) {
            stringBuffer.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            stringBuffer.append(",doublebuffered");
        }
        if (this.parent == null) {
            stringBuffer.append(",parent=null");
        } else {
            stringBuffer.append(",parent=").append(this.parent.getName());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.paramString() + ']';
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(' ');
        }
        printStream.println(this.toString());
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
        printWriter.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, bl, bl2);
        }
    }

    protected void firePropertyChange(String string, int n, int n2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, n, n2);
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        ComponentOrientation componentOrientation2 = this.orientation;
        this.orientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        this.setComponentOrientation(componentOrientation);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    String generateName() {
        return null;
    }

    final void setPeer(ComponentPeer componentPeer) {
        this.peer = componentPeer;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.peer != null && (graphicsConfiguration = this.peer.getGraphicsConfiguration()) != null) {
            return graphicsConfiguration;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    static Event translateEvent(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        Event event = null;
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            long l = inputEvent.getWhen();
            int n = 0;
            int n2 = aWTEvent.getID();
            int n3 = 0;
            int n4 = inputEvent.getModifiersEx();
            if ((n4 & 0x800) != 0) {
                n3 |= 4;
            } else if ((n4 & 0x1000) != 0) {
                n3 |= 8;
            }
            if ((n4 & 0x40) != 0) {
                n3 |= 1;
            }
            if ((n4 & 0x80) != 0) {
                n3 |= 2;
            }
            if ((n4 & 0x100) != 0) {
                n3 |= 4;
            }
            if ((n4 & 0x200) != 0) {
                n3 |= 8;
            }
            if (aWTEvent instanceof MouseEvent) {
                if (n2 == 501) {
                    n = 501;
                } else if (n2 == 502) {
                    n = 502;
                } else if (n2 == 503) {
                    n = 503;
                } else if (n2 == 506) {
                    n = 506;
                } else if (n2 == 504) {
                    n = 504;
                } else if (n2 == 505) {
                    n = 505;
                } else {
                    return null;
                }
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                event = new Event(component, l, n, mouseEvent.getX(), mouseEvent.getY(), 0, n3);
            } else if (aWTEvent instanceof KeyEvent) {
                if (n2 == 401) {
                    n = 401;
                } else if (aWTEvent.getID() == 402) {
                    n = 402;
                } else {
                    return null;
                }
                int n5 = 0;
                int n6 = ((KeyEvent)aWTEvent).getKeyCode();
                switch (n6) {
                    case 8: {
                        n5 = 8;
                        break;
                    }
                    case 20: {
                        n5 = 1022;
                        break;
                    }
                    case 127: {
                        n5 = 127;
                        break;
                    }
                    case 40: 
                    case 225: {
                        n5 = 1005;
                        break;
                    }
                    case 35: {
                        n5 = 1001;
                        break;
                    }
                    case 10: {
                        n5 = 10;
                        break;
                    }
                    case 27: {
                        n5 = 27;
                        break;
                    }
                    case 112: {
                        n5 = 1008;
                        break;
                    }
                    case 121: {
                        n5 = 1017;
                        break;
                    }
                    case 122: {
                        n5 = 1018;
                        break;
                    }
                    case 123: {
                        n5 = 1019;
                        break;
                    }
                    case 113: {
                        n5 = 1009;
                        break;
                    }
                    case 114: {
                        n5 = 1010;
                        break;
                    }
                    case 115: {
                        n5 = 1011;
                        break;
                    }
                    case 116: {
                        n5 = 1012;
                        break;
                    }
                    case 117: {
                        n5 = 1013;
                        break;
                    }
                    case 118: {
                        n5 = 1014;
                        break;
                    }
                    case 119: {
                        n5 = 1015;
                        break;
                    }
                    case 120: {
                        n5 = 1016;
                        break;
                    }
                    case 36: {
                        n5 = 1000;
                        break;
                    }
                    case 155: {
                        n5 = 1025;
                        break;
                    }
                    case 37: 
                    case 226: {
                        n5 = 1006;
                        break;
                    }
                    case 144: {
                        n5 = 1023;
                        break;
                    }
                    case 19: {
                        n5 = 1024;
                        break;
                    }
                    case 34: {
                        n5 = 1003;
                        break;
                    }
                    case 33: {
                        n5 = 1002;
                        break;
                    }
                    case 154: {
                        n5 = 1020;
                        break;
                    }
                    case 39: 
                    case 227: {
                        n5 = 1007;
                        break;
                    }
                    case 145: {
                        n5 = 1021;
                        break;
                    }
                    case 9: {
                        n5 = 9;
                        break;
                    }
                    case 38: 
                    case 224: {
                        n5 = 1004;
                        break;
                    }
                    default: {
                        n5 = n6;
                    }
                }
                event = new Event(component, l, n, 0, 0, n5, n3);
            }
        } else if (aWTEvent instanceof ActionEvent) {
            event = new Event(component, 1001, ((ActionEvent)aWTEvent).getActionCommand());
        }
        return event;
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Event event = Component.translateEvent(aWTEvent);
        if (event != null) {
            this.postEvent(event);
        }
        if (this.eventTypeEnabled(aWTEvent.id)) {
            if (!Thread.holdsLock(aWTEvent)) {
                switch (aWTEvent.id) {
                    case 207: 
                    case 208: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 1004: 
                    case 1005: {
                        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(aWTEvent)) {
                            return;
                        }
                    }
                    case 501: {
                        if (!this.isLightweight()) break;
                        this.requestFocus();
                    }
                }
            }
            if (aWTEvent.id != 800 && aWTEvent.id != 801) {
                this.processEvent(aWTEvent);
            }
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    boolean eventTypeEnabled(int n) {
        if (n > 1999) {
            return true;
        }
        switch (n) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return this.componentListener != null || (this.eventMask & 1L) != 0L;
            }
            case 400: 
            case 401: 
            case 402: {
                return this.keyListener != null || (this.eventMask & (long)8) != 0L;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                return this.mouseListener != null || this.mouseMotionListener != null || (this.eventMask & (long)16) != 0L;
            }
            case 1004: 
            case 1005: {
                return this.focusListener != null || (this.eventMask & (long)4) != 0L;
            }
            case 1100: 
            case 1101: {
                return this.inputMethodListener != null || (this.eventMask & (long)2048) != 0L;
            }
            case 800: 
            case 801: {
                return (this.eventMask & (long)8192) != 0L;
            }
        }
        return false;
    }

    private PaintEvent coalescePaintEvents(PaintEvent paintEvent, PaintEvent paintEvent2) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Rectangle rectangle2 = paintEvent2.getUpdateRect();
        Rectangle rectangle3 = rectangle.union(rectangle2);
        int n = rectangle3.width * rectangle3.height;
        int n2 = rectangle.width * rectangle.height;
        int n3 = rectangle2.width * rectangle2.height;
        if (n > (n2 + n3) * 2) {
            return null;
        }
        paintEvent2.setUpdateRect(rectangle3);
        return paintEvent2;
    }

    Component findNextFocusComponent(Component component) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("componentL".equals(string)) {
                this.addComponentListener((ComponentListener)object);
            } else if ("focusL".equals(string)) {
                this.addFocusListener((FocusListener)object);
            } else if ("keyL".equals(string)) {
                this.addKeyListener((KeyListener)object);
            } else if ("mouseL".equals(string)) {
                this.addMouseListener((MouseListener)object);
            } else if ("mouseMotionL".equals(string)) {
                this.addMouseMotionListener((MouseMotionListener)object);
            } else if ("inputMethodL".equals(string)) {
                this.addInputMethodListener((InputMethodListener)object);
            } else if ("hierarchyL".equals(string)) {
                this.addHierarchyListener((HierarchyListener)object);
            } else if ("hierarchyBoundsL".equals(string)) {
                this.addHierarchyBoundsListener((HierarchyBoundsListener)object);
            } else if ("mouseWheelL".equals(string)) {
                this.addMouseWheelListener((MouseWheelListener)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "componentL", this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, "focusL", this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, "keyL", this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseL", this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseMotionL", this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, "inputMethodL", this.inputMethodListener);
        AWTEventMulticaster.save(objectOutputStream, "hierarchyL", this.hierarchyListener);
        AWTEventMulticaster.save(objectOutputStream, "hierarchyBoundsL", this.hierarchyBoundsListener);
        AWTEventMulticaster.save(objectOutputStream, "mouseWheelL", this.mouseWheelListener);
        objectOutputStream.writeObject(null);
    }

    protected class FlipBufferStrategy
    extends BufferStrategy {
        private /* synthetic */ Component this$0;
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;
        private int width;
        private int height;

        protected FlipBufferStrategy(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
            this.this$0 = component;
            this.caps = bufferCapabilities;
            this.width = component.getWidth();
            this.height = component.getHeight();
            if (n > 1) {
                this.createBuffers(n, bufferCapabilities);
            } else {
                this.drawVBuffer = component.peer.createVolatileImage(this.width, this.height);
                this.drawBuffer = this.drawVBuffer;
            }
        }

        protected void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
            if (n <= 1) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: numBuffers must be greater than one.");
            }
            if (!bufferCapabilities.isPageFlipping()) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: flipping must be a specified capability.");
            }
            this.this$0.peer.createBuffers(n, bufferCapabilities);
        }

        protected Image getBackBuffer() {
            return this.this$0.peer.getBackBuffer();
        }

        protected void flip(BufferCapabilities.FlipContents flipContents) {
            this.this$0.peer.flip(flipContents);
        }

        protected void destroyBuffers() {
            this.this$0.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.drawVBuffer.getGraphics();
        }

        protected void revalidate() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (this.drawVBuffer.validate(graphicsConfiguration) == 2) {
                this.drawVBuffer = this.this$0.peer.createVolatileImage(this.width, this.height);
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer.contentsLost()) {
                this.validatedContents = false;
                return true;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int n = this.drawVBuffer.validate(graphicsConfiguration);
            boolean bl = false;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                return false;
            }
            this.validatedContents = true;
            return bl;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }
    }

    protected class BltBufferStrategy
    extends BufferStrategy {
        private /* synthetic */ Component this$0;
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;
        private VolatileImage frontBuffer;

        protected BltBufferStrategy(Component component, int n, BufferCapabilities bufferCapabilities) {
            this.this$0 = component;
            this.caps = bufferCapabilities;
            this.createBackBuffers(n - 1);
            this.width = component.getWidth();
            this.height = component.getHeight();
        }

        protected void createBackBuffers(int n) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.backBuffers = new VolatileImage[n];
            for (int i = 0; i < n; ++i) {
                this.backBuffers[i] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.backBuffers[0].getGraphics();
        }

        public void show() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.this$0.getGraphics().drawImage(this.backBuffers[this.backBuffers.length - 1], this.width, this.height, null);
            BufferCapabilities.FlipContents flipContents = this.getCapabilities().getFlipContents();
            for (int i = this.backBuffers.length - 1; i > 0; --i) {
                this.backBuffers[i] = this.backBuffers[i - 1];
            }
            if (flipContents == BufferCapabilities.FlipContents.UNDEFINED) {
                this.backBuffers[0] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
            }
            if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
                this.backBuffers[0] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
                this.backBuffers[0].getGraphics().clearRect(0, 0, this.width, this.height);
            }
            if (flipContents == BufferCapabilities.FlipContents.COPIED) {
                this.backBuffers[0] = this.backBuffers[this.backBuffers.length - 1];
            }
        }

        protected void revalidate() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            for (int i = 0; i < this.backBuffers.length; ++i) {
                int n = this.backBuffers[i].validate(graphicsConfiguration);
                if (n != 2) continue;
                this.backBuffers[i] = graphicsConfiguration.createCompatibleVolatileImage(this.width, this.height);
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            for (int i = 0; i < this.backBuffers.length; ++i) {
                if (!this.backBuffers[i].contentsLost()) continue;
                this.validatedContents = false;
                return true;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            boolean bl = false;
            for (int i = 0; i < this.backBuffers.length; ++i) {
                int n = this.backBuffers[i].validate(graphicsConfiguration);
                if (n == 1) {
                    bl = true;
                    continue;
                }
                if (n != 2) continue;
                return false;
            }
            this.validatedContents = true;
            return bl;
        }
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private /* synthetic */ Component this$0;
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler;
        protected FocusListener accessibleAWTFocusHandler;

        private /* synthetic */ void finit$() {
            this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler(this);
            this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler(this);
        }

        protected AccessibleAWTComponent(Component component) {
            this.this$0 = component;
            this.finit$();
            component.addComponentListener(this.accessibleAWTComponentHandler);
            component.addFocusListener(this.accessibleAWTFocusHandler);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.this$0.addPropertyChangeListener(propertyChangeListener);
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.this$0.removePropertyChangeListener(propertyChangeListener);
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleName() {
            if (this.accessibleName == null) {
                return this.this$0.getName();
            }
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (this.this$0.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (this.this$0.isFocusable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (this.this$0.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (this.this$0.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            if (this.this$0.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (this.this$0.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null) {
                Container container = this.this$0.getParent();
                this.accessibleParent = container instanceof Accessible ? (Accessible)((Object)container) : null;
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() == null) {
                return -1;
            }
            AccessibleContext accessibleContext = ((Component)((Object)this.accessibleParent)).getAccessibleContext();
            if (accessibleContext == null) {
                return -1;
            }
            int n = accessibleContext.getAccessibleChildrenCount();
            while (--n >= 0) {
                if (accessibleContext.getAccessibleChild(n) != this.this$0) continue;
                return n;
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            return this.this$0.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return this.this$0.getBackground();
        }

        public void setBackground(Color color) {
            this.this$0.setBackground(color);
        }

        public Color getForeground() {
            return this.this$0.getForeground();
        }

        public void setForeground(Color color) {
            this.this$0.setForeground(color);
        }

        public Cursor getCursor() {
            return this.this$0.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.this$0.setCursor(cursor);
        }

        public Font getFont() {
            return this.this$0.getFont();
        }

        public void setFont(Font font) {
            this.this$0.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.this$0.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return this.this$0.isEnabled();
        }

        public void setEnabled(boolean bl) {
            this.this$0.setEnabled(bl);
        }

        public boolean isVisible() {
            return this.this$0.isVisible();
        }

        public void setVisible(boolean bl) {
            this.this$0.setVisible(bl);
        }

        public boolean isShowing() {
            return this.this$0.isShowing();
        }

        public boolean contains(Point point) {
            return this.this$0.contains(point.x, point.y);
        }

        public Point getLocationOnScreen() {
            if (this.this$0.isShowing()) {
                return this.this$0.getLocationOnScreen();
            }
            return null;
        }

        public Point getLocation() {
            if (this.this$0.isShowing()) {
                return this.this$0.getLocation();
            }
            return null;
        }

        public void setLocation(Point point) {
            this.this$0.setLocation(point.x, point.y);
        }

        public Rectangle getBounds() {
            if (this.this$0.isShowing()) {
                return this.this$0.getBounds();
            }
            return null;
        }

        public void setBounds(Rectangle rectangle) {
            this.this$0.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Dimension getSize() {
            if (this.this$0.isShowing()) {
                return this.this$0.getSize();
            }
            return null;
        }

        public void setSize(Dimension dimension) {
            this.this$0.setSize(dimension.width, dimension.height);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return this.this$0.isFocusTraversable();
        }

        public void requestFocus() {
            this.this$0.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            this.this$0.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            this.this$0.removeFocusListener(focusListener);
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleAWTComponent this$1;

            protected AccessibleAWTFocusHandler(AccessibleAWTComponent accessibleAWTComponent) {
                this.this$1 = accessibleAWTComponent;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            private /* synthetic */ AccessibleAWTComponent this$1;

            protected AccessibleAWTComponentHandler(AccessibleAWTComponent accessibleAWTComponent) {
                this.this$1 = accessibleAWTComponent;
            }

            public void componentHidden(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }
}

