/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Choice
extends Component
implements ItemSelectable,
Serializable,
Accessible {
    private static final long serialVersionUID = -4075310674757313071L;
    Vector pItems;
    private int selectedIndex;
    private ItemListener item_listeners;

    private /* synthetic */ void finit$() {
        this.pItems = new Vector();
        this.selectedIndex = -1;
    }

    public Choice() {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public synchronized void add(String string) {
        if (string == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(string);
        int n = this.pItems.size() - 1;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        } else if (this.selectedIndex == -1) {
            this.select(0);
        }
    }

    public synchronized void addItem(String string) {
        this.add(string);
    }

    public synchronized void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (n > this.getItemCount()) {
            n = this.getItemCount();
        }
        this.pItems.insertElementAt(string, n);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        } else if (this.selectedIndex == -1 || this.selectedIndex >= n) {
            this.select(0);
        }
    }

    public synchronized void remove(String string) {
        int n = this.pItems.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("item \"" + string + "\" not found in Choice");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        if (n < 0 || n > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + n);
        }
        this.pItems.removeElementAt(n);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.remove(n);
        } else if (this.getItemCount() == 0) {
            this.selectedIndex = -1;
        } else if (n == this.selectedIndex) {
            this.select(0);
        }
        if (this.selectedIndex > n) {
            --this.selectedIndex;
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return (String)this.pItems.elementAt(this.selectedIndex);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objectArray = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objectArray;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n < 0 || n > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + n);
        }
        this.selectedIndex = n;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.select(n);
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        int n = this.pItems.indexOf((String)itemEvent.getItem());
        if (itemEvent.getStateChange() == 1) {
            this.selectedIndex = n;
        }
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + "," + super.paramString();
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Choice.class$("java.awt.event.ItemListener")) {
            return AWTEventMulticaster.getListeners(this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(Choice.class$("java.awt.event.ItemListener"));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private /* synthetic */ Choice this$0;
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAWTChoice(Choice choice) {
            this.this$0 = choice;
            super(choice);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return this.this$0.pItems.size();
        }

        public String getAccessibleActionDescription(int n) {
            return (String)this.this$0.pItems.get(n);
        }

        public boolean doAccessibleAction(int n) {
            if (n < 0 || n >= this.this$0.pItems.size()) {
                return false;
            }
            this.this$0.processItemEvent(new ItemEvent(this.this$0, 701, this, 1));
            return true;
        }
    }
}

