/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NamespaceTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Test;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.XMLConstants;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Selector
extends Path {
    public static final int ANCESTOR = 0;
    public static final int ANCESTOR_OR_SELF = 1;
    public static final int ATTRIBUTE = 2;
    public static final int CHILD = 3;
    public static final int DESCENDANT = 4;
    public static final int DESCENDANT_OR_SELF = 5;
    public static final int FOLLOWING = 6;
    public static final int FOLLOWING_SIBLING = 7;
    public static final int NAMESPACE = 8;
    public static final int PARENT = 9;
    public static final int PRECEDING = 10;
    public static final int PRECEDING_SIBLING = 11;
    public static final int SELF = 12;
    final int axis;
    final Test[] tests;

    public Selector(int n, List list2) {
        this.axis = n;
        this.tests = new Test[list2.size()];
        list2.toArray(this.tests);
        if (n == 8 && this.tests.length > 0 && this.tests[0] instanceof NameTest) {
            NameTest nameTest = (NameTest)this.tests[0];
            this.tests[0] = new NamespaceTest(nameTest.qName, nameTest.anyLocalName, nameTest.any);
        }
    }

    public Test[] getTests() {
        return this.tests;
    }

    public boolean matches(Node node2) {
        int n;
        short s = node2.getNodeType();
        switch (this.axis) {
            case 3: {
                if (s != 2) break;
                return false;
            }
            case 2: 
            case 8: {
                if (s == 2) break;
                return false;
            }
            case 5: {
                return true;
            }
            default: {
                return false;
            }
        }
        if ((n = this.tests.length) > 0) {
            int n2 = this.getContextPosition(node2);
            int n3 = this.getContextSize(node2);
            for (int i = 0; i < n && n3 > 0; ++i) {
                Test test = this.tests[i];
                if (test.matches(node2, n2, n3)) continue;
                return false;
            }
        }
        return true;
    }

    private int getContextPosition(Node node2) {
        int n = 1;
        for (node2 = node2.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            ++n;
        }
        return n;
    }

    private int getContextSize(Node node2) {
        if (node2.getNodeType() == 2) {
            Element element = ((Attr)node2).getOwnerElement();
            return element.getAttributes().getLength();
        }
        Node node3 = node2.getParentNode();
        if (node3 != null) {
            return node3.getChildNodes().getLength();
        }
        return 1;
    }

    public Object evaluate(Node node2, int n, int n2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addCandidates(node2, linkedHashSet);
        ArrayList arrayList = new ArrayList(linkedHashSet);
        List list2 = this.filterCandidates(arrayList, false);
        return list2;
    }

    Collection evaluate(Node node2, Collection collection) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object object = collection.iterator();
        while (object.hasNext()) {
            this.addCandidates((Node)object.next(), linkedHashSet);
        }
        object = new ArrayList(linkedHashSet);
        List list2 = this.filterCandidates((List)object, true);
        return list2;
    }

    List filterCandidates(List list2, boolean bl) {
        int n = list2.size();
        int n2 = this.tests.length;
        if (n2 > 0 && n > 0) {
            for (int i = 0; i < n2 && n > 0; ++i) {
                Test test = this.tests[i];
                ArrayList arrayList = new ArrayList(n);
                for (int j = 0; j < n; ++j) {
                    short s;
                    Node node2 = (Node)list2.get(j);
                    if (bl && ((s = node2.getNodeType()) == 9 || s == 11) && (this.axis == 5 || this.axis == 1 || this.axis == 12) && this.tests.length == 1 && this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                        arrayList.add(node2);
                        continue;
                    }
                    if (!test.matches(node2, j + 1, n)) continue;
                    arrayList.add(node2);
                }
                list2 = arrayList;
                n = list2.size();
            }
        }
        return list2;
    }

    void addCandidates(Node node2, Collection collection) {
        switch (this.axis) {
            case 3: {
                this.addChildNodes(node2, collection, false);
                break;
            }
            case 4: {
                this.addChildNodes(node2, collection, true);
                break;
            }
            case 5: {
                collection.add(node2);
                this.addChildNodes(node2, collection, true);
                break;
            }
            case 9: {
                this.addParentNode(node2, collection, false);
                break;
            }
            case 0: {
                this.addParentNode(node2, collection, true);
                break;
            }
            case 1: {
                collection.add(node2);
                this.addParentNode(node2, collection, true);
                break;
            }
            case 7: {
                this.addFollowingNodes(node2, collection, false);
                break;
            }
            case 11: {
                this.addPrecedingNodes(node2, collection, false);
                break;
            }
            case 6: {
                this.addFollowingNodes(node2, collection, true);
                break;
            }
            case 10: {
                this.addPrecedingNodes(node2, collection, true);
                break;
            }
            case 2: {
                this.addAttributes(node2, collection);
                break;
            }
            case 8: {
                this.addNamespaceAttributes(node2, collection);
                break;
            }
            case 12: {
                collection.add(node2);
            }
        }
    }

    void addChildNodes(Node node2, Collection collection, boolean bl) {
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            collection.add(node3);
            if (!bl) continue;
            this.addChildNodes(node3, collection, bl);
        }
    }

    void addParentNode(Node node2, Collection collection, boolean bl) {
        Node node3;
        Node node4 = node3 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
        if (node3 != null) {
            collection.add(node3);
            if (bl) {
                this.addParentNode(node3, collection, bl);
            }
        }
    }

    void addFollowingNodes(Node node2, Collection collection, boolean bl) {
        for (Node node3 = node2.getNextSibling(); node3 != null; node3 = node3.getNextSibling()) {
            collection.add(node3);
            if (!bl) continue;
            this.addChildNodes(node3, collection, true);
        }
        if (bl) {
            Node node4 = node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
            if (node2 != null) {
                this.addFollowingNodes(node2, collection, bl);
            }
        }
    }

    void addPrecedingNodes(Node node2, Collection collection, boolean bl) {
        for (Node node3 = node2.getPreviousSibling(); node3 != null; node3 = node3.getPreviousSibling()) {
            collection.add(node3);
            if (!bl) continue;
            this.addChildNodes(node3, collection, true);
        }
        if (bl) {
            Node node4 = node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
            if (node2 != null) {
                this.addPrecedingNodes(node2, collection, bl);
            }
        }
    }

    void addAttributes(Node node2, Collection collection) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = namedNodeMap.item(i);
                if (this.isNamespaceAttribute(node3)) continue;
                collection.add(node3);
            }
        }
    }

    void addNamespaceAttributes(Node node2, Collection collection) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = namedNodeMap.item(i);
                if (!this.isNamespaceAttribute(node3)) continue;
                collection.add(node3);
            }
        }
    }

    final boolean isNamespaceAttribute(Node node2) {
        String string = node2.getNamespaceURI();
        return XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string) || XMLConstants.XMLNS_ATTRIBUTE.equals(node2.getPrefix()) || XMLConstants.XMLNS_ATTRIBUTE.equals(node2.getNodeName());
    }

    public Expr clone(Object object) {
        int n = this.tests.length;
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.tests[i].clone(object));
        }
        return new Selector(this.axis, arrayList);
    }

    public boolean references(QName qName) {
        for (int i = 0; i < this.tests.length; ++i) {
            if (!this.tests[i].references(qName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.axis) {
            case 0: {
                stringBuffer.append("ancestor::");
                break;
            }
            case 1: {
                stringBuffer.append("ancestor-or-self::");
                break;
            }
            case 2: {
                if (this.tests.length == 0 || this.tests[0] instanceof NameTest) {
                    stringBuffer.append('@');
                    break;
                }
                stringBuffer.append("attribute::");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                stringBuffer.append("descendant::");
                break;
            }
            case 5: {
                stringBuffer.append("descendant-or-self::");
                break;
            }
            case 6: {
                stringBuffer.append("following::");
                break;
            }
            case 7: {
                stringBuffer.append("following-sibling::");
                break;
            }
            case 8: {
                stringBuffer.append("namespace::");
                break;
            }
            case 9: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return "..";
                }
                stringBuffer.append("parent::");
                break;
            }
            case 10: {
                stringBuffer.append("preceding::");
                break;
            }
            case 11: {
                stringBuffer.append("preceding-sibling::");
                break;
            }
            case 12: {
                if (this.tests.length == 0 || this.tests[0] instanceof NodeTypeTest && ((NodeTypeTest)this.tests[0]).type == 0) {
                    return ".";
                }
                stringBuffer.append("self::");
            }
        }
        if (this.tests.length == 0) {
            stringBuffer.append('*');
        } else {
            for (int i = 0; i < this.tests.length; ++i) {
                stringBuffer.append(this.tests[i]);
            }
        }
        return stringBuffer.toString();
    }
}

