/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.dom.JAXPFactory;
import gnu.xml.xpath.DocumentOrderComparator;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Expr
implements XPathExpression {
    protected static final Comparator documentOrderComparator = new DocumentOrderComparator();
    protected static final DecimalFormat decimalFormat = new DecimalFormat("####################################################.####################################################", new DecimalFormatSymbols(Locale.US));

    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        Object object2;
        block6: {
            block10: {
                block11: {
                    block9: {
                        Node node2;
                        block8: {
                            block7: {
                                object2 = null;
                                node2 = null;
                                if (!(object instanceof Node)) break block6;
                                node2 = (Node)object;
                                object2 = this.evaluate(node2, 1, 1);
                                if (XPathConstants.STRING != qName || object2 instanceof String) break block7;
                                object2 = Expr._string(node2, object2);
                                break block6;
                            }
                            if (XPathConstants.NUMBER != qName || object2 instanceof Double) break block8;
                            object2 = new Double(Expr._number(node2, object2));
                            break block6;
                        }
                        if (XPathConstants.BOOLEAN != qName || object2 instanceof Boolean) break block9;
                        object2 = Expr._boolean(node2, object2) ? Boolean.TRUE : Boolean.FALSE;
                        break block6;
                    }
                    if (XPathConstants.NODE != qName) break block10;
                    if (!(object2 instanceof Collection)) break block11;
                    Collection collection = (Collection)object2;
                    switch (collection.size()) {
                        case 0: {
                            object2 = null;
                            break block6;
                        }
                        case 1: {
                            object2 = (Node)collection.iterator().next();
                            break block6;
                        }
                        default: {
                            throw new XPathExpressionException("multiple nodes in node-set");
                        }
                    }
                }
                if (object2 != null) {
                    throw new XPathExpressionException("return value is not a node-set");
                }
                break block6;
            }
            if (XPathConstants.NODESET == qName && object2 != null && !(object2 instanceof Collection)) {
                throw new XPathExpressionException("return value is not a node-set");
            }
        }
        return object2;
    }

    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        try {
            JAXPFactory jAXPFactory = new JAXPFactory();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)jAXPFactory).newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return this.evaluate(document, qName);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XPathExpressionException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XPathExpressionException(sAXException);
        }
        catch (IOException iOException) {
            throw new XPathExpressionException(iOException);
        }
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    public abstract Object evaluate(Node var1, int var2, int var3);

    public abstract Expr clone(Object var1);

    public abstract boolean references(QName var1);

    public static Collection _id(Node node2, Object object) {
        HashSet hashSet = new HashSet();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = Expr.stringValue((Node)iterator.next());
                hashSet.addAll(Expr._id(node2, string));
            }
        } else {
            Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            String string = Expr._string(node2, object);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                Element element = document.getElementById(stringTokenizer.nextToken());
                if (element == null) continue;
                hashSet.add(element);
            }
        }
        return hashSet;
    }

    public static String _local_name(Node node2, Collection collection) {
        Node node3 = collection == null || collection.size() == 0 ? node2 : Expr.firstNode(collection);
        return node3.getLocalName();
    }

    public static String _namespace_uri(Node node2, Collection collection) {
        Node node3 = collection == null || collection.size() == 0 ? node2 : Expr.firstNode(collection);
        return node3.getNamespaceURI();
    }

    public static String _name(Node node2, Collection collection) {
        Node node3 = collection == null || collection.size() == 0 ? node2 : Expr.firstNode(collection);
        switch (node3.getNodeType()) {
            case 1: 
            case 2: 
            case 7: {
                return node3.getNodeName();
            }
        }
        return "";
    }

    static Node firstNode(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, documentOrderComparator);
        return (Node)arrayList.get(0);
    }

    public static String _string(Node node2, Object object) {
        if (object == null) {
            return Expr.stringValue(node2);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d == 0.0) {
                return "0";
            }
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    return "-Infinity";
                }
                return "Infinity";
            }
            String string = decimalFormat.format(d);
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return "";
            }
            Node node3 = Expr.firstNode(collection);
            return Expr.stringValue(node3);
        }
        throw new IllegalArgumentException(object.toString());
    }

    public static boolean _boolean(Node node2, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Double) {
            return (Double)object != 0.0;
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() != 0;
        }
        return false;
    }

    public static double _number(Node node2, Object object) {
        if (object == null) {
            object = Collections.singleton(node2);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        if (object instanceof Collection) {
            object = Expr.stringValue((Collection)object);
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public static String stringValue(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(Expr.stringValue((Node)iterator.next()));
        }
        return stringBuffer.toString();
    }

    public static String stringValue(Node node2) {
        return Expr.stringValue(node2, false);
    }

    static String stringValue(Node node2, boolean bl) {
        switch (node2.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    stringBuffer.append(Expr.stringValue(node3, true));
                }
                return stringBuffer.toString();
            }
            case 3: 
            case 4: {
                return node2.getNodeValue();
            }
            case 2: 
            case 7: 
            case 8: {
                if (bl) break;
                return node2.getNodeValue();
            }
        }
        return "";
    }
}

