/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.transform.SAXSerializer;
import gnu.xml.transform.StreamSerializer;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerOutputProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class TransformerImpl
extends Transformer {
    final TransformerFactoryImpl factory;
    final Stylesheet stylesheet;
    URIResolver uriResolver;
    ErrorListener errorListener;
    Properties outputProperties;
    static final String INDENT_WHITESPACE = "  ";

    TransformerImpl(TransformerFactoryImpl transformerFactoryImpl, Stylesheet stylesheet, Properties properties) throws TransformerConfigurationException {
        this.factory = transformerFactoryImpl;
        this.uriResolver = transformerFactoryImpl.userResolver;
        this.errorListener = transformerFactoryImpl.userListener;
        this.stylesheet = stylesheet;
        this.outputProperties = properties;
        if (stylesheet != null) {
            stylesheet.bindings.push(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Source var1_1, Result var2_2) throws TransformerException {
        var4_3 = this.factory.resolver;
        synchronized (var4_3) {
            try {
                this.factory.resolver.setUserResolver(this.uriResolver);
                this.factory.resolver.setUserListener(this.errorListener);
                var3_4 = this.factory.resolver.resolveDOM(var1_1, null, null);
            }
            finally {
                var5_5 = null;
            }
            var5_5 = var3_4.getNode();
            v0 = var6_8 = var5_5 instanceof Document != false ? (Document)var5_5 : var5_5.getOwnerDocument();
            if (var6_8 instanceof DomDocument) {
                ((DomDocument)var6_8).setBuilding(true);
            }
            var8_9 = null;
            var7_10 = null;
            if (var2_2 instanceof DOMResult) {
                var9_11 = (DOMResult)var2_2;
                var8_9 = var9_11.getNode();
                var7_10 = var9_11.getNextSibling();
                v1 = var10_13 = var8_9 instanceof Document != false ? (Document)var8_9 : var8_9.getOwnerDocument();
                if (var10_13 instanceof DomDocument) {
                    var11_15 = (DomDocument)var10_13;
                    var11_15.setBuilding(true);
                    var11_15.setCheckWellformedness(false);
                }
            }
            var9_12 = false;
            if (this.stylesheet != null) {
                if (var8_9 == null) {
                    var10_13 = new DomDocument();
                    var10_13.setBuilding(true);
                    var10_13.setCheckWellformedness(false);
                    var8_9 = var10_13;
                    var9_12 = true;
                }
                var5_5 = var5_5.cloneNode(true);
                this.strip(var5_5);
                try {
                    ((TransformerOutputProperties)this.outputProperties).apply();
                    this.stylesheet.initTopLevelVariables(var5_5);
                    var10_13 = this.stylesheet.getTemplate(null, var5_5, false);
                    if (var10_13 == null) ** GOTO lbl73
                    this.stylesheet.current = var5_5;
                    var10_13.apply(this.stylesheet, null, var5_5, 1, 1, var8_9, var7_10);
                }
                catch (TransformerException var10_14) {
                    if (var6_8 instanceof DomDocument) {
                        ((DomDocument)var6_8).setBuilding(false);
                    }
                    throw var10_14;
                }
            } else {
                var10_13 = var5_5.cloneNode(true);
                if (var5_5.getNodeType() != 9) {
                    if (var8_9 == null) {
                        var12_17 = new DomDocument();
                        var12_17.setBuilding(true);
                        var12_17.setCheckWellformedness(false);
                        var11_15 = var12_17;
                        var8_9 = var11_15;
                        var9_12 = true;
                    } else {
                        var11_15 = var8_9 instanceof Document != false ? (Document)var8_9 : var8_9.getOwnerDocument();
                    }
                    var12_17 = var5_5.getOwnerDocument();
                    if (var12_17 != var11_15) {
                        var10_13 = var11_15.adoptNode((Node)var10_13);
                    }
                    if (var7_10 != null) {
                        var8_9.insertBefore((Node)var10_13, var7_10);
                    } else {
                        var8_9.appendChild((Node)var10_13);
                    }
                } else {
                    var8_9 = var10_13;
                    var9_12 = true;
                }
            }
lbl73:
            // 5 sources

            var10_13 = this.outputProperties.getProperty("method");
            var11_16 = "html".equals(var10_13) != false ? 1 : ("text".equals(var10_13) != false ? 2 : 0);
            var12_17 = this.outputProperties.getProperty("encoding");
            var13_18 = this.outputProperties.getProperty("doctype-public");
            var14_19 = this.outputProperties.getProperty("doctype-system");
            var15_20 = this.outputProperties.getProperty("version");
            var16_21 = "yes".equals(this.outputProperties.getProperty("omit-xml-declaration"));
            var17_22 = "yes".equals(this.outputProperties.getProperty("standalone"));
            var18_23 = this.outputProperties.getProperty("media-type");
            var19_24 = this.outputProperties.getProperty("cdata-section-elements");
            var20_25 = "yes".equals(this.outputProperties.getProperty("indent"));
            if (var9_12) {
                var21_26 = (DomDocument)var8_9;
                var22_27 = var21_26.getDocumentElement();
                if ((var13_18 != null || var14_19 != null) && var22_27 != null) {
                    var21_26.appendChild(new DomDoctype((DomDocument)var21_26, var22_27.getNodeName(), var13_18, var14_19));
                }
                var21_26.setBuilding(false);
                var21_26.setCheckWellformedness(true);
            } else if (var13_18 != null || var14_19 != null) {
                switch (var8_9.getNodeType()) {
                    case 9: 
                    case 11: {
                        var21_26 = var8_9 instanceof Document != false ? (Document)var8_9 : var8_9.getOwnerDocument();
                        var22_27 = var21_26.getImplementation();
                        var23_29 = var22_27.createDocumentType(var21_26.getNodeName(), var13_18, var14_19);
                        for (var24_32 = var8_9.getFirstChild(); var24_32 != null && var24_32.getNodeType() != 1; var24_32 = var24_32.getNextSibling()) {
                        }
                        if (var24_32 != null) {
                            var8_9.insertBefore((Node)var23_29, (Node)var24_32);
                            break;
                        }
                        var8_9.appendChild((Node)var23_29);
                    }
                }
            }
            if (var15_20 != null) {
                var8_9.setUserData("version", var15_20, this.stylesheet);
            }
            if (var16_21) {
                var8_9.setUserData("omit-xml-declaration", "yes", this.stylesheet);
            }
            if (var17_22) {
                var8_9.setUserData("standalone", "yes", this.stylesheet);
            }
            if (var18_23 != null) {
                var8_9.setUserData("media-type", var18_23, this.stylesheet);
            }
            if (var19_24 != null) {
                var21_26 = new LinkedList();
                var22_27 = new StringTokenizer(var19_24);
                while (var22_27.hasMoreTokens()) {
                    var24_32 = var23_29 = var22_27.nextToken();
                    var25_34 = null;
                    var26_35 = null;
                    var27_36 = var23_29.indexOf(58);
                    if (var27_36 != -1) {
                        var26_35 = var23_29.substring(0, var27_36);
                        var24_32 = var23_29.substring(var27_36 + 1);
                        var25_34 = this.stylesheet.output.lookupNamespaceURI(var26_35);
                    }
                    var21_26.add(new QName(var25_34, (String)var24_32, var26_35));
                }
                if (!var21_26.isEmpty()) {
                    var23_29 = var8_9 instanceof Document != false ? (Document)var8_9 : var8_9.getOwnerDocument();
                    this.convertCdataSectionElements((Document)var23_29, var8_9, (List)var21_26);
                }
            }
            if (var20_25) {
                var8_9.normalize();
                this.strip(var8_9);
                var21_26 = var8_9 instanceof Document != false ? (Document)var8_9 : var8_9.getOwnerDocument();
                this.reindent((Document)var21_26, var8_9, 0);
            }
            if (var2_2 instanceof DOMResult) {
                if (var9_12) {
                    var21_26 = (DOMResult)var2_2;
                    var21_26.setNode(var8_9);
                    var21_26.setNextSibling(null);
                }
            } else if (var2_2 instanceof StreamResult) {
                var21_26 = (StreamResult)var2_2;
                var22_27 = null;
                try {
                    this.writeStreamResult(var8_9, (StreamResult)var21_26, var11_16, (String)var12_17);
                }
                catch (UnsupportedEncodingException var23_30) {
                    try {
                        this.writeStreamResult(var8_9, (StreamResult)var21_26, var11_16, "UTF-8");
                    }
                    catch (IOException var24_33) {
                        var22_27 = var24_33;
                    }
                }
                catch (IOException var23_31) {
                    var22_27 = var23_31;
                }
                if (var22_27 != null) {
                    if (this.errorListener != null) {
                        this.errorListener.error(new TransformerException((Throwable)var22_27));
                    } else {
                        var22_27.printStackTrace(System.err);
                    }
                }
            } else if (var2_2 instanceof SAXResult) {
                var21_26 = (SAXResult)var2_2;
                try {
                    var22_27 = var21_26.getHandler();
                    var23_29 = var21_26.getLexicalHandler();
                    if (var23_29 == null && var22_27 instanceof LexicalHandler) {
                        var23_29 = (LexicalHandler)var22_27;
                    }
                    var24_32 = new SAXSerializer();
                    var24_32.serialize(var8_9, (ContentHandler)var22_27, (LexicalHandler)var23_29);
                }
                catch (SAXException var22_28) {
                    if (this.errorListener != null) {
                        this.errorListener.error(new TransformerException(var22_28));
                    }
                    var22_28.printStackTrace(System.err);
                }
            }
            return;
        }
    }

    void strip(Node node2) throws TransformerConfigurationException {
        block6: {
            Object object;
            block4: {
                Object object2;
                block5: {
                    short s = node2.getNodeType();
                    if (s == 5) {
                        object = node2.getParentNode();
                        object2 = node2.getFirstChild();
                        if (object2 != null) {
                            this.strip((Node)object2);
                        }
                        while (object2 != null) {
                            Node node3 = object2.getNextSibling();
                            node2.removeChild((Node)object2);
                            object.insertBefore((Node)object2, node2);
                            object2 = node3;
                        }
                        object.removeChild(node2);
                    }
                    if (s != 3 && s != 4) break block4;
                    if (this.stylesheet.isPreserved((Text)node2)) break block5;
                    node2.getParentNode().removeChild(node2);
                    break block6;
                }
                object = node2.getNodeValue();
                if (((String)object).equals(object2 = ((String)object).trim())) break block6;
                node2.setNodeValue((String)object2);
                break block6;
            }
            for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                this.strip((Node)object);
            }
        }
    }

    void writeStreamResult(Node node2, StreamResult streamResult, int n, String string) throws IOException {
        Object object4;
        Object object2;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            Object object3;
            outputStream = streamResult.getOutputStream();
            if (outputStream == null && (object2 = streamResult.getWriter()) != null) {
                outputStream = new WriterOutputStream((Writer)object2);
            }
            if (outputStream == null) {
                object2 = streamResult.getSystemId();
                try {
                    object3 = new URL((String)object2);
                    object4 = ((URL)object3).openConnection();
                    ((URLConnection)object4).setDoInput(false);
                    ((URLConnection)object4).setDoOutput(true);
                    outputStream = ((URLConnection)object4).getOutputStream();
                }
                catch (MalformedURLException malformedURLException) {
                    outputStream = new FileOutputStream((String)object2);
                }
                catch (UnknownServiceException unknownServiceException) {
                    object4 = new URL((String)object2);
                    outputStream = new FileOutputStream(((URL)object4).getPath());
                }
                bl = true;
            }
            outputStream = new BufferedOutputStream(outputStream);
            object2 = new StreamSerializer(n, string, null);
            if (this.stylesheet != null) {
                object3 = this.stylesheet.outputCdataSectionElements;
                ((StreamSerializer)object2).setCdataSectionElements((Collection)object3);
            }
            ((StreamSerializer)object2).serialize(node2, outputStream);
            outputStream.flush();
        }
        finally {
            object2 = null;
            try {
                if (outputStream != null && bl) {
                    outputStream.close();
                }
            }
            catch (IOException object4) {}
        }
    }

    void copyChildren(Document document, Node node2, Node node3) {
        for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            Node node5 = document.adoptNode(node4);
            node3.appendChild(node5);
        }
    }

    public void setParameter(String string, Object object) {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.set(new QName(null, string), object, 1);
        }
    }

    public Object getParameter(String string) {
        if (this.stylesheet != null) {
            return this.stylesheet.bindings.get(new QName(null, string), null, 1, 1);
        }
        return null;
    }

    public void clearParameters() {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.pop(1);
            this.stylesheet.bindings.push(1);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this.outputProperties.clear();
        } else {
            this.outputProperties.putAll(properties);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.outputProperties.clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        return this.outputProperties.getProperty(string);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    void reindent(Document document, Node node2, int n) {
        if (node2.hasChildNodes()) {
            Node node3;
            boolean bl = false;
            boolean bl2 = false;
            LinkedList linkedList = new LinkedList();
            for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                switch (node3.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 10: {
                        bl = true;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        bl2 = true;
                    }
                }
                linkedList.add(node3);
            }
            if (bl) {
                short s;
                if (bl2) {
                    // empty if block
                }
                if ((s = node2.getNodeType()) == 9) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        node3 = (Node)iterator.next();
                        this.reindent(document, node3, n + 1);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('\n');
                    for (int i = 0; i < n + 1; ++i) {
                        stringBuffer.append(INDENT_WHITESPACE);
                    }
                    String string = stringBuffer.toString();
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        node3 = (Node)iterator.next();
                        node2.insertBefore(document.createTextNode(string), node3);
                        this.reindent(document, node3, n + 1);
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('\n');
                    string = stringBuffer.toString();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(INDENT_WHITESPACE);
                    }
                    node2.appendChild(document.createTextNode(string));
                }
            }
        }
    }

    void convertCdataSectionElements(Document document, Node node2, List list2) {
        if (node2.getNodeType() == 1) {
            Object object;
            boolean bl = false;
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (QName)object2.next();
                if (!this.match((QName)object, node2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (object2 = node2.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 3) continue;
                    object = document.createCDATASection(object2.getNodeValue());
                    node2.replaceChild((Node)object, (Node)object2);
                    object2 = object;
                }
            }
        }
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (!node3.hasChildNodes()) continue;
            this.convertCdataSectionElements(document, node3, list2);
        }
    }

    boolean match(QName qName, Node node2) {
        String string;
        String string2 = qName.getLocalPart();
        String string3 = node2.getLocalName();
        if (string3 == null) {
            return string2.equals(node2.getNodeName());
        }
        String string4 = qName.getNamespaceURI();
        return string4.equals(string = node2.getNamespaceURI()) && string2.equals(string3);
    }
}

