/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplatesImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.TransformerOutputProperties;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.XPathFactoryImpl;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformerFactoryImpl
extends TransformerFactory {
    final XPathFactory xpathFactory = new XPathFactoryImpl();
    final XSLURIResolver resolver = new XSLURIResolver();
    ErrorListener userListener;
    URIResolver userResolver;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TransformerImpl transformerImpl;
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        TransformerOutputProperties transformerOutputProperties = new TransformerOutputProperties(stylesheet);
        stylesheet.transformer = transformerImpl = new TransformerImpl(this, stylesheet, transformerOutputProperties);
        return transformerImpl;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(this, null, new Properties());
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        return new TemplatesImpl(this, stylesheet);
    }

    Stylesheet newStylesheet(Source source, int n, Stylesheet stylesheet) throws TransformerConfigurationException {
        Object object;
        Document document = null;
        String string = null;
        if (source != null) {
            try {
                XSLURIResolver xSLURIResolver = this.resolver;
                synchronized (xSLURIResolver) {
                    DOMSource dOMSource;
                    try {
                        this.resolver.setUserResolver(this.userResolver);
                        this.resolver.setUserListener(this.userListener);
                        dOMSource = this.resolver.resolveDOM(source, null, null);
                    }
                    finally {
                        object = null;
                    }
                    object = dOMSource.getNode();
                    if (object == null) {
                        throw new TransformerConfigurationException("no source document");
                    }
                    document = object instanceof Document ? (Document)object : object.getOwnerDocument();
                    string = dOMSource.getSystemId();
                }
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        {
            object = new Stylesheet(this, stylesheet, document, string, n);
            return object;
        }
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        try {
            XSLURIResolver xSLURIResolver = this.resolver;
            synchronized (xSLURIResolver) {
                Object object;
                Object object2;
                Object object3;
                Node node2;
                DOMSource dOMSource;
                try {
                    this.resolver.setUserResolver(this.userResolver);
                    this.resolver.setUserListener(this.userListener);
                    dOMSource = this.resolver.resolveDOM(source, null, null);
                }
                finally {
                    node2 = null;
                }
                node2 = dOMSource.getNode();
                if (node2 == null) {
                    throw new TransformerConfigurationException("no source document");
                }
                Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                LinkedList linkedList = new LinkedList();
                for (node2 = document.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 7 || !"xml-stylesheet".equals(node2.getNodeName())) continue;
                    object3 = this.parseParameters(node2.getNodeValue());
                    if (string != null && !string.equals(object3.get("media")) || string2 != null && !string2.equals(object3.get("title")) || string3 != null && !string3.equals(object3.get("charset"))) continue;
                    object2 = (String)object3.get("href");
                    object = this.resolver.resolveURL(null, node2.getBaseURI(), (String)object2);
                    linkedList.add(object);
                }
                switch (linkedList.size()) {
                    case 0: {
                        object3 = null;
                        return object3;
                    }
                    case 1: {
                        object3 = new StreamSource(((URL)linkedList.getFirst()).toString());
                        return object3;
                    }
                }
                object2 = new DomDocument();
                ((DomDocument)object2).setBuilding(true);
                object = ((DomDocument)object2).createElementNS("http://www.w3.org/1999/XSL/Transform", "stylesheet");
                Attr attr = ((DomDocument)object2).createAttributeNS(null, "version");
                attr.setNodeValue("1.0");
                object.getAttributes().setNamedItemNS(attr);
                ((DomDocument)object2).appendChild((Node)object);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    URL uRL = (URL)iterator.next();
                    Element element = ((DomDocument)object2).createElementNS("http://www.w3.org/1999/XSL/Transform", "import");
                    Attr attr2 = ((DomDocument)object2).createAttributeNS(null, "href");
                    attr2.setNodeValue(uRL.toString());
                    element.getAttributes().setNamedItemNS(attr2);
                    object.appendChild(element);
                }
                ((DomDocument)object2).setBuilding(false);
                object3 = new DOMSource((Node)object2);
                return object3;
            }
        }
        catch (IOException iOException) {
            throw new TransformerConfigurationException(iOException);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }

    Map parseParameters(String string) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        int n = string.length();
        String string2 = null;
        int n2 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == '\u0000' && c2 == ' ') {
                if (string2 == null && n2 < i) {
                    string2 = string.substring(n2, i);
                } else {
                    String string3 = this.unquote(string.substring(n2, i).trim());
                    linkedHashMap.put(string2, string3);
                    string2 = null;
                }
                n2 = i + 1;
                continue;
            }
            if (c2 == '\"') {
                c = c == c2 ? (char)'\u0000' : c2;
                continue;
            }
            if (c2 != '\'') continue;
            c = c == c2 ? (char)'\u0000' : c2;
        }
        if (n2 < n && string2 != null) {
            String string4 = this.unquote(string.substring(n2, n).trim());
            linkedHashMap.put(string2, string4);
        }
        return linkedHashMap;
    }

    String unquote(String string) {
        int n = string.length() - 1;
        if (string.charAt(0) == '\'' && string.charAt(n) == '\'') {
            return string.substring(1, n);
        }
        if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            return string.substring(1, n);
        }
        return string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userResolver;
    }

    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        throw new TransformerConfigurationException("not supported");
    }

    public boolean getFeature(String string) {
        return SAXSource.FEATURE.equals(string) || SAXResult.FEATURE.equals(string) || StreamSource.FEATURE.equals(string) || StreamResult.FEATURE.equals(string) || DOMSource.FEATURE.equals(string) || DOMResult.FEATURE.equals(string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.userListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.userListener;
    }
}

