/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AbstractNumberNode;
import gnu.xml.transform.ApplyImportsNode;
import gnu.xml.transform.ApplyTemplatesNode;
import gnu.xml.transform.AttributeNode;
import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Bindings;
import gnu.xml.transform.CallTemplateNode;
import gnu.xml.transform.ChooseNode;
import gnu.xml.transform.CommentNode;
import gnu.xml.transform.CopyNode;
import gnu.xml.transform.CopyOfNode;
import gnu.xml.transform.CurrentFunction;
import gnu.xml.transform.DOMSourceLocator;
import gnu.xml.transform.DocumentFunction;
import gnu.xml.transform.ElementAvailableFunction;
import gnu.xml.transform.ElementNode;
import gnu.xml.transform.ForEachNode;
import gnu.xml.transform.FormatNumberFunction;
import gnu.xml.transform.FunctionAvailableFunction;
import gnu.xml.transform.GenerateIdFunction;
import gnu.xml.transform.IfNode;
import gnu.xml.transform.Key;
import gnu.xml.transform.KeyFunction;
import gnu.xml.transform.LiteralNode;
import gnu.xml.transform.MessageNode;
import gnu.xml.transform.NodeNumberNode;
import gnu.xml.transform.NumberNode;
import gnu.xml.transform.OtherwiseNode;
import gnu.xml.transform.ParameterNode;
import gnu.xml.transform.ProcessingInstructionNode;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.SystemPropertyFunction;
import gnu.xml.transform.Template;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.TextNode;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.UnparsedEntityUriFunction;
import gnu.xml.transform.ValueOfNode;
import gnu.xml.transform.WhenNode;
import gnu.xml.transform.WithParam;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.XPathImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class Stylesheet
implements NamespaceContext,
XPathFunctionResolver,
UserDataHandler,
Cloneable {
    static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    static final int OUTPUT_XML = 0;
    static final int OUTPUT_HTML = 1;
    static final int OUTPUT_TEXT = 2;
    final TransformerFactoryImpl factory;
    TransformerImpl transformer;
    Stylesheet parent;
    final XPathImpl xpath;
    final String systemId;
    final int precedence;
    final boolean debug;
    String version;
    Collection extensionElementPrefixes;
    Collection excludeResultPrefixes;
    Set stripSpace;
    Set preserveSpace;
    Node output;
    int outputMethod;
    String outputVersion;
    String outputEncoding;
    boolean outputOmitXmlDeclaration;
    boolean outputStandalone;
    String outputPublicId;
    String outputSystemId;
    Collection outputCdataSectionElements;
    boolean outputIndent;
    String outputMediaType;
    Collection keys;
    Map decimalFormats;
    Map namespaceAliases;
    List attributeSets;
    List variables;
    Bindings bindings;
    LinkedList templates;
    TemplateNode builtInNodeTemplate;
    TemplateNode builtInTextTemplate;
    Node current;
    transient boolean terminated;
    transient Template currentTemplate;

    Stylesheet(TransformerFactoryImpl transformerFactoryImpl, Stylesheet stylesheet, Document document, String string, int n) throws TransformerConfigurationException {
        Object object;
        this.factory = transformerFactoryImpl;
        this.systemId = string;
        this.precedence = n;
        this.parent = stylesheet;
        this.extensionElementPrefixes = new HashSet();
        this.excludeResultPrefixes = new HashSet();
        this.stripSpace = new LinkedHashSet();
        this.preserveSpace = new LinkedHashSet();
        this.outputCdataSectionElements = new LinkedHashSet();
        this.xpath = (XPathImpl)transformerFactoryImpl.xpathFactory.newXPath();
        if (stylesheet == null) {
            this.bindings = new Bindings(this);
            this.attributeSets = new LinkedList();
            this.variables = new LinkedList();
            this.namespaceAliases = new LinkedHashMap();
            this.templates = new LinkedList();
            this.keys = new LinkedList();
            this.decimalFormats = new LinkedHashMap();
            this.initDefaultDecimalFormat();
            this.xpath.setNamespaceContext(this);
            this.xpath.setXPathFunctionResolver(this);
        } else {
            object = this;
            while (((Stylesheet)object).parent != null) {
                if (string != null && string.equals(((Stylesheet)object).parent.systemId)) {
                    String string2 = "circularity importing " + string;
                    throw new TransformerConfigurationException(string2);
                }
                object = ((Stylesheet)object).parent;
            }
            object = this.getRootStylesheet();
            this.bindings = ((Stylesheet)object).bindings;
            this.attributeSets = ((Stylesheet)object).attributeSets;
            this.variables = ((Stylesheet)object).variables;
            this.namespaceAliases = ((Stylesheet)object).namespaceAliases;
            this.templates = ((Stylesheet)object).templates;
            this.keys = ((Stylesheet)object).keys;
            this.decimalFormats = ((Stylesheet)object).decimalFormats;
            this.xpath.setNamespaceContext((NamespaceContext)object);
            this.xpath.setXPathFunctionResolver((XPathFunctionResolver)object);
        }
        this.xpath.setXPathVariableResolver(this.bindings);
        object = new NodeTypeTest(0);
        List list2 = Collections.singletonList(object);
        this.builtInNodeTemplate = new ApplyTemplatesNode(new Selector(3, list2), null, null, null, true);
        this.builtInTextTemplate = new ValueOfNode(new Selector(12, list2), false);
        this.parse(document.getDocumentElement(), true);
        this.current = document;
        this.debug = "yes".equals(System.getProperty("xsl.debug"));
        if (this.debug) {
            System.err.println("Stylesheet: " + document.getDocumentURI());
            Iterator iterator = this.templates.iterator();
            while (iterator.hasNext()) {
                Template template = (Template)iterator.next();
                template.list(System.err);
                System.err.println("--------------------");
            }
        }
    }

    Stylesheet getRootStylesheet() {
        Stylesheet stylesheet = this;
        while (stylesheet.parent != null) {
            stylesheet = stylesheet.parent;
        }
        return stylesheet;
    }

    void initDefaultDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormats.put(null, decimalFormat);
    }

    public Object clone() {
        try {
            Object object;
            Object object2;
            Object object3;
            Stylesheet stylesheet = (Stylesheet)super.clone();
            stylesheet.bindings = (Bindings)this.bindings.clone();
            LinkedList linkedList = new LinkedList();
            Object object4 = this.templates.iterator();
            while (object4.hasNext()) {
                object3 = (Template)object4.next();
                linkedList.add(((Template)object3).clone(stylesheet));
            }
            stylesheet.templates = linkedList;
            object4 = new LinkedList();
            object3 = this.attributeSets.iterator();
            while (object3.hasNext()) {
                object2 = (AttributeSet)object3.next();
                ((LinkedList)object4).add(((AttributeSet)object2).clone(stylesheet));
            }
            stylesheet.attributeSets = object4;
            object3 = new LinkedList();
            object2 = this.variables.iterator();
            while (object2.hasNext()) {
                object = (ParameterNode)object2.next();
                ((LinkedList)object3).add(((ParameterNode)object).clone(stylesheet));
            }
            stylesheet.variables = object3;
            object2 = new LinkedList();
            object = this.keys.iterator();
            while (object.hasNext()) {
                Key key = (Key)object.next();
                ((LinkedList)object2).add(key.clone(stylesheet));
            }
            stylesheet.keys = object2;
            return stylesheet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.getMessage());
        }
    }

    void initTopLevelVariables(Node node2) throws TransformerException {
        this.current = node2;
        ArrayList arrayList = new ArrayList(this.variables);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ParameterNode parameterNode = (ParameterNode)iterator.next();
            this.bindings.set(parameterNode.name, parameterNode.getValue(this, null, node2, 1, 1), parameterNode.type);
        }
        this.current = null;
    }

    public String getNamespaceURI(String string) {
        if (this.current == null) {
            return null;
        }
        return this.current.lookupNamespaceURI(string);
    }

    public String getPrefix(String string) {
        if (this.current == null) {
            return null;
        }
        return this.current.lookupPrefix(string);
    }

    public Iterator getPrefixes(String string) {
        return Collections.singleton(this.getPrefix(string)).iterator();
    }

    final QName getQName(String string) {
        String string2 = string;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string4 = string.substring(0, n);
            string2 = string.substring(n + 1);
            string3 = this.getNamespaceURI(string4);
        }
        return new QName(string3, string2, string4);
    }

    TemplateNode getTemplate(QName qName, Node node2, boolean bl) throws TransformerException {
        if (this.debug) {
            System.err.println("getTemplate: mode=" + qName + " context=" + node2);
        }
        TreeSet treeSet = new TreeSet();
        Object object = this.templates.iterator();
        while (object.hasNext()) {
            Template template = (Template)object.next();
            boolean bl2 = template.matches(qName, node2);
            if (bl) {
                if (this.currentTemplate == null) {
                    String string = "current template may not be null during apply-imports";
                    throw new TransformerException(string);
                }
                if (!this.currentTemplate.imports(template)) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            treeSet.add(template);
        }
        if (treeSet.isEmpty()) {
            if (this.debug) {
                System.err.println("\tbuiltInTemplate context=" + node2);
            }
            switch (node2.getNodeType()) {
                case 1: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    return this.builtInNodeTemplate;
                }
                case 2: 
                case 3: {
                    return this.builtInTextTemplate;
                }
            }
            return null;
        }
        this.currentTemplate = object = (Template)treeSet.iterator().next();
        if (this.debug) {
            System.err.println("\ttemplate=" + object + " context=" + node2);
        }
        return ((Template)object).node;
    }

    TemplateNode getTemplate(QName qName, QName qName2) throws TransformerException {
        TreeSet treeSet = new TreeSet();
        Object object = this.templates.iterator();
        while (object.hasNext()) {
            Template template = (Template)object.next();
            boolean bl = template.matches(qName2);
            if (!bl) continue;
            treeSet.add(template);
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        object = (Template)treeSet.iterator().next();
        return ((Template)object).node;
    }

    final Template parseTemplate(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        String string = Stylesheet.getAttribute(namedNodeMap, "name");
        QName qName = string == null ? null : this.getQName(string);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "match");
        Pattern pattern2 = null;
        if (string2 != null) {
            try {
                pattern2 = (Pattern)this.xpath.compile(string2);
            }
            catch (ClassCastException classCastException) {
                String string3 = "illegal pattern: " + string2;
                throw new TransformerConfigurationException(string3);
            }
        }
        String string4 = Stylesheet.getAttribute(namedNodeMap, "priority");
        String string5 = Stylesheet.getAttribute(namedNodeMap, "mode");
        QName qName2 = string5 == null ? null : this.getQName(string5);
        double d = string4 == null ? 0.5 : Double.parseDouble(string4);
        Node node3 = node2.getFirstChild();
        return new Template(this, qName, pattern2, this.parse(node3), this.precedence, d, qName2);
    }

    final void parseOutput(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string;
        this.output = node2;
        String string2 = Stylesheet.getAttribute(namedNodeMap, "method");
        if ("xml".equals(string2) || string2 == null) {
            this.outputMethod = 0;
        } else if ("html".equals(string2)) {
            this.outputMethod = 1;
        } else if ("text".equals(string2)) {
            this.outputMethod = 2;
        } else {
            String string3 = "unsupported output method: " + string2;
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(string3, dOMSourceLocator);
        }
        this.outputPublicId = Stylesheet.getAttribute(namedNodeMap, "public-id");
        this.outputSystemId = Stylesheet.getAttribute(namedNodeMap, "system-id");
        this.outputEncoding = Stylesheet.getAttribute(namedNodeMap, "encoding");
        String string4 = Stylesheet.getAttribute(namedNodeMap, "indent");
        if (string4 != null) {
            this.outputIndent = "yes".equals(string4);
        }
        this.outputVersion = Stylesheet.getAttribute(namedNodeMap, "version");
        String string5 = Stylesheet.getAttribute(namedNodeMap, "omit-xml-declaration");
        if (string5 != null) {
            this.outputOmitXmlDeclaration = "yes".equals(string5);
        }
        if ((string = Stylesheet.getAttribute(namedNodeMap, "standalone")) != null) {
            this.outputStandalone = "yes".equals(string);
        }
        this.outputMediaType = Stylesheet.getAttribute(namedNodeMap, "media-type");
        String string6 = Stylesheet.getAttribute(namedNodeMap, "cdata-section-elements");
        if (string6 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.outputCdataSectionElements.add(stringTokenizer.nextToken());
            }
        }
    }

    final void parseKey(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getRequiredAttribute(namedNodeMap, "match", node2);
        String string3 = Stylesheet.getRequiredAttribute(namedNodeMap, "use", node2);
        QName qName = this.getQName(string);
        Expr expr = (Expr)this.xpath.compile(string3);
        try {
            Pattern pattern2 = (Pattern)this.xpath.compile(string2);
            Key key = new Key(qName, pattern2, expr);
            this.keys.add(key);
        }
        catch (ClassCastException classCastException) {
            throw new TransformerConfigurationException("invalid pattern: " + string2);
        }
    }

    final void parseDecimalFormat(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string = Stylesheet.getAttribute(namedNodeMap, "name");
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(this.parseDFChar(namedNodeMap, "decimal-separator", '.'));
        decimalFormatSymbols.setGroupingSeparator(this.parseDFChar(namedNodeMap, "grouping-separator", ','));
        decimalFormatSymbols.setInfinity(this.parseDFString(namedNodeMap, "infinity", "Infinity"));
        decimalFormatSymbols.setMinusSign(this.parseDFChar(namedNodeMap, "minus-sign", '-'));
        decimalFormatSymbols.setNaN(this.parseDFString(namedNodeMap, "NaN", "NaN"));
        decimalFormatSymbols.setPercent(this.parseDFChar(namedNodeMap, "percent", '%'));
        decimalFormatSymbols.setPerMill(this.parseDFChar(namedNodeMap, "per-mille", '\u2030'));
        decimalFormatSymbols.setZeroDigit(this.parseDFChar(namedNodeMap, "zero-digit", '0'));
        decimalFormatSymbols.setDigit(this.parseDFChar(namedNodeMap, "digit", '#'));
        decimalFormatSymbols.setPatternSeparator(this.parseDFChar(namedNodeMap, "pattern-separator", ';'));
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormats.put(string, decimalFormat);
    }

    private final char parseDFChar(NamedNodeMap namedNodeMap, String string, char c) throws TransformerConfigurationException {
        Node node2 = namedNodeMap.getNamedItem(string);
        try {
            return node2 == null ? c : node2.getNodeValue().charAt(0);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new TransformerConfigurationException("empty attribute '" + string + "' in decimal-format", stringIndexOutOfBoundsException);
        }
    }

    private final String parseDFString(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return string2;
        }
        return node2.getNodeValue();
    }

    final void parseNamespaceAlias(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "stylesheet-prefix", node2);
        String string2 = Stylesheet.getRequiredAttribute(namedNodeMap, "result-prefix", node2);
        this.namespaceAliases.put(string, string2);
    }

    final void parseAttributeSet(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        TemplateNode templateNode = this.parse(node2.getFirstChild());
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        this.attributeSets.add(new AttributeSet(templateNode, string, string2));
    }

    void parse(Node node2, boolean bl) throws TransformerConfigurationException {
        while (node2 != null) {
            this.current = node2;
            this.doParse(node2, bl);
            node2 = node2.getNextSibling();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doParse(Node node2, boolean bl) throws TransformerConfigurationException {
        try {
            String string = node2.getNamespaceURI();
            if (XSL_NS.equals(string) && node2.getNodeType() == 1) {
                String string2 = node2.getLocalName();
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if ("stylesheet".equals(string2)) {
                    Object object;
                    this.version = Stylesheet.getAttribute(namedNodeMap, "version");
                    String string3 = Stylesheet.getAttribute(namedNodeMap, "extension-element-prefixes");
                    if (string3 != null) {
                        object = new StringTokenizer(string3);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            this.extensionElementPrefixes.add(((StringTokenizer)object).nextToken());
                        }
                    }
                    if ((object = Stylesheet.getAttribute(namedNodeMap, "exclude-result-prefixes")) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                        while (stringTokenizer.hasMoreTokens()) {
                            this.excludeResultPrefixes.add(stringTokenizer.nextToken());
                        }
                    }
                    this.parse(node2.getFirstChild(), false);
                    return;
                }
                if ("template".equals(string2)) {
                    this.templates.add(this.parseTemplate(node2, namedNodeMap));
                    return;
                }
                if ("param".equals(string2) || "variable".equals(string2)) {
                    ParameterNode parameterNode;
                    int n = "variable".equals(string2) ? 0 : 1;
                    TemplateNode templateNode = this.parse(node2.getFirstChild());
                    QName qName = this.getQName(Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2));
                    String string4 = Stylesheet.getAttribute(namedNodeMap, "select");
                    if (string4 != null && string4.length() > 0) {
                        if (templateNode != null) {
                            String string5 = "parameter '" + qName + "' has both select and content";
                            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                            throw new TransformerConfigurationException(string5, dOMSourceLocator);
                        }
                        Expr expr = (Expr)this.xpath.compile(string4);
                        parameterNode = new ParameterNode(qName, expr, n);
                    } else {
                        parameterNode = new ParameterNode(qName, null, n);
                        parameterNode.children = templateNode;
                    }
                    this.variables.add(parameterNode);
                    return;
                }
                if ("include".equals(string2) || "import".equals(string2)) {
                    int n = "import".equals(string2) ? -1 : 0;
                    String string6 = Stylesheet.getRequiredAttribute(namedNodeMap, "href", node2);
                    XSLURIResolver xSLURIResolver = this.factory.resolver;
                    synchronized (xSLURIResolver) {
                        Source source;
                        try {
                            if (this.transformer != null) {
                                this.factory.resolver.setUserResolver(this.transformer.getURIResolver());
                                this.factory.resolver.setUserListener(this.transformer.getErrorListener());
                            }
                            source = this.factory.resolver.resolve(this.systemId, string6);
                        }
                        finally {
                            Object var10_31 = null;
                        }
                        this.factory.newStylesheet(source, this.precedence + n, this);
                        return;
                    }
                }
                if ("output".equals(string2)) {
                    this.parseOutput(node2, namedNodeMap);
                    return;
                } else if ("preserve-space".equals(string2)) {
                    String string7 = Stylesheet.getRequiredAttribute(namedNodeMap, "elements", node2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, " \t\n\r");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.preserveSpace.add(this.parseNameTest(stringTokenizer.nextToken()));
                    }
                    return;
                } else if ("strip-space".equals(string2)) {
                    String string8 = Stylesheet.getRequiredAttribute(namedNodeMap, "elements", node2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, " \t\n\r");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.stripSpace.add(this.parseNameTest(stringTokenizer.nextToken()));
                    }
                    return;
                } else if ("key".equals(string2)) {
                    this.parseKey(node2, namedNodeMap);
                    return;
                } else if ("decimal-format".equals(string2)) {
                    this.parseDecimalFormat(node2, namedNodeMap);
                    return;
                } else if ("namespace-alias".equals(string2)) {
                    this.parseNamespaceAlias(node2, namedNodeMap);
                    return;
                } else {
                    if (!"attribute-set".equals(string2)) return;
                    this.parseAttributeSet(node2, namedNodeMap);
                }
                return;
            }
            if (!bl) return;
            Attr attr = ((Element)node2).getAttributeNodeNS(XSL_NS, "version");
            if (attr == null) {
                String string9 = "no xsl:version attribute on literal result node";
                DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                throw new TransformerConfigurationException(string9, dOMSourceLocator);
            }
            this.version = attr.getValue();
            Node node3 = node2.cloneNode(true);
            NamedNodeMap namedNodeMap = node3.getAttributes();
            namedNodeMap.removeNamedItemNS(XSL_NS, "version");
            this.templates.add(new Template(this, null, new Root(), this.parse(node3), this.precedence, 0.5, null));
            return;
        }
        catch (TransformerException transformerException) {
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(transformerException.getMessage(), dOMSourceLocator, transformerException);
        }
        catch (DOMException dOMException) {
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(dOMException.getMessage(), dOMSourceLocator, dOMException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(xPathExpressionException.getMessage(), dOMSourceLocator, xPathExpressionException);
        }
    }

    final NameTest parseNameTest(String string) {
        if ("*".equals(string)) {
            return new NameTest(null, true, true);
        }
        if (string.endsWith(":*")) {
            QName qName = this.getQName(string.substring(0, string.length() - 2));
            return new NameTest(qName, true, false);
        }
        QName qName = this.getQName(string);
        return new NameTest(qName, false, false);
    }

    final TemplateNode parseAttributeValueTemplate(String string, Node node2) throws TransformerConfigurationException, XPathExpressionException {
        this.current = node2;
        int n = string.length();
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                if (i < n - 1 && string.charAt(i + 1) == '{') {
                    arrayList.add(string.substring(n2, i + 1));
                    arrayList2.add(Boolean.FALSE);
                    n2 = ++i + 1;
                    continue;
                }
                if (n3 == 0) {
                    if (i - n2 > 0) {
                        arrayList.add(string.substring(n2, i));
                        arrayList2.add(Boolean.FALSE);
                    }
                    n2 = i + 1;
                }
                ++n3;
                continue;
            }
            if (c != '}') continue;
            if (i < n - 1 && string.charAt(i + 1) == '}') {
                arrayList.add(string.substring(n2, i + 1));
                arrayList2.add(Boolean.FALSE);
                n2 = ++i + 1;
                continue;
            }
            if (n3 == 1) {
                if (i - n2 <= 0) {
                    String string2 = "attribute value template must contain expression: " + string;
                    DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                    throw new TransformerConfigurationException(string2, dOMSourceLocator);
                }
                arrayList.add(string.substring(n2, i));
                arrayList2.add(Boolean.TRUE);
                n2 = i + 1;
            }
            --n3;
        }
        if (n3 > 0) {
            String string3 = "invalid attribute value template: " + string;
            throw new TransformerConfigurationException(string3);
        }
        if (n - n2 > 0) {
            arrayList.add(string.substring(n2));
            arrayList2.add(Boolean.FALSE);
        }
        Object object = null;
        Document document = node2.getOwnerDocument();
        n = arrayList.size();
        for (int i = n - 1; i >= 0; --i) {
            Object object2;
            String string4 = (String)arrayList.get(i);
            Boolean bl = (Boolean)arrayList2.get(i);
            if (bl == Boolean.TRUE) {
                object2 = (Expr)this.xpath.compile(string4);
                ValueOfNode valueOfNode = new ValueOfNode((Expr)object2, false);
                valueOfNode.next = object;
                object = valueOfNode;
                continue;
            }
            object2 = new LiteralNode(document.createTextNode(string4));
            ((TemplateNode)object2).next = object;
            object = object2;
        }
        return object;
    }

    boolean isPreserved(Text text) throws TransformerConfigurationException {
        String string = text.getData();
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                return true;
            }
        }
        Node node2 = text.getParentNode();
        if (!this.preserveSpace.isEmpty()) {
            Iterator iterator = this.preserveSpace.iterator();
            while (iterator.hasNext()) {
                NameTest nameTest = (NameTest)iterator.next();
                if (!nameTest.matches(node2, 1, 1)) continue;
                boolean bl = false;
                if (!this.stripSpace.isEmpty()) {
                    Iterator iterator2 = this.stripSpace.iterator();
                    while (iterator2.hasNext()) {
                        NameTest nameTest2 = (NameTest)iterator2.next();
                        if (!nameTest2.matches(node2, 1, 1)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                return true;
            }
        }
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Element element = (Element)node2;
                String string2 = element.getAttribute("xml:space");
                if ("default".equals(string2)) break;
                if ("preserve".equals(string2)) {
                    return true;
                }
                if (string2.length() > 0) {
                    String string3 = "Illegal value for xml:space: " + string2;
                    throw new TransformerConfigurationException(string3);
                }
                if ("text".equals(node2.getLocalName()) && XSL_NS.equals(node2.getNamespaceURI())) {
                    return true;
                }
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        String string = qName.getNamespaceURI();
        if (XSL_NS.equals(string) || string == null || string.length() == 0) {
            String string2 = qName.getLocalPart();
            if ("document".equals(string2) && (n == 1 || n == 2)) {
                if (this.current == null) {
                    throw new RuntimeException("current is null");
                }
                return new DocumentFunction(this.getRootStylesheet(), this.current);
            }
            if ("key".equals(string2) && n == 2) {
                return new KeyFunction(this.getRootStylesheet());
            }
            if ("format-number".equals(string2) && (n == 2 || n == 3)) {
                return new FormatNumberFunction(this.getRootStylesheet());
            }
            if ("current".equals(string2) && n == 0) {
                return new CurrentFunction(this.getRootStylesheet());
            }
            if ("unparsed-entity-uri".equals(string2) && n == 1) {
                return new UnparsedEntityUriFunction();
            }
            if ("generate-id".equals(string2) && (n == 1 || n == 0)) {
                return new GenerateIdFunction();
            }
            if ("system-property".equals(string2) && n == 1) {
                return new SystemPropertyFunction();
            }
            if ("element-available".equals(string2) && n == 1) {
                return new ElementAvailableFunction(this);
            }
            if ("function-available".equals(string2) && n == 1) {
                return new FunctionAvailableFunction(this);
            }
        }
        return null;
    }

    final TemplateNode parseApplyTemplates(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "mode");
        QName qName = string == null ? null : this.getQName(string);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
        if (string2 == null) {
            string2 = "child::node()";
        }
        Node node3 = node2.getFirstChild();
        List list2 = this.parseSortKeys(node3);
        List list3 = this.parseWithParams(node3);
        Expr expr = (Expr)this.xpath.compile(string2);
        return new ApplyTemplatesNode(expr, qName, list2, list3, false);
    }

    final TemplateNode parseCallTemplate(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        QName qName = this.getQName(string);
        Node node3 = node2.getFirstChild();
        List list2 = this.parseWithParams(node3);
        return new CallTemplateNode(qName, list2);
    }

    final TemplateNode parseValueOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "disable-output-escaping");
        boolean bl = "yes".equals(string2);
        Expr expr = (Expr)this.xpath.compile(string);
        return new ValueOfNode(expr, bl);
    }

    final TemplateNode parseForEach(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        Node node3 = node2.getFirstChild();
        List list2 = this.parseSortKeys(node3);
        Expr expr = (Expr)this.xpath.compile(string);
        ForEachNode forEachNode = new ForEachNode(expr, list2);
        forEachNode.children = this.parse(node3);
        return forEachNode;
    }

    final TemplateNode parseIf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "test", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        IfNode ifNode = new IfNode(expr);
        ifNode.children = this.parse(node3);
        return ifNode;
    }

    final TemplateNode parseWhen(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "test", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        WhenNode whenNode = new WhenNode(expr);
        whenNode.children = this.parse(node3);
        return whenNode;
    }

    final TemplateNode parseElement(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "namespace");
        String string3 = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        TemplateNode templateNode = this.parseAttributeValueTemplate(string, node2);
        TemplateNode templateNode2 = string2 == null ? null : this.parseAttributeValueTemplate(string2, node2);
        Node node3 = node2.getFirstChild();
        ElementNode elementNode = new ElementNode(templateNode, templateNode2, string3, node2);
        elementNode.children = this.parse(node3);
        return elementNode;
    }

    final TemplateNode parseAttribute(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "namespace");
        TemplateNode templateNode = this.parseAttributeValueTemplate(string, node2);
        TemplateNode templateNode2 = string2 == null ? null : this.parseAttributeValueTemplate(string2, node2);
        Node node3 = node2.getFirstChild();
        AttributeNode attributeNode = new AttributeNode(templateNode, templateNode2, node2);
        attributeNode.children = this.parse(node3);
        return attributeNode;
    }

    final TemplateNode parseText(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "disable-output-escaping");
        boolean bl = "yes".equals(string);
        Node node3 = node2.getFirstChild();
        TextNode textNode = new TextNode(bl);
        textNode.children = this.parse(node3);
        return textNode;
    }

    final TemplateNode parseCopy(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        Node node3 = node2.getFirstChild();
        CopyNode copyNode = new CopyNode(string);
        copyNode.children = this.parse(node3);
        return copyNode;
    }

    final TemplateNode parseProcessingInstruction(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        Node node3 = node2.getFirstChild();
        ProcessingInstructionNode processingInstructionNode = new ProcessingInstructionNode(string);
        processingInstructionNode.children = this.parse(node3);
        return processingInstructionNode;
    }

    final TemplateNode parseNumber(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        AbstractNumberNode abstractNumberNode;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "value");
        String string2 = Stylesheet.getAttribute(namedNodeMap, "format");
        if (string2 == null) {
            string2 = "1";
        }
        TemplateNode templateNode = this.parseAttributeValueTemplate(string2, node2);
        String string3 = Stylesheet.getAttribute(namedNodeMap, "lang");
        String string4 = Stylesheet.getAttribute(namedNodeMap, "letter-value");
        int n = "traditional".equals(string4) ? 1 : 0;
        String string5 = Stylesheet.getAttribute(namedNodeMap, "grouping-separator");
        String string6 = Stylesheet.getAttribute(namedNodeMap, "grouping-size");
        int n2 = string6 != null && string6.length() > 0 ? Integer.parseInt(string6) : 1;
        Node node3 = node2.getFirstChild();
        if (string != null && string.length() > 0) {
            Expr expr = (Expr)this.xpath.compile(string);
            abstractNumberNode = new NumberNode(expr, templateNode, string3, n, string5, n2);
        } else {
            String string7 = Stylesheet.getAttribute(namedNodeMap, "level");
            int n3 = "multiple".equals(string7) ? 1 : ("any".equals(string7) ? 2 : 0);
            String string8 = Stylesheet.getAttribute(namedNodeMap, "count");
            String string9 = Stylesheet.getAttribute(namedNodeMap, "from");
            Pattern pattern2 = null;
            Pattern pattern3 = null;
            if (string8 != null) {
                try {
                    pattern2 = (Pattern)this.xpath.compile(string8);
                }
                catch (ClassCastException classCastException) {
                    String string10 = "invalid pattern: " + string8;
                    throw new TransformerConfigurationException(string10);
                }
            }
            if (string9 != null) {
                try {
                    pattern3 = (Pattern)this.xpath.compile(string9);
                }
                catch (ClassCastException classCastException) {
                    String string11 = "invalid pattern: " + string9;
                    throw new TransformerConfigurationException(string11);
                }
            }
            abstractNumberNode = new NodeNumberNode(n3, pattern2, pattern3, templateNode, string3, n, string5, n2);
        }
        abstractNumberNode.children = this.parse(node3);
        return abstractNumberNode;
    }

    final TemplateNode parseCopyOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        CopyOfNode copyOfNode = new CopyOfNode(expr);
        copyOfNode.children = this.parse(node3);
        return copyOfNode;
    }

    final TemplateNode parseMessage(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "terminate");
        boolean bl = "yes".equals(string);
        Node node3 = node2.getFirstChild();
        MessageNode messageNode = new MessageNode(bl);
        messageNode.children = this.parse(node3);
        return messageNode;
    }

    final TemplateNode parse(Node node2) throws TransformerConfigurationException {
        TemplateNode templateNode = null;
        TemplateNode templateNode2 = null;
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            TemplateNode templateNode3 = this.doParse(node2);
            if (templateNode3 != null) {
                if (templateNode == null) {
                    templateNode = templateNode3;
                }
                if (templateNode2 != null) {
                    templateNode2.next = templateNode3;
                }
                templateNode2 = templateNode3;
            }
            node2 = node3;
        }
        return templateNode;
    }

    private final TemplateNode doParse(Node node2) throws TransformerConfigurationException {
        Object object;
        Object object2;
        this.current = node2;
        try {
            object2 = node2.getNamespaceURI();
            if (XSL_NS.equals(object2) && 1 == node2.getNodeType()) {
                String string = node2.getLocalName();
                if ("apply-templates".equals(string)) {
                    return this.parseApplyTemplates(node2);
                }
                if ("call-template".equals(string)) {
                    return this.parseCallTemplate(node2);
                }
                if ("value-of".equals(string)) {
                    return this.parseValueOf(node2);
                }
                if ("for-each".equals(string)) {
                    return this.parseForEach(node2);
                }
                if ("if".equals(string)) {
                    return this.parseIf(node2);
                }
                if ("choose".equals(string)) {
                    Node node3 = node2.getFirstChild();
                    ChooseNode chooseNode = new ChooseNode();
                    chooseNode.children = this.parse(node3);
                    return chooseNode;
                }
                if ("when".equals(string)) {
                    return this.parseWhen(node2);
                }
                if ("otherwise".equals(string)) {
                    Node node4 = node2.getFirstChild();
                    OtherwiseNode otherwiseNode = new OtherwiseNode();
                    otherwiseNode.children = this.parse(node4);
                    return otherwiseNode;
                }
                if ("element".equals(string)) {
                    return this.parseElement(node2);
                }
                if ("attribute".equals(string)) {
                    return this.parseAttribute(node2);
                }
                if ("text".equals(string)) {
                    return this.parseText(node2);
                }
                if ("copy".equals(string)) {
                    return this.parseCopy(node2);
                }
                if ("processing-instruction".equals(string)) {
                    return this.parseProcessingInstruction(node2);
                }
                if ("comment".equals(string)) {
                    Node node5 = node2.getFirstChild();
                    CommentNode commentNode = new CommentNode();
                    commentNode.children = this.parse(node5);
                    return commentNode;
                }
                if ("number".equals(string)) {
                    return this.parseNumber(node2);
                }
                if ("param".equals(string) || "variable".equals(string)) {
                    ParameterNode parameterNode;
                    int n = "variable".equals(string) ? 0 : 1;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Node node6 = node2.getFirstChild();
                    TemplateNode templateNode = this.parse(node6);
                    QName qName = this.getQName(Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2));
                    String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
                    if (string2 != null) {
                        if (templateNode != null) {
                            String string3 = "parameter '" + qName + "' has both select and content";
                            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                            throw new TransformerConfigurationException(string3, dOMSourceLocator);
                        }
                        Expr expr = (Expr)this.xpath.compile(string2);
                        parameterNode = new ParameterNode(qName, expr, n);
                    } else {
                        parameterNode = new ParameterNode(qName, null, n);
                        parameterNode.children = templateNode;
                    }
                    return parameterNode;
                }
                if ("copy-of".equals(string)) {
                    return this.parseCopyOf(node2);
                }
                if ("message".equals(string)) {
                    return this.parseMessage(node2);
                }
                if ("apply-imports".equals(string)) {
                    Node node7 = node2.getFirstChild();
                    ApplyImportsNode applyImportsNode = new ApplyImportsNode();
                    applyImportsNode.children = this.parse(node7);
                    return applyImportsNode;
                }
                return null;
            }
            object = node2.getPrefix();
            if (this.extensionElementPrefixes.contains(object)) {
                return null;
            }
            switch (node2.getNodeType()) {
                case 3: {
                    Text text = (Text)node2;
                    if (!this.isPreserved(text)) {
                        text.getParentNode().removeChild(text);
                        return null;
                    }
                    break;
                }
                case 8: {
                    return null;
                }
                case 1: {
                    Object object3;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    boolean bl = false;
                    String string = null;
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        object3 = namedNodeMap.item(i);
                        String string4 = object3.getNodeValue();
                        if (XSL_NS.equals(object3.getNamespaceURI()) && "use-attribute-sets".equals(object3.getLocalName())) {
                            string = string4;
                            bl = true;
                            break;
                        }
                        int n2 = string4.indexOf(123);
                        int n3 = string4.indexOf(125);
                        if (n2 == -1 && n3 == -1) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        Object object4;
                        Node node8 = node2.getFirstChild();
                        object3 = this.parse(node8);
                        for (int i = 0; i < n; ++i) {
                            Node node9 = namedNodeMap.item(i);
                            String string5 = node9.getNamespaceURI();
                            object4 = node9.getNodeName();
                            if (XSL_NS.equals(string5) && "use-attribute-sets".equals(node9.getLocalName())) continue;
                            String string6 = node9.getNodeValue();
                            TemplateNode templateNode = this.parseAttributeValueTemplate(string6, node2);
                            TemplateNode templateNode2 = this.parseAttributeValueTemplate((String)object4, node2);
                            TemplateNode templateNode3 = string5 == null ? null : this.parseAttributeValueTemplate(string5, node2);
                            AttributeNode attributeNode = new AttributeNode(templateNode2, templateNode3, node9);
                            attributeNode.children = templateNode;
                            attributeNode.next = object3;
                            object3 = attributeNode;
                        }
                        String string7 = node2.getNodeName();
                        TemplateNode templateNode = this.parseAttributeValueTemplate(string7, node2);
                        TemplateNode templateNode4 = object2 == null ? null : this.parseAttributeValueTemplate((String)object2, node2);
                        object4 = new ElementNode(templateNode, templateNode4, string, node2);
                        ((TemplateNode)object4).children = object3;
                        return object4;
                    } else {
                        break;
                    }
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(xPathExpressionException.getMessage(), dOMSourceLocator, xPathExpressionException);
        }
        object2 = node2.getFirstChild();
        object = new LiteralNode(node2);
        ((TemplateNode)object).children = this.parse((Node)object2);
        return object;
    }

    final List parseSortKeys(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList linkedList = new LinkedList();
        while (node2 != null) {
            String string = node2.getNamespaceURI();
            if (XSL_NS.equals(string) && 1 == node2.getNodeType() && "sort".equals(node2.getLocalName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
                if (string2 == null) {
                    string2 = ".";
                }
                Expr expr = (Expr)this.xpath.compile(string2);
                String string3 = Stylesheet.getAttribute(namedNodeMap, "lang");
                TemplateNode templateNode = string3 == null ? null : this.parseAttributeValueTemplate(string3, node2);
                String string4 = Stylesheet.getAttribute(namedNodeMap, "data-type");
                TemplateNode templateNode2 = string4 == null ? null : this.parseAttributeValueTemplate(string4, node2);
                String string5 = Stylesheet.getAttribute(namedNodeMap, "order");
                TemplateNode templateNode3 = string5 == null ? null : this.parseAttributeValueTemplate(string5, node2);
                String string6 = Stylesheet.getAttribute(namedNodeMap, "case-order");
                TemplateNode templateNode4 = string6 == null ? null : this.parseAttributeValueTemplate(string6, node2);
                linkedList.add(new SortKey(expr, templateNode, templateNode2, templateNode3, templateNode4));
            }
            node2 = node2.getNextSibling();
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList;
    }

    final List parseWithParams(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList linkedList = new LinkedList();
        while (node2 != null) {
            String string = node2.getNamespaceURI();
            if (XSL_NS.equals(string) && 1 == node2.getNodeType() && "with-param".equals(node2.getLocalName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                TemplateNode templateNode = this.parse(node2.getFirstChild());
                QName qName = this.getQName(Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2));
                String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
                if (string2 != null) {
                    Object object;
                    if (templateNode != null) {
                        object = "parameter '" + qName + "' has both select and content";
                        DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                        throw new TransformerConfigurationException((String)object, dOMSourceLocator);
                    }
                    object = (Expr)this.xpath.compile(string2);
                    linkedList.add(new WithParam(qName, (Expr)object));
                } else {
                    linkedList.add(new WithParam(qName, templateNode));
                }
            }
            node2 = node2.getNextSibling();
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList;
    }

    final void addNamespaceNodes(Node node2, Node node3, Document document, Collection collection) {
        Node node4;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node5 = namedNodeMap.item(i);
                String string2 = node5.getNamespaceURI();
                if (string2 != "http://www.w3.org/2000/xmlns/") continue;
                String string3 = node5.getLocalName();
                if (XMLConstants.XMLNS_ATTRIBUTE.equals(string3)) {
                    string3 = "#default";
                }
                if (XSL_NS.equals(string = node5.getNodeValue()) || this.extensionElementPrefixes.contains(string3) || collection.contains(string3) || this.excludeResultPrefixes.contains(string3)) continue;
                if (string3 == "#default") {
                    string3 = null;
                }
                if (node3.lookupNamespaceURI(string3) != null) continue;
                node5 = node5.cloneNode(true);
                node5 = document.adoptNode(node5);
                node3.getAttributes().setNamedItemNS(node5);
            }
        }
        if ((node4 = node2.getParentNode()) != null) {
            this.addNamespaceNodes(node4, node3, document, collection);
        }
    }

    static final String getAttribute(NamedNodeMap namedNodeMap, String string) {
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        String string2 = node2.getNodeValue();
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    static final String getRequiredAttribute(NamedNodeMap namedNodeMap, String string, Node node2) throws TransformerConfigurationException {
        String string2 = Stylesheet.getAttribute(namedNodeMap, string);
        if (string2 == null || string2.length() == 0) {
            String string3 = string + " attribute is required on " + node2.getNodeName();
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(string3, dOMSourceLocator);
        }
        return string2;
    }

    public void handle(short s, String string, Object object, Node node2, Node node3) {
        node3.setUserData(string, object, this);
    }

    static {
        XSL_NS = XSL_NS;
    }
}

