/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.XMLConstants;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ElementNode
extends TemplateNode {
    final TemplateNode name;
    final TemplateNode namespace;
    final String uas;
    final Node source;
    final Collection elementExcludeResultPrefixes;

    ElementNode(TemplateNode templateNode, TemplateNode templateNode2, String string, Node node2) {
        this.name = templateNode;
        this.namespace = templateNode2;
        this.uas = string;
        this.source = node2;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItemNS("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
        if (node3 != null) {
            this.elementExcludeResultPrefixes = new HashSet();
            StringTokenizer stringTokenizer = new StringTokenizer(node3.getNodeValue());
            while (stringTokenizer.hasMoreTokens()) {
                this.elementExcludeResultPrefixes.add(stringTokenizer.nextToken());
            }
        } else {
            this.elementExcludeResultPrefixes = Collections.EMPTY_SET;
        }
    }

    TemplateNode clone(Stylesheet stylesheet) {
        ElementNode elementNode = new ElementNode(this.name.clone(stylesheet), this.namespace == null ? null : this.namespace.clone(stylesheet), this.uas, this.source);
        if (this.children != null) {
            elementNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            elementNode.next = this.next.clone(stylesheet);
        }
        return elementNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        Element element;
        String string;
        Document document = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.name.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
        String string2 = Expr.stringValue(documentFragment);
        String string3 = null;
        if (this.namespace != null) {
            documentFragment = document.createDocumentFragment();
            this.namespace.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
            string3 = Expr.stringValue(documentFragment);
            if (string3.length() == 0) {
                string3 = null;
            }
        }
        if (XMLConstants.XMLNS_ATTRIBUTE.equals(string = this.getPrefix(string2))) {
            int n3 = string2.indexOf(58);
            string2 = string2.substring(n3 + 1);
        } else {
            String string4;
            if (string == null) {
                string = "#default";
            }
            if ((string4 = (String)stylesheet.namespaceAliases.get(string)) != null) {
                if ("#default".equals(string4)) {
                    string4 = null;
                }
                string3 = this.source.lookupNamespaceURI(string4);
            }
            if (string == "#default") {
                string = null;
            }
            if (string3 == null) {
                string3 = XMLConstants.XML_NS_PREFIX.equals(string) ? "http://www.w3.org/XML/1998/namespace" : this.source.lookupNamespaceURI(string);
            }
        }
        Element element2 = element = string3 != null ? document.createElementNS(string3, string2) : document.createElement(string2);
        if (node4 != null) {
            node3.insertBefore(element, node4);
        } else {
            node3.appendChild(element);
        }
        stylesheet.addNamespaceNodes(this.source, element, document, this.elementExcludeResultPrefixes);
        if (this.uas != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.uas, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addAttributeSet(stylesheet, qName, node2, n, n2, element, null, stringTokenizer.nextToken());
            }
        }
        if (this.children != null) {
            this.children.apply(stylesheet, qName, node2, n, n2, element, null);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    final String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    void addAttributeSet(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4, String string) throws TransformerException {
        Iterator iterator = stylesheet.attributeSets.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            if (!attributeSet.name.equals(string)) continue;
            if (attributeSet.uas != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(attributeSet.uas, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addAttributeSet(stylesheet, qName, node2, n, n2, node3, node4, stringTokenizer.nextToken());
                }
            }
            if (attributeSet.children == null) continue;
            attributeSet.children.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public boolean references(QName qName) {
        if (this.name != null && this.name.references(qName)) {
            return true;
        }
        if (this.namespace != null && this.namespace.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        if (this.uas != null) {
            stringBuffer.append(",uas=");
            stringBuffer.append(this.uas);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

