/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class AbstractNumberNode
extends TemplateNode {
    static final int ALPHABETIC = 0;
    static final int TRADITIONAL = 1;
    final TemplateNode format;
    final String lang;
    final int letterValue;
    final String groupingSeparator;
    final int groupingSize;
    static final int[] roman_numbers = new int[]{1, 5, 10, 50, 100, 500, 1000};
    static final char[] roman_chars = new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm'};

    AbstractNumberNode(TemplateNode templateNode, String string, int n, String string2, int n2) {
        this.format = templateNode;
        this.lang = string;
        this.letterValue = n;
        this.groupingSeparator = string2;
        this.groupingSize = n2;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        Document document = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.format.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
        String string = Expr._string(node2, Collections.singleton(documentFragment));
        String string2 = this.format(string, this.compute(stylesheet, node2, n, n2));
        Text text = document.createTextNode(string2);
        if (node4 != null) {
            node3.insertBefore(text, node4);
        } else {
            node3.appendChild(text);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    String format(String string, int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        ArrayList arrayList = new ArrayList(nArray.length * 2 + 1);
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        while (n2 < n3) {
            while (n2 < n3 && !AbstractNumberNode.isAlphanumeric(string.charAt(n2))) {
                ++n2;
            }
            if (n2 > n) {
                arrayList.add(string.substring(n, n2));
                arrayList2.add(Boolean.FALSE);
            }
            n = n2;
            while (n2 < n3 && AbstractNumberNode.isAlphanumeric(string.charAt(n2))) {
                ++n2;
            }
            if (n2 > n) {
                arrayList.add(string.substring(n, n2));
                arrayList2.add(Boolean.TRUE);
            }
            n = n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = arrayList.size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            String string2 = i < 0 ? "." : (String)arrayList.get(i);
            boolean bl2 = bl = i < 0 ? true : (Boolean)arrayList2.get(i);
            if (!bl) {
                stringBuffer.append(string2);
                continue;
            }
            if (n4 < nArray.length) {
                this.format(stringBuffer, nArray[n4++], string2);
                if ((i + 1 == n3 || i + 2 == n3) && n4 < nArray.length) {
                    i -= 2;
                }
            }
            if (n4 != nArray.length || i >= n3 - 2 || !((Boolean)arrayList2.get((i = n3 - 2) + 1)).booleanValue()) continue;
            ++i;
        }
        return stringBuffer.toString();
    }

    void format(StringBuffer stringBuffer, int n, String string) {
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        if (Character.digit(c, 10) == 1) {
            for (int i = n2 - 2; i >= 0; --i) {
                if (string.charAt(i) == c - '\u0001') continue;
                this.format(stringBuffer, n, "1");
                return;
            }
            String string2 = Integer.toString(n);
            for (int i = n2 - string2.length(); i > 0; --i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        } else if ("A".equals(string)) {
            stringBuffer.append(AbstractNumberNode.alphabetic('@', n));
        } else if ("a".equals(string)) {
            stringBuffer.append(AbstractNumberNode.alphabetic('`', n));
        } else if ("i".equals(string)) {
            stringBuffer.append(AbstractNumberNode.roman(false, n));
        } else if ("I".equals(string)) {
            stringBuffer.append(AbstractNumberNode.roman(true, n));
        } else {
            this.format(stringBuffer, n, "1");
        }
    }

    static final boolean isAlphanumeric(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static final String alphabetic(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = n % 26;
            n /= 26;
            stringBuffer.insert(0, (char)(c + n2));
        }
        return stringBuffer.toString();
    }

    static final String roman(boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = roman_numbers.length - 1; i >= 0; i -= 2) {
            int n2 = n / roman_numbers[i];
            if (n2 != 0) {
                n %= n2 * roman_numbers[i];
            }
            if (n2 > 4 && n2 < 9) {
                stringBuffer.append(roman_chars[i + 1]);
                n2 -= 5;
            }
            if (n2 == 4) {
                stringBuffer.append(roman_chars[i]);
                stringBuffer.append(roman_chars[i + 1]);
                continue;
            }
            if (n2 == 9) {
                stringBuffer.append(roman_chars[i]);
                stringBuffer.append(roman_chars[i + 2]);
                continue;
            }
            while (n2 > 0) {
                stringBuffer.append(roman_chars[i]);
                --n2;
            }
        }
        if (bl) {
            return stringBuffer.toString().toUpperCase();
        }
        return stringBuffer.toString();
    }

    abstract int[] compute(Stylesheet var1, Node var2, int var3, int var4) throws TransformerException;

    public boolean references(QName qName) {
        if (this.format.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("format=");
        stringBuffer.append(this.format);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

