/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomDocumentBuilder
extends DocumentBuilder {
    final DOMImplementation impl;
    final DOMImplementationLS ls;
    final LSParser parser;

    DomDocumentBuilder(DOMImplementation dOMImplementation, DOMImplementationLS dOMImplementationLS, LSParser lSParser) {
        this.impl = dOMImplementation;
        this.ls = dOMImplementationLS;
        this.parser = lSParser;
    }

    public boolean isNamespaceAware() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("namespaces");
    }

    public boolean isValidating() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("validating");
    }

    public boolean isXIncludeAware() {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        return (Boolean)dOMConfiguration.getParameter("xinclude-aware");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        dOMConfiguration.setParameter("entity-resolver", entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        DOMConfiguration dOMConfiguration = this.parser.getDomConfig();
        dOMConfiguration.setParameter("error-handler", errorHandler);
    }

    public DOMImplementation getDOMImplementation() {
        return this.impl;
    }

    public Document newDocument() {
        return this.impl.createDocument(null, null, null);
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        LSInput lSInput = this.ls.createLSInput();
        lSInput.setByteStream(inputStream);
        return this.parser.parse(lSInput);
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        LSInput lSInput = this.ls.createLSInput();
        lSInput.setByteStream(inputStream);
        lSInput.setSystemId(string);
        return this.parser.parse(lSInput);
    }

    public Document parse(String string) throws SAXException, IOException {
        return this.parser.parseURI(string);
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        LSInput lSInput = this.ls.createLSInput();
        String string = inputSource.getSystemId();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            lSInput.setByteStream(inputStream);
        } else {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                lSInput.setCharacterStream(reader);
            } else {
                URL uRL = new URL(string);
                lSInput.setByteStream(uRL.openStream());
            }
        }
        lSInput.setPublicId(inputSource.getPublicId());
        lSInput.setSystemId(string);
        lSInput.setEncoding(inputSource.getEncoding());
        return this.parser.parse(lSInput);
    }
}

