/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.java.security.action.GetPropertyAction;
import gnu.xml.aelfred2.SAXDriver;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    static boolean uriWarnings;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private LinkedList inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private InputSource scratch;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private boolean docIsStandalone;
    private HashMap elementInfo;
    private HashMap entityInfo;
    private HashMap notationInfo;
    private boolean skippedPE;
    private String currentElement;
    private int currentElementContent;
    private LinkedList entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private boolean doReport;
    private static final int SYMBOL_TABLE_LENGTH = 2039;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;
    private static final int XML_10 = 0;
    private static final int XML_11 = 1;
    private int xmlVersion;
    static final char[] startDelimComment;
    static final char[] endDelimComment;
    static final char[] startDelimPI;
    static final char[] endDelimPI;
    static final char[] endDelimCDATA;
    private boolean isDirtyCurrentElement;

    private /* synthetic */ void finit$() {
        this.xmlVersion = 0;
    }

    XmlParser() {
        this.finit$();
    }

    void setHandler(SAXDriver sAXDriver) {
        this.handler = sAXDriver;
    }

    void doParse(String string, String string2, Reader reader, InputStream inputStream, String string3) throws Exception {
        IOException iOException3;
        block19: {
            if (this.handler == null) {
                throw new IllegalStateException("no callback handler");
            }
            this.initializeVariables();
            this.setInternalEntity("amp", "&#38;");
            this.setInternalEntity("lt", "&#60;");
            this.setInternalEntity("gt", "&#62;");
            this.setInternalEntity("apos", "&#39;");
            this.setInternalEntity("quot", "&#34;");
            try {
                try {
                    this.handler.startDocument();
                    this.pushURL(false, "[document]", new ExternalIdentifiers(string2, string, null), reader, inputStream, string3, false);
                    this.parseDocument();
                }
                catch (EOFException eOFException) {
                    this.error("empty document, with no root element.");
                }
                Object var6_7 = null;
                if (reader == null) break block19;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var6_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                this.scratch = null;
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        this.scratch = null;
    }

    private void error(String string, String string2, String string3) throws SAXException {
        if (string2 != null) {
            string = string + " (found \"" + string2 + "\")";
        }
        if (string3 != null) {
            string = string + " (expected \"" + string3 + "\")";
        }
        this.handler.fatal(string);
        throw new SAXException(string);
    }

    private void error(String string, char c, String string2) throws SAXException {
        this.error(string, new Character(c).toString(), string2);
    }

    private void error(String string) throws SAXException {
        this.handler.fatal(string);
    }

    private void parseDocument() throws Exception {
        char c;
        try {
            c = this.parseProlog();
            this.require('<');
            this.parseElement(c ^ true);
        }
        catch (EOFException eOFException) {
            this.error("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseComment() throws Exception {
        boolean bl = this.expandPE;
        this.expandPE = false;
        this.parseUntil(endDelimComment);
        this.require('>');
        this.expandPE = bl;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parsePI() throws SAXException, IOException {
        boolean bl = this.expandPE;
        this.expandPE = false;
        String string = this.readNmtoken(true);
        if (string.indexOf(58) >= 0) {
            this.error("Illegal character(':') in processing instruction name ", string, null);
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.error("Illegal processing instruction target", string, null);
        }
        if (!this.tryRead(endDelimPI)) {
            this.requireWhitespace();
            this.parseUntil(endDelimPI);
        }
        this.expandPE = bl;
        this.handler.processingInstruction(string, this.dataBufferToString());
    }

    private void parseCDSect() throws Exception {
        this.parseUntil(endDelimCDATA);
        this.dataBufferFlush();
    }

    private boolean parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
            return true;
        }
        return false;
    }

    private void checkLegalVersion(String string) throws SAXException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('0' <= c && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') continue;
            this.error("illegal character in version", string, "1.0");
        }
    }

    private String parseXMLDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        String string2 = null;
        int n = 112;
        String string3 = null;
        switch (this.encoding) {
            case 0: 
            case 1: {
                string3 = "UTF-8";
                break;
            }
            case 2: {
                string3 = "ISO-8859-1";
                break;
            }
            case 3: {
                string3 = "UTF-16BE";
                break;
            }
            case 4: {
                string3 = "UTF-16LE";
            }
        }
        this.require("version");
        this.parseEq();
        String string4 = this.readLiteral(n);
        this.checkLegalVersion(string4);
        if (!string4.equals("1.0")) {
            if (string4.equals("1.1")) {
                this.handler.warn("expected XML version 1.0, not: " + string4);
                this.xmlVersion = 1;
            } else {
                this.error("illegal XML version", string4, "1.0 or 1.1");
            }
        } else {
            this.xmlVersion = 0;
        }
        boolean bl2 = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!bl2) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            string = this.readLiteral(n);
            if (!bl) {
                this.setupDecoding(string);
            }
        }
        if (string != null) {
            bl2 = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!bl2) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            string2 = this.readLiteral(n);
            if ("yes".equals(string2)) {
                this.docIsStandalone = true;
            } else if (!"no".equals(string2)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        if (string3 == null) {
            string3 = string;
        }
        this.handler.xmlDecl(string4, string, this.docIsStandalone, string3);
        return string;
    }

    private String parseTextDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        int n = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String string2 = this.readLiteral(n);
            this.checkLegalVersion(string2);
            if (string2.equals("1.1")) {
                if (this.xmlVersion == 0) {
                    this.error("external subset has later version number.", "1.0", string2);
                }
                this.handler.warn("expected XML version 1.0, not: " + string2);
                this.xmlVersion = 1;
            } else if (!string2.equals("1.0")) {
                this.error("illegal XML version", string2, "1.0 or 1.1");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        string = this.readLiteral(n);
        if (!bl) {
            this.setupDecoding(string);
        }
        this.skipWhitespace();
        this.require("?>");
        return string;
    }

    private void setupDecoding(String string) throws SAXException, IOException {
        string = string.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (string.equals("ISO-8859-1") || string.equals("8859_1") || string.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (string.equals("US-ASCII") || string.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (string.equals("UTF-8") || string.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                throw new UnsupportedEncodingException(string);
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(string.equals("ISO-10646-UCS-2") || string.equals("UTF-16") || string.equals("UTF-16BE") || string.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", string, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!string.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", string, "ISO-10646-UCS-4");
            }
            return;
        }
        if (string.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (string.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (string.equals("UTF-16") || string.equals("ISO-10646-UCS-2")) {
            string = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, string);
        this.sourceType = 5;
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead(startDelimPI)) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead(startDelimComment)) break;
            this.parseComment();
        }
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        ExternalIdentifiers externalIdentifiers = this.readExternalIds(false, true);
        this.handler.doctypeDecl(string, externalIdentifiers.publicId, externalIdentifiers.systemId);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        this.skipWhitespace();
        this.require('>');
        InputSource inputSource = externalIdentifiers.systemId == null ? this.handler.getExternalSubset(string, this.handler.getSystemId()) : null;
        if (externalIdentifiers.systemId != null || inputSource != null) {
            this.pushString(null, ">");
            if (externalIdentifiers.systemId != null) {
                this.pushURL(true, "[dtd]", externalIdentifiers, null, null, null, true);
            } else {
                this.handler.warn("modifying document by adding external subset");
                this.pushURL(true, "[dtd]", new ExternalIdentifiers(inputSource.getPublicId(), inputSource.getSystemId(), null), inputSource.getCharacterStream(), inputSource.getByteStream(), inputSource.getEncoding(), false);
            }
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
        }
        this.handler.endDoctype();
        this.expandPE = false;
        this.doReport = true;
    }

    private void parseMarkupdecl() throws Exception {
        char[] cArray = null;
        boolean bl = this.expandPE;
        this.require('<');
        this.unread('<');
        this.expandPE = false;
        if (this.tryRead("<!ELEMENT")) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parseElementDecl();
        } else if (this.tryRead("<!ATTLIST")) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parseNotationDecl();
        } else if (this.tryRead(startDelimPI)) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parsePI();
        } else if (this.tryRead(startDelimComment)) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            this.parseComment();
        } else if (this.tryRead("<![")) {
            cArray = this.readBuffer;
            this.expandPE = bl;
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect(cArray);
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
        if (this.readBuffer != cArray) {
            this.handler.verror("Illegal Declaration/PE nesting");
        }
    }

    private void parseElement(boolean bl) throws Exception {
        String string;
        Object object;
        InputSource inputSource;
        int n = this.currentElementContent;
        String string2 = this.currentElement;
        this.tagAttributePos = 0;
        String string3 = this.readNmtoken(true);
        if (bl && (inputSource = this.handler.getExternalSubset(string3, this.handler.getSystemId())) != null) {
            object = inputSource.getPublicId();
            string = inputSource.getSystemId();
            this.handler.warn("modifying document by adding DTD");
            this.handler.doctypeDecl(string3, (String)object, string);
            this.pushString(null, ">");
            this.pushURL(true, "[dtd]", new ExternalIdentifiers((String)object, string, null), inputSource.getCharacterStream(), inputSource.getByteStream(), inputSource.getEncoding(), false);
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
            this.handler.endDoctype();
        }
        this.currentElement = string3;
        ElementDecl elementDecl = (ElementDecl)this.elementInfo.get(string3);
        this.currentElementContent = this.getContentType(elementDecl, 1);
        boolean bl2 = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!bl2) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(string3);
            bl2 = this.tryWhitespace();
            c = this.readCh();
        }
        object = this.declaredAttributes(elementDecl);
        if (object != null) {
            block6: while (object.hasNext()) {
                string = (String)object.next();
                for (int i = 0; i < this.tagAttributePos; ++i) {
                    if (this.tagAttributes[i] == string) continue block6;
                }
                String string4 = this.getAttributeDefaultValue(string3, string);
                if (string4 == null) continue;
                this.handler.attribute(string, string4, false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(string3);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(string3);
                this.handler.endElement(string3);
            }
        }
        this.currentElement = string2;
        this.currentElementContent = n;
    }

    private void parseAttribute(String string) throws Exception {
        int n = 10;
        String string2 = this.readNmtoken(true);
        String string3 = this.getAttributeType(string, string2);
        this.parseEq();
        String string4 = this.handler.stringInterning ? (string3 == "CDATA" || string3 == null ? this.readLiteral(n) : this.readLiteral(n | 4)) : (string3 == null || string3.equals("CDATA") ? this.readLiteral(n) : this.readLiteral(n | 4));
        for (int i = 0; i < this.tagAttributePos; ++i) {
            if (!string2.equals(this.tagAttributes[i])) continue;
            this.error("duplicate attribute", string2, null);
        }
        this.handler.attribute(string2, string4, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] stringArray = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, stringArray, 0, this.tagAttributePos);
            this.tagAttributes = stringArray;
        }
        this.tagAttributes[this.tagAttributePos++] = string2;
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseContent() throws Exception {
        while (true) {
            this.parseCharData();
            char c = this.readCh();
            block0 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                    } else {
                        this.unread(c);
                        this.parseEntityRef(true);
                    }
                    this.isDirtyCurrentElement = true;
                    break;
                }
                case '<': {
                    this.dataBufferFlush();
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.isDirtyCurrentElement = false;
                                    this.parseComment();
                                    break block0;
                                }
                                case '[': {
                                    this.isDirtyCurrentElement = false;
                                    this.require("CDATA[");
                                    this.handler.startCDATA();
                                    this.inCDATA = true;
                                    this.parseCDSect();
                                    this.inCDATA = false;
                                    this.handler.endCDATA();
                                    break block0;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block0;
                        }
                        case '?': {
                            this.isDirtyCurrentElement = false;
                            this.parsePI();
                            break block0;
                        }
                        case '/': {
                            this.isDirtyCurrentElement = false;
                            this.parseETag();
                            return;
                        }
                    }
                    this.isDirtyCurrentElement = false;
                    this.unread(c);
                    this.parseElement(false);
                }
            }
        }
    }

    private void parseElementDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(string);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseContentspec(String string) throws Exception {
        String string2;
        if (this.tryRead("EMPTY")) {
            this.setElement(string, 2, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(string, "EMPTY");
            }
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(string, 1, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(string, "ANY");
            }
            return;
        }
        this.require('(');
        char[] cArray = this.readBuffer;
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed(cArray);
            string2 = this.dataBufferToString();
            this.setElement(string, 3, string2, null);
        } else {
            this.parseElements(cArray);
            string2 = this.dataBufferToString();
            this.setElement(string, 4, string2, null);
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().elementDecl(string, string2);
        }
    }

    private void parseElements(char[] cArray) throws Exception {
        char c;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c2 = this.readCh();
        switch (c2) {
            case ')': {
                if (this.readBuffer != cArray) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                this.dataBufferAppend(')');
                c2 = this.readCh();
                switch (c2) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c2);
                        break;
                    }
                    default: {
                        this.unread(c2);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                c = c2;
                this.dataBufferAppend(c2);
                break;
            }
            default: {
                this.error("bad separator in content model", c2, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c2 = this.readCh();
            if (c2 == ')') {
                if (this.readBuffer != cArray) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                break;
            }
            if (c2 != c) {
                this.error("bad separator in content model", c2, null);
                return;
            }
            this.dataBufferAppend(c2);
        }
        this.dataBufferAppend(')');
        c2 = this.readCh();
        switch (c2) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c2);
                return;
            }
        }
        this.unread(c2);
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements(this.readBuffer);
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    private void parseMixed(char[] cArray) throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            if (this.readBuffer != cArray) {
                this.handler.verror("Illegal Group/PE nesting");
            }
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        if (this.readBuffer != cArray) {
            this.handler.verror("Illegal Group/PE nesting");
        }
        this.require('*');
        this.dataBufferAppend(")*");
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        boolean bl = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!bl) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(string);
            bl = this.tryWhitespace();
        }
    }

    private void parseAttDef(String string) throws Exception {
        String string2 = null;
        String string3 = this.readNmtoken(true);
        this.requireWhitespace();
        String string4 = this.readAttType();
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == string4 || "NOTATION" == string4) {
                string2 = this.dataBufferToString();
            }
        } else if ("ENUMERATION".equals(string4) || "NOTATION".equals(string4)) {
            string2 = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(string, string3, string4, string2);
    }

    private String readAttType() throws Exception {
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return "ENUMERATION";
        }
        String string = this.readNmtoken(true);
        if (this.handler.stringInterning) {
            if ("NOTATION" == string) {
                this.parseNotationType();
                return string;
            }
            if ("CDATA" == string || "ID" == string || "IDREF" == string || "IDREFS" == string || "ENTITY" == string || "ENTITIES" == string || "NMTOKEN" == string || "NMTOKENS" == string) {
                return string;
            }
        } else {
            if ("NOTATION".equals(string)) {
                this.parseNotationType();
                return string;
            }
            if ("CDATA".equals(string) || "ID".equals(string) || "IDREF".equals(string) || "IDREFS".equals(string) || "ENTITY".equals(string) || "ENTITIES".equals(string) || "NMTOKEN".equals(string) || "NMTOKENS".equals(string)) {
                return string;
            }
        }
        this.error("illegal attribute type", string, null);
        return null;
    }

    private void parseEnumeration(boolean bl) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(bl));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(bl));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parseDefault(String string, String string2, String string3, String string4) throws Exception {
        int n = 31;
        String string5 = null;
        int n2 = 8;
        boolean bl = this.expandPE;
        String string6 = null;
        if (!this.skippedPE) {
            n2 |= 2;
            if (this.handler.stringInterning) {
                if ("CDATA" != string3) {
                    n2 |= 4;
                }
            } else if (!"CDATA".equals(string3)) {
                n2 |= 4;
            }
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                string6 = "#FIXED";
                n = 34;
                this.requireWhitespace();
                string5 = this.readLiteral(n2);
            } else if (this.tryRead("REQUIRED")) {
                string6 = "#REQUIRED";
                n = 33;
            } else if (this.tryRead("IMPLIED")) {
                string6 = "#IMPLIED";
                n = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            string5 = this.readLiteral(n2);
        }
        this.expandPE = bl;
        this.setAttribute(string, string2, string3, string4, string5, n);
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == string3) {
                string3 = string4;
            } else if ("NOTATION" == string3) {
                string3 = "NOTATION " + string4;
            }
        } else if ("ENUMERATION".equals(string3)) {
            string3 = string4;
        } else if ("NOTATION".equals(string3)) {
            string3 = "NOTATION " + string4;
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().attributeDecl(string, string2, string3, string6, string5);
        }
    }

    private void parseConditionalSect(char[] cArray) throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != cArray) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != cArray) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            boolean bl = true;
            this.expandPE = false;
            int n = 1;
            block5: while (n > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (!this.tryRead("![")) continue block5;
                        ++n;
                        break;
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --n;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseCharRef() throws SAXException, IOException {
        this.parseCharRef(true);
    }

    private void tryReadCharRef() throws SAXException, IOException {
        int n = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n2 = Character.digit(c, 16);
                if (n2 == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                n *= 16;
                n += n2;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n3 = Character.digit(c, 10);
                if (n3 == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                n *= 10;
                n += n3;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(n));
        }
        if (n > 0x10FFFF) {
            this.error("character reference " + n + " is too large for UTF-16", new Integer(n).toString(), null);
        }
    }

    private void parseCharRef(boolean bl) throws SAXException, IOException {
        int n = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n2 = Character.digit(c, 16);
                if (n2 == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                n *= 16;
                n += n2;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n3 = Character.digit(c, 10);
                if (n3 == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                n *= 10;
                n += c - 48;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            this.dataBufferAppend((char)n);
        } else if (n <= 0x10FFFF) {
            this.dataBufferAppend((char)(0xD800 | (n -= 65536) >> 10));
            this.dataBufferAppend((char)(0xDC00 | n & 0x3FF));
        } else {
            this.error("character reference " + n + " is too large for UTF-16", new Integer(n).toString(), null);
        }
        if (bl) {
            this.dataBufferFlush();
        }
    }

    private void parseEntityRef(boolean bl) throws SAXException, IOException {
        String string = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                String string2 = "reference to undeclared general entity " + string;
                if (this.skippedPE && !this.docIsStandalone) {
                    this.handler.verror(string2);
                    if (!bl) break;
                    this.handler.skippedEntity(string);
                    break;
                }
                this.error(string2);
                break;
            }
            case 1: {
                this.pushString(string, this.getEntityValue(string));
                char c = this.readCh();
                this.unread(c);
                int n = this.readBufferPos;
                int n2 = this.readBufferPos + this.getEntityValue(string).length();
                for (int i = this.readBufferPos; i < n2; ++i) {
                    c = this.readCh();
                    if (c != '&') continue;
                    c = this.readCh();
                    if (c == '#') {
                        this.tryReadCharRef();
                        if (this.readBufferPos >= n2) break;
                        i = this.readBufferPos;
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        this.unread(c);
                        this.readNmtoken(true);
                        this.require(';');
                        if (this.readBufferPos >= n2) break;
                        i = this.readBufferPos;
                        continue;
                    }
                    this.error(" malformed entity reference");
                }
                this.readBufferPos = n;
                break;
            }
            case 3: {
                if (bl) {
                    this.pushURL(false, string, this.getEntityIds(string), null, null, null, true);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            case 2: {
                if (bl) {
                    this.error("unparsed entity reference in content", string, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void parsePEReference() throws SAXException, IOException {
        String string = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                this.handler.verror("reference to undeclared parameter entity " + string);
                break;
            }
            case 1: {
                if (this.inLiteral) {
                    this.pushString(string, this.getEntityValue(string));
                    break;
                }
                this.pushString(string, ' ' + this.getEntityValue(string) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(true, string, this.getEntityIds(string), null, null, null, true);
                if (this.inLiteral) break;
                this.pushString(null, " ");
            }
        }
    }

    private void parseEntityDecl() throws Exception {
        boolean bl = false;
        int n = 0;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String string = this.readNmtoken(true);
        if (string.indexOf(58) >= 0) {
            this.error("Illegal character(':') in entity name ", string, null);
        }
        if (bl) {
            string = "%" + string;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String string2 = this.readLiteral(n);
            this.setInternalEntity(string, string2);
        } else {
            ExternalIdentifiers externalIdentifiers = this.readExternalIds(false, false);
            boolean bl2 = this.tryWhitespace();
            if (!bl && this.tryRead("NDATA")) {
                if (!bl2) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String string3 = this.readNmtoken(true);
                if (!this.skippedPE) {
                    this.setExternalEntity(string, 2, externalIdentifiers, string3);
                    this.handler.unparsedEntityDecl(string, externalIdentifiers.publicId, externalIdentifiers.systemId, externalIdentifiers.baseUri, string3);
                }
            } else if (!this.skippedPE) {
                this.setExternalEntity(string, 3, externalIdentifiers, null);
                this.handler.getDeclHandler().externalEntityDecl(string, externalIdentifiers.publicId, this.handler.resolveURIs() ? this.handler.absolutize(externalIdentifiers.baseUri, externalIdentifiers.systemId, false) : externalIdentifiers.systemId);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        if (string.indexOf(58) >= 0) {
            this.error("Illegal character(':') in notation name ", string, null);
        }
        this.requireWhitespace();
        ExternalIdentifiers externalIdentifiers = this.readExternalIds(true, false);
        this.setNotation(string, externalIdentifiers);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseCharData() throws Exception {
        int n = 0;
        boolean bl = false;
        if (this.currentElementContent == 4 && !this.isDirtyCurrentElement) {
            bl = true;
        }
        while (true) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            block7: for (n2 = this.readBufferPos; n2 < this.readBufferLength; ++n2) {
                char c = this.readBuffer[n2];
                switch (c) {
                    case '\n': {
                        ++n3;
                        n4 = 0;
                        continue block7;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        ++n4;
                        continue block7;
                    }
                    case '&': 
                    case '<': {
                        ++n4;
                        n = 1;
                        break block7;
                    }
                    case ']': {
                        bl = false;
                        if (n2 + 2 < this.readBufferLength && this.readBuffer[n2 + 1] == ']' && this.readBuffer[n2 + 2] == '>') {
                            n = 2;
                            break block7;
                        }
                        ++n4;
                        continue block7;
                    }
                    default: {
                        if (c < ' ' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                            this.error("illegal XML character U+" + Integer.toHexString(c));
                        }
                        bl = false;
                        ++n4;
                    }
                }
            }
            if (n3 > 0) {
                this.line += n3;
                this.column = n4;
            } else {
                this.column += n4;
            }
            int n5 = n2 - this.readBufferPos;
            if (n5 != 0) {
                if (bl) {
                    this.handler.ignorableWhitespace(this.readBuffer, this.readBufferPos, n5);
                } else {
                    this.handler.charData(this.readBuffer, this.readBufferPos, n5);
                }
                this.readBufferPos = n2;
            }
            if (n != 0) break;
            this.unread(this.readCh());
        }
        if (!bl) {
            this.isDirtyCurrentElement = true;
        }
        if (n != 1) {
            this.error("character data may not contain ']]>'");
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void skipWhitespace() throws SAXException, IOException {
        char c = '\u0000';
        int n = 0;
        block5: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++n;
                    continue block5;
                }
                case '\n': {
                    ++c;
                    n = 0;
                    continue block5;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (c > '\u0000') {
                        this.line += c;
                        this.column = n;
                    } else {
                        this.column += n;
                    }
                    return;
                }
            }
        }
        c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private String readNmtoken(boolean bl) throws SAXException, IOException {
        char c;
        block26: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            c = this.readBuffer[i];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block26;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int n = this.readBufferPos;
                    if (i == n) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, n, i - n);
                }
                default: {
                    if (bl && i == this.readBufferPos) {
                        int n = c & 0xF0;
                        block4 : switch (c & 0xFF00) {
                            case 256: {
                                switch (n) {
                                    case 48: {
                                        if (c != '\u0132' && c != '\u0133' && c != '\u013f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 64: {
                                        if (c != '\u0140' && c != '\u0149') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 192: {
                                        if (c != '\u01c4' && c != '\u01cc') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 240: {
                                        if (c != '\u01f1' && c != '\u01f3') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 176: {
                                        if (c != '\u01f1' && c != '\u01f3') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    default: {
                                        if (c != '\u017f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                }
                                break;
                            }
                            case 4352: {
                                switch (n) {
                                    case 0: {
                                        if (c != '\u1104' && c != '\u1108' && c != '\u110a' && c != '\u110d') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 48: {
                                        if (c != '\u113b' && c != '\u113f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 64: {
                                        if (c != '\u1141' && c != '\u114d' && c != '\u114f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 80: {
                                        if (c != '\u1151' && c != '\u1156') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 96: {
                                        if (c != '\u1162' && c != '\u1164' && c != '\u1166' && c != '\u116b' && c != '\u116f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 176: {
                                        if (c != '\u11b6' && c != '\u11b9' && c != '\u11bb' && c != '\u116f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    default: {
                                        if (c != '\u1174' && c != '\u119f' && c != '\u11ac' && c != '\u11c3' && c != '\u11f1') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                }
                                break;
                            }
                            default: {
                                if (c != '\u0e46' && c != '\u1011' && c != '\u212f' && c != '\u0587' && c != '\u0230') break;
                                this.error("Not a name start character, U+" + Integer.toHexString(c));
                            }
                        }
                    }
                    if (i == this.readBufferPos && bl) {
                        if (Character.isUnicodeIdentifierStart(c) || c == ':' || c == '_') continue block26;
                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                        continue block26;
                    }
                    if (Character.isUnicodeIdentifierPart(c) || c == '-' || c == ':' || c == '_' || c == '.' || XmlParser.isExtender(c)) continue block26;
                    this.error("Not a name character, U+" + Integer.toHexString(c));
                    continue block26;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (bl && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String string = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return string;
                }
            }
            if (!(this.nameBufferPos == 0 && bl || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private String readLiteral(int n) throws SAXException, IOException {
        int n2 = this.line;
        boolean bl = this.expandPE;
        boolean bl2 = this.doReport;
        char c = this.readCh();
        if (c != '\"' && c != '\'') {
            this.error("expected '\"' or \"'\"", c, null);
            return null;
        }
        this.inLiteral = true;
        if ((n & 0x10) != 0) {
            this.expandPE = false;
        }
        this.doReport = false;
        char[] cArray = this.readBuffer;
        try {
            char c2 = this.readCh();
            boolean bl3 = false;
            block8: while (c2 != c || this.readBuffer != cArray) {
                switch (c2) {
                    case '\n': 
                    case '\r': {
                        if ((n & 0x108) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '\t': {
                        if ((n & 8) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '&': {
                        c2 = this.readCh();
                        if (c2 == '#') {
                            if ((n & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                break;
                            }
                            this.parseCharRef(false);
                        } else {
                            this.unread(c2);
                            if ((n & 2) > 0) {
                                this.parseEntityRef(false);
                                if (String.valueOf(this.readBuffer).equals("&#38;")) {
                                    bl3 = true;
                                }
                            } else if ((n & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String string = this.readNmtoken(true);
                                this.require(';');
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(string);
                                this.dataBufferAppend(';');
                            }
                        }
                        c2 = this.readCh();
                        continue block8;
                    }
                    case '<': {
                        if ((n & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                        break;
                    }
                }
                this.dataBufferAppend(c2);
                c2 = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n2 + ')', null, new Character(c).toString());
        }
        this.inLiteral = false;
        this.expandPE = bl;
        this.doReport = bl2;
        if ((n & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private ExternalIdentifiers readExternalIds(boolean bl, boolean bl2) throws Exception {
        ExternalIdentifiers externalIdentifiers = new ExternalIdentifiers();
        int n = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            externalIdentifiers.publicId = this.readLiteral(0x104 | n);
            if (bl) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    externalIdentifiers.systemId = this.readLiteral(n);
                }
            } else {
                this.requireWhitespace();
                externalIdentifiers.systemId = this.readLiteral(n);
            }
            for (int i = 0; i < externalIdentifiers.publicId.length(); ++i) {
                c = externalIdentifiers.publicId.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1) continue;
                this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            externalIdentifiers.systemId = this.readLiteral(n);
        } else if (!bl2) {
            this.error("missing SYSTEM or PUBLIC keyword");
        }
        if (externalIdentifiers.systemId != null) {
            if (externalIdentifiers.systemId.indexOf(35) != -1) {
                this.handler.verror("SYSTEM id has a URI fragment: " + externalIdentifiers.systemId);
            }
            externalIdentifiers.baseUri = this.handler.getSystemId();
            if (externalIdentifiers.baseUri == null && uriWarnings) {
                this.handler.warn("No base URI; hope URI is absolute: " + externalIdentifiers.systemId);
            }
        }
        return externalIdentifiers;
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String string) {
        this.dataBufferAppend(string.toCharArray(), 0, string.length());
    }

    private void dataBufferAppend(char[] cArray, int n, int n2) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + n2);
        System.arraycopy(cArray, n, this.dataBuffer, this.dataBufferPos, n2);
        this.dataBufferPos += n2;
    }

    private void dataBufferNormalize() {
        int n;
        int n2 = 0;
        int n3 = this.dataBufferPos;
        for (n = 0; n < n3 && this.dataBuffer[n] == ' '; ++n) {
        }
        while (n3 > n && this.dataBuffer[n3 - 1] == ' ') {
            --n3;
        }
        while (n < n3) {
            char c;
            if ((c = this.dataBuffer[n++]) == ' ') {
                while (n < n3 && this.dataBuffer[n++] == ' ') {
                }
                this.dataBuffer[n2++] = 32;
                this.dataBuffer[n2++] = this.dataBuffer[n - 1];
                continue;
            }
            this.dataBuffer[n2++] = c;
        }
        this.dataBufferPos = n2;
    }

    private String dataBufferToString() {
        String string = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return string;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            for (int i = 0; i < this.dataBufferPos; ++i) {
                if (this.isWhitespace(this.dataBuffer[i])) continue;
                this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void require(String string) throws SAXException, IOException {
        char[] cArray;
        int n = string.length();
        if (n < this.dataBuffer.length) {
            cArray = this.dataBuffer;
            string.getChars(0, n, cArray, 0);
        } else {
            cArray = string.toCharArray();
        }
        if (n <= this.readBufferLength - this.readBufferPos) {
            int n2 = this.readBufferPos;
            int n3 = 0;
            while (n3 < n) {
                if (cArray[n3] != this.readBuffer[n2]) {
                    this.error("required string", null, string);
                }
                ++n3;
                ++n2;
            }
            this.readBufferPos = n2;
        } else {
            for (int i = 0; i < n; ++i) {
                this.require(cArray[i]);
            }
        }
    }

    private void require(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 != c) {
            this.error("required character", c2, new Character(c).toString());
        }
    }

    public String intern(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            n4 = 31 * n4 + cArray[i];
        }
        Object[] objectArray = this.symbolTable[n4 = (n4 & Integer.MAX_VALUE) % 2039];
        if (objectArray == null) {
            objectArray = new Object[8];
        } else {
            char[] cArray2;
            while (n3 < objectArray.length && (cArray2 = (char[])objectArray[n3]) != null) {
                if (cArray2.length == n2) {
                    for (int i = 0; i < cArray2.length && cArray[n + i] == cArray2[i]; ++i) {
                        if (i != n2 - 1) continue;
                        return (String)objectArray[n3 + 1];
                    }
                }
                n3 += 2;
            }
            objectArray = (Object[])this.extendArray(objectArray, objectArray.length, n3);
        }
        this.symbolTable[n4] = objectArray;
        String string = new String(cArray, n, n2).intern();
        objectArray[n3] = string.toCharArray();
        objectArray[n3 + 1] = string;
        return string;
    }

    private Object extendArray(Object object, int n, int n2) {
        if (n2 < n) {
            return object;
        }
        Object[] objectArray = null;
        int n3 = n * 2;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        if (object instanceof char[]) {
            objectArray = new char[n3];
        } else if (object instanceof Object[]) {
            objectArray = new Object[n3];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(object, 0, objectArray, 0, n);
        return objectArray;
    }

    boolean isStandalone() {
        return this.docIsStandalone;
    }

    private int getContentType(ElementDecl elementDecl, int n) {
        if (elementDecl == null) {
            return n;
        }
        int n2 = elementDecl.contentType;
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    public int getElementContentType(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementInfo.get(string);
        return this.getContentType(elementDecl, 0);
    }

    private void setElement(String string, int n, String string2, HashMap hashMap) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        ElementDecl elementDecl = (ElementDecl)this.elementInfo.get(string);
        if (elementDecl == null) {
            elementDecl = new ElementDecl();
            elementDecl.contentType = n;
            elementDecl.contentModel = string2;
            elementDecl.attributes = hashMap;
            this.elementInfo.put(string, elementDecl);
            return;
        }
        if (n != 0) {
            if (elementDecl.contentType == 0) {
                elementDecl.contentType = n;
                elementDecl.contentModel = string2;
            } else {
                this.handler.verror("multiple declarations for element type: " + string);
            }
        } else if (hashMap != null) {
            elementDecl.attributes = hashMap;
        }
    }

    private HashMap getElementAttributes(String string) {
        ElementDecl elementDecl = (ElementDecl)this.elementInfo.get(string);
        if (elementDecl == null) {
            return null;
        }
        return elementDecl.attributes;
    }

    private Iterator declaredAttributes(ElementDecl elementDecl) {
        if (elementDecl == null) {
            return null;
        }
        HashMap hashMap = elementDecl.attributes;
        if (hashMap == null) {
            return null;
        }
        return hashMap.keySet().iterator();
    }

    public Iterator declaredAttributes(String string) {
        return this.declaredAttributes((ElementDecl)this.elementInfo.get(string));
    }

    public String getAttributeType(String string, String string2) {
        AttributeDecl attributeDecl = this.getAttribute(string, string2);
        if (attributeDecl == null) {
            return null;
        }
        return attributeDecl.type;
    }

    public String getAttributeEnumeration(String string, String string2) {
        AttributeDecl attributeDecl = this.getAttribute(string, string2);
        if (attributeDecl == null) {
            return null;
        }
        return attributeDecl.enumeration;
    }

    public String getAttributeDefaultValue(String string, String string2) {
        AttributeDecl attributeDecl = this.getAttribute(string, string2);
        if (attributeDecl == null) {
            return null;
        }
        return attributeDecl.value;
    }

    public int getAttributeDefaultValueType(String string, String string2) {
        AttributeDecl attributeDecl = this.getAttribute(string, string2);
        if (attributeDecl == null) {
            return 30;
        }
        return attributeDecl.valueType;
    }

    private void setAttribute(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        if (this.skippedPE) {
            return;
        }
        HashMap hashMap = this.getElementAttributes(string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (hashMap.get(string2) != null) {
            return;
        }
        AttributeDecl attributeDecl = new AttributeDecl();
        attributeDecl.type = string3;
        attributeDecl.value = string5;
        attributeDecl.valueType = n;
        attributeDecl.enumeration = string4;
        hashMap.put(string2, attributeDecl);
        this.setElement(string, 0, null, hashMap);
    }

    private AttributeDecl getAttribute(String string, String string2) {
        HashMap hashMap = this.getElementAttributes(string);
        if (hashMap == null) {
            return null;
        }
        return (AttributeDecl)hashMap.get(string2);
    }

    public int getEntityType(String string) {
        EntityInfo entityInfo = (EntityInfo)this.entityInfo.get(string);
        if (entityInfo == null) {
            return 0;
        }
        return entityInfo.type;
    }

    public ExternalIdentifiers getEntityIds(String string) {
        EntityInfo entityInfo = (EntityInfo)this.entityInfo.get(string);
        if (entityInfo == null) {
            return null;
        }
        return entityInfo.ids;
    }

    public String getEntityValue(String string) {
        EntityInfo entityInfo = (EntityInfo)this.entityInfo.get(string);
        if (entityInfo == null) {
            return null;
        }
        return entityInfo.value;
    }

    private void setInternalEntity(String string, String string2) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        if (this.entityInfo.get(string) == null) {
            EntityInfo entityInfo = new EntityInfo();
            entityInfo.type = 1;
            entityInfo.value = string2;
            this.entityInfo.put(string, entityInfo);
        }
        if (this.handler.stringInterning ? "lt" == string || "gt" == string || "quot" == string || "apos" == string || "amp" == string : "lt".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string) || "amp".equals(string)) {
            return;
        }
        this.handler.getDeclHandler().internalEntityDecl(string, string2);
    }

    private void setExternalEntity(String string, int n, ExternalIdentifiers externalIdentifiers, String string2) {
        if (this.entityInfo.get(string) == null) {
            EntityInfo entityInfo = new EntityInfo();
            entityInfo.type = n;
            entityInfo.ids = externalIdentifiers;
            entityInfo.notationName = string2;
            this.entityInfo.put(string, entityInfo);
        }
    }

    private void setNotation(String string, ExternalIdentifiers externalIdentifiers) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        this.handler.notationDecl(string, externalIdentifiers.publicId, externalIdentifiers.systemId, externalIdentifiers.baseUri);
        if (this.notationInfo.get(string) == null) {
            this.notationInfo.put(string, string);
        } else {
            this.handler.verror("Duplicate notation name decl: " + string);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError) {
                        this.error("PE reference within decl in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] cArray, int n) throws SAXException {
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\n') continue;
            --this.line;
            this.column = -1;
        }
        if (n < this.readBufferPos) {
            this.readBufferPos -= n;
        } else {
            this.pushCharArray(null, cArray, 0, n);
        }
    }

    private void pushURL(boolean bl, String string, ExternalIdentifiers externalIdentifiers, Reader reader, InputStream inputStream, String string2, boolean bl2) throws SAXException, IOException {
        boolean bl3;
        String string3;
        InputSource inputSource;
        if (!bl) {
            this.dataBufferFlush();
        }
        this.scratch.setPublicId(externalIdentifiers.publicId);
        this.scratch.setSystemId(externalIdentifiers.systemId);
        if (bl2) {
            inputSource = this.handler.resolveEntity(bl, string, this.scratch, externalIdentifiers.baseUri);
            if (inputSource == null) {
                this.handler.warn("skipping entity: " + string);
                this.handler.skippedEntity(string);
                if (bl) {
                    this.skippedPE = true;
                }
                return;
            }
            string3 = inputSource.getSystemId();
        } else {
            this.scratch.setCharacterStream(reader);
            this.scratch.setByteStream(inputStream);
            this.scratch.setEncoding(string2);
            inputSource = this.scratch;
            string3 = externalIdentifiers.systemId;
            if (this.handler.stringInterning) {
                this.handler.startExternalEntity(string, string3, "[document]" == string);
            } else {
                this.handler.startExternalEntity(string, string3, "[document]".equals(string));
            }
        }
        if (inputSource.getCharacterStream() != null) {
            if (inputSource.getByteStream() != null) {
                this.error("InputSource has two streams!");
            }
            reader = inputSource.getCharacterStream();
        } else if (inputSource.getByteStream() != null) {
            string2 = inputSource.getEncoding();
            if (string2 == null) {
                inputStream = inputSource.getByteStream();
            } else {
                try {
                    reader = new InputStreamReader(inputSource.getByteStream(), string2);
                }
                catch (IOException iOException) {
                    inputStream = inputSource.getByteStream();
                }
            }
        } else if (string3 == null) {
            this.error("InputSource has no URI!");
        }
        this.scratch.setCharacterStream(null);
        this.scratch.setByteStream(null);
        this.scratch.setEncoding(null);
        this.pushInput(string);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.column = 0;
        this.currentByteCount = 0;
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        this.sourceType = 3;
        if (inputStream != null) {
            this.is = inputStream;
        } else {
            URL uRL = new URL(string3);
            this.externalEntity = uRL.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (string2 == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            string2 = this.externalEntity.getContentType();
            int n = string2 == null ? -1 : string2.indexOf("charset");
            if (n < 0) {
                string2 = null;
            } else {
                n = string2.indexOf(59);
                if (n > 0) {
                    string2 = string2.substring(0, n);
                }
                if ((n = string2.indexOf(61, n + 7)) > 0) {
                    if ((n = (string2 = string2.substring(n + 1)).indexOf(40)) > 0) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n = string2.indexOf(34)) > 0) {
                        string2 = string2.substring(n + 1, string2.indexOf(34, n + 2));
                    }
                    string2 = string2.trim();
                } else {
                    this.handler.warn("ignoring illegal MIME attribute: " + string2);
                    string2 = null;
                }
            }
        }
        if (string2 != null) {
            this.encoding = 0;
            this.setupDecoding(string2);
            bl3 = true;
        } else {
            this.detectEncoding();
            bl3 = false;
        }
        try {
            this.tryEncodingDecl(bl3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = unsupportedEncodingException.getMessage();
            try {
                if (this.sourceType != 3) {
                    throw unsupportedEncodingException;
                }
                this.is.reset();
                this.readBufferPos = 0;
                this.readBufferLength = 0;
                this.readBufferOverflow = -1;
                this.line = 1;
                this.column = 0;
                this.currentByteCount = 0;
                this.sourceType = 5;
                this.reader = new InputStreamReader(this.is, string2);
                this.is = null;
                this.tryEncodingDecl(true);
            }
            catch (IOException iOException) {
                this.error("unsupported text encoding", string2, null);
            }
        }
    }

    private String tryEncodingDecl(boolean bl) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(bl);
                }
                return this.parseXMLDecl(bl);
            }
            this.unread('l');
            this.unread('m');
            this.unread('x');
            this.unread('?');
            this.unread('<');
        }
        return null;
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] byArray = new byte[4];
        this.is.mark(4);
        this.is.read(byArray);
        this.is.reset();
        if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(byArray, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.prefetchASCIIEncodingDecl();
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = 1;
            this.is.read();
            this.is.read();
            this.is.read();
        } else {
            this.encoding = 1;
        }
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3 && byArray[3] == by4;
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2) {
        return byArray[0] == by && byArray[1] == by2;
    }

    private void pushString(String string, String string2) throws SAXException {
        char[] cArray = string2.toCharArray();
        this.pushCharArray(string, cArray, 0, cArray.length);
    }

    private void pushCharArray(String string, char[] cArray, int n, int n2) throws SAXException {
        this.pushInput(string);
        if (string != null && this.doReport) {
            this.dataBufferFlush();
            this.handler.startInternalEntity(string);
        }
        this.sourceType = 1;
        this.readBuffer = cArray;
        this.readBufferPos = n;
        this.readBufferLength = n2;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String string) throws SAXException {
        Object object;
        if (string != null) {
            object = this.entityStack.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (string2 == null || string2 != string) continue;
                this.error("recursive reference to entity", string, null);
            }
        }
        this.entityStack.addLast(string);
        if (this.sourceType == 0) {
            return;
        }
        object = new Input();
        ((Input)object).sourceType = this.sourceType;
        ((Input)object).externalEntity = this.externalEntity;
        ((Input)object).readBuffer = this.readBuffer;
        ((Input)object).readBufferPos = this.readBufferPos;
        ((Input)object).readBufferLength = this.readBufferLength;
        ((Input)object).line = this.line;
        ((Input)object).encoding = this.encoding;
        ((Input)object).readBufferOverflow = this.readBufferOverflow;
        ((Input)object).is = this.is;
        ((Input)object).currentByteCount = this.currentByteCount;
        ((Input)object).column = this.column;
        ((Input)object).reader = this.reader;
        this.inputStack.addLast(object);
    }

    private void popInput() throws SAXException, IOException {
        String string = (String)this.entityStack.removeLast();
        if (string != null && this.doReport) {
            this.dataBufferFlush();
        }
        switch (this.sourceType) {
            case 3: {
                this.handler.endExternalEntity(string);
                this.is.close();
                break;
            }
            case 5: {
                this.handler.endExternalEntity(string);
                this.reader.close();
                break;
            }
            case 1: {
                if (string == null || !this.doReport) break;
                this.handler.endInternalEntity(string);
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Input input = (Input)this.inputStack.removeLast();
        this.sourceType = input.sourceType;
        this.externalEntity = input.externalEntity;
        this.readBuffer = input.readBuffer;
        this.readBufferPos = input.readBufferPos;
        this.readBufferLength = input.readBufferLength;
        this.line = input.line;
        this.encoding = input.encoding;
        this.readBufferOverflow = input.readBufferOverflow;
        this.is = input.is;
        this.currentByteCount = input.currentByteCount;
        this.column = input.column;
        this.reader = input.reader;
    }

    private boolean tryRead(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 == c) {
            return true;
        }
        this.unread(c2);
        return false;
    }

    private boolean tryRead(String string) throws SAXException, IOException {
        return this.tryRead(string.toCharArray());
    }

    private boolean tryRead(char[] cArray) throws SAXException, IOException {
        for (int i = 0; i < cArray.length; ++i) {
            char c = this.readCh();
            if (c == cArray[i]) continue;
            this.unread(c);
            if (i != 0) {
                this.unread(cArray, i);
            }
            return false;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void parseUntil(String string) throws SAXException, IOException {
        this.parseUntil(string.toCharArray());
    }

    private void parseUntil(char[] cArray) throws SAXException, IOException {
        int n = this.line;
        try {
            while (!this.tryRead(cArray)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', null, new String(cArray));
        }
    }

    private void prefetchASCIIEncodingDecl() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        this.is.mark(this.readBuffer.length);
        while (true) {
            int n = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)n;
            switch (n) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("file ends before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int n = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = n < 0 ? this.readBufferPos : this.readBufferPos + n;
            if (this.readBufferLength > 0) {
                this.filterCR(n >= 0);
            }
            this.sawCR = false;
            return;
        }
        int n = this.is.read(this.rawReadBuffer, 0, 16384);
        if (n > 0) {
            switch (this.encoding) {
                case 9: {
                    this.copyIso8859_1ReadBuffer(n, '\u0080');
                    break;
                }
                case 1: {
                    this.copyUtf8ReadBuffer(n);
                    break;
                }
                case 2: {
                    this.copyIso8859_1ReadBuffer(n, '\u0000');
                    break;
                }
                case 3: {
                    this.copyUcs2ReadBuffer(n, 8, 0);
                    break;
                }
                case 4: {
                    this.copyUcs2ReadBuffer(n, 0, 8);
                    break;
                }
                case 5: {
                    this.copyUcs4ReadBuffer(n, 24, 16, 8, 0);
                    break;
                }
                case 6: {
                    this.copyUcs4ReadBuffer(n, 0, 8, 16, 24);
                    break;
                }
                case 7: {
                    this.copyUcs4ReadBuffer(n, 16, 24, 0, 8);
                    break;
                }
                case 8: {
                    this.copyUcs4ReadBuffer(n, 8, 0, 24, 16);
                }
            }
        } else {
            this.readBufferLength = this.readBufferPos;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(n >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && n >= 0) {
                this.readDataChunk();
            }
        }
        if (n > 0) {
            this.currentByteCount += n;
        }
    }

    private void filterCR(boolean bl) {
        int n;
        this.readBufferOverflow = -1;
        int n2 = n = this.readBufferPos;
        block3: while (n < this.readBufferLength) {
            switch (this.readBuffer[n]) {
                case '\r': {
                    if (n == this.readBufferLength - 1) {
                        if (bl) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[n2++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[n + 1] == '\n') {
                        ++n;
                    }
                    this.readBuffer[n2] = 10;
                    break;
                }
                default: {
                    this.readBuffer[n2] = this.readBuffer[n];
                }
            }
            ++n2;
            ++n;
        }
        this.readBufferLength = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int n) throws SAXException, IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        char c = '\u0000';
        while (true) {
            block12: {
                byte by;
                block13: {
                    block14: {
                        if (n2 >= n) {
                            this.readBufferLength = n3;
                            return;
                        }
                        if ((by = this.rawReadBuffer[n2++]) >= 0) break block13;
                        if ((by & 0xE0) != 192) break block14;
                        if ((c = (char)((by & 0x1F) << 6 | this.getNextUtf8Byte(n2++, n))) < '\u0080') {
                            this.encodingError("Illegal two byte UTF-8 sequence", c, 0);
                        }
                        if ((c == '\u0085' || c == '\n') && this.sawCR) continue;
                        if (c == '\u0085' && this.xmlVersion == 1) {
                            this.readBuffer[n3++] = 13;
                        }
                        break block12;
                    }
                    if ((by & 0xF0) == 224) {
                        if ((c = (char)((by & 0xF) << 12 | this.getNextUtf8Byte(n2++, n) << 6 | this.getNextUtf8Byte(n2++, n))) == '\u2028' && this.xmlVersion == 1) {
                            this.readBuffer[n3++] = 13;
                            this.sawCR = true;
                            continue;
                        }
                        if (c < '\u0800' || c >= '\ud800' && c <= '\udfff') {
                            this.encodingError("Illegal three byte UTF-8 sequence", c, 0);
                        }
                        break block12;
                    } else {
                        if ((by & 0xF8) == 240) {
                            int n4 = by & 7;
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            if ((n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n)) <= 65535) {
                                this.encodingError("Illegal four byte UTF-8 sequence", n4, 0);
                                break block12;
                            } else {
                                if (n4 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", n4, 0);
                                }
                                this.readBuffer[n3++] = (char)(0xD800 | (n4 -= 65536) >> 10);
                                this.readBuffer[n3++] = (char)(0xDC00 | n4 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("unsupported five or six byte UTF-8 sequence", 0xFF & by, n2);
                        c = '\u0000';
                    }
                    break block12;
                }
                c = (char)by;
            }
            this.readBuffer[n3++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
    }

    private int getNextUtf8Byte(int n, int n2) throws SAXException, IOException {
        int n3;
        if (n < n2) {
            n3 = this.rawReadBuffer[n];
        } else {
            n3 = this.is.read();
            if (n3 == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, n);
            }
        }
        if ((n3 & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", n3, n + 1);
        }
        return n3 & 0x3F;
    }

    private void copyIso8859_1ReadBuffer(int n, char c) throws IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        while (n2 < n) {
            int n4 = (char)this.rawReadBuffer[n2] & 0xFF;
            if ((n4 & c) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(n4));
            }
            if (n4 == 133 && this.xmlVersion == 1) {
                n4 = 13;
            }
            this.readBuffer[n3] = n4;
            if (n4 == 13) {
                this.sawCR = true;
            }
            ++n2;
            ++n3;
        }
        this.readBufferLength = n3;
    }

    private void copyUcs2ReadBuffer(int n, int n2, int n3) throws SAXException {
        int n4 = this.readBufferPos;
        if (n > 0 && n % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, n);
        }
        if (n2 == 0) {
            for (int i = 0; i < n; i += 2) {
                char c = (char)(this.rawReadBuffer[i + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i]);
                this.readBuffer[n4++] = c;
                if (c != '\r') continue;
                this.sawCR = true;
            }
        } else {
            for (int i = 0; i < n; i += 2) {
                char c = (char)(this.rawReadBuffer[i] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i + 1]);
                this.readBuffer[n4++] = c;
                if (c != '\r') continue;
                this.sawCR = true;
            }
        }
        this.readBufferLength = n4;
    }

    private void copyUcs4ReadBuffer(int n, int n2, int n3, int n4, int n5) throws SAXException {
        int n6 = this.readBufferPos;
        if (n > 0 && n % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, n);
        }
        for (int i = 0; i < n; i += 4) {
            int n7 = (this.rawReadBuffer[i] & 0xFF) << (n2 & 0x1F) | (this.rawReadBuffer[i + 1] & 0xFF) << (n3 & 0x1F) | (this.rawReadBuffer[i + 2] & 0xFF) << (n4 & 0x1F) | (this.rawReadBuffer[i + 3] & 0xFF) << (n5 & 0x1F);
            if (n7 < 65535) {
                this.readBuffer[n6++] = (char)n7;
                if (n7 != 13) continue;
                this.sawCR = true;
                continue;
            }
            if (n7 < 0x10FFFF) {
                this.readBuffer[n6++] = (char)(0xD8 | (n7 -= 65536) >> 10 & 0x3FF);
                this.readBuffer[n6++] = (char)(0xDC | n7 & 0x3FF);
                continue;
            }
            this.encodingError("UCS-4 value out of range for Unicode", n7, i);
        }
        this.readBufferLength = n6;
    }

    private void encodingError(String string, int n, int n2) throws SAXException {
        if (n != -1) {
            string = string + " (character code: 0x" + Integer.toHexString(n) + ')';
            this.error(string);
        }
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new HashMap();
        this.entityInfo = new HashMap();
        this.notationInfo = new HashMap();
        this.skippedPE = false;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new LinkedList();
        this.entityStack = new LinkedList();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.scratch = new InputSource();
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.doReport = false;
        this.inCDATA = false;
        this.symbolTable = new Object[2039][];
    }

    static {
        String string = "gnu.xml.aelfred2.XmlParser.uriWarnings";
        GetPropertyAction getPropertyAction = new GetPropertyAction(string);
        uriWarnings = "true".equals(AccessController.doPrivileged(getPropertyAction));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
        startDelimComment = new char[]{'<', '!', '-', '-'};
        endDelimComment = new char[]{'-', '-'};
        startDelimPI = new char[]{'<', '?'};
        endDelimPI = new char[]{'?', '>'};
        endDelimCDATA = new char[]{']', ']', '>'};
    }

    static class Input {
        int sourceType;
        URLConnection externalEntity;
        char[] readBuffer;
        int readBufferPos;
        int readBufferLength;
        int line;
        int encoding;
        int readBufferOverflow;
        InputStream is;
        int currentByteCount;
        int column;
        Reader reader;

        Input() {
        }
    }

    static class ElementDecl {
        int contentType;
        String contentModel;
        HashMap attributes;

        ElementDecl() {
        }
    }

    static class AttributeDecl {
        String type;
        String value;
        int valueType;
        String enumeration;
        String defaultValue;

        AttributeDecl() {
        }
    }

    static class EntityInfo {
        int type;
        ExternalIdentifiers ids;
        String value;
        String notationName;

        EntityInfo() {
        }
    }

    static class ExternalIdentifiers {
        String publicId;
        String systemId;
        String baseUri;

        ExternalIdentifiers() {
        }

        ExternalIdentifiers(String string, String string2, String string3) {
            this.publicId = string;
            this.systemId = string2;
            this.baseUri = string3;
        }
    }
}

