/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenChar;
import java.util.Stack;
import java.util.Vector;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;
    private Vector addition;

    RETokenOneOf(int n, String string, boolean bl, boolean bl2) {
        super(n);
        this.options = new Vector();
        this.negative = bl;
        for (int i = 0; i < string.length(); ++i) {
            this.options.addElement(new RETokenChar(n, string.charAt(i), bl2));
        }
    }

    RETokenOneOf(int n, Vector vector, boolean bl) {
        super(n);
        this.options = vector;
        this.negative = bl;
    }

    RETokenOneOf(int n, Vector vector, Vector vector2, boolean bl) {
        super(n);
        this.options = vector;
        this.addition = vector2;
        this.negative = bl;
    }

    int getMinimumLength() {
        if (this.negative || this.addition != null) {
            return 1;
        }
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.options.size(); ++i) {
            int n2 = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    int getMaximumLength() {
        if (this.negative || this.addition != null) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.options.size(); ++i) {
            int n2 = ((REToken)this.options.elementAt(i)).getMaximumLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        boolean bl;
        boolean bl2;
        REMatch rEMatch2;
        if (this.addition == null) {
            rEMatch2 = rEMatch;
            bl2 = false;
        } else {
            rEMatch2 = (REMatch)rEMatch.clone();
            bl2 = true;
        }
        boolean bl3 = bl = this.negative ? this.matchN(charIndexed, rEMatch2, bl2) : this.matchP(charIndexed, rEMatch2, bl2);
        if (this.addition == null) {
            return bl;
        }
        Stack stack = new Stack();
        stack.push(new Boolean(bl));
        for (int i = 0; i < this.addition.size(); ++i) {
            Object object = this.addition.elementAt(i);
            if (object instanceof REToken) {
                bl = ((REToken)object).match(charIndexed, (REMatch)rEMatch.clone());
                stack.push(new Boolean(bl));
                continue;
            }
            if (object instanceof Boolean) {
                stack.push(object);
                continue;
            }
            if (object.equals("|")) {
                bl = (Boolean)stack.pop();
                bl = (Boolean)stack.pop() != false || bl;
                stack.push(new Boolean(bl));
                continue;
            }
            if (object.equals("&")) {
                bl = (Boolean)stack.pop();
                bl = (Boolean)stack.pop() != false && bl;
                stack.push(new Boolean(bl));
                continue;
            }
            throw new RuntimeException("Invalid object found");
        }
        bl = (Boolean)stack.pop();
        if (bl) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    private boolean matchN(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        if (charIndexed.charAt(rEMatch.index) == '\uffff') {
            return false;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch rEMatch2;
            REToken rEToken = (REToken)this.options.elementAt(i);
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            return false;
        }
        if (bl) {
            return true;
        }
        ++rEMatch.index;
        return this.next(charIndexed, rEMatch);
    }

    private boolean matchP(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        REMatch.REMatchList rEMatchList = new REMatch.REMatchList();
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch rEMatch2;
            REToken rEToken = (REToken)((REToken)this.options.elementAt(i)).clone();
            if (!bl) {
                rEToken.chain(this.next);
                rEToken.setUncle(this.uncle);
                rEToken.subIndex = this.subIndex;
            }
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            if (bl) {
                return true;
            }
            rEMatchList.addTail(rEMatch2);
        }
        if (bl) {
            return false;
        }
        if (rEMatchList.head != null) {
            rEMatch.assignFrom(rEMatchList.head);
            return true;
        }
        return false;
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                stringBuffer.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(stringBuffer);
        }
        stringBuffer.append(this.negative ? (char)']' : ')');
    }
}

