/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenChar
extends REToken {
    private char[] ch = new char[1];
    private boolean insens;

    RETokenChar(int n, char c, boolean bl) {
        super(n);
        this.insens = bl;
        this.ch[0] = this.insens ? Character.toLowerCase(c) : c;
    }

    int getMinimumLength() {
        return this.ch.length;
    }

    int getMaximumLength() {
        return this.ch.length;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        int n = this.ch.length;
        for (int i = 0; i < n; ++i) {
            char c = charIndexed.charAt(rEMatch.index + i);
            if ((this.insens ? Character.toLowerCase(c) : c) == this.ch[i]) continue;
            return false;
        }
        rEMatch.index += n;
        return this.next(charIndexed, rEMatch);
    }

    boolean chain(REToken rEToken) {
        if (rEToken instanceof RETokenChar && ((RETokenChar)rEToken).insens == this.insens) {
            RETokenChar rETokenChar = (RETokenChar)rEToken;
            int n = this.ch.length + rETokenChar.ch.length;
            char[] cArray = new char[n];
            System.arraycopy(this.ch, 0, cArray, 0, this.ch.length);
            System.arraycopy(rETokenChar.ch, 0, cArray, this.ch.length, rETokenChar.ch.length);
            this.ch = cArray;
            return false;
        }
        return super.chain(rEToken);
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.ch);
    }
}

