/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] end;
    REMatch next;
    boolean empty;

    public Object clone() {
        try {
            REMatch rEMatch = (REMatch)super.clone();
            rEMatch.next = null;
            rEMatch.start = (int[])this.start.clone();
            rEMatch.end = (int[])this.end.clone();
            return rEMatch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    void assignFrom(REMatch rEMatch) {
        this.start = rEMatch.start;
        this.end = rEMatch.end;
        this.index = rEMatch.index;
        this.next = rEMatch.next;
    }

    REMatch(int n, int n2, int n3) {
        this.start = new int[n + 1];
        this.end = new int[n + 1];
        this.anchor = n2;
        this.eflags = n3;
        this.clear(n2);
    }

    void finish(CharIndexed charIndexed) {
        int n;
        this.start[0] = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.end[0]; ++n) {
            stringBuffer.append(charIndexed.charAt(n));
        }
        this.matchedText = stringBuffer.toString();
        for (n = 0; n < this.start.length; ++n) {
            if (!(this.start[n] == -1 ^ this.end[n] == -1)) continue;
            this.start[n] = -1;
            this.end[n] = -1;
        }
        this.next = null;
    }

    void clear(int n) {
        this.offset = n;
        this.index = 0;
        for (int i = 0; i < this.start.length; ++i) {
            this.end[i] = -1;
            this.start[i] = -1;
        }
        this.next = null;
    }

    public String toString() {
        return this.matchedText;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int n) {
        if (n >= this.start.length || n < 0) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        if (this.start[n] == -1) {
            return null;
        }
        return this.matchedText.substring(this.start[n], this.end[n]);
    }

    public int getSubStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        if (n2 == -1) {
            return n2;
        }
        return this.offset + n2;
    }

    public int getStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        if (n2 == -1) {
            return n2;
        }
        return this.offset + n2;
    }

    public int getSubEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        if (n2 == -1) {
            return n2;
        }
        return this.offset + n2;
    }

    public int getEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        if (n2 == -1) {
            return n2;
        }
        return this.offset + n2;
    }

    public String substituteInto(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length() - 1; ++n) {
            if (string.charAt(n) == '$' && Character.isDigit(string.charAt(n + 1))) {
                int n2;
                int n3;
                int n4 = Character.digit(string.charAt(++n), 10);
                for (n3 = n + 1; n3 < string.length() && Character.isDigit(string.charAt(n3)) && (n2 = n4 * 10 + Character.digit(string.charAt(n3), 10)) < this.start.length; ++n3) {
                    n4 = n2;
                }
                n = n3 - 1;
                if (n4 >= this.start.length) continue;
                stringBuffer.append(this.toString(n4));
                continue;
            }
            stringBuffer.append(string.charAt(n));
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    static class REMatchList {
        REMatch head = null;
        REMatch tail = null;

        REMatchList() {
        }

        void addTail(REMatch rEMatch) {
            if (this.head == null) {
                this.head = rEMatch;
                this.tail = rEMatch;
            } else {
                this.tail.next = rEMatch;
            }
            while (this.tail.next != null) {
                this.tail = this.tail.next;
            }
        }
    }
}

