/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenEndSub;
import gnu.regexp.RETokenIndependent;
import gnu.regexp.RETokenLookAhead;
import gnu.regexp.RETokenLookBehind;
import gnu.regexp.RETokenNamedProperty;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import gnu.regexp.RETokenWordBoundary;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class RE
extends REToken {
    private static final String VERSION = "1.1.5-dev";
    private static ResourceBundle messages;
    private REToken firstToken;
    private REToken lastToken;
    private int numSubs;
    private int minimumLength;
    private int maximumLength;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;
    public static final int REG_NO_INTERPOLATE = 128;
    public static final int REG_TRY_ENTIRE_MATCH = 256;
    public static final int REG_REPLACE_USE_BACKSLASHESCAPE = 512;

    public static final String version() {
        return VERSION;
    }

    static final String getLocalizedMessage(String string) {
        return messages.getString(string);
    }

    public RE(Object object) throws REException {
        this(object, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n) throws REException {
        this(object, n, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n, RESyntax rESyntax) throws REException {
        this(object, n, rESyntax, 0, 0);
    }

    private RE(REToken rEToken, REToken rEToken2, int n, int n2, int n3, int n4) {
        super(n2);
        this.firstToken = rEToken;
        this.lastToken = rEToken2;
        this.numSubs = n;
        this.minimumLength = n3;
        this.maximumLength = n4;
        this.addToken(new RETokenEndSub(n2));
    }

    private RE(Object object, int n, RESyntax rESyntax, int n2, int n3) throws REException {
        super(n2);
        this.initialize(object, n, rESyntax, n2, n3);
    }

    protected RE() {
        super(0);
    }

    protected void initialize(Object object, int n, RESyntax rESyntax, int n2, int n3) throws REException {
        char[] cArray;
        if (object instanceof String) {
            cArray = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            cArray = (char[])object;
        } else if (object instanceof StringBuffer) {
            cArray = new char[((StringBuffer)object).length()];
            ((StringBuffer)object).getChars(0, cArray.length, cArray, 0);
        } else {
            cArray = object.toString().toCharArray();
        }
        int n4 = cArray.length;
        this.numSubs = 0;
        Vector vector = null;
        this.lastToken = null;
        this.firstToken = null;
        boolean bl = (n & 2) > 0;
        int n5 = 0;
        CharUnit charUnit = new CharUnit();
        IntPair intPair = new IntPair();
        REToken rEToken = null;
        boolean bl2 = false;
        RESyntax rESyntax2 = null;
        int n6 = 0;
        boolean bl3 = false;
        while (n5 < n4) {
            int n7;
            int n8;
            n5 = RE.getCharUnit(cArray, n5, charUnit, bl2);
            if (charUnit.bk) {
                if (charUnit.ch == 'Q') {
                    bl2 = true;
                    continue;
                }
                if (charUnit.ch == 'E') {
                    bl2 = false;
                    continue;
                }
            }
            if (bl2) {
                charUnit.bk = false;
            }
            if ((charUnit.ch == '|' && rESyntax.get(14) ^ (charUnit.bk || bl2) || rESyntax.get(10) && charUnit.ch == '\n' && !charUnit.bk && !bl2) && !rESyntax.get(9)) {
                this.addToken(rEToken);
                RE rE = new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength, this.maximumLength);
                this.minimumLength = 0;
                this.maximumLength = 0;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(rE);
                rEToken = null;
                this.lastToken = null;
                this.firstToken = null;
                continue;
            }
            if (charUnit.ch == '{' && rESyntax.get(8) && rESyntax.get(11) ^ (charUnit.bk || bl2)) {
                int n9 = this.getMinMax(cArray, n5, intPair, rESyntax);
                if (n9 > n5) {
                    if (intPair.first > intPair.second) {
                        throw new REException(RE.getLocalizedMessage("interval.order"), 1, n9);
                    }
                    if (rEToken == null) {
                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n9);
                    }
                    if (rEToken instanceof RETokenRepeated) {
                        throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n9);
                    }
                    if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                        throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n9);
                    }
                    n5 = n9;
                    rEToken = RE.setRepeated(rEToken, intPair.first, intPair.second, n5);
                    continue;
                }
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, charUnit.ch, bl);
                continue;
            }
            if (charUnit.ch == '[' && !charUnit.bk && !bl2) {
                ParseCharClassResult parseCharClassResult = RE.parseCharClass(this.subIndex, cArray, n5, n4, n, rESyntax, 0);
                this.addToken(rEToken);
                rEToken = parseCharClassResult.token;
                n5 = parseCharClassResult.index;
                continue;
            }
            if (charUnit.ch == '(' && rESyntax.get(12) ^ (charUnit.bk || bl2)) {
                int n10;
                int n11;
                int n12;
                int n13;
                boolean bl4 = false;
                n8 = 0;
                n7 = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                if (n5 + 1 < n4 && cArray[n5] == '?') {
                    switch (cArray[n5 + 1]) {
                        case '!': {
                            if (!rESyntax.get(21)) break;
                            bl4 = true;
                            bl7 = true;
                            n7 = 1;
                            n5 += 2;
                            break;
                        }
                        case '=': {
                            if (!rESyntax.get(21)) break;
                            bl4 = true;
                            n7 = 1;
                            n5 += 2;
                            break;
                        }
                        case '<': {
                            if (rESyntax.get(21)) {
                                switch (cArray[++n5 + 1]) {
                                    case '!': {
                                        bl4 = true;
                                        bl8 = true;
                                        bl5 = true;
                                        n5 += 2;
                                        break;
                                    }
                                    case '=': {
                                        bl4 = true;
                                        bl5 = true;
                                        n5 += 2;
                                    }
                                }
                            }
                            break;
                        }
                        case '>': {
                            if (!rESyntax.get(21)) break;
                            bl4 = true;
                            bl6 = true;
                            n5 += 2;
                            break;
                        }
                        case '-': 
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 's': {
                            if (!rESyntax.get(26)) break;
                            n13 = n5 + 1;
                            n12 = -1;
                            RESyntax rESyntax3 = new RESyntax(rESyntax);
                            n11 = n;
                            n10 = 0;
                            block27: while (n13 < n4 && n12 < 0) {
                                switch (cArray[n13]) {
                                    case 'i': {
                                        n11 = n10 != 0 ? (n11 &= 0xFFFFFFFD) : (n11 |= 2);
                                        ++n13;
                                        continue block27;
                                    }
                                    case 'd': {
                                        if (n10 != 0) {
                                            rESyntax3.setLineSeparator(RESyntax.DEFAULT_LINE_SEPARATOR);
                                        } else {
                                            rESyntax3.setLineSeparator("\n");
                                        }
                                        ++n13;
                                        continue block27;
                                    }
                                    case 'm': {
                                        n11 = n10 != 0 ? (n11 &= 0xFFFFFFF7) : (n11 |= 8);
                                        ++n13;
                                        continue block27;
                                    }
                                    case 's': {
                                        n11 = n10 != 0 ? (n11 &= 0xFFFFFFFB) : (n11 |= 4);
                                        ++n13;
                                        continue block27;
                                    }
                                    case '-': {
                                        n10 = 1;
                                        ++n13;
                                        continue block27;
                                    }
                                    case ')': 
                                    case ':': {
                                        n12 = cArray[n13];
                                        continue block27;
                                    }
                                }
                                throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                            }
                            if (n12 == 41) {
                                rESyntax = rESyntax3;
                                n = n11;
                                bl = (n & 2) > 0;
                                n8 = 1;
                                n5 = n13 - 1;
                                break;
                            }
                            if (n12 == 58) {
                                rESyntax2 = rESyntax;
                                n6 = n;
                                bl3 = true;
                                rESyntax = rESyntax3;
                                n = n11;
                                bl = (n & 2) > 0;
                                n5 = n13 - 1;
                            } else {
                                throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, n5);
                            }
                        }
                        case ':': {
                            if (!rESyntax.get(20)) break;
                            bl4 = true;
                            n5 += 2;
                            break;
                        }
                        case '#': {
                            if (!rESyntax.get(23)) break;
                            n8 = 1;
                            break;
                        }
                        default: {
                            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                        }
                    }
                }
                if (n5 >= n4) {
                    throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, n5);
                }
                n13 = n5;
                n12 = n5;
                int n14 = 0;
                while (!((n12 = RE.getCharUnit(cArray, n13, charUnit, false)) <= 0 || n14 == 0 && charUnit.ch == ')' && rESyntax.get(12) ^ (charUnit.bk || bl2))) {
                    n13 = n12;
                    if (n13 >= n4) {
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, n12);
                    }
                    if (charUnit.ch == '[' && !charUnit.bk && !bl2) {
                        n11 = n12;
                        if (n11 < n4 && cArray[n11] == '^') {
                            ++n11;
                        }
                        if (n11 < n4 && cArray[n11] == ']') {
                            ++n11;
                        }
                        n10 = -1;
                        int n15 = 0;
                        block29: while (n11 < n4 && n10 < 0) {
                            switch (cArray[n11++]) {
                                case '\\': {
                                    ++n11;
                                    break;
                                }
                                case '[': {
                                    ++n15;
                                    if (n11 < n4 && cArray[n11] == '^') {
                                        ++n11;
                                    }
                                    if (n11 >= n4 || cArray[n11] != ']') continue block29;
                                    ++n11;
                                    break;
                                }
                                case ']': {
                                    if (n15 == 0) {
                                        n10 = n11;
                                    }
                                    --n15;
                                }
                            }
                        }
                        if (n10 >= 0) {
                            n12 = n10;
                            n13 = n12;
                            if (n13 < n4) continue;
                            throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, n12);
                        }
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, n12);
                    }
                    if (charUnit.ch == '(' && rESyntax.get(12) ^ (charUnit.bk || bl2)) {
                        ++n14;
                        continue;
                    }
                    if (charUnit.ch != ')' || !(rESyntax.get(12) ^ (charUnit.bk || bl2))) continue;
                    --n14;
                }
                if (n8 != 0) {
                    n5 = n12;
                    continue;
                }
                this.addToken(rEToken);
                if (!bl4) {
                    ++this.numSubs;
                }
                n11 = bl4 || n7 != 0 || bl5 || bl6 ? 0 : n3 + this.numSubs;
                rEToken = new RE(String.valueOf(cArray, n5, n13 - n5).toCharArray(), n, rESyntax, n11, n3 + this.numSubs);
                this.numSubs += ((RE)rEToken).getNumSubs();
                if (n7 != 0) {
                    rEToken = new RETokenLookAhead(rEToken, bl7);
                } else if (bl5) {
                    rEToken = new RETokenLookBehind(rEToken, bl8);
                } else if (bl6) {
                    rEToken = new RETokenIndependent(rEToken);
                }
                n5 = n12;
                if (!bl3) continue;
                rESyntax = rESyntax2;
                n = n6;
                bl = (n & 2) > 0;
                bl3 = false;
                continue;
            }
            if (!rESyntax.get(16) && charUnit.ch == ')' && rESyntax.get(12) ^ (charUnit.bk || bl2)) {
                throw new REException(RE.getLocalizedMessage("unmatched.paren"), 7, n5);
            }
            if (charUnit.ch == '^' && !charUnit.bk && !bl2) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenStart(this.subIndex, (n & 8) > 0 ? rESyntax.getLineSeparator() : null));
                continue;
            }
            if (charUnit.ch == '$' && !charUnit.bk && !bl2) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenEnd(this.subIndex, (n & 8) > 0 ? rESyntax.getLineSeparator() : null));
                continue;
            }
            if (charUnit.ch == '.' && !charUnit.bk && !bl2) {
                this.addToken(rEToken);
                rEToken = new RETokenAny(this.subIndex, rESyntax.get(6) || (n & 4) > 0, rESyntax.get(7));
                continue;
            }
            if (charUnit.ch == '*' && !charUnit.bk && !bl2) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 0, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '+' && !rESyntax.get(9) && rESyntax.get(1) ^ true ^ (charUnit.bk || bl2)) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    RETokenRepeated rETokenRepeated = (RETokenRepeated)rEToken;
                    if (rESyntax.get(25) && !rETokenRepeated.isPossessive() && !rETokenRepeated.isStingy()) {
                        rETokenRepeated.makePossessive();
                        continue;
                    }
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 1, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '?' && !rESyntax.get(9) && rESyntax.get(1) ^ true ^ (charUnit.bk || bl2)) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    RETokenRepeated rETokenRepeated = (RETokenRepeated)rEToken;
                    if (rESyntax.get(18) && !rETokenRepeated.isStingy() && !rETokenRepeated.isPossessive()) {
                        rETokenRepeated.makeStingy();
                        continue;
                    }
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 0, 1, n5);
                continue;
            }
            if (charUnit.bk && charUnit.ch == '0' && rESyntax.get(27)) {
                CharExpression charExpression = RE.getCharExpression(cArray, n5 - 2, n4, rESyntax);
                if (charExpression == null) {
                    throw new REException("invalid octal character", 10, n5);
                }
                n5 = n5 - 2 + charExpression.len;
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, charExpression.ch, bl);
                continue;
            }
            if (charUnit.bk && Character.isDigit(charUnit.ch) && !rESyntax.get(13)) {
                this.addToken(rEToken);
                int n16 = n5 - 1;
                n8 = n4;
                for (n7 = n5; n7 < n4; ++n7) {
                    if (Character.isDigit(cArray[n7])) continue;
                    n8 = n7;
                    break;
                }
                n7 = RE.parseInt(cArray, n16, n8 - n16, 10);
                rEToken = new RETokenBackRef(this.subIndex, n7, bl);
                n5 = n8;
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'A' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenStart(this.subIndex, null);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'b' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 3, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == '<') {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 1, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == '>') {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 2, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'B' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 3, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'd' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 4, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'D' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 4, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'n') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\n', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'r') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\r', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 's' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 9, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'S' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 9, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 't') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\t', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'w' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 0, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'W' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 0, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'Z' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenEnd(this.subIndex, null);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'x' && rESyntax.get(28) || charUnit.bk && charUnit.ch == 'u' && rESyntax.get(29)) {
                CharExpression charExpression = RE.getCharExpression(cArray, n5 - 2, n4, rESyntax);
                if (charExpression == null) {
                    throw new REException("invalid hex character", 10, n5);
                }
                n5 = n5 - 2 + charExpression.len;
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, charExpression.ch, bl);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'p' && rESyntax.get(30) || charUnit.bk && charUnit.ch == 'P' && rESyntax.get(30)) {
                NamedProperty namedProperty = RE.getNamedProperty(cArray, n5 - 2, n4);
                if (namedProperty == null) {
                    throw new REException("invalid escape sequence", 10, n5);
                }
                n5 = n5 - 2 + namedProperty.len;
                this.addToken(rEToken);
                rEToken = RE.getRETokenNamedProperty(this.subIndex, namedProperty, bl, n5);
                continue;
            }
            this.addToken(rEToken);
            rEToken = new RETokenChar(this.subIndex, charUnit.ch, bl);
        }
        this.addToken(rEToken);
        if (vector != null) {
            vector.addElement(new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength, this.maximumLength));
            vector.trimToSize();
            this.minimumLength = 0;
            this.maximumLength = 0;
            this.lastToken = null;
            this.firstToken = null;
            this.addToken(new RETokenOneOf(this.subIndex, vector, false));
        } else {
            this.addToken(new RETokenEndSub(this.subIndex));
        }
    }

    private static ParseCharClassResult parseCharClass(int n, char[] cArray, int n2, int n3, int n4, RESyntax rESyntax, int n5) throws REException {
        Object object;
        boolean bl = (n4 & 2) > 0;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl2 = false;
        int n6 = 1;
        boolean bl3 = (n5 & n6) != 0;
        boolean bl4 = false;
        char c = '\u0000';
        boolean bl5 = false;
        if (n2 == n3) {
            throw new REException(RE.getLocalizedMessage("unmatched.bracket"), 4, n2);
        }
        char c2 = cArray[n2];
        if (c2 == '^') {
            bl4 = true;
            if (++n2 == n3) {
                throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n2);
            }
            c2 = cArray[n2];
        }
        if (c2 == ']') {
            c = c2;
            bl5 = true;
            if (++n2 == n3) {
                throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n2);
            }
        }
        while ((c2 = cArray[n2++]) != ']') {
            int n7;
            if (c2 == '-' && bl5) {
                if (n2 == n3) {
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n2);
                }
                c2 = cArray[n2];
                if (c2 == ']') {
                    vector.addElement(new RETokenChar(n, c, bl));
                    c = '-';
                } else {
                    if (c2 == '\\' && rESyntax.get(0)) {
                        object = RE.getCharExpression(cArray, n2, n3, rESyntax);
                        if (object == null) {
                            throw new REException("invalid escape sequence", 10, n2);
                        }
                        c2 = ((CharExpression)object).ch;
                        n2 = n2 + ((CharExpression)object).len - 1;
                    }
                    vector.addElement(new RETokenRange(n, c, c2, bl));
                    c = '\u0000';
                    bl5 = false;
                    ++n2;
                }
            } else if (c2 == '\\' && rESyntax.get(0)) {
                if (n2 == n3) {
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n2);
                }
                int n8 = -1;
                n7 = 0;
                char c3 = '\u0000';
                boolean bl6 = false;
                NamedProperty namedProperty = null;
                if ("dswDSW".indexOf(cArray[n2]) != -1 && rESyntax.get(24)) {
                    switch (cArray[n2]) {
                        case 'D': {
                            n7 = 1;
                        }
                        case 'd': {
                            n8 = 4;
                            break;
                        }
                        case 'S': {
                            n7 = 1;
                        }
                        case 's': {
                            n8 = 9;
                            break;
                        }
                        case 'W': {
                            n7 = 1;
                        }
                        case 'w': {
                            n8 = 0;
                        }
                    }
                }
                if ("pP".indexOf(cArray[n2]) != -1 && rESyntax.get(30)) {
                    namedProperty = RE.getNamedProperty(cArray, n2 - 1, n3);
                    if (namedProperty == null) {
                        throw new REException("invalid escape sequence", 10, n2);
                    }
                    n2 = n2 - 1 + namedProperty.len - 1;
                } else {
                    CharExpression charExpression = RE.getCharExpression(cArray, n2 - 1, n3, rESyntax);
                    if (charExpression == null) {
                        throw new REException("invalid escape sequence", 10, n2);
                    }
                    c3 = charExpression.ch;
                    bl6 = true;
                    n2 = n2 - 1 + charExpression.len - 1;
                }
                if (bl5) {
                    vector.addElement(new RETokenChar(n, c, bl));
                }
                if (n8 != -1) {
                    vector.addElement(new RETokenPOSIX(n, n8, bl, n7 != 0));
                } else if (namedProperty != null) {
                    vector.addElement(RE.getRETokenNamedProperty(n, namedProperty, bl, n2));
                } else if (bl6) {
                    c = c3;
                    bl5 = true;
                } else {
                    c = cArray[n2];
                    bl5 = true;
                }
                ++n2;
            } else if (c2 == '[' && rESyntax.get(2) && n2 < n3 && cArray[n2] == ':') {
                object = new StringBuffer();
                n2 = RE.getPosixSet(cArray, n2 + 1, (StringBuffer)object);
                n7 = RETokenPOSIX.intValue(((StringBuffer)object).toString());
                if (n7 != -1) {
                    vector.addElement(new RETokenPOSIX(n, n7, bl, false));
                }
            } else if (c2 == '[' && rESyntax.get(31)) {
                object = RE.parseCharClass(n, cArray, n2, n3, n4, rESyntax, 0);
                vector2.addElement(((ParseCharClassResult)object).token);
                vector2.addElement("|");
                n2 = ((ParseCharClassResult)object).index;
            } else if (c2 == '&' && rESyntax.get(31) && n2 < n3 && cArray[n2] == '&') {
                if (bl3) {
                    object = new ParseCharClassResult();
                    vector.trimToSize();
                    if (bl2) {
                        vector2.addElement("&");
                    }
                    if (vector2.size() == 0) {
                        vector2 = null;
                    }
                    ((ParseCharClassResult)object).token = new RETokenOneOf(n, vector, vector2, bl4);
                    ((ParseCharClassResult)object).index = n2 - 1;
                    ((ParseCharClassResult)object).returnAtAndOperator = true;
                    return object;
                }
                if (bl2) {
                    vector2.addElement("&");
                }
                vector2.addElement(Boolean.FALSE);
                bl2 = true;
                if (n2 + 1 < n3 && cArray[n2 + 1] != '[') {
                    object = RE.parseCharClass(n, cArray, n2 + 1, n3, n4, rESyntax, n6);
                    vector2.addElement(((ParseCharClassResult)object).token);
                    vector2.addElement("|");
                    n2 = ((ParseCharClassResult)object).returnAtAndOperator ? ((ParseCharClassResult)object).index : ((ParseCharClassResult)object).index - 1;
                }
            } else {
                if (bl5) {
                    vector.addElement(new RETokenChar(n, c, bl));
                }
                c = c2;
                bl5 = true;
            }
            if (n2 != n3) continue;
            throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n2);
        }
        if (bl5) {
            vector.addElement(new RETokenChar(n, c, bl));
        }
        object = new ParseCharClassResult();
        vector.trimToSize();
        if (bl2) {
            vector2.addElement("&");
        }
        if (vector2.size() == 0) {
            vector2 = null;
        }
        ((ParseCharClassResult)object).token = new RETokenOneOf(n, vector, vector2, bl4);
        ((ParseCharClassResult)object).index = n2;
        return object;
    }

    private static int getCharUnit(char[] cArray, int n, CharUnit charUnit, boolean bl) throws REException {
        charUnit.ch = cArray[n++];
        boolean bl2 = charUnit.bk = charUnit.ch == '\\' && (!bl || n >= cArray.length || cArray[n] == 'E');
        if (charUnit.bk) {
            if (n < cArray.length) {
                charUnit.ch = cArray[n++];
            } else {
                throw new REException(RE.getLocalizedMessage("ends.with.backslash"), 10, n);
            }
        }
        return n;
    }

    private static int parseInt(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            n4 = n4 * n3 + Character.digit(cArray[i], n3);
        }
        return n4;
    }

    private static CharExpression getCharExpression(char[] cArray, int n, int n2, RESyntax rESyntax) {
        CharExpression charExpression = new CharExpression();
        char c = cArray[n];
        if (c == '\\') {
            if (n + 1 >= n2) {
                return null;
            }
            c = cArray[n + 1];
            switch (c) {
                case 't': {
                    charExpression.ch = (char)9;
                    charExpression.len = 2;
                    break;
                }
                case 'n': {
                    charExpression.ch = (char)10;
                    charExpression.len = 2;
                    break;
                }
                case 'r': {
                    charExpression.ch = (char)13;
                    charExpression.len = 2;
                    break;
                }
                case 'u': 
                case 'x': {
                    if (c == 'x' && rESyntax.get(28) || c == 'u' && rESyntax.get(29)) {
                        int n3 = 0;
                        int n4 = c == 'x' ? 2 : 4;
                        for (int i = n + 2; i < n + 2 + n4 && i < n2 && (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'A' && cArray[i] <= 'F' || cArray[i] >= 'a' && cArray[i] <= 'f'); ++i) {
                            ++n3;
                        }
                        if (n3 != n4) {
                            return null;
                        }
                        charExpression.ch = (char)RE.parseInt(cArray, n + 2, n3, 16);
                        charExpression.len = n3 + 2;
                        break;
                    }
                    charExpression.ch = c;
                    charExpression.len = 2;
                    break;
                }
                case '0': {
                    if (rESyntax.get(27)) {
                        int n5 = 0;
                        for (int i = n + 2; i < n + 2 + 3 && i < n2 && cArray[i] >= '0' && cArray[i] <= '7'; ++i) {
                            ++n5;
                        }
                        if (n5 == 3 && cArray[n + 2] > '3') {
                            --n5;
                        }
                        if (n5 <= 0) {
                            return null;
                        }
                        charExpression.ch = (char)RE.parseInt(cArray, n + 2, n5, 8);
                        charExpression.len = n5 + 2;
                        break;
                    }
                    charExpression.ch = c;
                    charExpression.len = 2;
                    break;
                }
                default: {
                    charExpression.ch = c;
                    charExpression.len = 2;
                    break;
                }
            }
        } else {
            charExpression.ch = cArray[n];
            charExpression.len = 1;
        }
        charExpression.expr = new String(cArray, n, charExpression.len);
        return charExpression;
    }

    private static NamedProperty getNamedProperty(char[] cArray, int n, int n2) {
        NamedProperty namedProperty = new NamedProperty();
        char c = cArray[n];
        if (c == '\\') {
            if (++n >= n2) {
                return null;
            }
            c = cArray[n++];
            switch (c) {
                case 'p': {
                    namedProperty.negate = false;
                    break;
                }
                case 'P': {
                    namedProperty.negate = true;
                    break;
                }
                default: {
                    return null;
                }
            }
            c = cArray[n++];
            if (c == '{') {
                int n3;
                int n4 = -1;
                for (n3 = n; n3 < n2; ++n3) {
                    if (cArray[n3] != '}') continue;
                    n4 = n3;
                    break;
                }
                if (n4 < 0) {
                    return null;
                }
                n3 = n4 - n;
                namedProperty.name = new String(cArray, n, n3);
                namedProperty.len = n3 + 4;
            } else {
                namedProperty.name = new String(cArray, n - 1, 1);
                namedProperty.len = 3;
            }
            return namedProperty;
        }
        return null;
    }

    private static RETokenNamedProperty getRETokenNamedProperty(int n, NamedProperty namedProperty, boolean bl, int n2) throws REException {
        try {
            return new RETokenNamedProperty(n, namedProperty.name, bl, namedProperty.negate);
        }
        catch (REException rEException) {
            REException rEException2 = new REException(rEException.getMessage(), 10, n2);
            rEException2.initCause(rEException);
            throw rEException2;
        }
    }

    public boolean isMatch(Object object) {
        return this.isMatch(object, 0, 0);
    }

    public boolean isMatch(Object object, int n) {
        return this.isMatch(object, n, 0);
    }

    public boolean isMatch(Object object, int n, int n2) {
        return this.isMatchImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private boolean isMatchImpl(CharIndexed charIndexed, int n, int n2) {
        if (this.firstToken == null) {
            return charIndexed.charAt(0) == '\uffff';
        }
        REMatch rEMatch = new REMatch(this.numSubs, n, n2);
        if (this.firstToken.match(charIndexed, rEMatch)) {
            while (rEMatch != null) {
                if (charIndexed.charAt(rEMatch.index) == '\uffff') {
                    return true;
                }
                rEMatch = rEMatch.next;
            }
        }
        return false;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    void setUncle(REToken rEToken) {
        if (this.lastToken != null) {
            this.lastToken.setUncle(rEToken);
        } else {
            super.setUncle(rEToken);
        }
    }

    boolean chain(REToken rEToken) {
        super.chain(rEToken);
        this.setUncle(rEToken);
        return true;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public REMatch[] getAllMatches(Object object) {
        return this.getAllMatches(object, 0, 0);
    }

    public REMatch[] getAllMatches(Object object, int n) {
        return this.getAllMatches(object, n, 0);
    }

    public REMatch[] getAllMatches(Object object, int n, int n2) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private REMatch[] getAllMatchesImpl(CharIndexed charIndexed, int n, int n2) {
        Vector vector = new Vector();
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, null)) != null) {
            vector.addElement(rEMatch);
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                ++n;
                charIndexed.move(1);
            } else {
                charIndexed.move(rEMatch.end[0]);
            }
            if (charIndexed.isValid()) continue;
            break;
        }
        Object[] objectArray = new REMatch[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.firstToken == null) {
            return this.next(charIndexed, rEMatch);
        }
        rEMatch.start[this.subIndex] = rEMatch.index;
        return this.firstToken.match(charIndexed, rEMatch);
    }

    public REMatch getMatch(Object object) {
        return this.getMatch(object, 0, 0);
    }

    public REMatch getMatch(Object object, int n) {
        return this.getMatch(object, n, 0);
    }

    public REMatch getMatch(Object object, int n, int n2) {
        return this.getMatch(object, n, n2, null);
    }

    public REMatch getMatch(Object object, int n, int n2, StringBuffer stringBuffer) {
        return this.getMatchImpl(RE.makeCharIndexed(object, n), n, n2, stringBuffer);
    }

    REMatch getMatchImpl(CharIndexed charIndexed, int n, int n2, StringBuffer stringBuffer) {
        RE rE;
        boolean bl = (n2 & 0x100) != 0;
        RE rE2 = rE = bl ? (RE)this.clone() : this;
        if (bl) {
            rE.chain(new RETokenEnd(0, null));
        }
        REMatch rEMatch = new REMatch(this.numSubs, n, n2);
        do {
            if ((this.minimumLength == 0 || charIndexed.charAt(this.minimumLength - 1) != '\uffff') && rE.match(charIndexed, rEMatch)) {
                REMatch rEMatch2 = rEMatch;
                rEMatch2.end[0] = rEMatch2.index;
                rEMatch2.finish(charIndexed);
                return rEMatch2;
            }
            rEMatch.clear(++n);
            if (stringBuffer == null || charIndexed.charAt(0) == '\uffff') continue;
            stringBuffer.append(charIndexed.charAt(0));
        } while (charIndexed.move(1));
        if (this.minimumLength == 0 && this.match(charIndexed, rEMatch)) {
            rEMatch.finish(charIndexed);
            return rEMatch;
        }
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object object) {
        return this.getMatchEnumeration(object, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n) {
        return this.getMatchEnumeration(object, n, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n, int n2) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(object, n), n, n2);
    }

    public String substitute(Object object, String string) {
        return this.substitute(object, string, 0, 0);
    }

    public String substitute(Object object, String string, int n) {
        return this.substitute(object, string, n, 0);
    }

    public String substitute(Object object, String string, int n, int n2) {
        return this.substituteImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteImpl(CharIndexed charIndexed, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        REMatch rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer);
        if (rEMatch == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(RE.getReplacement(string, rEMatch, n2));
        if (charIndexed.move(rEMatch.end[0])) {
            do {
                stringBuffer.append(charIndexed.charAt(0));
            } while (charIndexed.move(1));
        }
        return stringBuffer.toString();
    }

    public String substituteAll(Object object, String string) {
        return this.substituteAll(object, string, 0, 0);
    }

    public String substituteAll(Object object, String string, int n) {
        return this.substituteAll(object, string, n, 0);
    }

    public String substituteAll(Object object, String string, int n, int n2) {
        return this.substituteAllImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteAllImpl(CharIndexed charIndexed, String string, int n, int n2) {
        REMatch rEMatch;
        StringBuffer stringBuffer = new StringBuffer();
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer)) != null) {
            stringBuffer.append(RE.getReplacement(string, rEMatch, n2));
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                char c = charIndexed.charAt(0);
                if (c != '\uffff') {
                    stringBuffer.append(c);
                }
                charIndexed.move(1);
            } else {
                charIndexed.move(rEMatch.end[0]);
            }
            if (charIndexed.isValid()) continue;
            break;
        }
        return stringBuffer.toString();
    }

    public static String getReplacement(String string, REMatch rEMatch, int n) {
        if ((n & 0x80) > 0) {
            return string;
        }
        if ((n & 0x200) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string.length();
            block4: for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        stringBuffer.append(string.charAt(++i));
                        continue block4;
                    }
                    case '$': {
                        int n3;
                        for (n3 = i + 1; n3 < string.length() && Character.isDigit(string.charAt(n3)); ++n3) {
                        }
                        stringBuffer.append(rEMatch.substituteInto(string.substring(i, n3)));
                        i = n3 - 1;
                        continue block4;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }
        return rEMatch.substituteInto(string);
    }

    private void addToken(REToken rEToken) {
        if (rEToken == null) {
            return;
        }
        this.minimumLength += rEToken.getMinimumLength();
        int n = rEToken.getMaximumLength();
        this.maximumLength = n < Integer.MAX_VALUE && this.maximumLength < Integer.MAX_VALUE ? (this.maximumLength += n) : Integer.MAX_VALUE;
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
        } else if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    private static REToken setRepeated(REToken rEToken, int n, int n2, int n3) throws REException {
        if (rEToken == null) {
            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n3);
        }
        return new RETokenRepeated(rEToken.subIndex, rEToken, n, n2);
    }

    private static int getPosixSet(char[] cArray, int n, StringBuffer stringBuffer) {
        for (int i = n; i < cArray.length - 1; ++i) {
            if (cArray[i] == ':' && cArray[i + 1] == ']') {
                return i + 2;
            }
            stringBuffer.append(cArray[i]);
        }
        return n;
    }

    private int getMinMax(char[] cArray, int n, IntPair intPair, RESyntax rESyntax) throws REException {
        boolean bl = rESyntax.get(11) ^ true;
        int n2 = n;
        if (n == cArray.length) {
            if (bl) {
                throw new REException(RE.getLocalizedMessage("unmatched.brace"), 3, n);
            }
            return n2;
        }
        int n3 = 0;
        CharUnit charUnit = new CharUnit();
        StringBuffer stringBuffer = new StringBuffer();
        do {
            n = RE.getCharUnit(cArray, n, charUnit, false);
            if (!Character.isDigit(charUnit.ch)) continue;
            stringBuffer.append(charUnit.ch);
        } while (n != cArray.length && Character.isDigit(charUnit.ch));
        if (stringBuffer.length() == 0) {
            if (bl) {
                throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
            }
            return n2;
        }
        int n4 = Integer.parseInt(stringBuffer.toString());
        if (charUnit.ch == '}' && rESyntax.get(11) ^ charUnit.bk) {
            n3 = n4;
        } else {
            if (n == cArray.length) {
                if (bl) {
                    throw new REException(RE.getLocalizedMessage("interval.no.end"), 3, n);
                }
                return n2;
            }
            if (charUnit.ch == ',' && !charUnit.bk) {
                stringBuffer = new StringBuffer();
                while ((n = RE.getCharUnit(cArray, n, charUnit, false)) != cArray.length && Character.isDigit(charUnit.ch)) {
                    stringBuffer.append(charUnit.ch);
                }
                if (charUnit.ch != '}' || !(rESyntax.get(11) ^ charUnit.bk)) {
                    if (bl) {
                        throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
                    }
                    return n2;
                }
                n3 = stringBuffer.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(stringBuffer.toString());
            } else {
                if (bl) {
                    throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
                }
                return n2;
            }
        }
        intPair.first = n4;
        intPair.second = n3;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.dump(stringBuffer);
        return stringBuffer.toString();
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        if (this.subIndex == 0) {
            stringBuffer.append("?:");
        }
        if (this.firstToken != null) {
            this.firstToken.dumpAll(stringBuffer);
        }
        stringBuffer.append(')');
    }

    private static CharIndexed makeCharIndexed(Object object, int n) {
        if (object instanceof String) {
            return new CharIndexedString((String)object, n);
        }
        if (object instanceof char[]) {
            return new CharIndexedCharArray((char[])object, n);
        }
        if (object instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)object, n);
        }
        if (object instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)object, n);
        }
        if (object instanceof CharIndexed) {
            return (CharIndexed)object;
        }
        return new CharIndexedString(object.toString(), n);
    }

    static {
        VERSION = VERSION;
        messages = ResourceBundle.getBundle("gnu/regexp/MessagesBundle", Locale.getDefault());
    }

    private static class NamedProperty {
        String name;
        boolean negate;
        int len;

        NamedProperty() {
        }
    }

    private static class CharExpression {
        char ch;
        String expr;
        int len;

        public String toString() {
            return this.expr;
        }

        CharExpression() {
        }
    }

    private static class ParseCharClassResult {
        RETokenOneOf token;
        int index;
        boolean returnAtAndOperator;

        private /* synthetic */ void finit$() {
            this.returnAtAndOperator = false;
        }

        ParseCharClassResult() {
            this.finit$();
        }
    }

    private static final class CharUnit
    implements Serializable {
        public char ch;
        public boolean bk;

        CharUnit() {
        }
    }

    private static final class IntPair
    implements Serializable {
        public int first;
        public int second;

        IntPair() {
        }
    }
}

