/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class BMPInfoHeader {
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;
    public static final int SIZE = 40;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;

    public BMPInfoHeader(ImageInputStream imageInputStream) throws IOException, BMPException {
        byte[] byArray = new byte[40];
        if (imageInputStream.read(byArray) != 40) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        if (n != 40) {
            throw new BMPException("Invalid BITMAPINFOHEADER size: " + n);
        }
        this.biWidth = byteBuffer.getInt();
        this.biHeight = byteBuffer.getInt();
        this.biPlanes = byteBuffer.getShort();
        this.setBitCount(byteBuffer.getShort());
        this.setCompression(byteBuffer.getInt());
        this.biSizeImage = byteBuffer.getInt();
        this.biXPelsPerMeter = byteBuffer.getInt();
        this.biYPelsPerMeter = byteBuffer.getInt();
        this.biClrUsed = byteBuffer.getInt();
        this.biClrImportant = byteBuffer.getInt();
    }

    public void setBitCount(short s) throws BMPException {
        switch (s) {
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                this.biBitCount = s;
                break;
            }
            default: {
                throw new BMPException("Invalid number of bits per pixel: " + s);
            }
        }
    }

    public short getBitCount() {
        return this.biBitCount;
    }

    public void setCompression(int n) throws BMPException {
        switch (n) {
            case 1: {
                if (this.getBitCount() != 8) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = n;
                break;
            }
            case 2: {
                if (this.getBitCount() != 4) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = n;
                break;
            }
            case 0: 
            case 3: {
                this.biCompression = n;
                break;
            }
            default: {
                throw new BMPException("Unknown bitmap compression type.");
            }
        }
    }

    public int getNumberOfPaletteEntries() {
        if (this.biClrUsed == 0) {
            switch (this.biBitCount) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 256;
                }
            }
            return 0;
        }
        return this.biClrUsed;
    }

    public int getCompression() {
        return this.biCompression;
    }

    public Dimension getSize() {
        return new Dimension(this.biWidth, this.biHeight);
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public void setSize(Dimension dimension) {
        this.biWidth = (int)dimension.getWidth();
        this.biHeight = (int)dimension.getHeight();
    }
}

