/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERValue;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;

class GnuRSAPublicKey
implements RSAPublicKey {
    private final RSAPublicKeySpec spec;
    private byte[] encodedKey;

    public GnuRSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        this.spec = rSAPublicKeySpec;
    }

    public BigInteger getModulus() {
        return this.spec.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.spec.getPublicExponent();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new DERValue(2, this.getModulus()));
        arrayList.add(new DERValue(2, this.getPublicExponent()));
        DERValue dERValue = new DERValue(48, arrayList);
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(new DERValue(6, new OID("1.2.840.113549.1.1.1")));
        arrayList2.add(new DERValue(5, null));
        ArrayList arrayList3 = new ArrayList(2);
        arrayList3.add(new DERValue(48, arrayList2));
        arrayList3.add(new DERValue(3, new BitString(dERValue.getEncoded())));
        this.encodedKey = new DERValue(48, arrayList3).getEncoded();
        return (byte[])this.encodedKey.clone();
    }
}

