/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.DERValue;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;

class GnuRSAPrivateKey
implements RSAPrivateCrtKey {
    private final RSAPrivateCrtKeySpec spec;
    private byte[] encodedKey;

    public GnuRSAPrivateKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        this.spec = rSAPrivateCrtKeySpec;
    }

    public BigInteger getModulus() {
        return this.spec.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.spec.getPrivateExponent();
    }

    public BigInteger getCrtCoefficient() {
        return this.spec.getCrtCoefficient();
    }

    public BigInteger getPrimeExponentP() {
        return this.spec.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return this.spec.getPrimeExponentQ();
    }

    public BigInteger getPrimeP() {
        return this.spec.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return this.spec.getPrimeQ();
    }

    public BigInteger getPublicExponent() {
        return this.spec.getPublicExponent();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        ArrayList arrayList = new ArrayList(9);
        arrayList.add(new DERValue(2, BigInteger.ZERO));
        arrayList.add(new DERValue(2, this.getModulus()));
        arrayList.add(new DERValue(2, this.getPublicExponent()));
        arrayList.add(new DERValue(2, this.getPrivateExponent()));
        arrayList.add(new DERValue(2, this.getPrimeP()));
        arrayList.add(new DERValue(2, this.getPrimeQ()));
        arrayList.add(new DERValue(2, this.getPrimeExponentP()));
        arrayList.add(new DERValue(2, this.getPrimeExponentQ()));
        arrayList.add(new DERValue(2, this.getCrtCoefficient()));
        DERValue dERValue = new DERValue(48, arrayList);
        ArrayList arrayList2 = new ArrayList(3);
        arrayList2.add(new DERValue(2, BigInteger.ZERO));
        ArrayList arrayList3 = new ArrayList(2);
        arrayList3.add(new DERValue(6, new OID("1.2.840.113549.1.1.1")));
        arrayList3.add(new DERValue(5, null));
        arrayList2.add(new DERValue(48, arrayList3));
        arrayList2.add(new DERValue(4, dERValue.getEncoded()));
        this.encodedKey = new DERValue(48, arrayList2).getEncoded();
        return (byte[])this.encodedKey.clone();
    }
}

