/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.provider.GnuDHPublicKey;
import gnu.javax.crypto.GnuDHPrivateKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DiffieHellmanKeyPairGeneratorImpl
extends KeyPairGeneratorSpi {
    private SecureRandom random;
    private DHParameterSpec params;

    public KeyPair generateKeyPair() {
        if (this.params == null || this.random == null) {
            throw new IllegalStateException("not initialized");
        }
        byte[] byArray = new byte[this.params.getP().bitLength() >>> 3];
        this.random.nextBytes(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.params.getG().modPow(bigInteger, this.params.getP());
        GnuDHPublicKey gnuDHPublicKey = new GnuDHPublicKey(this.params, bigInteger2, null);
        GnuDHPrivateKey gnuDHPrivateKey = new GnuDHPrivateKey(bigInteger, this.params);
        return new KeyPair(gnuDHPublicKey, gnuDHPrivateKey);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("key generation without parameters not supported");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new IllegalArgumentException("expecting Diffie-Hellman parameters");
        }
        this.params = (DHParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }
}

