/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.provider.GnuDHPublicKey;
import gnu.javax.crypto.GnuDHPrivateKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanKeyFactoryImpl
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
            return new GnuDHPrivateKey(dHPrivateKeySpec.getX(), new DHParameterSpec(dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG()));
        }
        throw new InvalidKeySpecException();
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
            return new GnuDHPublicKey(new DHParameterSpec(dHPublicKeySpec.getP(), dHPublicKeySpec.getG()), dHPublicKeySpec.getY(), null);
        }
        throw new InvalidKeySpecException();
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DHPrivateKey && DiffieHellmanKeyFactoryImpl.class$("javax.crypto.spec.DHPrivateKeySpec").isAssignableFrom(clazz)) {
            DHParameterSpec dHParameterSpec = ((DHPrivateKey)key).getParams();
            return new DHPrivateKeySpec(((DHPrivateKey)key).getX(), dHParameterSpec.getP(), dHParameterSpec.getG());
        }
        if (key instanceof DHPublicKey && DiffieHellmanKeyFactoryImpl.class$("javax.crypto.spec.DHPublicKeySpec").isAssignableFrom(clazz)) {
            DHParameterSpec dHParameterSpec = ((DHPublicKey)key).getParams();
            return new DHPublicKeySpec(((DHPublicKey)key).getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
        }
        throw new InvalidKeySpecException();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DHPrivateKey) {
            return new GnuDHPrivateKey(((DHPrivateKey)key).getX(), ((DHPrivateKey)key).getParams());
        }
        if (key instanceof DHPublicKey) {
            return new GnuDHPublicKey(((DHPublicKey)key).getParams(), ((DHPublicKey)key).getY(), null);
        }
        throw new InvalidKeyException();
    }
}

