/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;

public class DSASignature
extends SignatureSpi {
    private DSAPublicKey publicKey;
    private DSAPrivateKey privateKey;
    private final MessageDigest digest;
    private final SecureRandom random = new SecureRandom();

    public DSASignature() throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance("SHA1");
    }

    private void init() {
        this.digest.reset();
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (DSAPublicKey)publicKey;
        this.init();
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key");
        }
        this.privateKey = (DSAPrivateKey)privateKey;
        this.init();
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key");
        }
        this.privateKey = (DSAPrivateKey)privateKey;
        this.appRandom = secureRandom;
        this.init();
    }

    public void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    public byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("not initialized for signing");
        }
        try {
            BigInteger bigInteger = this.privateKey.getParams().getG();
            BigInteger bigInteger2 = this.privateKey.getParams().getP();
            BigInteger bigInteger3 = this.privateKey.getParams().getQ();
            BigInteger bigInteger4 = this.privateKey.getX();
            BigInteger bigInteger5 = new BigInteger(159, this.appRandom != null ? this.appRandom : this.random);
            BigInteger bigInteger6 = bigInteger.modPow(bigInteger5, bigInteger2);
            bigInteger6 = bigInteger6.mod(bigInteger3);
            byte[] byArray = this.digest.digest();
            BigInteger bigInteger7 = new BigInteger(1, byArray);
            BigInteger bigInteger8 = bigInteger7.add(bigInteger4.multiply(bigInteger6));
            bigInteger8 = bigInteger8.multiply(bigInteger5.modInverse(bigInteger3)).mod(bigInteger3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(0, new DERValue(2, bigInteger6));
            arrayList.add(1, new DERValue(2, bigInteger8));
            DERWriter.write(byteArrayOutputStream, new DERValue(48, arrayList));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            SignatureException signatureException = new SignatureException();
            signatureException.initCause(iOException);
            throw signatureException;
        }
        catch (ArithmeticException arithmeticException) {
            SignatureException signatureException = new SignatureException();
            signatureException.initCause(arithmeticException);
            throw signatureException;
        }
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        if (byArray2.length > n2) {
            throw new SignatureException("output buffer too short");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            DERReader dERReader = new DERReader(byArray);
            DERValue dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new SignatureException("badly formed signature");
            }
            BigInteger bigInteger = (BigInteger)dERReader.read().getValue();
            BigInteger bigInteger2 = (BigInteger)dERReader.read().getValue();
            BigInteger bigInteger3 = this.publicKey.getParams().getG();
            BigInteger bigInteger4 = this.publicKey.getParams().getP();
            BigInteger bigInteger5 = this.publicKey.getParams().getQ();
            BigInteger bigInteger6 = this.publicKey.getY();
            BigInteger bigInteger7 = bigInteger2.modInverse(bigInteger5);
            byte[] byArray2 = this.digest.digest();
            BigInteger bigInteger8 = new BigInteger(1, byArray2);
            BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(bigInteger5);
            BigInteger bigInteger10 = bigInteger.multiply(bigInteger7).mod(bigInteger5);
            BigInteger bigInteger11 = bigInteger3.modPow(bigInteger9, bigInteger4).multiply(bigInteger6.modPow(bigInteger10, bigInteger4)).mod(bigInteger4).mod(bigInteger5);
            return bigInteger11.equals(bigInteger);
        }
        catch (IOException iOException) {
            SignatureException signatureException = new SignatureException("badly formed signature");
            signatureException.initCause(iOException);
            throw signatureException;
        }
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidParameterException();
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

