/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;

public class DSAParameters
extends AlgorithmParametersSpi {
    private BigInteger q;
    private BigInteger p;
    private BigInteger g;

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.p = dSAParameterSpec.getP();
        this.q = dSAParameterSpec.getQ();
        this.g = dSAParameterSpec.getG();
    }

    public void engineInit(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (dERValue.getValue() != DER.CONSTRUCTED_VALUE) {
            throw new ASN1ParsingException("badly formed parameters");
        }
        try {
            this.p = (BigInteger)dERReader.read().getValue();
            this.q = (BigInteger)dERReader.read().getValue();
            this.g = (BigInteger)dERReader.read().getValue();
        }
        catch (Exception exception) {
            throw new ASN1ParsingException("badly formed parameters");
        }
    }

    public void engineInit(byte[] byArray, String string) throws IOException {
        if (!string.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        this.engineInit(byArray);
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(DSAParameters.class$("java.security.spec.DSAParameterSpec"))) {
            return new DSAParameterSpec(this.p, this.q, this.g);
        }
        throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public byte[] engineGetEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(new DERValue(2, this.p));
        arrayList.add(new DERValue(2, this.q));
        arrayList.add(new DERValue(2, this.g));
        DERWriter.write(byteArrayOutputStream, new DERValue(48, arrayList));
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] engineGetEncoded(String string) throws IOException {
        if (!string.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        return this.engineGetEncoded();
    }

    public String engineToString() {
        return "q: " + this.q + " p: " + this.p + " g: " + this.g;
    }
}

