/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PolicyFile
extends Policy {
    private static final Logger logger = SystemLogger.SYSTEM;
    private static final String DEFAULT_POLICY = SystemProperties.getProperty("java.home") + SystemProperties.getProperty("file.separator") + "lib" + SystemProperties.getProperty("file.separator") + "security" + SystemProperties.getProperty("file.separator") + "java.policy";
    private static final String DEFAULT_USER_POLICY = SystemProperties.getProperty("user.home") + SystemProperties.getProperty("file.separator") + ".java.policy";
    private final Map cs2pc = new HashMap();
    private static final int STATE_BEGIN = 0;
    private static final int STATE_GRANT = 1;
    private static final int STATE_PERMS = 2;

    public PolicyFile() {
        this.refresh();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        Iterator iterator = this.cs2pc.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CodeSource codeSource2 = (CodeSource)entry.getKey();
            if (codeSource2.implies(codeSource)) {
                logger.log((Level)Component.POLICY, "{0} -> {1}", new Object[]{codeSource2, codeSource});
                PermissionCollection permissionCollection = (PermissionCollection)entry.getValue();
                Enumeration enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    permissions.add((Permission)enumeration.nextElement());
                }
                continue;
            }
            logger.log((Level)Component.POLICY, "{0} !-> {1}", new Object[]{codeSource2, codeSource});
        }
        logger.log((Level)Component.POLICY, "returning permissions {0} for {1}", new Object[]{permissions, codeSource});
        return permissions;
    }

    public void refresh() {
        this.cs2pc.clear();
        LinkedList linkedList = new LinkedList();
        try {
            linkedList.add(new File(DEFAULT_POLICY).toURL());
            linkedList.add(new File(DEFAULT_USER_POLICY).toURL());
            AccessController.doPrivileged(new PrivilegedExceptionAction(this, linkedList){
                private /* synthetic */ PolicyFile this$0;
                private /* synthetic */ List val$policyFiles;
                {
                    this.this$0 = policyFile;
                    this.finit$(list2);
                }

                private /* synthetic */ void finit$(List list2) {
                    this.val$policyFiles = list2;
                }

                public Object run() throws Exception {
                    String string = Security.getProperty("policy.allowSystemProperty");
                    if (string == null || Boolean.getBoolean(string)) {
                        String string2 = SystemProperties.getProperty("java.security.policy");
                        logger.log((Level)Component.POLICY, "java.security.policy={0}", string2);
                        if (string2 != null) {
                            boolean bl = string2.startsWith("=");
                            if (bl) {
                                string2 = string2.substring(1);
                            }
                            this.val$policyFiles.clear();
                            this.val$policyFiles.add(new URL(string2));
                            if (bl) {
                                return null;
                            }
                        }
                    }
                    int n = 1;
                    while (true) {
                        String string3 = "policy.url." + n;
                        String string4 = Security.getProperty(string3);
                        logger.log((Level)Component.POLICY, "{0}={1}", new Object[]{string3, string4});
                        if (string4 == null) break;
                        this.val$policyFiles.add(new URL(string4));
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            logger.log((Level)Component.POLICY, "reading policy properties", privilegedActionException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log((Level)Component.POLICY, "setting default policies", malformedURLException);
        }
        logger.log((Level)Component.POLICY, "building policy from URLs {0}", linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            try {
                URL uRL = (URL)iterator.next();
                this.parse(uRL);
            }
            catch (IOException iOException) {
                logger.log((Level)Component.POLICY, "reading policy", iOException);
            }
        }
    }

    public String toString() {
        return super.toString() + " [ " + this.cs2pc.toString() + " ]";
    }

    private void parse(URL uRL) throws IOException {
        int n;
        logger.log((Level)Component.POLICY, "reading policy file from {0}", uRL);
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(uRL.openStream()));
        streamTokenizer.resetSyntax();
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(12, 12);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.quoteChar(39);
        streamTokenizer.quoteChar(34);
        int n2 = 0;
        LinkedList linkedList = new LinkedList();
        URL uRL2 = null;
        LinkedList linkedList2 = new LinkedList();
        Permissions permissions = new Permissions();
        block26: while ((n = streamTokenizer.nextToken()) != -1) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            switch (n) {
                case 123: {
                    if (n2 != 1) {
                        PolicyFile.error(uRL, streamTokenizer, "spurious '{'");
                    }
                    n2 = 2;
                    n = streamTokenizer.nextToken();
                    break;
                }
                case 125: {
                    if (n2 != 2) {
                        PolicyFile.error(uRL, streamTokenizer, "spurious '}'");
                    }
                    n2 = 0;
                    permissions.setReadOnly();
                    object5 = null;
                    if (!linkedList2.isEmpty()) {
                        object5 = (Certificate[])linkedList2.toArray(new Certificate[linkedList2.size()]);
                    }
                    this.cs2pc.put(new CodeSource(uRL2, (Certificate[])object5), permissions);
                    linkedList2.clear();
                    permissions = new Permissions();
                    uRL2 = null;
                    n = streamTokenizer.nextToken();
                    if (n == 59) continue block26;
                    streamTokenizer.pushBack();
                    continue block26;
                }
            }
            if (n != -3) {
                PolicyFile.error(uRL, streamTokenizer, "expecting word token");
            }
            if (streamTokenizer.sval.equalsIgnoreCase("keystore")) {
                object5 = KeyStore.getDefaultType();
                n = streamTokenizer.nextToken();
                if (n != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting key store URL");
                }
                object4 = streamTokenizer.sval;
                n = streamTokenizer.nextToken();
                if (n == 44) {
                    n = streamTokenizer.nextToken();
                    if (n != 34 && n != 39) {
                        PolicyFile.error(uRL, streamTokenizer, "expecting key store type");
                    }
                    object5 = streamTokenizer.sval;
                    n = streamTokenizer.nextToken();
                }
                if (n != 59) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting semicolon");
                }
                try {
                    object3 = KeyStore.getInstance((String)object5);
                    ((KeyStore)object3).load(new URL(uRL, (String)object4).openStream(), null);
                    linkedList.add(object3);
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("grant")) {
                if (n2 != 0) {
                    PolicyFile.error(uRL, streamTokenizer, "extraneous grant keyword");
                }
                n2 = 1;
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("signedBy")) {
                if (n2 != 1 && n2 != 2) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'signedBy'");
                }
                if (linkedList.isEmpty()) {
                    PolicyFile.error(uRL, streamTokenizer, "'signedBy' with no keystores");
                }
                if ((n = streamTokenizer.nextToken()) != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting signedBy name");
                }
                object5 = new StringTokenizer(streamTokenizer.sval, ",");
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    object4 = ((StringTokenizer)object5).nextToken();
                    object3 = linkedList.iterator();
                    while (object3.hasNext()) {
                        object2 = (KeyStore)object3.next();
                        try {
                            if (!((KeyStore)object2).isCertificateEntry((String)object4)) continue;
                            linkedList2.add(((KeyStore)object2).getCertificate((String)object4));
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                }
                n = streamTokenizer.nextToken();
                if (n == 44) continue;
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious ','");
                }
                streamTokenizer.pushBack();
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("codeBase")) {
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'codeBase'");
                }
                if ((n = streamTokenizer.nextToken()) != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting code base URL");
                }
                object5 = PolicyFile.expand(streamTokenizer.sval);
                if (File.separatorChar != '/') {
                    object5 = ((String)object5).replace(File.separatorChar, '/');
                }
                try {
                    uRL2 = new URL((String)object5);
                }
                catch (MalformedURLException malformedURLException) {
                    PolicyFile.error(uRL, streamTokenizer, malformedURLException.toString());
                }
                if ((n = streamTokenizer.nextToken()) == 44) continue;
                streamTokenizer.pushBack();
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("principal")) {
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'principal'");
                }
                if ((n = streamTokenizer.nextToken()) == -3) {
                    n = streamTokenizer.nextToken();
                    if (n != 34 && n != 39) {
                        PolicyFile.error(uRL, streamTokenizer, "expecting principal name");
                    }
                    object5 = streamTokenizer.sval;
                    object4 = null;
                    try {
                        object3 = Class.forName(streamTokenizer.sval);
                        object2 = ((Class)object3).getConstructor(new Class[]{PolicyFile.class$("java.lang.String")});
                        object4 = (Principal)((Constructor)object2).newInstance(new Object[]{object5});
                    }
                    catch (Exception exception) {
                        PolicyFile.error(uRL, streamTokenizer, exception.toString());
                    }
                    object3 = linkedList.iterator();
                    while (object3.hasNext()) {
                        object2 = (KeyStore)object3.next();
                        try {
                            object = ((KeyStore)object2).aliases();
                            while (object.hasMoreElements()) {
                                Certificate certificate;
                                String string = (String)object.nextElement();
                                if (!((KeyStore)object2).isCertificateEntry(string) || !((certificate = ((KeyStore)object2).getCertificate(string)) instanceof X509Certificate) || !object4.equals(((X509Certificate)certificate).getSubjectDN()) && !object4.equals(((X509Certificate)certificate).getSubjectX500Principal())) continue;
                                linkedList2.add(certificate);
                            }
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                } else if (n == 34 || n == 39) {
                    object5 = streamTokenizer.sval;
                    object4 = linkedList.iterator();
                    while (object4.hasNext()) {
                        object3 = (KeyStore)object4.next();
                        try {
                            if (!((KeyStore)object3).isCertificateEntry((String)object5)) continue;
                            linkedList2.add(((KeyStore)object3).getCertificate((String)object5));
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                } else {
                    PolicyFile.error(uRL, streamTokenizer, "expecting principal");
                }
                if ((n = streamTokenizer.nextToken()) == 44) continue;
                streamTokenizer.pushBack();
                continue;
            }
            if (!streamTokenizer.sval.equalsIgnoreCase("permission")) continue;
            if (n2 != 2) {
                PolicyFile.error(uRL, streamTokenizer, "spurious 'permission'");
            }
            if ((n = streamTokenizer.nextToken()) != -3) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission class name");
            }
            object5 = streamTokenizer.sval;
            object4 = null;
            try {
                object4 = Class.forName((String)object5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            n = streamTokenizer.nextToken();
            if (n == 59) {
                if (object4 == null) {
                    permissions.add(new UnresolvedPermission((String)object5, null, null, (Certificate[])linkedList2.toArray(new Certificate[linkedList2.size()])));
                    continue;
                }
                try {
                    permissions.add((Permission)((Class)object4).newInstance());
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (n != 34 && n != 39) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission target");
            }
            object3 = PolicyFile.expand(streamTokenizer.sval);
            n = streamTokenizer.nextToken();
            if (n == 59) {
                if (object4 == null) {
                    permissions.add(new UnresolvedPermission((String)object5, (String)object3, null, (Certificate[])linkedList2.toArray(new Certificate[linkedList2.size()])));
                    continue;
                }
                try {
                    object2 = ((Class)object4).getConstructor(new Class[]{PolicyFile.class$("java.lang.String")});
                    permissions.add((Permission)((Constructor)object2).newInstance(new Object[]{object3}));
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (n != 44) {
                PolicyFile.error(uRL, streamTokenizer, "expecting ','");
            }
            if ((n = streamTokenizer.nextToken()) == -3) {
                if (!streamTokenizer.sval.equalsIgnoreCase("signedBy")) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting 'signedBy'");
                }
                try {
                    object2 = ((Class)object4).getConstructor(new Class[]{PolicyFile.class$("java.lang.String")});
                    permissions.add((Permission)((Constructor)object2).newInstance(new Object[]{object3}));
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                streamTokenizer.pushBack();
                continue;
            }
            if (n != 34 && n != 39) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission action");
            }
            object2 = streamTokenizer.sval;
            if (object4 == null) {
                permissions.add(new UnresolvedPermission((String)object5, (String)object3, (String)object2, (Certificate[])linkedList2.toArray(new Certificate[linkedList2.size()])));
                continue;
            }
            try {
                object = ((Class)object4).getConstructor(new Class[]{PolicyFile.class$("java.lang.String"), PolicyFile.class$("java.lang.String")});
                permissions.add((Permission)((Constructor)object).newInstance(new Object[]{object3, object2}));
            }
            catch (Exception exception) {
                PolicyFile.error(uRL, streamTokenizer, exception.toString());
            }
            if ((n = streamTokenizer.nextToken()) == 59 || n == 44) continue;
            PolicyFile.error(uRL, streamTokenizer, "expecting ';' or ','");
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String expand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (n) {
                case 0: {
                    if (string.charAt(i) == '$') {
                        n = 1;
                        continue block5;
                    }
                    stringBuffer.append(string.charAt(i));
                    continue block5;
                }
                case 1: {
                    if (string.charAt(i) == '{') {
                        n = 2;
                        continue block5;
                    }
                    n = 0;
                    stringBuffer.append('$').append(string.charAt(i));
                    continue block5;
                }
                case 2: {
                    if (string.charAt(i) == '}') {
                        String string2 = stringBuffer2.toString();
                        if (string2.equals("/")) {
                            string2 = "file.separator";
                        }
                        if ((string2 = System.getProperty(string2)) == null) {
                            string2 = "";
                        }
                        stringBuffer.append(string2);
                        stringBuffer2.setLength(0);
                        n = 0;
                        continue block5;
                    }
                    stringBuffer2.append(string.charAt(i));
                }
            }
        }
        if (n != 0) {
            stringBuffer.append('$').append('{').append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private static void error(URL uRL, StreamTokenizer streamTokenizer, String string) throws IOException {
        throw new IOException(uRL + ":" + streamTokenizer.lineno() + ": " + string);
    }
}

