/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS;

    private Engine() {
    }

    public static Object getInstance(String string, String string2, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(string, string2, provider, NO_ARGS);
    }

    public static Object getInstance(String string, String string2, Provider provider, Object[] objectArray) throws InvocationTargetException, NoSuchAlgorithmException {
        Object object;
        if (string == null || string2 == null || provider == null || objectArray == null) {
            throw new IllegalArgumentException();
        }
        if (provider.getProperty(string + "." + string2) == null) {
            object = null;
            int n = 0;
            while ((object = provider.getProperty(ALG_ALIAS + string + "." + string2)) != null && !string2.equals(object)) {
                string2 = object;
                if (n++ <= 5) continue;
                throw new NoSuchAlgorithmException("too many aliases");
            }
            if (provider.getProperty(string + "." + string2) == null) {
                throw new NoSuchAlgorithmException(string2);
            }
        }
        object = null;
        ClassLoader classLoader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String string3 = string2;
        try {
            object = classLoader != null ? classLoader.loadClass(provider.getProperty(string + "." + string2)) : Class.forName(provider.getProperty(string + "." + string2));
            constructor = Engine.getCompatibleConstructor((Class)object, objectArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string3 = "class not found: " + string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            string3 = "illegal access: " + illegalAccessException.getMessage();
        }
        catch (InstantiationException instantiationException) {
            string3 = "instantiation exception: " + instantiationException.getMessage();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            string3 = "exception in initializer: " + exceptionInInitializerError.getMessage();
        }
        catch (SecurityException securityException) {
            string3 = "security exception: " + securityException.getMessage();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string3 = "no appropriate constructor found";
        }
        throw new NoSuchAlgorithmException(string3);
    }

    private static Constructor getCompatibleConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException {
        Constructor[] constructorArray = clazz.getConstructors();
        block0: for (int i = 0; i < constructorArray.length; ++i) {
            Class[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            for (int j = 0; j < classArray.length; ++j) {
                if (objectArray[j] != null && !classArray[j].isAssignableFrom(objectArray[j].getClass())) continue block0;
            }
            return constructorArray[i];
        }
        throw new NoSuchMethodException();
    }

    static {
        ALG_ALIAS = ALG_ALIAS;
        NO_ARGS = new Object[0];
    }
}

