/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.util.Hashtable;

public class UnicastServerRef
extends UnicastRef
implements ServerRef {
    private static final Class[] stubprototype = new Class[]{UnicastServerRef.class$("java.rmi.server.RemoteRef")};
    Remote myself;
    private Skeleton skel;
    private RemoteStub stub;
    private Hashtable methods;

    private /* synthetic */ void finit$() {
        this.methods = new Hashtable();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    UnicastServerRef() {
        this.finit$();
    }

    public UnicastServerRef(ObjID objID, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(objID);
        this.finit$();
        this.manager = UnicastConnectionManager.getInstance(n, rMIServerSocketFactory);
    }

    public RemoteStub exportObject(Remote remote) throws RemoteException {
        if (this.myself == null) {
            Class clazz;
            this.myself = remote;
            this.manager.serverobj = remote;
            Class clazz2 = remote.getClass();
            try {
                clazz = this.findStubSkelClass(clazz2);
            }
            catch (Exception exception) {
                throw new RemoteException("can not find stubs for class: " + clazz2, exception);
            }
            this.stub = (RemoteStub)this.getHelperClass(clazz, "_Stub");
            if (this.stub == null) {
                throw new RemoteException("failed to export: " + clazz2);
            }
            this.skel = (Skeleton)this.getHelperClass(clazz, "_Skel");
            this.buildMethodHash(remote.getClass(), true);
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        return this.exportObject(remote);
    }

    public RemoteStub getStub() {
        return this.stub;
    }

    public boolean unexportObject(Remote remote, boolean bl) {
        this.buildMethodHash(remote.getClass(), false);
        return UnicastServer.unexportObject(this, bl);
    }

    private Class findStubSkelClass(Class clazz) throws Exception {
        Class clazz2 = clazz;
        while (true) {
            Object object;
            try {
                String string = clazz2.getName() + "_Stub";
                object = clazz2.getClassLoader();
                Class clazz3 = object == null ? Class.forName(string) : ((ClassLoader)object).loadClass(string);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = clazz2.getSuperclass();
                if (object == null || object == UnicastServerRef.class$("java.rmi.server.UnicastRemoteObject")) {
                    throw new Exception("Neither " + clazz + " nor one of their superclasses (like" + clazz2 + ")" + " has a _Stub");
                }
                clazz2 = object;
                continue;
            }
            break;
        }
    }

    private Object getHelperClass(Class clazz, String string) {
        try {
            Class clazz2;
            String string2 = clazz.getName();
            ClassLoader classLoader = clazz.getClassLoader();
            Class clazz3 = clazz2 = classLoader == null ? Class.forName(string2 + string) : classLoader.loadClass(string2 + string);
            if (string.equals("_Stub")) {
                try {
                    Constructor constructor = clazz2.getConstructor(stubprototype);
                    return constructor.newInstance(new Object[]{this});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                RemoteStub remoteStub = (RemoteStub)clazz2.newInstance();
                UnicastRemoteStub.setStubRef(remoteStub, this);
                return remoteStub;
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    private void buildMethodHash(Class clazz, boolean bl) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getDeclaringClass().getName().startsWith("java.")) continue;
            long l = RMIHashes.getMethodHash(methodArray[i]);
            if (bl) {
                this.methods.put(new Long(l), methodArray[i]);
                continue;
            }
            this.methods.remove(new Long(l));
        }
    }

    Class getMethodReturnType(int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            return method.getReturnType();
        }
        return null;
    }

    public Object incomingMessageCall(UnicastConnection unicastConnection, int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            if (method == null) {
                throw new NoSuchMethodException();
            }
            ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
            int n2 = method.getParameterTypes().length;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    objectArray[i] = ((RMIObjectInputStream)objectInputStream).readValue(method.getParameterTypes()[i]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            Object object = null;
            try {
                object = method.invoke(this.myself, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("The remote method threw a java.lang.Throwable that is neither java.lang.Exception nor java.lang.Error.", invocationTargetException);
            }
            return object;
        }
        if (this.skel == null) {
            throw new NoSuchMethodException();
        }
        UnicastRemoteCall unicastRemoteCall = new UnicastRemoteCall(unicastConnection);
        this.skel.dispatch(this.myself, unicastRemoteCall, n, l);
        if (!unicastRemoteCall.isReturnValue()) {
            return RMIVoidValue.INSTANCE;
        }
        return unicastRemoteCall.returnValue();
    }
}

