/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.dgc.DGCImpl;
import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;

public class UnicastServer
implements ProtocolConstants {
    private static Hashtable objects = new Hashtable();
    private static Map refcache = Collections.synchronizedMap(new IdentityHashMap());
    private static DGCImpl dgc;

    public static void exportObject(UnicastServerRef unicastServerRef) {
        UnicastServer.startDGC();
        objects.put(unicastServerRef.objid, unicastServerRef);
        refcache.put(unicastServerRef.myself, unicastServerRef);
        unicastServerRef.manager.startServer();
    }

    public static boolean unexportObject(UnicastServerRef unicastServerRef, boolean bl) {
        objects.remove(unicastServerRef.objid);
        refcache.remove(unicastServerRef.myself);
        unicastServerRef.manager.stopServer();
        return true;
    }

    public static UnicastServerRef getExportedRef(Remote remote) {
        return (UnicastServerRef)refcache.get(remote);
    }

    private static synchronized void startDGC() {
        if (dgc == null) {
            try {
                dgc = new DGCImpl();
                dgc.exportObject(dgc);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public static void dispatch(UnicastConnection unicastConnection) throws Exception {
        switch (unicastConnection.getDataInputStream().readUnsignedByte()) {
            case 80: {
                UnicastServer.incomingMessageCall(unicastConnection);
                break;
            }
            case 82: {
                DataOutputStream dataOutputStream = unicastConnection.getDataOutputStream();
                dataOutputStream.writeByte(83);
                dataOutputStream.flush();
                break;
            }
            default: {
                throw new Exception("bad method type");
            }
        }
    }

    private static void incomingMessageCall(UnicastConnection unicastConnection) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = unicastConnection.startObjectInputStream();
        ObjID objID = ObjID.read(objectInputStream);
        int n = objectInputStream.readInt();
        long l = objectInputStream.readLong();
        UnicastServerRef unicastServerRef = (UnicastServerRef)objects.get(objID);
        int n2 = 1;
        Class clazz = null;
        if (unicastServerRef != null) {
            try {
                object = unicastServerRef.incomingMessageCall(unicastConnection, n, l);
                clazz = unicastServerRef.getMethodReturnType(n, l);
            }
            catch (Exception exception) {
                object = exception;
                n2 = 2;
            }
            catch (Error error) {
                object = new ServerError("An Error is thrown while processing the invocation on the server", error);
                n2 = 2;
            }
        } else {
            object = new NoSuchObjectException("");
            n2 = 2;
        }
        unicastConnection.getDataOutputStream().writeByte(81);
        ObjectOutputStream objectOutputStream = unicastConnection.startObjectOutputStream();
        objectOutputStream.writeByte(n2);
        new UID().write(objectOutputStream);
        if (object != null && clazz != null) {
            ((RMIObjectOutputStream)objectOutputStream).writeValue(object, clazz);
        } else if (!(object instanceof RMIVoidValue) && clazz != Void.TYPE) {
            objectOutputStream.writeObject(object);
        }
        objectOutputStream.flush();
    }
}

