/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    UTF_8() {
        super("UTF-8", new String[]{"ibm-1208", "ibm-1209", "ibm-5304", "ibm-5305", "windows-65001", "cp1208", "UTF8"});
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof UTF_8 || charset instanceof UTF_16BE || charset instanceof UTF_16LE || charset instanceof UTF_16;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block22: {
                CoderResult coderResult2;
                block21: {
                    CoderResult coderResult3;
                    block20: {
                        CoderResult coderResult4;
                        block19: {
                            CoderResult coderResult5;
                            block18: {
                                CoderResult coderResult6;
                                block17: {
                                    CoderResult coderResult7;
                                    block16: {
                                        n = charBuffer.position();
                                        try {
                                            while (charBuffer.hasRemaining()) {
                                                int n2 = byteBuffer.remaining();
                                                char c = charBuffer.get();
                                                if (c <= '\u007f') {
                                                    if (n2 < 1) {
                                                        CoderResult coderResult8 = CoderResult.OVERFLOW;
                                                        Object var8_8 = null;
                                                        charBuffer.position(n);
                                                        return coderResult8;
                                                    } else {
                                                        byteBuffer.put((byte)c);
                                                        ++n;
                                                        continue;
                                                    }
                                                }
                                                if (c <= '\u07ff') {
                                                    if (n2 < 2) {
                                                        coderResult7 = CoderResult.OVERFLOW;
                                                        break block16;
                                                    } else {
                                                        byteBuffer.put((byte)((byte)(c >> 6) | 0xFFFFFFC0));
                                                        byteBuffer.put((byte)((byte)c & 0x3F | 0xFFFFFF80));
                                                        ++n;
                                                        continue;
                                                    }
                                                }
                                                if ('\ud800' <= c && c <= '\udfff') {
                                                    if (n2 < 4) {
                                                        coderResult6 = CoderResult.OVERFLOW;
                                                        break block17;
                                                    }
                                                    if (c > '\udbff') {
                                                        coderResult5 = CoderResult.malformedForLength(1);
                                                        break block18;
                                                    }
                                                    if (!charBuffer.hasRemaining()) {
                                                        coderResult4 = CoderResult.UNDERFLOW;
                                                        break block19;
                                                    }
                                                    char c2 = charBuffer.get();
                                                    if (c2 < '\udc00' || c2 > '\udfff') {
                                                        coderResult3 = CoderResult.malformedForLength(1);
                                                        break block20;
                                                    } else {
                                                        int n3 = ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
                                                        byteBuffer.put((byte)((byte)(n3 >> 18) & 7 | 0xFFFFFFF0));
                                                        byteBuffer.put((byte)((byte)(n3 >> 12) & 0x3F | 0xFFFFFF80));
                                                        byteBuffer.put((byte)((byte)(n3 >> 6) & 0x3F | 0xFFFFFF80));
                                                        byteBuffer.put((byte)((byte)n3 & 0x3F | 0xFFFFFF80));
                                                        n += 2;
                                                        continue;
                                                    }
                                                }
                                                if (n2 < 3) {
                                                    coderResult2 = CoderResult.OVERFLOW;
                                                    break block21;
                                                }
                                                byteBuffer.put((byte)((byte)(c >> 12) | 0xFFFFFFE0));
                                                byteBuffer.put((byte)((byte)(c >> 6) & 0x3F | 0xFFFFFF80));
                                                byteBuffer.put((byte)((byte)c & 0x3F | 0xFFFFFF80));
                                                ++n;
                                            }
                                            coderResult = CoderResult.UNDERFLOW;
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_16 = null;
                                            charBuffer.position(n);
                                            throw throwable;
                                        }
                                    }
                                    Object var8_9 = null;
                                    charBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var8_10 = null;
                                charBuffer.position(n);
                                return coderResult6;
                            }
                            Object var8_11 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var8_12 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var8_13 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var8_14 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var8_15 = null;
            charBuffer.position(n);
            return coderResult;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            block45: {
                CoderResult coderResult2;
                block44: {
                    CoderResult coderResult3;
                    block43: {
                        CoderResult coderResult4;
                        block42: {
                            CoderResult coderResult5;
                            block41: {
                                CoderResult coderResult6;
                                block40: {
                                    CoderResult coderResult7;
                                    block39: {
                                        CoderResult coderResult8;
                                        block38: {
                                            CoderResult coderResult9;
                                            block37: {
                                                CoderResult coderResult10;
                                                block36: {
                                                    CoderResult coderResult11;
                                                    block35: {
                                                        CoderResult coderResult12;
                                                        block34: {
                                                            CoderResult coderResult13;
                                                            block33: {
                                                                CoderResult coderResult14;
                                                                block32: {
                                                                    CoderResult coderResult15;
                                                                    block31: {
                                                                        CoderResult coderResult16;
                                                                        block30: {
                                                                            CoderResult coderResult17;
                                                                            block29: {
                                                                                n = byteBuffer.position();
                                                                                try {
                                                                                    block8: while (byteBuffer.hasRemaining()) {
                                                                                        byte by = byteBuffer.get();
                                                                                        int n2 = (by & 0xFF) >> 4 & 0xF;
                                                                                        switch (n2) {
                                                                                            case 0: 
                                                                                            case 1: 
                                                                                            case 2: 
                                                                                            case 3: 
                                                                                            case 4: 
                                                                                            case 5: 
                                                                                            case 6: 
                                                                                            case 7: {
                                                                                                if (charBuffer.remaining() < 1) {
                                                                                                    CoderResult coderResult18 = CoderResult.OVERFLOW;
                                                                                                    Object var14_31 = null;
                                                                                                    byteBuffer.position(n);
                                                                                                    return coderResult18;
                                                                                                } else {
                                                                                                    charBuffer.put((char)by);
                                                                                                    ++n;
                                                                                                    continue block8;
                                                                                                }
                                                                                            }
                                                                                            case 12: 
                                                                                            case 13: {
                                                                                                if (byteBuffer.remaining() < 1) {
                                                                                                    coderResult17 = CoderResult.UNDERFLOW;
                                                                                                    break block29;
                                                                                                }
                                                                                                if (charBuffer.remaining() < 1) {
                                                                                                    coderResult16 = CoderResult.OVERFLOW;
                                                                                                    break block30;
                                                                                                }
                                                                                                byte by2 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by2)) {
                                                                                                    coderResult15 = CoderResult.malformedForLength(1);
                                                                                                    break block31;
                                                                                                }
                                                                                                char c = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                                                                                                if (c <= '\u007f') {
                                                                                                    coderResult14 = CoderResult.malformedForLength(2);
                                                                                                    break block32;
                                                                                                } else {
                                                                                                    charBuffer.put(c);
                                                                                                    n += 2;
                                                                                                    continue block8;
                                                                                                }
                                                                                            }
                                                                                            case 14: {
                                                                                                if (byteBuffer.remaining() < 2) {
                                                                                                    coderResult13 = CoderResult.UNDERFLOW;
                                                                                                    break block33;
                                                                                                }
                                                                                                if (charBuffer.remaining() < 1) {
                                                                                                    coderResult12 = CoderResult.OVERFLOW;
                                                                                                    break block34;
                                                                                                }
                                                                                                byte by2 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by2)) {
                                                                                                    coderResult11 = CoderResult.malformedForLength(1);
                                                                                                    break block35;
                                                                                                }
                                                                                                byte by3 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by3)) {
                                                                                                    coderResult10 = CoderResult.malformedForLength(1);
                                                                                                    break block36;
                                                                                                }
                                                                                                char c = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                                                                                                if (c <= '\u07ff') {
                                                                                                    coderResult9 = CoderResult.malformedForLength(3);
                                                                                                    break block37;
                                                                                                } else {
                                                                                                    charBuffer.put(c);
                                                                                                    n += 3;
                                                                                                    continue block8;
                                                                                                }
                                                                                            }
                                                                                            case 15: {
                                                                                                if (byteBuffer.remaining() < 3) {
                                                                                                    coderResult8 = CoderResult.UNDERFLOW;
                                                                                                    break block38;
                                                                                                }
                                                                                                if ((by & 0xF) > 4) {
                                                                                                    coderResult7 = CoderResult.malformedForLength(4);
                                                                                                    break block39;
                                                                                                }
                                                                                                if (charBuffer.remaining() < 2) {
                                                                                                    coderResult6 = CoderResult.OVERFLOW;
                                                                                                    break block40;
                                                                                                }
                                                                                                byte by2 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by2)) {
                                                                                                    coderResult5 = CoderResult.malformedForLength(3);
                                                                                                    break block41;
                                                                                                }
                                                                                                byte by3 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by3)) {
                                                                                                    coderResult4 = CoderResult.malformedForLength(2);
                                                                                                    break block42;
                                                                                                }
                                                                                                byte by4 = byteBuffer.get();
                                                                                                if (!Decoder.isContinuation(by4)) {
                                                                                                    coderResult3 = CoderResult.malformedForLength(1);
                                                                                                    break block43;
                                                                                                } else {
                                                                                                    int n3 = ((by & 3) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | by4 & 0x3F) - 65536;
                                                                                                    char c = (char)(0xD800 | (n3 & 0xFFC00) >> 10);
                                                                                                    char c2 = (char)(0xDC00 | n3 & 0x3FF);
                                                                                                    charBuffer.put(c);
                                                                                                    charBuffer.put(c2);
                                                                                                    n += 4;
                                                                                                    continue block8;
                                                                                                }
                                                                                            }
                                                                                            default: {
                                                                                                coderResult2 = CoderResult.malformedForLength(1);
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        break block44;
                                                                                    }
                                                                                    coderResult = CoderResult.UNDERFLOW;
                                                                                    break block45;
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    Object var14_49 = null;
                                                                                    byteBuffer.position(n);
                                                                                    throw throwable;
                                                                                }
                                                                            }
                                                                            Object var14_32 = null;
                                                                            byteBuffer.position(n);
                                                                            return coderResult17;
                                                                        }
                                                                        Object var14_33 = null;
                                                                        byteBuffer.position(n);
                                                                        return coderResult16;
                                                                    }
                                                                    Object var14_34 = null;
                                                                    byteBuffer.position(n);
                                                                    return coderResult15;
                                                                }
                                                                Object var14_35 = null;
                                                                byteBuffer.position(n);
                                                                return coderResult14;
                                                            }
                                                            Object var14_36 = null;
                                                            byteBuffer.position(n);
                                                            return coderResult13;
                                                        }
                                                        Object var14_37 = null;
                                                        byteBuffer.position(n);
                                                        return coderResult12;
                                                    }
                                                    Object var14_38 = null;
                                                    byteBuffer.position(n);
                                                    return coderResult11;
                                                }
                                                Object var14_39 = null;
                                                byteBuffer.position(n);
                                                return coderResult10;
                                            }
                                            Object var14_40 = null;
                                            byteBuffer.position(n);
                                            return coderResult9;
                                        }
                                        Object var14_41 = null;
                                        byteBuffer.position(n);
                                        return coderResult8;
                                    }
                                    Object var14_42 = null;
                                    byteBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var14_43 = null;
                                byteBuffer.position(n);
                                return coderResult6;
                            }
                            Object var14_44 = null;
                            byteBuffer.position(n);
                            return coderResult5;
                        }
                        Object var14_45 = null;
                        byteBuffer.position(n);
                        return coderResult4;
                    }
                    Object var14_46 = null;
                    byteBuffer.position(n);
                    return coderResult3;
                }
                Object var14_47 = null;
                byteBuffer.position(n);
                return coderResult2;
            }
            Object var14_48 = null;
            byteBuffer.position(n);
            return coderResult;
        }

        private static boolean isContinuation(byte by) {
            return (by & 0xC0) == 128;
        }
    }
}

