/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    static final int MAYBE_BIG_ENDIAN = 3;
    static final int MAYBE_LITTLE_ENDIAN = 4;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    UTF_16Decoder(Charset charset, int n) {
        super(charset, 0.5f, 1.0f);
        this.originalByteOrder = n;
        this.byteOrder = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block21: {
            CoderResult coderResult2;
            block20: {
                CoderResult coderResult3;
                block19: {
                    CoderResult coderResult4;
                    block18: {
                        CoderResult coderResult5;
                        block17: {
                            CoderResult coderResult6;
                            block16: {
                                n = byteBuffer.position();
                                try {
                                    while (byteBuffer.remaining() >= 2) {
                                        char c;
                                        byte by = byteBuffer.get();
                                        byte by2 = byteBuffer.get();
                                        if (this.byteOrder == 2 || this.byteOrder == 3 || this.byteOrder == 4) {
                                            char c2 = (char)((by & 0xFF) << 8 | by2 & 0xFF);
                                            if (c2 == '\ufeff') {
                                                if (this.byteOrder == 4) {
                                                    CoderResult coderResult7 = CoderResult.malformedForLength(2);
                                                    Object var12_18 = null;
                                                    byteBuffer.position(n);
                                                    return coderResult7;
                                                } else {
                                                    this.byteOrder = 0;
                                                    n += 2;
                                                    continue;
                                                }
                                            }
                                            if (c2 == '\ufffe') {
                                                if (this.byteOrder == 3) {
                                                    coderResult6 = CoderResult.malformedForLength(2);
                                                    break block16;
                                                } else {
                                                    this.byteOrder = 1;
                                                    n += 2;
                                                    continue;
                                                }
                                            }
                                            this.byteOrder = this.byteOrder == 4 ? 1 : 0;
                                        }
                                        char c3 = c = this.byteOrder == 0 ? (char)((by & 0xFF) << 8 | by2 & 0xFF) : (char)((by2 & 0xFF) << 8 | by & 0xFF);
                                        if ('\ud800' <= c && c <= '\udfff') {
                                            char c4;
                                            if (c > '\udbff') {
                                                coderResult5 = CoderResult.malformedForLength(2);
                                                break block17;
                                            }
                                            if (byteBuffer.remaining() < 2) {
                                                coderResult4 = CoderResult.UNDERFLOW;
                                                break block18;
                                            }
                                            byte by3 = byteBuffer.get();
                                            byte by4 = byteBuffer.get();
                                            char c5 = c4 = this.byteOrder == 0 ? (char)((by3 & 0xFF) << 8 | by4 & 0xFF) : (char)((by4 & 0xFF) << 8 | by3 & 0xFF);
                                            if (c4 < '\udc00' || c4 > '\udfff') {
                                                coderResult3 = CoderResult.malformedForLength(2);
                                                break block19;
                                            } else {
                                                charBuffer.put(c);
                                                charBuffer.put(c4);
                                                n += 4;
                                                continue;
                                            }
                                        }
                                        if (!charBuffer.hasRemaining()) {
                                            coderResult2 = CoderResult.UNDERFLOW;
                                            break block20;
                                        }
                                        charBuffer.put(c);
                                        n += 2;
                                    }
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block21;
                                }
                                catch (Throwable throwable) {
                                    Object var12_25 = null;
                                    byteBuffer.position(n);
                                    throw throwable;
                                }
                            }
                            Object var12_19 = null;
                            byteBuffer.position(n);
                            return coderResult6;
                        }
                        Object var12_20 = null;
                        byteBuffer.position(n);
                        return coderResult5;
                    }
                    Object var12_21 = null;
                    byteBuffer.position(n);
                    return coderResult4;
                }
                Object var12_22 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var12_23 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var12_24 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected void implReset() {
        this.byteOrder = this.originalByteOrder;
    }
}

