/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.VMPipe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

class PipeImpl
extends Pipe {
    private SinkChannelImpl sink;
    private SourceChannelImpl source;

    public PipeImpl(SelectorProvider selectorProvider) throws IOException {
        VMPipe.init(this, selectorProvider);
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public static final class SinkChannelImpl
    extends Pipe.SinkChannel {
        private int native_fd;

        public SinkChannelImpl(SelectorProvider selectorProvider, int n) {
            super(selectorProvider);
            this.native_fd = n;
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected final void implConfigureBlocking(boolean bl) throws IOException {
            throw new Error("Not implemented");
        }

        public final int write(ByteBuffer byteBuffer) throws IOException {
            throw new Error("Not implemented");
        }

        public final long write(ByteBuffer[] byteBufferArray) throws IOException {
            return this.write(byteBufferArray, 0, byteBufferArray.length);
        }

        public final synchronized long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            long l = 0L;
            for (int i = 0; i < n2; ++i) {
                l += (long)this.write(byteBufferArray[n + i]);
            }
            return l;
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }

    public static final class SourceChannelImpl
    extends Pipe.SourceChannel {
        private int native_fd;

        public SourceChannelImpl(SelectorProvider selectorProvider, int n) {
            super(selectorProvider);
            this.native_fd = n;
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected void implConfigureBlocking(boolean bl) throws IOException {
            throw new Error("Not implemented");
        }

        public final int read(ByteBuffer byteBuffer) throws IOException {
            throw new Error("Not implemented");
        }

        public final long read(ByteBuffer[] byteBufferArray) throws IOException {
            return this.read(byteBufferArray, 0, byteBufferArray.length);
        }

        public final synchronized long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            long l = 0L;
            for (int i = 0; i < n2; ++i) {
                l += (long)this.read(byteBufferArray[n + i]);
            }
            return l;
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }
}

