/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public final class Connection
extends JarURLConnection {
    private static Hashtable file_cache = new Hashtable();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", new Locale("En", "Us", "Unix"));
    private JarFile jar_file;
    static HashMap connectionCache = new HashMap();

    protected Connection(URL uRL) throws MalformedURLException {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.getUseCaches()) {
            this.jarFileURLConnection = (URLConnection)connectionCache.get(this.getJarFileURL());
            if (this.jarFileURLConnection == null) {
                this.jarFileURLConnection = this.getJarFileURL().openConnection();
                this.jarFileURLConnection.setUseCaches(true);
                this.jarFileURLConnection.connect();
                connectionCache.put(this.getJarFileURL(), this.jarFileURLConnection);
            }
        } else {
            this.jarFileURLConnection = this.getJarFileURL().openConnection();
            this.jarFileURLConnection.connect();
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (this.getEntryName() == null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.jarFileURLConnection.getInputStream());
            return new JarInputStream(bufferedInputStream);
        }
        JarFile jarFile = null;
        try {
            jarFile = this.getJarFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jarFile != null) {
            ZipEntry zipEntry = jarFile.getEntry(gnu.java.net.protocol.file.Connection.unquote(this.getEntryName()));
            if (zipEntry != null) {
                return jarFile.getInputStream(zipEntry);
            }
        } else {
            JarInputStream jarInputStream = new JarInputStream(this.jarFileURLConnection.getInputStream());
            String string = gnu.java.net.protocol.file.Connection.unquote(this.getEntryName());
            ZipEntry zipEntry = jarInputStream.getNextEntry();
            while (zipEntry != null) {
                if (string.equals(zipEntry.getName())) {
                    int n = (int)zipEntry.getSize();
                    byte[] byArray = new byte[n];
                    jarInputStream.read(byArray, 0, n);
                    return new ByteArrayInputStream(byArray);
                }
                zipEntry = jarInputStream.getNextEntry();
            }
        }
        throw new FileNotFoundException("No entry for \"" + this.getEntryName() + "\" in \"" + this.getJarFileURL() + "\"");
    }

    public synchronized JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarFile if doInput is false");
        }
        if (this.jar_file != null) {
            return this.jar_file;
        }
        URL uRL = this.getJarFileURL();
        if (uRL.getProtocol().equals("file") && uRL.getHost().equals("")) {
            if (this.getUseCaches()) {
                this.jar_file = (JarFile)file_cache.get(uRL);
                if (this.jar_file == null) {
                    this.jar_file = new JarFile(gnu.java.net.protocol.file.Connection.unquote(uRL.getFile()));
                    file_cache.put(uRL, this.jar_file);
                }
            } else {
                this.jar_file = new JarFile(gnu.java.net.protocol.file.Connection.unquote(uRL.getFile()));
            }
        } else {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[4096];
            File file = File.createTempFile("cache", "jar");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            this.jar_file = new JarFile(file, true, 5);
        }
        return this.jar_file;
    }

    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (string.equals("content-type")) {
                return URLConnection.guessContentTypeFromName(this.getJarEntry().getName());
            }
            if (string.equals("content-length")) {
                return Long.toString(this.getJarEntry().getSize());
            }
            if (string.equals("last-modified")) {
                SimpleDateFormat simpleDateFormat = dateFormat;
                synchronized (simpleDateFormat) {
                    try {
                        String string2 = dateFormat.format(new Date(this.getJarEntry().getTime()));
                        Object var4_5 = null;
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string3 = null;
        return string3;
    }

    public int getContentLength() {
        if (!this.connected) {
            return -1;
        }
        try {
            return (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public long getLastModified() {
        if (!this.connected) {
            return -1;
        }
        try {
            return this.getJarEntry().getTime();
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

