/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Authenticator;
import gnu.java.net.protocol.http.ByteArrayRequestBodyWriter;
import gnu.java.net.protocol.http.Credentials;
import gnu.java.net.protocol.http.HTTPConnection;
import gnu.java.net.protocol.http.Headers;
import gnu.java.net.protocol.http.Request;
import gnu.java.net.protocol.http.RequestBodyWriter;
import gnu.java.net.protocol.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HTTPURLConnection
extends HttpsURLConnection
implements HandshakeCompletedListener {
    private static final LinkedHashMap connectionPool = new LinkedHashMap();
    static int maxConnections;
    private HTTPConnection connection;
    String proxyHostname;
    int proxyPort;
    String agent;
    boolean keepAlive;
    private Request request;
    private Headers requestHeaders = new Headers();
    private ByteArrayOutputStream requestSink;
    private boolean requestMethodSetExplicitly;
    private Response response;
    private InputStream responseSink;
    private InputStream errorSink;
    private HandshakeCompletedEvent handshakeEvent;

    public HTTPURLConnection(URL uRL) throws IOException {
        super(uRL);
        AccessController.doPrivileged(new GetHTTPPropertiesAction(this));
    }

    public void connect() throws IOException {
        boolean bl;
        int n;
        if (this.connected) {
            return;
        }
        String string = this.url.getProtocol();
        boolean bl2 = "https".equals(string);
        String string2 = this.url.getHost();
        int n2 = this.url.getPort();
        if (n2 < 0) {
            n2 = bl2 ? 443 : 80;
        }
        Object object = this.url.getFile();
        String string3 = this.url.getUserInfo();
        String string4 = null;
        if (string3 != null && (n = string3.indexOf(58)) != -1) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        Credentials credentials = string3 == null ? null : new Credentials(string3, string4);
        do {
            Object object2;
            Object object3;
            bl = false;
            if (this.connection == null) {
                this.connection = this.getConnection(string2, n2, bl2);
                if (bl2) {
                    object3 = this.getSSLSocketFactory();
                    object2 = this.getHostnameVerifier();
                    if (object3 != null) {
                        this.connection.setSSLSocketFactory((SSLSocketFactory)object3);
                    }
                    this.connection.addHandshakeCompletedListener(this);
                }
            }
            if (this.proxyHostname != null) {
                if (this.proxyPort < 0) {
                    this.proxyPort = bl2 ? 443 : 80;
                }
                this.connection.setProxy(this.proxyHostname, this.proxyPort);
            }
            try {
                this.request = this.connection.newRequest(this.method, (String)object);
                if (!this.keepAlive) {
                    this.request.setHeader("Connection", "close");
                }
                if (this.agent != null) {
                    this.request.setHeader("User-Agent", this.agent);
                }
                this.request.getHeaders().putAll(this.requestHeaders);
                if (this.requestSink != null) {
                    object3 = this.requestSink.toByteArray();
                    object2 = new ByteArrayRequestBodyWriter((byte[])object3);
                    this.request.setRequestBodyWriter((RequestBodyWriter)object2);
                }
                if (credentials != null) {
                    this.request.setAuthenticator(new Authenticator(this, credentials){
                        private /* synthetic */ HTTPURLConnection this$0;
                        private /* synthetic */ Credentials val$creds;
                        {
                            this.this$0 = hTTPURLConnection;
                            this.finit$(credentials);
                        }

                        private /* synthetic */ void finit$(Credentials credentials) {
                            this.val$creds = credentials;
                        }

                        public Credentials getCredentials(String string, int n) {
                            if (n < 2) {
                                return this.val$creds;
                            }
                            return null;
                        }
                    });
                }
                this.response = this.request.dispatch();
            }
            catch (IOException iOException) {
                if (this.connection.useCount > 0) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.connection = null;
                    bl = true;
                    continue;
                }
                throw iOException;
            }
            if (HTTPURLConnection.isRedirect(this.response) && this.getInstanceFollowRedirects()) {
                int n3;
                int n4;
                object3 = this.response.getBody();
                if (object3 != null) {
                    int n5;
                    object2 = new byte[1024];
                    while ((n5 = ((InputStream)object3).read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                    }
                }
                if ((object2 = this.response.getHeader("Location")) == null) continue;
                String string5 = this.connection.getURI();
                int n6 = string5.length();
                if (((String)object2).startsWith(string5) && ((String)object2).charAt(n6) == '/') {
                    object = ((String)object2).substring(n6);
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("http:")) {
                    this.connection.close();
                    this.connection = null;
                    bl2 = false;
                    n6 = 7;
                    n4 = ((String)object2).indexOf(47, n6);
                    if (n4 == -1) {
                        n4 = ((String)object2).length();
                    }
                    if ((n3 = (string2 = ((String)object2).substring(n6, n4)).lastIndexOf(58)) != -1) {
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                        string2 = string2.substring(0, n3);
                    } else {
                        n2 = 80;
                    }
                    object = ((String)object2).substring(n4);
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("https:")) {
                    this.connection.close();
                    this.connection = null;
                    bl2 = true;
                    n6 = 8;
                    n4 = ((String)object2).indexOf(47, n6);
                    if (n4 == -1) {
                        n4 = ((String)object2).length();
                    }
                    if ((n3 = (string2 = ((String)object2).substring(n6, n4)).lastIndexOf(58)) != -1) {
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                        string2 = string2.substring(0, n3);
                    } else {
                        n2 = 443;
                    }
                    object = ((String)object2).substring(n4);
                    bl = true;
                    continue;
                }
                if (((String)object2).length() <= 0) continue;
                if (((String)object2).charAt(0) == '/') {
                    object = object2;
                } else {
                    n4 = ((String)object).lastIndexOf(47);
                    object = n4 == -1 ? "/" : ((String)object).substring(0, n4 + 1);
                    object = (String)object + (String)object2;
                }
                bl = true;
                continue;
            }
            this.responseSink = this.response.getBody();
            if (this.response.getCode() != 404) continue;
            this.errorSink = this.responseSink;
            throw new FileNotFoundException(this.url.toString());
        } while (bl);
        this.connected = true;
    }

    private static boolean isRedirect(Response response) {
        int n = response.getCode();
        return n != 304 && n / 100 == 3;
    }

    HTTPConnection getConnection(String string, int n, boolean bl) throws IOException {
        HTTPConnection hTTPConnection;
        HTTPConnection hTTPConnection2;
        block5: {
            block4: {
                if (!this.keepAlive) break block4;
                Object object = HTTPConnection.getPoolKey(string, n, bl);
                LinkedHashMap linkedHashMap = connectionPool;
                synchronized (linkedHashMap) {
                    block3: {
                        try {
                            hTTPConnection2 = (HTTPConnection)connectionPool.remove(object);
                            if (hTTPConnection2 != null) break block3;
                            hTTPConnection2 = new HTTPConnection(string, n, bl);
                            hTTPConnection2.setPool(connectionPool);
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            throw throwable;
                        }
                    }
                    hTTPConnection = null;
                    break block5;
                }
            }
            hTTPConnection2 = new HTTPConnection(string, n, bl);
        }
        hTTPConnection = hTTPConnection2;
        return hTTPConnection;
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean usingProxy() {
        return this.proxyHostname != null;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        int n = (string = string.toUpperCase()).length();
        if (n == 0) {
            throw new ProtocolException("Empty method name");
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            throw new ProtocolException("Illegal character '" + c + "' at index " + i);
        }
        this.method = string;
        this.requestMethodSetExplicitly = true;
    }

    public String getRequestProperty(String string) {
        return this.requestHeaders.getValue(string);
    }

    public Map getRequestProperties() {
        return this.requestHeaders;
    }

    public void setRequestProperty(String string, String string2) {
        this.requestHeaders.put(string, string2);
    }

    public void addRequestProperty(String string, String string2) {
        String string3 = this.requestHeaders.getValue(string);
        if (string3 == null) {
            this.requestHeaders.put(string, string2);
        } else {
            this.requestHeaders.put(string, string3 + "," + string2);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (!this.doOutput) {
            throw new ProtocolException("doOutput is false");
        }
        if (!this.requestMethodSetExplicitly) {
            this.method = "POST";
        }
        if (this.requestSink == null) {
            this.requestSink = new ByteArrayOutputStream();
        }
        return this.requestSink;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("doInput is false");
        }
        return this.responseSink;
    }

    public InputStream getErrorStream() {
        return this.errorSink;
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        Headers headers = this.response.getHeaders();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put(null, Collections.singletonList(this.getStatusLine(this.response)));
        Iterator iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            linkedHashMap.put(string, Collections.singletonList(string2));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    String getStatusLine(Response response) {
        return "HTTP/" + response.getMajorVersion() + "." + response.getMinorVersion() + " " + response.getCode() + " " + response.getMessage();
    }

    public String getHeaderField(int n) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n == 0) {
            return this.getStatusLine(this.response);
        }
        Iterator iterator = this.response.getHeaders().entrySet().iterator();
        int n2 = 1;
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            entry = (Map.Entry)iterator.next();
        } while (++n2 <= n);
        return (String)entry.getValue();
    }

    public String getHeaderFieldKey(int n) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n == 0) {
            return null;
        }
        Iterator iterator = this.response.getHeaders().entrySet().iterator();
        int n2 = 1;
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            entry = (Map.Entry)iterator.next();
        } while (++n2 <= n);
        return (String)entry.getKey();
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.response.getHeader(string);
    }

    public long getHeaderFieldDate(String string, long l) {
        Date date;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return l;
            }
        }
        if ((date = this.response.getDateHeader(string)) == null) {
            return l;
        }
        return date.getTime();
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getCode();
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getMessage();
    }

    public String getCipherSuite() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getPeerCertificates();
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.handshakeEvent = handshakeCompletedEvent;
    }

    class GetHTTPPropertiesAction
    implements PrivilegedAction {
        private /* synthetic */ HTTPURLConnection this$0;

        public Object run() {
            String string;
            this.this$0.proxyHostname = System.getProperty("http.proxyHost");
            if (this.this$0.proxyHostname != null && this.this$0.proxyHostname.length() > 0) {
                string = System.getProperty("http.proxyPort");
                if (string != null && string.length() > 0) {
                    this.this$0.proxyPort = Integer.parseInt(string);
                } else {
                    this.this$0.proxyHostname = null;
                    this.this$0.proxyPort = -1;
                }
            }
            this.this$0.agent = System.getProperty("http.agent");
            string = System.getProperty("http.keepAlive");
            this.this$0.keepAlive = string == null || !"false".equals(string);
            String string2 = System.getProperty("http.maxConnections");
            maxConnections = string2 != null && string2.length() > 0 ? Math.max(Integer.parseInt(string2), 1) : 5;
            return null;
        }

        GetHTTPPropertiesAction(HTTPURLConnection hTTPURLConnection) {
            this.this$0 = hTTPURLConnection;
        }
    }
}

