/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Headers;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public class ChunkedInputStream
extends FilterInputStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    int size;
    int count;
    boolean meta;
    boolean eof;
    Headers headers;

    public ChunkedInputStream(InputStream inputStream, Headers headers) {
        super(inputStream);
        this.headers = headers;
        this.size = -1;
        this.count = 0;
        this.meta = true;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        int n2 = byArray[0];
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        if (this.eof) {
            return -1;
        }
        if (this.meta) {
            n5 = 0;
            n4 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            do {
                if ((n3 = this.in.read()) == 59) {
                    n4 = 1;
                } else {
                    if (n3 == 10 && n5 == 13) {
                        this.size = Integer.parseInt(stringBuilder.toString(), 16);
                        break;
                    }
                    if (n4 == 0 && n3 >= 48) {
                        stringBuilder.append((char)n3);
                    }
                }
                n5 = n3;
            } while (n3 != -1);
            this.count = 0;
            this.meta = false;
        }
        if (this.size == 0) {
            this.headers.parse(this.in);
            this.eof = true;
            return -1;
        }
        n5 = Math.min(this.size - this.count, n2);
        n3 = this.in.read(byArray, n, n5);
        if (n3 == -1) {
            this.eof = true;
            return -1;
        }
        this.count += n3;
        if (this.count == this.size) {
            n4 = this.in.read();
            int n6 = this.in.read();
            if (n4 == -1 || n6 == -1) {
                this.eof = true;
                return -1;
            }
            if (n4 != 13 || n6 != 10) {
                throw new ProtocolException("expecting CRLF: " + n4 + "," + n6);
            }
            this.meta = true;
        }
        return n3;
    }
}

