/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends FilterInputStream {
    public static final int CR = 13;
    public static final int LF = 10;
    private boolean doReset;

    public CRLFInputStream(InputStream inputStream) {
        super(inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream));
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == 13) {
            this.in.mark(1);
            int n2 = this.in.read();
            if (n2 == 10) {
                n = n2;
            } else {
                this.in.reset();
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.in.mark(n2 + 1);
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            int n4 = this.indexOfCRLF(byArray, n, n3);
            if (this.doReset) {
                this.in.reset();
                if (n4 != -1) {
                    n3 = this.in.read(byArray, n, n4 + 1);
                    this.in.read();
                    byArray[n4] = 10;
                } else {
                    n3 = this.in.read(byArray, n, n2);
                }
            }
        }
        return n3;
    }

    private int indexOfCRLF(byte[] byArray, int n, int n2) throws IOException {
        this.doReset = false;
        int n3 = n2 - 1;
        for (int i = n; i < n2; ++i) {
            int n4;
            if (byArray[i] != 13) continue;
            if (i == n3) {
                n4 = this.in.read();
                this.doReset = true;
            } else {
                n4 = byArray[i + 1];
            }
            if (n4 != 10) continue;
            this.doReset = true;
            return i;
        }
        return -1;
    }
}

