/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;

public class NameFinder {
    private String binaryFile;
    private String sourceFile;
    private int lineNum;
    private HashMap procs;
    private static final boolean use_addr2line = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.use_addr2line", "true"));
    private static final boolean remove_unknown = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.remove_unknown", "true"));

    private /* synthetic */ void finit$() {
        this.procs = new HashMap();
    }

    static final boolean removeUnknown() {
        return remove_unknown;
    }

    public NameFinder() {
        this.finit$();
    }

    public String getSourceFile() {
        String string = this.sourceFile != null ? this.sourceFile : this.binaryFile;
        return string.substring(string.lastIndexOf(File.separator) + 1, string.length());
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void lookup(String string, long l) {
        this.binaryFile = string;
        this.sourceFile = null;
        this.lineNum = -1;
        if (!use_addr2line) {
            return;
        }
        Addr2Line addr2Line = (Addr2Line)this.procs.get(string);
        if (addr2Line == null) {
            addr2Line = new Addr2Line(this, string);
            this.procs.put(string, addr2Line);
        }
        if (addr2Line.proc == null) {
            return;
        }
        String string2 = "0x" + Long.toHexString(l);
        try {
            addr2Line.out.write(string2);
            addr2Line.out.newLine();
            addr2Line.out.flush();
            String string3 = addr2Line.in.readLine();
            if (string3.indexOf("??") == -1) {
                int n = string3.lastIndexOf(58);
                this.sourceFile = string3.substring(0, n);
                String string4 = string3.substring(n + 1, string3.length());
                this.lineNum = Integer.parseInt(string4);
            }
        }
        catch (IOException iOException) {
            addr2Line = null;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static String demangleInterpreterMethod(String string, String string2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n4);
        if (string.startsWith("<init>")) {
            n2 = string2.lastIndexOf(46);
            String string3 = n2 < 0 ? string2 : string2.substring(n2 + 1);
            stringBuffer.append(string3);
            n3 += 7;
        } else {
            n2 = string.indexOf(40);
            if (n2 > 0) {
                stringBuffer.append(string.substring(0, n2));
                n3 += n2 + 1;
            }
        }
        stringBuffer.append('(');
        n2 = 0;
        int n5 = n = n3 < n4 ? (int)string.charAt(n3) : 41;
        while (n != 41) {
            int n6;
            String string4;
            switch (n) {
                case 66: {
                    string4 = "byte";
                    break;
                }
                case 67: {
                    string4 = "char";
                    break;
                }
                case 68: {
                    string4 = "double";
                    break;
                }
                case 70: {
                    string4 = "float";
                    break;
                }
                case 73: {
                    string4 = "int";
                    break;
                }
                case 74: {
                    string4 = "long";
                    break;
                }
                case 83: {
                    string4 = "short";
                    break;
                }
                case 90: {
                    string4 = "boolean";
                    break;
                }
                case 76: {
                    n6 = string.indexOf(59, n3);
                    if (n6 > 0) {
                        string4 = string.substring(n3 + 1, n6);
                        n3 = n6;
                        break;
                    }
                    string4 = "<unknown ref>";
                    break;
                }
                case 91: {
                    string4 = "";
                    ++n2;
                    break;
                }
                default: {
                    string4 = "<unknown " + (char)n + '>';
                }
            }
            stringBuffer.append(string4);
            if (n != 91 && n2 > 0) {
                while (n2 > 0) {
                    stringBuffer.append("[]");
                    --n2;
                }
            }
            int n7 = n6 = ++n3 < n4 ? (int)string.charAt(n3) : 41;
            if (n != 91 && n6 != 41) {
                stringBuffer.append(", ");
            }
            n = n6;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void close() {
        Iterator iterator = this.procs.values().iterator();
        while (iterator.hasNext()) {
            Addr2Line addr2Line = (Addr2Line)iterator.next();
            addr2Line.close();
        }
    }

    class Addr2Line {
        private /* synthetic */ NameFinder this$0;
        Process proc;
        BufferedWriter out;
        BufferedReader in;

        Addr2Line(NameFinder nameFinder, String string) {
            this.this$0 = nameFinder;
            try {
                String[] stringArray = new String[]{"addr2line", "-e", string};
                Runtime runtime = Runtime.getRuntime();
                this.proc = runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.proc != null) {
                this.in = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                this.out = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
            }
        }

        void close() {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.proc != null) {
                this.proc.destroy();
            }
        }
    }
}

