/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.UnicodeToBytes;
import gnu.java.nio.charset.EncodingHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharsetToBytesAdaptor
extends UnicodeToBytes {
    private final CharsetEncoder encoder;
    private ByteBuffer outBuf;
    private boolean closedEncoder;
    private boolean finished;

    public CharsetToBytesAdaptor(Charset charset) {
        this(charset.newEncoder());
    }

    public CharsetToBytesAdaptor(CharsetEncoder charsetEncoder) {
        this.encoder = charsetEncoder;
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public String getName() {
        return EncodingHelper.getOldCanonical(this.encoder.charset().name());
    }

    public int write(char[] cArray, int n, int n2) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        this.write(charBuffer);
        return charBuffer.position() - n;
    }

    public int write(String string, int n, int n2, char c) {
        CharBuffer charBuffer = CharBuffer.wrap(string, n, n2);
        this.write(charBuffer);
        return charBuffer.position() - n;
    }

    private void write(CharBuffer charBuffer) {
        if (this.outBuf == null || !this.outBuf.hasArray() || this.outBuf.array() != this.buf) {
            this.outBuf = ByteBuffer.wrap(this.buf);
        }
        this.outBuf.position(this.count);
        if (this.closedEncoder) {
            CoderResult coderResult = this.encoder.flush(this.outBuf);
            if (coderResult == CoderResult.UNDERFLOW) {
                this.finished = true;
            }
        } else {
            this.closedEncoder = charBuffer.hasRemaining() ^ true;
            this.encoder.encode(charBuffer, this.outBuf, this.closedEncoder);
        }
        this.count = this.outBuf.position();
    }

    public boolean havePendingBytes() {
        return this.finished ^ true;
    }

    public void done() {
    }
}

