/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.ObjectId;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class Location {
    private ClassReferenceTypeId crti;
    private int index;
    private byte tag;
    private ObjectId mid;

    public Location(byte by, Class clazz, Method method, int n) throws JdwpException {
        this.tag = by;
        this.crti = (ClassReferenceTypeId)VMIdManager.getDefault().getReferenceTypeId(clazz);
        this.mid = VMIdManager.getDefault().getObjectId(method);
        this.index = n;
    }

    public Location(ByteBuffer byteBuffer) throws IOException, JdwpException {
        this.tag = byteBuffer.get();
        this.crti = (ClassReferenceTypeId)VMIdManager.getDefault().readReferenceTypeId(byteBuffer);
        this.mid = VMIdManager.getDefault().readObjectId(byteBuffer);
        this.index = byteBuffer.getInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        this.crti.write(dataOutputStream);
        this.mid.write(dataOutputStream);
        dataOutputStream.writeInt(this.index);
    }
}

