/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ThreadGroupReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeName(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeParent(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeChildren(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ThreadGroupReference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeName(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup = (ThreadGroup)objectId.getObject();
        JdwpString.writeString(dataOutputStream, threadGroup.getName());
    }

    private void executeParent(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup = (ThreadGroup)objectId.getObject();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        ObjectId objectId2 = this.idMan.getObjectId(threadGroup2);
        objectId2.write(dataOutputStream);
    }

    private void executeChildren(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadGroup threadGroup;
        int n;
        ThreadGroup[] threadGroupArray;
        int n2;
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ThreadGroup threadGroup2 = (ThreadGroup)objectId.getObject();
        ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
        int n3 = threadGroup2.activeCount();
        Thread[] threadArray = new Thread[n3];
        threadGroup2.enumerate(threadArray, false);
        n3 = 0;
        for (n2 = 0; n2 < threadArray.length && (threadGroupArray = threadArray[n2]) != null; ++n2) {
            if (threadGroupArray.getThreadGroup().equals(threadGroup3)) continue;
            ++n3;
        }
        dataOutputStream.writeInt(n3);
        for (n2 = 0; n2 < threadArray.length && (threadGroupArray = threadArray[n2]) != null; ++n2) {
            if (threadGroupArray.getThreadGroup().equals(threadGroup3)) continue;
            this.idMan.getObjectId(threadGroupArray).write(dataOutputStream);
        }
        n2 = threadGroup2.activeCount();
        threadGroupArray = new ThreadGroup[n2];
        threadGroup2.enumerate(threadGroupArray, false);
        n2 = 0;
        for (n = 0; n < threadGroupArray.length && (threadGroup = threadGroupArray[n]) != null; ++n) {
            if (threadGroup.equals(threadGroup3)) continue;
            ++n2;
        }
        dataOutputStream.writeInt(n2);
        for (n = 0; n < threadGroupArray.length && (threadGroup = threadGroupArray[n]) != null; ++n) {
            if (threadGroup.equals(threadGroup3)) continue;
            this.idMan.getObjectId(threadGroup).write(dataOutputStream);
        }
    }
}

