/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.processor.PacketProcessor;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.TransportException;
import gnu.classpath.jdwp.transport.TransportFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;

public class Jdwp
extends Thread {
    private static Jdwp _instance = null;
    public static boolean isDebugging = false;
    private PacketProcessor _packetProcessor;
    private Thread _ppThread;
    private HashMap _properties;
    private static final String _PROPERTY_SUSPEND = "suspend";
    private Thread _mainThread;
    private JdwpConnection _connection;
    private boolean _shutdown = false;
    private ThreadGroup _group;

    static /* synthetic */ PacketProcessor access$1(Jdwp jdwp, PacketProcessor packetProcessor) {
        jdwp._packetProcessor = packetProcessor;
        return jdwp._packetProcessor;
    }

    public Jdwp() {
        isDebugging = true;
        _instance = this;
    }

    public static Jdwp getDefault() {
        return _instance;
    }

    public static boolean suspendOnStartup() {
        String string;
        Jdwp jdwp = Jdwp.getDefault();
        return jdwp != null && (string = (String)jdwp._properties.get(_PROPERTY_SUSPEND)) != null && string.equals("y");
    }

    public void configure(String string, Thread thread) {
        this._mainThread = thread;
        this._processConfigury(string);
    }

    private void _doInitialization() throws TransportException {
        this._group = new ThreadGroup("JDWP threads");
        ITransport iTransport = TransportFactory.newInstance(this._properties);
        this._connection = new JdwpConnection(this._group, iTransport);
        this._connection.initialize();
        this._connection.start();
        this._packetProcessor = new PacketProcessor(this._connection);
        this._ppThread = new Thread(this._group, new Runnable(this){
            private /* synthetic */ Jdwp this$0;
            {
                this.this$0 = jdwp;
            }

            public void run() {
                AccessController.doPrivileged(this.this$0._packetProcessor);
            }
        });
        this._ppThread.start();
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._packetProcessor.shutdown();
            this._ppThread.interrupt();
            this._connection.shutdown();
            this._shutdown = true;
            isDebugging = false;
            this.interrupt();
        }
    }

    public static void notify(Event event) {
        EventManager eventManager;
        EventRequest eventRequest;
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null && (eventRequest = (eventManager = EventManager.getDefault()).getEventRequest(event)) != null) {
            Jdwp.sendEvent(eventRequest, event);
        }
    }

    public static void sendEvent(EventRequest eventRequest, Event event) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            try {
                JdwpConnection jdwpConnection = jdwp._connection;
                synchronized (jdwpConnection) {
                    try {
                        jdwp._connection.sendEvent(eventRequest, event);
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    jdwp._enforceSuspendPolicy(eventRequest.getSuspendPolicy());
                }
            }
            catch (IOException iOException) {
                System.out.println("Jdwp.notify: caught exception: " + iOException);
            }
        }
    }

    private void _enforceSuspendPolicy(byte by) {
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                VMVirtualMachine.suspendThread(this);
                break;
            }
            case 2: {
                VMVirtualMachine.suspendAllThreads();
            }
        }
    }

    public void run() {
        try {
            this._doInitialization();
            this._mainThread.start();
            this._mainThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            System.out.println("Exception in JDWP back-end: " + throwable);
            System.exit(1);
        }
    }

    private void _processConfigury(String string) {
        this._properties = new HashMap();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) continue;
            this._properties.put(stringArray2[0], stringArray2[1]);
        }
    }

    static {
        _PROPERTY_SUSPEND = _PROPERTY_SUSPEND;
    }
}

