/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Graphics;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;

class GTKIconFactory {
    private static final String RADIO_BUTTON_ICON = "paintRadioButtonIcon";
    private static final String CHECK_BOX_ICON = "paintCheckBoxIcon";
    private static final String MENU_ARROW_ICON = "paintMenuArrowIcon";
    private static final String MENU_ITEM_ARROW_ICON = "paintMenuItemArrowIcon";
    private static final String CHECK_BOX_MENU_ITEM_ARROW_ICON = "paintCheckBoxMenuItemArrowIcon";
    private static final String CHECK_BOX_MENU_ITEM_CHECK_ICON = "paintCheckBoxMenuItemCheckIcon";
    private static final String RADIO_BUTTON_MENU_ITEM_ARROW_ICON = "paintRadioButtonMenuItemArrowIcon";
    private static final String RADIO_BUTTON_MENU_ITEM_CHECK_ICON = "paintRadioButtonMenuItemCheckIcon";
    private static final String TREE_EXPANDED_ICON = "paintTreeExpandedIcon";
    private static final String TREE_COLLAPSED_ICON = "paintTreeCollapsedIcon";
    private static final String ASCENDING_SORT_ICON = "paintAscendingSortIcon";
    private static final String DESCENDING_SORT_ICON = "paintDescendingSortIcon";
    private static final String TOOL_BAR_HANDLE_ICON = "paintToolBarHandleIcon";
    private static Map<String, DelegatingIcon> iconsPool = Collections.synchronizedMap(new HashMap());

    GTKIconFactory() {
    }

    private static DelegatingIcon getIcon(String string) {
        DelegatingIcon delegatingIcon = iconsPool.get(string);
        if (delegatingIcon == null) {
            delegatingIcon = string == TREE_COLLAPSED_ICON || string == TREE_EXPANDED_ICON ? new SynthExpanderIcon(string) : (string == TOOL_BAR_HANDLE_ICON ? new ToolBarHandleIcon() : (string == MENU_ARROW_ICON ? new MenuArrowIcon() : new DelegatingIcon(string)));
            iconsPool.put(string, delegatingIcon);
        }
        return delegatingIcon;
    }

    public static Icon getAscendingSortIcon() {
        return GTKIconFactory.getIcon(ASCENDING_SORT_ICON);
    }

    public static Icon getDescendingSortIcon() {
        return GTKIconFactory.getIcon(DESCENDING_SORT_ICON);
    }

    public static SynthIcon getTreeExpandedIcon() {
        return GTKIconFactory.getIcon(TREE_EXPANDED_ICON);
    }

    public static SynthIcon getTreeCollapsedIcon() {
        return GTKIconFactory.getIcon(TREE_COLLAPSED_ICON);
    }

    public static SynthIcon getRadioButtonIcon() {
        return GTKIconFactory.getIcon(RADIO_BUTTON_ICON);
    }

    public static SynthIcon getCheckBoxIcon() {
        return GTKIconFactory.getIcon(CHECK_BOX_ICON);
    }

    public static SynthIcon getMenuArrowIcon() {
        return GTKIconFactory.getIcon(MENU_ARROW_ICON);
    }

    public static SynthIcon getMenuItemArrowIcon() {
        return GTKIconFactory.getIcon(MENU_ITEM_ARROW_ICON);
    }

    public static SynthIcon getCheckBoxMenuItemArrowIcon() {
        return GTKIconFactory.getIcon(CHECK_BOX_MENU_ITEM_ARROW_ICON);
    }

    public static SynthIcon getCheckBoxMenuItemCheckIcon() {
        return GTKIconFactory.getIcon(CHECK_BOX_MENU_ITEM_CHECK_ICON);
    }

    public static SynthIcon getRadioButtonMenuItemArrowIcon() {
        return GTKIconFactory.getIcon(RADIO_BUTTON_MENU_ITEM_ARROW_ICON);
    }

    public static SynthIcon getRadioButtonMenuItemCheckIcon() {
        return GTKIconFactory.getIcon(RADIO_BUTTON_MENU_ITEM_CHECK_ICON);
    }

    public static SynthIcon getToolBarHandleIcon() {
        return GTKIconFactory.getIcon(TOOL_BAR_HANDLE_ICON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetIcons() {
        Map<String, DelegatingIcon> map = iconsPool;
        synchronized (map) {
            for (DelegatingIcon delegatingIcon : iconsPool.values()) {
                delegatingIcon.resetIconDimensions();
            }
        }
    }

    private static class DelegatingIcon
    extends SynthIcon
    implements UIResource {
        static final int DEFAULT_ICON_DIMENSION = 13;
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private Object method;
        int iconDimension = -1;

        DelegatingIcon(String string) {
            this.method = string;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext != null) {
                GTKPainter.INSTANCE.paintIcon(synthContext, graphics, this.getMethod(), n, n2, n3, n4);
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            return this.getIconDimension(synthContext);
        }

        public int getIconHeight(SynthContext synthContext) {
            return this.getIconDimension(synthContext);
        }

        void resetIconDimensions() {
            this.iconDimension = -1;
        }

        protected Method getMethod() {
            if (this.method instanceof String) {
                this.method = this.resolveMethod((String)this.method);
            }
            return (Method)this.method;
        }

        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        private Method resolveMethod(String string) {
            try {
                return GTKPainter.class.getMethod(string, this.getMethodParamTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                assert (false);
                return null;
            }
        }

        int getIconDimension(SynthContext synthContext) {
            if (this.iconDimension >= 0) {
                return this.iconDimension;
            }
            if (synthContext == null) {
                return 13;
            }
            Region region = synthContext.getRegion();
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            Object object = gTKStyle.getClassSpecificValue(region, "indicator-size");
            if (object != null) {
                this.iconDimension = ((Number)object).intValue();
            } else if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
                this.iconDimension = 13;
            } else {
                this.iconDimension = 13;
                return 13;
            }
            if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
                object = gTKStyle.getClassSpecificValue(region, "indicator-spacing");
                this.iconDimension = object != null ? (this.iconDimension += 2 * ((Number)object).intValue()) : (this.iconDimension += 4);
            } else if (region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM) {
                ++this.iconDimension;
            }
            return this.iconDimension;
        }
    }

    private static class MenuArrowIcon
    extends DelegatingIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, GTKConstants.ArrowType.class};

        public MenuArrowIcon() {
            super(GTKIconFactory.MENU_ARROW_ICON);
        }

        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            GTKConstants.ArrowType arrowType = GTKConstants.ArrowType.RIGHT;
            if (!synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
                arrowType = GTKConstants.ArrowType.LEFT;
            }
            GTKPainter.INSTANCE.paintIcon(synthContext, graphics, this.getMethod(), n, n2, n3, n4, (Object)arrowType);
        }
    }

    private static class SynthExpanderIcon
    extends DelegatingIcon {
        SynthExpanderIcon(String string) {
            super(string);
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext != null) {
                super.paintIcon(synthContext, graphics, n, n2, n3, n4);
                this.updateSizeIfNecessary(synthContext);
            }
        }

        int getIconDimension(SynthContext synthContext) {
            this.updateSizeIfNecessary(synthContext);
            return this.iconDimension == -1 ? 13 : this.iconDimension;
        }

        private void updateSizeIfNecessary(SynthContext synthContext) {
            if (this.iconDimension == -1 && synthContext != null) {
                this.iconDimension = synthContext.getStyle().getInt(synthContext, "Tree.expanderSize", 10);
            }
        }
    }

    private static class ToolBarHandleIcon
    extends DelegatingIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, GTKConstants.Orientation.class};
        private SynthStyle style;

        public ToolBarHandleIcon() {
            super(GTKIconFactory.TOOL_BAR_HANDLE_ICON);
        }

        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            GTKConstants.Orientation orientation;
            JToolBar jToolBar = (JToolBar)synthContext.getComponent();
            GTKConstants.Orientation orientation2 = orientation = jToolBar.getOrientation() == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
            if (this.style == null) {
                this.style = SynthLookAndFeel.getStyleFactory().getStyle(synthContext.getComponent(), GTKRegion.HANDLE_BOX);
            }
            synthContext = new SynthContext(jToolBar, GTKRegion.HANDLE_BOX, this.style, 1);
            GTKPainter.INSTANCE.paintIcon(synthContext, graphics, this.getMethod(), n, n2, n3, n4, (Object)orientation);
        }

        public int getIconWidth(SynthContext synthContext) {
            if (synthContext == null) {
                return 10;
            }
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return 10;
            }
            return synthContext.getComponent().getWidth();
        }

        public int getIconHeight(SynthContext synthContext) {
            if (synthContext == null) {
                return 10;
            }
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return synthContext.getComponent().getHeight();
            }
            return 10;
        }
    }
}

