#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/msgs/mirrors.msg.new
config etc/msgs/msg.toomany.new
config etc/msgs/msg.dead.new
config etc/msgs/welcome.msg.new
config etc/ftpusers.new
config etc/ftpaccess.new
config etc/ftpconversions.new
config etc/ftpgroups.new
