/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration EMPTY_ENUMERATION = null;
    protected MutableTreeNode parent;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;
    static Random random = new Random(System.currentTimeMillis());

    private /* synthetic */ void finit$() {
        this.parent = null;
        this.children = new Vector();
        this.userObject = "";
        this.allowsChildren = true;
    }

    public DefaultMutableTreeNode() {
        this.finit$();
    }

    public DefaultMutableTreeNode(Object userObject) {
        this.finit$();
        this.userObject = userObject;
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.finit$();
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public void add(MutableTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    private void writeObject(ObjectOutputStream value0) throws IOException {
    }

    private void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    public void insert(MutableTreeNode node, int index) {
        this.children.insertElementAt(node, index);
    }

    public TreeNode[] getPath() {
        int size = this.getLevel() + 1;
        TreeNode[] path = new TreeNode[size];
        TreeNode current = this;
        for (int index = size - 1; index >= 0; --index) {
            path[index] = current;
            current = current.getParent();
        }
        return path;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public void setParent(MutableTreeNode node) {
        this.parent = node;
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        this.parent = null;
    }

    public void removeAllChildren() {
        this.children.removeAllElements();
    }

    public boolean isNodeAncestor(TreeNode node) {
        TreeNode current;
        if (node == null) {
            return false;
        }
        for (current = this; current != null && current != node; current = current.getParent()) {
        }
        return current == node;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode node) {
        TreeNode current;
        if (node == null) {
            return false;
        }
        for (current = node; current != null && current != this; current = current.getParent()) {
        }
        return current == this;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode node) {
        TreeNode current;
        ArrayList list = new ArrayList();
        for (current = this; current != null; current = current.getParent()) {
            list.add(current);
        }
        for (current = node; current != null; current = current.getParent()) {
            if (!list.contains(current)) continue;
            return current;
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        return node.getRoot() == this.getRoot();
    }

    public int getDepth() {
        if (!this.allowsChildren || this.children.size() == 0) {
            return 0;
        }
        Stack stack = new Stack();
        stack.push(new Integer(0));
        TreeNode node = this.getChildAt(0);
        int depth = 0;
        int current = 1;
        while (!stack.empty()) {
            int size;
            int index;
            if (node.getChildCount() != 0) {
                node = node.getChildAt(0);
                stack.push(new Integer(0));
                ++current;
                continue;
            }
            if (current > depth) {
                depth = current;
            }
            do {
                node = node.getParent();
                size = node.getChildCount();
                --current;
                index = (Integer)stack.pop();
            } while (++index >= size && node != this);
            if (index >= size) continue;
            node = node.getChildAt(index);
            stack.push(new Integer(index));
            ++current;
        }
        return depth;
    }

    public static void growTree(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode current = root;
        int index = 0;
        do {
            if (random.nextBoolean()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(String.valueOf(index));
                ++index;
                current.add(node);
                current = node;
                continue;
            }
            current = (DefaultMutableTreeNode)current.getParent();
        } while (current != root && current != null);
        System.out.println("Number of nodes: " + index);
    }

    public static void main(String[] argv) {
        System.out.println("Create tree...");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode.growTree(root);
        System.out.println("Find depth...");
        System.out.println("Depth (root): " + root.getDepth());
    }

    public int getLevel() {
        int count = -1;
        TreeNode current = this;
        do {
            current = current.getParent();
            ++count;
        } while (current != null);
        return count;
    }

    protected TreeNode[] getPathToRoot(TreeNode value0, int value1) {
        return null;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] path = this.getPath();
        Object[] object = new Object[path.length];
        for (int index = 0; index < path.length; ++index) {
            object[index] = ((DefaultMutableTreeNode)path[index]).getUserObject();
        }
        return object;
    }

    public TreeNode getRoot() {
        TreeNode current = this;
        TreeNode check = current.getParent();
        while (check != null) {
            current = check;
            check = current.getParent();
        }
        return current;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        return null;
    }

    public DefaultMutableTreeNode getPreviousNode() {
        return null;
    }

    public Enumeration preorderEnumeration() {
        return null;
    }

    public Enumeration postorderEnumeration() {
        return null;
    }

    public Enumeration breadthFirstEnumeration() {
        return null;
    }

    public Enumeration depthFirstEnumeration() {
        return null;
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode value0) {
        return null;
    }

    public boolean isNodeChild(TreeNode node) {
        if (node == null) {
            return false;
        }
        for (TreeNode current = node; current != null; current = current.getParent()) {
            if (current != this) continue;
            return true;
        }
        return false;
    }

    public TreeNode getFirstChild() {
        return (TreeNode)this.children.firstElement();
    }

    public TreeNode getLastChild() {
        return (TreeNode)this.children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode node) {
        if (node == null || node.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node);
        if (++index == this.getChildCount()) {
            return null;
        }
        return this.getChildAt(index);
    }

    public TreeNode getChildBefore(TreeNode node) {
        if (node == null || node.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node);
        if (--index < 0) {
            return null;
        }
        return this.getChildAt(index);
    }

    public boolean isNodeSibling(TreeNode node) {
        if (node == null) {
            return false;
        }
        return node.getParent() == this.getParent() && this.getParent() != null;
    }

    public int getSiblingCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this);
        int size = this.parent.getChildCount();
        if (++index == size) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this);
        if (--index < 0) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        TreeNode current = this;
        while (current.getChildCount() > 0) {
            current = current.getChildAt(0);
        }
        return current;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        TreeNode current = this;
        int size = current.getChildCount();
        while (size > 0) {
            current = current.getChildAt(size - 1);
            size = current.getChildCount();
        }
        return current;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        return null;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        return null;
    }

    public int getLeafCount() {
        Enumeration enumeration = this.depthFirstEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            TreeNode current = (TreeNode)enumeration.nextElement();
            if (!current.isLeaf()) continue;
            ++count;
        }
        return count;
    }
}

