/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class Size2DSyntax
implements Cloneable,
Serializable {
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private int x;
    private int y;

    protected Size2DSyntax(float x, float y, int units) {
        if (x < 0.0f || y < 0.0f) {
            throw new IllegalArgumentException("x and/or y may not be less than 0");
        }
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        this.x = (int)(x * (float)units + 0.5f);
        this.y = (int)(y * (float)units + 0.5f);
    }

    protected Size2DSyntax(int x, int y, int units) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("x and/or y may not be less then 0");
        }
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        this.x = x * units;
        this.y = y * units;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Size2DSyntax)) {
            return false;
        }
        Size2DSyntax tmp = (Size2DSyntax)obj;
        return this.x == tmp.getXMicrometers() && this.y == tmp.getYMicrometers();
    }

    public float[] getSize(int units) {
        float[] size = new float[]{this.getX(units), this.getY(units)};
        return size;
    }

    public float getX(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (float)this.x / (float)units;
    }

    protected int getXMicrometers() {
        return this.x;
    }

    public float getY(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (float)this.y / (float)units;
    }

    protected int getYMicrometers() {
        return this.y;
    }

    public int hashCode() {
        return this.x + this.y;
    }

    public String toString() {
        return this.toString(1, "um");
    }

    public String toString(int units, String unitsName) {
        return this.getX(units) + "x" + this.getY(units) + " " + unitsName;
    }
}

