/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    private static final Set DEFAULT_FORWARD_KEYS;
    private static final Set DEFAULT_BACKWARD_KEYS;
    private static KeyboardFocusManager current;
    private static Component focusOwner;
    private static Component permanentFocusOwner;
    private static Window focusedWindow;
    private static Window activeWindow;
    private static Container focusCycleRoot;
    private FocusTraversalPolicy defaultPolicy;
    private Set[] defaultFocusKeys;
    private final PropertyChangeSupport propertyChangeSupport;
    private final VetoableChangeSupport vetoableChangeSupport;
    private final ArrayList keyEventDispatchers;
    private final ArrayList keyEventPostProcessors;

    private /* synthetic */ void finit$() {
        this.defaultFocusKeys = new Set[]{DEFAULT_FORWARD_KEYS, DEFAULT_BACKWARD_KEYS, Collections.EMPTY_SET, Collections.EMPTY_SET};
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.keyEventDispatchers = new ArrayList();
        this.keyEventPostProcessors = new ArrayList();
    }

    public KeyboardFocusManager() {
        this.finit$();
    }

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        return current;
    }

    public static void setCurrentKeyboardFocusManager(KeyboardFocusManager m) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("replaceKeyboardFocusManager"));
        }
        current = m == null ? new DefaultKeyboardFocusManager() : m;
    }

    public Component getFocusOwner() {
        try {
            return this.getGlobalFocusOwner();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected Component getGlobalFocusOwner() {
        return focusOwner;
    }

    protected void setGlobalFocusOwner(Component owner) {
        if (owner == null || owner.focusable) {
            this.firePropertyChange("focusOwner", focusOwner, owner);
            try {
                this.fireVetoableChange("focusOwner", focusOwner, owner);
                focusOwner = owner;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void clearGlobalFocusOwner() {
        this.setGlobalFocusOwner(null);
    }

    public Component getPermanentFocusOwner() {
        try {
            return this.getGlobalPermanentFocusOwner();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected Component getGlobalPermanentFocusOwner() {
        if (permanentFocusOwner == null) {
            return focusOwner;
        }
        return permanentFocusOwner;
    }

    protected void setGlobalPermanentFocusOwner(Component focusOwner) {
        if (focusOwner == null || focusOwner.focusable) {
            this.firePropertyChange("permanentFocusOwner", permanentFocusOwner, focusOwner);
            try {
                this.fireVetoableChange("permanentFocusOwner", permanentFocusOwner, focusOwner);
                permanentFocusOwner = focusOwner;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public Window getFocusedWindow() {
        try {
            return this.getGlobalFocusedWindow();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected Window getGlobalFocusedWindow() {
        return focusedWindow;
    }

    protected void setGlobalFocusedWindow(Window window) {
        if (window == null || window.focusable) {
            this.firePropertyChange("focusedWindow", focusedWindow, window);
            try {
                this.fireVetoableChange("focusedWindow", focusedWindow, window);
                focusedWindow = window;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public Window getActiveWindow() {
        try {
            return this.getGlobalActiveWindow();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected Window getGlobalActiveWindow() {
        return activeWindow;
    }

    protected void setGlobalActiveWindow(Window window) {
        this.firePropertyChange("activeWindow", activeWindow, window);
        try {
            this.fireVetoableChange("activeWindow", activeWindow, window);
            activeWindow = window;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        if (this.defaultPolicy == null) {
            this.defaultPolicy = new DefaultFocusTraversalPolicy();
        }
        return this.defaultPolicy;
    }

    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", this.defaultPolicy, policy);
        this.defaultPolicy = policy;
    }

    public void setDefaultFocusTraversalKeys(int id, Set keystrokes) {
        String type;
        Set sc;
        Set sb;
        Set sa;
        if (keystrokes == null) {
            throw new IllegalArgumentException();
        }
        switch (id) {
            case 0: {
                sa = this.defaultFocusKeys[1];
                sb = this.defaultFocusKeys[2];
                sc = this.defaultFocusKeys[3];
                type = "forwardDefaultFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[2];
                sc = this.defaultFocusKeys[3];
                type = "backwardDefaultFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[1];
                sc = this.defaultFocusKeys[3];
                type = "upCycleDefaultFocusTraversalKeys";
                break;
            }
            case 3: {
                sa = this.defaultFocusKeys[0];
                sb = this.defaultFocusKeys[1];
                sc = this.defaultFocusKeys[2];
                type = "downCycleDefaultFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator iter = keystrokes.iterator();
        while (--i >= 0) {
            Object o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && !sc.contains(o) && ((AWTKeyStroke)o).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        keystrokes = Collections.unmodifiableSet(new HashSet(keystrokes));
        this.firePropertyChange(type, this.defaultFocusKeys[id], keystrokes);
        this.defaultFocusKeys[id] = keystrokes;
    }

    public Set getDefaultFocusTraversalKeys(int id) {
        if (id < 0 || id > 3) {
            throw new IllegalArgumentException();
        }
        return this.defaultFocusKeys[id];
    }

    public Container getCurrentFocusCycleRoot() {
        try {
            return this.getGlobalCurrentFocusCycleRoot();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected Container getGlobalCurrentFocusCycleRoot() {
        return focusCycleRoot;
    }

    public void setGlobalCurrentFocusCycleRoot(Container cycleRoot) {
        this.firePropertyChange("currentFocusCycleRoot", focusCycleRoot, cycleRoot);
        focusCycleRoot = cycleRoot;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.addPropertyChangeListener(name, l);
        }
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        if (l != null) {
            this.propertyChangeSupport.removePropertyChangeListener(name, l);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.propertyChangeSupport.getPropertyChangeListeners(name);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.propertyChangeSupport.firePropertyChange(name, o, n);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(l);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(l);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(name, l);
        }
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener l) {
        if (l != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(name, l);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String name) {
        return this.vetoableChangeSupport.getVetoableChangeListeners(name);
    }

    protected void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(name, o, n);
    }

    public void addKeyEventDispatcher(KeyEventDispatcher dispatcher) {
        if (dispatcher != null) {
            this.keyEventDispatchers.add(dispatcher);
        }
    }

    public void removeKeyEventDispatcher(KeyEventDispatcher dispatcher) {
        this.keyEventDispatchers.remove(dispatcher);
    }

    protected List getKeyEventDispatchers() {
        return (List)this.keyEventDispatchers.clone();
    }

    public void addKeyEventPostProcessor(KeyEventPostProcessor postProcessor) {
        if (postProcessor != null) {
            this.keyEventPostProcessors.add(postProcessor);
        }
    }

    public void removeKeyEventPostProcessor(KeyEventPostProcessor postProcessor) {
        this.keyEventPostProcessors.remove(postProcessor);
    }

    protected List getKeyEventPostProcessors() {
        return (List)this.keyEventPostProcessors.clone();
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    public final void redispatchEvent(Component target, AWTEvent e) {
        throw new Error("not implemented");
    }

    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    public abstract void upFocusCycle(Component var1);

    public abstract void downFocusCycle(Container var1);

    public final void focusNextComponent() {
        this.focusNextComponent(focusOwner);
    }

    public final void focusPreviousComponent() {
        this.focusPreviousComponent(focusOwner);
    }

    public final void upFocusCycle() {
        this.upFocusCycle(focusOwner);
    }

    public final void downFocusCycle() {
        if (focusOwner instanceof Container && ((Container)focusOwner).isFocusCycleRoot()) {
            this.downFocusCycle((Container)focusOwner);
        }
    }

    static {
        HashSet s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        DEFAULT_FORWARD_KEYS = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        s.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        DEFAULT_BACKWARD_KEYS = Collections.unmodifiableSet(s);
        current = new DefaultKeyboardFocusManager();
    }
}

