# synth_1to1 works the same way as the c version of this
# file.  only two types of changes have been made:
# - reordered floating point instructions to
#   prevent pipline stalls
# - made WRITE_SAMPLE use integer instead of
#   (slower) floating point
# all kinds of x86 processors should benefit from these
# modifications.
#
# useful sources of information on optimizing x86 code include:
#
#     Intel Architecture Optimization Manual
#     http:#/www.intel.com/design/pentium/manuals/242816.htm
#
#     Cyrix 6x86 Instruction Set Summary
#     ftp:#/ftp.cyrix.com/6x86/6x-dbch6.pdf
#
#     AMD-K5 Processor Software Development
#     http:#/www.amd.com/products/cpg/techdocs/appnotes/20007e.pdf
#
# Stefan Bieschewski <stb@acm.org>
# 
# You can use this part under GPL.
#
# This version uses "circular" 64k dither noise.
# (Patch by Adrian <adrian.bacon@xs4all.nl>)
.bss
	.comm	buffs,4352,4
	.local	ditherindex.1
	.comm	ditherindex.1,4,4

.data
	.align 4
bo:
	.long 1


	.align 32
	.type	 dither.0,@object
	.size	 dither.0,262144
dither.0:
	.float -0.126371
	.float 0.497872
	.float -0.779434
	.float 0.843073
	.float -0.646505
	.float 0.245335
	.float 0.222073
	.float -0.581612
	.float 0.695388
	.float -0.530708
	.float 0.185041
	.float 0.158622
	.float -0.331470
	.float 0.278622
	.float -0.092817
	.float -0.048841
	.float 0.011484
	.float 0.193124
	.float -0.404798
	.float 0.427858
	.float -0.181552
	.float -0.226995
	.float 0.570757
	.float -0.665446
	.float 0.501044
	.float -0.236217
	.float 0.058892
	.float -0.027609
	.float 0.026705
	.float 0.123418
	.float -0.489333
	.float 0.929757
	.float -1.170636
	.float 1.002794
	.float -0.453246
	.float -0.206738
	.float 0.632205
	.float -0.633397
	.float 0.294532
	.float 0.104633
	.float -0.302673
	.float 0.242320
	.float -0.089727
	.float 0.081029
	.float -0.324990
	.float 0.717858
	.float -1.029248
	.float 1.079430
	.float -0.865108
	.float 0.545086
	.float -0.315316
	.float 0.279339
	.float -0.403600
	.float 0.567323
	.float -0.649849
	.float 0.592073
	.float -0.408065
	.float 0.162572
	.float 0.060177
	.float -0.184770
	.float 0.170196
	.float -0.029769
	.float -0.166320
	.float 0.316669
	.float -0.336468
	.float 0.202805
	.float 0.031615
	.float -0.267881
	.float 0.415993
	.float -0.441208
	.float 0.374135
	.float -0.283867
	.float 0.237228
	.float -0.269021
	.float 0.372174
	.float -0.501860
	.float 0.588166
	.float -0.561109
	.float 0.389184
	.float -0.113668
	.float -0.154052
	.float 0.288390
	.float -0.230394
	.float 0.033172
	.float 0.169925
	.float -0.254336
	.float 0.180427
	.float 0.001239
	.float -0.207596
	.float 0.381351
	.float -0.497008
	.float 0.525549
	.float -0.416073
	.float 0.133741
	.float 0.274462
	.float -0.657655
	.float 0.824427
	.float -0.655465
	.float 0.181011
	.float 0.434058
	.float -0.978169
	.float 1.285011
	.float -1.277038
	.float 0.964366
	.float -0.433292
	.float -0.163679
	.float 0.640509
	.float -0.853299
	.float 0.787458
	.float -0.582884
	.float 0.449365
	.float -0.512563
	.float 0.704562
	.float -0.798259
	.float 0.577758
	.float -0.023201
	.float -0.637865
	.float 1.068069
	.float -1.056910
	.float 0.681034
	.float -0.259306
	.float 0.124050
	.float -0.373801
	.float 0.794477
	.float -1.013669
	.float 0.775175
	.float -0.129223
	.float -0.599158
	.float 1.031099
	.float -0.974601
	.float 0.517839
	.float 0.066833
	.float -0.512471
	.float 0.700553
	.float -0.680405
	.float 0.587045
	.float -0.534422
	.float 0.550606
	.float -0.576378
	.float 0.514289
	.float -0.298390
	.float -0.051238
	.float 0.423241
	.float -0.671410
	.float 0.704669
	.float -0.549354
	.float 0.333014
	.float -0.194403
	.float 0.184374
	.float -0.232905
	.float 0.206095
	.float -0.008017
	.float -0.348208
	.float 0.743970
	.float -1.019454
	.float 1.049885
	.float -0.795487
	.float 0.316931
	.float 0.236503
	.float -0.666516
	.float 0.797240
	.float -0.561812
	.float 0.056286
	.float 0.489703
	.float -0.828997
	.float 0.835407
	.float -0.572158
	.float 0.239403
	.float -0.035552
	.float 0.028771
	.float -0.126091
	.float 0.156077
	.float -0.002708
	.float -0.304050
	.float 0.602824
	.float -0.710860
	.float 0.555917
	.float -0.239252
	.float -0.018276
	.float 0.017531
	.float 0.282194
	.float -0.725074
	.float 1.049196
	.float -1.048341
	.float 0.699686
	.float -0.177881
	.float -0.246852
	.float 0.355969
	.float -0.086717
	.float -0.456173
	.float 1.068131
	.float -1.539105
	.float 1.723683
	.float -1.568057
	.float 1.105834
	.float -0.444760
	.float -0.248736
	.float 0.779518
	.float -0.982741
	.float 0.800518
	.float -0.332841
	.float -0.187653
	.float 0.507058
	.float -0.492466
	.float 0.211669
	.float 0.113055
	.float -0.253987
	.float 0.128636
	.float 0.153526
	.float -0.377464
	.float 0.374412
	.float -0.128717
	.float -0.227781
	.float 0.516816
	.float -0.630938
	.float 0.590884
	.float -0.517150
	.float 0.545354
	.float -0.739329
	.float 1.047802
	.float -1.323966
	.float 1.397959
	.float -1.168752
	.float 0.669202
	.float -0.066645
	.float -0.409525
	.float 0.580521
	.float -0.410935
	.float 0.026572
	.float 0.356685
	.float -0.553327
	.float 0.504346
	.float -0.288332
	.float 0.043253
	.float 0.141181
	.float -0.277205
	.float 0.436716
	.float -0.651000
	.float 0.844066
	.float -0.869754
	.float 0.635648
	.float -0.215008
	.float -0.157355
	.float 0.226196
	.float 0.096190
	.float -0.635057
	.float 1.036336
	.float -0.990329
	.float 0.451464
	.float 0.299472
	.float -0.807388
	.float 0.722275
	.float -0.027316
	.float -0.935817
	.float 1.664935
	.float -1.792102
	.float 1.287557
	.float -0.451326
	.float -0.286585
	.float 0.618143
	.float -0.505490
	.float 0.152416
	.float 0.157551
	.float -0.240544
	.float 0.102379
	.float 0.099415
	.float -0.179993
	.float 0.051984
	.float 0.226031
	.float -0.500686
	.float 0.633198
	.float -0.588798
	.float 0.445032
	.float -0.317995
	.float 0.269202
	.float -0.269536
	.float 0.248552
	.float -0.182288
	.float 0.135708
	.float -0.212630
	.float 0.448683
	.float -0.739797
	.float 0.880135
	.float -0.697185
	.float 0.191455
	.float 0.424851
	.float -0.828880
	.float 0.772228
	.float -0.236914
	.float -0.534490
	.float 1.158070
	.float -1.314780
	.float 0.930502
	.float -0.226757
	.float -0.393937
	.float 0.571055
	.float -0.192762
	.float -0.537378
	.float 1.218571
	.float -1.487907
	.float 1.229142
	.float -0.628217
	.float 0.047183
	.float 0.196134
	.float -0.002984
	.float -0.476145
	.float 0.954564
	.float -1.178012
	.float 1.043978
	.float -0.617449
	.float 0.062058
	.float 0.451735
	.float -0.808485
	.float 0.964828
	.float -0.938582
	.float 0.790698
	.float -0.605411
	.float 0.463329
	.float -0.409224
	.float 0.430645
	.float -0.465883
	.float 0.442322
	.float -0.322865
	.float 0.131314
	.float 0.058113
	.float -0.158472
	.float 0.113045
	.float 0.075994
	.float -0.343025
	.float 0.580166
	.float -0.678519
	.float 0.574712
	.float -0.281691
	.float -0.113686
	.float 0.486386
	.float -0.724084
	.float 0.768183
	.float -0.628861
	.float 0.372934
	.float -0.093638
	.float -0.124324
	.float 0.231160
	.float -0.219429
	.float 0.112956
	.float 0.050462
	.float -0.226928
	.float 0.362720
	.float -0.395747
	.float 0.279793
	.float -0.024831
	.float -0.282393
	.float 0.510873
	.float -0.563079
	.float 0.442322
	.float -0.249115
	.float 0.100163
	.float -0.032927
	.float -0.020319
	.float 0.160193
	.float -0.409025
	.float 0.663533
	.float -0.766234
	.float 0.647766
	.float -0.419203
	.float 0.320701
	.float -0.544970
	.float 1.065059
	.float -1.610836
	.float 1.833730
	.float -1.553197
	.float 0.903052
	.float -0.259697
	.float -0.007328
	.float -0.212963
	.float 0.698974
	.float -1.051706
	.float 0.966280
	.float -0.430702
	.float -0.275602
	.float 0.767679
	.float -0.792826
	.float 0.371346
	.float 0.230092
	.float -0.659509
	.float 0.676170
	.float -0.279738
	.float -0.289389
	.float 0.677696
	.float -0.612296
	.float 0.059468
	.float 0.744351
	.float -1.415615
	.float 1.633517
	.float -1.310116
	.float 0.618659
	.float 0.125613
	.float -0.641087
	.float 0.797705
	.float -0.624972
	.float 0.244521
	.float 0.200689
	.float -0.580801
	.float 0.792009
	.float -0.778689
	.float 0.563061
	.float -0.245811
	.float -0.048662
	.float 0.255707
	.float -0.416065
	.float 0.636467
	.float -0.985799
	.float 1.405228
	.float -1.706730
	.float 1.672335
	.float -1.194345
	.float 0.367253
	.float 0.531114
	.float -1.167965
	.float 1.328168
	.float -1.033785
	.float 0.534288
	.float -0.161470
	.float 0.130608
	.float -0.412598
	.float 0.763537
	.float -0.892412
	.float 0.650136
	.float -0.110037
	.float -0.506462
	.float 0.990219
	.float -1.265662
	.float 1.392091
	.float -1.463807
	.float 1.502231
	.float -1.428187
	.float 1.130763
	.float -0.575290
	.float -0.131447
	.float 0.766594
	.float -1.094440
	.float 0.988759
	.float -0.506066
	.float -0.132718
	.float 0.647549
	.float -0.840015
	.float 0.693105
	.float -0.370183
	.float 0.110418
	.float -0.083722
	.float 0.297888
	.float -0.616739
	.float 0.869546
	.float -0.967642
	.float 0.943438
	.float -0.891181
	.float 0.867534
	.float -0.838194
	.float 0.714985
	.float -0.449887
	.float 0.104667
	.float 0.165938
	.float -0.209080
	.float -0.023751
	.float 0.441613
	.float -0.868145
	.float 1.141624
	.float -1.192608
	.float 1.058257
	.float -0.840340
	.float 0.643364
	.float -0.524861
	.float 0.474193
	.float -0.425268
	.float 0.302863
	.float -0.085859
	.float -0.152176
	.float 0.268761
	.float -0.148889
	.float -0.186358
	.float 0.549277
	.float -0.681526
	.float 0.428213
	.float 0.134062
	.float -0.721509
	.float 1.019052
	.float -0.887599
	.float 0.451604
	.float -0.001794
	.float -0.212825
	.float 0.146477
	.float 0.045285
	.float -0.159039
	.float 0.121305
	.float -0.050041
	.float 0.156332
	.float -0.567752
	.float 1.211385
	.float -1.841873
	.float 2.186326
	.float -2.095567
	.float 1.601731
	.float -0.866160
	.float 0.082809
	.float 0.585382
	.float -1.015759
	.float 1.120463
	.float -0.871128
	.float 0.346640
	.float 0.255073
	.float -0.689651
	.float 0.801037
	.float -0.626363
	.float 0.379712
	.float -0.308040
	.float 0.514921
	.float -0.883995
	.float 1.165453
	.float -1.164216
	.float 0.885950
	.float -0.525427
	.float 0.303936
	.float -0.284000
	.float 0.312088
	.float -0.143421
	.float -0.341842
	.float 0.999944
	.float -1.480440
	.float 1.452371
	.float -0.841920
	.float -0.091956
	.float 0.905720
	.float -1.243410
	.float 1.043876
	.float -0.544013
	.float 0.088666
	.float 0.104874
	.float -0.059335
	.float -0.036917
	.float 0.011546
	.float 0.152849
	.float -0.322889
	.float 0.341940
	.float -0.168819
	.float -0.082418
	.float 0.226453
	.float -0.143899
	.float -0.133743
	.float 0.451565
	.float -0.644967
	.float 0.652353
	.float -0.544854
	.float 0.456003
	.float -0.468467
	.float 0.544916
	.float -0.555947
	.float 0.384552
	.float -0.029689
	.float -0.369447
	.float 0.608910
	.float -0.544448
	.float 0.180984
	.float 0.328957
	.float -0.768386
	.float 0.962414
	.float -0.848542
	.float 0.488615
	.float -0.036194
	.float -0.319074
	.float 0.419543
	.float -0.209805
	.float -0.218671
	.float 0.647677
	.float -0.830564
	.float 0.627034
	.float -0.091921
	.float -0.545405
	.float 1.004111
	.float -1.098973
	.float 0.820335
	.float -0.308723
	.float -0.240546
	.float 0.669917
	.float -0.897878
	.float 0.904382
	.float -0.702341
	.float 0.330260
	.float 0.134447
	.float -0.571624
	.float 0.851422
	.float -0.896608
	.float 0.730999
	.float -0.469036
	.float 0.242118
	.float -0.111680
	.float 0.038244
	.float 0.064536
	.float -0.233955
	.float 0.406047
	.float -0.460742
	.float 0.332000
	.float -0.086600
	.float -0.106043
	.float 0.098374
	.float 0.116018
	.float -0.389234
	.float 0.525811
	.float -0.425894
	.float 0.154290
	.float 0.111027
	.float -0.203706
	.float 0.073183
	.float 0.196870
	.float -0.451806
	.float 0.557485
	.float -0.464065
	.float 0.217680
	.float 0.073077
	.float -0.293398
	.float 0.375712
	.float -0.328123
	.float 0.223963
	.float -0.156283
	.float 0.182045
	.float -0.288072
	.float 0.398408
	.float -0.418353
	.float 0.291616
	.float -0.042398
	.float -0.219641
	.float 0.341600
	.float -0.208667
	.float -0.171333
	.float 0.634521
	.float -0.920253
	.float 0.810839
	.float -0.275652
	.float -0.477942
	.float 1.094327
	.float -1.255779
	.float 0.853991
	.float -0.044561
	.float -0.840078
	.float 1.457267
	.float -1.601629
	.float 1.265814
	.float -0.609276
	.float -0.122629
	.float 0.682685
	.float -0.887867
	.float 0.668919
	.float -0.102846
	.float -0.591799
	.float 1.123047
	.float -1.252539
	.float 0.925260
	.float -0.317176
	.float -0.250328
	.float 0.493810
	.float -0.337583
	.float -0.044739
	.float 0.347126
	.float -0.327706
	.float -0.046634
	.float 0.595021
	.float -1.044198
	.float 1.185353
	.float -0.971055
	.float 0.515207
	.float -0.021765
	.float -0.308064
	.float 0.353022
	.float -0.116044
	.float -0.276426
	.float 0.627639
	.float -0.764058
	.float 0.624909
	.float -0.291646
	.float -0.067457
	.float 0.304359
	.float -0.377220
	.float 0.356467
	.float -0.351534
	.float 0.415600
	.float -0.499381
	.float 0.487763
	.float -0.292859
	.float -0.063127
	.float 0.437589
	.float -0.645581
	.float 0.579737
	.float -0.290667
	.float -0.034326
	.float 0.188131
	.float -0.081413
	.float -0.193407
	.float 0.418649
	.float -0.392865
	.float 0.064960
	.float 0.425936
	.float -0.830973
	.float 0.943858
	.float -0.732277
	.float 0.364261
	.float -0.105132
	.float 0.140695
	.float -0.439890
	.float 0.759009
	.float -0.802184
	.float 0.436993
	.float 0.192156
	.float -0.749808
	.float 0.944502
	.float -0.739487
	.float 0.373420
	.float -0.169415
	.float 0.280941
	.float -0.577621
	.float 0.762562
	.float -0.625049
	.float 0.221936
	.float 0.159477
	.float -0.228902
	.float -0.068902
	.float 0.491491
	.float -0.660812
	.float 0.331401
	.float 0.427909
	.float -1.263737
	.float 1.753887
	.float -1.661433
	.float 1.063673
	.float -0.284554
	.float -0.311289
	.float 0.524205
	.float -0.400098
	.float 0.152814
	.float 0.000831
	.float 0.024832
	.float -0.164273
	.float 0.290136
	.float -0.331264
	.float 0.327050
	.float -0.383008
	.float 0.570581
	.float -0.854593
	.float 1.104448
	.float -1.177109
	.float 1.006895
	.float -0.639477
	.float 0.194828
	.float 0.203307
	.float -0.479882
	.float 0.615899
	.float -0.623115
	.float 0.517761
	.float -0.316398
	.float 0.052591
	.float 0.205826
	.float -0.361960
	.float 0.326457
	.float -0.071748
	.float -0.329229
	.float 0.713980
	.float -0.900912
	.float 0.788143
	.float -0.419879
	.float -0.029883
	.float 0.355239
	.float -0.436436
	.float 0.298387
	.float -0.070931
	.float -0.114130
	.float 0.208693
	.float -0.254976
	.float 0.318693
	.float -0.412097
	.float 0.473227
	.float -0.416822
	.float 0.214036
	.float 0.063603
	.float -0.271802
	.float 0.276965
	.float -0.042089
	.float -0.340042
	.float 0.690092
	.float -0.839610
	.float 0.726656
	.float -0.430764
	.float 0.121686
	.float 0.049591
	.float -0.047432
	.float -0.031360
	.float 0.035101
	.float 0.124440
	.float -0.400909
	.float 0.644842
	.float -0.713888
	.float 0.575514
	.float -0.322630
	.float 0.096578
	.float 0.013152
	.float -0.010922
	.float -0.043259
	.float 0.102322
	.float -0.163330
	.float 0.241401
	.float -0.326364
	.float 0.374773
	.float -0.347347
	.float 0.253156
	.float -0.155689
	.float 0.134088
	.float -0.232258
	.float 0.432746
	.float -0.665160
	.float 0.833455
	.float -0.846793
	.float 0.649700
	.float -0.250874
	.float -0.263652
	.float 0.751424
	.float -1.070271
	.float 1.140694
	.float -0.975397
	.float 0.660284
	.float -0.309355
	.float 0.028465
	.float 0.099423
	.float -0.024506
	.float -0.246477
	.float 0.626578
	.float -0.962104
	.float 1.100112
	.float -0.975528
	.float 0.649942
	.float -0.264381
	.float -0.059637
	.float 0.289311
	.float -0.464241
	.float 0.618969
	.float -0.724111
	.float 0.705307
	.float -0.521791
	.float 0.228780
	.float 0.036842
	.float -0.137976
	.float 0.020887
	.float 0.258619
	.float -0.575388
	.float 0.805269
	.float -0.883310
	.float 0.827107
	.float -0.721062
	.float 0.666692
	.float -0.716213
	.float 0.826535
	.float -0.873709
	.float 0.735604
	.float -0.394343
	.float -0.020124
	.float 0.291573
	.float -0.252174
	.float -0.102241
	.float 0.599796
	.float -0.991718
	.float 1.093305
	.float -0.874595
	.float 0.453732
	.float -0.014581
	.float -0.289499
	.float 0.394402
	.float -0.331127
	.float 0.193321
	.float -0.087056
	.float 0.079568
	.float -0.165102
	.float 0.270096
	.float -0.307337
	.float 0.252447
	.float -0.182961
	.float 0.231172
	.float -0.469057
	.float 0.816267
	.float -1.067345
	.float 1.044785
	.float -0.764925
	.float 0.466107
	.float -0.445726
	.float 0.817137
	.float -1.383623
	.float 1.748763
	.float -1.595159
	.float 0.922294
	.float -0.061379
	.float -0.542436
	.float 0.615714
	.float -0.205097
	.float -0.399097
	.float 0.881831
	.float -1.092023
	.float 1.077639
	.float -0.975025
	.float 0.867492
	.float -0.731467
	.float 0.498781
	.float -0.162509
	.float -0.178186
	.float 0.379277
	.float -0.369241
	.float 0.220551
	.float -0.107283
	.float 0.172762
	.float -0.406348
	.float 0.629314
	.float -0.612433
	.float 0.249310
	.float 0.338060
	.float -0.846355
	.float 0.972771
	.float -0.617145
	.float -0.032780
	.float 0.600043
	.float -0.746601
	.float 0.386403
	.float 0.256532
	.float -0.784731
	.float 0.870020
	.float -0.445768
	.float -0.268976
	.float 0.915043
	.float -1.203731
	.float 1.059589
	.float -0.623752
	.float 0.141269
	.float 0.182059
	.float -0.269220
	.float 0.172855
	.float -0.008117
	.float -0.129451
	.float 0.210069
	.float -0.258417
	.float 0.302920
	.float -0.330486
	.float 0.287292
	.float -0.128816
	.float -0.121732
	.float 0.361859
	.float -0.469078
	.float 0.394170
	.float -0.214734
	.float 0.093875
	.float -0.162012
	.float 0.406885
	.float -0.663390
	.float 0.723732
	.float -0.491897
	.float 0.064450
	.float 0.327834
	.float -0.474959
	.float 0.320895
	.float 0.022322
	.float -0.378511
	.float 0.635648
	.float -0.795615
	.float 0.917141
	.float -1.016394
	.float 1.019779
	.float -0.813605
	.float 0.350780
	.float 0.273418
	.float -0.841845
	.float 1.126313
	.float -1.017729
	.float 0.590333
	.float -0.058643
	.float -0.345717
	.float 0.499637
	.float -0.441121
	.float 0.322034
	.float -0.298458
	.float 0.431822
	.float -0.660216
	.float 0.849055
	.float -0.880159
	.float 0.720260
	.float -0.431131
	.float 0.123961
	.float 0.105120
	.float -0.214306
	.float 0.208351
	.float -0.100351
	.float -0.114623
	.float 0.440820
	.float -0.829259
	.float 1.145886
	.float -1.213623
	.float 0.923573
	.float -0.340590
	.float -0.289546
	.float 0.661411
	.float -0.590929
	.float 0.132205
	.float 0.454372
	.float -0.863841
	.float 0.929048
	.float -0.703966
	.float 0.400286
	.float -0.228318
	.float 0.251690
	.float -0.350402
	.float 0.312806
	.float 0.007098
	.float -0.572131
	.float 1.162878
	.float -1.497817
	.float 1.394627
	.float -0.870285
	.float 0.122760
	.float 0.580750
	.float -1.028903
	.float 1.132477
	.float -0.917120
	.float 0.479999
	.float 0.047192
	.float -0.519970
	.float 0.808986
	.float -0.846259
	.float 0.667735
	.float -0.410196
	.float 0.243936
	.float -0.273427
	.float 0.470404
	.float -0.688768
	.float 0.757221
	.float -0.593355
	.float 0.267412
	.float 0.028232
	.float -0.091791
	.float -0.156209
	.float 0.605217
	.float -1.004469
	.float 1.112847
	.float -0.859761
	.float 0.404783
	.float -0.041174
	.float -0.003764
	.float -0.264562
	.float 0.598731
	.float -0.673303
	.float 0.309215
	.float 0.401547
	.float -1.157364
	.float 1.641678
	.float -1.705791
	.float 1.418602
	.float -0.974983
	.float 0.558513
	.float -0.265421
	.float 0.120322
	.float -0.129348
	.float 0.297804
	.float -0.594940
	.float 0.915478
	.float -1.098386
	.float 1.010987
	.float -0.641185
	.float 0.122715
	.float 0.334966
	.float -0.569442
	.float 0.558987
	.float -0.424526
	.float 0.339881
	.float -0.409981
	.float 0.597664
	.float -0.747025
	.float 0.688491
	.float -0.356512
	.float -0.158509
	.float 0.658171
	.float -0.951136
	.float 0.958656
	.float -0.745797
	.float 0.467615
	.float -0.274757
	.float 0.239728
	.float -0.339133
	.float 0.486582
	.float -0.586261
	.float 0.579078
	.float -0.467582
	.float 0.315632
	.float -0.221506
	.float 0.269172
	.float -0.474973
	.float 0.760398
	.float -0.975954
	.float 0.973743
	.float -0.690864
	.float 0.192410
	.float 0.356026
	.float -0.772543
	.float 0.949729
	.float -0.900134
	.float 0.733633
	.float -0.583325
	.float 0.523436
	.float -0.525331
	.float 0.478425
	.float -0.268967
	.float -0.127116
	.float 0.598335
	.float -0.940496
	.float 0.973332
	.float -0.658561
	.float 0.133762
	.float 0.369268
	.float -0.668722
	.float 0.736605
	.float -0.688751
	.float 0.674695
	.float -0.756061
	.float 0.865415
	.float -0.870559
	.float 0.688613
	.float -0.363137
	.float 0.049877
	.float 0.075865
	.float 0.071788
	.float -0.431807
	.float 0.823065
	.float -1.038807
	.float 0.955526
	.float -0.596866
	.float 0.118791
	.float 0.274354
	.float -0.436421
	.float 0.350777
	.float -0.128100
	.float -0.067161
	.float 0.119981
	.float -0.035890
	.float -0.067142
	.float 0.045999
	.float 0.155266
	.float -0.448546
	.float 0.649838
	.float -0.607867
	.float 0.322344
	.float 0.041586
	.float -0.263861
	.float 0.228872
	.float -0.013125
	.float -0.171139
	.float 0.138699
	.float 0.123717
	.float -0.445500
	.float 0.605721
	.float -0.507377
	.float 0.252150
	.float -0.054281
	.float 0.064718
	.float -0.251054
	.float 0.432242
	.float -0.435885
	.float 0.242430
	.float 0.004844
	.float -0.127050
	.float 0.058282
	.float 0.113901
	.float -0.244058
	.float 0.265755
	.float -0.241002
	.float 0.279204
	.float -0.406938
	.float 0.517508
	.float -0.456691
	.float 0.173850
	.float 0.198372
	.float -0.416717
	.float 0.304491
	.float 0.105234
	.float -0.575120
	.float 0.817256
	.float -0.683192
	.float 0.256697
	.float 0.209879
	.float -0.463639
	.float 0.407055
	.float -0.141686
	.float -0.120206
	.float 0.209269
	.float -0.111371
	.float -0.036117
	.float 0.056245
	.float 0.132113
	.float -0.455004
	.float 0.738924
	.float -0.831891
	.float 0.695433
	.float -0.407892
	.float 0.095410
	.float 0.144420
	.float -0.276075
	.float 0.316568
	.float -0.311501
	.float 0.313140
	.float -0.354244
	.float 0.416890
	.float -0.422025
	.float 0.270441
	.float 0.074684
	.float -0.526041
	.float 0.897210
	.float -1.015672
	.float 0.842516
	.float -0.499020
	.float 0.171551
	.float 0.030642
	.float -0.146657
	.float 0.306201
	.float -0.595179
	.float 0.962286
	.float -1.245916
	.float 1.295508
	.float -1.081126
	.float 0.700356
	.float -0.285323
	.float -0.099657
	.float 0.476437
	.float -0.875218
	.float 1.241929
	.float -1.431463
	.float 1.310947
	.float -0.891512
	.float 0.366863
	.float -0.005617
	.float -0.031304
	.float -0.194777
	.float 0.450450
	.float -0.509341
	.float 0.318669
	.float -0.023303
	.float -0.165326
	.float 0.142850
	.float 0.012307
	.float -0.116057
	.float 0.039768
	.float 0.174585
	.float -0.333380
	.float 0.228331
	.float 0.207951
	.float -0.834385
	.float 1.364494
	.float -1.518036
	.float 1.172248
	.float -0.431292
	.float -0.417212
	.float 1.034792
	.float -1.191249
	.float 0.875492
	.float -0.299263
	.float -0.217953
	.float 0.429268
	.float -0.301802
	.float 0.025015
	.float 0.127076
	.float 0.012276
	.float -0.394095
	.float 0.806780
	.float -1.043587
	.float 1.048174
	.float -0.924980
	.float 0.818928
	.float -0.778188
	.float 0.723077
	.float -0.543930
	.float 0.233090
	.float 0.075025
	.float -0.199677
	.float 0.066336
	.float 0.217387
	.float -0.432228
	.float 0.409344
	.float -0.151076
	.float -0.184965
	.float 0.416687
	.float -0.467639
	.float 0.391133
	.float -0.283283
	.float 0.176900
	.float -0.017769
	.float -0.258219
	.float 0.624694
	.float -0.942099
	.float 1.044431
	.float -0.868458
	.float 0.517675
	.float -0.204333
	.float 0.112470
	.float -0.284888
	.float 0.611869
	.float -0.915314
	.float 1.054162
	.float -0.979808
	.float 0.727258
	.float -0.379226
	.float 0.039545
	.float 0.184125
	.float -0.210794
	.float 0.032270
	.float 0.259758
	.float -0.504564
	.float 0.558015
	.float -0.378406
	.float 0.050077
	.float 0.271750
	.float -0.452459
	.float 0.442826
	.float -0.283869
	.float 0.066321
	.float 0.116858
	.float -0.198305
	.float 0.145301
	.float 0.035784
	.float -0.293010
	.float 0.530312
	.float -0.632053
	.float 0.512656
	.float -0.170955
	.float -0.285003
	.float 0.669622
	.float -0.804852
	.float 0.619735
	.float -0.205060
	.float -0.220618
	.float 0.427814
	.float -0.313197
	.float -0.029399
	.float 0.357015
	.float -0.422249
	.float 0.124783
	.float 0.426866
	.float -0.980676
	.float 1.285697
	.float -1.222558
	.float 0.847610
	.float -0.342968
	.float -0.081648
	.float 0.278461
	.float -0.210017
	.float -0.049320
	.float 0.352640
	.float -0.549652
	.float 0.561496
	.float -0.422917
	.float 0.258953
	.float -0.201742
	.float 0.299498
	.float -0.482371
	.float 0.609926
	.float -0.562707
	.float 0.309754
	.float 0.088441
	.float -0.525716
	.float 0.898143
	.float -1.125803
	.float 1.158252
	.float -0.986273
	.float 0.658672
	.float -0.277931
	.float -0.041854
	.float 0.233335
	.float -0.304836
	.float 0.313730
	.float -0.306201
	.float 0.274504
	.float -0.167333
	.float -0.056101
	.float 0.372723
	.float -0.686676
	.float 0.875548
	.float -0.864011
	.float 0.676555
	.float -0.431590
	.float 0.275262
	.float -0.293007
	.float 0.454948
	.float -0.632119
	.float 0.675175
	.float -0.507616
	.float 0.176505
	.float 0.169068
	.float -0.358550
	.float 0.294113
	.float -0.006279
	.float -0.359251
	.float 0.615854
	.float -0.630706
	.float 0.387357
	.float 0.015235
	.float -0.421784
	.float 0.699343
	.float -0.791669
	.float 0.725989
	.float -0.578780
	.float 0.427831
	.float -0.317745
	.float 0.252718
	.float -0.212435
	.float 0.175990
	.float -0.137676
	.float 0.106774
	.float -0.094368
	.float 0.098810
	.float -0.100976
	.float 0.073057
	.float 0.006375
	.float -0.142302
	.float 0.325267
	.float -0.541313
	.float 0.778582
	.float -1.022235
	.float 1.240814
	.float -1.378523
	.float 1.367406
	.float -1.161542
	.float 0.778153
	.float -0.318791
	.float -0.051722
	.float 0.170870
	.float 0.038593
	.float -0.514572
	.float 1.069342
	.float -1.473991
	.float 1.570776
	.float -1.349059
	.float 0.940323
	.float -0.539828
	.float 0.306654
	.float -0.300306
	.float 0.479036
	.float -0.742283
	.float 0.981081
	.float -1.110657
	.float 1.083779
	.float -0.894245
	.float 0.576321
	.float -0.196482
	.float -0.165455
	.float 0.439992
	.float -0.585456
	.float 0.593641
	.float -0.487724
	.float 0.320186
	.float -0.170138
	.float 0.129661
	.float -0.270644
	.float 0.599909
	.float -1.029764
	.float 1.394669
	.float -1.521270
	.float 1.322157
	.float -0.857043
	.float 0.314362
	.float 0.087627
	.float -0.225309
	.float 0.138654
	.float 0.005851
	.float -0.038163
	.float -0.092435
	.float 0.286070
	.float -0.380001
	.float 0.289860
	.float -0.092329
	.float -0.022898
	.float -0.099272
	.float 0.445759
	.float -0.824991
	.float 0.993879
	.float -0.828842
	.float 0.413001
	.float 0.022589
	.float -0.255005
	.float 0.207553
	.float 0.022108
	.float -0.248469
	.float 0.326430
	.float -0.233274
	.float 0.062357
	.float 0.051383
	.float -0.019135
	.float -0.150237
	.float 0.356854
	.float -0.466509
	.float 0.388746
	.float -0.136404
	.float -0.169770
	.float 0.363775
	.float -0.335023
	.float 0.104683
	.float 0.180737
	.float -0.346056
	.float 0.315050
	.float -0.177286
	.float 0.137148
	.float -0.369718
	.float 0.878869
	.float -1.458996
	.float 1.795941
	.float -1.650661
	.float 1.012486
	.float -0.126298
	.float -0.626793
	.float 0.927206
	.float -0.680170
	.float 0.053978
	.float 0.622507
	.float -1.037653
	.float 1.046285
	.float -0.712487
	.float 0.237690
	.float 0.167528
	.float -0.387699
	.float 0.432696
	.float -0.396343
	.float 0.384227
	.float -0.454948
	.float 0.598305
	.float -0.750330
	.float 0.830445
	.float -0.783369
	.float 0.608248
	.float -0.361498
	.float 0.131084
	.float 0.004466
	.float -0.008442
	.float -0.106326
	.float 0.291594
	.float -0.482222
	.float 0.606105
	.float -0.591277
	.float 0.386474
	.float 0.002125
	.float -0.481882
	.float 0.888868
	.float -1.059688
	.float 0.925105
	.float -0.560939
	.float 0.150254
	.float 0.127323
	.float -0.206099
	.float 0.165933
	.float -0.162594
	.float 0.308410
	.float -0.590654
	.float 0.884120
	.float -1.042306
	.float 0.996308
	.float -0.790537
	.float 0.537674
	.float -0.335780
	.float 0.212223
	.float -0.130261
	.float 0.040124
	.float 0.075285
	.float -0.198047
	.float 0.309149
	.float -0.417683
	.float 0.550934
	.float -0.711807
	.float 0.847520
	.float -0.868410
	.float 0.712931
	.float -0.410214
	.float 0.086215
	.float 0.100619
	.float -0.056309
	.float -0.182961
	.float 0.462160
	.float -0.594302
	.float 0.473966
	.float -0.148668
	.float -0.201714
	.float 0.373232
	.float -0.270681
	.float -0.024302
	.float 0.303310
	.float -0.372952
	.float 0.190864
	.float 0.103034
	.float -0.286269
	.float 0.215294
	.float 0.065693
	.float -0.343818
	.float 0.370732
	.float -0.023498
	.float -0.604514
	.float 1.232847
	.float -1.527338
	.float 1.271319
	.float -0.490821
	.float -0.533027
	.float 1.382690
	.float -1.705096
	.float 1.391742
	.float -0.633061
	.float -0.192174
	.float 0.729938
	.float -0.834421
	.float 0.608782
	.float -0.288889
	.float 0.065827
	.float 0.021201
	.float -0.055577
	.float 0.125187
	.float -0.230018
	.float 0.295264
	.float -0.266293
	.float 0.185280
	.float -0.168070
	.float 0.296549
	.float -0.525245
	.float 0.692595
	.float -0.636416
	.float 0.321086
	.float 0.127152
	.float -0.504578
	.float 0.666483
	.float -0.613017
	.float 0.467016
	.float -0.370717
	.float 0.383103
	.float -0.449985
	.float 0.459639
	.float -0.335926
	.float 0.100074
	.float 0.139102
	.float -0.254889
	.float 0.183248
	.float 0.035394
	.float -0.273479
	.float 0.377977
	.float -0.242704
	.float -0.141088
	.float 0.674361
	.float -1.182653
	.float 1.479144
	.float -1.434833
	.float 1.028470
	.float -0.356300
	.float -0.400691
	.float 1.037117
	.float -1.387793
	.float 1.376616
	.float -1.037221
	.float 0.499455
	.float 0.059051
	.float -0.483843
	.float 0.707778
	.float -0.771247
	.float 0.779539
	.float -0.817796
	.float 0.878985
	.float -0.858590
	.float 0.627723
	.float -0.140865
	.float -0.494144
	.float 1.038073
	.float -1.234972
	.float 0.961761
	.float -0.324582
	.float -0.368443
	.float 0.762767
	.float -0.662284
	.float 0.156057
	.float 0.427814
	.float -0.725503
	.float 0.569076
	.float -0.087663
	.float -0.392051
	.float 0.572664
	.float -0.378117
	.float -0.017438
	.float 0.327032
	.float -0.342688
	.float 0.048028
	.float 0.407031
	.float -0.824422
	.float 1.071446
	.float -1.117622
	.float 0.995038
	.float -0.738888
	.float 0.367537
	.float 0.085878
	.float -0.532210
	.float 0.832099
	.float -0.865933
	.float 0.623684
	.float -0.239136
	.float -0.073903
	.float 0.150679
	.float 0.019128
	.float -0.286856
	.float 0.443702
	.float -0.350596
	.float 0.010160
	.float 0.455583
	.float -0.886996
	.float 1.162013
	.float -1.223766
	.float 1.068054
	.float -0.724916
	.float 0.255554
	.float 0.242930
	.float -0.648100
	.float 0.848158
	.float -0.788456
	.float 0.498334
	.float -0.078706
	.float -0.343317
	.float 0.663446
	.float -0.825617
	.float 0.819414
	.float -0.667896
	.float 0.424025
	.float -0.172050
	.float 0.011215
	.float -0.010753
	.float 0.158761
	.float -0.351189
	.float 0.445401
	.float -0.351037
	.float 0.092183
	.float 0.208582
	.float -0.414398
	.float 0.462014
	.float -0.389127
	.float 0.288430
	.float -0.233138
	.float 0.235014
	.float -0.260855
	.float 0.283222
	.float -0.316240
	.float 0.405761
	.float -0.582664
	.float 0.819253
	.float -1.026533
	.float 1.101420
	.float -0.996201
	.float 0.761894
	.float -0.527704
	.float 0.419489
	.float -0.465984
	.float 0.561297
	.float -0.521609
	.float 0.208199
	.float 0.365522
	.float -1.021585
	.float 1.513503
	.float -1.666461
	.float 1.466653
	.float -1.046055
	.float 0.585909
	.float -0.213872
	.float -0.037456
	.float 0.198072
	.float -0.294995
	.float 0.310708
	.float -0.195764
	.float -0.078267
	.float 0.468995
	.float -0.857159
	.float 1.094255
	.float -1.077061
	.float 0.803287
	.float -0.374940
	.float -0.052045
	.float 0.341770
	.float -0.435986
	.float 0.368958
	.float -0.238494
	.float 0.152980
	.float -0.180209
	.float 0.318427
	.float -0.498555
	.float 0.615258
	.float -0.575636
	.float 0.345979
	.float 0.025882
	.float -0.428371
	.float 0.739907
	.float -0.890239
	.float 0.890841
	.float -0.812574
	.float 0.725756
	.float -0.647373
	.float 0.537835
	.float -0.351525
	.float 0.100754
	.float 0.123649
	.float -0.203250
	.float 0.085058
	.float 0.154156
	.float -0.333356
	.float 0.281126
	.float 0.036597
	.float -0.472377
	.float 0.781267
	.float -0.782275
	.float 0.482621
	.float -0.072404
	.float -0.208383
	.float 0.234324
	.float -0.072849
	.float -0.075694
	.float 0.028513
	.float 0.247859
	.float -0.614901
	.float 0.858885
	.float -0.834937
	.float 0.558063
	.float -0.184959
	.float -0.089833
	.float 0.144801
	.float 0.020925
	.float -0.315614
	.float 0.616334
	.float -0.814619
	.float 0.833074
	.float -0.634503
	.float 0.242623
	.float 0.238931
	.float -0.643939
	.float 0.811448
	.float -0.672304
	.float 0.293367
	.float 0.157997
	.float -0.508230
	.float 0.664236
	.float -0.635522
	.float 0.489119
	.float -0.287489
	.float 0.063018
	.float 0.161815
	.float -0.346614
	.float 0.439637
	.float -0.420470
	.float 0.337019
	.float -0.292934
	.float 0.384054
	.float -0.629788
	.float 0.954009
	.float -1.231756
	.float 1.367329
	.float -1.345980
	.float 1.224245
	.float -1.071118
	.float 0.909174
	.float -0.702947
	.float 0.404456
	.float -0.018987
	.float -0.364264
	.float 0.609390
	.float -0.619389
	.float 0.410068
	.float -0.114896
	.float -0.088350
	.float 0.081209
	.float 0.131863
	.float -0.438847
	.float 0.694655
	.float -0.797210
	.float 0.717569
	.float -0.481647
	.float 0.137508
	.float 0.258831
	.float -0.637591
	.float 0.914521
	.float -1.015672
	.float 0.918905
	.float -0.678063
	.float 0.400736
	.float -0.184714
	.float 0.054164
	.float 0.055583
	.float -0.246526
	.float 0.571070
	.float -0.971940
	.float 1.295944
	.float -1.376902
	.float 1.133565
	.float -0.618778
	.float -0.006816
	.float 0.554644
	.float -0.893077
	.float 0.996645
	.float -0.943563
	.float 0.866136
	.float -0.873903
	.float 0.983292
	.float -1.094365
	.float 1.040139
	.float -0.691809
	.float 0.059973
	.float 0.677729
	.float -1.250438
	.float 1.432056
	.float -1.162356
	.float 0.579162
	.float 0.055740
	.float -0.492782
	.float 0.615857
	.float -0.484135
	.float 0.276158
	.float -0.172039
	.float 0.243543
	.float -0.416184
	.float 0.525495
	.float -0.431605
	.float 0.118041
	.float 0.291860
	.float -0.614069
	.float 0.726525
	.float -0.649218
	.float 0.522187
	.float -0.493238
	.float 0.596064
	.float -0.713226
	.float 0.661348
	.float -0.344190
	.float -0.141255
	.float 0.538115
	.float -0.597623
	.float 0.270197
	.float 0.225134
	.float -0.522265
	.float 0.352333
	.float 0.256921
	.float -0.975051
	.float 1.373203
	.float -1.203945
	.float 0.563151
	.float 0.178625
	.float -0.624059
	.float 0.599968
	.float -0.239178
	.float -0.149309
	.float 0.310270
	.float -0.198822
	.float -0.036547
	.float 0.202401
	.float -0.203183
	.float 0.070257
	.float 0.116519
	.float -0.314281
	.float 0.521588
	.float -0.711438
	.float 0.785017
	.float -0.621040
	.float 0.193358
	.float 0.354431
	.float -0.765992
	.float 0.835962
	.float -0.553717
	.float 0.108635
	.float 0.250074
	.float -0.387750
	.float 0.359865
	.float -0.341019
	.float 0.474357
	.float -0.759662
	.float 1.055456
	.float -1.180507
	.float 1.034917
	.float -0.660368
	.float 0.208078
	.float 0.156640
	.float -0.350083
	.float 0.407457
	.float -0.441324
	.float 0.549667
	.float -0.736101
	.float 0.897979
	.float -0.894352
	.float 0.649271
	.float -0.220177
	.float -0.217032
	.float 0.458825
	.float -0.385109
	.float 0.026166
	.float 0.449216
	.float -0.813522
	.float 0.886222
	.float -0.615216
	.float 0.098736
	.float 0.461573
	.float -0.854682
	.float 0.957067
	.float -0.784865
	.float 0.476586
	.float -0.217121
	.float 0.143448
	.float -0.278967
	.float 0.526843
	.float -0.725240
	.float 0.737806
	.float -0.534771
	.float 0.217928
	.float 0.032291
	.float -0.064752
	.float -0.143493
	.float 0.465984
	.float -0.706201
	.float 0.728534
	.float -0.548320
	.float 0.311897
	.float -0.178440
	.float 0.193516
	.float -0.255232
	.float 0.203867
	.float 0.033096
	.float -0.357364
	.float 0.551625
	.float -0.436597
	.float 0.018082
	.float 0.490990
	.float -0.800441
	.float 0.738459
	.float -0.372463
	.float -0.038132
	.float 0.229979
	.float -0.129838
	.float -0.092408
	.float 0.158006
	.float 0.096308
	.float -0.576703
	.float 0.987951
	.float -1.049909
	.float 0.710174
	.float -0.187830
	.float -0.185788
	.float 0.206140
	.float 0.068123
	.float -0.379929
	.float 0.480943
	.float -0.316740
	.float 0.050821
	.float 0.081471
	.float 0.031126
	.float -0.281472
	.float 0.419307
	.float -0.235200
	.float -0.282433
	.float 0.926887
	.float -1.398347
	.float 1.486065
	.float -1.188334
	.float 0.699641
	.float -0.281686
	.float 0.104348
	.float -0.154339
	.float 0.262842
	.float -0.228935
	.float -0.042555
	.float 0.475951
	.float -0.872085
	.float 1.034053
	.float -0.889130
	.float 0.529564
	.float -0.151569
	.float -0.063670
	.float 0.051196
	.float 0.112866
	.float -0.269791
	.float 0.278498
	.float -0.095450
	.float -0.210252
	.float 0.509979
	.float -0.698288
	.float 0.749898
	.float -0.715488
	.float 0.664358
	.float -0.620823
	.float 0.544824
	.float -0.372517
	.float 0.084993
	.float 0.250845
	.float -0.504614
	.float 0.556701
	.float -0.375009
	.float 0.044560
	.float 0.266908
	.float -0.385601
	.float 0.211107
	.float 0.234015
	.float -0.802283
	.float 1.270601
	.float -1.430702
	.float 1.188960
	.float -0.625687
	.float -0.028828
	.float 0.501610
	.float -0.613103
	.float 0.362747
	.float 0.085527
	.float -0.502260
	.float 0.709530
	.float -0.647155
	.float 0.364028
	.float 0.038358
	.float -0.460888
	.float 0.828573
	.float -1.082807
	.float 1.170806
	.float -1.054445
	.float 0.737460
	.float -0.289902
	.float -0.154061
	.float 0.433104
	.float -0.419558
	.float 0.078131
	.float 0.505783
	.float -1.148989
	.float 1.643317
	.float -1.847843
	.float 1.749887
	.float -1.455119
	.float 1.111372
	.float -0.818955
	.float 0.591584
	.float -0.391431
	.float 0.200297
	.float -0.059297
	.float 0.038764
	.float -0.163718
	.float 0.362139
	.float -0.488731
	.float 0.416219
	.float -0.129928
	.float -0.246186
	.float 0.516795
	.float -0.533689
	.float 0.286711
	.float 0.092007
	.float -0.408378
	.float 0.513845
	.float -0.372031
	.float 0.056056
	.float 0.303641
	.float -0.579108
	.float 0.686730
	.float -0.609381
	.float 0.402074
	.float -0.173817
	.float 0.037575
	.float -0.045069
	.float 0.148993
	.float -0.229629
	.float 0.176944
	.float 0.029180
	.float -0.302890
	.float 0.515421
	.float -0.589254
	.float 0.551983
	.float -0.510036
	.float 0.564084
	.float -0.729529
	.float 0.919099
	.float -0.999345
	.float 0.880746
	.float -0.580157
	.float 0.213581
	.float 0.073575
	.float -0.190483
	.float 0.143524
	.float -0.016184
	.float -0.090829
	.float 0.113627
	.float -0.043581
	.float -0.086270
	.float 0.225019
	.float -0.323440
	.float 0.350807
	.float -0.311101
	.float 0.248490
	.float -0.226689
	.float 0.285156
	.float -0.401305
	.float 0.492689
	.float -0.465546
	.float 0.279628
	.float 0.015186
	.float -0.296663
	.float 0.433280
	.float -0.357615
	.float 0.109936
	.float 0.174640
	.float -0.333294
	.float 0.263187
	.float 0.022563
	.float -0.406906
	.float 0.740149
	.float -0.919323
	.float 0.921802
	.float -0.782057
	.float 0.547244
	.float -0.257042
	.float -0.042433
	.float 0.281539
	.float -0.381533
	.float 0.299948
	.float -0.069528
	.float -0.206146
	.float 0.401240
	.float -0.426720
	.float 0.263612
	.float 0.037951
	.float -0.378841
	.float 0.636115
	.float -0.695895
	.float 0.499676
	.float -0.090678
	.float -0.374824
	.float 0.679106
	.float -0.646836
	.float 0.247897
	.float 0.365233
	.float -0.917955
	.float 1.148801
	.float -0.949562
	.float 0.428392
	.float 0.150876
	.float -0.528294
	.float 0.609869
	.float -0.518530
	.float 0.486335
	.float -0.657006
	.float 0.947586
	.float -1.087743
	.float 0.823357
	.float -0.137023
	.float -0.687535
	.float 1.220794
	.float -1.162949
	.float 0.548004
	.float 0.268380
	.float -0.831330
	.float 0.869686
	.float -0.451043
	.float -0.087681
	.float 0.377053
	.float -0.253329
	.float -0.158900
	.float 0.559491
	.float -0.684041
	.float 0.461603
	.float -0.024538
	.float -0.406372
	.float 0.657995
	.float -0.671154
	.float 0.483405
	.float -0.177941
	.float -0.150153
	.float 0.404783
	.float -0.503786
	.float 0.412109
	.float -0.170363
	.float -0.116119
	.float 0.332719
	.float -0.419242
	.float 0.395863
	.float -0.336292
	.float 0.313903
	.float -0.359442
	.float 0.450644
	.float -0.529319
	.float 0.531370
	.float -0.419283
	.float 0.207427
	.float 0.033401
	.float -0.204619
	.float 0.234314
	.float -0.126566
	.float -0.031379
	.float 0.115554
	.float -0.039302
	.float -0.191031
	.float 0.471725
	.float -0.648014
	.float 0.584866
	.float -0.230152
	.float -0.353081
	.float 0.998338
	.float -1.493963
	.float 1.671718
	.float -1.486682
	.float 1.040804
	.float -0.527877
	.float 0.128480
	.float 0.079172
	.float -0.136246
	.float 0.146262
	.float -0.195577
	.float 0.310294
	.float -0.467862
	.float 0.633382
	.float -0.779402
	.float 0.878064
	.float -0.889381
	.float 0.772913
	.float -0.520682
	.float 0.181049
	.float 0.154971
	.float -0.400760
	.float 0.519660
	.float -0.533704
	.float 0.490230
	.float -0.416690
	.float 0.302854
	.float -0.125764
	.float -0.104559
	.float 0.320594
	.float -0.420702
	.float 0.328230
	.float -0.044451
	.float -0.343344
	.float 0.703453
	.float -0.920583
	.float 0.936195
	.float -0.751871
	.float 0.409001
	.float 0.028065
	.float -0.472741
	.float 0.813951
	.float -0.934627
	.float 0.759882
	.float -0.312261
	.float -0.269040
	.float 0.774731
	.float -1.023162
	.float 0.952504
	.float -0.645888
	.float 0.271716
	.float 0.017259
	.float -0.155583
	.float 0.165945
	.float -0.106782
	.float 0.020404
	.float 0.080545
	.float -0.195296
	.float 0.319038
	.float -0.446802
	.float 0.581940
	.float -0.726477
	.float 0.856766
	.float -0.914989
	.float 0.839109
	.float -0.614266
	.float 0.298458
	.float 0.008471
	.float -0.233888
	.float 0.384284
	.float -0.535614
	.float 0.766746
	.float -1.084455
	.float 1.394704
	.float -1.542551
	.float 1.399011
	.float -0.944210
	.float 0.296978
	.float 0.332108
	.float -0.743257
	.float 0.848942
	.float -0.712651
	.float 0.499768
	.float -0.372049
	.float 0.394537
	.float -0.512283
	.float 0.604156
	.float -0.569910
	.float 0.393207
	.float -0.148246
	.float -0.044160
	.float 0.081996
	.float 0.063617
	.float -0.329044
	.float 0.586079
	.float -0.709048
	.float 0.647662
	.float -0.457487
	.float 0.260988
	.float -0.161615
	.float 0.176025
	.float -0.240137
	.float 0.282608
	.float -0.297620
	.float 0.346146
	.float -0.480821
	.float 0.665068
	.float -0.769095
	.float 0.659929
	.float -0.315369
	.float -0.134644
	.float 0.478955
	.float -0.557610
	.float 0.358738
	.float -0.015240
	.float -0.285679
	.float 0.410500
	.float -0.337130
	.float 0.141074
	.float 0.064001
	.float -0.188227
	.float 0.199666
	.float -0.123229
	.float 0.013763
	.float 0.080160
	.float -0.143672
	.float 0.200009
	.float -0.289143
	.float 0.433038
	.float -0.610552
	.float 0.759239
	.float -0.803111
	.float 0.687251
	.float -0.397481
	.float -0.040959
	.float 0.573251
	.float -1.118135
	.float 1.565584
	.float -1.790847
	.float 1.703770
	.float -1.318926
	.float 0.792891
	.float -0.375164
	.float 0.273771
	.float -0.513338
	.float 0.892817
	.float -1.093799
	.float 0.880851
	.float -0.258690
	.float -0.524646
	.float 1.130703
	.float -1.332252
	.float 1.130414
	.float -0.722582
	.float 0.361197
	.float -0.206034
	.float 0.258942
	.float -0.401848
	.float 0.491879
	.float -0.443485
	.float 0.254409
	.float 0.018609
	.float -0.298500
	.float 0.511586
	.float -0.596809
	.float 0.518956
	.float -0.292346
	.float -0.004270
	.float 0.247112
	.float -0.322540
	.float 0.185699
	.float 0.117595
	.float -0.479903
	.float 0.788915
	.float -0.973114
	.float 1.011938
	.float -0.916855
	.float 0.708714
	.float -0.412559
	.float 0.070075
	.float 0.249893
	.float -0.462515
	.float 0.501738
	.float -0.356279
	.float 0.080272
	.float 0.230237
	.float -0.478014
	.float 0.597503
	.float -0.567615
	.float 0.411475
	.float -0.191365
	.float -0.003413
	.float 0.085315
	.float -0.009961
	.float -0.193997
	.float 0.433441
	.float -0.601202
	.float 0.639698
	.float -0.575868
	.float 0.504072
	.float -0.526577
	.float 0.687061
	.float -0.934848
	.float 1.139871
	.float -1.151483
	.float 0.873319
	.float -0.318192
	.float -0.383914
	.float 1.029385
	.float -1.416548
	.float 1.420226
	.float -1.036267
	.float 0.382090
	.float 0.342891
	.float -0.923570
	.float 1.203340
	.float -1.142593
	.float 0.835789
	.float -0.470521
	.float 0.237320
	.float -0.232078
	.float 0.406938
	.float -0.604147
	.float 0.656699
	.float -0.493846
	.float 0.183328
	.float 0.117077
	.float -0.264593
	.float 0.222040
	.float -0.074067
	.float -0.037641
	.float 0.010903
	.float 0.156445
	.float -0.380192
	.float 0.560245
	.float -0.651024
	.float 0.681249
	.float -0.714967
	.float 0.790370
	.float -0.885143
	.float 0.931891
	.float -0.869123
	.float 0.689424
	.float -0.451279
	.float 0.246335
	.float -0.142984
	.float 0.144585
	.float -0.194064
	.float 0.226460
	.float -0.231706
	.float 0.273703
	.float -0.439613
	.float 0.751835
	.float -1.116397
	.float 1.363254
	.float -1.360211
	.float 1.113566
	.float -0.767718
	.float 0.494177
	.float -0.354288
	.float 0.249815
	.float -0.010917
	.float -0.442066
	.float 0.992591
	.float -1.372363
	.float 1.335995
	.float -0.841753
	.float 0.103063
	.float 0.532037
	.float -0.790522
	.float 0.627749
	.float -0.225791
	.float -0.146821
	.float 0.304932
	.float -0.231748
	.float 0.043121
	.float 0.116028
	.float -0.158372
	.float 0.077254
	.float 0.077760
	.float -0.230565
	.float 0.293844
	.float -0.187611
	.float -0.118309
	.float 0.553616
	.float -0.940403
	.float 1.066957
	.float -0.815879
	.float 0.259748
	.float 0.357129
	.float -0.754074
	.float 0.778588
	.float -0.484770
	.float 0.073600
	.float 0.253158
	.float -0.413865
	.float 0.460220
	.float -0.491110
	.float 0.550692
	.float -0.595068
	.float 0.545912
	.float -0.375444
	.float 0.147647
	.float 0.015979
	.float -0.013363
	.float -0.179477
	.float 0.503929
	.float -0.857141
	.float 1.135290
	.float -1.256986
	.float 1.172767
	.float -0.879676
	.float 0.442975
	.float -0.001015
	.float -0.274484
	.float 0.260684
	.float 0.036653
	.float -0.466437
	.float 0.806461
	.float -0.892182
	.float 0.717038
	.float -0.432922
	.float 0.248135
	.float -0.292330
	.float 0.538738
	.float -0.827441
	.float 0.962933
	.float -0.819501
	.float 0.400551
	.float 0.163920
	.float -0.669947
	.float 0.923093
	.float -0.827092
	.float 0.439551
	.float 0.044087
	.float -0.385837
	.float 0.432755
	.float -0.197511
	.float -0.161521
	.float 0.446239
	.float -0.536139
	.float 0.441217
	.float -0.265379
	.float 0.118401
	.float -0.040783
	.float -0.012832
	.float 0.128967
	.float -0.363268
	.float 0.687353
	.float -0.989191
	.float 1.130906
	.float -1.033045
	.float 0.733884
	.float -0.381682
	.float 0.157862
	.float -0.175602
	.float 0.416977
	.float -0.747233
	.float 0.992749
	.float -1.029877
	.float 0.832445
	.float -0.461383
	.float 0.019650
	.float 0.391798
	.float -0.696255
	.float 0.845937
	.float -0.822484
	.float 0.640130
	.float -0.347129
	.float 0.019244
	.float 0.255562
	.float -0.397308
	.float 0.356229
	.float -0.134565
	.float -0.200581
	.float 0.527796
	.float -0.714263
	.float 0.678909
	.float -0.441631
	.float 0.122685
	.float 0.116618
	.float -0.162727
	.float 0.016839
	.float 0.200817
	.float -0.314547
	.float 0.192912
	.float 0.167082
	.float -0.618188
	.float 0.922917
	.float -0.874195
	.float 0.417552
	.float 0.295837
	.float -0.966641
	.float 1.294251
	.float -1.134125
	.float 0.575335
	.float 0.107086
	.float -0.595590
	.float 0.687400
	.float -0.382063
	.float -0.137735
	.float 0.609875
	.float -0.820043
	.float 0.689105
	.float -0.285906
	.float -0.227096
	.float 0.675938
	.float -0.938141
	.float 0.962307
	.float -0.753510
	.float 0.354992
	.float 0.152102
	.float -0.638744
	.float 0.938660
	.float -0.900757
	.float 0.468971
	.float 0.260284
	.float -1.051652
	.float 1.624108
	.float -1.779578
	.float 1.496639
	.float -0.937557
	.float 0.365867
	.float -0.019468
	.float 0.004088
	.float -0.258709
	.float 0.606946
	.float -0.863370
	.float 0.934130
	.float -0.853624
	.float 0.737878
	.float -0.689511
	.float 0.721288
	.float -0.750211
	.float 0.662233
	.float -0.398656
	.float 0.003781
	.float 0.395112
	.float -0.658302
	.float 0.709349
	.float -0.572694
	.float 0.354205
	.float -0.177510
	.float 0.113002
	.float -0.141904
	.float 0.178076
	.float -0.132288
	.float -0.027125
	.float 0.258618
	.float -0.479897
	.float 0.612793
	.float -0.604218
	.float 0.423411
	.float -0.067866
	.float -0.403633
	.float 0.842763
	.float -1.044842
	.float 0.860092
	.float -0.317029
	.float -0.348339
	.float 0.808586
	.float -0.841345
	.float 0.465645
	.float 0.084612
	.float -0.528094
	.float 0.715858
	.float -0.693531
	.float 0.616266
	.float -0.599909
	.float 0.630020
	.float -0.590547
	.float 0.376186
	.float 0.006241
	.float -0.424043
	.float 0.698380
	.float -0.716365
	.float 0.498281
	.float -0.179653
	.float -0.073519
	.float 0.158685
	.float -0.083065
	.float -0.059102
	.float 0.156879
	.float -0.153659
	.float 0.077425
	.float -0.016851
	.float 0.062719
	.float -0.251956
	.float 0.545587
	.float -0.848644
	.float 1.056025
	.float -1.097501
	.float 0.959988
	.float -0.681359
	.float 0.326019
	.float 0.040565
	.float -0.363343
	.float 0.595650
	.float -0.696246
	.float 0.640953
	.float -0.448522
	.float 0.197247
	.float -0.003356
	.float -0.042873
	.float -0.055074
	.float 0.187334
	.float -0.207762
	.float 0.046311
	.float 0.224140
	.float -0.430290
	.float 0.427310
	.float -0.212992
	.float -0.069169
	.float 0.244149
	.float -0.241955
	.float 0.141108
	.float -0.083755
	.float 0.137304
	.float -0.223887
	.float 0.181261
	.float 0.091615
	.float -0.522494
	.float 0.882591
	.float -0.929659
	.float 0.578491
	.float 0.024808
	.float -0.583194
	.float 0.831315
	.float -0.694679
	.float 0.314872
	.float 0.070362
	.float -0.297727
	.float 0.372162
	.float -0.422291
	.float 0.565085
	.float -0.793621
	.float 0.974205
	.float -0.949583
	.float 0.666281
	.float -0.232602
	.float -0.132286
	.float 0.224761
	.float 0.019112
	.float -0.475632
	.float 0.893026
	.float -1.028685
	.float 0.787499
	.float -0.278747
	.float -0.244744
	.float 0.528017
	.float -0.449088
	.float 0.070534
	.float 0.408971
	.float -0.759602
	.float 0.820773
	.float -0.558796
	.float 0.073470
	.float 0.443318
	.float -0.787926
	.float 0.837980
	.float -0.609563
	.float 0.235793
	.float 0.125460
	.float -0.389008
	.float 0.570047
	.float -0.725592
	.float 0.869734
	.float -0.945008
	.float 0.877152
	.float -0.659929
	.float 0.387366
	.float -0.197952
	.float 0.173833
	.float -0.276754
	.float 0.372678
	.float -0.327273
	.float 0.103790
	.float 0.203096
	.float -0.417096
	.float 0.380040
	.float -0.040029
	.float -0.520783
	.float 1.128173
	.float -1.596589
	.float 1.802555
	.float -1.718330
	.float 1.403732
	.float -0.972923
	.float 0.554823
	.float -0.254443
	.float 0.119587
	.float -0.122541
	.float 0.172299
	.float -0.162062
	.float 0.032229
	.float 0.189992
	.float -0.405746
	.float 0.510978
	.float -0.469612
	.float 0.338522
	.float -0.221559
	.float 0.185540
	.float -0.205582
	.float 0.188133
	.float -0.057889
	.float -0.161825
	.float 0.346485
	.float -0.357892
	.float 0.158997
	.float 0.136055
	.float -0.326007
	.float 0.264464
	.float 0.021243
	.float -0.327005
	.float 0.398712
	.float -0.106879
	.float -0.454051
	.float 1.016182
	.float -1.306998
	.float 1.218919
	.float -0.861230
	.float 0.462849
	.float -0.203489
	.float 0.099407
	.float -0.024008
	.float -0.161062
	.float 0.472231
	.float -0.774195
	.float 0.878487
	.float -0.694303
	.float 0.312907
	.float 0.042947
	.float -0.170913
	.float 0.030041
	.float 0.233755
	.float -0.395642
	.float 0.312106
	.float -0.017151
	.float -0.309739
	.float 0.471361
	.float -0.378827
	.float 0.091377
	.float 0.241780
	.float -0.478785
	.float 0.549649
	.float -0.458876
	.float 0.250842
	.float 0.020407
	.float -0.299063
	.float 0.526616
	.float -0.650183
	.float 0.639832
	.float -0.500290
	.float 0.268718
	.float -0.006441
	.float -0.206243
	.float 0.279298
	.float -0.141860
	.float -0.210395
	.float 0.681758
	.float -1.098297
	.float 1.291756
	.float -1.198631
	.float 0.902203
	.float -0.580181
	.float 0.390489
	.float -0.378055
	.float 0.468861
	.float -0.548564
	.float 0.557291
	.float -0.524485
	.float 0.523138
	.float -0.591200
	.float 0.691534
	.float -0.743108
	.float 0.691332
	.float -0.553235
	.float 0.397922
	.float -0.281785
	.float 0.197061
	.float -0.081008
	.float -0.119636
	.float 0.383267
	.float -0.605619
	.float 0.663926
	.float -0.508492
	.float 0.210165
	.float 0.077557
	.float -0.218305
	.float 0.180971
	.float -0.050463
	.float -0.045219
	.float 0.033848
	.float 0.051171
	.float -0.103668
	.float 0.030440
	.float 0.174841
	.float -0.420181
	.float 0.570739
	.float -0.533477
	.float 0.319014
	.float -0.043636
	.float -0.133021
	.float 0.102999
	.float 0.117117
	.float -0.384451
	.float 0.509666
	.float -0.374797
	.float 0.014058
	.float 0.399860
	.float -0.660111
	.float 0.653626
	.float -0.427387
	.float 0.149322
	.float 0.008095
	.float 0.018677
	.float -0.149358
	.float 0.225024
	.float -0.128123
	.float -0.122301
	.float 0.364028
	.float -0.382707
	.float 0.050552
	.float 0.569919
	.float -1.225497
	.float 1.589892
	.float -1.443867
	.float 0.816398
	.float 0.004849
	.float -0.615577
	.float 0.717420
	.float -0.288924
	.float -0.404560
	.float 0.974452
	.float -1.144661
	.float 0.907597
	.float -0.500275
	.float 0.222426
	.float -0.225126
	.float 0.415901
	.float -0.540898
	.float 0.380406
	.float 0.082131
	.float -0.634721
	.float 0.972002
	.float -0.899178
	.float 0.468524
	.float 0.043868
	.float -0.309733
	.float 0.159310
	.float 0.306827
	.float -0.781798
	.float 0.952862
	.float -0.704508
	.float 0.187072
	.float 0.293013
	.float -0.479912
	.float 0.326180
	.float 0.001376
	.float -0.256280
	.float 0.279384
	.float -0.081684
	.float -0.197160
	.float 0.401383
	.float -0.451213
	.float 0.360261
	.float -0.191787
	.float 0.007325
	.float 0.154586
	.float -0.274152
	.float 0.347994
	.float -0.398200
	.float 0.472076
	.float -0.609750
	.float 0.792721
	.float -0.921477
	.float 0.862682
	.float -0.547664
	.float 0.049591
	.float 0.431092
	.float -0.676468
	.float 0.582884
	.float -0.221695
	.float -0.210417
	.float 0.510289
	.float -0.572506
	.float 0.418887
	.float -0.153674
	.float -0.109267
	.float 0.297955
	.float -0.393470
	.float 0.411710
	.float -0.377378
	.float 0.304428
	.float -0.187905
	.float 0.008803
	.float 0.247330
	.float -0.563732
	.float 0.873215
	.float -1.066507
	.float 1.036816
	.float -0.744110
	.float 0.259945
	.float 0.245475
	.float -0.581337
	.float 0.641334
	.float -0.469990
	.float 0.241825
	.float -0.158539
	.float 0.327369
	.float -0.698726
	.float 1.102845
	.float -1.358399
	.float 1.378813
	.float -1.207433
	.float 0.964289
	.float -0.749245
	.float 0.574780
	.float -0.377587
	.float 0.097631
	.float 0.242712
	.float -0.531838
	.float 0.651232
	.float -0.586219
	.float 0.467686
	.float -0.492564
	.float 0.769405
	.float -1.207456
	.float 1.548798
	.float -1.536846
	.float 1.104150
	.float -0.436749
	.float -0.141362
	.float 0.386170
	.float -0.297073
	.float 0.105355
	.float -0.096076
	.float 0.395329
	.float -0.881289
	.float 1.284105
	.float -1.395202
	.float 1.222070
	.float -0.967848
	.float 0.854348
	.float -0.933519
	.float 1.042270
	.float -0.938708
	.float 0.511004
	.float 0.108814
	.float -0.616590
	.float 0.738337
	.float -0.413367
	.float -0.168801
	.float 0.691835
	.float -0.902107
	.float 0.739922
	.float -0.341660
	.float -0.068537
	.float 0.316579
	.float -0.359060
	.float 0.267572
	.float -0.145267
	.float 0.046820
	.float 0.038627
	.float -0.139325
	.float 0.241719
	.float -0.281692
	.float 0.198056
	.float 0.000270
	.float -0.217924
	.float 0.328597
	.float -0.261181
	.float 0.050262
	.float 0.185775
	.float -0.320323
	.float 0.294185
	.float -0.144409
	.float -0.026160
	.float 0.115796
	.float -0.086744
	.float -0.013131
	.float 0.084818
	.float -0.049252
	.float -0.091285
	.float 0.248226
	.float -0.308562
	.float 0.223186
	.float -0.055498
	.float -0.051087
	.float -0.029486
	.float 0.309900
	.float -0.661086
	.float 0.873203
	.float -0.770487
	.float 0.314147
	.float 0.361459
	.float -0.997462
	.float 1.320178
	.float -1.163021
	.float 0.546701
	.float 0.319640
	.float -1.120531
	.float 1.564979
	.float -1.504857
	.float 0.983742
	.float -0.195992
	.float -0.612650
	.float 1.242382
	.float -1.585210
	.float 1.615515
	.float -1.360289
	.float 0.885628
	.float -0.301826
	.float -0.243249
	.float 0.610030
	.float -0.738635
	.float 0.692729
	.float -0.627475
	.float 0.686685
	.float -0.896275
	.float 1.134849
	.float -1.210264
	.float 0.990717
	.float -0.496406
	.float -0.110806
	.float 0.623410
	.float -0.894328
	.float 0.884526
	.float -0.642684
	.float 0.259118
	.float 0.162057
	.float -0.508617
	.float 0.672763
	.float -0.590866
	.float 0.291821
	.float 0.091427
	.float -0.376323
	.float 0.429730
	.float -0.249400
	.float -0.031275
	.float 0.224937
	.float -0.207544
	.float -0.005572
	.float 0.273479
	.float -0.420425
	.float 0.341380
	.float -0.057923
	.float -0.300434
	.float 0.567505
	.float -0.620250
	.float 0.431184
	.float -0.076851
	.float -0.297746
	.float 0.544830
	.float -0.581489
	.float 0.422934
	.float -0.159416
	.float -0.108446
	.float 0.328162
	.float -0.502772
	.float 0.645874
	.float -0.731094
	.float 0.691654
	.float -0.480386
	.float 0.139913
	.float 0.187821
	.float -0.337943
	.float 0.234891
	.float 0.049507
	.float -0.345350
	.float 0.506867
	.float -0.509398
	.float 0.441670
	.float -0.402876
	.float 0.397598
	.float -0.325625
	.float 0.081264
	.float 0.322093
	.float -0.715459
	.float 0.871000
	.float -0.667551
	.float 0.197497
	.float 0.274068
	.float -0.477826
	.float 0.318380
	.float 0.066326
	.float -0.407475
	.float 0.494424
	.float -0.312493
	.float 0.031953
	.float 0.134405
	.float -0.089424
	.float -0.096770
	.float 0.271942
	.float -0.342575
	.float 0.348444
	.float -0.413454
	.float 0.625010
	.float -0.951786
	.float 1.268622
	.float -1.457473
	.float 1.488184
	.float -1.409604
	.float 1.270812
	.float -1.058728
	.float 0.719750
	.float -0.247997
	.float -0.247302
	.float 0.572164
	.float -0.567225
	.float 0.225188
	.float 0.290671
	.float -0.745573
	.float 0.974279
	.float -0.958820
	.float 0.795487
	.float -0.594750
	.float 0.404584
	.float -0.212204
	.float 0.001885
	.float 0.201113
	.float -0.347725
	.float 0.424049
	.float -0.487697
	.float 0.635969
	.float -0.924619
	.float 1.303586
	.float -1.625086
	.float 1.720479
	.float -1.490869
	.float 0.955395
	.float -0.241827
	.float -0.459108
	.float 0.951082
	.float -1.094318
	.float 0.867600
	.float -0.401073
	.float -0.062730
	.float 0.288882
	.float -0.190369
	.float -0.113208
	.float 0.377107
	.float -0.405335
	.float 0.188251
	.float 0.103954
	.float -0.264672
	.float 0.214032
	.float -0.052039
	.float -0.034008
	.float -0.074528
	.float 0.334105
	.float -0.574658
	.float 0.627141
	.float -0.442442
	.float 0.120501
	.float 0.157889
	.float -0.239963
	.float 0.080050
	.float 0.248788
	.float -0.602737
	.float 0.840248
	.float -0.883867
	.float 0.747335
	.float -0.520891
	.float 0.323449
	.float -0.243893
	.float 0.300449
	.float -0.438510
	.float 0.566891
	.float -0.609625
	.float 0.542287
	.float -0.394149
	.float 0.219859
	.float -0.062824
	.float -0.065298
	.float 0.178474
	.float -0.291090
	.float 0.393279
	.float -0.445312
	.float 0.397726
	.float -0.226245
	.float -0.040860
	.float 0.323771
	.float -0.525081
	.float 0.578446
	.float -0.481393
	.float 0.290717
	.float -0.084988
	.float -0.077775
	.float 0.178516
	.float -0.225446
	.float 0.230479
	.float -0.196537
	.float 0.121651
	.float -0.008090
	.float -0.134731
	.float 0.291881
	.float -0.440922
	.float 0.548186
	.float -0.575779
	.float 0.505154
	.float -0.360026
	.float 0.201101
	.float -0.087198
	.float 0.031789
	.float 0.003659
	.float -0.070564
	.float 0.183447
	.float -0.306845
	.float 0.389908
	.float -0.410721
	.float 0.383729
	.float -0.323208
	.float 0.207852
	.float 0.003795
	.float -0.306365
	.float 0.589492
	.float -0.660540
	.float 0.361844
	.float 0.290027
	.float -1.054436
	.float 1.568439
	.float -1.553140
	.float 0.991325
	.float -0.152345
	.float -0.557044
	.float 0.817060
	.float -0.551846
	.float -0.065191
	.float 0.732820
	.float -1.175694
	.float 1.245252
	.float -0.942576
	.float 0.387807
	.float 0.232434
	.float -0.725270
	.float 0.953425
	.float -0.882675
	.float 0.590651
	.float -0.225997
	.float -0.065008
	.float 0.205528
	.float -0.213888
	.float 0.177285
	.float -0.191989
	.float 0.305432
	.float -0.492433
	.float 0.675562
	.float -0.772311
	.float 0.736921
	.float -0.573809
	.float 0.323503
	.float -0.039305
	.float -0.228064
	.float 0.436022
	.float -0.552773
	.float 0.559997
	.float -0.453136
	.float 0.240719
	.float 0.050608
	.float -0.363239
	.float 0.604627
	.float -0.676495
	.float 0.537399
	.float -0.257948
	.float 0.009435
	.float 0.034687
	.float 0.169698
	.float -0.475468
	.float 0.621523
	.float -0.415972
	.float -0.102086
	.float 0.653030
	.float -0.886606
	.float 0.621967
	.float 0.012213
	.float -0.641343
	.float 0.870747
	.float -0.519254
	.float -0.289605
	.float 1.219819
	.float -1.916665
	.float 2.171739
	.float -1.977335
	.float 1.476143
	.float -0.868491
	.float 0.335485
	.float 0.002043
	.float -0.098177
	.float -0.018347
	.float 0.260311
	.float -0.517219
	.float 0.700699
	.float -0.778713
	.float 0.778278
	.float -0.754163
	.float 0.741925
	.float -0.724540
	.float 0.637382
	.float -0.415003
	.float 0.055462
	.float 0.344095
	.float -0.618277
	.float 0.627973
	.float -0.361784
	.float -0.032232
	.float 0.321667
	.float -0.331741
	.float 0.057391
	.float 0.335735
	.float -0.624319
	.float 0.674343
	.float -0.518569
	.float 0.313024
	.float -0.209018
	.float 0.237839
	.float -0.295108
	.float 0.236805
	.float -0.011957
	.float -0.276544
	.float 0.439378
	.float -0.349153
	.float 0.050303
	.float 0.264052
	.float -0.394596
	.float 0.284245
	.float -0.054063
	.float -0.097097
	.float 0.043419
	.float 0.183815
	.float -0.431190
	.float 0.534496
	.float -0.419575
	.float 0.133826
	.float 0.191325
	.float -0.409785
	.float 0.425122
	.float -0.229560
	.float -0.092228
	.float 0.397741
	.float -0.550403
	.float 0.483247
	.float -0.227354
	.float -0.110567
	.float 0.404316
	.float -0.560796
	.float 0.543003
	.float -0.365689
	.float 0.083587
	.float 0.216353
	.float -0.428290
	.float 0.461704
	.float -0.291305
	.float -0.010791
	.float 0.296637
	.float -0.419125
	.float 0.318058
	.float -0.055394
	.float -0.227252
	.float 0.397663
	.float -0.404435
	.float 0.287552
	.float -0.135097
	.float 0.027602
	.float -0.005565
	.float 0.065935
	.float -0.174999
	.float 0.288243
	.float -0.374523
	.float 0.433995
	.float -0.491709
	.float 0.560707
	.float -0.603044
	.float 0.534389
	.float -0.288092
	.float -0.104696
	.float 0.493980
	.float -0.687132
	.float 0.579466
	.float -0.242191
	.float -0.105858
	.float 0.231040
	.float -0.032873
	.float -0.394543
	.float 0.827471
	.float -1.056841
	.float 1.012388
	.float -0.784966
	.float 0.539453
	.float -0.388966
	.float 0.325566
	.float -0.255809
	.float 0.104335
	.float 0.104633
	.float -0.257928
	.float 0.248013
	.float -0.072859
	.float -0.143146
	.float 0.229166
	.float -0.091175
	.float -0.212826
	.float 0.503175
	.float -0.595626
	.float 0.425131
	.float -0.091841
	.float -0.200495
	.float 0.270039
	.float -0.061334
	.float -0.335520
	.float 0.751776
	.float -1.036077
	.float 1.114284
	.float -0.989265
	.float 0.707733
	.float -0.337303
	.float -0.031794
	.float 0.285961
	.float -0.321488
	.float 0.109323
	.float 0.256635
	.float -0.582846
	.float 0.678903
	.float -0.479671
	.float 0.097068
	.float 0.247361
	.float -0.371286
	.float 0.257927
	.float -0.065909
	.float 0.011288
	.float -0.206497
	.float 0.574304
	.float -0.900316
	.float 0.984032
	.float -0.776651
	.float 0.407072
	.float -0.083149
	.float -0.053455
	.float 0.014283
	.float 0.061568
	.float -0.015622
	.float -0.220931
	.float 0.588103
	.float -0.941700
	.float 1.141362
	.float -1.123595
	.float 0.923182
	.float -0.642816
	.float 0.397162
	.float -0.262781
	.float 0.254484
	.float -0.332367
	.float 0.431065
	.float -0.494066
	.float 0.495849
	.float -0.440880
	.float 0.343064
	.float -0.202175
	.float -0.002288
	.float 0.291103
	.float -0.651358
	.float 1.015103
	.float -1.273346
	.float 1.324234
	.float -1.128951
	.float 0.740113
	.float -0.284602
	.float -0.088353
	.float 0.263841
	.float -0.196952
	.float -0.078952
	.float 0.464920
	.float -0.825664
	.float 1.036509
	.float -1.039388
	.float 0.878338
	.float -0.678671
	.float 0.565905
	.float -0.574947
	.float 0.624107
	.float -0.587844
	.float 0.418199
	.float -0.210515
	.float 0.143633
	.float -0.328269
	.float 0.685487
	.float -0.967314
	.float 0.922911
	.float -0.492144
	.float -0.125710
	.float 0.592553
	.float -0.661944
	.float 0.350223
	.float 0.082077
	.float -0.328069
	.float 0.263227
	.float -0.029854
	.float -0.088703
	.float -0.094291
	.float 0.508477
	.float -0.872759
	.float 0.913225
	.float -0.579084
	.float 0.084790
	.float 0.252122
	.float -0.245379
	.float -0.036303
	.float 0.340966
	.float -0.428326
	.float 0.230684
	.float 0.129903
	.float -0.453195
	.float 0.596058
	.float -0.534192
	.float 0.332933
	.float -0.080596
	.float -0.154367
	.float 0.326370
	.float -0.402730
	.float 0.370305
	.float -0.256598
	.float 0.135218
	.float -0.091629
	.float 0.161865
	.float -0.290085
	.float 0.349102
	.float -0.224076
	.float -0.093956
	.float 0.477274
	.float -0.727938
	.float 0.704171
	.float -0.417978
	.float 0.030159
	.float 0.257049
	.float -0.332209
	.float 0.236269
	.float -0.112665
	.float 0.089925
	.float -0.187689
	.float 0.312049
	.float -0.334391
	.float 0.187558
	.float 0.091156
	.float -0.393088
	.float 0.612579
	.float -0.705328
	.float 0.695531
	.float -0.640017
	.float 0.584297
	.float -0.540708
	.float 0.495411
	.float -0.430770
	.float 0.345988
	.float -0.265543
	.float 0.233056
	.float -0.291579
	.float 0.457174
	.float -0.698798
	.float 0.940254
	.float -1.089764
	.float 1.083442
	.float -0.915600
	.float 0.635808
	.float -0.317563
	.float 0.025212
	.float 0.195534
	.float -0.304532
	.float 0.257896
	.float -0.026881
	.float -0.362544
	.float 0.808464
	.float -1.165345
	.float 1.322663
	.float -1.275995
	.float 1.131800
	.float -1.032160
	.float 1.048827
	.float -1.123407
	.float 1.099093
	.float -0.825491
	.float 0.267944
	.float 0.447801
	.float -1.082441
	.float 1.395181
	.float -1.262178
	.float 0.742786
	.float -0.060752
	.float -0.494224
	.float 0.700404
	.float -0.506513
	.float 0.046237
	.float 0.445902
	.float -0.767793
	.float 0.849210
	.float -0.757322
	.float 0.613288
	.float -0.487679
	.float 0.353552
	.float -0.129280
	.float -0.227304
	.float 0.652624
	.float -0.998460
	.float 1.132358
	.float -1.042815
	.float 0.861484
	.float -0.772141
	.float 0.866992
	.float -1.061005
	.float 1.138944
	.float -0.907809
	.float 0.342286
	.float 0.384460
	.float -1.002445
	.float 1.297595
	.float -1.208726
	.float 0.821170
	.float -0.292070
	.float -0.222726
	.float 0.600895
	.float -0.759003
	.float 0.665014
	.float -0.366583
	.float 0.004992
	.float 0.223216
	.float -0.160634
	.float -0.207864
	.float 0.716052
	.float -1.085886
	.float 1.080465
	.float -0.649969
	.float -0.029554
	.float 0.661092
	.float -1.011446
	.float 1.049951
	.float -0.942910
	.float 0.909964
	.float -1.050910
	.float 1.271539
	.float -1.358134
	.float 1.137299
	.float -0.599193
	.float -0.098737
	.float 0.735356
	.float -1.149960
	.float 1.302206
	.float -1.246253
	.float 1.063139
	.float -0.812494
	.float 0.530714
	.float -0.255599
	.float 0.039408
	.float 0.068227
	.float -0.053090
	.float -0.046114
	.float 0.155132
	.float -0.207668
	.float 0.185696
	.float -0.126551
	.float 0.089044
	.float -0.100403
	.float 0.124801
	.float -0.084529
	.float -0.072880
	.float 0.309489
	.float -0.492412
	.float 0.469135
	.float -0.178505
	.float -0.285817
	.float 0.716654
	.float -0.920551
	.float 0.843798
	.float -0.606004
	.float 0.415975
	.float -0.428875
	.float 0.643802
	.float -0.908536
	.float 1.022930
	.float -0.870276
	.float 0.494349
	.float -0.079889
	.float -0.147733
	.float 0.046430
	.float 0.360538
	.float -0.886111
	.float 1.266601
	.float -1.295285
	.float 0.935670
	.float -0.349910
	.float -0.185137
	.float 0.437977
	.float -0.366854
	.float 0.150318
	.float -0.069002
	.float 0.306470
	.float -0.805767
	.float 1.290856
	.float -1.446141
	.float 1.126653
	.float -0.446525
	.float -0.311003
	.float 0.880141
	.float -1.148574
	.float 1.155364
	.float -0.986887
	.float 0.683997
	.float -0.240992
	.float -0.322007
	.float 0.901967
	.float -1.339235
	.float 1.511446
	.float -1.412539
	.float 1.145624
	.float -0.834421
	.float 0.530756
	.float -0.200097
	.float -0.201301
	.float 0.628608
	.float -0.926401
	.float 0.919111
	.float -0.552230
	.float -0.030373
	.float 0.546084
	.float -0.736742
	.float 0.519624
	.float -0.020471
	.float -0.524762
	.float 0.916116
	.float -1.077353
	.float 1.041307
	.float -0.875167
	.float 0.624510
	.float -0.317885
	.float 0.006383
	.float 0.221230
	.float -0.277987
	.float 0.143806
	.float 0.106139
	.float -0.345105
	.float 0.482931
	.float -0.528428
	.float 0.572614
	.float -0.703939
	.float 0.924267
	.float -1.134810
	.float 1.204348
	.float -1.064170
	.float 0.752837
	.float -0.377190
	.float 0.027762
	.float 0.274892
	.float -0.556263
	.float 0.812750
	.float -0.964700
	.float 0.898134
	.float -0.574953
	.float 0.116772
	.float 0.228811
	.float -0.240760
	.float -0.109124
	.float 0.611455
	.float -0.947592
	.float 0.906989
	.float -0.533558
	.float 0.090180
	.float 0.131283
	.float -0.010638
	.float -0.334257
	.float 0.651823
	.float -0.740509
	.float 0.572694
	.float -0.279935
	.float 0.030178
	.float 0.099701
	.float -0.164826
	.float 0.288834
	.float -0.553345
	.float 0.922047
	.float -1.248018
	.float 1.353580
	.float -1.129240
	.float 0.594383
	.float 0.108674
	.float -0.776892
	.float 1.230147
	.float -1.378881
	.float 1.250122
	.float -0.964492
	.float 0.675222
	.float -0.496725
	.float 0.457487
	.float -0.502090
	.float 0.539665
	.float -0.507559
	.float 0.408932
	.float -0.301698
	.float 0.250262
	.float -0.274494
	.float 0.329568
	.float -0.328477
	.float 0.194825
	.float 0.082335
	.float -0.421251
	.float 0.668868
	.float -0.671285
	.float 0.364827
	.float 0.163348
	.float -0.693481
	.float 0.978163
	.float -0.882398
	.float 0.469695
	.float 0.032074
	.float -0.373596
	.float 0.442597
	.float -0.325589
	.float 0.226815
	.float -0.305105
	.float 0.552463
	.float -0.804065
	.float 0.866315
	.float -0.660496
	.float 0.276331
	.float 0.092959
	.float -0.274081
	.float 0.205247
	.float 0.053842
	.float -0.378153
	.float 0.648657
	.float -0.796849
	.float 0.812446
	.float -0.725869
	.float 0.580914
	.float -0.410503
	.float 0.226737
	.float -0.033621
	.float -0.144114
	.float 0.242101
	.float -0.176097
	.float -0.098527
	.float 0.528020
	.float -0.957619
	.float 1.205972
	.float -1.173771
	.float 0.906739
	.float -0.560829
	.float 0.294629
	.float -0.172736
	.float 0.153330
	.float -0.158711
	.float 0.155860
	.float -0.169532
	.float 0.218383
	.float -0.243526
	.float 0.114817
	.float 0.267443
	.float -0.851094
	.float 1.403276
	.float -1.625405
	.float 1.348758
	.float -0.672248
	.float -0.067663
	.float 0.489450
	.float -0.398620
	.float -0.094884
	.float 0.651498
	.float -0.917347
	.float 0.737365
	.float -0.231262
	.float -0.305286
	.float 0.596872
	.float -0.548308
	.float 0.271760
	.float 0.019057
	.float -0.159930
	.float 0.125879
	.float -0.009196
	.float -0.078666
	.float 0.095131
	.float -0.076607
	.float 0.074269
	.float -0.083080
	.float 0.035462
	.float 0.129732
	.float -0.383214
	.float 0.586500
	.float -0.567103
	.float 0.238637
	.float 0.323461
	.float -0.908337
	.float 1.283202
	.float -1.320893
	.float 1.063396
	.float -0.687961
	.float 0.400965
	.float -0.323193
	.float 0.430815
	.float -0.582410
	.float 0.613291
	.float -0.439372
	.float 0.107909
	.float 0.234723
	.float -0.434949
	.float 0.423745
	.float -0.249918
	.float 0.038696
	.float 0.091739
	.float -0.098347
	.float 0.025751
	.float 0.035612
	.float -0.010708
	.float -0.118571
	.float 0.307534
	.float -0.469439
	.float 0.504802
	.float -0.330227
	.float -0.091630
	.float 0.721506
	.float -1.426262
	.float 1.998989
	.float -2.229942
	.float 2.009140
	.float -1.405980
	.float 0.663995
	.float -0.088382
	.float -0.123303
	.float 0.002729
	.float 0.208134
	.float -0.219714
	.float -0.101210
	.float 0.632089
	.float -1.078164
	.float 1.184796
	.float -0.924127
	.float 0.515469
	.float -0.260762
	.float 0.314663
	.float -0.560161
	.float 0.685478
	.float -0.412628
	.float -0.283219
	.float 1.121688
	.float -1.676481
	.float 1.642226
	.float -1.029293
	.float 0.155681
	.float 0.554051
	.float -0.822052
	.float 0.655179
	.float -0.292327
	.float 0.021850
	.float -0.006914
	.float 0.223916
	.float -0.521758
	.float 0.729458
	.float -0.736331
	.float 0.518920
	.float -0.135007
	.float -0.293882
	.float 0.615568
	.float -0.708293
	.float 0.552999
	.float -0.265365
	.float 0.043834
	.float -0.047949
	.float 0.285286
	.float -0.593897
	.float 0.743290
	.float -0.589334
	.float 0.176118
	.float 0.284250
	.float -0.537244
	.float 0.432698
	.float -0.003414
	.float -0.560838
	.float 1.016504
	.float -1.184087
	.float 1.024646
	.float -0.647796
	.float 0.254108
	.float -0.036842
	.float 0.083572
	.float -0.325977
	.float 0.572339
	.float -0.615881
	.float 0.360720
	.float 0.115725
	.float -0.609175
	.float 0.914280
	.float -0.941688
	.float 0.747800
	.float -0.468798
	.float 0.222383
	.float -0.053039
	.float -0.054626
	.float 0.129985
	.float -0.188393
	.float 0.235630
	.float -0.279882
	.float 0.324996
	.float -0.352092
	.float 0.319876
	.float -0.196874
	.float 0.000523
	.float 0.198250
	.float -0.317855
	.float 0.322642
	.float -0.243156
	.float 0.141351
	.float -0.051430
	.float -0.050986
	.float 0.225153
	.float -0.506668
	.float 0.861412
	.float -1.186912
	.float 1.358900
	.float -1.291789
	.float 0.978223
	.float -0.491688
	.float -0.041870
	.float 0.487542
	.float -0.745955
	.float 0.788242
	.float -0.669562
	.float 0.507645
	.float -0.424532
	.float 0.474443
	.float -0.602663
	.float 0.673082
	.float -0.559714
	.float 0.246095
	.float 0.141969
	.float -0.406604
	.float 0.413975
	.float -0.201701
	.float -0.029188
	.float 0.048523
	.float 0.227810
	.float -0.651265
	.float 0.920670
	.float -0.787705
	.float 0.243846
	.float 0.453365
	.float -0.943357
	.float 1.000186
	.float -0.672280
	.float 0.227686
	.float 0.042676
	.float -0.010154
	.float -0.247401
	.float 0.550621
	.float -0.768198
	.float 0.890087
	.float -0.983230
	.float 1.091111
	.float -1.173899
	.float 1.137704
	.float -0.918646
	.float 0.544809
	.float -0.127233
	.float -0.206139
	.float 0.377393
	.float -0.382558
	.float 0.271286
	.float -0.112291
	.float -0.029387
	.float 0.101568
	.float -0.074839
	.float -0.039904
	.float 0.178227
	.float -0.234465
	.float 0.109277
	.float 0.224970
	.float -0.681967
	.float 1.081117
	.float -1.234594
	.float 1.055971
	.float -0.616999
	.float 0.103982
	.float 0.304598
	.float -0.551613
	.float 0.716940
	.float -0.918643
	.float 1.178752
	.float -1.368926
	.float 1.291759
	.float -0.841342
	.float 0.114822
	.float 0.620489
	.float -1.085797
	.float 1.155632
	.float -0.907100
	.float 0.529301
	.float -0.181291
	.float -0.084008
	.float 0.285105
	.float -0.427265
	.float 0.466366
	.float -0.360529
	.float 0.151854
	.float 0.018157
	.float 0.002641
	.float -0.247484
	.float 0.572012
	.float -0.729559
	.float 0.536335
	.float -0.009917
	.float -0.618829
	.float 1.031841
	.float -1.008996
	.float 0.560319
	.float 0.070335
	.float -0.532640
	.float 0.559204
	.float -0.114048
	.float -0.585591
	.float 1.191529
	.float -1.422435
	.float 1.216252
	.float -0.741192
	.float 0.263225
	.float 0.032651
	.float -0.140056
	.float 0.186302
	.float -0.294414
	.float 0.469451
	.float -0.599119
	.float 0.559628
	.float -0.332468
	.float 0.033522
	.float 0.167475
	.float -0.168541
	.float 0.000998
	.float 0.207059
	.float -0.330579
	.float 0.327157
	.float -0.240157
	.float 0.138876
	.float -0.058682
	.float -0.007478
	.float 0.070995
	.float -0.112566
	.float 0.092822
	.float 0.000163
	.float -0.117875
	.float 0.176230
	.float -0.126445
	.float 0.011334
	.float 0.048822
	.float 0.060672
	.float -0.357668
	.float 0.733598
	.float -1.007875
	.float 1.028113
	.float -0.751537
	.float 0.264120
	.float 0.264351
	.float -0.659643
	.float 0.819042
	.float -0.751448
	.float 0.562268
	.float -0.385545
	.float 0.296783
	.float -0.261529
	.float 0.162529
	.float 0.102660
	.float -0.519651
	.float 0.933507
	.float -1.136608
	.float 1.014853
	.float -0.642541
	.float 0.243688
	.float -0.037466
	.float 0.082220
	.float -0.241625
	.float 0.303665
	.float -0.158006
	.float -0.112238
	.float 0.298461
	.float -0.235963
	.float -0.065555
	.float 0.432663
	.float -0.663032
	.float 0.669228
	.float -0.521549
	.float 0.371957
	.float -0.335344
	.float 0.423435
	.float -0.567109
	.float 0.686447
	.float -0.740125
	.float 0.720555
	.float -0.616593
	.float 0.392283
	.float -0.008911
	.float -0.524542
	.float 1.114883
	.float -1.597376
	.float 1.801324
	.float -1.639541
	.float 1.173521
	.float -0.610996
	.float 0.219570
	.float -0.185894
	.float 0.494192
	.float -0.908062
	.float 1.092333
	.float -0.821325
	.float 0.146794
	.float 0.598264
	.float -0.985602
	.float 0.761960
	.float -0.026495
	.float -0.812538
	.float 1.285527
	.float -1.155787
	.float 0.564027
	.float 0.077831
	.float -0.373298
	.float 0.211976
	.float 0.166535
	.float -0.363265
	.float 0.128904
	.float 0.435318
	.float -0.938123
	.float 0.981179
	.float -0.457275
	.float -0.358899
	.float 0.996505
	.float -1.113849
	.float 0.725142
	.float -0.168950
	.float -0.146643
	.float 0.027700
	.float 0.395034
	.float -0.790653
	.float 0.875560
	.float -0.596094
	.float 0.126987
	.float 0.285561
	.float -0.498573
	.float 0.534973
	.float -0.509660
	.float 0.503956
	.float -0.501443
	.float 0.431015
	.float -0.264702
	.float 0.072615
	.float 0.019252
	.float 0.066068
	.float -0.279847
	.float 0.466762
	.float -0.466667
	.float 0.219899
	.float 0.199651
	.float -0.637430
	.float 0.946347
	.float -1.047688
	.float 0.939786
	.float -0.674686
	.float 0.334426
	.float -0.017541
	.float -0.176795
	.float 0.179243
	.float 0.013408
	.float -0.321348
	.float 0.604794
	.float -0.723041
	.float 0.601608
	.float -0.271008
	.float -0.145545
	.float 0.490552
	.float -0.647408
	.float 0.593176
	.float -0.403096
	.float 0.204976
	.float -0.107120
	.float 0.136398
	.float -0.221085
	.float 0.233663
	.float -0.076698
	.float -0.238095
	.float 0.575192
	.float -0.750250
	.float 0.655411
	.float -0.347889
	.float 0.027590
	.float 0.093959
	.float 0.055283
	.float -0.349910
	.float 0.551548
	.float -0.479915
	.float 0.148414
	.float 0.234722
	.float -0.402936
	.float 0.212261
	.float 0.257863
	.float -0.753343
	.float 1.011607
	.float -0.931423
	.float 0.629019
	.float -0.342068
	.float 0.252985
	.float -0.363418
	.float 0.513827
	.float -0.530708
	.float 0.383428
	.float -0.223723
	.float 0.271568
	.float -0.632089
	.float 1.183520
	.float -1.626874
	.float 1.669518
	.float -1.218210
	.float 0.449893
	.float 0.286217
	.float -0.667714
	.float 0.569332
	.float -0.103837
	.float -0.473772
	.float 0.920530
	.float -1.119118
	.float 1.098869
	.float -0.978989
	.float 0.885801
	.float -0.888913
	.float 0.974709
	.float -1.057175
	.float 1.019729
	.float -0.776421
	.float 0.328930
	.float 0.211366
	.float -0.657667
	.float 0.831089
	.float -0.654693
	.float 0.205826
	.float 0.309829
	.float -0.658150
	.float 0.698735
	.float -0.456396
	.float 0.094537
	.float 0.192904
	.float -0.297076
	.float 0.237991
	.float -0.114737
	.float 0.013538
	.float 0.047695
	.float -0.100598
	.float 0.166439
	.float -0.221055
	.float 0.219199
	.float -0.148792
	.float 0.054470
	.float -0.000427
	.float 0.005696
	.float -0.017055
	.float -0.047317
	.float 0.217935
	.float -0.430964
	.float 0.565848
	.float -0.535143
	.float 0.350139
	.float -0.106333
	.float -0.096331
	.float 0.226760
	.float -0.327670
	.float 0.453931
	.float -0.604669
	.float 0.711059
	.float -0.689117
	.float 0.510334
	.float -0.231878
	.float -0.034763
	.float 0.189549
	.float -0.196750
	.float 0.093421
	.float 0.045738
	.float -0.161609
	.float 0.248131
	.float -0.347853
	.float 0.502772
	.float -0.691651
	.float 0.808014
	.float -0.714627
	.float 0.351877
	.float 0.181925
	.float -0.658058
	.float 0.856023
	.float -0.718865
	.float 0.401624
	.float -0.163378
	.float 0.177502
	.float -0.403699
	.float 0.619532
	.float -0.585382
	.float 0.217405
	.float 0.354235
	.float -0.870532
	.float 1.097772
	.float -0.943974
	.float 0.479259
	.float 0.122210
	.float -0.663464
	.float 0.988845
	.float -1.024918
	.float 0.802408
	.float -0.450092
	.float 0.143980
	.float -0.021055
	.float 0.104857
	.float -0.299036
	.float 0.460974
	.float -0.503038
	.float 0.443604
	.float -0.371122
	.float 0.358354
	.float -0.403398
	.float 0.445458
	.float -0.433861
	.float 0.383664
	.float -0.366836
	.float 0.446719
	.float -0.610975
	.float 0.758297
	.float -0.753224
	.float 0.514259
	.float -0.077766
	.float -0.406923
	.float 0.755051
	.float -0.853371
	.float 0.728424
	.float -0.525928
	.float 0.409701
	.float -0.448850
	.float 0.576026
	.float -0.648374
	.float 0.562200
	.float -0.330301
	.float 0.063264
	.float 0.121787
	.float -0.183250
	.float 0.161666
	.float -0.117964
	.float 0.071951
	.float -0.003268
	.float -0.090939
	.float 0.148502
	.float -0.067373
	.float -0.203274
	.float 0.582902
	.float -0.871686
	.float 0.866565
	.float -0.505741
	.float -0.065206
	.float 0.563148
	.float -0.734882
	.float 0.514915
	.float -0.068428
	.float -0.311516
	.float 0.388585
	.float -0.129533
	.float -0.285054
	.float 0.593885
	.float -0.639600
	.float 0.473430
	.float -0.303486
	.float 0.324606
	.float -0.557398
	.float 0.817924
	.float -0.842203
	.float 0.476371
	.float 0.200163
	.float -0.900000
	.float 1.282147
	.float -1.139415
	.float 0.512477
	.float 0.329449
	.float -1.028613
	.float 1.324595
	.float -1.182772
	.float 0.790060
	.float -0.419015
	.float 0.249424
	.float -0.270056
	.float 0.326624
	.float -0.272237
	.float 0.097175
	.float 0.063976
	.float -0.047451
	.float -0.200077
	.float 0.568259
	.float -0.851478
	.float 0.880821
	.float -0.624456
	.float 0.196510
	.float 0.216800
	.float -0.459225
	.float 0.476443
	.float -0.328132
	.float 0.143623
	.float -0.050014
	.float 0.109799
	.float -0.296546
	.float 0.515949
	.float -0.656538
	.float 0.643436
	.float -0.471689
	.float 0.207762
	.float 0.040075
	.float -0.169791
	.float 0.131449
	.float 0.050519
	.float -0.289287
	.float 0.472482
	.float -0.504468
	.float 0.338414
	.float 0.005409
	.float -0.435241
	.float 0.805263
	.float -0.964372
	.float 0.827578
	.float -0.433044
	.float -0.060214
	.float 0.447696
	.float -0.589301
	.float 0.484144
	.float -0.260291
	.float 0.087105
	.float -0.070316
	.float 0.197711
	.float -0.364186
	.float 0.450662
	.float -0.399320
	.float 0.239519
	.float -0.057116
	.float -0.062800
	.float 0.080513
	.float -0.012553
	.float -0.084611
	.float 0.140083
	.float -0.091556
	.float -0.092993
	.float 0.393827
	.float -0.728650
	.float 0.970882
	.float -1.003411
	.float 0.785887
	.float -0.394528
	.float 0.000853
	.float 0.207817
	.float -0.125550
	.float -0.213018
	.float 0.646809
	.float -0.969731
	.float 1.035895
	.float -0.832442
	.float 0.481945
	.float -0.172958
	.float 0.054202
	.float -0.147830
	.float 0.331544
	.float -0.406986
	.float 0.224945
	.float 0.202408
	.float -0.678522
	.float 0.919490
	.float -0.725553
	.float 0.120935
	.float 0.636440
	.float -1.192810
	.float 1.300832
	.float -0.955351
	.float 0.377113
	.float 0.135593
	.float -0.381861
	.float 0.345547
	.float -0.153617
	.float -0.044475
	.float 0.179483
	.float -0.277918
	.float 0.394620
	.float -0.528956
	.float 0.599608
	.float -0.503511
	.float 0.216561
	.float 0.144026
	.float -0.355966
	.float 0.220973
	.float 0.290089
	.float -0.977716
	.float 1.499030
	.float -1.564019
	.float 1.124921
	.float -0.427453
	.float -0.127495
	.float 0.234168
	.float 0.120402
	.float -0.650648
	.float 0.967278
	.float -0.838203
	.float 0.334200
	.float 0.235846
	.float -0.541188
	.float 0.436594
	.float -0.024432
	.float -0.444936
	.float 0.737127
	.float -0.743916
	.float 0.492689
	.float -0.093862
	.float -0.309823
	.float 0.569860
	.float -0.560990
	.float 0.235903
	.float 0.319709
	.float -0.891390
	.float 1.228585
	.float -1.182558
	.float 0.796673
	.float -0.283913
	.float -0.094235
	.float 0.166888
	.float 0.070107
	.float -0.470086
	.float 0.815972
	.float -0.917150
	.float 0.684509
	.float -0.163239
	.float -0.484433
	.float 1.042994
	.float -1.330976
	.float 1.272025
	.float -0.914208
	.float 0.389968
	.float 0.153343
	.float -0.606478
	.float 0.906855
	.float -1.013643
	.float 0.888487
	.float -0.512360
	.float -0.069853
	.float 0.721250
	.float -1.242528
	.float 1.457586
	.float -1.304343
	.float 0.867921
	.float -0.332641
	.float -0.114795
	.float 0.367876
	.float -0.424326
	.float 0.352780
	.float -0.238240
	.float 0.143126
	.float -0.096325
	.float 0.099380
	.float -0.133879
	.float 0.165046
	.float -0.148021
	.float 0.045035
	.float 0.147653
	.float -0.376234
	.float 0.529781
	.float -0.479164
	.float 0.148778
	.float 0.413927
	.float -1.021922
	.float 1.417356
	.float -1.402957
	.float 0.958453
	.float -0.259390
	.float -0.423048
	.float 0.874216
	.float -1.033633
	.float 0.977495
	.float -0.820460
	.float 0.630962
	.float -0.426702
	.float 0.230348
	.float -0.106425
	.float 0.123211
	.float -0.268116
	.float 0.405529
	.float -0.343156
	.float -0.021454
	.float 0.584142
	.float -1.054132
	.float 1.122659
	.float -0.677207
	.float -0.089132
	.float 0.761951
	.float -0.943008
	.float 0.493610
	.float 0.373551
	.float -1.215587
	.float 1.618231
	.float -1.429460
	.float 0.826943
	.float -0.190235
	.float -0.127669
	.float -0.015902
	.float 0.510021
	.float -1.082590
	.float 1.449050
	.float -1.434002
	.float 1.026566
	.float -0.371459
	.float -0.290533
	.float 0.719974
	.float -0.786447
	.float 0.534794
	.float -0.160196
	.float -0.106436
	.float 0.133889
	.float 0.045893
	.float -0.288322
	.float 0.454015
	.float -0.497935
	.float 0.466211
	.float -0.422642
	.float 0.385190
	.float -0.331848
	.float 0.258960
	.float -0.218287
	.float 0.282075
	.float -0.463511
	.float 0.677002
	.float -0.792808
	.float 0.748181
	.float -0.611649
	.float 0.528225
	.float -0.582071
	.float 0.697501
	.float -0.676367
	.float 0.352968
	.float 0.258085
	.float -0.944758
	.float 1.426563
	.float -1.526888
	.float 1.259996
	.float -0.785479
	.float 0.292843
	.float 0.083858
	.float -0.275168
	.float 0.246975
	.float 0.002633
	.float -0.407117
	.float 0.808843
	.float -1.010298
	.float 0.890773
	.float -0.502844
	.float 0.057057
	.float 0.213881
	.float -0.216396
	.float 0.057282
	.float 0.047049
	.float 0.056106
	.float -0.335389
	.float 0.601029
	.float -0.652031
	.float 0.426478
	.float -0.040212
	.float -0.306923
	.float 0.475665
	.float -0.470863
	.float 0.412053
	.float -0.430415
	.float 0.577668
	.float -0.805668
	.float 1.010597
	.float -1.093558
	.float 0.998251
	.float -0.721297
	.float 0.311680
	.float 0.135008
	.float -0.499848
	.float 0.688748
	.float -0.683970
	.float 0.556161
	.float -0.413507
	.float 0.315763
	.float -0.220563
	.float 0.015215
	.float 0.377736
	.float -0.897506
	.float 1.331623
	.float -1.422053
	.float 1.034440
	.float -0.280938
	.float -0.495393
	.float 0.884833
	.float -0.639251
	.float -0.171074
	.float 1.175932
	.float -1.901354
	.float 2.032957
	.float -1.585442
	.float 0.873251
	.float -0.305495
	.float 0.143323
	.float -0.374770
	.float 0.772108
	.float -1.067783
	.float 1.115971
	.float -0.939304
	.float 0.657709
	.float -0.377661
	.float 0.129107
	.float 0.117295
	.float -0.385735
	.float 0.644419
	.float -0.808074
	.float 0.789276
	.float -0.561258
	.float 0.190030
	.float 0.185156
	.float -0.413919
	.float 0.406369
	.float -0.176463
	.float -0.166510
	.float 0.473340
	.float -0.626450
	.float 0.589045
	.float -0.407800
	.float 0.174648
	.float 0.024650
	.float -0.143809
	.float 0.177727
	.float -0.141824
	.float 0.051878
	.float 0.077033
	.float -0.213732
	.float 0.297605
	.float -0.255452
	.float 0.053459
	.float 0.247968
	.float -0.490183
	.float 0.493595
	.float -0.182585
	.float -0.331094
	.float 0.785857
	.float -0.924410
	.float 0.663411
	.float -0.153225
	.float -0.321369
	.float 0.527412
	.float -0.420031
	.float 0.136542
	.float 0.130846
	.float -0.274815
	.float 0.320570
	.float -0.361710
	.float 0.453097
	.float -0.554409
	.float 0.567425
	.float -0.428973
	.float 0.179086
	.float 0.054156
	.float -0.143048
	.float 0.053799
	.float 0.126687
	.float -0.252288
	.float 0.223070
	.float -0.058499
	.float -0.113934
	.float 0.147959
	.float 0.015120
	.float -0.296033
	.float 0.519549
	.float -0.524223
	.float 0.269437
	.float 0.130010
	.float -0.464908
	.float 0.550013
	.float -0.327288
	.float -0.104395
	.float 0.544889
	.float -0.796581
	.float 0.758246
	.float -0.461645
	.float 0.037183
	.float 0.365787
	.float -0.652952
	.float 0.807156
	.float -0.850948
	.float 0.789371
	.float -0.591098
	.float 0.231354
	.float 0.240917
	.float -0.681836
	.float 0.914861
	.float -0.839890
	.float 0.505172
	.float -0.082564
	.float -0.235882
	.float 0.342727
	.float -0.250882
	.float 0.052597
	.float 0.150818
	.float -0.294883
	.float 0.357570
	.float -0.344971
	.float 0.280876
	.float -0.201950
	.float 0.145338
	.float -0.123832
	.float 0.106635
	.float -0.031482
	.float -0.147281
	.float 0.405120
	.float -0.635934
	.float 0.706091
	.float -0.545080
	.float 0.206593
	.float 0.153445
	.float -0.374925
	.float 0.398980
	.float -0.302383
	.float 0.234263
	.float -0.303176
	.float 0.498767
	.float -0.703584
	.float 0.781056
	.float -0.670772
	.float 0.422279
	.float -0.149257
	.float -0.053625
	.float 0.165766
	.float -0.229839
	.float 0.292719
	.float -0.352727
	.float 0.358324
	.float -0.258271
	.float 0.059364
	.float 0.158659
	.float -0.286940
	.float 0.259069
	.float -0.095796
	.float -0.111272
	.float 0.265034
	.float -0.325744
	.float 0.323336
	.float -0.313569
	.float 0.321146
	.float -0.322651
	.float 0.281890
	.float -0.197575
	.float 0.110114
	.float -0.056711
	.float 0.022431
	.float 0.052982
	.float -0.204567
	.float 0.370279
	.float -0.398599
	.float 0.156550
	.float 0.333431
	.float -0.843944
	.float 1.046034
	.float -0.717989
	.float -0.080168
	.float 1.001590
	.float -1.601829
	.float 1.607727
	.float -1.085087
	.float 0.386063
	.float 0.090017
	.float -0.156865
	.float -0.057294
	.float 0.230942
	.float -0.098285
	.float -0.354709
	.float 0.882940
	.float -1.160666
	.float 1.013643
	.float -0.540326
	.float 0.039729
	.float 0.199317
	.float -0.096242
	.float -0.176697
	.float 0.332659
	.float -0.187507
	.float -0.204962
	.float 0.597557
	.float -0.735460
	.float 0.540863
	.float -0.162390
	.float -0.136730
	.float 0.159885
	.float 0.101628
	.float -0.477146
	.float 0.729473
	.float -0.688721
	.float 0.332900
	.float 0.212217
	.float -0.738307
	.float 1.049954
	.float -1.051372
	.float 0.786507
	.float -0.409060
	.float 0.091110
	.float 0.078567
	.float -0.138109
	.float 0.200631
	.float -0.339365
	.float 0.499303
	.float -0.516709
	.float 0.248117
	.float 0.285642
	.float -0.863558
	.float 1.185511
	.float -1.072140
	.float 0.590121
	.float -0.000549
	.float -0.430618
	.float 0.608039
	.float -0.632071
	.float 0.669351
	.float -0.793797
	.float 0.934729
	.float -0.959931
	.float 0.799660
	.float -0.495470
	.float 0.144573
	.float 0.188014
	.float -0.497774
	.float 0.789741
	.float -1.013207
	.float 1.060642
	.float -0.845908
	.float 0.398536
	.float 0.111654
	.float -0.454763
	.float 0.480392
	.float -0.220967
	.float -0.119599
	.float 0.295385
	.float -0.185254
	.float -0.118980
	.float 0.372973
	.float -0.355185
	.float 0.034638
	.float 0.394835
	.float -0.646046
	.float 0.543867
	.float -0.153527
	.float -0.264019
	.float 0.435977
	.float -0.264376
	.float -0.118415
	.float 0.456876
	.float -0.554016
	.float 0.394394
	.float -0.131874
	.float -0.030077
	.float -0.029945
	.float 0.292349
	.float -0.628640
	.float 0.883375
	.float -0.949846
	.float 0.807329
	.float -0.517186
	.float 0.189211
	.float 0.067120
	.float -0.188122
	.float 0.176165
	.float -0.082646
	.float -0.034323
	.float 0.145095
	.float -0.249969
	.float 0.351257
	.float -0.428076
	.float 0.443014
	.float -0.376859
	.float 0.257399
	.float -0.149838
	.float 0.111335
	.float -0.145260
	.float 0.193119
	.float -0.171287
	.float 0.025657
	.float 0.232478
	.float -0.527492
	.float 0.751141
	.float -0.806369
	.float 0.647480
	.float -0.304896
	.float -0.116750
	.float 0.474073
	.float -0.645954
	.float 0.590970
	.float -0.365534
	.float 0.088105
	.float 0.128589
	.float -0.232097
	.float 0.238333
	.float -0.197634
	.float 0.154660
	.float -0.134513
	.float 0.155004
	.float -0.236399
	.float 0.384576
	.float -0.557622
	.float 0.655393
	.float -0.562552
	.float 0.229735
	.float 0.264477
	.float -0.728152
	.float 0.953482
	.float -0.840364
	.float 0.464038
	.float -0.038842
	.float -0.200695
	.float 0.127728
	.float 0.215109
	.float -0.648481
	.float 0.954924
	.float -0.983212
	.float 0.706866
	.float -0.218428
	.float -0.323354
	.float 0.759385
	.float -0.979325
	.float 0.943324
	.float -0.683120
	.float 0.293156
	.float 0.088180
	.float -0.316511
	.float 0.299308
	.float -0.048450
	.float -0.313277
	.float 0.613527
	.float -0.730906
	.float 0.665321
	.float -0.522029
	.float 0.417552
	.float -0.382063
	.float 0.340203
	.float -0.188867
	.float -0.092517
	.float 0.395562
	.float -0.547229
	.float 0.441220
	.float -0.134833
	.float -0.167770
	.float 0.239724
	.float 0.022543
	.float -0.531829
	.float 1.063270
	.float -1.385975
	.float 1.384523
	.float -1.097507
	.float 0.663983
	.float -0.229292
	.float -0.120606
	.float 0.359847
	.float -0.478145
	.float 0.447529
	.float -0.242081
	.float -0.101753
	.float 0.446728
	.float -0.596532
	.float 0.411710
	.float 0.079733
	.float -0.670766
	.float 1.089263
	.float -1.164341
	.float 0.925483
	.float -0.562715
	.float 0.282511
	.float -0.169734
	.float 0.153994
	.float -0.092595
	.float -0.104489
	.float 0.402953
	.float -0.669908
	.float 0.765665
	.float -0.631201
	.float 0.317882
	.float 0.044607
	.float -0.310499
	.float 0.376111
	.float -0.217806
	.float -0.093857
	.float 0.410920
	.float -0.564051
	.float 0.447815
	.float -0.094366
	.float -0.319605
	.float 0.558132
	.float -0.466598
	.float 0.080196
	.float 0.381026
	.float -0.642673
	.float 0.555211
	.float -0.199799
	.float -0.160714
	.float 0.261284
	.float -0.023855
	.float -0.380046
	.float 0.641716
	.float -0.525260
	.float 0.027681
	.float 0.618945
	.float -1.095567
	.float 1.186283
	.float -0.887369
	.float 0.381276
	.float 0.086807
	.float -0.342724
	.float 0.354616
	.float -0.220595
	.float 0.099144
	.float -0.127320
	.float 0.361596
	.float -0.756008
	.float 1.178477
	.float -1.461449
	.float 1.475040
	.float -1.195523
	.float 0.729708
	.float -0.269038
	.float -0.010043
	.float 0.039020
	.float 0.119804
	.float -0.335169
	.float 0.502710
	.float -0.598839
	.float 0.655125
	.float -0.686661
	.float 0.649554
	.float -0.476526
	.float 0.165587
	.float 0.162431
	.float -0.310309
	.float 0.145572
	.float 0.265166
	.float -0.651161
	.float 0.699337
	.float -0.286023
	.float -0.397344
	.float 0.942460
	.float -0.999017
	.float 0.531602
	.float 0.139447
	.float -0.555547
	.float 0.440543
	.float 0.111846
	.float -0.716591
	.float 0.972771
	.float -0.725163
	.float 0.130397
	.float 0.491274
	.float -0.880645
	.float 0.971382
	.float -0.860783
	.float 0.684599
	.float -0.516694
	.float 0.362148
	.float -0.217683
	.float 0.121160
	.float -0.139053
	.float 0.307242
	.float -0.583054
	.float 0.851910
	.float -0.983185
	.float 0.893512
	.float -0.578837
	.float 0.107415
	.float 0.408095
	.float -0.840886
	.float 1.079797
	.float -1.062799
	.float 0.807159
	.float -0.411943
	.float 0.014671
	.float 0.283169
	.float -0.472348
	.float 0.625049
	.float -0.816186
	.float 1.034902
	.float -1.162630
	.float 1.048165
	.float -0.632742
	.float 0.031262
	.float 0.499762
	.float -0.698854
	.float 0.456819
	.float 0.105725
	.float -0.692831
	.float 0.990147
	.float -0.834704
	.float 0.301245
	.float 0.343761
	.float -0.793833
	.float 0.873233
	.float -0.627743
	.float 0.282198
	.float -0.091924
	.float 0.182437
	.float -0.479948
	.float 0.774531
	.float -0.866986
	.float 0.695400
	.float -0.358062
	.float 0.030579
	.float 0.150259
	.float -0.149972
	.float 0.017439
	.float 0.178269
	.float -0.391210
	.float 0.591978
	.float -0.735377
	.float 0.750834
	.float -0.579391
	.float 0.234157
	.float 0.168117
	.float -0.443276
	.float 0.436832
	.float -0.127577
	.float -0.332465
	.float 0.681517
	.float -0.692452
	.float 0.315813
	.float 0.272249
	.float -0.758678
	.float 0.872201
	.float -0.540457
	.float -0.074193
	.float 0.678736
	.float -1.018885
	.float 1.003729
	.float -0.719870
	.float 0.349883
	.float -0.063179
	.float -0.058426
	.float 0.038815
	.float 0.018557
	.float 0.017526
	.float -0.241961
	.float 0.655059
	.float -1.140163
	.float 1.503059
	.float -1.566612
	.float 1.272532
	.float -0.725553
	.float 0.145716
	.float 0.247177
	.float -0.345702
	.float 0.194289
	.float 0.063912
	.float -0.288176
	.float 0.414175
	.float -0.452748
	.float 0.430633
	.float -0.338176
	.float 0.138440
	.float 0.170510
	.float -0.505046
	.float 0.718478
	.float -0.693060
	.float 0.430061
	.float -0.060280
	.float -0.238142
	.float 0.351081
	.float -0.283159
	.float 0.123165
	.float 0.037310
	.float -0.158505
	.float 0.244293
	.float -0.298390
	.float 0.301382
	.float -0.233352
	.float 0.112670
	.float -0.001598
	.float -0.036531
	.float -0.008537
	.float 0.082090
	.float -0.110879
	.float 0.069287
	.float -0.007658
	.float 0.018603
	.float -0.169240
	.float 0.451517
	.float -0.782597
	.float 1.048183
	.float -1.157230
	.float 1.080000
	.float -0.857675
	.float 0.584774
	.float -0.371608
	.float 0.298258
	.float -0.377321
	.float 0.543441
	.float -0.677908
	.float 0.660889
	.float -0.429655
	.float 0.016831
	.float 0.451309
	.float -0.801406
	.float 0.887557
	.float -0.659396
	.float 0.187406
	.float 0.369805
	.float -0.837205
	.float 1.092261
	.float -1.095856
	.float 0.879822
	.float -0.514491
	.float 0.082388
	.float 0.333854
	.float -0.660841
	.float 0.852325
	.float -0.909475
	.float 0.883927
	.float -0.849878
	.float 0.854688
	.float -0.879504
	.float 0.841854
	.float -0.649206
	.float 0.276491
	.float 0.183394
	.float -0.539653
	.float 0.598684
	.float -0.285943
	.float -0.281790
	.float 0.830624
	.float -1.064358
	.float 0.828225
	.float -0.204292
	.float -0.522887
	.float 1.015258
	.float -1.059977
	.float 0.674885
	.float -0.081924
	.float -0.429104
	.float 0.659622
	.float -0.589364
	.float 0.349430
	.float -0.115163
	.float -0.001923
	.float -0.003441
	.float 0.064685
	.float -0.111407
	.float 0.115064
	.float -0.086369
	.float 0.042389
	.float 0.017488
	.float -0.104573
	.float 0.214895
	.float -0.316418
	.float 0.367268
	.float -0.349916
	.float 0.286524
	.float -0.217825
	.float 0.164145
	.float -0.108633
	.float 0.021864
	.float 0.095259
	.float -0.195521
	.float 0.218375
	.float -0.146507
	.float 0.034215
	.float 0.023326
	.float 0.038913
	.float -0.198256
	.float 0.346822
	.float -0.358485
	.float 0.178968
	.float 0.120913
	.float -0.370442
	.float 0.395881
	.float -0.132084
	.float -0.325738
	.float 0.770854
	.float -1.006886
	.float 0.960426
	.float -0.708416
	.float 0.407859
	.float -0.187966
	.float 0.085187
	.float -0.057506
	.float 0.046944
	.float -0.027978
	.float 0.006559
	.float 0.011669
	.float -0.038032
	.float 0.079790
	.float -0.106931
	.float 0.054098
	.float 0.125101
	.float -0.391040
	.float 0.605709
	.float -0.607542
	.float 0.331252
	.float 0.118297
	.float -0.506087
	.float 0.605992
	.float -0.347195
	.float -0.133078
	.float 0.567326
	.float -0.714728
	.float 0.497914
	.float -0.039230
	.float -0.417686
	.float 0.648759
	.float -0.569469
	.float 0.269923
	.float 0.048099
	.float -0.190651
	.float 0.077223
	.float 0.224333
	.float -0.547190
	.float 0.724212
	.float -0.677708
	.float 0.452817
	.float -0.182743
	.float 0.011106
	.float -0.016720
	.float 0.180985
	.float -0.411075
	.float 0.600108
	.float -0.685263
	.float 0.668987
	.float -0.596216
	.float 0.510665
	.float -0.426061
	.float 0.333315
	.float -0.232101
	.float 0.153910
	.float -0.150493
	.float 0.253909
	.float -0.443434
	.float 0.652749
	.float -0.815310
	.float 0.907192
	.float -0.944984
	.float 0.938728
	.float -0.848608
	.float 0.600466
	.float -0.162648
	.float -0.379864
	.float 0.833238
	.float -1.003026
	.float 0.830689
	.float -0.447717
	.float 0.091798
	.float 0.060292
	.float -0.015902
	.float -0.051865
	.float -0.047983
	.float 0.361331
	.float -0.738304
	.float 0.935533
	.float -0.795588
	.float 0.370836
	.float 0.100633
	.float -0.351940
	.float 0.268136
	.float 0.035277
	.float -0.292189
	.float 0.271672
	.float 0.056810
	.float -0.492886
	.float 0.734313
	.float -0.580831
	.float 0.074897
	.float 0.516688
	.float -0.868750
	.float 0.798661
	.float -0.368171
	.float -0.176204
	.float 0.574050
	.float -0.710633
	.float 0.660931
	.float -0.603301
	.float 0.677651
	.float -0.890174
	.float 1.118394
	.float -1.197123
	.float 1.020092
	.float -0.598827
	.float 0.057581
	.float 0.423086
	.float -0.684965
	.float 0.660692
	.float -0.403427
	.float 0.061149
	.float 0.195345
	.float -0.254371
	.float 0.110926
	.float 0.144310
	.float -0.382943
	.float 0.505905
	.float -0.483265
	.float 0.352148
	.float -0.184913
	.float 0.051785
	.float 0.002190
	.float 0.039007
	.float -0.168306
	.float 0.359912
	.float -0.570331
	.float 0.745520
	.float -0.841592
	.float 0.849216
	.float -0.798408
	.float 0.730301
	.float -0.653787
	.float 0.528544
	.float -0.300193
	.float -0.034287
	.float 0.388808
	.float -0.620543
	.float 0.616671
	.float -0.370037
	.float -0.014150
	.float 0.381631
	.float -0.609869
	.float 0.650759
	.float -0.522601
	.float 0.280827
	.float 0.000535
	.float -0.235763
	.float 0.343609
	.float -0.282357
	.float 0.081166
	.float 0.165905
	.float -0.349970
	.float 0.406455
	.float -0.337771
	.float 0.187497
	.float 0.000176
	.float -0.192779
	.float 0.349627
	.float -0.408807
	.float 0.318076
	.float -0.093382
	.float -0.157106
	.float 0.289866
	.float -0.234942
	.float 0.066313
	.float 0.038948
	.float 0.067230
	.float -0.384036
	.float 0.754482
	.float -0.978822
	.float 0.956221
	.float -0.743386
	.float 0.492737
	.float -0.332591
	.float 0.289721
	.float -0.304738
	.float 0.307280
	.float -0.276107
	.float 0.238252
	.float -0.224740
	.float 0.234492
	.float -0.239050
	.float 0.216561
	.float -0.178451
	.float 0.165665
	.float -0.220812
	.float 0.358351
	.float -0.550665
	.float 0.734024
	.float -0.832740
	.float 0.795988
	.float -0.634014
	.float 0.430597
	.float -0.312624
	.float 0.381399
	.float -0.642845
	.float 0.984911
	.float -1.226427
	.float 1.214317
	.float -0.910167
	.float 0.411150
	.float 0.105155
	.float -0.472738
	.float 0.607485
	.float -0.522679
	.float 0.299460
	.float -0.046280
	.float -0.132968
	.float 0.167459
	.float -0.054293
	.float -0.116602
	.float 0.185813
	.float -0.012925
	.float -0.411510
	.float 0.916584
	.float -1.225542
	.float 1.126522
	.float -0.626948
	.float -0.025903
	.float 0.486377
	.float -0.523564
	.float 0.159191
	.float 0.364261
	.float -0.756819
	.float 0.868309
	.float -0.758321
	.float 0.611097
	.float -0.573263
	.float 0.642956
	.float -0.687892
	.float 0.565171
	.float -0.240091
	.float -0.185717
	.float 0.545882
	.float -0.713086
	.float 0.657018
	.float -0.432153
	.float 0.130626
	.float 0.151798
	.float -0.326132
	.float 0.323271
	.float -0.130832
	.float -0.168090
	.float 0.404193
	.float -0.402959
	.float 0.096547
	.float 0.416792
	.float -0.920861
	.float 1.210538
	.float -1.208345
	.float 0.984973
	.float -0.678015
	.float 0.383747
	.float -0.109863
	.float -0.183559
	.float 0.504733
	.float -0.789967
	.float 0.937337
	.float -0.882252
	.float 0.649793
	.float -0.343422
	.float 0.083487
	.float 0.057344
	.float -0.081548
	.float 0.049367
	.float -0.034381
	.float 0.076718
	.float -0.153933
	.float 0.184770
	.float -0.072778
	.float -0.225083
	.float 0.645087
	.float -1.024095
	.float 1.177646
	.float -1.006132
	.float 0.557389
	.float -0.001924
	.float -0.459082
	.float 0.687892
	.float -0.650851
	.float 0.400217
	.float -0.032081
	.float -0.345788
	.float 0.633809
	.float -0.763653
	.float 0.727664
	.float -0.590958
	.float 0.461478
	.float -0.424058
	.float 0.483024
	.float -0.560051
	.float 0.554260
	.float -0.420148
	.float 0.202995
	.float -0.005605
	.float -0.084486
	.float 0.050303
	.float 0.053355
	.float -0.142341
	.float 0.150636
	.float -0.054043
	.float -0.127704
	.float 0.334462
	.float -0.471984
	.float 0.438039
	.float -0.176878
	.float -0.264260
	.float 0.727762
	.float -1.017016
	.float 1.013425
	.float -0.755227
	.float 0.409168
	.float -0.146008
	.float 0.013300
	.float 0.089317
	.float -0.304732
	.float 0.664314
	.float -1.016438
	.float 1.111226
	.float -0.790665
	.float 0.140022
	.float 0.526655
	.float -0.854196
	.float 0.680969
	.float -0.152338
	.float -0.371492
	.float 0.550457
	.float -0.279314
	.float -0.260502
	.float 0.734447
	.float -0.870029
	.float 0.607735
	.float -0.103650
	.float -0.392349
	.float 0.686375
	.float -0.727532
	.float 0.600114
	.float -0.449660
	.float 0.394537
	.float -0.464223
	.float 0.586351
	.float -0.627869
	.float 0.477003
	.float -0.126606
	.float -0.296581
	.float 0.590744
	.float -0.600296
	.float 0.319399
	.float 0.099825
	.float -0.444352
	.float 0.571427
	.float -0.479700
	.float 0.279090
	.float -0.099319
	.float 0.013986
	.float -0.026295
	.float 0.101655
	.float -0.201163
	.float 0.289075
	.float -0.325679
	.float 0.272663
	.float -0.117706
	.float -0.103261
	.float 0.312276
	.float -0.427429
	.float 0.408035
	.float -0.275937
	.float 0.100132
	.float 0.041870
	.float -0.100682
	.float 0.070187
	.float 0.022028
	.float -0.138750
	.float 0.255144
	.float -0.364431
	.float 0.463990
	.float -0.534580
	.float 0.534964
	.float -0.426469
	.float 0.214516
	.float 0.030631
	.float -0.206408
	.float 0.253593
	.float -0.217485
	.float 0.231484
	.float -0.415495
	.float 0.759659
	.float -1.093510
	.float 1.185389
	.float -0.910658
	.float 0.361093
	.float 0.197357
	.float -0.495530
	.float 0.435551
	.float -0.141038
	.float -0.146771
	.float 0.239793
	.float -0.113636
	.float -0.109057
	.float 0.266945
	.float -0.267170
	.float 0.121526
	.float 0.089664
	.float -0.276710
	.float 0.376633
	.float -0.357588
	.float 0.212692
	.float 0.038701
	.float -0.345636
	.float 0.633040
	.float -0.827798
	.float 0.889613
	.float -0.824624
	.float 0.672346
	.float -0.477110
	.float 0.266979
	.float -0.054614
	.float -0.142693
	.float 0.283173
	.float -0.301272
	.float 0.136690
	.float 0.220944
	.float -0.700073
	.float 1.155385
	.float -1.422563
	.float 1.395771
	.float -1.084980
	.float 0.617061
	.float -0.176615
	.float -0.082470
	.float 0.106198
	.float 0.045890
	.float -0.246312
	.float 0.376010
	.float -0.387816
	.float 0.323661
	.float -0.279302
	.float 0.339076
	.float -0.519347
	.float 0.753305
	.float -0.925918
	.float 0.937918
	.float -0.760094
	.float 0.445699
	.float -0.096350
	.float -0.192562
	.float 0.370794
	.float -0.437539
	.float 0.420952
	.float -0.357463
	.float 0.284473
	.float -0.238370
	.float 0.244053
	.float -0.297874
	.float 0.364809
	.float -0.405576
	.float 0.419137
	.float -0.460590
	.float 0.605086
	.float -0.874049
	.float 1.182310
	.float -1.361860
	.float 1.263141
	.float -0.868875
	.float 0.334280
	.float 0.088333
	.float -0.199826
	.float -0.019569
	.float 0.395711
	.float -0.670367
	.float 0.662400
	.float -0.373050
	.float -0.030880
	.float 0.337103
	.float -0.423718
	.float 0.321441
	.float -0.170266
	.float 0.114329
	.float -0.213027
	.float 0.422300
	.float -0.642205
	.float 0.783288
	.float -0.805519
	.float 0.717211
	.float -0.553506
	.float 0.358619
	.float -0.177563
	.float 0.048001
	.float 0.013675
	.float -0.023264
	.float 0.023007
	.float -0.056793
	.float 0.141286
	.float -0.253535
	.float 0.344304
	.float -0.369280
	.float 0.318049
	.float -0.221232
	.float 0.128704
	.float -0.071931
	.float 0.039286
	.float 0.011166
	.float -0.105918
	.float 0.215930
	.float -0.265640
	.float 0.194933
	.float -0.023853
	.float -0.144690
	.float 0.200741
	.float -0.123062
	.float 0.007734
	.float 0.005116
	.float 0.149462
	.float -0.398402
	.float 0.581692
	.float -0.576399
	.float 0.389136
	.float -0.141674
	.float -0.032944
	.float 0.091512
	.float -0.096073
	.float 0.139384
	.float -0.252842
	.float 0.377545
	.float -0.418649
	.float 0.330734
	.float -0.160550
	.float 0.015163
	.float 0.014512
	.float 0.085796
	.float -0.248396
	.float 0.366776
	.float -0.351654
	.float 0.168548
	.float 0.151233
	.float -0.519594
	.float 0.814985
	.float -0.920732
	.float 0.773873
	.float -0.405153
	.float -0.057554
	.float 0.436153
	.float -0.582998
	.float 0.452912
	.float -0.124912
	.float -0.239113
	.float 0.474598
	.float -0.488624
	.float 0.291181
	.float 0.027588
	.float -0.355591
	.float 0.618271
	.float -0.805731
	.float 0.952868
	.float -1.086130
	.float 1.176194
	.float -1.136810
	.float 0.880240
	.float -0.394784
	.float -0.213897
	.float 0.755993
	.float -1.050243
	.float 1.016620
	.float -0.709381
	.float 0.273725
	.float 0.138847
	.float -0.438952
	.float 0.614281
	.float -0.695922
	.float 0.713718
	.float -0.677720
	.float 0.594508
	.float -0.494114
	.float 0.433280
	.float -0.463046
	.float 0.583731
	.float -0.727088
	.float 0.787452
	.float -0.685105
	.float 0.418246
	.float -0.068698
	.float -0.239663
	.float 0.400107
	.float -0.366923
	.float 0.168891
	.float 0.103039
	.float -0.325378
	.float 0.385735
	.float -0.234398
	.float -0.077643
	.float 0.404387
	.float -0.568724
	.float 0.459618
	.float -0.105197
	.float -0.328880
	.float 0.622098
	.float -0.615923
	.float 0.297271
	.float 0.197267
	.float -0.653828
	.float 0.887414
	.float -0.824502
	.float 0.523251
	.float -0.127866
	.float -0.210491
	.float 0.399878
	.float -0.428907
	.float 0.343833
	.float -0.207710
	.float 0.068823
	.float 0.052327
	.float -0.163250
	.float 0.290683
	.float -0.459892
	.float 0.664031
	.float -0.843732
	.float 0.904474
	.float -0.776809
	.float 0.481986
	.float -0.145824
	.float -0.066849
	.float 0.060878
	.float 0.116778
	.float -0.302419
	.float 0.327941
	.float -0.141199
	.float -0.154044
	.float 0.368684
	.float -0.358515
	.float 0.121332
	.float 0.204946
	.float -0.437324
	.float 0.466944
	.float -0.321321
	.float 0.132910
	.float -0.040895
	.float 0.096067
	.float -0.231992
	.float 0.319667
	.float -0.264441
	.float 0.074384
	.float 0.151849
	.float -0.309376
	.float 0.376040
	.float -0.428705
	.float 0.566021
	.float -0.798530
	.float 1.004713
	.float -1.004993
	.float 0.706872
	.float -0.206200
	.float -0.245580
	.float 0.396691
	.float -0.164786
	.float -0.301078
	.float 0.711059
	.float -0.815447
	.float 0.554573
	.float -0.084205
	.float -0.330108
	.float 0.471874
	.float -0.283522
	.float -0.129485
	.float 0.580485
	.float -0.900102
	.float 0.993515
	.float -0.847630
	.float 0.517803
	.float -0.115482
	.float -0.215424
	.float 0.355618
	.float -0.287628
	.float 0.133185
	.float -0.093270
	.float 0.303385
	.float -0.703087
	.float 1.035945
	.float -1.011693
	.float 0.530324
	.float 0.201162
	.float -0.767489
	.float 0.810980
	.float -0.282288
	.float -0.509389
	.float 1.093743
	.float -1.152961
	.float 0.732537
	.float -0.200708
	.float -0.015111
	.float -0.269929
	.float 0.868318
	.float -1.350316
	.float 1.339908
	.float -0.769247
	.float -0.082059
	.float 0.781702
	.float -1.029204
	.float 0.831557
	.float -0.459478
	.float 0.234905
	.float -0.310863
	.float 0.593200
	.float -0.836782
	.float 0.826457
	.float -0.509350
	.float 0.002651
	.float 0.500129
	.float -0.839127
	.float 0.942084
	.float -0.814580
	.float 0.509627
	.float -0.115856
	.float -0.241669
	.float 0.425906
	.float -0.354136
	.float 0.066849
	.float 0.269459
	.float -0.452429
	.float 0.372547
	.float -0.079344
	.float -0.272515
	.float 0.553557
	.float -0.753695
	.float 0.958492
	.float -1.231682
	.float 1.513875
	.float -1.634650
	.float 1.436368
	.float -0.909797
	.float 0.230889
	.float 0.332760
	.float -0.576703
	.float 0.467841
	.float -0.141349
	.float -0.195844
	.float 0.383059
	.float -0.375548
	.float 0.239347
	.float -0.090647
	.float 0.021711
	.float -0.052960
	.float 0.131777
	.float -0.173743
	.float 0.119923
	.float 0.024648
	.float -0.193570
	.float 0.299087
	.float -0.283251
	.float 0.151225
	.float 0.028753
	.float -0.156106
	.float 0.147144
	.float 0.014618
	.float -0.251380
	.float 0.412646
	.float -0.354139
	.float 0.041640
	.float 0.388489
	.float -0.674280
	.float 0.576947
	.float -0.049645
	.float -0.693400
	.float 1.274219
	.float -1.369043
	.float 0.908623
	.float -0.124806
	.float -0.591954
	.float 0.930177
	.float -0.833834
	.float 0.507598
	.float -0.260109
	.float 0.297319
	.float -0.597295
	.float 0.933858
	.float -1.021219
	.float 0.689198
	.float 0.007023
	.float -0.799210
	.float 1.335661
	.float -1.364622
	.float 0.873957
	.float -0.102094
	.float -0.595727
	.float 0.950525
	.float -0.922947
	.float 0.692563
	.float -0.505389
	.float 0.495145
	.float -0.608376
	.float 0.678256
	.float -0.573117
	.float 0.293866
	.float 0.050683
	.float -0.350342
	.float 0.575150
	.float -0.759954
	.float 0.920318
	.float -0.995918
	.float 0.889193
	.float -0.568775
	.float 0.135925
	.float 0.220353
	.float -0.351710
	.float 0.254654
	.float -0.062365
	.float -0.064491
	.float 0.050754
	.float 0.065213
	.float -0.191782
	.float 0.259281
	.float -0.241124
	.float 0.123688
	.float 0.114312
	.float -0.468640
	.float 0.849821
	.float -1.072763
	.float 0.942698
	.float -0.397338
	.float -0.401103
	.float 1.111569
	.float -1.391104
	.float 1.097662
	.float -0.385726
	.float -0.373214
	.float 0.800166
	.float -0.719956
	.float 0.245240
	.float 0.313945
	.float -0.651438
	.float 0.645429
	.float -0.403392
	.float 0.151806
	.float -0.057240
	.float 0.111121
	.float -0.159756
	.float 0.049570
	.float 0.230298
	.float -0.521370
	.float 0.607092
	.float -0.375569
	.float -0.089511
	.float 0.555694
	.float -0.788107
	.float 0.689391
	.float -0.341940
	.float -0.061443
	.float 0.337124
	.float -0.398265
	.float 0.268612
	.float -0.039965
	.float -0.178862
	.float 0.290472
	.float -0.222560
	.float -0.048939
	.float 0.465829
	.float -0.877718
	.float 1.093778
	.float -0.986833
	.float 0.581940
	.float -0.054257
	.float -0.376287
	.float 0.580089
	.float -0.579838
	.float 0.495458
	.float -0.426091
	.float 0.373924
	.float -0.272347
	.float 0.085811
	.float 0.115257
	.float -0.178499
	.float -0.018502
	.float 0.456459
	.float -0.954328
	.float 1.265146
	.float -1.225336
	.float 0.855058
	.float -0.341863
	.float -0.078409
	.float 0.258836
	.float -0.204418
	.float 0.026989
	.float 0.160129
	.float -0.320770
	.float 0.489596
	.float -0.698228
	.float 0.907130
	.float -1.008597
	.float 0.902492
	.float -0.583257
	.float 0.166666
	.float 0.166628
	.float -0.271449
	.float 0.115611
	.float 0.208417
	.float -0.534726
	.float 0.702434
	.float -0.622459
	.float 0.308422
	.float 0.135226
	.float -0.561786
	.float 0.846566
	.float -0.935873
	.float 0.852948
	.float -0.660028
	.float 0.407788
	.float -0.114882
	.float -0.206975
	.float 0.511434
	.float -0.710350
	.float 0.722689
	.float -0.545012
	.float 0.278018
	.float -0.073828
	.float 0.037008
	.float -0.157074
	.float 0.326749
	.float -0.428690
	.float 0.417754
	.float -0.335833
	.float 0.258070
	.float -0.225712
	.float 0.223108
	.float -0.211045
	.float 0.178415
	.float -0.163012
	.float 0.221942
	.float -0.375214
	.float 0.569422
	.float -0.695677
	.float 0.657208
	.float -0.442391
	.float 0.148351
	.float 0.069391
	.float -0.092579
	.float -0.084923
	.float 0.356255
	.float -0.574804
	.float 0.647453
	.float -0.584050
	.float 0.476166
	.float -0.428648
	.float 0.492812
	.float -0.639001
	.float 0.777893
	.float -0.813719
	.float 0.700428
	.float -0.471227
	.float 0.223780
	.float -0.067053
	.float 0.059152
	.float -0.172283
	.float 0.304133
	.float -0.325709
	.float 0.137614
	.float 0.288833
	.float -0.894710
	.float 1.540363
	.float -2.037436
	.float 2.206173
	.float -1.946151
	.float 1.290677
	.float -0.410917
	.float -0.441464
	.float 1.030372
	.float -1.222955
	.float 1.028196
	.float -0.575013
	.float 0.048318
	.float 0.383866
	.float -0.623112
	.float 0.657241
	.float -0.540624
	.float 0.351448
	.float -0.149825
	.float -0.041575
	.float 0.227246
	.float -0.412336
	.float 0.583015
	.float -0.707903
	.float 0.755176
	.float -0.709286
	.float 0.576727
	.float -0.382674
	.float 0.165569
	.float 0.030403
	.float -0.169482
	.float 0.242950
	.float -0.275285
	.float 0.301838
	.float -0.325917
	.float 0.292791
	.float -0.119603
	.float -0.222220
	.float 0.632184
	.float -0.890588
	.float 0.779166
	.float -0.247256
	.float -0.498919
	.float 1.073446
	.float -1.131714
	.float 0.600237
	.float 0.245226
	.float -0.924130
	.float 1.040917
	.float -0.537340
	.float -0.260365
	.float 0.838114
	.float -0.813412
	.float 0.173379
	.float 0.719882
	.float -1.355562
	.float 1.380896
	.float -0.791854
	.float -0.102561
	.float 0.898120
	.float -1.336681
	.float 1.414876
	.float -1.309844
	.float 1.202306
	.float -1.137681
	.float 1.021720
	.float -0.738304
	.float 0.285137
	.float 0.184942
	.float -0.451917
	.float 0.379339
	.float -0.012878
	.float -0.445550
	.float 0.764189
	.float -0.811957
	.float 0.604275
	.float -0.250672
	.float -0.134927
	.float 0.488502
	.float -0.789705
	.float 1.026447
	.float -1.174665
	.float 1.208345
	.float -1.120057
	.float 0.928008
	.float -0.666579
	.float 0.373602
	.float -0.084691
	.float -0.168522
	.float 0.363650
	.float -0.493551
	.float 0.563827
	.float -0.579940
	.float 0.535611
	.float -0.416184
	.float 0.215817
	.float 0.047140
	.float -0.331011
	.float 0.584214
	.float -0.757942
	.float 0.812455
	.float -0.726495
	.float 0.516935
	.float -0.254530
	.float 0.048022
	.float 0.011327
	.float 0.089430
	.float -0.272840
	.float 0.428401
	.float -0.497086
	.float 0.509854
	.float -0.544305
	.float 0.639632
	.float -0.750631
	.float 0.785616
	.float -0.691665
	.float 0.505327
	.float -0.320114
	.float 0.203834
	.float -0.147050
	.float 0.091967
	.float -0.010923
	.float -0.047021
	.float -0.006258
	.float 0.205018
	.float -0.467749
	.float 0.631937
	.float -0.568971
	.float 0.290136
	.float 0.046210
	.float -0.243130
	.float 0.214062
	.float -0.059790
	.float 0.006305
	.float -0.236870
	.float 0.734370
	.float -1.252852
	.float 1.454284
	.float -1.129863
	.float 0.358130
	.float 0.514781
	.float -1.072218
	.float 1.078667
	.float -0.621687
	.float 0.048277
	.float 0.263282
	.float -0.143398
	.float -0.277641
	.float 0.683520
	.float -0.804214
	.float 0.599027
	.float -0.263599
	.float 0.067070
	.float -0.149060
	.float 0.429000
	.float -0.686596
	.float 0.738909
	.float -0.571550
	.float 0.329315
	.float -0.189132
	.float 0.226370
	.float -0.376764
	.float 0.507246
	.float -0.522622
	.float 0.420935
	.float -0.268929
	.float 0.137461
	.float -0.057434
	.float 0.022475
	.float -0.018174
	.float 0.042018
	.float -0.098092
	.float 0.178851
	.float -0.254845
	.float 0.281744
	.float -0.219111
	.float 0.049898
	.float 0.207163
	.float -0.496314
	.float 0.736983
	.float -0.848441
	.float 0.780060
	.float -0.535176
	.float 0.176909
	.float 0.189072
	.float -0.450829
	.float 0.533277
	.float -0.430362
	.float 0.209915
	.float 0.015751
	.float -0.142446
	.float 0.123178
	.float 0.013828
	.float -0.189256
	.float 0.323500
	.float -0.381572
	.float 0.382889
	.float -0.370815
	.float 0.365486
	.float -0.337341
	.float 0.224557
	.float 0.014777
	.float -0.354366
	.float 0.693886
	.float -0.905210
	.float 0.903261
	.float -0.696932
	.float 0.388278
	.float -0.119006
	.float -0.007857
	.float -0.011189
	.float 0.074024
	.float -0.034215
	.float -0.199115
	.float 0.586234
	.float -0.967070
	.float 1.163718
	.float -1.107483
	.float 0.891521
	.float -0.697570
	.float 0.646401
	.float -0.691496
	.float 0.651533
	.float -0.366958
	.float -0.140523
	.float 0.639144
	.float -0.825962
	.float 0.538317
	.float 0.117393
	.float -0.814726
	.float 1.197990
	.float -1.080456
	.float 0.523585
	.float 0.232611
	.float -0.915955
	.float 1.342493
	.float -1.456609
	.float 1.306620
	.float -1.002069
	.float 0.678307
	.float -0.459326
	.float 0.407040
	.float -0.475811
	.float 0.516959
	.float -0.360374
	.float -0.059195
	.float 0.617804
	.float -1.038705
	.float 1.050269
	.float -0.569872
	.float -0.217863
	.float 0.956018
	.float -1.328523
	.float 1.247004
	.float -0.883936
	.float 0.536541
	.float -0.425104
	.float 0.566042
	.float -0.794408
	.float 0.900572
	.float -0.776448
	.float 0.477188
	.float -0.171100
	.float 0.020678
	.float -0.070968
	.float 0.212411
	.float -0.243992
	.float 0.007354
	.float 0.485763
	.float -1.020718
	.float 1.283581
	.float -1.055029
	.float 0.374928
	.float 0.440570
	.float -0.960322
	.float 0.888040
	.float -0.243804
	.float -0.641650
	.float 1.320360
	.float -1.487305
	.float 1.144455
	.float -0.569803
	.float 0.118810
	.float 0.005471
	.float 0.138634
	.float -0.308777
	.float 0.276233
	.float 0.005197
	.float -0.379533
	.float 0.621925
	.float -0.613577
	.float 0.423632
	.float -0.244357
	.float 0.241078
	.float -0.433700
	.float 0.686772
	.float -0.797174
	.float 0.608296
	.float -0.085285
	.float -0.668525
	.float 1.441963
	.float -1.980194
	.float 2.077449
	.float -1.675995
	.float 0.918634
	.float -0.100149
	.float -0.481045
	.float 0.688944
	.float -0.618131
	.float 0.506027
	.float -0.546418
	.float 0.742423
	.float -0.911681
	.float 0.840483
	.float -0.465892
	.float -0.058368
	.float 0.465847
	.float -0.569931
	.float 0.394501
	.float -0.142533
	.float 0.033141
	.float -0.141358
	.float 0.366097
	.float -0.541498
	.float 0.587564
	.float -0.569973
	.float 0.620808
	.float -0.790799
	.float 0.960540
	.float -0.892594
	.float 0.400074
	.float 0.481975
	.float -1.447009
	.float 2.043859
	.float -1.925600
	.float 1.077815
	.float 0.123871
	.float -1.089641
	.float 1.342045
	.float -0.798760
	.float -0.175041
	.float 0.990279
	.float -1.194313
	.float 0.732277
	.float 0.056316
	.float -0.685055
	.float 0.827354
	.float -0.477608
	.float -0.112739
	.float 0.639105
	.float -0.925540
	.float 0.975439
	.float -0.899580
	.float 0.811144
	.float -0.769792
	.float 0.788790
	.float -0.862491
	.float 0.971949
	.float -1.068829
	.float 1.075770
	.float -0.930911
	.float 0.655915
	.float -0.385610
	.float 0.309525
	.float -0.542326
	.float 1.011982
	.float -1.464292
	.float 1.607721
	.float -1.311460
	.float 0.712275
	.float -0.138392
	.float -0.107926
	.float -0.044270
	.float 0.393005
	.float -0.616170
	.float 0.502784
	.float -0.089435
	.float -0.392891
	.float 0.707229
	.float -0.778731
	.float 0.713921
	.float -0.670436
	.float 0.699895
	.float -0.703027
	.float 0.535635
	.float -0.171241
	.float -0.225901
	.float 0.392248
	.float -0.159032
	.float -0.401177
	.float 0.992919
	.float -1.273387
	.float 1.059634
	.float -0.424681
	.float -0.371304
	.float 1.048445
	.float -1.449423
	.float 1.571613
	.float -1.498145
	.float 1.305719
	.float -1.024018
	.float 0.661810
	.float -0.256217
	.float -0.109538
	.float 0.337976
	.float -0.371900
	.float 0.229053
	.float 0.005478
	.float -0.220163
	.float 0.324871
	.float -0.283150
	.float 0.120195
	.float 0.091823
	.float -0.263672
	.float 0.323157
	.float -0.240853
	.float 0.038059
	.float 0.223146
	.float -0.459544
	.float 0.587054
	.float -0.539244
	.float 0.286797
	.float 0.143045
	.float -0.658612
	.float 1.123023
	.float -1.403500
	.float 1.429725
	.float -1.226639
	.float 0.898313
	.float -0.572152
	.float 0.341061
	.float -0.238018
	.float 0.248775
	.float -0.338149
	.float 0.464014
	.float -0.576223
	.float 0.619484
	.float -0.554391
	.float 0.385542
	.float -0.169161
	.float -0.014588
	.float 0.106729
	.float -0.095973
	.float 0.005533
	.float 0.142597
	.float -0.345728
	.float 0.596350
	.float -0.835795
	.float 0.938317
	.float -0.763587
	.float 0.259242
	.float 0.458959
	.float -1.123869
	.float 1.443355
	.float -1.266398
	.float 0.680030
	.float 0.031614
	.float -0.542594
	.float 0.655435
	.float -0.383703
	.float -0.089337
	.float 0.529555
	.float -0.766451
	.float 0.745895
	.float -0.517752
	.float 0.189708
	.float 0.122087
	.float -0.331962
	.float 0.408870
	.float -0.377879
	.float 0.294204
	.float -0.201568
	.float 0.104482
	.float 0.021278
	.float -0.187288
	.float 0.358285
	.float -0.462134
	.float 0.444313
	.float -0.324150
	.float 0.201400
	.float -0.196387
	.float 0.361269
	.float -0.629359
	.float 0.847222
	.float -0.874020
	.float 0.678531
	.float -0.360288
	.float 0.076902
	.float 0.066781
	.float -0.080173
	.float 0.051725
	.float -0.053446
	.float 0.073768
	.float -0.040661
	.float -0.090090
	.float 0.272679
	.float -0.405749
	.float 0.439932
	.float -0.453472
	.float 0.605700
	.float -0.985403
	.float 1.480095
	.float -1.796206
	.float 1.644661
	.float -0.962387
	.float -0.006351
	.float 0.844331
	.float -1.218746
	.float 1.071526
	.float -0.608954
	.float 0.118644
	.float 0.227309
	.float -0.432344
	.float 0.578920
	.float -0.689251
	.float 0.681004
	.float -0.454870
	.float 0.024960
	.float 0.437285
	.float -0.697638
	.float 0.620605
	.float -0.266527
	.float -0.155424
	.float 0.441705
	.float -0.534997
	.float 0.545229
	.float -0.641865
	.float 0.907183
	.float -1.263528
	.float 1.525314
	.float -1.530417
	.float 1.251248
	.float -0.807531
	.float 0.378281
	.float -0.081414
	.float -0.093495
	.float 0.255620
	.float -0.513389
	.float 0.878106
	.float -1.239157
	.float 1.427567
	.float -1.324121
	.float 0.939345
	.float -0.413632
	.float -0.060622
	.float 0.342775
	.float -0.407871
	.float 0.334024
	.float -0.227992
	.float 0.144247
	.float -0.056455
	.float -0.096953
	.float 0.326892
	.float -0.537477
	.float 0.555875
	.float -0.244693
	.float -0.375000
	.float 1.085075
	.float -1.563789
	.float 1.567116
	.float -1.083788
	.float 0.356172
	.float 0.256463
	.float -0.489667
	.float 0.325056
	.float 0.016963
	.float -0.236717
	.float 0.160531
	.float 0.145374
	.float -0.428275
	.float 0.432150
	.float -0.083200
	.float -0.453469
	.float 0.887151
	.float -1.003613
	.float 0.808589
	.float -0.509165
	.float 0.351359
	.float -0.440305
	.float 0.678584
	.float -0.861680
	.float 0.846653
	.float -0.659664
	.float 0.465034
	.float -0.431637
	.float 0.606054
	.float -0.884377
	.float 1.089615
	.float -1.085195
	.float 0.844108
	.float -0.442182
	.float 0.003177
	.float 0.355558
	.float -0.550826
	.float 0.542383
	.float -0.341943
	.float 0.023342
	.float 0.287794
	.float -0.461821
	.float 0.435849
	.float -0.259187
	.float 0.069746
	.float -0.005458
	.float 0.110836
	.float -0.311274
	.float 0.476443
	.float -0.520998
	.float 0.459043
	.float -0.371629
	.float 0.323652
	.float -0.308073
	.float 0.264239
	.float -0.145268
	.float -0.032472
	.float 0.201904
	.float -0.304073
	.float 0.337422
	.float -0.354795
	.float 0.412977
	.float -0.518694
	.float 0.615482
	.float -0.623875
	.float 0.506975
	.float -0.313405
	.float 0.162512
	.float -0.175333
	.float 0.393359
	.float -0.738468
	.float 1.041772
	.float -1.125854
	.float 0.893443
	.float -0.376487
	.float -0.275917
	.float 0.860429
	.float -1.203027
	.float 1.225986
	.float -0.970035
	.float 0.564557
	.float -0.163939
	.float -0.116341
	.float 0.235019
	.float -0.222408
	.float 0.150254
	.float -0.092086
	.float 0.089742
	.float -0.137767
	.float 0.192576
	.float -0.204008
	.float 0.152373
	.float -0.065117
	.float -0.003068
	.float 0.015831
	.float 0.009042
	.float -0.006929
	.float -0.081789
	.float 0.254450
	.float -0.434526
	.float 0.524157
	.float -0.484362
	.float 0.375631
	.float -0.318386
	.float 0.399696
	.float -0.602722
	.float 0.819537
	.float -0.936404
	.float 0.916888
	.float -0.811379
	.float 0.690715
	.float -0.570697
	.float 0.399290
	.float -0.116875
	.float -0.268247
	.float 0.658132
	.float -0.915737
	.float 0.945533
	.float -0.744655
	.float 0.397988
	.float -0.032826
	.float -0.234901
	.float 0.342626
	.float -0.305081
	.float 0.213215
	.float -0.198702
	.float 0.366896
	.float -0.728155
	.float 1.172788
	.float -1.515673
	.float 1.592155
	.float -1.349309
	.float 0.876937
	.float -0.360890
	.float -0.011541
	.float 0.137718
	.float -0.031803
	.float -0.207285
	.float 0.463803
	.float -0.663861
	.float 0.792226
	.float -0.867296
	.float 0.903195
	.float -0.891855
	.float 0.816625
	.float -0.679502
	.float 0.514226
	.float -0.370758
	.float 0.283302
	.float -0.247254
	.float 0.222141
	.float -0.157528
	.float 0.023795
	.float 0.169657
	.float -0.376192
	.float 0.531450
	.float -0.583579
	.float 0.523153
	.float -0.396769
	.float 0.290564
	.float -0.284285
	.float 0.401135
	.float -0.588583
	.float 0.748837
	.float -0.800292
	.float 0.726617
	.float -0.581129
	.float 0.450492
	.float -0.409040
	.float 0.489870
	.float -0.674918
	.float 0.894787
	.float -1.040741
	.float 1.002582
	.float -0.730415
	.float 0.284289
	.float 0.177166
	.float -0.482013
	.float 0.555175
	.float -0.471951
	.float 0.406688
	.float -0.506656
	.float 0.782024
	.float -1.094619
	.float 1.256417
	.float -1.167172
	.float 0.891127
	.float -0.616644
	.float 0.527597
	.float -0.677228
	.float 0.951804
	.float -1.147567
	.float 1.107864
	.float -0.829935
	.float 0.471060
	.float -0.248529
	.float 0.294127
	.float -0.556489
	.float 0.820374
	.float -0.839160
	.float 0.498233
	.float 0.101601
	.float -0.701415
	.float 1.043802
	.float -1.024268
	.float 0.735159
	.float -0.386480
	.float 0.172279
	.float -0.173020
	.float 0.339547
	.float -0.543906
	.float 0.653539
	.float -0.592157
	.float 0.368621
	.float -0.064799
	.float -0.214916
	.float 0.407445
	.float -0.524327
	.float 0.623454
	.float -0.736784
	.float 0.817587
	.float -0.764156
	.float 0.513138
	.float -0.125361
	.float -0.219386
	.float 0.332474
	.float -0.153933
	.float -0.191925
	.float 0.472652
	.float -0.503070
	.float 0.265256
	.float 0.093773
	.float -0.379718
	.float 0.492129
	.float -0.483280
	.float 0.495661
	.float -0.631788
	.float 0.860297
	.float -1.032989
	.float 0.999932
	.float -0.731294
	.float 0.346745
	.float -0.025653
	.float -0.131333
	.float 0.175400
	.float -0.252274
	.float 0.457395
	.float -0.725115
	.float 0.853824
	.float -0.660302
	.float 0.144607
	.float 0.472363
	.float -0.880946
	.float 0.891172
	.float -0.559854
	.float 0.140998
	.float 0.098077
	.float -0.053433
	.float -0.171875
	.float 0.371906
	.float -0.395398
	.float 0.237705
	.float -0.015323
	.float -0.137046
	.float 0.160621
	.float -0.096508
	.float 0.038298
	.float -0.058368
	.float 0.158875
	.float -0.273137
	.float 0.309587
	.float -0.209903
	.float -0.011318
	.float 0.268275
	.float -0.448268
	.float 0.475421
	.float -0.354217
	.float 0.161198
	.float 0.013050
	.float -0.130806
	.float 0.229462
	.float -0.377411
	.float 0.596681
	.float -0.819745
	.float 0.925898
	.float -0.836311
	.float 0.590088
	.float -0.330382
	.float 0.201202
	.float -0.235584
	.float 0.330394
	.float -0.334540
	.float 0.177956
	.float 0.069662
	.float -0.261798
	.float 0.301734
	.float -0.217856
	.float 0.120919
	.float -0.089496
	.float 0.097482
	.float -0.055657
	.float -0.074422
	.float 0.211166
	.float -0.206208
	.float -0.019293
	.float 0.380570
	.float -0.672918
	.float 0.727851
	.float -0.554391
	.float 0.344873
	.float -0.334835
	.float 0.624533
	.float -1.098154
	.float 1.497948
	.float -1.594309
	.float 1.329474
	.float -0.842227
	.float 0.370061
	.float -0.102804
	.float 0.080943
	.float -0.192003
	.float 0.255574
	.float -0.140825
	.float -0.151264
	.float 0.486269
	.float -0.676110
	.float 0.595977
	.float -0.268484
	.float -0.141134
	.float 0.422589
	.float -0.452933
	.float 0.276326
	.float -0.073546
	.float 0.038050
	.float -0.242049
	.float 0.584178
	.float -0.852044
	.float 0.853991
	.float -0.531665
	.float -0.011887
	.float 0.572840
	.float -0.947846
	.float 1.018495
	.float -0.787231
	.float 0.363739
	.float 0.081372
	.float -0.376749
	.float 0.408789
	.float -0.162775
	.float -0.267257
	.float 0.707647
	.float -0.968998
	.float 0.925158
	.float -0.574527
	.float 0.049815
	.float 0.439318
	.float -0.709912
	.float 0.700863
	.float -0.499783
	.float 0.279580
	.float -0.182871
	.float 0.232370
	.float -0.330549
	.float 0.347371
	.float -0.228351
	.float 0.038492
	.float 0.092224
	.float -0.076873
	.float -0.056654
	.float 0.192153
	.float -0.230036
	.float 0.182009
	.float -0.169941
	.float 0.320994
	.float -0.641582
	.float 0.980163
	.float -1.122293
	.float 0.953380
	.float -0.561529
	.float 0.191914
	.float -0.078955
	.float 0.279224
	.float -0.629576
	.float 0.859737
	.float -0.774677
	.float 0.378025
	.float 0.140132
	.float -0.529087
	.float 0.626980
	.float -0.444844
	.float 0.148114
	.float 0.043011
	.float 0.021363
	.float -0.332319
	.float 0.716239
	.float -0.921758
	.float 0.761495
	.float -0.231352
	.float -0.467269
	.float 1.024509
	.float -1.187070
	.float 0.894483
	.float -0.308031
	.float -0.279843
	.float 0.597876
	.float -0.523385
	.float 0.123271
	.float 0.398256
	.float -0.803764
	.float 0.922550
	.float -0.707697
	.float 0.240886
	.float 0.305128
	.float -0.731517
	.float 0.889360
	.float -0.742587
	.float 0.386504
	.float -0.003291
	.float -0.229573
	.float 0.226150
	.float -0.019024
	.float -0.288544
	.float 0.604552
	.float -0.898126
	.float 1.178752
	.float -1.428506
	.float 1.556252
	.float -1.430074
	.float 0.979737
	.float -0.293578
	.float -0.376821
	.float 0.730301
	.float -0.584249
	.float -0.013703
	.float 0.805862
	.float -1.461506
	.float 1.740555
	.float -1.588062
	.float 1.121583
	.float -0.542442
	.float 0.035204
	.float 0.293761
	.float -0.423241
	.float 0.386379
	.float -0.232274
	.float 0.005390
	.float 0.250694
	.float -0.480675
	.float 0.620569
	.float -0.627663
	.float 0.519436
	.float -0.385846
	.float 0.349213
	.float -0.485080
	.float 0.753278
	.float -0.994678
	.float 1.013529
	.float -0.707128
	.float 0.160952
	.float 0.365540
	.float -0.574310
	.float 0.311238
	.float 0.324004
	.float -1.023401
	.float 1.449158
	.float -1.427412
	.float 1.029192
	.float -0.495339
	.float 0.074329
	.float 0.108222
	.float -0.073345
	.float -0.078878
	.float 0.253925
	.float -0.400742
	.float 0.495640
	.float -0.511484
	.float 0.413844
	.float -0.190715
	.float -0.115865
	.float 0.415662
	.float -0.622188
	.float 0.714940
	.float -0.755409
	.float 0.830740
	.float -0.962039
	.float 1.059011
	.float -0.978533
	.float 0.658213
	.float -0.217106
	.float -0.081512
	.float 0.008504
	.float 0.434052
	.float -0.961401
	.float 1.171679
	.float -0.832063
	.float 0.076287
	.float 0.650952
	.float -0.886508
	.float 0.476848
	.float 0.300875
	.float -0.922053
	.float 0.974577
	.float -0.434466
	.float -0.339720
	.float 0.879456
	.float -0.936267
	.float 0.628047
	.float -0.308797
	.float 0.277148
	.float -0.548493
	.float 0.854101
	.float -0.855311
	.float 0.407415
	.float 0.319041
	.float -0.942257
	.float 1.121282
	.float -0.780102
	.float 0.151178
	.float 0.386886
	.float -0.563732
	.float 0.388740
	.float -0.124607
	.float 0.085536
	.float -0.402280
	.float 0.918387
	.float -1.289387
	.float 1.217432
	.float -0.661071
	.float -0.122239
	.float 0.730993
	.float -0.869662
	.float 0.528825
	.float 0.020872
	.float -0.411960
	.float 0.413728
	.float -0.062079
	.float -0.390206
	.float 0.653125
	.float -0.578789
	.float 0.226348
	.float 0.209643
	.float -0.537072
	.float 0.670555
	.float -0.644348
	.float 0.547435
	.float -0.440993
	.float 0.317038
	.float -0.120451
	.float -0.186995
	.float 0.568727
	.float -0.906790
	.float 1.062141
	.float -0.970828
	.float 0.709960
	.float -0.473623
	.float 0.454441
	.float -0.702505
	.float 1.066760
	.float -1.277637
	.float 1.126471
	.float -0.615383
	.float -0.034064
	.float 0.521689
	.float -0.653706
	.float 0.439235
	.float -0.041555
	.float -0.357084
	.float 0.663116
	.float -0.878371
	.float 1.026813
	.float -1.084706
	.float 0.983760
	.float -0.683237
	.float 0.244712
	.float 0.161989
	.float -0.338340
	.float 0.172503
	.float 0.286489
	.float -0.843607
	.float 1.251859
	.float -1.329730
	.float 1.042175
	.float -0.512247
	.float -0.035155
	.float 0.372925
	.float -0.377858
	.float 0.098966
	.float 0.252044
	.float -0.399827
	.float 0.155140
	.float 0.464813
	.float -1.223709
	.float 1.779647
	.float -1.865934
	.float 1.434166
	.float -0.677481
	.float -0.074074
	.float 0.519800
	.float -0.521433
	.float 0.139656
	.float 0.427185
	.float -0.951324
	.float 1.268720
	.float -1.319841
	.float 1.138733
	.float -0.814288
	.float 0.448981
	.float -0.128387
	.float -0.096125
	.float 0.212188
	.float -0.238912
	.float 0.208184
	.float -0.141588
	.float 0.033803
	.float 0.145223
	.float -0.424675
	.float 0.792876
	.float -1.167220
	.float 1.403664
	.float -1.358536
	.float 0.979805
	.float -0.371414
	.float -0.225713
	.float 0.546675
	.float -0.452289
	.float 0.019244
	.float 0.498424
	.float -0.821417
	.float 0.813474
	.float -0.551616
	.float 0.249700
	.float -0.090785
	.float 0.090660
	.float -0.093769
	.float -0.092874
	.float 0.525418
	.float -1.041328
	.float 1.341938
	.float -1.192578
	.float 0.602338
	.float 0.150645
	.float -0.679091
	.float 0.730301
	.float -0.348071
	.float -0.160282
	.float 0.429471
	.float -0.272346
	.float -0.213821
	.float 0.735675
	.float -1.013109
	.float 0.956307
	.float -0.690521
	.float 0.426872
	.float -0.290376
	.float 0.239509
	.float -0.131632
	.float -0.129821
	.float 0.493324
	.float -0.787967
	.float 0.858166
	.float -0.691779
	.float 0.434999
	.float -0.280498
	.float 0.318973
	.float -0.472637
	.float 0.561729
	.float -0.449845
	.float 0.154082
	.float 0.162493
	.float -0.307063
	.float 0.193373
	.float 0.098488
	.float -0.375262
	.float 0.453526
	.float -0.268536
	.float -0.095642
	.float 0.461511
	.float -0.656937
	.float 0.600713
	.float -0.338253
	.float 0.019461
	.float 0.168863
	.float -0.092928
	.float -0.250403
	.float 0.711414
	.float -1.050594
	.float 1.070262
	.float -0.742661
	.float 0.243165
	.float 0.150493
	.float -0.237165
	.float 0.026560
	.float 0.270276
	.float -0.391091
	.float 0.205744
	.float 0.195946
	.float -0.566843
	.float 0.662034
	.float -0.384036
	.float -0.171312
	.float 0.778123
	.float -1.200056
	.float 1.298864
	.float -1.086029
	.float 0.703632
	.float -0.345654
	.float 0.155262
	.float -0.151789
	.float 0.235804
	.float -0.276186
	.float 0.221265
	.float -0.145730
	.float 0.185884
	.float -0.406974
	.float 0.712573
	.float -0.885473
	.float 0.744974
	.float -0.302658
	.float -0.214281
	.float 0.506987
	.float -0.419406
	.float 0.063085
	.float 0.249126
	.float -0.223268
	.float -0.195370
	.float 0.763301
	.float -1.093239
	.float 0.922178
	.float -0.306133
	.float -0.401192
	.float 0.778460
	.float -0.616963
	.float 0.053343
	.float 0.536759
	.float -0.799710
	.float 0.626128
	.float -0.181132
	.float -0.257059
	.float 0.506629
	.float -0.577758
	.float 0.599816
	.float -0.665592
	.float 0.733270
	.float -0.664734
	.float 0.359531
	.float 0.132384
	.float -0.614874
	.float 0.867111
	.float -0.791899
	.float 0.480481
	.float -0.147459
	.float -0.015080
	.float -0.041813
	.float 0.209962
	.float -0.315283
	.float 0.238629
	.float 0.018963
	.float -0.356649
	.float 0.644377
	.float -0.785640
	.float 0.742447
	.float -0.531099
	.float 0.210684
	.float 0.130818
	.float -0.400828
	.float 0.537003
	.float -0.533090
	.float 0.433605
	.float -0.298118
	.float 0.163369
	.float -0.035284
	.float -0.085532
	.float 0.174920
	.float -0.188650
	.float 0.102342
	.float 0.048599
	.float -0.174642
	.float 0.191276
	.float -0.086562
	.float -0.065148
	.float 0.163394
	.float -0.168208
	.float 0.135570
	.float -0.164674
	.float 0.298571
	.float -0.466074
	.float 0.521993
	.float -0.359927
	.float 0.006885
	.float 0.380582
	.float -0.621884
	.float 0.640705
	.float -0.517296
	.float 0.423337
	.float -0.488299
	.float 0.699284
	.float -0.909040
	.float 0.943235
	.float -0.722552
	.float 0.309736
	.float 0.143073
	.float -0.492883
	.float 0.670102
	.float -0.672713
	.float 0.521889
	.float -0.238200
	.float -0.138261
	.float 0.517520
	.float -0.771500
	.float 0.799064
	.float -0.597477
	.float 0.276698
	.float 0.002391
	.float -0.121874
	.float 0.065032
	.float 0.093757
	.float -0.245146
	.float 0.299710
	.float -0.214297
	.float -0.003176
	.float 0.293080
	.float -0.548418
	.float 0.642735
	.float -0.488868
	.float 0.101637
	.float 0.383887
	.float -0.765709
	.float 0.875981
	.float -0.666823
	.float 0.228976
	.float 0.259029
	.float -0.609360
	.float 0.688459
	.float -0.454322
	.float -0.023596
	.float 0.567025
	.float -0.940064
	.float 0.957201
	.float -0.598273
	.float 0.041333
	.float 0.437271
	.float -0.641969
	.float 0.583957
	.float -0.450656
	.float 0.438111
	.float -0.580914
	.float 0.718505
	.float -0.627368
	.float 0.216486
	.float 0.365739
	.float -0.797898
	.float 0.786242
	.float -0.267059
	.float -0.523987
	.float 1.167771
	.float -1.300474
	.float 0.833986
	.float -0.022791
	.float -0.671219
	.float 0.841500
	.float -0.371551
	.float -0.500230
	.float 1.323382
	.float -1.695472
	.float 1.479082
	.float -0.849609
	.float 0.159529
	.float 0.282393
	.float -0.375354
	.float 0.242780
	.float -0.109400
	.float 0.133526
	.float -0.306175
	.float 0.475716
	.float -0.469749
	.float 0.224453
	.float 0.167614
	.float -0.519356
	.float 0.670859
	.float -0.583281
	.float 0.344667
	.float -0.097404
	.float -0.049561
	.float 0.062439
	.float 0.034039
	.float -0.197537
	.float 0.393046
	.float -0.591423
	.float 0.759951
	.float -0.862592
	.float 0.869155
	.float -0.761292
	.float 0.533364
	.float -0.198341
	.float -0.197167
	.float 0.565475
	.float -0.801701
	.float 0.839479
	.float -0.701367
	.float 0.496638
	.float -0.354822
	.float 0.338739
	.float -0.406700
	.float 0.457159
	.float -0.419233
	.float 0.309516
	.float -0.203280
	.float 0.146982
	.float -0.097757
	.float -0.043433
	.float 0.324025
	.float -0.654126
	.float 0.832969
	.float -0.685743
	.float 0.208480
	.float 0.400572
	.float -0.859776
	.float 0.990532
	.float -0.833360
	.float 0.609184
	.float -0.559055
	.float 0.781416
	.float -1.178486
	.float 1.536667
	.float -1.670991
	.float 1.530831
	.float -1.204217
	.float 0.834397
	.float -0.516262
	.float 0.244066
	.float 0.060566
	.float -0.466005
	.float 0.952960
	.float -1.396075
	.float 1.619676
	.float -1.494556
	.float 1.017049
	.float -0.323604
	.float -0.365426
	.float 0.839664
	.float -0.981263
	.float 0.800050
	.float -0.412726
	.float -0.015890
	.float 0.339013
	.float -0.472443
	.float 0.405484
	.float -0.185703
	.float -0.103907
	.float 0.364386
	.float -0.502158
	.float 0.462116
	.float -0.264784
	.float 0.016201
	.float 0.138476
	.float -0.106233
	.float -0.078103
	.float 0.258673
	.float -0.260218
	.float 0.016473
	.float 0.374570
	.float -0.717560
	.float 0.859588
	.float -0.792015
	.float 0.634828
	.float -0.522914
	.float 0.493739
	.float -0.469445
	.float 0.341147
	.float -0.076532
	.float -0.241746
	.float 0.473826
	.float -0.520965
	.float 0.382150
	.float -0.132695
	.float -0.139275
	.float 0.373509
	.float -0.526476
	.float 0.540943
	.float -0.352983
	.float -0.047628
	.float 0.554185
	.float -0.952209
	.float 1.026915
	.float -0.707623
	.float 0.141060
	.float 0.374597
	.float -0.562045
	.float 0.329160
	.float 0.186959
	.float -0.722856
	.float 1.061744
	.float -1.154666
	.float 1.111652
	.float -1.082783
	.float 1.128253
	.float -1.177881
	.float 1.104076
	.float -0.839863
	.float 0.440421
	.float -0.040545
	.float -0.246914
	.float 0.399225
	.float -0.464855
	.float 0.490371
	.float -0.473513
	.float 0.388137
	.float -0.246236
	.float 0.121204
	.float -0.095345
	.float 0.176471
	.float -0.267651
	.float 0.231826
	.float -0.006787
	.float -0.325199
	.float 0.575782
	.float -0.573058
	.float 0.277762
	.float 0.190459
	.float -0.629624
	.float 0.873739
	.float -0.872175
	.float 0.689591
	.float -0.447869
	.float 0.261978
	.float -0.205795
	.float 0.305853
	.float -0.539486
	.float 0.827500
	.float -1.038127
	.float 1.028211
	.float -0.721205
	.float 0.179314
	.float 0.391562
	.float -0.734364
	.float 0.692294
	.float -0.322511
	.float -0.119060
	.float 0.334143
	.float -0.185340
	.float -0.199717
	.float 0.514572
	.float -0.504897
	.float 0.178109
	.float 0.177128
	.float -0.197116
	.float -0.266803
	.float 0.996737
	.float -1.527308
	.float 1.464397
	.float -0.774132
	.float -0.175457
	.float 0.857353
	.float -0.939548
	.float 0.495893
	.float 0.071329
	.float -0.329708
	.float 0.112424
	.float 0.397431
	.float -0.836704
	.float 0.941324
	.float -0.721014
	.float 0.411251
	.float -0.261128
	.float 0.334716
	.float -0.477787
	.float 0.461213
	.float -0.175939
	.float -0.273451
	.float 0.639778
	.float -0.704690
	.float 0.422124
	.float 0.059405
	.float -0.494704
	.float 0.682808
	.float -0.562346
	.float 0.218925
	.float 0.178942
	.float -0.465728
	.float 0.542672
	.float -0.402095
	.float 0.118544
	.float 0.179085
	.float -0.347085
	.float 0.276774
	.float 0.053453
	.float -0.547786
	.float 1.015958
	.float -1.259534
	.float 1.185636
	.float -0.874657
	.float 0.541712
	.float -0.401168
	.float 0.520622
	.float -0.771244
	.float 0.915880
	.float -0.774937
	.float 0.352297
	.float 0.164155
	.float -0.519877
	.float 0.543572
	.float -0.234939
	.float -0.251758
	.float 0.703501
	.float -0.959863
	.float 0.978843
	.float -0.826693
	.float 0.605867
	.float -0.372654
	.float 0.105799
	.float 0.245792
	.float -0.671208
	.float 1.043403
	.float -1.167581
	.float 0.917472
	.float -0.359939
	.float -0.243359
	.float 0.584541
	.float -0.513433
	.float 0.144290
	.float 0.224359
	.float -0.324561
	.float 0.107652
	.float 0.237106
	.float -0.445747
	.float 0.393586
	.float -0.190225
	.float 0.081977
	.float -0.241004
	.float 0.609586
	.float -0.924765
	.float 0.909642
	.float -0.489217
	.float -0.133131
	.float 0.601322
	.float -0.648058
	.float 0.279482
	.float 0.230166
	.float -0.528670
	.float 0.422666
	.float 0.005583
	.float -0.473710
	.float 0.697990
	.float -0.567800
	.float 0.185072
	.float 0.231310
	.float -0.485378
	.float 0.490579
	.float -0.269720
	.float -0.094915
	.float 0.505622
	.float -0.863522
	.float 1.071633
	.float -1.054576
	.float 0.796104
	.float -0.364291
	.float -0.107546
	.float 0.482854
	.float -0.687028
	.float 0.728588
	.float -0.664266
	.float 0.542666
	.float -0.377453
	.float 0.170545
	.float 0.044686
	.float -0.191832
	.float 0.194319
	.float -0.040554
	.float -0.188445
	.float 0.362580
	.float -0.389729
	.float 0.278000
	.float -0.122062
	.float 0.024401
	.float -0.017018
	.float 0.047612
	.float -0.037971
	.float -0.040255
	.float 0.140608
	.float -0.190272
	.float 0.168069
	.float -0.142110
	.float 0.230593
	.float -0.512811
	.float 0.956757
	.float -1.415717
	.float 1.696155
	.float -1.654938
	.float 1.271387
	.float -0.660555
	.float 0.024290
	.float 0.437464
	.float -0.615553
	.float 0.537933
	.float -0.345800
	.float 0.207985
	.float -0.222077
	.float 0.364458
	.float -0.521275
	.float 0.575138
	.float -0.482946
	.float 0.290716
	.float -0.085185
	.float -0.068782
	.float 0.153566
	.float -0.177763
	.float 0.143625
	.float -0.042750
	.float -0.116908
	.float 0.286797
	.float -0.390030
	.float 0.368210
	.float -0.225187
	.float 0.031235
	.float 0.115906
	.float -0.141962
	.float 0.024641
	.float 0.211228
	.float -0.516217
	.float 0.833884
	.float -1.104743
	.float 1.264261
	.float -1.248974
	.float 1.018247
	.float -0.585230
	.float 0.038139
	.float 0.472124
	.float -0.787950
	.float 0.824585
	.float -0.625735
	.float 0.348241
	.float -0.171523
	.float 0.183575
	.float -0.323241
	.float 0.425468
	.float -0.344393
	.float 0.070124
	.float 0.243822
	.float -0.365346
	.float 0.129775
	.float 0.444623
	.float -1.144598
	.float 1.665772
	.float -1.776225
	.float 1.445718
	.float -0.861674
	.float 0.318076
	.float -0.042919
	.float 0.072253
	.float -0.249231
	.float 0.343332
	.float -0.204724
	.float -0.147357
	.float 0.549178
	.float -0.799907
	.float 0.776138
	.float -0.488821
	.float 0.062471
	.float 0.339079
	.float -0.594639
	.float 0.672939
	.float -0.625693
	.float 0.538520
	.float -0.476255
	.float 0.457386
	.float -0.466458
	.float 0.481700
	.float -0.489238
	.float 0.477152
	.float -0.428052
	.float 0.329986
	.float -0.199905
	.float 0.092256
	.float -0.072658
	.float 0.169470
	.float -0.343371
	.float 0.507115
	.float -0.588944
	.float 0.593495
	.float -0.608025
	.float 0.738930
	.float -1.017541
	.float 1.344683
	.float -1.525455
	.float 1.384830
	.float -0.894072
	.float 0.220841
	.float 0.341073
	.float -0.529143
	.float 0.265144
	.float 0.289693
	.float -0.813689
	.float 0.995483
	.float -0.701376
	.float 0.046348
	.float 0.669899
	.float -1.125565
	.float 1.147346
	.float -0.794951
	.float 0.315235
	.float 0.003064
	.float 0.011877
	.float -0.330853
	.float 0.753403
	.float -1.024670
	.float 0.970810
	.float -0.583996
	.float 0.021740
	.float 0.473072
	.float -0.691898
	.float 0.564659
	.float -0.196984
	.float -0.183532
	.float 0.350762
	.float -0.209180
	.float -0.147414
	.float 0.489491
	.float -0.592672
	.float 0.381431
	.float 0.018432
	.float -0.359111
	.float 0.436159
	.float -0.230676
	.float -0.072906
	.float 0.213436
	.float -0.041630
	.float -0.362082
	.float 0.729175
	.float -0.781452
	.float 0.423990
	.float 0.181577
	.float -0.713477
	.float 0.886788
	.float -0.617541
	.float 0.053040
	.float 0.533888
	.float -0.901395
	.float 0.944558
	.float -0.703844
	.float 0.302458
	.float 0.124876
	.float -0.468393
	.float 0.646097
	.float -0.604949
	.float 0.341690
	.float 0.069166
	.float -0.477662
	.float 0.714207
	.float -0.678507
	.float 0.403305
	.float -0.040869
	.float -0.227141
	.float 0.297969
	.float -0.200769
	.float 0.063136
	.float -0.022750
	.float 0.147177
	.float -0.405269
	.float 0.689809
	.float -0.865695
	.float 0.822958
	.float -0.526002
	.float 0.047633
	.float 0.437145
	.float -0.717345
	.float 0.654424
	.float -0.271568
	.float -0.242968
	.float 0.634774
	.float -0.728510
	.float 0.524983
	.float -0.187351
	.float -0.069210
	.float 0.104755
	.float 0.083881
	.float -0.392957
	.float 0.691272
	.float -0.883026
	.float 0.920685
	.float -0.787851
	.float 0.494639
	.float -0.100670
	.float -0.264499
	.float 0.428675
	.float -0.261836
	.float -0.228093
	.float 0.860238
	.float -1.347202
	.float 1.436881
	.float -1.050645
	.float 0.337261
	.float 0.391568
	.float -0.811433
	.float 0.743994
	.float -0.241976
	.float -0.443160
	.float 0.992824
	.float -1.179869
	.float 0.967672
	.float -0.500045
	.float -0.000938
	.float 0.357427
	.float -0.504882
	.float 0.480759
	.float -0.364085
	.float 0.222026
	.float -0.096667
	.float 0.021325
	.float -0.031915
	.float 0.152289
	.float -0.365197
	.float 0.600678
	.float -0.761292
	.float 0.772713
	.float -0.624256
	.float 0.370666
	.float -0.095221
	.float -0.136621
	.float 0.300175
	.float -0.400408
	.float 0.444644
	.float -0.427304
	.float 0.338849
	.float -0.186561
	.float 0.003290
	.float 0.167814
	.float -0.303269
	.float 0.419981
	.float -0.567070
	.float 0.787914
	.float -1.073425
	.float 1.339205
	.float -1.451640
	.float 1.299002
	.float -0.868041
	.float 0.273729
	.float 0.285932
	.float -0.626828
	.float 0.667816
	.float -0.459603
	.float 0.144852
	.float 0.116952
	.float -0.217497
	.float 0.136504
	.float 0.056960
	.float -0.237531
	.float 0.286049
	.float -0.160546
	.float -0.065915
	.float 0.237584
	.float -0.213765
	.float -0.026333
	.float 0.347803
	.float -0.530374
	.float 0.407394
	.float 0.015771
	.float -0.545536
	.float 0.901824
	.float -0.876940
	.float 0.454501
	.float 0.181588
	.float -0.748265
	.float 1.009577
	.float -0.884687
	.float 0.466712
	.float 0.042470
	.float -0.435676
	.float 0.588499
	.float -0.496743
	.float 0.256381
	.float -0.003504
	.float -0.153161
	.float 0.174184
	.float -0.088317
	.float -0.043540
	.float 0.171198
	.float -0.277624
	.float 0.371760
	.float -0.464813
	.float 0.550698
	.float -0.604159
	.float 0.596422
	.float -0.518497
	.float 0.399502
	.float -0.308058
	.float 0.329232
	.float -0.520631
	.float 0.868681
	.float -1.274755
	.float 1.589907
	.float -1.685330
	.float 1.517643
	.float -1.148354
	.float 0.708940
	.float -0.339642
	.float 0.140412
	.float -0.150887
	.float 0.348175
	.float -0.647069
	.float 0.907681
	.float -0.972455
	.float 0.738492
	.float -0.233434
	.float -0.363546
	.float 0.792504
	.float -0.850346
	.float 0.514158
	.float 0.034118
	.float -0.506581
	.float 0.674164
	.float -0.493661
	.float 0.118131
	.float 0.211559
	.float -0.319763
	.float 0.195106
	.float 0.022293
	.float -0.147491
	.float 0.074116
	.float 0.166854
	.float -0.443270
	.float 0.615383
	.float -0.613923
	.float 0.453145
	.float -0.189465
	.float -0.120344
	.float 0.419438
	.float -0.622474
	.float 0.613884
	.float -0.310130
	.float -0.244411
	.float 0.833744
	.float -1.145984
	.float 0.947503
	.float -0.244837
	.float -0.686614
	.float 1.443057
	.float -1.718249
	.float 1.469675
	.float -0.921111
	.float 0.409391
	.float -0.181707
	.float 0.270348
	.float -0.510313
	.float 0.671786
	.float -0.614585
	.float 0.369927
	.float -0.104653
	.float -0.003397
	.float -0.103371
	.float 0.313107
	.float -0.415978
	.float 0.253914
	.float 0.154700
	.float -0.611533
	.float 0.869889
	.float -0.812064
	.float 0.539051
	.float -0.297202
	.float 0.289485
	.float -0.513079
	.float 0.750187
	.float -0.723047
	.float 0.298524
	.float 0.408885
	.float -1.105349
	.float 1.498356
	.float -1.456427
	.float 1.048830
	.float -0.467507
	.float -0.087020
	.float 0.474899
	.float -0.623663
	.float 0.512536
	.float -0.174930
	.float -0.284970
	.float 0.701552
	.float -0.909675
	.float 0.833864
	.float -0.540428
	.float 0.202265
	.float 0.011962
	.float -0.051829
	.float 0.019440
	.float -0.092975
	.float 0.387023
	.float -0.846024
	.float 1.249278
	.float -1.333498
	.float 0.958298
	.float -0.208818
	.float -0.631898
	.float 1.225736
	.float -1.351246
	.float 1.004960
	.float -0.381619
	.float -0.241534
	.float 0.641135
	.float -0.730057
	.float 0.555142
	.float -0.232127
	.float -0.131212
	.float 0.477683
	.float -0.792688
	.float 1.064000
	.float -1.247946
	.float 1.274177
	.float -1.091242
	.float 0.720144
	.float -0.271043
	.float -0.099593
	.float 0.271242
	.float -0.228556
	.float 0.069400
	.float 0.057919
	.float -0.051084
	.float -0.077567
	.float 0.206671
	.float -0.186393
	.float -0.054612
	.float 0.445625
	.float -0.799684
	.float 0.917251
	.float -0.704851
	.float 0.235053
	.float 0.287785
	.float -0.632956
	.float 0.657965
	.float -0.371173
	.float -0.083259
	.float 0.502275
	.float -0.719381
	.float 0.672090
	.float -0.413007
	.float 0.065488
	.float 0.247724
	.float -0.462485
	.float 0.587924
	.float -0.674361
	.float 0.760637
	.float -0.839172
	.float 0.863519
	.float -0.791186
	.float 0.625845
	.float -0.421987
	.float 0.246190
	.float -0.127852
	.float 0.043973
	.float 0.047771
	.float -0.160184
	.float 0.262830
	.float -0.320123
	.float 0.343097
	.float -0.393365
	.float 0.519868
	.float -0.679472
	.float 0.724454
	.float -0.492144
	.float -0.059968
	.float 0.784760
	.float -1.412402
	.float 1.716005
	.float -1.653293
	.float 1.376059
	.float -1.104118
	.float 0.967213
	.float -0.938028
	.float 0.897154
	.float -0.761358
	.float 0.561100
	.float -0.406914
	.float 0.383410
	.float -0.468369
	.float 0.546856
	.float -0.505499
	.float 0.325583
	.float -0.097543
	.float -0.051772
	.float 0.057545
	.float 0.037011
	.float -0.118250
	.float 0.087491
	.float 0.072196
	.float -0.289986
	.float 0.454468
	.float -0.473391
	.float 0.312609
	.float -0.004858
	.float -0.364365
	.float 0.687096
	.float -0.875072
	.float 0.899598
	.float -0.804914
	.float 0.678432
	.float -0.591489
	.float 0.552332
	.float -0.509237
	.float 0.403305
	.float -0.227806
	.float 0.042703
	.float 0.070426
	.float -0.076462
	.float 0.018710
	.float 0.014576
	.float 0.037694
	.float -0.160498
	.float 0.278081
	.float -0.318636
	.float 0.269773
	.float -0.177933
	.float 0.097859
	.float -0.043408
	.float -0.014839
	.float 0.107782
	.float -0.226542
	.float 0.323646
	.float -0.355731
	.float 0.327872
	.float -0.298139
	.float 0.336358
	.float -0.467653
	.float 0.642070
	.float -0.751719
	.float 0.686810
	.float -0.399764
	.float -0.057020
	.float 0.542132
	.float -0.882672
	.float 0.951506
	.float -0.724874
	.float 0.291521
	.float 0.189080
	.float -0.555109
	.float 0.704225
	.float -0.624465
	.float 0.387133
	.float -0.108524
	.float -0.102215
	.float 0.186338
	.float -0.150088
	.float 0.045363
	.float 0.068572
	.float -0.156785
	.float 0.216140
	.float -0.260785
	.float 0.301352
	.float -0.332698
	.float 0.335106
	.float -0.286016
	.float 0.176883
	.float -0.027628
	.float -0.112483
	.float 0.185208
	.float -0.158074
	.float 0.050444
	.float 0.072040
	.float -0.134826
	.float 0.097371
	.float 0.029880
	.float -0.203112
	.float 0.376055
	.float -0.516009
	.float 0.598857
	.float -0.601992
	.float 0.515067
	.float -0.362297
	.float 0.206334
	.float -0.112446
	.float 0.090198
	.float -0.063383
	.float -0.091228
	.float 0.447803
	.float -0.944388
	.float 1.379248
	.float -1.510761
	.float 1.203761
	.float -0.524586
	.float -0.283222
	.float 0.929018
	.float -1.226037
	.float 1.167935
	.float -0.891515
	.float 0.564811
	.float -0.284325
	.float 0.048264
	.float 0.188608
	.float -0.432159
	.float 0.608209
	.float -0.598466
	.float 0.328761
	.float 0.153767
	.float -0.671959
	.float 0.990925
	.float -0.934237
	.float 0.482341
	.float 0.199422
	.float -0.822118
	.float 1.101727
	.float -0.897547
	.float 0.289749
	.float 0.452390
	.float -1.003175
	.float 1.143111
	.float -0.858247
	.float 0.322153
	.float 0.216332
	.float -0.559398
	.float 0.625481
	.float -0.436132
	.float 0.065650
	.float 0.392808
	.float -0.829008
	.float 1.114800
	.float -1.138429
	.float 0.872073
	.float -0.421483
	.float -0.001579
	.float 0.192626
	.float -0.088447
	.float -0.177641
	.float 0.354068
	.float -0.241456
	.float -0.160939
	.float 0.641003
	.float -0.908420
	.float 0.788674
	.float -0.342605
	.float -0.169961
	.float 0.456256
	.float -0.373152
	.float 0.005340
	.float 0.406715
	.float -0.633078
	.float 0.597909
	.float -0.404283
	.float 0.231292
	.float -0.185759
	.float 0.222326
	.float -0.192048
	.float -0.019535
	.float 0.374451
	.float -0.681588
	.float 0.721112
	.float -0.405335
	.float -0.144361
	.float 0.665154
	.float -0.919439
	.float 0.842185
	.float -0.564498
	.float 0.300521
	.float -0.184723
	.float 0.180725
	.float -0.126953
	.float -0.120711
	.float 0.561347
	.float -1.033251
	.float 1.318038
	.float -1.281700
	.float 0.947548
	.float -0.457645
	.float -0.031161
	.float 0.426967
	.float -0.703379
	.float 0.844921
	.float -0.811519
	.float 0.572178
	.float -0.181415
	.float -0.185656
	.float 0.303480
	.float -0.045244
	.float -0.498874
	.float 1.041489
	.float -1.264503
	.float 1.022697
	.float -0.436060
	.float -0.198535
	.float 0.609267
	.float -0.713724
	.float 0.630208
	.float -0.543930
	.float 0.547494
	.float -0.584634
	.float 0.532762
	.float -0.343532
	.float 0.114608
	.float -0.027332
	.float 0.197449
	.float -0.559693
	.float 0.883628
	.float -0.918533
	.float 0.567374
	.float 0.033926
	.float -0.590282
	.float 0.827226
	.float -0.658377
	.float 0.231379
	.float 0.175052
	.float -0.331526
	.float 0.195783
	.float 0.081079
	.float -0.277570
	.float 0.263915
	.float -0.088608
	.float -0.069210
	.float 0.042752
	.float 0.191603
	.float -0.493205
	.float 0.660585
	.float -0.580902
	.float 0.313241
	.float -0.045258
	.float -0.042737
	.float -0.094105
	.float 0.332617
	.float -0.460441
	.float 0.307996
	.float 0.148970
	.float -0.767924
	.float 1.300855
	.float -1.502976
	.float 1.242930
	.float -0.571421
	.float -0.283353
	.float 1.002430
	.float -1.317105
	.float 1.138703
	.float -0.603593
	.float -0.000327
	.float 0.388701
	.float -0.425793
	.float 0.172932
	.float 0.180717
	.float -0.447726
	.float 0.542341
	.float -0.495864
	.float 0.400995
	.float -0.342790
	.float 0.363635
	.float -0.466193
	.float 0.626807
	.float -0.798509
	.float 0.910453
	.float -0.885754
	.float 0.684101
	.float -0.345019
	.float -0.006217
	.float 0.209750
	.float -0.159686
	.float -0.121833
	.float 0.476651
	.float -0.684515
	.float 0.583868
	.float -0.170784
	.float -0.385664
	.float 0.826031
	.float -0.936901
	.float 0.663387
	.float -0.134063
	.float -0.413537
	.float 0.760818
	.float -0.815301
	.float 0.640923
	.float -0.404083
	.float 0.276118
	.float -0.350271
	.float 0.610841
	.float -0.954984
	.float 1.242867
	.float -1.351741
	.float 1.222341
	.float -0.889303
	.float 0.479578
	.float -0.162082
	.float 0.057655
	.float -0.158221
	.float 0.318743
	.float -0.347144
	.float 0.142333
	.float 0.219059
	.float -0.521013
	.float 0.554570
	.float -0.268868
	.float -0.186821
	.float 0.562480
	.float -0.675115
	.float 0.523504
	.float -0.273846
	.float 0.137577
	.float -0.234195
	.float 0.527871
	.float -0.864816
	.float 1.072209
	.float -1.054785
	.float 0.841491
	.float -0.567741
	.float 0.406449
	.float -0.478958
	.float 0.787407
	.float -1.204655
	.float 1.531347
	.float -1.592360
	.float 1.320938
	.float -0.788644
	.float 0.172448
	.float 0.317560
	.float -0.518345
	.float 0.376764
	.float 0.022347
	.float -0.479703
	.float 0.761945
	.float -0.715289
	.float 0.355299
	.float 0.128403
	.float -0.470237
	.float 0.478815
	.float -0.147967
	.float -0.341904
	.float 0.730143
	.float -0.819665
	.float 0.572193
	.float -0.110743
	.float -0.355302
	.float 0.632238
	.float -0.624062
	.float 0.368571
	.float -0.016514
	.float -0.242672
	.float 0.282900
	.float -0.117704
	.float -0.104891
	.float 0.198515
	.float -0.066584
	.float -0.232162
	.float 0.533164
	.float -0.691618
	.float 0.681869
	.float -0.591301
	.float 0.522056
	.float -0.493342
	.float 0.434424
	.float -0.273657
	.float 0.040860
	.float 0.117107
	.float -0.036785
	.float -0.316424
	.float 0.776060
	.float -1.047748
	.float 0.893425
	.float -0.304646
	.float -0.459421
	.float 1.006677
	.float -1.040905
	.float 0.541462
	.float 0.218457
	.float -0.825587
	.float 0.958206
	.float -0.559702
	.float -0.141241
	.float 0.767173
	.float -1.002871
	.float 0.762851
	.float -0.226068
	.float -0.276549
	.float 0.455431
	.float -0.224113
	.float -0.264772
	.float 0.727833
	.float -0.931012
	.float 0.823363
	.float -0.540630
	.float 0.287659
	.float -0.192868
	.float 0.240042
	.float -0.315724
	.float 0.320341
	.float -0.249956
	.float 0.190322
	.float -0.240893
	.float 0.436594
	.float -0.724826
	.float 1.002916
	.float -1.176921
	.float 1.201153
	.float -1.084986
	.float 0.878702
	.float -0.651107
	.float 0.461943
	.float -0.334531
	.float 0.246042
	.float -0.152337
	.float 0.037497
	.float 0.053850
	.float -0.041453
	.float -0.115392
	.float 0.352658
	.float -0.512834
	.float 0.442305
	.float -0.109517
	.float -0.347353
	.float 0.688068
	.float -0.714105
	.float 0.394176
	.float 0.109212
	.float -0.527448
	.float 0.633218
	.float -0.362571
	.float -0.152211
	.float 0.651864
	.float -0.882019
	.float 0.720227
	.float -0.235315
	.float -0.349988
	.float 0.774132
	.float -0.868646
	.float 0.635415
	.float -0.226630
	.float -0.157408
	.float 0.387437
	.float -0.465850
	.float 0.495193
	.float -0.583522
	.float 0.756112
	.float -0.931650
	.float 0.971388
	.float -0.762016
	.float 0.281209
	.float 0.382743
	.float -1.056365
	.float 1.536160
	.float -1.659611
	.float 1.373343
	.float -0.769384
	.float 0.059029
	.float 0.517636
	.float -0.803543
	.float 0.789905
	.float -0.593978
	.float 0.369665
	.float -0.218360
	.float 0.158513
	.float -0.158363
	.float 0.186342
	.float -0.230339
	.float 0.277485
	.float -0.288585
	.float 0.204991
	.float 0.008333
	.float -0.319789
	.float 0.629851
	.float -0.821429
	.float 0.828579
	.float -0.673637
	.float 0.446459
	.float -0.243717
	.float 0.114041
	.float -0.046429
	.float 0.001990
	.float 0.044042
	.float -0.085463
	.float 0.102358
	.float -0.090424
	.float 0.073972
	.float -0.093107
	.float 0.180564
	.float -0.346894
	.float 0.577803
	.float -0.833586
	.float 1.046845
	.float -1.131696
	.float 1.019499
	.float -0.709942
	.float 0.297810
	.float 0.061402
	.float -0.239569
	.float 0.220984
	.float -0.117819
	.float 0.095934
	.float -0.258152
	.float 0.567577
	.float -0.868106
	.float 0.991572
	.float -0.876955
	.float 0.615637
	.float -0.385387
	.float 0.317852
	.float -0.397410
	.float 0.471653
	.float -0.371337
	.float 0.049965
	.float 0.367373
	.float -0.669115
	.float 0.714386
	.float -0.541095
	.float 0.340662
	.float -0.317602
	.float 0.540234
	.float -0.893091
	.float 1.161986
	.float -1.184167
	.float 0.952182
	.float -0.602231
	.float 0.305367
	.float -0.147290
	.float 0.082155
	.float 0.014446
	.float -0.238789
	.float 0.576145
	.float -0.896877
	.float 1.030211
	.float -0.865957
	.float 0.421435
	.float 0.163703
	.float -0.696059
	.float 1.018069
	.float -1.069342
	.float 0.893834
	.float -0.599977
	.float 0.304565
	.float -0.091287
	.float -0.002754
	.float -0.020056
	.float 0.129237
	.float -0.272516
	.float 0.381369
	.float -0.386543
	.float 0.246428
	.float 0.024530
	.float -0.349517
	.float 0.616766
	.float -0.729693
	.float 0.651042
	.float -0.414550
	.float 0.100897
	.float 0.201769
	.float -0.425399
	.float 0.526422
	.float -0.478145
	.float 0.271727
	.float 0.066485
	.float -0.457269
	.float 0.777458
	.float -0.907311
	.float 0.795755
	.float -0.500078
	.float 0.166508
	.float 0.043741
	.float -0.038955
	.float -0.159995
	.float 0.441935
	.float -0.672868
	.float 0.762636
	.float -0.692676
	.float 0.499136
	.float -0.236824
	.float -0.043616
	.float 0.292119
	.float -0.445252
	.float 0.432007
	.float -0.212991
	.float -0.168789
	.float 0.570739
	.float -0.799085
	.float 0.707930
	.float -0.291204
	.float -0.294932
	.float 0.799779
	.float -0.999914
	.float 0.806875
	.float -0.304056
	.float -0.301182
	.float 0.778916
	.float -0.976205
	.float 0.867561
	.float -0.541423
	.float 0.143890
	.float 0.180838
	.float -0.327783
	.float 0.248206
	.float 0.036681
	.float -0.422455
	.float 0.732882
	.float -0.782012
	.float 0.475131
	.float 0.111006
	.float -0.737901
	.float 1.121044
	.float -1.089421
	.float 0.685386
	.float -0.137235
	.float -0.276608
	.float 0.381113
	.float -0.180974
	.float -0.174680
	.float 0.497670
	.float -0.659193
	.float 0.626560
	.float -0.437920
	.float 0.156676
	.float 0.153860
	.float -0.427197
	.float 0.587033
	.float -0.563008
	.float 0.327732
	.float 0.074529
	.float -0.535730
	.float 0.927650
	.float -1.151033
	.float 1.160046
	.float -0.956847
	.float 0.576438
	.float -0.081334
	.float -0.435473
	.float 0.858229
	.float -1.079776
	.float 1.046750
	.float -0.790542
	.float 0.418973
	.float -0.066334
	.float -0.173716
	.float 0.292697
	.float -0.359239
	.float 0.459645
	.float -0.626417
	.float 0.808530
	.float -0.911156
	.float 0.877110
	.float -0.742697
	.float 0.615368
	.float -0.584932
	.float 0.641117
	.float -0.671658
	.float 0.550394
	.float -0.247925
	.float -0.125111
	.float 0.380892
	.float -0.378859
	.float 0.121728
	.float 0.244343
	.float -0.521883
	.float 0.581072
	.float -0.427483
	.float 0.180897
	.float 0.012504
	.float -0.071610
	.float 0.016397
	.float 0.067798
	.float -0.103741
	.float 0.074884
	.float -0.019731
	.float -0.021690
	.float 0.059401
	.float -0.154817
	.float 0.364568
	.float -0.668826
	.float 0.945461
	.float -1.023776
	.float 0.794289
	.float -0.303084
	.float -0.242578
	.float 0.577817
	.float -0.538302
	.float 0.169724
	.float 0.291824
	.float -0.565738
	.float 0.505312
	.float -0.187525
	.float -0.147356
	.float 0.261471
	.float -0.072371
	.float -0.309286
	.float 0.671613
	.float -0.846131
	.float 0.802151
	.float -0.638041
	.float 0.495109
	.float -0.463746
	.float 0.539477
	.float -0.640005
	.float 0.657903
	.float -0.516041
	.float 0.204855
	.float 0.208145
	.float -0.600955
	.float 0.847344
	.float -0.874890
	.float 0.699316
	.float -0.412235
	.float 0.128638
	.float 0.071273
	.float -0.168540
	.float 0.189820
	.float -0.172824
	.float 0.145823
	.float -0.133082
	.float 0.166713
	.float -0.277633
	.float 0.463138
	.float -0.661476
	.float 0.768833
	.float -0.700249
	.float 0.453162
	.float -0.121453
	.float -0.156857
	.float 0.283124
	.float -0.253194
	.float 0.146913
	.float -0.063328
	.float 0.049686
	.float -0.073242
	.float 0.054882
	.float 0.058746
	.float -0.235813
	.float 0.361057
	.float -0.308800
	.float 0.042747
	.float 0.333148
	.float -0.623368
	.float 0.666606
	.float -0.449091
	.float 0.115901
	.float 0.132603
	.float -0.179543
	.float 0.057370
	.float 0.103814
	.float -0.190317
	.float 0.179917
	.float -0.122032
	.float 0.058564
	.float 0.029381
	.float -0.196829
	.float 0.460393
	.float -0.748533
	.float 0.926774
	.float -0.879507
	.float 0.583364
	.float -0.121073
	.float -0.364291
	.float 0.731780
	.float -0.882666
	.float 0.772350
	.float -0.417272
	.float -0.089076
	.float 0.569493
	.float -0.803755
	.float 0.629657
	.float -0.058013
	.float -0.684614
	.float 1.243967
	.float -1.326252
	.float 0.871209
	.float -0.088936
	.float -0.670382
	.float 1.126203
	.float -1.213802
	.float 1.076989
	.float -0.931325
	.float 0.908703
	.float -0.989730
	.float 1.051614
	.float -0.975302
	.float 0.728272
	.float -0.376186
	.float 0.035370
	.float 0.188354
	.float -0.237118
	.float 0.107759
	.float 0.157148
	.float -0.480279
	.float 0.763253
	.float -0.912488
	.float 0.876782
	.float -0.676620
	.float 0.398471
	.float -0.146812
	.float -0.017360
	.float 0.103377
	.float -0.157548
	.float 0.196325
	.float -0.169076
	.float -0.004961
	.float 0.346047
	.float -0.745254
	.float 0.986952
	.float -0.863454
	.float 0.309027
	.float 0.538094
	.float -1.388547
	.float 1.937430
	.float -2.004359
	.float 1.605376
	.float -0.928449
	.float 0.233582
	.float 0.269531
	.float -0.505893
	.float 0.541006
	.float -0.509016
	.float 0.510811
	.float -0.550505
	.float 0.553631
	.float -0.448850
	.float 0.244209
	.float -0.032813
	.float -0.077441
	.float 0.049715
	.float 0.054229
	.float -0.128008
	.float 0.109591
	.float -0.030890
	.float -0.009717
	.float -0.074338
	.float 0.291880
	.float -0.566709
	.float 0.785783
	.float -0.862357
	.float 0.772427
	.float -0.552174
	.float 0.272189
	.float -0.012351
	.float -0.152882
	.float 0.166641
	.float -0.009700
	.float -0.275405
	.float 0.577722
	.float -0.750187
	.float 0.678495
	.float -0.352065
	.float -0.112448
	.float 0.522545
	.float -0.715935
	.float 0.657256
	.float -0.459207
	.float 0.307614
	.float -0.336090
	.float 0.534485
	.float -0.754825
	.float 0.811182
	.float -0.604120
	.float 0.183684
	.float 0.288523
	.float -0.645677
	.float 0.812008
	.float -0.825319
	.float 0.781190
	.float -0.752661
	.float 0.749746
	.float -0.742670
	.float 0.716114
	.float -0.698661
	.float 0.738769
	.float -0.849636
	.float 0.974452
	.float -1.005548
	.float 0.846405
	.float -0.473126
	.float -0.043192
	.float 0.561961
	.float -0.928544
	.float 1.034843
	.float -0.865063
	.float 0.511058
	.float -0.144688
	.float -0.053093
	.float -0.018532
	.float 0.319614
	.float -0.679908
	.float 0.885044
	.float -0.793949
	.float 0.418052
	.float 0.086379
	.float -0.507225
	.float 0.691248
	.float -0.616397
	.float 0.385831
	.float -0.157884
	.float 0.060293
	.float -0.135478
	.float 0.337589
	.float -0.571910
	.float 0.751293
	.float -0.841339
	.float 0.872413
	.float -0.911815
	.float 1.010331
	.float -1.157179
	.float 1.277778
	.float -1.281926
	.float 1.131064
	.float -0.874008
	.float 0.620358
	.float -0.468163
	.float 0.438305
	.float -0.464193
	.float 0.442942
	.float -0.309322
	.float 0.079634
	.float 0.161811
	.float -0.318675
	.float 0.339344
	.float -0.237853
	.float 0.073602
	.float 0.087268
	.float -0.198055
	.float 0.233152
	.float -0.178309
	.float 0.030545
	.float 0.186908
	.float -0.412527
	.float 0.560578
	.float -0.563636
	.float 0.416717
	.float -0.187175
	.float -0.023887
	.float 0.145783
	.float -0.185125
	.float 0.221884
	.float -0.353910
	.float 0.622271
	.float -0.964140
	.float 1.228105
	.float -1.252721
	.float 0.968164
	.float -0.457559
	.float -0.070217
	.float 0.390441
	.float -0.389711
	.float 0.125657
	.float 0.221744
	.float -0.469695
	.float 0.533954
	.float -0.443416
	.float 0.274562
	.float -0.076898
	.float -0.142480
	.float 0.374046
	.float -0.561800
	.float 0.618987
	.float -0.497729
	.float 0.244213
	.float 0.021239
	.float -0.189774
	.float 0.239289
	.float -0.229883
	.float 0.224717
	.float -0.213704
	.float 0.117035
	.float 0.128309
	.float -0.476002
	.float 0.761566
	.float -0.801305
	.float 0.532178
	.float -0.086017
	.float -0.267903
	.float 0.286147
	.float 0.082699
	.float -0.641492
	.float 1.044851
	.float -1.003455
	.float 0.466870
	.float 0.334573
	.float -1.022346
	.float 1.294772
	.float -1.097149
	.float 0.626676
	.float -0.178273
	.float -0.049790
	.float 0.050678
	.float 0.049248
	.float -0.132359
	.float 0.187433
	.float -0.285984
	.float 0.472205
	.float -0.676867
	.float 0.741409
	.float -0.539805
	.float 0.098388
	.float 0.389479
	.float -0.675163
	.float 0.615288
	.float -0.264950
	.float -0.162711
	.float 0.440126
	.float -0.469153
	.float 0.327640
	.float -0.194135
	.float 0.212770
	.float -0.395052
	.float 0.620709
	.float -0.725655
	.float 0.609253
	.float -0.292138
	.float -0.101732
	.float 0.415367
	.float -0.535289
	.float 0.436686
	.float -0.184070
	.float -0.104038
	.float 0.306046
	.float -0.341115
	.float 0.189594
	.float 0.111212
	.float -0.484755
	.float 0.833059
	.float -1.052073
	.float 1.053113
	.float -0.796122
	.float 0.322749
	.float 0.238411
	.float -0.713748
	.float 0.961416
	.float -0.939825
	.float 0.722677
	.float -0.449365
	.float 0.244499
	.float -0.158474
	.float 0.162171
	.float -0.186795
	.float 0.174180
	.float -0.106747
	.float 0.010824
	.float 0.055684
	.float -0.022769
	.float -0.163478
	.float 0.503964
	.float -0.917505
	.float 1.248042
	.float -1.324189
	.float 1.050997
	.float -0.481104
	.float -0.186996
	.float 0.694342
	.float -0.846245
	.float 0.603780
	.float -0.089150
	.float -0.491849
	.float 0.956069
	.float -1.212258
	.float 1.261743
	.float -1.149719
	.float 0.916265
	.float -0.585799
	.float 0.194889
	.float 0.176064
	.float -0.407266
	.float 0.392388
	.float -0.112571
	.float -0.319921
	.float 0.690926
	.float -0.787756
	.float 0.526577
	.float -0.024977
	.float -0.439053
	.float 0.575296
	.float -0.255854
	.float -0.392808
	.float 1.047241
	.float -1.366649
	.float 1.188021
	.float -0.617932
	.float -0.032382
	.float 0.425525
	.float -0.380814
	.float -0.044194
	.float 0.613434
	.float -1.066436
	.float 1.266011
	.float -1.248790
	.float 1.155456
	.float -1.100148
	.float 1.078378
	.float -0.981084
	.float 0.701251
	.float -0.249697
	.float -0.211525
	.float 0.450391
	.float -0.310726
	.float -0.173618
	.float 0.774621
	.float -1.184465
	.float 1.182817
	.float -0.757409
	.float 0.107565
	.float 0.468327
	.float -0.729777
	.float 0.602904
	.float -0.187593
	.float -0.321134
	.float 0.733434
	.float -0.928389
	.float 0.864855
	.float -0.564286
	.float 0.095518
	.float 0.431262
	.float -0.878127
	.float 1.116194
	.float -1.079579
	.float 0.807400
	.float -0.441807
	.float 0.170571
	.float -0.135199
	.float 0.352545
	.float -0.698649
	.float 0.972128
	.float -1.005199
	.float 0.756926
	.float -0.331911
	.float -0.084020
	.float 0.326799
	.float -0.332397
	.float 0.151740
	.float 0.092255
	.float -0.271631
	.float 0.308628
	.float -0.200016
	.float 0.007765
	.float 0.176175
	.float -0.275030
	.float 0.261064
	.float -0.160150
	.float 0.026165
	.float 0.096044
	.float -0.191543
	.float 0.266142
	.float -0.318827
	.float 0.325136
	.float -0.252978
	.float 0.103955
	.float 0.055667
	.float -0.112594
	.float -0.020817
	.float 0.320588
	.float -0.620334
	.float 0.680960
	.float -0.338852
	.float -0.357427
	.float 1.125049
	.float -1.579267
	.float 1.455124
	.float -0.780516
	.float -0.120544
	.float 0.809698
	.float -0.992538
	.float 0.688086
	.float -0.199079
	.float -0.096062
	.float -0.008310
	.float 0.419224
	.float -0.818586
	.float 0.879283
	.float -0.476950
	.float -0.237130
	.float 0.936287
	.float -1.312694
	.float 1.237556
	.float -0.799666
	.float 0.224342
	.float 0.255487
	.float -0.495783
	.float 0.469081
	.float -0.238107
	.float -0.089488
	.float 0.400885
	.float -0.607709
	.float 0.668188
	.float -0.598264
	.float 0.462542
	.float -0.342706
	.float 0.295499
	.float -0.323172
	.float 0.375208
	.float -0.383777
	.float 0.313247
	.float -0.192481
	.float 0.105034
	.float -0.138047
	.float 0.320070
	.float -0.589918
	.float 0.822189
	.float -0.897035
	.float 0.770812
	.float -0.500349
	.float 0.204316
	.float 0.012294
	.float -0.118212
	.float 0.157968
	.float -0.195626
	.float 0.245713
	.float -0.250874
	.float 0.132467
	.float 0.121415
	.float -0.405946
	.float 0.542606
	.float -0.397213
	.float -0.013092
	.float 0.511970
	.float -0.869036
	.float 0.942123
	.float -0.750327
	.float 0.431554
	.float -0.133534
	.float -0.065843
	.float 0.154278
	.float -0.129484
	.float -0.029388
	.float 0.323169
	.float -0.669503
	.float 0.899267
	.float -0.849660
	.float 0.495747
	.float -0.008379
	.float -0.329139
	.float 0.302446
	.float 0.082975
	.float -0.596112
	.float 0.929701
	.float -0.899848
	.float 0.556269
	.float -0.131066
	.float -0.128935
	.float 0.122907
	.float 0.059648
	.float -0.229601
	.float 0.246285
	.float -0.110895
	.float -0.058004
	.float 0.137405
	.float -0.106322
	.float 0.059697
	.float -0.118566
	.float 0.311024
	.float -0.525689
	.float 0.584750
	.float -0.386606
	.float 0.005559
	.float 0.338188
	.float -0.425963
	.float 0.198784
	.float 0.194084
	.float -0.494215
	.float 0.506775
	.float -0.220121
	.float -0.207179
	.float 0.565708
	.float -0.720370
	.float 0.653864
	.float -0.423387
	.float 0.096899
	.float 0.265110
	.float -0.582750
	.float 0.743815
	.float -0.653948
	.float 0.325020
	.float 0.083057
	.float -0.332197
	.float 0.258806
	.float 0.102625
	.float -0.528455
	.float 0.749761
	.float -0.626194
	.float 0.223193
	.float 0.253749
	.float -0.604043
	.float 0.744444
	.float -0.721726
	.float 0.642705
	.float -0.591620
	.float 0.590127
	.float -0.605607
	.float 0.579016
	.float -0.449091
	.float 0.173278
	.float 0.246312
	.float -0.739177
	.float 1.170299
	.float -1.388579
	.float 1.302420
	.float -0.936106
	.float 0.425903
	.float 0.044122
	.float -0.324537
	.float 0.350733
	.float -0.140851
	.float -0.237716
	.float 0.697322
	.float -1.137457
	.float 1.445405
	.float -1.515193
	.float 1.291872
	.float -0.815719
	.float 0.228899
	.float 0.273940
	.float -0.530419
	.float 0.484129
	.float -0.204941
	.float -0.153012
	.float 0.429298
	.float -0.528577
	.float 0.452593
	.float -0.284014
	.float 0.134949
	.float -0.086035
	.float 0.144333
	.float -0.241044
	.float 0.273015
	.float -0.167869
	.float -0.066061
	.float 0.340843
	.float -0.545834
	.float 0.623890
	.float -0.610725
	.float 0.603488
	.float -0.679744
	.float 0.830350
	.float -0.963296
	.float 0.978342
	.float -0.851204
	.float 0.656329
	.float -0.508060
	.float 0.469281
	.float -0.503249
	.float 0.505434
	.float -0.387097
	.float 0.145343
	.float 0.127576
	.float -0.294809
	.float 0.250023
	.float 0.022323
	.float -0.425459
	.float 0.777819
	.float -0.888135
	.float 0.655939
	.float -0.147605
	.float -0.409344
	.float 0.735347
	.float -0.662925
	.float 0.253151
	.float 0.224664
	.float -0.452608
	.float 0.265497
	.float 0.241315
	.float -0.772502
	.float 1.019881
	.float -0.848709
	.float 0.363361
	.float 0.178228
	.float -0.531188
	.float 0.599497
	.float -0.464232
	.float 0.303620
	.float -0.268304
	.float 0.391643
	.float -0.584881
	.float 0.710031
	.float -0.675335
	.float 0.487161
	.float -0.227833
	.float -0.014929
	.float 0.207414
	.float -0.374791
	.float 0.557708
	.float -0.763545
	.float 0.949556
	.float -1.041689
	.float 0.969549
	.float -0.701707
	.float 0.277352
	.float 0.176555
	.float -0.469820
	.float 0.433768
	.float -0.036955
	.float -0.547587
	.float 0.997137
	.float -1.011285
	.float 0.501717
	.float 0.330006
	.float -1.090023
	.float 1.410423
	.float -1.154738
	.float 0.487748
	.float 0.224382
	.float -0.617315
	.float 0.515743
	.float -0.004735
	.float -0.642959
	.float 1.129776
	.float -1.286290
	.float 1.129347
	.float -0.805993
	.float 0.477897
	.float -0.231783
	.float 0.070397
	.float 0.029214
	.float -0.053920
	.float -0.050288
	.float 0.318246
	.float -0.691454
	.float 0.999834
	.float -1.033165
	.float 0.667741
	.float 0.035436
	.float -0.836647
	.float 1.435677
	.float -1.630486
	.float 1.413517
	.float -0.947148
	.float 0.448188
	.float -0.071053
	.float -0.134561
	.float 0.188140
	.float -0.123260
	.float -0.028726
	.float 0.213117
	.float -0.333771
	.float 0.286984
	.float -0.036514
	.float -0.333547
	.float 0.646875
	.float -0.738757
	.float 0.563514
	.float -0.222689
	.float -0.110339
	.float 0.312177
	.float -0.385291
	.float 0.433864
	.float -0.564852
	.float 0.794748
	.float -1.032357
	.float 1.145081
	.float -1.053590
	.float 0.784415
	.float -0.447580
	.float 0.165446
	.float -0.009906
	.float -0.010542
	.float -0.079658
	.float 0.255184
	.float -0.489140
	.float 0.727261
	.float -0.878732
	.float 0.854733
	.float -0.636256
	.float 0.312976
	.float -0.047238
	.float -0.024068
	.float -0.118948
	.float 0.363534
	.float -0.539310
	.float 0.531945
	.float -0.357778
	.float 0.151623
	.float -0.078448
	.float 0.226089
	.float -0.543316
	.float 0.858277
	.float -0.967800
	.float 0.750601
	.float -0.244382
	.float -0.357939
	.float 0.799403
	.float -0.896266
	.float 0.646619
	.float -0.238936
	.float -0.058097
	.float 0.066814
	.float 0.177899
	.float -0.447815
	.float 0.480875
	.float -0.177667
	.float -0.304735
	.float 0.636145
	.float -0.525558
	.float -0.077179
	.float 0.925719
	.float -1.606574
	.float 1.774917
	.float -1.352981
	.float 0.573824
	.float 0.151907
	.float -0.465543
	.float 0.253671
	.float 0.299996
	.float -0.824305
	.float 0.962680
	.float -0.555688
	.float -0.284811
	.float 1.234710
	.float -1.909750
	.float 2.037356
	.float -1.576126
	.float 0.735726
	.float 0.113562
	.float -0.609485
	.float 0.571946
	.float -0.092551
	.float -0.518438
	.float 0.907681
	.float -0.874499
	.float 0.463284
	.float 0.103863
	.float -0.595277
	.float 0.906963
	.float -1.069315
	.float 1.138071
	.float -1.083296
	.float 0.788999
	.float -0.173756
	.float -0.671222
	.float 1.457682
	.float -1.836046
	.float 1.610186
	.float -0.880210
	.float 0.004883
	.float 0.601014
	.float -0.705206
	.float 0.377703
	.float 0.082627
	.float -0.358994
	.float 0.318719
	.float -0.070441
	.float -0.153090
	.float 0.189920
	.float -0.069775
	.float -0.029727
	.float -0.048924
	.float 0.292460
	.float -0.512354
	.float 0.494963
	.float -0.184890
	.float -0.252532
	.float 0.545977
	.float -0.521162
	.float 0.230060
	.float 0.093254
	.float -0.208526
	.float 0.035409
	.float 0.310791
	.float -0.619759
	.float 0.728623
	.float -0.602028
	.float 0.318156
	.float -0.003108
	.float -0.227297
	.float 0.296269
	.float -0.177541
	.float -0.096876
	.float 0.439402
	.float -0.732376
	.float 0.871981
	.float -0.808443
	.float 0.563225
	.float -0.219941
	.float -0.103676
	.float 0.296903
	.float -0.304112
	.float 0.161276
	.float 0.008291
	.float -0.053658
	.float -0.112801
	.float 0.451720
	.float -0.809862
	.float 1.010307
	.float -0.962936
	.float 0.721998
	.float -0.453276
	.float 0.333663
	.float -0.449309
	.float 0.753942
	.float -1.106445
	.float 1.354358
	.float -1.406516
	.float 1.254455
	.float -0.944445
	.float 0.536320
	.float -0.085701
	.float -0.344647
	.float 0.671306
	.float -0.806253
	.float 0.706973
	.float -0.427617
	.float 0.124499
	.float 0.007570
	.float 0.156417
	.float -0.582804
	.float 1.074656
	.float -1.370124
	.float 1.293348
	.float -0.862840
	.float 0.280675
	.float 0.195038
	.float -0.407335
	.float 0.376591
	.float -0.245832
	.float 0.145903
	.float -0.089855
	.float -0.023564
	.float 0.306953
	.float -0.769229
	.float 1.278952
	.float -1.632200
	.float 1.673241
	.float -1.383826
	.float 0.887265
	.float -0.375107
	.float 0.009996
	.float 0.139334
	.float -0.106281
	.float -0.010959
	.float 0.105762
	.float -0.113848
	.float 0.041016
	.float 0.046130
	.float -0.068707
	.float 0.000456
	.float 0.098425
	.float -0.117616
	.float -0.008775
	.float 0.221176
	.float -0.348092
	.float 0.228974
	.float 0.137668
	.float -0.548037
	.float 0.712013
	.float -0.467290
	.float -0.074795
	.float 0.580390
	.float -0.721646
	.float 0.416488
	.float 0.107264
	.float -0.479095
	.float 0.459457
	.float -0.110372
	.float -0.264229
	.float 0.355349
	.float -0.075584
	.float -0.393902
	.float 0.757984
	.float -0.830186
	.float 0.648726
	.float -0.408682
	.float 0.283199
	.float -0.288134
	.float 0.296137
	.float -0.175239
	.float -0.075602
	.float 0.311584
	.float -0.356840
	.float 0.146945
	.float 0.220344
	.float -0.561148
	.float 0.734906
	.float -0.718204
	.float 0.574584
	.float -0.367912
	.float 0.109803
	.float 0.211818
	.float -0.559520
	.float 0.810875
	.float -0.811030
	.float 0.484168
	.float 0.082659
	.float -0.655664
	.float 0.969815
	.float -0.870723
	.float 0.394271
	.float 0.257575
	.float -0.817769
	.float 1.068000
	.float -0.913830
	.float 0.406131
	.float 0.280805
	.float -0.903285
	.float 1.229369
	.float -1.132703
	.float 0.661846
	.float -0.037720
	.float -0.441318
	.float 0.549804
	.float -0.256787
	.float -0.260439
	.float 0.725634
	.float -0.928663
	.float 0.839944
	.float -0.604031
	.float 0.426815
	.float -0.441184
	.float 0.640315
	.float -0.908936
	.float 1.113217
	.float -1.178927
	.float 1.113101
	.float -0.972244
	.float 0.814750
	.float -0.672382
	.float 0.551461
	.float -0.448903
	.float 0.363644
	.float -0.294809
	.float 0.233045
	.float -0.156614
	.float 0.037586
	.float 0.145532
	.float -0.394718
	.float 0.683547
	.float -0.955264
	.float 1.132235
	.float -1.139180
	.float 0.934398
	.float -0.533936
	.float 0.014415
	.float 0.506569
	.float -0.901160
	.float 1.060653
	.float -0.921492
	.float 0.490254
	.float 0.138949
	.float -0.793499
	.float 1.273003
	.float -1.430300
	.float 1.241780
	.float -0.821405
	.float 0.363656
	.float -0.046581
	.float -0.046784
	.float -0.055412
	.float 0.259256
	.float -0.469469
	.float 0.624802
	.float -0.688909
	.float 0.623216
	.float -0.383297
	.float -0.045655
	.float 0.601924
	.float -1.136876
	.float 1.467359
	.float -1.467929
	.float 1.145379
	.float -0.644547
	.float 0.178803
	.float 0.074431
	.float -0.055173
	.float -0.159949
	.float 0.402769
	.float -0.496072
	.float 0.336566
	.float 0.053120
	.float -0.523674
	.float 0.855675
	.float -0.857803
	.float 0.466980
	.float 0.201915
	.float -0.893008
	.float 1.323894
	.float -1.320798
	.float 0.900134
	.float -0.251743
	.float -0.362178
	.float 0.730578
	.float -0.772204
	.float 0.539152
	.float -0.163254
	.float -0.210643
	.float 0.470726
	.float -0.557845
	.float 0.470372
	.float -0.261024
	.float 0.017749
	.float 0.177427
	.float -0.295344
	.float 0.375038
	.float -0.482529
	.float 0.634652
	.float -0.752461
	.float 0.700330
	.float -0.399431
	.float -0.070241
	.float 0.476556
	.float -0.571231
	.float 0.267155
	.float 0.279308
	.float -0.755379
	.float 0.892096
	.float -0.631499
	.float 0.139073
	.float 0.336781
	.float -0.639397
	.float 0.777133
	.float -0.853165
	.float 0.929179
	.float -0.946791
	.float 0.772219
	.float -0.323768
	.float -0.324895
	.float 0.951452
	.float -1.303764
	.float 1.252536
	.float -0.876946
	.float 0.427420
	.float -0.185916
	.float 0.306225
	.float -0.725914
	.float 1.200029
	.float -1.436893
	.float 1.260586
	.float -0.710043
	.float 0.019792
	.float 0.507303
	.float -0.663700
	.float 0.444242
	.float -0.035468
	.float -0.303740
	.float 0.395580
	.float -0.237275
	.float -0.018212
	.float 0.176164
	.float -0.133004
	.float -0.056026
	.float 0.216142
	.float -0.173800
	.float -0.117718
	.float 0.531698
	.float -0.837273
	.float 0.846203
	.float -0.541724
	.float 0.099662
	.float 0.218153
	.float -0.229181
	.float -0.056664
	.float 0.450060
	.float -0.708225
	.float 0.686473
	.float -0.417394
	.float 0.073469
	.float 0.153670
	.float -0.174155
	.float 0.042832
	.float 0.098255
	.float -0.131120
	.float 0.042820
	.float 0.083685
	.float -0.156037
	.float 0.159411
	.float -0.166013
	.float 0.258545
	.float -0.438290
	.float 0.606129
	.float -0.640029
	.float 0.502680
	.float -0.281759
	.float 0.123631
	.float -0.116072
	.float 0.221514
	.float -0.317101
	.float 0.303799
	.float -0.187611
	.float 0.063426
	.float -0.018188
	.float 0.040581
	.float -0.018051
	.float -0.171942
	.float 0.549983
	.float -0.994126
	.float 1.308184
	.float -1.352003
	.float 1.138572
	.float -0.825953
	.float 0.608630
	.float -0.585364
	.float 0.698428
	.float -0.787550
	.float 0.718657
	.float -0.491643
	.float 0.244996
	.float -0.151990
	.float 0.284663
	.float -0.549047
	.float 0.742676
	.float -0.694840
	.float 0.388972
	.float 0.019932
	.float -0.304708
	.float 0.313748
	.float -0.068994
	.float -0.247671
	.float 0.408625
	.float -0.283552
	.float -0.074900
	.float 0.454322
	.float -0.604058
	.float 0.388152
	.float 0.118180
	.float -0.652112
	.float 0.905884
	.float -0.714344
	.float 0.173531
	.float 0.394450
	.float -0.625469
	.float 0.338823
	.float 0.341693
	.float -1.057163
	.float 1.431910
	.float -1.294751
	.float 0.756023
	.float -0.099350
	.float -0.418413
	.float 0.707039
	.float -0.832007
	.float 0.890874
	.float -0.901517
	.float 0.802596
	.float -0.555351
	.float 0.238318
	.float -0.030072
	.float 0.076679
	.float -0.351451
	.float 0.636589
	.float -0.663423
	.float 0.316103
	.float 0.259895
	.float -0.739395
	.float 0.840188
	.float -0.523528
	.float 0.019944
	.float 0.341949
	.float -0.374582
	.float 0.156532
	.float 0.047324
	.float -0.000954
	.float -0.324251
	.float 0.740539
	.float -0.995968
	.float 0.953974
	.float -0.661607
	.float 0.273946
	.float 0.077683
	.float -0.356753
	.float 0.589510
	.float -0.787517
	.float 0.914608
	.float -0.930511
	.float 0.858891
	.float -0.799055
	.float 0.853666
	.float -1.029034
	.float 1.200426
	.float -1.188453
	.float 0.900590
	.float -0.430049
	.float 0.025854
	.float 0.059648
	.float 0.255725
	.float -0.814935
	.float 1.313501
	.float -1.493158
	.float 1.303496
	.float -0.919710
	.float 0.608647
	.float -0.543107
	.float 0.695185
	.float -0.874860
	.float 0.873751
	.float -0.607336
	.float 0.163056
	.float 0.263574
	.float -0.489190
	.float 0.439378
	.float -0.171692
	.float -0.172429
	.float 0.445595
	.float -0.555229
	.float 0.481295
	.float -0.256892
	.float -0.062043
	.float 0.413051
	.float -0.726227
	.float 0.923501
	.float -0.937182
	.float 0.743809
	.float -0.387243
	.float -0.032779
	.float 0.401427
	.float -0.628441
	.float 0.663548
	.float -0.494659
	.float 0.153745
	.float 0.265990
	.float -0.613446
	.float 0.737022
	.float -0.580497
	.float 0.245498
	.float 0.050748
	.float -0.117825
	.float -0.060398
	.float 0.291792
	.float -0.298595
	.float -0.079543
	.float 0.748288
	.float -1.392982
	.float 1.670180
	.float -1.427162
	.float 0.798089
	.float -0.113527
	.float -0.308529
	.float 0.343392
	.float -0.097740
	.float -0.199709
	.float 0.359257
	.float -0.331723
	.float 0.202919
	.float -0.112502
	.float 0.162733
	.float -0.364711
	.float 0.635531
	.float -0.838933
	.float 0.853869
	.float -0.642953
	.float 0.282486
	.float 0.073668
	.float -0.283038
	.float 0.299272
	.float -0.190205
	.float 0.073413
	.float -0.018470
	.float -0.007255
	.float 0.105797
	.float -0.356443
	.float 0.739511
	.float -1.137341
	.float 1.409750
	.float -1.481430
	.float 1.372777
	.float -1.156479
	.float 0.885107
	.float -0.554877
	.float 0.135456
	.float 0.365373
	.float -0.863415
	.float 1.224630
	.float -1.339762
	.float 1.190450
	.float -0.857639
	.float 0.468804
	.float -0.125191
	.float -0.140642
	.float 0.355603
	.float -0.563127
	.float 0.782108
	.float -0.991888
	.float 1.143296
	.float -1.181264
	.float 1.068084
	.float -0.805162
	.float 0.450754
	.float -0.122164
	.float -0.033957
	.float -0.095073
	.float 0.516643
	.float -1.098219
	.float 1.604061
	.float -1.797154
	.float 1.556860
	.float -0.946394
	.float 0.189469
	.float 0.433771
	.float -0.716821
	.float 0.616128
	.float -0.256565
	.float -0.144852
	.float 0.393526
	.float -0.408256
	.float 0.243269
	.float -0.036360
	.float -0.079984
	.float 0.049985
	.float 0.088101
	.float -0.238428
	.float 0.307587
	.float -0.253331
	.float 0.102754
	.float 0.061120
	.float -0.136173
	.float 0.050355
	.float 0.193945
	.float -0.506057
	.float 0.744274
	.float -0.796128
	.float 0.656097
	.float -0.441401
	.float 0.321715
	.float -0.403728
	.float 0.653989
	.float -0.921206
	.float 1.042765
	.float -0.952975
	.float 0.711521
	.float -0.439691
	.float 0.226724
	.float -0.085403
	.float -0.016107
	.float 0.089316
	.float -0.094643
	.float -0.025496
	.float 0.281498
	.float -0.600547
	.float 0.854506
	.float -0.933006
	.float 0.807919
	.float -0.546108
	.float 0.268447
	.float -0.087007
	.float 0.056011
	.float -0.152742
	.float 0.287206
	.float -0.336462
	.float 0.199831
	.float 0.139710
	.float -0.583042
	.float 0.946564
	.float -1.058820
	.float 0.868562
	.float -0.486660
	.float 0.121104
	.float 0.056821
	.float -0.019125
	.float -0.119288
	.float 0.204800
	.float -0.167384
	.float 0.062857
	.float -0.006286
	.float 0.059009
	.float -0.167561
	.float 0.204004
	.float -0.069935
	.float -0.223008
	.float 0.556707
	.float -0.781899
	.float 0.801582
	.float -0.607977
	.float 0.267471
	.float 0.115533
	.float -0.429995
	.float 0.584506
	.float -0.538383
	.float 0.328144
	.float -0.062170
	.float -0.130804
	.float 0.174620
	.float -0.089959
	.float -0.023901
	.float 0.056722
	.float 0.042540
	.float -0.236276
	.float 0.419647
	.float -0.475093
	.float 0.332844
	.float -0.013167
	.float -0.369772
	.float 0.654121
	.float -0.714234
	.float 0.538827
	.float -0.249416
	.float 0.035613
	.float -0.040606
	.float 0.270265
	.float -0.587421
	.float 0.794617
	.float -0.750205
	.float 0.444358
	.float 0.004097
	.float -0.415638
	.float 0.633865
	.float -0.581707
	.float 0.277128
	.float 0.178166
	.float -0.623869
	.float 0.882019
	.float -0.821080
	.float 0.429554
	.float 0.146053
	.float -0.646657
	.float 0.830663
	.float -0.619121
	.float 0.153556
	.float 0.290107
	.float -0.483647
	.float 0.397192
	.float -0.206090
	.float 0.148481
	.float -0.343660
	.float 0.709429
	.float -1.034720
	.float 1.141219
	.float -1.005413
	.float 0.755826
	.float -0.563866
	.float 0.521791
	.float -0.594988
	.float 0.666960
	.float -0.628676
	.float 0.445327
	.float -0.164076
	.float -0.128098
	.float 0.359170
	.float -0.502209
	.float 0.567025
	.float -0.567699
	.float 0.496871
	.float -0.329956
	.float 0.055757
	.float 0.294483
	.float -0.646589
	.float 0.913245
	.float -1.030843
	.float 0.978306
	.float -0.774466
	.float 0.468428
	.float -0.134404
	.float -0.135095
	.float 0.251061
	.float -0.164339
	.float -0.103811
	.float 0.460408
	.float -0.773369
	.float 0.921066
	.float -0.835658
	.float 0.526258
	.float -0.077423
	.float -0.377214
	.float 0.702404
	.float -0.814237
	.float 0.711706
	.float -0.467406
	.float 0.183776
	.float 0.053701
	.float -0.197945
	.float 0.235022
	.float -0.175080
	.float 0.056081
	.float 0.051144
	.float -0.063573
	.float -0.060649
	.float 0.270880
	.float -0.427000
	.float 0.377518
	.float -0.071520
	.float -0.376663
	.float 0.728105
	.float -0.752646
	.float 0.372800
	.float 0.274461
	.float -0.898787
	.float 1.201418
	.float -1.018468
	.float 0.388903
	.float 0.472440
	.float -1.265161
	.float 1.709487
	.float -1.635288
	.float 1.039585
	.float -0.100591
	.float -0.868154
	.float 1.527544
	.float -1.655060
	.float 1.251672
	.float -0.546573
	.float -0.117141
	.float 0.458271
	.float -0.394197
	.float 0.057576
	.float 0.310511
	.float -0.516244
	.float 0.514694
	.float -0.398584
	.float 0.297365
	.float -0.270121
	.float 0.272237
	.float -0.213155
	.float 0.051909
	.float 0.149690
	.float -0.260044
	.float 0.172884
	.float 0.107548
	.float -0.455439
	.float 0.695937
	.float -0.711024
	.float 0.508680
	.float -0.214460
	.float -0.002624
	.float 0.020986
	.float 0.174999
	.float -0.493342
	.float 0.784862
	.float -0.921326
	.float 0.864646
	.float -0.687946
	.float 0.528747
	.float -0.495422
	.float 0.588827
	.float -0.701054
	.float 0.699504
	.float -0.534452
	.float 0.282925
	.float -0.091338
	.float 0.062216
	.float -0.176874
	.float 0.313074
	.float -0.337729
	.float 0.198918
	.float 0.046911
	.float -0.277848
	.float 0.374654
	.float -0.268445
	.float -0.043464
	.float 0.496361
	.float -0.960235
	.float 1.259427
	.float -1.231738
	.float 0.818923
	.float -0.135495
	.float -0.549899
	.float 0.939113
	.float -0.873340
	.float 0.435318
	.float 0.094084
	.float -0.405406
	.float 0.344453
	.float 0.013313
	.float -0.441217
	.float 0.725196
	.float -0.790793
	.float 0.710502
	.float -0.604987
	.float 0.528896
	.float -0.432675
	.float 0.223361
	.float 0.133769
	.float -0.561449
	.float 0.912855
	.float -1.078971
	.float 1.073341
	.float -1.021156
	.float 1.055408
	.float -1.201659
	.float 1.346796
	.float -1.320827
	.float 1.027257
	.float -0.516772
	.float -0.051739
	.float 0.523370
	.float -0.833190
	.float 0.996815
	.float -1.028417
	.float 0.878976
	.float -0.470696
	.float -0.190148
	.float 0.927608
	.float -1.441224
	.float 1.481895
	.float -1.035707
	.float 0.360059
	.float 0.179859
	.float -0.363778
	.float 0.261403
	.float -0.150418
	.float 0.271911
	.float -0.624319
	.float 0.965195
	.float -1.014996
	.float 0.688894
	.float -0.166246
	.float -0.251118
	.float 0.367575
	.float -0.225549
	.float 0.048556
	.float -0.056041
	.float 0.298664
	.float -0.629600
	.float 0.816696
	.float -0.705632
	.float 0.324001
	.float 0.132301
	.float -0.413164
	.float 0.358258
	.float 0.008817
	.float -0.486144
	.float 0.796661
	.float -0.736158
	.float 0.287008
	.float 0.367459
	.float -0.941485
	.float 1.206094
	.float -1.115068
	.float 0.817477
	.float -0.544803
	.float 0.446000
	.float -0.484788
	.float 0.475310
	.float -0.232716
	.float -0.271933
	.float 0.869352
	.float -1.294927
	.float 1.359228
	.float -1.061369
	.float 0.571210
	.float -0.108435
	.float -0.184274
	.float 0.289121
	.float -0.270324
	.float 0.194698
	.float -0.081157
	.float -0.093293
	.float 0.351150
	.float -0.673821
	.float 0.990016
	.float -1.196846
	.float 1.202375
	.float -0.972274
	.float 0.559684
	.float -0.096760
	.float -0.260449
	.float 0.413096
	.float -0.377906
	.float 0.276447
	.float -0.252612
	.float 0.371605
	.float -0.574932
	.float 0.727565
	.float -0.720692
	.float 0.549166
	.float -0.304795
	.float 0.096859
	.float 0.030665
	.float -0.118741
	.float 0.238583
	.float -0.412270
	.float 0.574873
	.float -0.609485
	.float 0.431387
	.float -0.062495
	.float -0.356381
	.float 0.627204
	.float -0.596818
	.float 0.241946
	.float 0.308261
	.float -0.823214
	.float 1.070435
	.float -0.919951
	.float 0.408247
	.float 0.268555
	.float -0.837419
	.float 1.074826
	.float -0.913985
	.float 0.472118
	.float 0.019841
	.float -0.341252
	.float 0.385088
	.float -0.188521
	.float -0.108200
	.float 0.335178
	.float -0.361719
	.float 0.145442
	.float 0.243489
	.float -0.636053
	.float 0.829882
	.float -0.693302
	.float 0.255401
	.float 0.283463
	.float -0.646416
	.float 0.635430
	.float -0.253215
	.float -0.289200
	.float 0.688712
	.float -0.718961
	.float 0.348041
	.float 0.261251
	.float -0.855213
	.float 1.221369
	.float -1.270481
	.float 1.041009
	.float -0.654267
	.float 0.264059
	.float -0.017978
	.float 0.017936
	.float -0.272690
	.float 0.668925
	.float -1.003619
	.float 1.086354
	.float -0.856473
	.float 0.427966
	.float -0.017086
	.float -0.202593
	.float 0.211200
	.float -0.136615
	.float 0.140176
	.float -0.285015
	.float 0.486600
	.float -0.577034
	.float 0.430770
	.float -0.061693
	.float -0.371700
	.float 0.654013
	.float -0.639421
	.float 0.342694
	.float 0.060129
	.float -0.328069
	.float 0.298366
	.float 0.007991
	.float -0.389398
	.float 0.583612
	.float -0.434731
	.float 0.000926
	.float 0.471263
	.float -0.693540
	.float 0.512498
	.float -0.005912
	.float -0.559354
	.float 0.879521
	.float -0.783777
	.float 0.323941
	.float 0.263200
	.float -0.693710
	.float 0.792224
	.float -0.577686
	.float 0.235171
	.float 0.003154
	.float 0.005938
	.float -0.242433
	.float 0.548224
	.float -0.730400
	.float 0.678727
	.float -0.429268
	.float 0.138300
	.float 0.017338
	.float 0.045078
	.float -0.255872
	.float 0.431986
	.float -0.395836
	.float 0.100899
	.float 0.320001
	.float -0.623001
	.float 0.600398
	.float -0.213639
	.float -0.374657
	.float 0.891735
	.float -1.110949
	.float 0.974879
	.float -0.610591
	.float 0.234094
	.float -0.010962
	.float -0.033785
	.float -0.000230
	.float -0.007512
	.float 0.088920
	.float -0.158356
	.float 0.089015
	.float 0.166398
	.float -0.511672
	.float 0.759206
	.float -0.762720
	.float 0.526327
	.float -0.203068
	.float -0.016382
	.float 0.038064
	.float 0.076196
	.float -0.160846
	.float 0.064281
	.float 0.249751
	.float -0.675577
	.float 1.021055
	.float -1.109691
	.float 0.876592
	.float -0.410488
	.float -0.082184
	.float 0.378830
	.float -0.356878
	.float 0.059437
	.float 0.330480
	.float -0.594446
	.float 0.600630
	.float -0.370022
	.float 0.048323
	.float 0.195620
	.float -0.277436
	.float 0.238528
	.float -0.194977
	.float 0.233726
	.float -0.336903
	.float 0.394829
	.float -0.298574
	.float 0.038708
	.float 0.270084
	.float -0.458429
	.float 0.411811
	.float -0.139613
	.float -0.238350
	.float 0.564376
	.float -0.717464
	.float 0.649280
	.float -0.382063
	.float -0.008835
	.float 0.412929
	.float -0.708025
	.float 0.796709
	.float -0.648300
	.float 0.322183
	.float 0.047525
	.float -0.305266
	.float 0.341416
	.float -0.141230
	.float -0.208804
	.float 0.561094
	.float -0.776224
	.float 0.789297
	.float -0.641141
	.float 0.456506
	.float -0.376779
	.float 0.478318
	.float -0.719011
	.float 0.946922
	.float -0.975805
	.float 0.693990
	.float -0.144442
	.float -0.479730
	.float 0.934317
	.float -1.062379
	.float 0.881924
	.float -0.559866
	.float 0.288213
	.float -0.152559
	.float 0.089824
	.float 0.035344
	.float -0.299424
	.float 0.639910
	.float -0.888943
	.float 0.893008
	.float -0.624671
	.float 0.203741
	.float 0.181566
	.float -0.390453
	.float 0.402551
	.float -0.310356
	.float 0.251354
	.float -0.328379
	.float 0.558486
	.float -0.865367
	.float 1.113917
	.float -1.175211
	.float 0.997122
	.float -0.642592
	.float 0.264237
	.float -0.020594
	.float -0.015855
	.float -0.105112
	.float 0.258095
	.float -0.338128
	.float 0.336194
	.float -0.342504
	.float 0.480037
	.float -0.816234
	.float 1.307445
	.float -1.803231
	.float 2.104235
	.float -2.047633
	.float 1.588641
	.float -0.844650
	.float 0.072478
	.float 0.429894
	.float -0.464077
	.float 0.043470
	.float 0.597021
	.float -1.114689
	.float 1.239866
	.float -0.918724
	.float 0.332266
	.float 0.216549
	.float -0.475328
	.float 0.370994
	.float -0.026178
	.float -0.334027
	.float 0.519961
	.float -0.476067
	.float 0.287492
	.float -0.102889
	.float 0.033531
	.float -0.096400
	.float 0.228622
	.float -0.344244
	.float 0.381127
	.float -0.311835
	.float 0.136986
	.float 0.108539
	.float -0.338838
	.float 0.427742
	.float -0.274816
	.float -0.104024
	.float 0.539289
	.float -0.780981
	.float 0.653012
	.float -0.183235
	.float -0.393386
	.float 0.771891
	.float -0.764070
	.float 0.406697
	.float 0.079335
	.float -0.443455
	.float 0.561991
	.float -0.492266
	.float 0.397890
	.float -0.410417
	.float 0.531385
	.float -0.640685
	.float 0.595316
	.float -0.337932
	.float -0.063881
	.float 0.466932
	.float -0.742172
	.float 0.835413
	.float -0.764851
	.float 0.577686
	.float -0.315030
	.float 0.013044
	.float 0.276189
	.float -0.483593
	.float 0.560036
	.float -0.523805
	.float 0.466560
	.float -0.492433
	.float 0.624769
	.float -0.758216
	.float 0.711879
	.float -0.363116
	.float -0.231873
	.float 0.830281
	.float -1.131362
	.float 0.963329
	.float -0.400870
	.float -0.271562
	.float 0.729959
	.float -0.803013
	.float 0.562152
	.float -0.256326
	.float 0.140916
	.float -0.315474
	.float 0.672203
	.float -0.979433
	.float 1.036732
	.float -0.797344
	.float 0.383798
	.float 0.002316
	.float -0.207199
	.float 0.204405
	.float -0.085562
	.float -0.015240
	.float 0.002898
	.float 0.141370
	.float -0.373816
	.float 0.623884
	.float -0.820934
	.float 0.904978
	.float -0.836543
	.float 0.615723
	.float -0.298500
	.float -0.013353
	.float 0.215957
	.float -0.256416
	.float 0.157435
	.float 0.004591
	.float -0.148978
	.float 0.229732
	.float -0.241772
	.float 0.203872
	.float -0.143471
	.float 0.095540
	.float -0.104308
	.float 0.209402
	.float -0.415817
	.float 0.670248
	.float -0.870160
	.float 0.911663
	.float -0.752732
	.float 0.451383
	.float -0.146804
	.float -0.016561
	.float -0.016998
	.float 0.164655
	.float -0.244860
	.float 0.096085
	.float 0.298294
	.float -0.770254
	.float 1.053763
	.float -0.949637
	.float 0.458912
	.float 0.207033
	.float -0.746536
	.float 0.937265
	.float -0.746837
	.float 0.324504
	.float 0.104938
	.float -0.366607
	.float 0.404858
	.float -0.271055
	.float 0.061537
	.float 0.139189
	.float -0.277417
	.float 0.320251
	.float -0.248510
	.float 0.070514
	.float 0.158356
	.float -0.340593
	.float 0.377935
	.float -0.226949
	.float -0.070407
	.float 0.403597
	.float -0.648005
	.float 0.724472
	.float -0.631788
	.float 0.438498
	.float -0.241913
	.float 0.118792
	.float -0.095695
	.float 0.154186
	.float -0.261074
	.float 0.394823
	.float -0.543998
	.float 0.682316
	.float -0.751746
	.float 0.682808
	.float -0.446355
	.float 0.095467
	.float 0.245640
	.float -0.448859
	.float 0.460420
	.float -0.330632
	.float 0.171569
	.float -0.076035
	.float 0.061513
	.float -0.080153
	.float 0.079263
	.float -0.055294
	.float 0.053449
	.float -0.115299
	.float 0.224106
	.float -0.301454
	.float 0.264584
	.float -0.100674
	.float -0.104813
	.float 0.216555
	.float -0.145268
	.float -0.078456
	.float 0.311158
	.float -0.386531
	.float 0.227966
	.float 0.095721
	.float -0.411087
	.float 0.546615
	.float -0.429644
	.float 0.113042
	.float 0.270263
	.float -0.578405
	.float 0.709581
	.float -0.619470
	.float 0.327792
	.float 0.073869
	.float -0.432761
	.float 0.590932
	.float -0.476046
	.float 0.166989
	.float 0.132111
	.float -0.213913
	.float 0.010165
	.float 0.351704
	.float -0.627556
	.float 0.619377
	.float -0.307084
	.float -0.141282
	.float 0.480946
	.float -0.540863
	.float 0.315199
	.float 0.050128
	.float -0.350587
	.float 0.431184
	.float -0.253010
	.float -0.104528
	.float 0.494165
	.float -0.773661
	.float 0.865802
	.float -0.780138
	.float 0.591107
	.float -0.390200
	.float 0.242069
	.float -0.167240
	.float 0.152660
	.float -0.174102
	.float 0.211753
	.float -0.252424
	.float 0.283169
	.float -0.285820
	.float 0.238437
	.float -0.125588
	.float -0.046403
	.float 0.238851
	.float -0.388632
	.float 0.441300
	.float -0.394590
	.float 0.318511
	.float -0.322201
	.float 0.476839
	.float -0.747746
	.float 0.996317
	.float -1.064284
	.float 0.883146
	.float -0.524172
	.float 0.147249
	.float 0.110640
	.float -0.219603
	.float 0.252575
	.float -0.306628
	.float 0.419039
	.float -0.540076
	.float 0.571678
	.float -0.434934
	.float 0.120621
	.float 0.299406
	.float -0.697758
	.float 0.941095
	.float -0.947810
	.float 0.731651
	.float -0.405222
	.float 0.129359
	.float -0.027152
	.float 0.113144
	.float -0.288419
	.float 0.410950
	.float -0.393675
	.float 0.257891
	.float -0.102201
	.float 0.014204
	.float 0.001729
	.float -0.023275
	.float 0.141073
	.float -0.381935
	.float 0.684530
	.float -0.938636
	.float 1.049170
	.float -0.978252
	.float 0.749692
	.float -0.432660
	.float 0.122973
	.float 0.079805
	.float -0.111066
	.float -0.012360
	.float 0.175426
	.float -0.214817
	.float 0.024639
	.float 0.351353
	.float -0.722674
	.float 0.869868
	.float -0.701728
	.float 0.329801
	.float 0.008609
	.float -0.129704
	.float 0.046773
	.float 0.038836
	.float 0.101573
	.float -0.533596
	.float 1.086792
	.float -1.456591
	.float 1.406999
	.float -0.928896
	.float 0.248098
	.float 0.311757
	.float -0.510787
	.float 0.303039
	.float 0.177402
	.float -0.723023
	.float 1.172129
	.float -1.471016
	.float 1.655668
	.float -1.779796
	.float 1.843632
	.float -1.774267
	.float 1.476101
	.float -0.922792
	.float 0.225332
	.float 0.383944
	.float -0.660394
	.float 0.489163
	.float 0.033450
	.float -0.640828
	.float 1.040646
	.float -1.072951
	.float 0.782319
	.float -0.363960
	.float 0.028558
	.float 0.120458
	.float -0.121835
	.float 0.096768
	.float -0.150966
	.float 0.309066
	.float -0.514247
	.float 0.675106
	.float -0.719083
	.float 0.625207
	.float -0.431903
	.float 0.223712
	.float -0.095409
	.float 0.097543
	.float -0.190384
	.float 0.248649
	.float -0.135247
	.float -0.194519
	.float 0.637811
	.float -0.993915
	.float 1.094175
	.float -0.917141
	.float 0.598216
	.float -0.325437
	.float 0.203697
	.float -0.193654
	.float 0.168176
	.float -0.034547
	.float -0.179028
	.float 0.342140
	.float -0.331112
	.float 0.142359
	.float 0.081614
	.float -0.141648
	.float -0.072380
	.float 0.487414
	.float -0.881831
	.float 1.032461
	.float -0.867710
	.float 0.510128
	.float -0.174393
	.float 0.002447
	.float 0.031503
	.float -0.073553
	.float 0.248553
	.float -0.548549
	.float 0.841196
	.float -0.979889
	.float 0.913427
	.float -0.707447
	.float 0.476738
	.float -0.301328
	.float 0.194924
	.float -0.130281
	.float 0.073987
	.float 0.006268
	.float -0.148981
	.float 0.381789
	.float -0.673255
	.float 0.900638
	.float -0.892150
	.float 0.543751
	.float 0.068528
	.float -0.682888
	.float 0.986172
	.float -0.812199
	.float 0.263593
	.float 0.339294
	.float -0.658734
	.float 0.555217
	.float -0.170581
	.float -0.177850
	.float 0.216910
	.float 0.100356
	.float -0.571833
	.float 0.891247
	.float -0.856113
	.float 0.496299
	.float -0.041613
	.float -0.238953
	.float 0.209062
	.float 0.068702
	.float -0.405046
	.float 0.627290
	.float -0.684894
	.float 0.651006
	.float -0.639391
	.float 0.711724
	.float -0.840072
	.float 0.935211
	.float -0.907875
	.float 0.723792
	.float -0.430082
	.float 0.143795
	.float 0.000379
	.float 0.070959
	.float -0.306967
	.float 0.540606
	.float -0.586216
	.float 0.373572
	.float -0.018334
	.float -0.240103
	.float 0.203437
	.float 0.136689
	.float -0.583701
	.float 0.872881
	.float -0.858485
	.float 0.608540
	.float -0.338724
	.float 0.242425
	.float -0.349973
	.float 0.518172
	.float -0.545593
	.float 0.320198
	.float 0.104253
	.float -0.543131
	.float 0.791782
	.float -0.739940
	.float 0.429813
	.float -0.033771
	.float -0.235691
	.float 0.242571
	.float -0.011614
	.float -0.273720
	.float 0.373876
	.float -0.145810
	.float -0.351442
	.float 0.878681
	.float -1.163077
	.float 1.071756
	.float -0.687910
	.float 0.234605
	.float 0.091089
	.float -0.243594
	.float 0.322090
	.float -0.451624
	.float 0.660099
	.float -0.851493
	.float 0.888099
	.float -0.706005
	.float 0.371414
	.float -0.042044
	.float -0.130187
	.float 0.086408
	.float 0.111230
	.float -0.318248
	.float 0.386918
	.float -0.246399
	.float -0.054639
	.float 0.367644
	.float -0.522882
	.float 0.429545
	.float -0.138975
	.float -0.172865
	.float 0.300547
	.float -0.127919
	.float -0.301021
	.float 0.801666
	.float -1.145129
	.float 1.172367
	.float -0.863755
	.float 0.334924
	.float 0.225080
	.float -0.632786
	.float 0.772117
	.float -0.624873
	.float 0.270961
	.float 0.138955
	.float -0.435858
	.float 0.498927
	.float -0.310294
	.float -0.032180
	.float 0.358127
	.float -0.506507
	.float 0.404116
	.float -0.098665
	.float -0.270140
	.float 0.543253
	.float -0.617479
	.float 0.484889
	.float -0.221717
	.float -0.060958
	.float 0.275487
	.float -0.397493
	.float 0.470202
	.float -0.570775
	.float 0.751102
	.float -0.983525
	.float 1.150029
	.float -1.097576
	.float 0.739213
	.float -0.137185
	.float -0.499795
	.float 0.920613
	.float -0.976557
	.float 0.707855
	.float -0.308777
	.float -0.004555
	.float 0.128638
	.float -0.115173
	.float 0.099670
	.float -0.178022
	.float 0.327855
	.float -0.431828
	.float 0.380081
	.float -0.169570
	.float -0.078955
	.float 0.201853
	.float -0.111603
	.float -0.137312
	.float 0.387750
	.float -0.496123
	.float 0.435637
	.float -0.306076
	.float 0.243539
	.float -0.304729
	.float 0.421254
	.float -0.461451
	.float 0.345919
	.float -0.118089
	.float -0.091344
	.float 0.175332
	.float -0.140891
	.float 0.100308
	.float -0.170025
	.float 0.364359
	.float -0.575925
	.float 0.660284
	.float -0.553324
	.float 0.323050
	.float -0.113297
	.float 0.027172
	.float -0.045267
	.float 0.043337
	.float 0.105999
	.float -0.426046
	.float 0.802241
	.float -1.043495
	.float 0.995587
	.float -0.633967
	.float 0.083962
	.float 0.436874
	.float -0.718779
	.float 0.651933
	.float -0.270830
	.float -0.265792
	.float 0.747978
	.float -1.006573
	.float 0.980875
	.float -0.729523
	.float 0.383336
	.float -0.070290
	.float -0.143425
	.float 0.266439
	.float -0.349114
	.float 0.430517
	.float -0.499327
	.float 0.493429
	.float -0.342125
	.float 0.030046
	.float 0.356565
	.float -0.642073
	.float 0.643894
	.float -0.289850
	.float -0.303284
	.float 0.857493
	.float -1.074596
	.float 0.816312
	.float -0.205257
	.float -0.435682
	.float 0.782445
	.float -0.720594
	.float 0.417340
	.float -0.195028
	.float 0.291918
	.float -0.687579
	.float 1.127240
	.float -1.326359
	.float 1.192846
	.float -0.888367
	.float 0.680799
	.float -0.711420
	.float 0.869889
	.float -0.880556
	.float 0.529623
	.float 0.148935
	.float -0.872911
	.float 1.290713
	.float -1.200831
	.float 0.660654
	.float 0.067593
	.float -0.668030
	.float 0.912766
	.float -0.730042
	.float 0.202769
	.float 0.470992
	.float -1.038887
	.float 1.277325
	.float -1.084286
	.float 0.538520
	.float 0.123591
	.float -0.620394
	.float 0.770615
	.float -0.583209
	.float 0.231832
	.float 0.070019
	.float -0.208612
	.float 0.229547
	.float -0.279770
	.float 0.478183
	.float -0.810649
	.float 1.125792
	.float -1.233610
	.float 1.035769
	.float -0.596842
	.float 0.109826
	.float 0.217133
	.float -0.276621
	.float 0.109527
	.float 0.136433
	.float -0.300714
	.float 0.293787
	.float -0.125772
	.float -0.123726
	.float 0.363009
	.float -0.534425
	.float 0.628962
	.float -0.671294
	.float 0.691212
	.float -0.698047
	.float 0.673169
	.float -0.588345
	.float 0.443398
	.float -0.295227
	.float 0.242773
	.float -0.358583
	.float 0.607074
	.float -0.822052
	.float 0.787756
	.float -0.387541
	.float -0.285357
	.float 0.950737
	.float -1.299556
	.float 1.181631
	.float -0.688953
	.float 0.078858
	.float 0.397416
	.float -0.631955
	.float 0.674903
	.float -0.641459
	.float 0.601533
	.float -0.536276
	.float 0.377327
	.float -0.080446
	.float -0.327956
	.float 0.757623
	.float -1.099769
	.float 1.277754
	.float -1.277676
	.float 1.148342
	.float -0.971239
	.float 0.812205
	.float -0.679091
	.float 0.514632
	.float -0.237767
	.float -0.188251
	.float 0.709358
	.float -1.194673
	.float 1.505891
	.float -1.571825
	.float 1.415162
	.float -1.120409
	.float 0.779890
	.float -0.464110
	.float 0.226322
	.float -0.111320
	.float 0.139104
	.float -0.272997
	.float 0.414696
	.float -0.452966
	.float 0.339797
	.float -0.131250
	.float -0.048083
	.float 0.093943
	.float 0.005757
	.float -0.172310
	.float 0.303263
	.float -0.344354
	.float 0.308282
	.float -0.236033
	.float 0.148187
	.float -0.036067
	.float -0.103042
	.float 0.230480
	.float -0.277691
	.float 0.204288
	.float -0.050875
	.float -0.071486
	.float 0.060571
	.float 0.087594
	.float -0.255423
	.float 0.274304
	.float -0.041406
	.float -0.401451
	.float 0.881122
	.float -1.185535
	.float 1.172955
	.float -0.836573
	.float 0.299588
	.float 0.245966
	.float -0.623466
	.float 0.743076
	.float -0.630417
	.float 0.399618
	.float -0.185687
	.float 0.075236
	.float -0.075065
	.float 0.130334
	.float -0.169586
	.float 0.142059
	.float -0.029298
	.float -0.160829
	.float 0.401788
	.float -0.651271
	.float 0.856324
	.float -0.967716
	.float 0.959505
	.float -0.840948
	.float 0.650654
	.float -0.435366
	.float 0.227239
	.float -0.035937
	.float -0.137279
	.float 0.274394
	.float -0.326946
	.float 0.233156
	.float 0.037321
	.float -0.439574
	.float 0.845726
	.float -1.088336
	.float 1.036237
	.float -0.662454
	.float 0.067427
	.float 0.554349
	.float -0.990428
	.float 1.098043
	.float -0.865629
	.float 0.417850
	.float 0.045322
	.float -0.348822
	.float 0.426690
	.float -0.337484
	.float 0.202073
	.float -0.111186
	.float 0.072894
	.float -0.035519
	.float -0.042930
	.float 0.145829
	.float -0.212521
	.float 0.197552
	.float -0.114523
	.float 0.023381
	.float 0.022078
	.float -0.012270
	.float -0.029986
	.float 0.091094
	.float -0.187178
	.float 0.336671
	.float -0.514217
	.float 0.641662
	.float -0.640315
	.float 0.505580
	.float -0.333207
	.float 0.259597
	.float -0.353302
	.float 0.543345
	.float -0.651411
	.float 0.515365
	.float -0.116259
	.float -0.388856
	.float 0.760169
	.float -0.830412
	.float 0.610591
	.float -0.270801
	.float 0.015004
	.float 0.055895
	.float 0.002724
	.float -0.036616
	.float -0.090545
	.float 0.402545
	.float -0.791654
	.float 1.076772
	.float -1.100487
	.float 0.816368
	.float -0.324469
	.float -0.165107
	.float 0.428830
	.float -0.339911
	.float -0.069039
	.float 0.627275
	.float -1.115276
	.float 1.364143
	.float -1.308932
	.float 0.983245
	.float -0.484574
	.float -0.053286
	.float 0.476169
	.float -0.639129
	.float 0.466950
	.float -0.019373
	.float -0.499530
	.float 0.828633
	.float -0.802914
	.float 0.473695
	.float -0.096470
	.float -0.028170
	.float -0.236034
	.float 0.748747
	.float -1.166502
	.float 1.160529
	.float -0.632822
	.float -0.214584
	.float 0.996857
	.float -1.364044
	.float 1.178433
	.float -0.557765
	.float -0.211812
	.float 0.819548
	.float -1.052335
	.float 0.857797
	.float -0.346509
	.float -0.256951
	.float 0.704011
	.float -0.828403
	.float 0.622307
	.float -0.234577
	.float -0.117553
	.float 0.273998
	.float -0.214295
	.float 0.044184
	.float 0.098738
	.float -0.147618
	.float 0.143079
	.float -0.182284
	.float 0.325729
	.float -0.536514
	.float 0.699504
	.float -0.706693
	.float 0.543211
	.float -0.306070
	.float 0.136300
	.float -0.111634
	.float 0.181980
	.float -0.203279
	.float 0.053290
	.float 0.254454
	.float -0.549408
	.float 0.604445
	.float -0.297296
	.float -0.279335
	.float 0.844164
	.float -1.085618
	.float 0.856026
	.float -0.273798
	.float -0.339532
	.float 0.654416
	.float -0.537835
	.float 0.133747
	.float 0.234713
	.float -0.275700
	.float -0.088588
	.float 0.685791
	.float -1.217468
	.float 1.448088
	.float -1.329024
	.float 0.988082
	.float -0.617064
	.float 0.353111
	.float -0.231711
	.float 0.218636
	.float -0.268301
	.float 0.353674
	.float -0.455523
	.float 0.541077
	.float -0.565890
	.float 0.503139
	.float -0.373202
	.float 0.243597
	.float -0.191662
	.float 0.251374
	.float -0.380040
	.float 0.471999
	.float -0.420711
	.float 0.196846
	.float 0.110468
	.float -0.330328
	.float 0.316320
	.float -0.056855
	.float -0.295163
	.float 0.509958
	.float -0.433876
	.float 0.097254
	.float 0.307242
	.float -0.561884
	.float 0.571061
	.float -0.405886
	.float 0.220426
	.float -0.119334
	.float 0.090737
	.float -0.053093
	.float -0.039303
	.float 0.137362
	.float -0.142389
	.float 0.013152
	.float 0.168763
	.float -0.246027
	.float 0.116286
	.float 0.162717
	.float -0.390334
	.float 0.361909
	.float -0.026628
	.float -0.460268
	.float 0.835625
	.float -0.904382
	.float 0.662874
	.float -0.283597
	.float -0.016804
	.float 0.121241
	.float -0.066615
	.float -0.015243
	.float 0.010810
	.float 0.096142
	.float -0.230761
	.float 0.302550
	.float -0.286284
	.float 0.246477
	.float -0.287633
	.float 0.469117
	.float -0.751394
	.float 1.016417
	.float -1.146902
	.float 1.101271
	.float -0.926765
	.float 0.707483
	.float -0.498826
	.float 0.304824
	.float -0.108550
	.float -0.084854
	.float 0.240111
	.float -0.325762
	.float 0.354759
	.float -0.388823
	.float 0.496844
	.float -0.696279
	.float 0.921844
	.float -1.048428
	.float 0.961854
	.float -0.639030
	.float 0.185422
	.float 0.204597
	.float -0.353379
	.float 0.210089
	.float 0.111083
	.float -0.398417
	.float 0.474762
	.float -0.302658
	.float -0.011026
	.float 0.309239
	.float -0.502394
	.float 0.619246
	.float -0.754756
	.float 0.958113
	.float -1.151263
	.float 1.149063
	.float -0.779807
	.float 0.028717
	.float 0.900817
	.float -1.666389
	.float 1.969604
	.float -1.727536
	.float 1.117256
	.float -0.462906
	.float 0.044948
	.float 0.038073
	.float 0.126008
	.float -0.369364
	.float 0.562432
	.float -0.657512
	.float 0.650943
	.float -0.529555
	.float 0.269490
	.float 0.108539
	.float -0.490770
	.float 0.696863
	.float -0.586160
	.float 0.169476
	.float 0.368103
	.float -0.767459
	.float 0.856026
	.float -0.653670
	.float 0.346181
	.float -0.146923
	.float 0.149930
	.float -0.279590
	.float 0.366619
	.float -0.287494
	.float 0.062425
	.float 0.157382
	.float -0.200850
	.float 0.005574
	.float 0.327580
	.float -0.593402
	.float 0.616474
	.float -0.371346
	.float 0.008514
	.float 0.231986
	.float -0.165213
	.float -0.226076
	.float 0.778042
	.float -1.236325
	.float 1.393596
	.float -1.193484
	.float 0.745937
	.float -0.253148
	.float -0.104683
	.float 0.257534
	.float -0.262697
	.float 0.248397
	.float -0.322210
	.float 0.498406
	.float -0.685898
	.float 0.743496
	.float -0.571335
	.float 0.183458
	.float 0.285568
	.float -0.650234
	.float 0.782814
	.float -0.695269
	.float 0.538410
	.float -0.509803
	.float 0.719434
	.float -1.098687
	.float 1.421457
	.float -1.439760
	.float 1.054502
	.float -0.402211
	.float -0.215958
	.float 0.526628
	.float -0.464956
	.float 0.209579
	.float -0.041842
	.float 0.134642
	.float -0.430657
	.float 0.699582
	.float -0.724942
	.float 0.473802
	.float -0.122022
	.float -0.078702
	.float -0.013001
	.float 0.326946
	.float -0.634667
	.float 0.711810
	.float -0.488877
	.float 0.086700
	.float 0.278542
	.float -0.443550
	.float 0.392465
	.float -0.240652
	.float 0.135055
	.float -0.154334
	.float 0.279990
	.float -0.445869
	.float 0.610629
	.float -0.785249
	.float 0.994287
	.float -1.213689
	.float 1.353356
	.float -1.312286
	.float 1.064936
	.float -0.700562
	.float 0.372979
	.float -0.197160
	.float 0.177555
	.float -0.226672
	.float 0.252741
	.float -0.235918
	.float 0.228173
	.float -0.283885
	.float 0.391255
	.float -0.470872
	.float 0.444927
	.float -0.314183
	.float 0.170791
	.float -0.127954
	.float 0.220552
	.float -0.360538
	.float 0.392099
	.float -0.212093
	.float -0.135411
	.float 0.468089
	.float -0.579326
	.float 0.379220
	.float 0.037977
	.float -0.447309
	.float 0.629079
	.float -0.494192
	.float 0.120235
	.float 0.314058
	.float -0.640989
	.float 0.786537
	.float -0.778320
	.float 0.689663
	.float -0.569550
	.float 0.409373
	.float -0.166441
	.float -0.175851
	.float 0.555494
	.float -0.829906
	.float 0.838445
	.float -0.501839
	.float -0.102230
	.float 0.745722
	.float -1.153769
	.float 1.153960
	.float -0.778528
	.float 0.246889
	.float 0.168104
	.float -0.304151
	.float 0.192580
	.float -0.004410
	.float -0.096767
	.float 0.082816
	.float -0.072778
	.float 0.221261
	.float -0.573001
	.float 0.999593
	.float -1.270464
	.float 1.206395
	.float -0.803227
	.float 0.238894
	.float 0.234703
	.float -0.435843
	.float 0.339961
	.float -0.067056
	.float -0.205901
	.float 0.345257
	.float -0.317360
	.float 0.180407
	.float -0.027695
	.float -0.077484
	.float 0.135143
	.float -0.192635
	.float 0.295023
	.float -0.440659
	.float 0.574402
	.float -0.621523
	.float 0.536526
	.float -0.333798
	.float 0.084114
	.float 0.118137
	.float -0.200133
	.float 0.150587
	.float -0.035446
	.float -0.026518
	.float -0.071023
	.float 0.345967
	.float -0.692965
	.float 0.929423
	.float -0.908444
	.float 0.629120
	.float -0.262413
	.float 0.060483
	.float -0.197977
	.float 0.646309
	.float -1.167360
	.float 1.439948
	.float -1.247261
	.float 0.611127
	.float 0.212764
	.float -0.879313
	.float 1.149391
	.float -1.011008
	.float 0.650103
	.float -0.298458
	.float 0.074633
	.float 0.064351
	.float -0.231858
	.float 0.465132
	.float -0.653808
	.float 0.612600
	.float -0.246489
	.float -0.326382
	.float 0.804920
	.float -0.885718
	.float 0.473859
	.float 0.228636
	.float -0.828922
	.float 0.982780
	.float -0.611145
	.float -0.050880
	.float 0.605771
	.float -0.744351
	.float 0.429185
	.float 0.104521
	.float -0.517642
	.float 0.581063
	.float -0.295097
	.float -0.144634
	.float 0.485885
	.float -0.560701
	.float 0.350190
	.float 0.039881
	.float -0.454903
	.float 0.768636
	.float -0.926708
	.float 0.944180
	.float -0.867173
	.float 0.727598
	.float -0.525263
	.float 0.252549
	.float 0.059224
	.float -0.316818
	.float 0.397323
	.float -0.224087
	.float -0.164266
	.float 0.605032
	.float -0.879024
	.float 0.822335
	.float -0.421149
	.float -0.166050
	.float 0.677115
	.float -0.875993
	.float 0.675765
	.float -0.184871
	.float -0.353725
	.float 0.695925
	.float -0.721786
	.float 0.477233
	.float -0.116310
	.float -0.204443
	.float 0.401830
	.float -0.469236
	.float 0.429134
	.float -0.294363
	.float 0.078456
	.float 0.162222
	.float -0.311209
	.float 0.241199
	.float 0.090569
	.float -0.574435
	.float 0.975820
	.float -1.060487
	.float 0.741609
	.float -0.147167
	.float -0.444921
	.float 0.766693
	.float -0.713423
	.float 0.393979
	.float -0.051120
	.float -0.092381
	.float -0.036364
	.float 0.331708
	.float -0.591581
	.float 0.651343
	.float -0.482478
	.float 0.196855
	.float 0.037387
	.float -0.104207
	.float -0.002366
	.float 0.201090
	.float -0.394847
	.float 0.526962
	.float -0.584223
	.float 0.563279
	.float -0.449183
	.float 0.234441
	.float 0.042771
	.float -0.289870
	.float 0.403710
	.float -0.337270
	.float 0.132089
	.float 0.114122
	.float -0.318401
	.float 0.462470
	.float -0.581692
	.float 0.707605
	.float -0.818693
	.float 0.845124
	.float -0.725646
	.float 0.467528
	.float -0.156537
	.float -0.095456
	.float 0.223887
	.float -0.244917
	.float 0.220976
	.float -0.190654
	.float 0.128238
	.float 0.026304
	.float -0.289620
	.float 0.579606
	.float -0.739299
	.float 0.633329
	.float -0.249187
	.float -0.273641
	.float 0.712892
	.float -0.888722
	.float 0.764717
	.float -0.462748
	.float 0.186312
	.float -0.102299
	.float 0.250496
	.float -0.527409
	.float 0.745594
	.float -0.731482
	.float 0.412276
	.float 0.145742
	.float -0.760911
	.float 1.210672
	.float -1.324976
	.float 1.056973
	.float -0.497276
	.float -0.173746
	.float 0.767882
	.float -1.159936
	.float 1.313895
	.float -1.263170
	.float 1.069538
	.float -0.790897
	.float 0.472312
	.float -0.155478
	.float -0.108381
	.float 0.256454
	.float -0.229424
	.float -0.000014
	.float 0.399791
	.float -0.871575
	.float 1.277021
	.float -1.490535
	.float 1.451825
	.float -1.187857
	.float 0.791478
	.float -0.372654
	.float 0.013365
	.float 0.250462
	.float -0.420184
	.float 0.515192
	.float -0.557738
	.float 0.565219
	.float -0.547339
	.float 0.508611
	.float -0.458262
	.float 0.421036
	.float -0.432952
	.float 0.513776
	.float -0.631925
	.float 0.697400
	.float -0.604880
	.float 0.308720
	.float 0.123076
	.float -0.522831
	.float 0.705924
	.float -0.572381
	.float 0.163480
	.float 0.361009
	.float -0.808169
	.float 1.048741
	.float -1.070885
	.float 0.964816
	.float -0.852557
	.float 0.808014
	.float -0.817766
	.float 0.806354
	.float -0.705063
	.float 0.511636
	.float -0.294329
	.float 0.137457
	.float -0.072817
	.float 0.053779
	.float 0.005772
	.float -0.159237
	.float 0.381431
	.float -0.585784
	.float 0.688023
	.float -0.662019
	.float 0.543858
	.float -0.389851
	.float 0.235696
	.float -0.098021
	.float 0.009503
	.float -0.036456
	.float 0.237854
	.float -0.587754
	.float 0.937077
	.float -1.076325
	.float 0.877560
	.float -0.411156
	.float -0.069112
	.float 0.285878
	.float -0.137252
	.float -0.214631
	.float 0.443416
	.float -0.285372
	.float -0.267228
	.float 0.948433
	.float -1.393140
	.float 1.378762
	.float -0.959481
	.float 0.399234
	.float 0.036147
	.float -0.260619
	.float 0.383178
	.float -0.556924
	.float 0.802041
	.float -0.962912
	.float 0.841339
	.float -0.391344
	.float -0.197569
	.float 0.610376
	.float -0.628235
	.float 0.286231
	.float 0.156256
	.float -0.403702
	.float 0.322189
	.float -0.001361
	.float -0.348608
	.float 0.567904
	.float -0.650657
	.float 0.713214
	.float -0.870154
	.float 1.125091
	.float -1.359958
	.float 1.422596
	.float -1.238817
	.float 0.865507
	.float -0.454411
	.float 0.162436
	.float -0.072093
	.float 0.164276
	.float -0.344429
	.float 0.497005
	.float -0.540863
	.float 0.465341
	.float -0.331991
	.float 0.236861
	.float -0.249038
	.float 0.362699
	.float -0.498767
	.float 0.559210
	.float -0.496767
	.float 0.348572
	.float -0.209160
	.float 0.164798
	.float -0.237968
	.float 0.380287
	.float -0.513824
	.float 0.587152
	.float -0.606624
	.float 0.624238
	.float -0.694464
	.float 0.829673
	.float -0.980780
	.float 1.053733
	.float -0.954322
	.float 0.642640
	.float -0.172412
	.float -0.308711
	.float 0.610510
	.float -0.592028
	.float 0.252470
	.float 0.234728
	.float -0.582944
	.float 0.535599
	.float -0.021142
	.float -0.775870
	.float 1.488157
	.float -1.760581
	.float 1.458594
	.float -0.759143
	.float 0.055695
	.float 0.273842
	.float -0.095137
	.float -0.402691
	.float 0.826547
	.float -0.823736
	.float 0.301224
	.float 0.511106
	.float -1.187305
	.float 1.345729
	.float -0.865418
	.float -0.041775
	.float 0.941819
	.float -1.410689
	.float 1.260571
	.float -0.636175
	.float -0.072652
	.float 0.454062
	.float -0.308955
	.float -0.237317
	.float 0.813784
	.float -1.030914
	.float 0.721297
	.float -0.044525
	.float -0.613380
	.float 0.883208
	.float -0.639987
	.float 0.066391
	.float 0.481951
	.float -0.706958
	.float 0.535820
	.float -0.126068
	.float -0.269662
	.float 0.467260
	.float -0.434922
	.float 0.264886
	.float -0.081765
	.float -0.036140
	.float 0.077380
	.float -0.066639
	.float 0.022686
	.float 0.058823
	.float -0.189438
	.float 0.358506
	.float -0.518780
	.float 0.602609
	.float -0.560784
	.float 0.397577
	.float -0.175803
	.float -0.015220
	.float 0.110838
	.float -0.107388
	.float 0.058657
	.float -0.033665
	.float 0.065365
	.float -0.127877
	.float 0.158544
	.float -0.108398
	.float -0.017504
	.float 0.159870
	.float -0.244414
	.float 0.231317
	.float -0.139978
	.float 0.033500
	.float 0.024540
	.float -0.011250
	.float -0.042859
	.float 0.076231
	.float -0.038967
	.float -0.071337
	.float 0.202718
	.float -0.275299
	.float 0.226681
	.float -0.052398
	.float -0.180039
	.float 0.353370
	.float -0.355239
	.float 0.144752
	.float 0.203883
	.float -0.516581
	.float 0.603649
	.float -0.376314
	.float -0.078317
	.float 0.526592
	.float -0.718710
	.float 0.541360
	.float -0.088493
	.float -0.400453
	.float 0.691302
	.float -0.689642
	.float 0.471042
	.float -0.200795
	.float 0.014409
	.float 0.052660
	.float -0.046657
	.float 0.020934
	.float 0.025923
	.float -0.149129
	.float 0.398459
	.float -0.750446
	.float 1.088497
	.float -1.252870
	.float 1.132662
	.float -0.739329
	.float 0.209032
	.float 0.273971
	.float -0.583972
	.float 0.715298
	.float -0.752434
	.float 0.772880
	.float -0.764392
	.float 0.631868
	.float -0.295066
	.float -0.203746
	.float 0.681475
	.float -0.915940
	.float 0.798140
	.float -0.416681
	.float 0.003714
	.float 0.222372
	.float -0.202340
	.float 0.063039
	.float -0.009302
	.float 0.164419
	.float -0.479048
	.float 0.774305
	.float -0.882347
	.float 0.774263
	.float -0.576882
	.float 0.466637
	.float -0.525841
	.float 0.675726
	.float -0.740369
	.float 0.592672
	.float -0.267939
	.float -0.045462
	.float 0.136077
	.float 0.074513
	.float -0.465263
	.float 0.790027
	.float -0.841026
	.float 0.584181
	.float -0.170208
	.float -0.181835
	.float 0.336876
	.float -0.317936
	.float 0.253169
	.float -0.248532
	.float 0.293617
	.float -0.274591
	.float 0.079739
	.float 0.289476
	.float -0.689773
	.float 0.914506
	.float -0.827232
	.float 0.460444
	.float -0.011085
	.float -0.271255
	.float 0.237615
	.float 0.062566
	.float -0.406435
	.float 0.535248
	.float -0.317450
	.float -0.168054
	.float 0.679824
	.float -0.956879
	.float 0.863194
	.float -0.450584
	.float -0.083497
	.float 0.505303
	.float -0.656851
	.float 0.518360
	.float -0.200403
	.float -0.122621
	.float 0.302366
	.float -0.284673
	.float 0.123525
	.float 0.062610
	.float -0.161794
	.float 0.124274
	.float 0.025352
	.float -0.215480
	.float 0.367426
	.float -0.422696
	.float 0.352256
	.float -0.159972
	.float -0.111802
	.float 0.383169
	.float -0.561359
	.float 0.589105
	.float -0.487158
	.float 0.350360
	.float -0.286917
	.float 0.338596
	.float -0.443720
	.float 0.476464
	.float -0.335979
	.float 0.019295
	.float 0.374663
	.float -0.707772
	.float 0.882100
	.float -0.881608
	.float 0.757003
	.float -0.577311
	.float 0.389944
	.float -0.214617
	.float 0.065433
	.float 0.027662
	.float -0.023220
	.float -0.100146
	.float 0.310252
	.float -0.516700
	.float 0.607366
	.float -0.507955
	.float 0.228002
	.float 0.135430
	.float -0.440328
	.float 0.565785
	.float -0.468488
	.float 0.203575
	.float 0.100292
	.float -0.302073
	.float 0.320445
	.float -0.180238
	.float 0.002541
	.float 0.065645
	.float 0.053970
	.float -0.313861
	.float 0.566563
	.float -0.663816
	.float 0.562093
	.float -0.356503
	.float 0.215428
	.float -0.261917
	.float 0.488225
	.float -0.763945
	.float 0.926956
	.float -0.887688
	.float 0.672415
	.float -0.382421
	.float 0.109117
	.float 0.125333
	.float -0.358693
	.float 0.624641
	.float -0.893744
	.float 1.075180
	.float -1.084080
	.float 0.921472
	.float -0.696458
	.float 0.563163
	.float -0.614576
	.float 0.815233
	.float -1.026816
	.float 1.105411
	.float -0.992582
	.float 0.732826
	.float -0.417707
	.float 0.118784
	.float 0.131692
	.float -0.311632
	.float 0.382990
	.float -0.311536
	.float 0.116659
	.float 0.107049
	.float -0.234410
	.float 0.192536
	.float -0.012026
	.float -0.199396
	.float 0.338221
	.float -0.373125
	.float 0.348098
	.float -0.329002
	.float 0.346807
	.float -0.383342
	.float 0.400858
	.float -0.379113
	.float 0.323867
	.float -0.243830
	.float 0.125274
	.float 0.062296
	.float -0.323947
	.float 0.593006
	.float -0.728844
	.float 0.582914
	.float -0.104707
	.float -0.584518
	.float 1.216931
	.float -1.507548
	.float 1.315490
	.float -0.731365
	.float 0.029987
	.float 0.481632
	.float -0.621323
	.float 0.399278
	.float 0.028089
	.float -0.466405
	.float 0.775882
	.float -0.902310
	.float 0.853997
	.float -0.663831
	.float 0.371369
	.float -0.031344
	.float -0.271378
	.float 0.429438
	.float -0.356342
	.float 0.047530
	.float 0.385699
	.float -0.747937
	.float 0.853937
	.float -0.630304
	.float 0.154172
	.float 0.398995
	.float -0.859478
	.float 1.142235
	.float -1.252056
	.float 1.231640
	.float -1.113014
	.float 0.917034
	.float -0.689135
	.float 0.518250
	.float -0.498480
	.float 0.649730
	.float -0.862825
	.float 0.930356
	.float -0.665342
	.float 0.036017
	.float 0.782427
	.float -1.491015
	.float 1.840833
	.float -1.780168
	.float 1.468972
	.float -1.149483
	.float 0.971350
	.float -0.902516
	.float 0.787118
	.float -0.494746
	.float 0.039634
	.float 0.417364
	.float -0.672063
	.float 0.599945
	.float -0.217063
	.float -0.339335
	.float 0.873477
	.float -1.195418
	.float 1.173971
	.float -0.781720
	.float 0.121391
	.float 0.595188
	.float -1.127783
	.float 1.314488
	.float -1.138241
	.float 0.709301
	.float -0.183195
	.float -0.318690
	.float 0.730242
	.float -1.008540
	.float 1.101328
	.float -0.960438
	.float 0.594195
	.float -0.106070
	.float -0.328144
	.float 0.543238
	.float -0.476201
	.float 0.204644
	.float 0.095345
	.float -0.249215
	.float 0.183929
	.float 0.030606
	.float -0.225977
	.float 0.244296
	.float -0.048531
	.float -0.239236
	.float 0.407356
	.float -0.296653
	.float -0.078850
	.float 0.524366
	.float -0.787216
	.float 0.729044
	.float -0.420464
	.float 0.083475
	.float 0.076973
	.float -0.021649
	.float -0.110115
	.float 0.129885
	.float 0.036867
	.float -0.287525
	.float 0.426589
	.float -0.323771
	.float 0.017513
	.float 0.312782
	.float -0.474368
	.float 0.385431
	.float -0.108834
	.float -0.212741
	.float 0.457314
	.float -0.584643
	.float 0.627001
	.float -0.633764
	.float 0.619726
	.float -0.552945
	.float 0.384373
	.float -0.095525
	.float -0.267369
	.float 0.594329
	.float -0.752670
	.float 0.653349
	.float -0.310565
	.float -0.143595
	.float 0.512131
	.float -0.635859
	.float 0.487497
	.float -0.190054
	.float -0.063539
	.float 0.141687
	.float -0.062994
	.float -0.024921
	.float -0.037312
	.float 0.298223
	.float -0.662955
	.float 0.973060
	.float -1.128268
	.float 1.147835
	.float -1.124617
	.float 1.120492
	.float -1.102160
	.float 0.977752
	.float -0.701736
	.float 0.351901
	.float -0.104315
	.float 0.118970
	.float -0.423522
	.float 0.882624
	.float -1.271131
	.float 1.394421
	.float -1.176215
	.float 0.672444
	.float -0.026327
	.float -0.592005
	.float 1.030974
	.float -1.187174
	.float 1.030664
	.float -0.623976
	.float 0.114023
	.float 0.319456
	.float -0.543095
	.float 0.529525
	.float -0.353910
	.float 0.130197
	.float 0.060945
	.float -0.194632
	.float 0.264887
	.float -0.237101
	.float 0.048667
	.float 0.332853
	.float -0.847794
	.float 1.344263
	.float -1.653698
	.float 1.687765
	.float -1.482268
	.float 1.158791
	.float -0.841306
	.float 0.593724
	.float -0.415319
	.float 0.278325
	.float -0.164444
	.float 0.072348
	.float -0.003857
	.float -0.046195
	.float 0.084034
	.float -0.106436
	.float 0.103999
	.float -0.079248
	.float 0.059754
	.float -0.085563
	.float 0.174413
	.float -0.293826
	.float 0.369602
	.float -0.332114
	.float 0.168336
	.float 0.060183
	.float -0.248582
	.float 0.307763
	.float -0.212019
	.float 0.008249
	.float 0.213255
	.float -0.364732
	.float 0.400015
	.float -0.330409
	.float 0.212573
	.float -0.113070
	.float 0.067331
	.float -0.057774
	.float 0.029587
	.float 0.063400
	.float -0.215257
	.float 0.362130
	.float -0.421280
	.float 0.346137
	.float -0.155559
	.float -0.082576
	.float 0.297092
	.float -0.452841
	.float 0.558281
	.float -0.642929
	.float 0.725291
	.float -0.793595
	.float 0.810282
	.float -0.737285
	.float 0.568569
	.float -0.348450
	.float 0.157277
	.float -0.063116
	.float 0.065333
	.float -0.073890
	.float -0.046167
	.float 0.379566
	.float -0.875644
	.float 1.341232
	.float -1.533204
	.float 1.301937
	.float -0.694241
	.float -0.055699
	.float 0.646860
	.float -0.871638
	.float 0.720189
	.float -0.370317
	.float 0.072975
	.float -0.003451
	.float 0.164834
	.float -0.399162
	.float 0.497482
	.float -0.339601
	.float -0.026302
	.float 0.417054
	.float -0.637844
	.float 0.611229
	.float -0.422705
	.float 0.253759
	.float -0.251362
	.float 0.425489
	.float -0.643248
	.float 0.720463
	.float -0.547414
	.float 0.165734
	.float 0.252271
	.float -0.508277
	.float 0.500683
	.float -0.288458
	.float 0.054022
	.float 0.014407
	.float 0.152100
	.float -0.453308
	.float 0.682179
	.float -0.661357
	.float 0.362371
	.float 0.074482
	.float -0.431760
	.float 0.551157
	.float -0.419421
	.float 0.153131
	.float 0.091587
	.float -0.209887
	.float 0.180091
	.float -0.034153
	.float -0.187480
	.float 0.450709
	.float -0.705757
	.float 0.864789
	.float -0.820821
	.float 0.513496
	.float 0.001049
	.float -0.538139
	.float 0.859677
	.float -0.804086
	.float 0.392385
	.float 0.161727
	.float -0.554153
	.float 0.552579
	.float -0.129442
	.float -0.508420
	.float 1.014495
	.float -1.077463
	.float 0.589707
	.float 0.279192
	.float -1.148840
	.float 1.607397
	.float -1.416089
	.float 0.633132
	.float 0.408417
	.float -1.258434
	.float 1.563569
	.float -1.228260
	.float 0.442009
	.float 0.437130
	.float -1.074405
	.float 1.314375
	.float -1.214294
	.float 0.949264
	.float -0.668015
	.float 0.405847
	.float -0.108823
	.float -0.266110
	.float 0.666111
	.float -0.943220
	.float 0.939822
	.float -0.595209
	.float 0.000608
	.float 0.629025
	.float -1.048156
	.float 1.090306
	.float -0.744262
	.float 0.162182
	.float 0.407126
	.float -0.732119
	.float 0.703900
	.float -0.376827
	.float -0.075707
	.float 0.458626
	.float -0.644568
	.float 0.608054
	.float -0.401785
	.float 0.108753
	.float 0.193205
	.float -0.442859
	.float 0.596374
	.float -0.632846
	.float 0.564301
	.float -0.436019
	.float 0.307105
	.float -0.219382
	.float 0.176429
	.float -0.149117
	.float 0.102823
	.float -0.023396
	.float -0.079744
	.float 0.192081
	.float -0.311817
	.float 0.444886
	.float -0.580294
	.float 0.673806
	.float -0.665235
	.float 0.522631
	.float -0.274762
	.float -0.002267
	.float 0.238094
	.float -0.413328
	.float 0.552448
	.float -0.668388
	.float 0.713679
	.float -0.595149
	.float 0.254312
	.float 0.249442
	.float -0.730829
	.float 0.971025
	.float -0.854411
	.float 0.452334
	.float 0.010764
	.float -0.290229
	.float 0.264890
	.float 0.001772
	.float -0.316898
	.float 0.485730
	.float -0.426270
	.float 0.204499
	.float 0.020436
	.float -0.097491
	.float -0.030766
	.float 0.301656
	.float -0.569413
	.float 0.679699
	.float -0.543262
	.float 0.179467
	.float 0.285062
	.float -0.663363
	.float 0.787631
	.float -0.592058
	.float 0.157200
	.float 0.318767
	.float -0.619738
	.float 0.631880
	.float -0.410339
	.float 0.145370
	.float -0.044599
	.float 0.204128
	.float -0.549071
	.float 0.879638
	.float -0.992988
	.float 0.806220
	.float -0.405189
	.float -0.010333
	.float 0.250560
	.float -0.247578
	.float 0.080670
	.float 0.097287
	.float -0.172923
	.float 0.137877
	.float -0.064027
	.float 0.022516
	.float -0.023148
	.float 0.022285
	.float 0.020783
	.float -0.100900
	.float 0.177502
	.float -0.220208
	.float 0.236081
	.float -0.247462
	.float 0.246089
	.float -0.179289
	.float -0.003613
	.float 0.279765
	.float -0.528374
	.float 0.595092
	.float -0.408208
	.float 0.052928
	.float 0.268211
	.float -0.371170
	.float 0.221448
	.float 0.043105
	.float -0.217024
	.float 0.177734
	.float 0.032735
	.float -0.250745
	.float 0.317518
	.float -0.191543
	.float -0.027983
	.float 0.172206
	.float -0.112843
	.float -0.157020
	.float 0.513788
	.float -0.767369
	.float 0.764866
	.float -0.480425
	.float 0.038073
	.float 0.353242
	.float -0.521052
	.float 0.431718
	.float -0.203857
	.float 0.021297
	.float -0.007412
	.float 0.150210
	.float -0.327348
	.float 0.403570
	.float -0.323691
	.float 0.137916
	.float 0.045878
	.float -0.137366
	.float 0.114157
	.float -0.025204
	.float -0.040988
	.float 0.000811
	.float 0.183537
	.float -0.475906
	.float 0.764144
	.float -0.898078
	.float 0.763560
	.float -0.357844
	.float -0.185755
	.float 0.653894
	.float -0.865635
	.float 0.771819
	.float -0.474348
	.float 0.153952
	.float 0.040400
	.float -0.064924
	.float -0.021671
	.float 0.115485
	.float -0.126077
	.float 0.003997
	.float 0.254475
	.float -0.600359
	.float 0.923129
	.float -1.071800
	.float 0.927674
	.float -0.497479
	.float -0.049618
	.float 0.457183
	.float -0.538419
	.float 0.305286
	.float 0.035092
	.float -0.223517
	.float 0.127087
	.float 0.179970
	.float -0.485885
	.float 0.596526
	.float -0.455043
	.float 0.150646
	.float 0.164210
	.float -0.369861
	.float 0.424913
	.float -0.355159
	.float 0.219392
	.float -0.082032
	.float -0.003555
	.float 0.011186
	.float 0.042432
	.float -0.096125
	.float 0.070114
	.float 0.085017
	.float -0.341747
	.float 0.584321
	.float -0.652112
	.float 0.425596
	.float 0.089691
	.float -0.736393
	.float 1.262860
	.float -1.440747
	.float 1.177565
	.float -0.561961
	.float -0.177329
	.float 0.769992
	.float -1.011586
	.float 0.841318
	.float -0.368708
	.float -0.163176
	.float 0.477695
	.float -0.397657
	.float -0.055622
	.float 0.666597
	.float -1.148327
	.float 1.313433
	.float -1.178117
	.float 0.924112
	.float -0.747421
	.float 0.707736
	.float -0.690157
	.float 0.503154
	.float -0.035799
	.float -0.640655
	.float 1.295365
	.float -1.665498
	.float 1.605415
	.float -1.166773
	.float 0.565687
	.float -0.059026
	.float -0.195864
	.float 0.212568
	.float -0.134413
	.float 0.110240
	.float -0.177406
	.float 0.239670
	.float -0.157100
	.float -0.123400
	.float 0.501422
	.float -0.773703
	.float 0.762762
	.float -0.426138
	.float -0.127486
	.float 0.712711
	.float -1.166308
	.float 1.403348
	.float -1.413216
	.float 1.227366
	.float -0.898489
	.float 0.498984
	.float -0.115241
	.float -0.182090
	.float 0.377020
	.float -0.513925
	.float 0.645498
	.float -0.753808
	.float 0.717807
	.float -0.380856
	.float -0.310392
	.float 1.200485
	.float -1.957116
	.float 2.249127
	.float -1.960484
	.float 1.283387
	.float -0.608281
	.float 0.274262
	.float -0.350381
	.float 0.604016
	.float -0.681714
	.float 0.374776
	.float 0.220982
	.float -0.766615
	.float 0.918917
	.float -0.575490
	.float -0.047906
	.float 0.559476
	.float -0.649948
	.float 0.288001
	.float 0.275193
	.float -0.684190
	.float 0.710791
	.float -0.382543
	.float -0.069023
	.float 0.391064
	.float -0.487003
	.float 0.463430
	.float -0.519585
	.float 0.768514
	.float -1.127002
	.float 1.356808
	.float -1.226886
	.float 0.680414
	.float 0.106787
	.float -0.811284
	.float 1.133419
	.float -0.954206
	.float 0.395046
	.float 0.247255
	.float -0.656347
	.float 0.665115
	.float -0.346724
	.float -0.030474
	.float 0.169051
	.float 0.065309
	.float -0.549595
	.float 0.977531
	.float -1.060326
	.float 0.720299
	.float -0.142517
	.float -0.353960
	.float 0.535134
	.float -0.406610
	.float 0.194645
	.float -0.167269
	.float 0.423060
	.float -0.799228
	.float 0.970545
	.float -0.681648
	.float -0.040534
	.float 0.844784
	.float -1.233550
	.float 0.867951
	.float 0.187146
	.float -1.445724
	.float 2.246832
	.float -2.131616
	.float 1.122880
	.float 0.272812
	.float -1.350519
	.float 1.606061
	.float -1.002656
	.float -0.051721
	.float 0.981671
	.float -1.381474
	.float 1.198378
	.float -0.674599
	.float 0.133061
	.float 0.219833
	.float -0.349600
	.float 0.314615
	.float -0.160234
	.float -0.111494
	.float 0.486284
	.float -0.873558
	.float 1.117566
	.float -1.092538
	.float 0.806384
	.float -0.419537
	.float 0.151200
	.float -0.136361
	.float 0.338942
	.float -0.583877
	.float 0.680378
	.float -0.544216
	.float 0.235773
	.float 0.099188
	.float -0.327935
	.float 0.393657
	.float -0.311456
	.float 0.125929
	.float 0.118661
	.float -0.372657
	.float 0.564247
	.float -0.611634
	.float 0.472878
	.float -0.194318
	.float -0.094841
	.float 0.254086
	.float -0.222994
	.float 0.063523
	.float 0.079269
	.float -0.067430
	.float -0.153228
	.float 0.532976
	.float -0.948665
	.float 1.250378
	.float -1.301481
	.float 1.016125
	.float -0.402629
	.float -0.404223
	.float 1.161861
	.float -1.612085
	.float 1.613366
	.float -1.230808
	.float 0.710684
	.float -0.339690
	.float 0.275584
	.float -0.463159
	.float 0.692551
	.float -0.753856
	.float 0.575308
	.float -0.251613
	.float -0.042693
	.float 0.176682
	.float -0.129545
	.float -0.034937
	.float 0.243414
	.float -0.464023
	.float 0.694139
	.float -0.911210
	.float 1.047438
	.float -1.024512
	.float 0.824243
	.float -0.530511
	.float 0.295083
	.float -0.240788
	.float 0.370529
	.float -0.551080
	.float 0.588172
	.float -0.344241
	.float -0.176496
	.float 0.825486
	.float -1.384326
	.float 1.669060
	.float -1.609361
	.float 1.270681
	.float -0.818538
	.float 0.445729
	.float -0.293671
	.float 0.398483
	.float -0.683618
	.float 1.002311
	.float -1.209534
	.float 1.226287
	.float -1.063393
	.float 0.796158
	.float -0.511162
	.float 0.262355
	.float -0.062768
	.float -0.089806
	.float 0.180023
	.float -0.165641
	.float 0.002791
	.float 0.311697
	.float -0.713897
	.float 1.085552
	.float -1.302346
	.float 1.289556
	.float -1.053885
	.float 0.678322
	.float -0.288917
	.float 0.011543
	.float 0.067542
	.float 0.069690
	.float -0.362780
	.float 0.689636
	.float -0.912754
	.float 0.939208
	.float -0.765080
	.float 0.478005
	.float -0.212933
	.float 0.083093
	.float -0.123422
	.float 0.278682
	.float -0.442749
	.float 0.525209
	.float -0.502364
	.float 0.420827
	.float -0.355069
	.float 0.353090
	.float -0.408551
	.float 0.471379
	.float -0.479993
	.float 0.391225
	.float -0.200679
	.float -0.043361
	.float 0.238915
	.float -0.262926
	.float 0.045054
	.float 0.353975
	.float -0.729365
	.float 0.829175
	.float -0.521138
	.float -0.086375
	.float 0.677970
	.float -0.922324
	.float 0.697117
	.float -0.182525
	.float -0.254642
	.float 0.309724
	.float 0.054835
	.float -0.593012
	.float 0.953351
	.float -0.921063
	.float 0.554579
	.float -0.128860
	.float -0.066498
	.float -0.070033
	.float 0.388149
	.float -0.602195
	.float 0.503231
	.float -0.114006
	.float -0.325896
	.float 0.534023
	.float -0.389103
	.float 0.013269
	.float 0.326376
	.float -0.417063
	.float 0.247109
	.float 0.006537
	.float -0.128980
	.float 0.032299
	.float 0.190016
	.float -0.348757
	.float 0.306073
	.float -0.069129
	.float -0.230956
	.float 0.442710
	.float -0.493348
	.float 0.414133
	.float -0.289514
	.float 0.184247
	.float -0.107772
	.float 0.032593
	.float 0.064086
	.float -0.179651
	.float 0.301629
	.float -0.433479
	.float 0.592934
	.float -0.774666
	.float 0.914444
	.float -0.904846
	.float 0.672579
	.float -0.263743
	.float -0.142597
	.float 0.327321
	.float -0.177882
	.float -0.219683
	.float 0.620847
	.float -0.773724
	.float 0.575219
	.float -0.123170
	.float -0.362109
	.float 0.679839
	.float -0.753421
	.float 0.640252
	.float -0.463233
	.float 0.325062
	.float -0.259464
	.float 0.236322
	.float -0.203513
	.float 0.132927
	.float -0.041608
	.float -0.022850
	.float 0.020167
	.float 0.050666
	.float -0.150399
	.float 0.228521
	.float -0.257050
	.float 0.241834
	.float -0.206413
	.float 0.166086
	.float -0.115324
	.float 0.037177
	.float 0.072959
	.float -0.186116
	.float 0.239047
	.float -0.164671
	.float -0.055440
	.float 0.350786
	.float -0.576634
	.float 0.595739
	.float -0.381572
	.float 0.062277
	.float 0.145166
	.float -0.077559
	.float -0.257290
	.float 0.680381
	.float -0.961428
	.float 0.967356
	.float -0.728424
	.float 0.382382
	.float -0.057361
	.float -0.203949
	.float 0.425015
	.float -0.619952
	.float 0.748414
	.float -0.750345
	.float 0.624742
	.float -0.465937
	.float 0.406262
	.float -0.502096
	.float 0.660648
	.float -0.679004
	.float 0.378794
	.float 0.258440
	.float -1.051134
	.float 1.701040
	.float -1.945793
	.float 1.690075
	.float -1.047852
	.float 0.281770
	.float 0.324963
	.float -0.602287
	.float 0.569413
	.float -0.412148
	.float 0.367039
	.float -0.572077
	.float 0.975028
	.float -1.364366
	.float 1.512281
	.float -1.337739
	.float 0.975698
	.float -0.695880
	.float 0.718758
	.float -1.052493
	.float 1.467794
	.float -1.637964
	.float 1.357678
	.float -0.693758
	.float -0.038609
	.float 0.466169
	.float -0.390510
	.float -0.092248
	.float 0.664621
	.float -1.000445
	.float 0.968414
	.float -0.689400
	.float 0.418994
	.float -0.352068
	.float 0.494680
	.float -0.688929
	.float 0.755161
	.float -0.630643
	.float 0.397729
	.float -0.192349
	.float 0.082185
	.float -0.021197
	.float -0.087111
	.float 0.282227
	.float -0.495276
	.float 0.599855
	.float -0.518292
	.float 0.289290
	.float -0.039642
	.float -0.111241
	.float 0.128867
	.float -0.059807
	.float -0.039718
	.float 0.168570
	.float -0.374740
	.float 0.685415
	.float -1.042642
	.float 1.310596
	.float -1.356882
	.float 1.143973
	.float -0.758747
	.float 0.359912
	.float -0.086926
	.float -0.004185
	.float -0.057442
	.float 0.202744
	.float -0.372201
	.float 0.534786
	.float -0.674483
	.float 0.767840
	.float -0.778645
	.float 0.677082
	.float -0.467683
	.float 0.201163
	.float 0.043605
	.float -0.199222
	.float 0.246396
	.float -0.224693
	.float 0.209934
	.float -0.271620
	.float 0.434019
	.float -0.662215
	.float 0.879721
	.float -1.006552
	.float 0.996210
	.float -0.852694
	.float 0.620963
	.float -0.359892
	.float 0.114275
	.float 0.098643
	.float -0.282278
	.float 0.439715
	.float -0.555848
	.float 0.600055
	.float -0.552424
	.float 0.433596
	.float -0.307546
	.float 0.243892
	.float -0.264324
	.float 0.320839
	.float -0.335163
	.float 0.274223
	.float -0.196186
	.float 0.215995
	.float -0.405618
	.float 0.707086
	.float -0.937515
	.float 0.898197
	.float -0.515436
	.float -0.089335
	.float 0.655366
	.float -0.930565
	.float 0.815391
	.float -0.412524
	.float -0.042341
	.float 0.319634
	.float -0.319008
	.float 0.108090
	.float 0.137104
	.float -0.247857
	.float 0.163083
	.float 0.041942
	.float -0.209416
	.float 0.196104
	.float 0.046275
	.float -0.449580
	.float 0.868488
	.float -1.149898
	.float 1.194992
	.float -0.990359
	.float 0.604004
	.float -0.154659
	.float -0.231329
	.float 0.460748
	.float -0.499327
	.float 0.376287
	.float -0.166794
	.float -0.041474
	.float 0.185706
	.float -0.252439
	.float 0.273737
	.float -0.296615
	.float 0.347204
	.float -0.416968
	.float 0.478738
	.float -0.510930
	.float 0.501467
	.float -0.428618
	.float 0.249915
	.float 0.070592
	.float -0.506513
	.float 0.938240
	.float -1.194882
	.float 1.157835
	.float -0.853019
	.float 0.452966
	.float -0.174886
	.float 0.142469
	.float -0.310842
	.float 0.508161
	.float -0.562638
	.float 0.424305
	.float -0.198112
	.float 0.068923
	.float -0.170924
	.float 0.488624
	.float -0.854286
	.float 1.045098
	.float -0.920586
	.float 0.515570
	.float -0.030959
	.float -0.273366
	.float 0.222438
	.float 0.174176
	.float -0.721452
	.float 1.139064
	.float -1.212982
	.float 0.918434
	.float -0.441130
	.float 0.072091
	.float -0.028840
	.float 0.314100
	.float -0.713739
	.float 0.943679
	.float -0.844397
	.float 0.480350
	.float -0.074249
	.float -0.164255
	.float 0.177965
	.float -0.068958
	.float -0.013138
	.float -0.001985
	.float 0.062888
	.float -0.057827
	.float -0.080960
	.float 0.313963
	.float -0.516101
	.float 0.564498
	.float -0.430344
	.float 0.210041
	.float -0.069537
	.float 0.133357
	.float -0.392581
	.float 0.698503
	.float -0.851523
	.float 0.726561
	.float -0.350226
	.float -0.118081
	.float 0.479221
	.float -0.595566
	.float 0.442993
	.float -0.101477
	.float -0.292063
	.float 0.600320
	.float -0.737016
	.float 0.703647
	.float -0.593653
	.float 0.545825
	.float -0.655730
	.float 0.894549
	.float -1.099569
	.float 1.062424
	.float -0.670394
	.float 0.006303
	.float 0.669550
	.float -1.054123
	.float 0.970152
	.float -0.461904
	.float -0.237376
	.float 0.835929
	.float -1.125082
	.float 1.053485
	.float -0.713131
	.float 0.271001
	.float 0.104535
	.float -0.295732
	.float 0.265998
	.float -0.072783
	.float -0.145394
	.float 0.219271
	.float -0.027722
	.float -0.431924
	.float 1.026250
	.float -1.538470
	.float 1.766971
	.float -1.619166
	.float 1.155167
	.float -0.564012
	.float 0.085404
	.float 0.092191
	.float 0.081229
	.float -0.481694
	.float 0.854095
	.float -0.930881
	.float 0.580542
	.float 0.095594
	.float -0.791317
	.float 1.156270
	.float -1.006442
	.float 0.449654
	.float 0.168408
	.float -0.475674
	.float 0.306652
	.float 0.198953
	.float -0.695507
	.float 0.855284
	.float -0.565231
	.float -0.022423
	.float 0.598925
	.float -0.883283
	.float 0.770186
	.float -0.369247
	.float -0.071388
	.float 0.308231
	.float -0.235778
	.float -0.061483
	.float 0.368377
	.float -0.476210
	.float 0.312004
	.float 0.023444
	.float -0.330400
	.float 0.441017
	.float -0.313343
	.float 0.030060
	.float 0.282085
	.float -0.541548
	.float 0.743979
	.float -0.923880
	.float 1.088619
	.float -1.185440
	.float 1.131153
	.float -0.883024
	.float 0.493819
	.float -0.102888
	.float -0.139579
	.float 0.166657
	.float -0.039528
	.float -0.094397
	.float 0.106410
	.float 0.018186
	.float -0.165911
	.float 0.178479
	.float 0.022054
	.float -0.358336
	.float 0.634107
	.float -0.663330
	.float 0.403684
	.float 0.002487
	.float -0.312818
	.float 0.340918
	.float -0.079759
	.float -0.287951
	.float 0.498773
	.float -0.368368
	.float -0.093372
	.float 0.678903
	.float -1.094211
	.float 1.124716
	.float -0.763510
	.float 0.224095
	.float 0.179172
	.float -0.220236
	.float -0.095020
	.float 0.528273
	.float -0.759984
	.float 0.596115
	.float -0.089770
	.float -0.504680
	.float 0.904617
	.float -0.967708
	.float 0.737913
	.float -0.357498
	.float -0.057339
	.float 0.463984
	.float -0.837866
	.float 1.095537
	.float -1.101900
	.float 0.782459
	.float -0.243696
	.float -0.229538
	.float 0.339401
	.float 0.004240
	.float -0.586315
	.float 1.012248
	.float -0.982091
	.float 0.510465
	.float 0.079960
	.float -0.391559
	.float 0.235828
	.float 0.245138
	.float -0.702464
	.float 0.843798
	.float -0.632777
	.float 0.287059
	.float -0.098186
	.float 0.220544
	.float -0.576485
	.float 0.921632
	.float -1.002648
	.float 0.698142
	.float -0.070626
	.float -0.675204
	.float 1.286853
	.float -1.561816
	.float 1.414891
	.float -0.899953
	.float 0.185699
	.float 0.504468
	.float -0.968781
	.float 1.094455
	.float -0.892540
	.float 0.485816
	.float -0.052069
	.float -0.255312
	.float 0.372988
	.float -0.345967
	.float 0.287694
	.float -0.305322
	.float 0.435309
	.float -0.626411
	.float 0.775336
	.float -0.787169
	.float 0.623672
	.float -0.318958
	.float -0.034364
	.float 0.316743
	.float -0.422762
	.float 0.307242
	.float -0.020994
	.float -0.290964
	.float 0.447541
	.float -0.328883
	.float -0.043633
	.float 0.505133
	.float -0.836266
	.float 0.888889
	.float -0.662484
	.float 0.280432
	.float 0.107154
	.float -0.412676
	.float 0.627484
	.float -0.770785
	.float 0.834796
	.float -0.784009
	.float 0.605300
	.float -0.351871
	.float 0.129816
	.float -0.031976
	.float 0.074806
	.float -0.190121
	.float 0.275030
	.float -0.256346
	.float 0.123954
	.float 0.078488
	.float -0.284341
	.float 0.431769
	.float -0.482368
	.float 0.437151
	.float -0.347707
	.float 0.306735
	.float -0.404804
	.float 0.666808
	.float -1.009383
	.float 1.260992
	.float -1.250578
	.float 0.918881
	.float -0.377494
	.float -0.137589
	.float 0.404155
	.float -0.359906
	.float 0.151791
	.float -0.040829
	.float 0.216080
	.float -0.646794
	.float 1.085180
	.float -1.226707
	.float 0.918724
	.float -0.269628
	.float -0.414732
	.float 0.816538
	.float -0.782364
	.float 0.382925
	.float 0.157495
	.float -0.591709
	.float 0.755430
	.float -0.608621
	.float 0.224892
	.float 0.243474
	.float -0.613985
	.float 0.737329
	.float -0.563663
	.float 0.176646
	.float 0.239131
	.float -0.493110
	.float 0.492463
	.float -0.286495
	.float 0.022656
	.float 0.151608
	.float -0.170536
	.float 0.066260
	.float 0.075086
	.float -0.171248
	.float 0.175869
	.float -0.081511
	.float -0.083037
	.float 0.248026
	.float -0.306398
	.float 0.153336
	.float 0.239463
	.float -0.762449
	.float 1.184253
	.float -1.267316
	.float 0.924947
	.float -0.309042
	.float -0.253647
	.float 0.453887
	.float -0.195141
	.float -0.347549
	.float 0.847717
	.float -1.035442
	.float 0.842039
	.float -0.390847
	.float -0.128534
	.float 0.583093
	.float -0.923975
	.float 1.128337
	.float -1.144241
	.float 0.912932
	.float -0.455290
	.float -0.067935
	.float 0.404837
	.float -0.363066
	.float -0.041443
	.float 0.559511
	.float -0.847008
	.float 0.682226
	.float -0.112767
	.float -0.571833
	.float 1.020307
	.float -1.024581
	.float 0.613711
	.float 0.007427
	.float -0.605810
	.float 1.037871
	.float -1.266750
	.float 1.300447
	.float -1.130662
	.float 0.736143
	.float -0.143884
	.float -0.517621
	.float 1.038026
	.float -1.223166
	.float 1.008775
	.float -0.508128
	.float -0.043026
	.float 0.408396
	.float -0.462536
	.float 0.231723
	.float 0.142024
	.float -0.477021
	.float 0.628524
	.float -0.544544
	.float 0.291578
	.float -0.035584
	.float -0.033182
	.float -0.189088
	.float 0.637275
	.float -1.093093
	.float 1.310760
	.float -1.176072
	.float 0.781252
	.float -0.350867
	.float 0.070827
	.float 0.045629
	.float -0.145638
	.float 0.387953
	.float -0.781500
	.float 1.147716
	.float -1.243461
	.float 0.950230
	.float -0.381670
	.float -0.176625
	.float 0.453919
	.float -0.373861
	.float 0.100219
	.float 0.082026
	.float 0.033247
	.float -0.428356
	.float 0.868681
	.float -1.054392
	.float 0.814142
	.float -0.215021
	.float -0.475608
	.float 0.941459
	.float -0.982002
	.float 0.598499
	.float 0.029240
	.float -0.642208
	.float 1.017842
	.float -1.051682
	.float 0.780644
	.float -0.347716
	.float -0.070355
	.float 0.338012
	.float -0.405561
	.float 0.310920
	.float -0.150161
	.float 0.037971
	.float -0.069288
	.float 0.283535
	.float -0.637382
	.float 1.004636
	.float -1.220934
	.float 1.164311
	.float -0.829745
	.float 0.347418
	.float 0.076696
	.float -0.270168
	.float 0.191096
	.float 0.046786
	.float -0.240391
	.float 0.219254
	.float 0.050164
	.float -0.444459
	.float 0.762422
	.float -0.851666
	.float 0.698458
	.float -0.422923
	.float 0.190226
	.float -0.103353
	.float 0.147348
	.float -0.211737
	.float 0.166306
	.float 0.058702
	.float -0.428323
	.float 0.812377
	.float -1.043590
	.float 0.999593
	.float -0.671249
	.float 0.179904
	.float 0.271962
	.float -0.496752
	.float 0.415430
	.float -0.097542
	.float -0.275405
	.float 0.504134
	.float -0.470959
	.float 0.190132
	.float 0.214318
	.float -0.581635
	.float 0.788930
	.float -0.787944
	.float 0.600445
	.float -0.297339
	.float -0.017671
	.float 0.225595
	.float -0.229717
	.float 0.011259
	.float 0.334772
	.float -0.628983
	.float 0.705414
	.float -0.519549
	.float 0.183763
	.float 0.107338
	.float -0.213636
	.float 0.143944
	.float -0.031692
	.float 0.009852
	.float -0.089957
	.float 0.150667
	.float -0.050071
	.float -0.233065
	.float 0.555384
	.float -0.709635
	.float 0.592779
	.float -0.301752
	.float 0.072046
	.float -0.101396
	.float 0.394501
	.float -0.748119
	.float 0.887491
	.float -0.653858
	.float 0.111432
	.float 0.493840
	.float -0.887473
	.float 0.926371
	.float -0.665896
	.float 0.302044
	.float -0.036964
	.float -0.041816
	.float -0.005847
	.float 0.039858
	.float 0.045331
	.float -0.237960
	.float 0.412285
	.float -0.413609
	.float 0.167500
	.float 0.257932
	.float -0.677675
	.float 0.889142
	.float -0.785011
	.float 0.410381
	.float 0.070939
	.float -0.478943
	.float 0.720221
	.float -0.821065
	.float 0.869635
	.float -0.914685
	.float 0.905636
	.float -0.731613
	.float 0.336602
	.float 0.183748
	.float -0.597989
	.float 0.678638
	.float -0.370645
	.float -0.145374
	.float 0.558471
	.float -0.634294
	.float 0.371793
	.float 0.007133
	.float -0.224132
	.float 0.139031
	.float 0.169849
	.float -0.485936
	.float 0.619967
	.float -0.531310
	.float 0.323661
	.float -0.136021
	.float 0.025507
	.float 0.064732
	.float -0.233026
	.float 0.506867
	.float -0.787893
	.float 0.906608
	.float -0.750402
	.float 0.364705
	.float 0.057304
	.float -0.295494
	.float 0.244611
	.float 0.029371
	.float -0.353889
	.float 0.575752
	.float -0.646875
	.float 0.614707
	.float -0.547071
	.float 0.468738
	.float -0.360297
	.float 0.204531
	.float -0.024190
	.float -0.127504
	.float 0.210368
	.float -0.228556
	.float 0.216758
	.float -0.193899
	.float 0.130439
	.float 0.031563
	.float -0.311128
	.float 0.626885
	.float -0.804300
	.float 0.671720
	.float -0.194097
	.float -0.453836
	.float 0.948615
	.float -0.997515
	.float 0.527370
	.float 0.248255
	.float -0.938463
	.float 1.195737
	.float -0.908000
	.float 0.246437
	.float 0.448048
	.float -0.858360
	.float 0.849446
	.float -0.512784
	.float 0.090140
	.float 0.170030
	.float -0.144272
	.float -0.112967
	.float 0.418452
	.float -0.579713
	.float 0.513165
	.float -0.289869
	.float 0.083549
	.float -0.056774
	.float 0.258659
	.float -0.596329
	.float 0.892808
	.float -0.990520
	.float 0.836266
	.float -0.501395
	.float 0.134161
	.float 0.119234
	.float -0.176755
	.float 0.038685
	.float 0.231823
	.float -0.540138
	.float 0.785052
	.float -0.878967
	.float 0.772928
	.float -0.481849
	.float 0.088205
	.float 0.291451
	.float -0.562188
	.float 0.689066
	.float -0.691096
	.float 0.605706
	.float -0.466107
	.float 0.314314
	.float -0.223030
	.float 0.278036
	.float -0.509806
	.float 0.829223
	.float -1.043286
	.float 0.969433
	.float -0.574360
	.float 0.023598
	.float 0.412211
	.float -0.534571
	.float 0.347269
	.float -0.043262
	.float -0.137280
	.float 0.069019
	.float 0.191088
	.float -0.466074
	.float 0.591087
	.float -0.515886
	.float 0.313620
	.float -0.105253
	.float -0.036130
	.float 0.131916
	.float -0.267596
	.float 0.511159
	.float -0.840170
	.float 1.130444
	.float -1.217969
	.float 0.997003
	.float -0.491786
	.float -0.144111
	.float 0.699996
	.float -1.007795
	.float 1.013195
	.float -0.786602
	.float 0.479543
	.float -0.254504
	.float 0.217143
	.float -0.370520
	.float 0.606484
	.float -0.747227
	.float 0.633353
	.float -0.222888
	.float -0.358783
	.float 0.864750
	.float -1.056609
	.float 0.844215
	.float -0.343144
	.float -0.192282
	.float 0.519037
	.float -0.541044
	.float 0.345922
	.float -0.127449
	.float 0.053712
	.float -0.169773
	.float 0.391690
	.float -0.583525
	.float 0.655924
	.float -0.618626
	.float 0.558200
	.float -0.564605
	.float 0.662019
	.float -0.790426
	.float 0.848578
	.float -0.768654
	.float 0.571556
	.float -0.361427
	.float 0.255258
	.float -0.290262
	.float 0.377533
	.float -0.348855
	.float 0.077633
	.float 0.409221
	.float -0.918715
	.float 1.201114
	.float -1.108827
	.float 0.688205
	.float -0.136671
	.float -0.337714
	.float 0.642604
	.float -0.819763
	.float 0.955213
	.float -1.069079
	.float 1.082286
	.float -0.886371
	.float 0.454149
	.float 0.101106
	.float -0.565404
	.float 0.735317
	.float -0.528854
	.float 0.034509
	.float 0.520703
	.float -0.866246
	.float 0.808711
	.float -0.332179
	.float -0.370410
	.float 0.966167
	.float -1.137439
	.float 0.751683
	.float 0.052058
	.float -0.923155
	.float 1.484494
	.float -1.538199
	.float 1.165262
	.float -0.652928
	.float 0.295716
	.float -0.204890
	.float 0.260731
	.float -0.241480
	.float 0.029265
	.float 0.270152
	.float -0.393860
	.float 0.127700
	.float 0.508262
	.float -1.241637
	.float 1.713018
	.float -1.701982
	.float 1.252113
	.float -0.619836
	.float 0.103133
	.float 0.120130
	.float -0.047172
	.float -0.205128
	.float 0.495726
	.float -0.722254
	.float 0.830233
	.float -0.797848
	.float 0.630962
	.float -0.373304
	.float 0.107724
	.float 0.070946
	.float -0.102628
	.float -0.004818
	.float 0.182254
	.float -0.341630
	.float 0.423218
	.float -0.416193
	.float 0.346673
	.float -0.252926
	.float 0.171421
	.float -0.136670
	.float 0.177866
	.float -0.299680
	.float 0.460977
	.float -0.583281
	.float 0.600624
	.float -0.518265
	.float 0.422347
	.float -0.415731
	.float 0.523791
	.float -0.653837
	.float 0.656004
	.float -0.444167
	.float 0.076115
	.float 0.279400
	.float -0.464825
	.float 0.444039
	.float -0.311396
	.float 0.198717
	.float -0.165708
	.float 0.166161
	.float -0.111885
	.float -0.027908
	.float 0.180509
	.float -0.217531
	.float 0.059545
	.float 0.244319
	.float -0.525209
	.float 0.591674
	.float -0.352491
	.float -0.115691
	.float 0.603000
	.float -0.885178
	.float 0.855493
	.float -0.588204
	.float 0.293237
	.float -0.187634
	.float 0.361546
	.float -0.720823
	.float 1.042780
	.float -1.113169
	.float 0.860715
	.float -0.404906
	.float -0.015714
	.float 0.192059
	.float -0.074266
	.float -0.205049
	.float 0.432907
	.float -0.473537
	.float 0.366404
	.float -0.288747
	.float 0.407156
	.float -0.732096
	.float 1.091001
	.float -1.245222
	.float 1.061726
	.float -0.609491
	.float 0.112884
	.float 0.192195
	.float -0.188330
	.float -0.089332
	.float 0.510405
	.float -0.930177
	.float 1.234114
	.float -1.340466
	.float 1.198134
	.float -0.806959
	.float 0.247799
	.float 0.317405
	.float -0.699704
	.float 0.770886
	.float -0.532485
	.float 0.119582
	.float 0.264830
	.float -0.446176
	.float 0.351496
	.float -0.026791
	.float -0.396450
	.float 0.757307
	.float -0.917338
	.float 0.799326
	.float -0.413659
	.float -0.133962
	.float 0.668337
	.float -1.011035
	.float 1.065315
	.float -0.872529
	.float 0.597325
	.float -0.440525
	.float 0.525635
	.float -0.826210
	.float 1.176385
	.float -1.358483
	.float 1.218577
	.float -0.750384
	.float 0.107807
	.float 0.457681
	.float -0.705733
	.float 0.515022
	.float 0.055875
	.float -0.783026
	.float 1.366095
	.float -1.557772
	.float 1.276913
	.float -0.648693
	.float -0.055447
	.float 0.552591
	.float -0.687779
	.float 0.498954
	.float -0.169983
	.float -0.095569
	.float 0.197168
	.float -0.177791
	.float 0.163010
	.float -0.250724
	.float 0.435014
	.float -0.617347
	.float 0.689976
	.float -0.622373
	.float 0.481662
	.float -0.371357
	.float 0.338000
	.float -0.321754
	.float 0.195816
	.float 0.128799
	.float -0.608886
	.float 1.059044
	.float -1.242990
	.float 1.013052
	.float -0.409963
	.float -0.339723
	.float 0.927701
	.float -1.110248
	.float 0.819012
	.float -0.184017
	.float -0.535498
	.float 1.073064
	.float -1.269191
	.float 1.124134
	.float -0.769253
	.float 0.381995
	.float -0.099347
	.float -0.022646
	.float -0.004681
	.float 0.137811
	.float -0.320081
	.float 0.478484
	.float -0.526965
	.float 0.402626
	.float -0.122150
	.float -0.191943
	.float 0.356634
	.float -0.231789
	.float -0.186102
	.float 0.748634
	.float -1.232379
	.float 1.454263
	.float -1.349795
	.float 0.975162
	.float -0.453869
	.float -0.082979
	.float 0.529772
	.float -0.816631
	.float 0.916387
	.float -0.851970
	.float 0.688247
	.float -0.497109
	.float 0.314746
	.float -0.129721
	.float -0.079346
	.float 0.285562
	.float -0.394763
	.float 0.299883
	.float 0.024531
	.float -0.467439
	.float 0.825277
	.float -0.924193
	.float 0.730704
	.float -0.365820
	.float 0.014560
	.float 0.194814
	.float -0.250472
	.float 0.223792
	.float -0.189987
	.float 0.177177
	.float -0.177222
	.float 0.187396
	.float -0.226926
	.float 0.307310
	.float -0.390722
	.float 0.389818
	.float -0.224937
	.float -0.102678
	.float 0.486132
	.float -0.764824
	.float 0.819733
	.float -0.643179
	.float 0.335902
	.float -0.039570
	.float -0.143080
	.float 0.188888
	.float -0.139365
	.float 0.053792
	.float 0.032502
	.float -0.119550
	.float 0.222946
	.float -0.341636
	.float 0.438913
	.float -0.454787
	.float 0.347546
	.float -0.136880
	.float -0.089021
	.float 0.220228
	.float -0.199669
	.float 0.068581
	.float 0.060081
	.float -0.085691
	.float -0.004451
	.float 0.130469
	.float -0.189176
	.float 0.138107
	.float -0.025225
	.float -0.054878
	.float 0.036739
	.float 0.069661
	.float -0.193447
	.float 0.261122
	.float -0.254749
	.float 0.230458
	.float -0.283670
	.float 0.478884
	.float -0.786880
	.float 1.075878
	.float -1.176260
	.float 0.986455
	.float -0.549116
	.float 0.037664
	.float 0.344232
	.float -0.480642
	.float 0.396438
	.float -0.215206
	.float 0.066098
	.float -0.013667
	.float 0.052090
	.float -0.145703
	.float 0.265614
	.float -0.391866
	.float 0.492630
	.float -0.514739
	.float 0.406077
	.float -0.156822
	.float -0.173799
	.float 0.470696
	.float -0.613586
	.float 0.536684
	.float -0.262784
	.float -0.106667
	.float 0.437721
	.float -0.619905
	.float 0.605822
	.float -0.421155
	.float 0.147123
	.float 0.115573
	.float -0.289094
	.float 0.352288
	.float -0.349460
	.float 0.364479
	.float -0.468413
	.float 0.667381
	.float -0.882788
	.float 0.981534
	.float -0.847005
	.float 0.455252
	.float 0.088885
	.float -0.585957
	.float 0.838650
	.float -0.759978
	.float 0.425218
	.float -0.028729
	.float -0.230745
	.float 0.260993
	.float -0.110018
	.float -0.093468
	.float 0.240321
	.float -0.304947
	.float 0.333556
	.float -0.381160
	.float 0.458250
	.float -0.528804
	.float 0.549733
	.float -0.508346
	.float 0.425325
	.float -0.329214
	.float 0.233537
	.float -0.137041
	.float 0.039038
	.float 0.051250
	.float -0.118987
	.float 0.151258
	.float -0.137711
	.float 0.070842
	.float 0.042327
	.float -0.163396
	.float 0.227656
	.float -0.186962
	.float 0.065980
	.float 0.023890
	.float 0.053708
	.float -0.354244
	.float 0.785318
	.float -1.143755
	.float 1.242543
	.float -1.038094
	.float 0.662922
	.float -0.339201
	.float 0.236843
	.float -0.374401
	.float 0.621794
	.float -0.787768
	.float 0.724853
	.float -0.391035
	.float -0.148638
	.float 0.758449
	.float -1.279089
	.float 1.574120
	.float -1.576152
	.float 1.322550
	.float -0.953646
	.float 0.652389
	.float -0.541426
	.float 0.597292
	.float -0.649164
	.float 0.481659
	.float 0.014074
	.float -0.741782
	.float 1.429218
	.float -1.775328
	.float 1.623473
	.float -1.047954
	.float 0.300041
	.float 0.346018
	.float -0.742026
	.float 0.915049
	.float -0.995453
	.float 1.086962
	.float -1.175703
	.float 1.140357
	.float -0.849824
	.float 0.275928
	.float 0.454507
	.float -1.099203
	.float 1.407711
	.float -1.240799
	.float 0.646338
	.float 0.145205
	.float -0.811784
	.float 1.084107
	.float -0.875063
	.float 0.320108
	.float 0.300998
	.float -0.717500
	.float 0.801180
	.float -0.601292
	.float 0.275238
	.float 0.020302
	.float -0.199831
	.float 0.250887
	.float -0.196864
	.float 0.069618
	.float 0.088471
	.float -0.214650
	.float 0.239646
	.float -0.128791
	.float -0.080938
	.float 0.285882
	.float -0.369751
	.float 0.272655
	.float -0.025780
	.float -0.272758
	.float 0.520616
	.float -0.664704
	.float 0.708225
	.float -0.675452
	.float 0.571651
	.float -0.375953
	.float 0.071642
	.float 0.316427
	.float -0.712293
	.float 1.016703
	.float -1.149698
	.float 1.078381
	.float -0.819244
	.float 0.427000
	.float 0.015230
	.float -0.404888
	.float 0.641364
	.float -0.662648
	.float 0.477477
	.float -0.164596
	.float -0.169225
	.float 0.445133
	.float -0.639433
	.float 0.762133
	.float -0.810571
	.float 0.745907
	.float -0.521206
	.float 0.140994
	.float 0.301793
	.float -0.654556
	.float 0.791684
	.float -0.701027
	.float 0.503350
	.float -0.380308
	.float 0.452125
	.float -0.688029
	.float 0.916724
	.float -0.937235
	.float 0.655989
	.float -0.153593
	.float -0.366085
	.float 0.704091
	.float -0.776466
	.float 0.633680
	.float -0.395300
	.float 0.168288
	.float -0.012363
	.float -0.043246
	.float -0.023634
	.float 0.219811
	.float -0.505631
	.float 0.782981
	.float -0.927990
	.float 0.850000
	.float -0.534929
	.float 0.048116
	.float 0.491673
	.float -0.942135
	.float 1.163739
	.float -1.056713
	.float 0.615905
	.float 0.023350
	.float -0.598615
	.float 0.821083
	.float -0.528005
	.float -0.204795
	.float 1.076629
	.float -1.712372
	.float 1.863869
	.float -1.534354
	.float 0.948293
	.float -0.396644
	.float 0.070549
	.float 0.009956
	.float 0.051557
	.float -0.129417
	.float 0.145726
	.float -0.074118
	.float -0.090478
	.float 0.345058
	.float -0.660350
	.float 0.963135
	.float -1.156568
	.float 1.176442
	.float -1.038664
	.float 0.831059
	.float -0.646189
	.float 0.504057
	.float -0.330552
	.float 0.020033
	.float 0.456277
	.float -0.980005
	.float 1.322869
	.float -1.285157
	.float 0.844289
	.float -0.198145
	.float -0.345201
	.float 0.563565
	.float -0.461618
	.float 0.251059
	.float -0.185341
	.float 0.374240
	.float -0.714669
	.float 0.979302
	.float -0.984994
	.float 0.713786
	.float -0.309683
	.float -0.027164
	.float 0.161143
	.float -0.078702
	.float -0.134338
	.float 0.357156
	.float -0.489438
	.float 0.476023
	.float -0.310475
	.float 0.034154
	.float 0.268518
	.float -0.493774
	.float 0.566855
	.float -0.493279
	.float 0.371489
	.float -0.340295
	.float 0.482165
	.float -0.747257
	.float 0.962492
	.float -0.934925
	.float 0.585772
	.float -0.019681
	.float -0.526607
	.float 0.826165
	.float -0.797988
	.float 0.545953
	.float -0.280393
	.float 0.181567
	.float -0.296036
	.float 0.524732
	.float -0.697871
	.float 0.683579
	.float -0.465803
	.float 0.150313
	.float 0.102121
	.float -0.177190
	.float 0.081857
	.float 0.058316
	.float -0.084179
	.float -0.081317
	.float 0.366255
	.float -0.583433
	.float 0.548376
	.float -0.206120
	.float -0.316702
	.float 0.769649
	.float -0.913612
	.float 0.655894
	.float -0.110399
	.float -0.451392
	.float 0.736328
	.float -0.583743
	.float 0.054744
	.float 0.597578
	.float -1.066394
	.float 1.160186
	.float -0.900614
	.float 0.490028
	.float -0.174624
	.float 0.099208
	.float -0.249059
	.float 0.504781
	.float -0.751853
	.float 0.952474
	.float -1.128614
	.float 1.283658
	.float -1.342111
	.float 1.170719
	.float -0.675878
	.float -0.093865
	.float 0.924094
	.float -1.522629
	.float 1.674693
	.float -1.369683
	.float 0.815692
	.float -0.325729
	.float 0.141126
	.float -0.298709
	.float 0.622590
	.float -0.842516
	.float 0.762031
	.float -0.372153
	.float -0.153822
	.float 0.570664
	.float -0.702699
	.float 0.532121
	.float -0.192189
	.float -0.118926
	.float 0.246585
	.float -0.149300
	.float -0.101661
	.float 0.380460
	.float -0.577454
	.float 0.639120
	.float -0.563815
	.float 0.376454
	.float -0.113877
	.float -0.171263
	.float 0.409120
	.float -0.535969
	.float 0.534240
	.float -0.453434
	.float 0.382910
	.float -0.388683
	.float 0.462289
	.float -0.525200
	.float 0.488752
	.float -0.324546
	.float 0.090728
	.float 0.106594
	.float -0.187755
	.float 0.153382
	.float -0.076769
	.float 0.041634
	.float -0.075972
	.float 0.136175
	.float -0.154785
	.float 0.109859
	.float -0.055452
	.float 0.085023
	.float -0.258778
	.float 0.556608
	.float -0.894033
	.float 1.182319
	.float -1.378178
	.float 1.483731
	.float -1.507652
	.float 1.434166
	.float -1.235324
	.float 0.916086
	.float -0.545548
	.float 0.235548
	.float -0.073993
	.float 0.061847
	.float -0.105209
	.float 0.073782
	.float 0.112300
	.float -0.423894
	.float 0.728394
	.float -0.854870
	.float 0.682515
	.float -0.208506
	.float -0.435604
	.float 1.027451
	.float -1.341259
	.float 1.242641
	.float -0.747060
	.float 0.013180
	.float 0.725559
	.float -1.256253
	.float 1.463300
	.float -1.357124
	.float 1.052624
	.float -0.715128
	.float 0.496633
	.float -0.481784
	.float 0.660782
	.float -0.940713
	.float 1.193526
	.float -1.317314
	.float 1.276317
	.float -1.098058
	.float 0.837473
	.float -0.542955
	.float 0.252498
	.float -0.014190
	.float -0.104152
	.float 0.044215
	.float 0.186918
	.float -0.484916
	.float 0.684393
	.float -0.655435
	.float 0.395508
	.float -0.042920
	.float -0.207720
	.float 0.230825
	.float -0.042695
	.float -0.230771
	.float 0.459323
	.float -0.596627
	.float 0.681344
	.float -0.761480
	.float 0.820073
	.float -0.774928
	.float 0.553649
	.float -0.175535
	.float -0.233098
	.float 0.505774
	.float -0.534803
	.float 0.335386
	.float -0.040535
	.float -0.162732
	.float 0.121920
	.float 0.203049
	.float -0.703844
	.float 1.154622
	.float -1.312127
	.float 1.045641
	.float -0.424329
	.float -0.302181
	.float 0.832224
	.float -0.976127
	.float 0.751293
	.float -0.346280
	.float -0.017211
	.float 0.224642
	.float -0.314854
	.float 0.410938
	.float -0.600398
	.float 0.859204
	.float -1.069851
	.float 1.108120
	.float -0.928285
	.float 0.590684
	.float -0.223047
	.float -0.051162
	.float 0.173186
	.float -0.168452
	.float 0.119798
	.float -0.111987
	.float 0.180414
	.float -0.293579
	.float 0.378326
	.float -0.369080
	.float 0.248748
	.float -0.058555
	.float -0.124154
	.float 0.224359
	.float -0.204880
	.float 0.083748
	.float 0.074607
	.float -0.193270
	.float 0.225328
	.float -0.179254
	.float 0.107888
	.float -0.067630
	.float 0.079218
	.float -0.122616
	.float 0.169763
	.float -0.223653
	.float 0.322022
	.float -0.493652
	.float 0.702446
	.float -0.837106
	.float 0.774210
	.float -0.478121
	.float 0.056173
	.float 0.291584
	.float -0.406807
	.float 0.292917
	.float -0.119780
	.float 0.097388
	.float -0.310675
	.float 0.646589
	.float -0.875268
	.float 0.825035
	.float -0.514849
	.float 0.141752
	.float 0.064279
	.float -0.003946
	.float -0.231151
	.float 0.438430
	.float -0.454933
	.float 0.264703
	.float 0.007139
	.float -0.194751
	.float 0.205384
	.float -0.069376
	.float -0.093814
	.float 0.155218
	.float -0.045909
	.float -0.215678
	.float 0.535432
	.float -0.778534
	.float 0.819879
	.float -0.606847
	.float 0.212862
	.float 0.163453
	.float -0.287159
	.float 0.035901
	.float 0.488958
	.float -0.990526
	.float 1.156666
	.float -0.878535
	.float 0.342858
	.float 0.086536
	.float -0.121197
	.float -0.251086
	.float 0.766481
	.float -1.081275
	.float 1.011392
	.float -0.640252
	.float 0.231271
	.float -0.030378
	.float 0.111877
	.float -0.365042
	.float 0.601354
	.float -0.680665
	.float 0.567738
	.float -0.306824
	.float -0.033224
	.float 0.388015
	.float -0.692291
	.float 0.872151
	.float -0.862667
	.float 0.644392
	.float -0.267494
	.float -0.158598
	.float 0.503571
	.float -0.660681
	.float 0.581934
	.float -0.300050
	.float -0.070078
	.float 0.364961
	.float -0.445774
	.float 0.279954
	.float 0.027310
	.float -0.291491
	.float 0.370141
	.float -0.260744
	.float 0.094483
	.float -0.025209
	.float 0.101623
	.float -0.228392
	.float 0.247847
	.float -0.072732
	.float -0.240556
	.float 0.533596
	.float -0.660692
	.float 0.581355
	.float -0.366058
	.float 0.128594
	.float 0.049694
	.float -0.150012
	.float 0.196620
	.float -0.221436
	.float 0.243320
	.float -0.266670
	.float 0.285373
	.float -0.282772
	.float 0.230629
	.float -0.095908
	.float -0.142519
	.float 0.473570
	.float -0.840301
	.float 1.142658
	.float -1.263543
	.float 1.116796
	.float -0.700380
	.float 0.123607
	.float 0.420189
	.float -0.736033
	.float 0.726242
	.float -0.445342
	.float 0.069866
	.float 0.204458
	.float -0.273707
	.float 0.170851
	.float -0.015784
	.float -0.088846
	.float 0.134870
	.float -0.199037
	.float 0.357743
	.float -0.598466
	.float 0.803442
	.float -0.822428
	.float 0.580554
	.float -0.141508
	.float -0.318564
	.float 0.607667
	.float -0.624644
	.float 0.415281
	.float -0.149729
	.float 0.031618
	.float -0.180971
	.float 0.550713
	.float -0.931221
	.float 1.057783
	.float -0.771655
	.float 0.137319
	.float 0.571079
	.float -1.020757
	.float 1.019141
	.float -0.628477
	.float 0.117675
	.float 0.214267
	.float -0.219098
	.float -0.037622
	.float 0.361874
	.float -0.586392
	.float 0.674304
	.float -0.702249
	.float 0.756103
	.float -0.838617
	.float 0.868318
	.float -0.763137
	.float 0.528273
	.float -0.267456
	.float 0.107170
	.float -0.099511
	.float 0.184870
	.float -0.241663
	.float 0.180259
	.float -0.008361
	.float -0.175543
	.float 0.250379
	.float -0.154601
	.float -0.067553
	.float 0.283285
	.float -0.346202
	.float 0.190089
	.float 0.116388
	.float -0.397225
	.float 0.471766
	.float -0.268460
	.float -0.129607
	.float 0.539825
	.float -0.793550
	.float 0.826469
	.float -0.690628
	.float 0.497700
	.float -0.347126
	.float 0.285843
	.float -0.307412
	.float 0.370612
	.float -0.419677
	.float 0.404232
	.float -0.301045
	.float 0.129298
	.float 0.056123
	.float -0.196798
	.float 0.268606
	.float -0.294525
	.float 0.318532
	.float -0.358813
	.float 0.380552
	.float -0.316210
	.float 0.123431
	.float 0.164690
	.float -0.442603
	.float 0.595003
	.float -0.575362
	.float 0.437575
	.float -0.290052
	.float 0.204640
	.float -0.154821
	.float 0.040215
	.float 0.213570
	.float -0.558784
	.float 0.820145
	.float -0.803057
	.float 0.444850
	.float 0.107250
	.float -0.564641
	.float 0.678045
	.float -0.406730
	.float -0.047347
	.float 0.369024
	.float -0.333884
	.float -0.053878
	.float 0.577680
	.float -0.955178
	.float 1.006197
	.float -0.734435
	.float 0.289889
	.float 0.136132
	.float -0.401746
	.float 0.444668
	.float -0.264676
	.float -0.097416
	.float 0.559708
	.float -0.994287
	.float 1.252336
	.float -1.227789
	.float 0.923209
	.float -0.462524
	.float 0.028386
	.float 0.238888
	.float -0.310240
	.float 0.258554
	.float -0.187730
	.float 0.162023
	.float -0.186862
	.float 0.238630
	.float -0.298160
	.float 0.351540
	.float -0.368580
	.float 0.301924
	.float -0.129620
	.float -0.090624
	.float 0.218018
	.float -0.104546
	.float -0.293510
	.float 0.855752
	.float -1.345974
	.float 1.542259
	.float -1.359842
	.float 0.886150
	.float -0.315405
	.float -0.161852
	.float 0.442400
	.float -0.527883
	.float 0.486067
	.float -0.392930
	.float 0.291060
	.float -0.180969
	.float 0.042170
	.float 0.134715
	.float -0.327086
	.float 0.485343
	.float -0.560754
	.float 0.538136
	.float -0.451028
	.float 0.367689
	.float -0.353719
	.float 0.432690
	.float -0.569162
	.float 0.687135
	.float -0.714052
	.float 0.620650
	.float -0.428502
	.float 0.182128
	.float 0.086192
	.float -0.365709
	.float 0.643897
	.float -0.879006
	.float 1.003265
	.float -0.960447
	.float 0.745487
	.float -0.410220
	.float 0.032715
	.float 0.318269
	.float -0.593480
	.float 0.749835
	.float -0.742885
	.float 0.545399
	.float -0.180662
	.float -0.262096
	.float 0.651304
	.float -0.865904
	.float 0.848042
	.float -0.629332
	.float 0.319807
	.float -0.062397
	.float -0.034167
	.float -0.042974
	.float 0.192163
	.float -0.248021
	.float 0.085991
	.float 0.281918
	.float -0.693665
	.float 0.930055
	.float -0.859066
	.float 0.529534
	.float -0.140888
	.float -0.094087
	.float 0.094879
	.float 0.039947
	.float -0.118167
	.float 0.006089
	.float 0.266353
	.float -0.522890
	.float 0.565955
	.float -0.319184
	.float -0.110630
	.float 0.491804
	.float -0.606418
	.float 0.380424
	.float 0.073628
	.float -0.523472
	.float 0.748583
	.float -0.656031
	.float 0.317462
	.float 0.082980
	.float -0.347925
	.float 0.356646
	.float -0.109619
	.float -0.276678
	.float 0.615374
	.float -0.724185
	.float 0.512593
	.float -0.044088
	.float -0.471796
	.float 0.774007
	.float -0.688727
	.float 0.227208
	.float 0.423295
	.float -1.008394
	.float 1.338657
	.float -1.360271
	.float 1.135001
	.float -0.769927
	.float 0.360506
	.float 0.021525
	.float -0.313277
	.float 0.456450
	.float -0.419257
	.float 0.224468
	.float 0.049374
	.float -0.305352
	.float 0.482255
	.float -0.586500
	.float 0.677589
	.float -0.815188
	.float 1.003804
	.float -1.173703
	.float 1.215984
	.float -1.055300
	.float 0.715900
	.float -0.332295
	.float 0.084695
	.float -0.089697
	.float 0.317190
	.float -0.597828
	.float 0.726132
	.float -0.592034
	.float 0.246723
	.float 0.143843
	.float -0.419623
	.float 0.528747
	.float -0.538717
	.float 0.557008
	.float -0.628918
	.float 0.691496
	.float -0.617383
	.float 0.316869
	.float 0.174911
	.float -0.690950
	.float 1.018650
	.float -1.026733
	.float 0.745815
	.float -0.343773
	.float 0.013121
	.float 0.144793
	.float -0.152963
	.float 0.092960
	.float -0.007937
	.float -0.134406
	.float 0.385339
	.float -0.719771
	.float 0.997998
	.float -1.034843
	.float 0.734241
	.float -0.184413
	.float -0.369209
	.float 0.664952
	.float -0.583793
	.float 0.214839
	.float 0.216169
	.float -0.500394
	.float 0.571678
	.float -0.521361
	.float 0.503422
	.float -0.607727
	.float 0.794176
	.float -0.927829
	.float 0.879366
	.float -0.613673
	.float 0.208587
	.float 0.196808
	.float -0.476681
	.float 0.566176
	.float -0.466342
	.float 0.226043
	.float 0.074819
	.float -0.337088
	.float 0.464980
	.float -0.406798
	.float 0.193085
	.float 0.063827
	.float -0.226625
	.float 0.217996
	.float -0.073852
	.float -0.081247
	.float 0.125224
	.float -0.028469
	.float -0.129902
	.float 0.235319
	.float -0.240180
	.float 0.205796
	.float -0.241792
	.float 0.390886
	.float -0.561949
	.float 0.581862
	.float -0.337628
	.float -0.102725
	.float 0.497172
	.float -0.574745
	.float 0.218929
	.float 0.444507
	.float -1.118314
	.float 1.508895
	.float -1.482789
	.float 1.110293
	.float -0.593489
	.float 0.149634
	.float 0.076200
	.float -0.044643
	.float -0.180519
	.float 0.453422
	.float -0.590577
	.float 0.445300
	.float 0.011858
	.float -0.657822
	.float 1.262500
	.float -1.596631
	.float 1.537779
	.float -1.115643
	.float 0.485560
	.float 0.137467
	.float -0.547816
	.float 0.607431
	.float -0.292603
	.float -0.283622
	.float 0.901049
	.float -1.323075
	.float 1.411365
	.float -1.194298
	.float 0.838838
	.float -0.542550
	.float 0.420151
	.float -0.459401
	.float 0.564745
	.float -0.641099
	.float 0.648923
	.float -0.597620
	.float 0.500290
	.float -0.343776
	.float 0.106837
	.float 0.189861
	.float -0.454876
	.float 0.558433
	.float -0.414184
	.float 0.049138
	.float 0.398676
	.float -0.759707
	.float 0.930961
	.float -0.918920
	.float 0.803302
	.float -0.665068
	.float 0.544573
	.float -0.453675
	.float 0.406122
	.float -0.415623
	.float 0.456343
	.float -0.436555
	.float 0.238349
	.float 0.184850
	.float -0.729508
	.float 1.164168
	.float -1.260875
	.float 0.950626
	.float -0.385938
	.float -0.143688
	.float 0.387309
	.float -0.274333
	.float -0.073643
	.float 0.455681
	.float -0.732507
	.float 0.890826
	.float -0.998505
	.float 1.107957
	.float -1.195138
	.float 1.178665
	.float -0.992472
	.float 0.648493
	.float -0.244381
	.float -0.082069
	.float 0.217894
	.float -0.124500
	.float -0.145714
	.float 0.467376
	.float -0.688497
	.float 0.691779
	.float -0.448516
	.float 0.038751
	.float 0.378841
	.float -0.638774
	.float 0.648070
	.float -0.429304
	.float 0.102275
	.float 0.185146
	.float -0.334829
	.float 0.338614
	.float -0.261235
	.float 0.184377
	.float -0.151762
	.float 0.148229
	.float -0.118152
	.float 0.005646
	.float 0.207340
	.float -0.481173
	.float 0.721738
	.float -0.806479
	.float 0.628745
	.float -0.150902
	.float -0.553756
	.float 1.296575
	.float -1.825397
	.float 1.925970
	.float -1.531240
	.float 0.776123
	.float 0.047639
	.float -0.626879
	.float 0.781342
	.float -0.544958
	.float 0.124380
	.float 0.233508
	.float -0.375071
	.float 0.292406
	.float -0.080558
	.float -0.146320
	.float 0.310914
	.float -0.374839
	.float 0.316153
	.float -0.126433
	.float -0.162715
	.float 0.457851
	.float -0.627398
	.float 0.572220
	.float -0.294721
	.float -0.092070
	.float 0.432341
	.float -0.626807
	.float 0.688640
	.float -0.712332
	.float 0.780764
	.float -0.886940
	.float 0.936997
	.float -0.834600
	.float 0.578569
	.float -0.289925
	.float 0.137866
	.float -0.216204
	.float 0.466014
	.float -0.710323
	.float 0.781202
	.float -0.644097
	.float 0.420413
	.float -0.286195
	.float 0.326385
	.float -0.465937
	.float 0.539501
	.float -0.442734
	.float 0.232733
	.float -0.082209
	.float 0.120876
	.float -0.303039
	.float 0.427638
	.float -0.306571
	.float -0.056470
	.float 0.434147
	.float -0.531066
	.float 0.211589
	.float 0.379500
	.float -0.900227
	.float 1.038166
	.float -0.712439
	.float 0.109444
	.float 0.458590
	.float -0.754825
	.float 0.732766
	.float -0.502036
	.float 0.200837
	.float 0.108487
	.float -0.442090
	.float 0.811987
	.float -1.146390
	.float 1.294570
	.float -1.124546
	.float 0.640622
	.float -0.026106
	.float -0.434680
	.float 0.514328
	.float -0.180579
	.float -0.375292
	.float 0.840281
	.float -0.950388
	.float 0.630491
	.float -0.027214
	.float -0.575680
	.float 0.905368
	.float -0.831160
	.float 0.415224
	.float 0.134602
	.float -0.576449
	.float 0.749042
	.float -0.633213
	.float 0.338861
	.float -0.038285
	.float -0.113513
	.float 0.038005
	.float 0.240080
	.float -0.599232
	.float 0.864255
	.float -0.884159
	.float 0.619377
	.float -0.185870
	.float -0.190743
	.float 0.302312
	.float -0.089947
	.float -0.315143
	.float 0.679028
	.float -0.820297
	.float 0.717491
	.float -0.491521
	.float 0.287413
	.float -0.160998
	.float 0.064968
	.float 0.062773
	.float -0.198649
	.float 0.222456
	.float -0.017479
	.float -0.399937
	.float 0.839535
	.float -1.038875
	.float 0.846182
	.float -0.349567
	.float -0.152623
	.float 0.333905
	.float -0.055201
	.float -0.534383
	.float 1.083618
	.float -1.256876
	.float 0.939849
	.float -0.301439
	.float -0.320537
	.float 0.626825
	.float -0.523245
	.float 0.152602
	.float 0.210077
	.float -0.323136
	.float 0.110223
	.float 0.304693
	.float -0.668883
	.float 0.742602
	.float -0.440582
	.float -0.105580
	.float 0.612528
	.float -0.812383
	.float 0.620847
	.float -0.188275
	.float -0.208561
	.float 0.356801
	.float -0.236543
	.float -0.004283
	.float 0.193790
	.float -0.269477
	.float 0.293410
	.float -0.354750
	.float 0.462390
	.float -0.527477
	.float 0.444009
	.float -0.187961
	.float -0.152634
	.float 0.435524
	.float -0.555485
	.float 0.498176
	.float -0.328409
	.float 0.138626
	.float -0.001512
	.float -0.049211
	.float 0.016099
	.float 0.070226
	.float -0.158343
	.float 0.188549
	.float -0.115575
	.float -0.066932
	.float 0.316618
	.float -0.556993
	.float 0.709989
	.float -0.728102
	.float 0.610662
	.float -0.401040
	.float 0.171106
	.float 0.000341
	.float -0.052052
	.float -0.034989
	.float 0.221019
	.float -0.412276
	.float 0.495569
	.float -0.395359
	.float 0.125885
	.float 0.196317
	.float -0.399872
	.float 0.351305
	.float -0.043563
	.float -0.377786
	.float 0.677809
	.float -0.656314
	.float 0.261364
	.float 0.375900
	.float -1.005172
	.float 1.378988
	.float -1.363323
	.float 0.983984
	.float -0.399353
	.float -0.174532
	.float 0.550808
	.float -0.640503
	.float 0.481981
	.float -0.216366
	.float 0.011607
	.float 0.032234
	.float 0.057477
	.float -0.145266
	.float 0.080473
	.float 0.193815
	.float -0.590470
	.float 0.923352
	.float -1.018387
	.float 0.815647
	.float -0.396030
	.float -0.078113
	.float 0.459240
	.float -0.678984
	.float 0.745183
	.float -0.693206
	.float 0.545080
	.float -0.311697
	.float 0.025138
	.float 0.244514
	.float -0.416884
	.float 0.454676
	.float -0.391473
	.float 0.300327
	.float -0.224548
	.float 0.132836
	.float 0.052411
	.float -0.366139
	.float 0.723056
	.float -0.927504
	.float 0.786137
	.float -0.255714
	.float -0.482443
	.float 1.090992
	.float -1.261358
	.float 0.901315
	.float -0.199997
	.float -0.479107
	.float 0.813111
	.float -0.706073
	.float 0.329544
	.float 0.002521
	.float -0.036018
	.float -0.275903
	.float 0.766055
	.float -1.173703
	.float 1.301118
	.float -1.109131
	.float 0.711551
	.float -0.296669
	.float 0.032498
	.float 0.001902
	.float 0.156248
	.float -0.370881
	.float 0.470047
	.float -0.340289
	.float 0.007882
	.float 0.353880
	.float -0.520110
	.float 0.368675
	.float 0.009904
	.float -0.340116
	.float 0.331392
	.float 0.114064
	.float -0.803257
	.float 1.348740
	.float -1.410277
	.float 0.923021
	.float -0.153809
	.float -0.459001
	.float 0.577016
	.float -0.164369
	.float -0.506265
	.float 1.034151
	.float -1.127109
	.float 0.744771
	.float -0.080560
	.float -0.574485
	.float 0.983379
	.float -1.048749
	.float 0.815239
	.float -0.421942
	.float 0.043052
	.float 0.168540
	.float -0.135186
	.float -0.103935
	.float 0.393470
	.float -0.527892
	.float 0.365802
	.float 0.071441
	.float -0.588985
	.float 0.917964
	.float -0.872055
	.float 0.462974
	.float 0.100467
	.float -0.530404
	.float 0.620498
	.float -0.350962
	.float -0.120872
	.float 0.569773
	.float -0.836731
	.float 0.902805
	.float -0.860661
	.float 0.812064
	.float -0.770636
	.float 0.644875
	.float -0.317572
	.float -0.237059
	.float 0.891196
	.float -1.412703
	.float 1.600133
	.float -1.409538
	.float 0.980297
	.float -0.538931
	.float 0.249416
	.float -0.116896
	.float 0.010163
	.float 0.220817
	.float -0.622364
	.float 1.095891
	.float -1.457977
	.float 1.549033
	.float -1.314193
	.float 0.814356
	.float -0.181988
	.float -0.433685
	.float 0.900868
	.float -1.121539
	.float 1.049712
	.float -0.716058
	.float 0.236502
	.float 0.222141
	.float -0.515791
	.float 0.592827
	.float -0.507192
	.float 0.360261
	.float -0.214976
	.float 0.051753
	.float 0.194622
	.float -0.544490
	.float 0.904486
	.float -1.085797
	.float 0.912280
	.float -0.352592
	.float -0.416130
	.float 1.070256
	.float -1.306265
	.float 1.018089
	.float -0.372198
	.float -0.278218
	.float 0.598606
	.float -0.472410
	.float 0.064772
	.float 0.294717
	.float -0.335634
	.float 0.027552
	.float 0.404286
	.float -0.640845
	.float 0.499342
	.float -0.071180
	.float -0.333970
	.float 0.406831
	.float -0.069323
	.float -0.451610
	.float 0.770114
	.float -0.609664
	.float 0.000265
	.float 0.740301
	.float -1.225533
	.float 1.256199
	.float -0.928970
	.float 0.533081
	.float -0.328495
	.float 0.374588
	.float -0.522148
	.float 0.552892
	.float -0.351665
	.float -0.008762
	.float 0.316371
	.float -0.356792
	.float 0.047947
	.float 0.504045
	.float -1.050827
	.float 1.320309
	.float -1.148884
	.float 0.566790
	.float 0.205723
	.float -0.857529
	.float 1.140306
	.float -0.997089
	.float 0.586258
	.float -0.178203
	.float -0.013550
	.float -0.046493
	.float 0.224940
	.float -0.345186
	.float 0.327601
	.float -0.236044
	.float 0.201701
	.float -0.294285
	.float 0.448876
	.float -0.507380
	.float 0.341842
	.float 0.035631
	.float -0.460086
	.float 0.710794
	.float -0.653325
	.float 0.330254
	.float 0.061979
	.float -0.296011
	.float 0.255558
	.float -0.002352
	.float -0.274504
	.float 0.388939
	.float -0.276486
	.float 0.023393
	.float 0.205188
	.float -0.278140
	.float 0.171365
	.float 0.042040
	.float -0.262822
	.float 0.435119
	.float -0.562471
	.float 0.667744
	.float -0.740733
	.float 0.726775
	.float -0.572840
	.float 0.293855
	.float 0.003321
	.float -0.173234
	.float 0.133182
	.float 0.064761
	.float -0.255535
	.float 0.270813
	.float -0.057896
	.float -0.282568
	.float 0.568638
	.float -0.662683
	.float 0.557523
	.float -0.367435
	.float 0.243992
	.float -0.284678
	.float 0.489864
	.float -0.775822
	.float 1.015228
	.float -1.079517
	.float 0.879131
	.float -0.404199
	.float -0.248220
	.float 0.890889
	.float -1.320860
	.float 1.421043
	.float -1.224108
	.float 0.888925
	.float -0.600702
	.float 0.464950
	.float -0.468858
	.float 0.527933
	.float -0.567520
	.float 0.569281
	.float -0.554773
	.float 0.540055
	.float -0.515767
	.float 0.471161
	.float -0.427900
	.float 0.437309
	.float -0.535838
	.float 0.701656
	.float -0.860697
	.float 0.942222
	.float -0.932604
	.float 0.873826
	.float -0.805031
	.float 0.703584
	.float -0.488332
	.float 0.094211
	.float 0.439682
	.float -0.947887
	.float 1.215837
	.float -1.112517
	.float 0.686655
	.float -0.154061
	.float -0.222283
	.float 0.284578
	.float -0.069125
	.float -0.220447
	.float 0.335064
	.float -0.123089
	.float -0.384683
	.float 0.989650
	.float -1.428488
	.float 1.510692
	.float -1.218773
	.float 0.715599
	.float -0.250416
	.float 0.015088
	.float -0.037695
	.float 0.181996
	.float -0.253172
	.float 0.138534
	.float 0.111836
	.float -0.316803
	.float 0.284937
	.float 0.055405
	.float -0.597670
	.float 1.104413
	.float -1.331831
	.float 1.161188
	.float -0.664230
	.float 0.066221
	.float 0.373402
	.float -0.495962
	.float 0.317521
	.float -0.002484
	.float -0.241340
	.float 0.277945
	.float -0.101120
	.float -0.187762
	.float 0.452662
	.float -0.593224
	.float 0.575999
	.float -0.424532
	.float 0.191162
	.float 0.067120
	.float -0.299144
	.float 0.459383
	.float -0.506131
	.float 0.407174
	.float -0.157175
	.float -0.200330
	.float 0.567234
	.float -0.820487
	.float 0.873569
	.float -0.733902
	.float 0.510042
	.float -0.352345
	.float 0.361561
	.float -0.528181
	.float 0.745812
	.float -0.885920
	.float 0.878577
	.float -0.744375
	.float 0.562230
	.float -0.402387
	.float 0.273805
	.float -0.122298
	.float -0.117287
	.float 0.446623
	.float -0.760046
	.float 0.874386
	.float -0.632321
	.float 0.024013
	.float 0.757307
	.float -1.380488
	.float 1.540703
	.float -1.129124
	.float 0.301385
	.float 0.601688
	.float -1.234203
	.float 1.416065
	.float -1.194959
	.float 0.773503
	.float -0.362923
	.float 0.065417
	.float 0.142891
	.float -0.334653
	.float 0.533102
	.float -0.675356
	.float 0.664954
	.float -0.466777
	.float 0.162104
	.float 0.088425
	.float -0.153076
	.float 0.029034
	.float 0.143489
	.float -0.170311
	.float -0.063102
	.float 0.505139
	.float -0.958337
	.float 1.192977
	.float -1.080083
	.float 0.662201
	.float -0.125162
	.float -0.304669
	.float 0.474798
	.float -0.372487
	.float 0.114074
	.float 0.129690
	.float -0.230077
	.float 0.168007
	.float -0.037182
	.float -0.019304
	.float -0.096875
	.float 0.370934
	.float -0.676045
	.float 0.847198
	.float -0.783297
	.float 0.513436
	.float -0.184044
	.float -0.026392
	.float 0.012255
	.float 0.197720
	.float -0.456843
	.float 0.580932
	.float -0.445124
	.float 0.046787
	.float 0.491730
	.float -0.975868
	.float 1.221214
	.float -1.131326
	.float 0.739457
	.float -0.194806
	.float -0.302878
	.float 0.589894
	.float -0.602570
	.float 0.387395
	.float -0.060767
	.float -0.249565
	.float 0.446298
	.float -0.477093
	.float 0.335702
	.float -0.064857
	.float -0.243440
	.float 0.470530
	.float -0.524732
	.float 0.401097
	.float -0.200752
	.float 0.079366
	.float -0.145744
	.float 0.377765
	.float -0.623079
	.float 0.695621
	.float -0.506376
	.float 0.134672
	.float 0.215157
	.float -0.343666
	.float 0.180377
	.float 0.183244
	.float -0.566325
	.float 0.814041
	.float -0.871686
	.float 0.778162
	.float -0.606257
	.float 0.408083
	.float -0.201384
	.float -0.012665
	.float 0.229709
	.float -0.435685
	.float 0.604785
	.float -0.692554
	.float 0.636425
	.float -0.383858
	.float -0.054402
	.float 0.566262
	.float -0.962867
	.float 1.070647
	.float -0.835935
	.float 0.364556
	.float 0.138675
	.float -0.490949
	.float 0.627249
	.float -0.606987
	.float 0.538049
	.float -0.485471
	.float 0.435414
	.float -0.333500
	.float 0.155545
	.float 0.052412
	.float -0.196532
	.float 0.200027
	.float -0.059633
	.float -0.147649
	.float 0.311572
	.float -0.358753
	.float 0.301182
	.float -0.230844
	.float 0.259471
	.float -0.437855
	.float 0.707915
	.float -0.925358
	.float 0.944427
	.float -0.711626
	.float 0.306124
	.float 0.098986
	.float -0.328892
	.float 0.296918
	.float -0.044508
	.float -0.284979
	.float 0.522747
	.float -0.564194
	.float 0.426174
	.float -0.236906
	.float 0.155899
	.float -0.266327
	.float 0.508697
	.float -0.707247
	.float 0.682259
	.float -0.379566
	.float -0.072028
	.float 0.425972
	.float -0.475933
	.float 0.205283
	.float 0.182813
	.float -0.395624
	.float 0.264486
	.float 0.113258
	.float -0.427349
	.float 0.385357
	.float 0.044453
	.float -0.574098
	.float 0.787631
	.float -0.454140
	.float -0.273669
	.float 0.933796
	.float -1.058236
	.float 0.491172
	.float 0.501076
	.float -1.397226
	.float 1.742293
	.float -1.406051
	.float 0.624799
	.float 0.171521
	.float -0.611708
	.float 0.555935
	.float -0.109719
	.float -0.487652
	.float 1.004060
	.float -1.303082
	.float 1.356718
	.float -1.209930
	.float 0.937256
	.float -0.614114
	.float 0.303930
	.float -0.052260
	.float -0.116004
	.float 0.194703
	.float -0.188092
	.float 0.101255
	.float 0.060981
	.float -0.281140
	.float 0.512197
	.float -0.678015
	.float 0.704511
	.float -0.568918
	.float 0.329917
	.float -0.106524
	.float 0.009304
	.float -0.068349
	.float 0.211620
	.float -0.313590
	.float 0.283465
	.float -0.131584
	.float -0.034163
	.float 0.082264
	.float 0.046988
	.float -0.290369
	.float 0.492815
	.float -0.502790
	.float 0.268858
	.float 0.127451
	.float -0.523045
	.float 0.770487
	.float -0.814580
	.float 0.701772
	.float -0.527334
	.float 0.367641
	.float -0.248357
	.float 0.165361
	.float -0.130152
	.float 0.189768
	.float -0.391103
	.float 0.709462
	.float -1.006099
	.float 1.073994
	.float -0.768386
	.float 0.137608
	.float 0.555467
	.float -0.967222
	.float 0.888290
	.float -0.391061
	.float -0.203718
	.float 0.525379
	.float -0.380785
	.float -0.141657
	.float 0.748583
	.float -1.127452
	.float 1.109015
	.float -0.715813
	.float 0.102012
	.float 0.541420
	.float -1.048264
	.float 1.296263
	.float -1.220684
	.float 0.848435
	.float -0.326761
	.float -0.109867
	.float 0.254459
	.float -0.063846
	.float -0.289910
	.float 0.514885
	.float -0.392036
	.float -0.068000
	.float 0.618102
	.float -0.922849
	.float 0.757447
	.float -0.130193
	.float -0.732206
	.float 1.504150
	.float -1.905905
	.float 1.807979
	.float -1.268142
	.float 0.504078
	.float 0.187040
	.float -0.543167
	.float 0.449231
	.float 0.006606
	.float -0.573657
	.float 0.969147
	.float -1.029832
	.float 0.790748
	.float -0.437843
	.float 0.169463
	.float -0.069052
	.float 0.081355
	.float -0.097848
	.float 0.067672
	.float -0.034819
	.float 0.075083
	.float -0.198977
	.float 0.316550
	.float -0.301650
	.float 0.101778
	.float 0.202075
	.float -0.440367
	.float 0.473790
	.float -0.296224
	.float 0.043979
	.float 0.096195
	.float -0.014602
	.float -0.248070
	.float 0.530833
	.float -0.661715
	.float 0.567526
	.float -0.309271
	.float 0.025346
	.float 0.168398
	.float -0.247450
	.float 0.272662
	.float -0.325378
	.float 0.437899
	.float -0.566858
	.float 0.619392
	.float -0.508265
	.float 0.204601
	.float 0.234305
	.float -0.673115
	.float 0.946558
	.float -0.936278
	.float 0.641725
	.float -0.197441
	.float -0.188345
	.float 0.346992
	.float -0.243256
	.float -0.014664
	.float 0.255853
	.float -0.358899
	.float 0.317113
	.float -0.216530
	.float 0.152430
	.float -0.151786
	.float 0.159735
	.float -0.098077
	.float -0.050287
	.float 0.198326
	.float -0.193795
	.float -0.078091
	.float 0.596606
	.float -1.183949
	.float 1.583130
	.float -1.591499
	.float 1.170108
	.float -0.468068
	.float -0.245319
	.float 0.699734
	.float -0.737645
	.float 0.377119
	.float 0.199784
	.float -0.730739
	.float 0.995533
	.float -0.917695
	.float 0.587045
	.float -0.187788
	.float -0.120255
	.float 0.286584
	.float -0.367733
	.float 0.453654
	.float -0.590547
	.float 0.760750
	.float -0.921576
	.float 1.053316
	.float -1.166028
	.float 1.261185
	.float -1.293497
	.float 1.181175
	.float -0.870750
	.float 0.408029
	.float 0.047563
	.float -0.292625
	.float 0.197939
	.float 0.201121
	.float -0.706589
	.float 1.058165
	.float -1.072993
	.float 0.739293
	.float -0.208410
	.float -0.304565
	.float 0.643647
	.float -0.780746
	.float 0.794420
	.float -0.785953
	.float 0.798626
	.float -0.795636
	.float 0.702982
	.float -0.476148
	.float 0.139045
	.float 0.226608
	.float -0.523394
	.float 0.677502
	.float -0.655846
	.float 0.466908
	.float -0.159307
	.float -0.181089
	.float 0.446996
	.float -0.545733
	.float 0.441473
	.float -0.177060
	.float -0.142508
	.float 0.397168
	.float -0.502513
	.float 0.438674
	.float -0.249187
	.float 0.017989
	.float 0.162874
	.float -0.225270
	.float 0.150380
	.float 0.020695
	.float -0.199525
	.float 0.287438
	.float -0.224147
	.float 0.023744
	.float 0.224893
	.float -0.399442
	.float 0.409430
	.float -0.251283
	.float 0.019118
	.float 0.140911
	.float -0.113113
	.float -0.113868
	.float 0.428517
	.float -0.651295
	.float 0.637412
	.float -0.369328
	.float -0.018338
	.float 0.301716
	.float -0.288083
	.float -0.071964
	.float 0.645829
	.float -1.179926
	.float 1.430789
	.float -1.292784
	.float 0.847961
	.float -0.308523
	.float -0.110359
	.float 0.305599
	.float -0.318582
	.float 0.273142
	.float -0.271183
	.float 0.321757
	.float -0.348259
	.float 0.260598
	.float -0.035316
	.float -0.254750
	.float 0.482252
	.float -0.549461
	.float 0.455550
	.float -0.297948
	.float 0.204380
	.float -0.242800
	.float 0.374186
	.float -0.482103
	.float 0.455740
	.float -0.264590
	.float -0.026467
	.float 0.304848
	.float -0.479456
	.float 0.522664
	.float -0.464891
	.float 0.357954
	.float -0.240020
	.float 0.125911
	.float -0.023135
	.float -0.046278
	.float 0.042969
	.float 0.062867
	.float -0.250952
	.float 0.432260
	.float -0.481092
	.float 0.310923
	.float 0.052736
	.float -0.459168
	.float 0.701251
	.float -0.630903
	.float 0.249766
	.float 0.284500
	.float -0.742283
	.float 0.945706
	.float -0.857302
	.float 0.582518
	.float -0.288825
	.float 0.096264
	.float -0.011848
	.float -0.048882
	.float 0.170221
	.float -0.344369
	.float 0.453949
	.float -0.350584
	.float -0.024304
	.float 0.569359
	.float -1.063741
	.float 1.294894
	.float -1.183303
	.float 0.818174
	.float -0.389058
	.float 0.074410
	.float 0.033557
	.float 0.065856
	.float -0.318445
	.float 0.645307
	.float -0.948504
	.float 1.114913
	.float -1.047402
	.float 0.719721
	.float -0.214288
	.float -0.297918
	.float 0.636589
	.float -0.704264
	.float 0.531269
	.float -0.245237
	.float -0.009662
	.float 0.145346
	.float -0.148150
	.float 0.043872
	.float 0.147000
	.float -0.417170
	.float 0.736501
	.float -1.012993
	.float 1.103474
	.float -0.888910
	.float 0.369808
	.float 0.292172
	.float -0.832615
	.float 1.019451
	.float -0.783363
	.float 0.259734
	.float 0.286203
	.float -0.604919
	.float 0.590216
	.float -0.316314
	.float -0.028376
	.float 0.261622
	.float -0.306038
	.float 0.211859
	.float -0.101070
	.float 0.077722
	.float -0.164674
	.float 0.303403
	.float -0.408822
	.float 0.435140
	.float -0.404223
	.float 0.376538
	.float -0.387953
	.float 0.404378
	.float -0.337568
	.float 0.120688
	.float 0.210606
	.float -0.504850
	.float 0.581260
	.float -0.368934
	.float -0.006950
	.float 0.275660
	.float -0.193340
	.float -0.279541
	.float 0.931093
	.float -1.425749
	.float 1.519884
	.float -1.212088
	.float 0.726626
	.float -0.354479
	.float 0.273009
	.float -0.464676
	.float 0.768287
	.float -1.002269
	.float 1.065833
	.float -0.964027
	.float 0.768833
	.float -0.566122
	.float 0.425614
	.float -0.393967
	.float 0.489050
	.float -0.683952
	.float 0.896474
	.float -1.010036
	.float 0.930318
	.float -0.646914
	.float 0.253523
	.float 0.096539
	.float -0.275200
	.float 0.249076
	.float -0.086886
	.float -0.095883
	.float 0.210820
	.float -0.236525
	.float 0.205609
	.float -0.163015
	.float 0.136350
	.float -0.135322
	.float 0.162988
	.float -0.212576
	.float 0.250217
	.float -0.213836
	.float 0.051924
	.float 0.217870
	.float -0.486833
	.float 0.609214
	.float -0.504051
	.float 0.222293
	.float 0.084742
	.float -0.275135
	.float 0.311152
	.float -0.257430
	.float 0.192823
	.float -0.129057
	.float 0.020658
	.float 0.145459
	.float -0.281256
	.float 0.239386
	.float 0.052017
	.float -0.481569
	.float 0.788632
	.float -0.736688
	.float 0.297539
	.float 0.303278
	.float -0.723914
	.float 0.726668
	.float -0.322278
	.float -0.255524
	.float 0.708654
	.float -0.843798
	.float 0.645435
	.float -0.234654
	.float -0.226038
	.float 0.608165
	.float -0.842766
	.float 0.913368
	.float -0.844719
	.float 0.694640
	.float -0.536714
	.float 0.428234
	.float -0.380791
	.float 0.359161
	.float -0.314565
	.float 0.226396
	.float -0.116181
	.float 0.020805
	.float 0.049374
	.float -0.125598
	.float 0.249604
	.float -0.421197
	.float 0.575597
	.float -0.621064
	.float 0.515234
	.float -0.317369
	.float 0.163422
	.float -0.169681
	.float 0.334662
	.float -0.520679
	.float 0.541238
	.float -0.297650
	.float -0.135794
	.float 0.545584
	.float -0.713164
	.float 0.557646
	.float -0.188907
	.float -0.162600
	.float 0.290093
	.float -0.135327
	.float -0.179798
	.float 0.426153
	.float -0.396104
	.float 0.016272
	.float 0.610451
	.float -1.248250
	.float 1.633169
	.float -1.591231
	.float 1.117291
	.float -0.378335
	.float -0.362571
	.float 0.865302
	.float -1.014075
	.float 0.849600
	.float -0.521549
	.float 0.199691
	.float -0.001012
	.float -0.031990
	.float -0.090175
	.float 0.332534
	.float -0.644371
	.float 0.952737
	.float -1.166442
	.float 1.206243
	.float -1.047232
	.float 0.739749
	.float -0.385655
	.float 0.080170
	.float 0.141057
	.float -0.310317
	.float 0.483873
	.float -0.679192
	.float 0.845854
	.float -0.899362
	.float 0.795755
	.float -0.585239
	.float 0.392248
	.float -0.327339
	.float 0.397645
	.float -0.491211
	.float 0.454554
	.float -0.205924
	.float -0.202939
	.float 0.620543
	.float -0.891181
	.float 0.935641
	.float -0.765313
	.float 0.441097
	.float -0.028491
	.float -0.414214
	.float 0.824123
	.float -1.132602
	.float 1.290552
	.float -1.297070
	.float 1.197323
	.float -1.045051
	.float 0.865957
	.float -0.660511
	.float 0.444695
	.float -0.281283
	.float 0.255779
	.float -0.403415
	.float 0.649778
	.float -0.829551
	.float 0.787771
	.float -0.494871
	.float 0.085384
	.float 0.218228
	.float -0.251056
	.float 0.022196
	.float 0.279472
	.float -0.397380
	.float 0.167740
	.float 0.372427
	.float -0.996147
	.float 1.407771
	.float -1.401387
	.float 0.965532
	.float -0.282202
	.float -0.369375
	.float 0.746059
	.float -0.743260
	.float 0.423724
	.float 0.031535
	.float -0.419358
	.float 0.608346
	.float -0.585540
	.float 0.437178
	.float -0.280693
	.float 0.191234
	.float -0.164252
	.float 0.131245
	.float -0.013836
	.float -0.217684
	.float 0.514700
	.float -0.767211
	.float 0.860363
	.float -0.740554
	.float 0.450724
	.float -0.108261
	.float -0.166381
	.float 0.326910
	.float -0.430559
	.float 0.594317
	.float -0.902024
	.float 1.323999
	.float -1.708554
	.float 1.860003
	.float -1.659483
	.float 1.151978
	.float -0.539715
	.float 0.080562
	.float 0.049045
	.float 0.155289
	.float -0.534002
	.float 0.860485
	.float -0.965067
	.float 0.812732
	.float -0.495437
	.float 0.154903
	.float 0.105612
	.float -0.261181
	.float 0.336966
	.float -0.347526
	.float 0.264675
	.float -0.049418
	.float -0.278508
	.float 0.603089
	.float -0.758699
	.float 0.641823
	.float -0.303337
	.float -0.060817
	.float 0.227130
	.float -0.089281
	.float -0.275611
	.float 0.663378
	.float -0.872338
	.float 0.809567
	.float -0.511672
	.float 0.092971
	.float 0.319840
	.float -0.623344
	.float 0.746855
	.float -0.663119
	.float 0.408133
	.float -0.086470
	.float -0.163948
	.float 0.239741
	.float -0.129802
	.float -0.079634
	.float 0.257999
	.float -0.305620
	.float 0.203979
	.float -0.015513
	.float -0.158556
	.float 0.232393
	.float -0.173262
	.float 0.009367
	.float 0.187835
	.float -0.335008
	.float 0.370687
	.float -0.284346
	.float 0.131581
	.float -0.021077
	.float 0.063371
	.float -0.294861
	.float 0.621967
	.float -0.838403
	.float 0.730602
	.float -0.219929
	.float -0.553297
	.float 1.275927
	.float -1.626197
	.float 1.459237
	.float -0.893780
	.float 0.240848
	.float 0.182624
	.float -0.236901
	.float 0.022771
	.float 0.213157
	.float -0.263332
	.float 0.104942
	.float 0.097245
	.float -0.132271
	.float -0.078205
	.float 0.402450
	.float -0.587301
	.float 0.450617
	.float -0.032007
	.float -0.413668
	.float 0.578619
	.float -0.304434
	.float -0.314657
	.float 0.989548
	.float -1.404650
	.float 1.383516
	.float -0.958936
	.float 0.327732
	.float 0.261913
	.float -0.620784
	.float 0.678751
	.float -0.485101
	.float 0.168959
	.float 0.113154
	.float -0.225610
	.float 0.093902
	.float 0.263566
	.float -0.723241
	.float 1.084381
	.float -1.147781
	.float 0.820756
	.float -0.188650
	.float -0.505261
	.float 0.977272
	.float -1.054365
	.float 0.762380
	.float -0.294073
	.float -0.117239
	.float 0.329002
	.float -0.341103
	.float 0.249367
	.float -0.153978
	.float 0.097516
	.float -0.069433
	.float 0.054219
	.float -0.069264
	.float 0.155433
	.float -0.330522
	.float 0.550239
	.float -0.716573
	.float 0.735356
	.float -0.583743
	.float 0.337300
	.float -0.132339
	.float 0.083929
	.float -0.211896
	.float 0.424145
	.float -0.571830
	.float 0.544091
	.float -0.342259
	.float 0.082012
	.float 0.082346
	.float -0.063160
	.float -0.098556
	.float 0.260362
	.float -0.276163
	.float 0.094092
	.float 0.214030
	.float -0.505738
	.float 0.656725
	.float -0.622492
	.float 0.442615
	.float -0.204311
	.float -0.000561
	.float 0.106167
	.float -0.092606
	.float -0.003226
	.float 0.097525
	.float -0.101162
	.float -0.020607
	.float 0.210194
	.float -0.337899
	.float 0.277417
	.float 0.010672
	.float -0.444933
	.float 0.861910
	.float -1.101334
	.float 1.085022
	.float -0.848542
	.float 0.517701
	.float -0.248794
	.float 0.158779
	.float -0.270441
	.float 0.494937
	.float -0.666570
	.float 0.624909
	.float -0.308082
	.float -0.196599
	.float 0.683639
	.float -0.934034
	.float 0.837631
	.float -0.460813
	.float 0.016706
	.float 0.248698
	.float -0.190197
	.float -0.160011
	.float 0.617315
	.float -0.954224
	.float 1.024423
	.float -0.823256
	.float 0.453326
	.float -0.034655
	.float -0.361495
	.float 0.703170
	.float -0.935647
	.float 0.948355
	.float -0.632846
	.float 0.004570
	.float 0.721428
	.float -1.201245
	.float 1.167268
	.float -0.627219
	.float -0.107802
	.float 0.614716
	.float -0.643048
	.float 0.280630
	.float 0.127962
	.float -0.249054
	.float 0.008154
	.float 0.367295
	.float -0.534529
	.float 0.301197
	.float 0.230237
	.float -0.736972
	.float 0.901261
	.float -0.616543
	.float 0.036192
	.float 0.548925
	.float -0.899324
	.float 0.950114
	.float -0.804843
	.float 0.633439
	.float -0.560874
	.float 0.612838
	.float -0.728519
	.float 0.809629
	.float -0.772418
	.float 0.587856
	.float -0.304079
	.float 0.040282
	.float 0.059273
	.float 0.098305
	.float -0.487140
	.float 0.953380
	.float -1.283324
	.float 1.315564
	.float -1.027785
	.float 0.541551
	.float -0.043106
	.float -0.323345
	.float 0.516289
	.float -0.576476
	.float 0.555041
	.float -0.459314
	.float 0.265340
	.float 0.017453
	.float -0.297900
	.float 0.431292
	.float -0.318508
	.float -0.000009
	.float 0.340936
	.float -0.485557
	.float 0.329074
	.float 0.036595
	.float -0.372261
	.float 0.444340
	.float -0.178946
	.float -0.287585
	.float 0.696419
	.float -0.835074
	.float 0.675213
	.float -0.386382
	.float 0.214779
	.float -0.308327
	.float 0.609151
	.float -0.890203
	.float 0.911055
	.float -0.582708
	.float 0.025948
	.float 0.513746
	.float -0.827462
	.float 0.865001
	.float -0.738748
	.float 0.619756
	.float -0.608698
	.float 0.671360
	.float -0.674400
	.float 0.487965
	.float -0.083428
	.float -0.434484
	.float 0.877289
	.float -1.072590
	.float 0.956388
	.float -0.606609
	.float 0.199273
	.float 0.087044
	.float -0.162792
	.float 0.060973
	.float 0.104694
	.float -0.223794
	.float 0.253234
	.float -0.216855
	.float 0.148916
	.float -0.038960
	.float -0.164693
	.float 0.487724
	.float -0.857564
	.float 1.102052
	.float -1.044517
	.float 0.637546
	.float -0.032880
	.float -0.480106
	.float 0.639883
	.float -0.374219
	.float -0.153171
	.float 0.642553
	.float -0.834707
	.float 0.647069
	.float -0.189701
	.float -0.329536
	.float 0.730349
	.float -0.932136
	.float 0.945420
	.float -0.819182
	.float 0.601000
	.float -0.335160
	.float 0.077745
	.float 0.107050
	.float -0.176877
	.float 0.138370
	.float -0.036822
	.float -0.089354
	.float 0.246455
	.float -0.471293
	.float 0.767915
	.float -1.052526
	.float 1.171226
	.float -0.999509
	.float 0.556364
	.float -0.036069
	.float -0.288371
	.float 0.237944
	.float 0.144082
	.float -0.608102
	.float 0.859356
	.float -0.757286
	.float 0.414294
	.float -0.121449
	.float 0.149795
	.float -0.562897
	.float 1.169774
	.float -1.649910
	.float 1.762503
	.float -1.493328
	.float 1.038383
	.float -0.642845
	.float 0.421194
	.float -0.294843
	.float 0.089354
	.float 0.294557
	.float -0.777619
	.float 1.148282
	.float -1.216303
	.float 0.949288
	.float -0.489608
	.float 0.051110
	.float 0.214998
	.float -0.286004
	.float 0.233309
	.float -0.136791
	.float 0.025255
	.float 0.116095
	.float -0.293876
	.float 0.469212
	.float -0.574891
	.float 0.573439
	.float -0.501804
	.float 0.455353
	.float -0.515705
	.float 0.678069
	.float -0.841222
	.float 0.875638
	.float -0.720958
	.float 0.436844
	.float -0.164514
	.float 0.026561
	.float -0.042533
	.float 0.126226
	.float -0.164618
	.float 0.110635
	.float -0.010695
	.float -0.056010
	.float 0.071157
	.float -0.116198
	.float 0.312454
	.float -0.703909
	.float 1.179512
	.float -1.509101
	.float 1.482840
	.float -1.063291
	.float 0.441336
	.float 0.053278
	.float -0.141724
	.float -0.228363
	.float 0.834871
	.float -1.300244
	.float 1.311937
	.float -0.808533
	.float 0.011515
	.float 0.719801
	.float -1.112818
	.float 1.133803
	.float -0.967955
	.float 0.851556
	.float -0.885232
	.float 0.964867
	.float -0.874878
	.float 0.467564
	.float 0.205825
	.float -0.905618
	.float 1.344665
	.float -1.360119
	.float 1.002618
	.float -0.492001
	.float 0.077307
	.float 0.105578
	.float -0.093117
	.float 0.042857
	.float -0.113379
	.float 0.353662
	.float -0.668987
	.float 0.879295
	.float -0.829333
	.float 0.481274
	.float 0.064489
	.float -0.626980
	.float 1.038705
	.float -1.216958
	.float 1.175118
	.float -0.980366
	.float 0.696705
	.float -0.354250
	.float -0.039903
	.float 0.465138
	.float -0.857928
	.float 1.116022
	.float -1.141427
	.float 0.900811
	.float -0.465850
	.float 0.001191
	.float 0.304196
	.float -0.329318
	.float 0.084117
	.float 0.295155
	.float -0.615801
	.float 0.723393
	.float -0.570867
	.float 0.231561
	.float 0.143212
	.float -0.397532
	.float 0.440919
	.float -0.283952
	.float 0.022600
	.float 0.219238
	.float -0.354595
	.float 0.366419
	.float -0.292550
	.float 0.183154
	.float -0.069202
	.float -0.036058
	.float 0.115422
	.float -0.138282
	.float 0.080160
	.float 0.045308
	.float -0.176353
	.float 0.233023
	.float -0.169101
	.float 0.006524
	.float 0.175388
	.float -0.290031
	.float 0.300166
	.float -0.245305
	.float 0.223005
	.float -0.331121
	.float 0.598234
	.float -0.940347
	.float 1.178987
	.float -1.129183
	.float 0.719318
	.float -0.066503
	.float -0.559616
	.float 0.883518
	.float -0.794122
	.float 0.419051
	.float -0.041725
	.float -0.086864
	.float -0.089958
	.float 0.410992
	.float -0.621267
	.float 0.548320
	.float -0.209021
	.float -0.213581
	.float 0.490868
	.float -0.480908
	.float 0.196557
	.float 0.213876
	.float -0.547756
	.float 0.643859
	.float -0.451088
	.float 0.046264
	.float 0.402909
	.float -0.714105
	.float 0.773119
	.float -0.583758
	.float 0.257166
	.float 0.055225
	.float -0.245588
	.float 0.297816
	.float -0.270576
	.float 0.232545
	.float -0.202072
	.float 0.137661
	.float 0.016987
	.float -0.273025
	.float 0.571311
	.float -0.810890
	.float 0.908310
	.float -0.843774
	.float 0.665047
	.float -0.453961
	.float 0.285775
	.float -0.209271
	.float 0.250931
	.float -0.421560
	.float 0.703939
	.float -1.027743
	.float 1.266476
	.float -1.285774
	.float 1.028631
	.float -0.575934
	.float 0.121820
	.float 0.135936
	.float -0.116839
	.float -0.100845
	.float 0.348667
	.float -0.490096
	.float 0.501714
	.float -0.461269
	.float 0.469734
	.float -0.577123
	.float 0.759167
	.float -0.938836
	.float 1.019040
	.float -0.910554
	.float 0.566164
	.float -0.026898
	.float -0.549026
	.float 0.922637
	.float -0.888734
	.float 0.411001
	.float 0.320737
	.float -0.971979
	.float 1.248071
	.float -1.065634
	.float 0.596797
	.float -0.156700
	.float 0.009514
	.float -0.216490
	.float 0.615482
	.float -0.933984
	.float 0.957532
	.float -0.650303
	.float 0.162677
	.float 0.266998
	.float -0.448632
	.float 0.333285
	.float -0.017810
	.float -0.326475
	.float 0.547885
	.float -0.577657
	.float 0.437706
	.float -0.204071
	.float -0.042955
	.float 0.252956
	.float -0.410270
	.float 0.515988
	.float -0.565258
	.float 0.538511
	.float -0.412646
	.float 0.183536
	.float 0.117002
	.float -0.421891
	.float 0.648923
	.float -0.731416
	.float 0.646470
	.float -0.426615
	.float 0.146818
	.float 0.109841
	.float -0.289821
	.float 0.386784
	.float -0.428720
	.float 0.446704
	.float -0.451031
	.float 0.431691
	.float -0.376988
	.float 0.290383
	.float -0.192949
	.float 0.116259
	.float -0.095886
	.float 0.164990
	.float -0.337186
	.float 0.579057
	.float -0.796673
	.float 0.867969
	.float -0.722102
	.float 0.415176
	.float -0.131367
	.float 0.080243
	.float -0.344986
	.float 0.792733
	.float -1.130355
	.float 1.087093
	.float -0.604686
	.float -0.101521
	.float 0.661941
	.float -0.776162
	.float 0.390617
	.float 0.286020
	.float -0.930631
	.float 1.306423
	.float -1.378163
	.float 1.276013
	.float -1.155683
	.float 1.072605
	.float -0.963317
	.float 0.734283
	.float -0.372559
	.float -0.017235
	.float 0.278536
	.float -0.315036
	.float 0.159587
	.float 0.050656
	.float -0.169348
	.float 0.133005
	.float 0.012987
	.float -0.164858
	.float 0.243654
	.float -0.249845
	.float 0.253677
	.float -0.332287
	.float 0.499008
	.float -0.674102
	.float 0.718517
	.float -0.514360
	.float 0.046786
	.float 0.561949
	.float -1.093468
	.float 1.335119
	.float -1.189758
	.float 0.727753
	.float -0.145514
	.float -0.344551
	.float 0.620814
	.float -0.686158
	.float 0.616567
	.float -0.477110
	.float 0.277524
	.float 0.003408
	.float -0.358458
	.float 0.720704
	.float -0.993301
	.float 1.115399
	.float -1.106153
	.float 1.046279
	.float -1.008567
	.float 0.990049
	.float -0.900876
	.float 0.627243
	.float -0.131935
	.float -0.476717
	.float 0.967952
	.float -1.109232
	.float 0.818219
	.float -0.242515
	.float -0.303146
	.float 0.518137
	.float -0.301549
	.float -0.184817
	.float 0.621517
	.float -0.731380
	.float 0.439384
	.float 0.104743
	.float -0.636020
	.float 0.928496
	.float -0.898194
	.float 0.613628
	.float -0.234970
	.float -0.070215
	.float 0.195642
	.float -0.130012
	.float -0.051537
	.float 0.236255
	.float -0.343800
	.float 0.378761
	.float -0.426702
	.float 0.585254
	.float -0.871304
	.float 1.173425
	.float -1.296578
	.float 1.081812
	.float -0.523028
	.float -0.203554
	.float 0.824824
	.float -1.117813
	.float 1.023654
	.float -0.660955
	.float 0.241902
	.float 0.045444
	.float -0.117000
	.float 0.001506
	.float 0.206272
	.float -0.407251
	.float 0.540273
	.float -0.593641
	.float 0.593814
	.float -0.585543
	.float 0.611625
	.float -0.693969
	.float 0.817420
	.float -0.925120
	.float 0.937715
	.float -0.796906
	.float 0.511290
	.float -0.169610
	.float -0.097012
	.float 0.183415
	.float -0.062371
	.float -0.213996
	.float 0.553187
	.float -0.860730
	.float 1.049372
	.float -1.033931
	.float 0.749931
	.float -0.207061
	.float -0.465007
	.float 1.040234
	.float -1.303276
	.float 1.176573
	.float -0.770460
	.float 0.309402
	.float 0.014722
	.float -0.152223
	.float 0.189772
	.float -0.246546
	.float 0.365763
	.float -0.489980
	.float 0.531856
	.float -0.470553
	.float 0.386117
	.float -0.398423
	.float 0.559881
	.float -0.792894
	.float 0.932490
	.float -0.850146
	.float 0.563717
	.float -0.239913
	.float 0.076379
	.float -0.149876
	.float 0.352431
	.float -0.472601
	.float 0.363721
	.float -0.067391
	.float -0.206684
	.float 0.233002
	.float 0.059609
	.float -0.526327
	.float 0.898039
	.float -0.957967
	.float 0.677329
	.float -0.218636
	.float -0.185707
	.float 0.384731
	.float -0.382412
	.float 0.292101
	.float -0.222350
	.float 0.190194
	.float -0.125694
	.float -0.046391
	.float 0.321521
	.float -0.596305
	.float 0.727979
	.float -0.625729
	.float 0.309420
	.float 0.098327
	.float -0.433721
	.float 0.566027
	.float -0.447938
	.float 0.126925
	.float 0.278175
	.float -0.624441
	.float 0.801183
	.float -0.775151
	.float 0.601524
	.float -0.389798
	.float 0.240809
	.float -0.194307
	.float 0.221705
	.float -0.265164
	.float 0.287945
	.float -0.294425
	.float 0.308034
	.float -0.334552
	.float 0.349686
	.float -0.324022
	.float 0.259920
	.float -0.200090
	.float 0.194961
	.float -0.256339
	.float 0.343278
	.float -0.398200
	.float 0.402524
	.float -0.397127
	.float 0.440290
	.float -0.536103
	.float 0.602108
	.float -0.520086
	.float 0.242417
	.float 0.131553
	.float -0.384007
	.float 0.311322
	.float 0.124854
	.float -0.738360
	.float 1.204700
	.float -1.245055
	.float 0.789431
	.float -0.011882
	.float -0.781691
	.float 1.330845
	.float -1.541960
	.float 1.483528
	.float -1.285467
	.float 1.038091
	.float -0.767438
	.float 0.483781
	.float -0.235200
	.float 0.105064
	.float -0.155353
	.float 0.372368
	.float -0.667062
	.float 0.929766
	.float -1.092509
	.float 1.150777
	.float -1.135234
	.float 1.064886
	.float -0.924303
	.float 0.685043
	.float -0.353579
	.float 0.003334
	.float 0.244876
	.float -0.291050
	.float 0.126183
	.float 0.153835
	.float -0.410285
	.float 0.557553
	.float -0.617318
	.float 0.685892
	.float -0.839461
	.float 1.053479
	.float -1.201639
	.float 1.137240
	.float -0.798557
	.float 0.264239
	.float 0.277764
	.float -0.627728
	.float 0.677961
	.float -0.462700
	.float 0.127980
	.float 0.156164
	.float -0.285464
	.float 0.260343
	.float -0.158453
	.float 0.070534
	.float -0.047951
	.float 0.090809
	.float -0.168265
	.float 0.242903
	.float -0.281432
	.float 0.258194
	.float -0.165618
	.float 0.030408
	.float 0.083504
	.float -0.100225
	.float -0.025337
	.float 0.277804
	.float -0.587349
	.float 0.865072
	.float -1.040422
	.float 1.079147
	.float -0.983424
	.float 0.788271
	.float -0.558596
	.float 0.374794
	.float -0.297242
	.float 0.324406
	.float -0.380069
	.float 0.354637
	.float -0.182820
	.float -0.098403
	.float 0.362890
	.float -0.479471
	.float 0.408539
	.float -0.237357
	.float 0.124360
	.float -0.192262
	.float 0.447783
	.float -0.783586
	.float 1.054573
	.float -1.168487
	.float 1.127571
	.float -1.001127
	.float 0.859534
	.float -0.722019
	.float 0.552317
	.float -0.297987
	.float -0.058217
	.float 0.469501
	.float -0.835258
	.float 1.043820
	.float -1.026599
	.float 0.797487
	.float -0.455362
	.float 0.143013
	.float 0.022878
	.float -0.013963
	.float -0.094760
	.float 0.172554
	.float -0.117351
	.float -0.076837
	.float 0.315036
	.float -0.462777
	.float 0.432851
	.float -0.241372
	.float -0.000477
	.float 0.151111
	.float -0.120624
	.float -0.075483
	.float 0.319769
	.float -0.455392
	.float 0.378335
	.float -0.109828
	.float -0.200068
	.float 0.351949
	.float -0.219669
	.float -0.163219
	.float 0.617956
	.float -0.934210
	.float 1.006871
	.float -0.898614
	.float 0.783857
	.float -0.816639
	.float 1.018033
	.float -1.258175
	.float 1.338084
	.float -1.112093
	.float 0.577427
	.float 0.111844
	.float -0.705450
	.float 0.962671
	.float -0.761101
	.float 0.165082
	.float 0.583272
	.float -1.161244
	.float 1.316595
	.float -0.998055
	.float 0.386859
	.float 0.199550
	.float -0.483870
	.float 0.382335
	.float -0.040876
	.float -0.267587
	.float 0.317149
	.float -0.061148
	.float -0.359084
	.float 0.723807
	.float -0.877817
	.float 0.806199
	.float -0.601393
	.float 0.363817
	.float -0.123575
	.float -0.157087
	.float 0.512381
	.float -0.899371
	.float 1.186453
	.float -1.217933
	.float 0.912196
	.float -0.329452
	.float -0.335359
	.float 0.834987
	.float -0.986642
	.float 0.760213
	.float -0.288098
	.float -0.209775
	.float 0.540818
	.float -0.623666
	.float 0.495607
	.float -0.254942
	.float -0.005631
	.float 0.225658
	.float -0.362270
	.float 0.374955
	.float -0.244322
	.float 0.012061
	.float 0.208352
	.float -0.285740
	.float 0.165674
	.float 0.070606
	.float -0.246896
	.float 0.221663
	.float -0.015511
	.float -0.170669
	.float 0.082691
	.float 0.389690
	.float -1.087901
	.float 1.640834
	.float -1.690155
	.float 1.143853
	.float -0.276306
	.float -0.418878
	.float 0.547512
	.float -0.093639
	.float -0.546707
	.float 0.822171
	.float -0.408455
	.float -0.551393
	.float 1.525550
	.float -1.940613
	.float 1.553560
	.float -0.592079
	.float -0.417948
	.float 0.996502
	.float -0.981269
	.float 0.564635
	.float -0.114696
	.float -0.064849
	.float -0.120815
	.float 0.563577
	.float -1.054639
	.float 1.393047
	.float -1.449146
	.float 1.187890
	.float -0.677046
	.float 0.081475
	.float 0.380740
	.float -0.531987
	.float 0.341189
	.float 0.034564
	.float -0.325467
	.float 0.312314
	.float 0.031284
	.float -0.524592
	.float 0.908095
	.float -1.016557
	.float 0.864846
	.float -0.591939
	.float 0.328618
	.float -0.111349
	.float -0.090790
	.float 0.281902
	.float -0.386221
	.float 0.300843
	.float -0.009985
	.float -0.352387
	.float 0.568277
	.float -0.493312
	.float 0.180592
	.float 0.139125
	.float -0.218660
	.float -0.020882
	.float 0.422422
	.float -0.694452
	.float 0.606281
	.float -0.136942
	.float -0.519514
	.float 1.079743
	.float -1.328735
	.float 1.207486
	.float -0.798238
	.float 0.250158
	.float 0.288669
	.float -0.702574
	.float 0.918339
	.float -0.920989
	.float 0.773065
	.float -0.605503
	.float 0.557652
	.float -0.690965
	.float 0.939477
	.float -1.146080
	.float 1.169742
	.float -0.987355
	.float 0.711158
	.float -0.505601
	.float 0.466858
	.float -0.557583
	.float 0.645578
	.float -0.612519
	.float 0.446370
	.float -0.246849
	.float 0.144035
	.float -0.195847
	.float 0.341922
	.float -0.443705
	.float 0.375631
	.float -0.101445
	.float -0.308565
	.float 0.716055
	.float -0.974095
	.float 0.978071
	.float -0.701111
	.float 0.215800
	.float 0.309483
	.float -0.662150
	.float 0.684295
	.float -0.372034
	.float -0.098560
	.float 0.458125
	.float -0.501994
	.float 0.216319
	.float 0.216527
	.float -0.537471
	.float 0.570799
	.float -0.317995
	.float -0.066810
	.float 0.388081
	.float -0.525144
	.float 0.482377
	.float -0.355957
	.float 0.254291
	.float -0.232052
	.float 0.278382
	.float -0.354789
	.float 0.440990
	.float -0.545587
	.float 0.675183
	.float -0.796644
	.float 0.836325
	.float -0.726135
	.float 0.460959
	.float -0.117908
	.float -0.182364
	.float 0.345162
	.float -0.351853
	.float 0.258638
	.float -0.150920
	.float 0.088211
	.float -0.073995
	.float 0.063300
	.float 0.001467
	.float -0.147730
	.float 0.344903
	.float -0.507791
	.float 0.535790
	.float -0.373030
	.float 0.055033
	.float 0.294567
	.float -0.526398
	.float 0.553100
	.float -0.403120
	.float 0.200810
	.float -0.086093
	.float 0.132000
	.float -0.315840
	.float 0.554570
	.float -0.767256
	.float 0.915511
	.float -0.999992
	.float 1.028453
	.float -0.987367
	.float 0.841759
	.float -0.564340
	.float 0.174549
	.float 0.242594
	.float -0.560337
	.float 0.672850
	.float -0.560552
	.float 0.310967
	.float -0.072886
	.float -0.029028
	.float -0.039761
	.float 0.222677
	.float -0.430046
	.float 0.605625
	.float -0.749612
	.float 0.886183
	.float -1.010749
	.float 1.066093
	.float -0.970491
	.float 0.678605
	.float -0.231281
	.float -0.239948
	.float 0.558132
	.float -0.573520
	.float 0.232539
	.float 0.381670
	.float -1.056290
	.float 1.514802
	.float -1.533022
	.float 1.060078
	.float -0.271408
	.float -0.500477
	.float 0.938952
	.float -0.920482
	.float 0.577490
	.float -0.200152
	.float 0.044802
	.float -0.180481
	.float 0.470688
	.float -0.684280
	.float 0.646067
	.float -0.330069
	.float -0.143230
	.float 0.579716
	.float -0.803037
	.float 0.724138
	.float -0.370600
	.float -0.127505
	.float 0.588377
	.float -0.846131
	.float 0.808992
	.float -0.486892
	.float -0.015394
	.float 0.531719
	.float -0.886338
	.float 0.957461
	.float -0.734843
	.float 0.338402
	.float 0.030941
	.float -0.196734
	.float 0.107187
	.float 0.143384
	.float -0.393827
	.float 0.536732
	.float -0.582476
	.float 0.613699
	.float -0.674346
	.float 0.697799
	.float -0.548388
	.float 0.148516
	.float 0.416953
	.float -0.916315
	.float 1.106776
	.float -0.890642
	.float 0.374752
	.float 0.207374
	.float -0.645373
	.float 0.860789
	.float -0.906498
	.float 0.880702
	.float -0.841744
	.float 0.790921
	.float -0.718797
	.float 0.651295
	.float -0.641030
	.float 0.710627
	.float -0.809161
	.float 0.833977
	.float -0.709435
	.float 0.456062
	.float -0.186842
	.float 0.027351
	.float -0.021108
	.float 0.094353
	.float -0.107757
	.float -0.043305
	.float 0.350444
	.float -0.687231
	.float 0.878687
	.float -0.801949
	.float 0.460473
	.float 0.008551
	.float -0.398164
	.float 0.535167
	.float -0.369960
	.float 0.003359
	.float 0.367879
	.float -0.560608
	.float 0.508703
	.float -0.296999
	.float 0.101010
	.float -0.067111
	.float 0.211031
	.float -0.404932
	.float 0.465585
	.float -0.284612
	.float -0.088518
	.float 0.466545
	.float -0.631010
	.float 0.452155
	.float 0.050480
	.float -0.730972
	.float 1.393482
	.float -1.870316
	.float 2.066618
	.float -1.965559
	.float 1.608115
	.float -1.064916
	.float 0.413233
	.float 0.272483
	.float -0.915999
	.float 1.429644
	.float -1.717474
	.float 1.702450
	.float -1.368786
	.float 0.790852
	.float -0.120402
	.float -0.470020
	.float 0.857836
	.float -1.013538
	.float 0.993128
	.float -0.891396
	.float 0.788575
	.float -0.719414
	.float 0.672835
	.float -0.613392
	.float 0.511586
	.float -0.371337
	.float 0.242104
	.float -0.201970
	.float 0.308732
	.float -0.541390
	.float 0.776028
	.float -0.832013
	.float 0.579239
	.float -0.042769
	.float -0.574673
	.float 0.987104
	.float -0.988544
	.float 0.579582
	.float 0.031774
	.float -0.558441
	.float 0.803776
	.float -0.755978
	.float 0.550454
	.float -0.342283
	.float 0.193600
	.float -0.058810
	.float -0.134597
	.float 0.389112
	.float -0.610665
	.float 0.674039
	.float -0.522762
	.float 0.218960
	.float 0.096599
	.float -0.298768
	.float 0.349216
	.float -0.291900
	.float 0.186804
	.float -0.047053
	.float -0.160955
	.float 0.453958
	.float -0.764460
	.float 0.941387
	.float -0.837083
	.float 0.422329
	.float 0.163283
	.float -0.676942
	.float 0.914399
	.float -0.824985
	.float 0.515767
	.float -0.148971
	.float -0.178668
	.float 0.479140
	.float -0.813185
	.float 1.188906
	.float -1.510651
	.float 1.623995
	.float -1.424104
	.float 0.946776
	.float -0.375503
	.float -0.044504
	.float 0.135895
	.float 0.112505
	.float -0.536356
	.float 0.885044
	.float -0.964766
	.float 0.754839
	.float -0.423742
	.float 0.225715
	.float -0.334012
	.float 0.716317
	.float -1.140262
	.float 1.314506
	.float -1.077305
	.float 0.505595
	.float 0.131476
	.float -0.543971
	.float 0.600088
	.float -0.392373
	.float 0.153983
	.float -0.093656
	.float 0.268015
	.float -0.569973
	.float 0.821581
	.float -0.891145
	.float 0.756646
	.float -0.493956
	.float 0.222744
	.float -0.053654
	.float 0.053588
	.float -0.224042
	.float 0.490782
	.float -0.719864
	.float 0.772815
	.float -0.585135
	.float 0.222593
	.float 0.130863
	.float -0.260899
	.float 0.045021
	.float 0.460351
	.float -1.024283
	.float 1.345607
	.float -1.208848
	.float 0.607512
	.float 0.238296
	.float -0.988055
	.float 1.356045
	.float -1.257504
	.float 0.842984
	.float -0.404166
	.float 0.209116
	.float -0.360342
	.float 0.750047
	.float -1.128197
	.float 1.238915
	.float -0.948636
	.float 0.301367
	.float 0.519666
	.float -1.290069
	.float 1.839641
	.float -2.094441
	.float 2.061024
	.float -1.788806
	.float 1.351222
	.float -0.852059
	.float 0.427235
	.float -0.208753
	.float 0.255065
	.float -0.495253
	.float 0.741886
	.float -0.785213
	.float 0.519356
	.float -0.017218
	.float -0.503014
	.float 0.804965
	.float -0.772868
	.float 0.469960
	.float -0.081003
	.float -0.212436
	.float 0.331941
	.float -0.313098
	.float 0.238352
	.float -0.160623
	.float 0.080753
	.float 0.015067
	.float -0.105879
	.float 0.128155
	.float -0.019954
	.float -0.220244
	.float 0.511457
	.float -0.725676
	.float 0.757212
	.float -0.578774
	.float 0.249719
	.float 0.121392
	.float -0.428657
	.float 0.602746
	.float -0.617911
	.float 0.486129
	.float -0.255064
	.float 0.008014
	.float 0.151430
	.float -0.139458
	.float -0.058809
	.float 0.365173
	.float -0.634411
	.float 0.724138
	.float -0.572074
	.float 0.236160
	.float 0.128013
	.float -0.344995
	.float 0.312395
	.float -0.056610
	.float -0.283693
	.float 0.538383
	.float -0.600266
	.float 0.472625
	.float -0.243983
	.float 0.016933
	.float 0.153207
	.float -0.269902
	.float 0.360073
	.float -0.428275
	.float 0.437789
	.float -0.331589
	.float 0.078146
	.float 0.288812
	.float -0.665342
	.float 0.917019
	.float -0.945402
	.float 0.741445
	.float -0.389714
	.float 0.018984
	.float 0.266593
	.float -0.429170
	.float 0.488326
	.float -0.478237
	.float 0.409779
	.float -0.265513
	.float 0.026636
	.float 0.291443
	.float -0.621204
	.float 0.856962
	.float -0.898674
	.float 0.708139
	.float -0.347976
	.float -0.025372
	.float 0.224446
	.float -0.126129
	.float -0.250641
	.float 0.733583
	.float -1.068125
	.float 1.040213
	.float -0.588553
	.float -0.154471
	.float 0.917776
	.float -1.416137
	.float 1.479737
	.float -1.122260
	.float 0.516482
	.float 0.101479
	.float -0.542356
	.float 0.732572
	.float -0.716418
	.float 0.603405
	.float -0.495390
	.float 0.431503
	.float -0.377760
	.float 0.266352
	.float -0.060370
	.float -0.200253
	.float 0.408756
	.float -0.456363
	.float 0.306485
	.float -0.022740
	.float -0.268587
	.float 0.448358
	.float -0.453457
	.float 0.280727
	.float 0.032678
	.float -0.416658
	.float 0.758786
	.float -0.911907
	.float 0.750500
	.float -0.260068
	.float -0.406226
	.float 0.967612
	.float -1.153641
	.float 0.862208
	.float -0.230314
	.float -0.439503
	.float 0.857064
	.float -0.910453
	.float 0.709656
	.float -0.483864
	.float 0.411424
	.float -0.505878
	.float 0.633031
	.float -0.633260
	.float 0.449169
	.float -0.163080
	.float -0.075142
	.float 0.167299
	.float -0.139808
	.float 0.116667
	.float -0.215043
	.float 0.444188
	.float -0.687540
	.float 0.787267
	.float -0.669294
	.float 0.408914
	.float -0.177452
	.float 0.105466
	.float -0.174461
	.float 0.232705
	.float -0.129618
	.float -0.143212
	.float 0.430058
	.float -0.536043
	.float 0.398235
	.float -0.155963
	.float 0.052481
	.float -0.240274
	.float 0.644339
	.float -0.993545
	.float 1.001190
	.float -0.563541
	.float -0.162062
	.float 0.846426
	.float -1.177029
	.float 1.023094
	.float -0.486436
	.float -0.170994
	.float 0.663899
	.float -0.807478
	.float 0.577713
	.float -0.097864
	.float -0.429286
	.float 0.810547
	.float -0.937003
	.float 0.813915
	.float -0.534341
	.float 0.214623
	.float 0.066860
	.float -0.289242
	.float 0.462587
	.float -0.587552
	.float 0.642270
	.float -0.608016
	.float 0.505204
	.float -0.399392
	.float 0.364458
	.float -0.430746
	.float 0.560456
	.float -0.668388
	.float 0.668463
	.float -0.510849
	.float 0.191827
	.float 0.252860
	.float -0.750434
	.float 1.186540
	.float -1.415320
	.float 1.306998
	.float -0.825527
	.float 0.089259
	.float 0.643576
	.float -1.084935
	.float 1.073836
	.float -0.680358
	.float 0.174555
	.float 0.136632
	.float -0.101731
	.float -0.189371
	.float 0.490248
	.float -0.588640
	.float 0.454101
	.float -0.229465
	.float 0.084448
	.float -0.065213
	.float 0.072885
	.float 0.013955
	.float -0.187640
	.float 0.274585
	.float -0.059458
	.float -0.520888
	.float 1.270049
	.float -1.808709
	.float 1.799288
	.float -1.173744
	.float 0.209686
	.float 0.606093
	.float -0.851994
	.float 0.418064
	.float 0.428454
	.float -1.200804
	.float 1.476551
	.float -1.133168
	.float 0.396107
	.float 0.318517
	.float -0.658830
	.float 0.531582
	.float -0.127150
	.float -0.222645
	.float 0.253299
	.float 0.087476
	.float -0.636005
	.float 1.132289
	.float -1.372566
	.float 1.299881
	.float -0.996973
	.float 0.615157
	.float -0.301415
	.float 0.159914
	.float -0.240641
	.float 0.532121
	.float -0.954027
	.float 1.369126
	.float -1.630051
	.float 1.644018
	.float -1.414065
	.float 1.026590
	.float -0.595656
	.float 0.208159
	.float 0.091770
	.float -0.280304
	.float 0.330513
	.float -0.222501
	.float -0.018041
	.float 0.297182
	.float -0.485974
	.float 0.500456
	.float -0.367319
	.float 0.212578
	.float -0.169970
	.float 0.277652
	.float -0.448996
	.float 0.545998
	.float -0.496969
	.float 0.360917
	.float -0.284025
	.float 0.382570
	.float -0.645280
	.float 0.930800
	.float -1.059852
	.float 0.931894
	.float -0.583701
	.float 0.155680
	.float 0.200775
	.float -0.405788
	.float 0.471874
	.float -0.464086
	.float 0.443956
	.float -0.443535
	.float 0.478586
	.float -0.569672
	.float 0.734748
	.float -0.952158
	.float 1.133597
	.float -1.150160
	.float 0.911472
	.float -0.444653
	.float -0.093040
	.float 0.489608
	.float -0.596034
	.float 0.407558
	.float -0.057168
	.float -0.266004
	.float 0.413689
	.float -0.334739
	.float 0.075347
	.float 0.255103
	.float -0.526789
	.float 0.631785
	.float -0.526643
	.float 0.262383
	.float 0.026347
	.float -0.189061
	.float 0.157248
	.float -0.005484
	.float -0.082757
	.float -0.059907
	.float 0.448802
	.float -0.903613
	.float 1.145066
	.float -0.979403
	.float 0.446656
	.float 0.176719
	.float -0.534252
	.float 0.407981
	.float 0.145967
	.float -0.836716
	.float 1.326961
	.float -1.441978
	.float 1.257555
	.float -1.012310
	.float 0.914938
	.float -0.989727
	.float 1.070155
	.float -0.939322
	.float 0.509583
	.float 0.088923
	.float -0.572113
	.float 0.674233
	.float -0.318144
	.float -0.320192
	.float 0.890200
	.float -1.046461
	.float 0.634730
	.float 0.215000
	.float -1.141976
	.float 1.732523
	.float -1.731277
	.float 1.172448
	.float -0.359149
	.float -0.297463
	.float 0.490883
	.float -0.169330
	.float -0.454405
	.float 1.033901
	.float -1.285968
	.float 1.143406
	.float -0.777390
	.float 0.478511
	.float -0.470631
	.float 0.774999
	.float -1.210398
	.float 1.523136
	.float -1.551888
	.float 1.312730
	.float -0.953485
	.float 0.626262
	.float -0.383965
	.float 0.177322
	.float 0.057840
	.float -0.306595
	.float 0.459564
	.float -0.393720
	.float 0.087521
	.float 0.322296
	.float -0.595355
	.float 0.528190
	.float -0.092977
	.float -0.519907
	.float 0.994034
	.float -1.068349
	.float 0.700193
	.float -0.104211
	.float -0.366484
	.float 0.428222
	.float -0.033675
	.float -0.607816
	.float 1.164332
	.float -1.377105
	.float 1.192927
	.float -0.762270
	.float 0.324776
	.float -0.067003
	.float 0.035792
	.float -0.142892
	.float 0.241809
	.float -0.226406
	.float 0.096545
	.float 0.045202
	.float -0.066298
	.float -0.094302
	.float 0.362973
	.float -0.557065
	.float 0.494096
	.float -0.116506
	.float -0.454581
	.float 0.978446
	.float -1.230072
	.float 1.122990
	.float -0.743037
	.float 0.281403
	.float 0.079614
	.float -0.253435
	.float 0.264782
	.float -0.202481
	.float 0.152338
	.float -0.154754
	.float 0.204696
	.float -0.280714
	.float 0.372773
	.float -0.485644
	.float 0.617875
	.float -0.738363
	.float 0.786128
	.float -0.699468
	.float 0.456044
	.float -0.093569
	.float -0.305149
	.float 0.653527
	.float -0.900063
	.float 1.038547
	.float -1.084730
	.float 1.040446
	.float -0.878434
	.float 0.566852
	.float -0.120915
	.float -0.361418
	.float 0.721264
	.float -0.820928
	.float 0.636795
	.float -0.293241
	.float 0.002049
	.float 0.060319
	.float 0.143230
	.float -0.493724
	.float 0.793368
	.float -0.880550
	.float 0.708305
	.float -0.348476
	.float -0.063168
	.float 0.395320
	.float -0.565663
	.float 0.553524
	.float -0.392370
	.float 0.152801
	.float 0.083684
	.float -0.259542
	.float 0.369539
	.float -0.457553
	.float 0.572119
	.float -0.707352
	.float 0.780916
	.float -0.681556
	.float 0.361903
	.float 0.095335
	.float -0.501306
	.float 0.670653
	.float -0.540347
	.float 0.206915
	.float 0.146902
	.float -0.378210
	.float 0.464959
	.float -0.485307
	.float 0.523406
	.float -0.586258
	.float 0.599345
	.float -0.477212
	.float 0.204378
	.float 0.140051
	.float -0.427685
	.float 0.554659
	.float -0.489122
	.float 0.269795
	.float 0.026205
	.float -0.313787
	.float 0.513797
	.float -0.559207
	.float 0.408768
	.float -0.069186
	.float -0.389583
	.float 0.843586
	.float -1.152362
	.float 1.210818
	.float -0.992520
	.float 0.564769
	.float -0.067065
	.float -0.340566
	.float 0.540717
	.float -0.506319
	.float 0.308097
	.float -0.074118
	.float -0.080536
	.float 0.114739
	.float -0.075132
	.float 0.052777
	.float -0.111681
	.float 0.239214
	.float -0.354142
	.float 0.366681
	.float -0.246577
	.float 0.048976
	.float 0.120722
	.float -0.178541
	.float 0.119851
	.float -0.024247
	.float 0.004075
	.float -0.130595
	.float 0.385813
	.float -0.672301
	.float 0.876690
	.float -0.945744
	.float 0.920688
	.float -0.898960
	.float 0.944806
	.float -1.014379
	.float 0.963067
	.float -0.646455
	.float 0.049930
	.float 0.655092
	.float -1.188891
	.float 1.337193
	.float -1.101712
	.float 0.712147
	.float -0.479033
	.float 0.584345
	.float -0.955660
	.float 1.313373
	.float -1.357708
	.float 0.968053
	.float -0.284355
	.float -0.375444
	.float 0.702258
	.float -0.570751
	.float 0.103073
	.float 0.407016
	.float -0.660844
	.float 0.517108
	.float -0.059608
	.float -0.465046
	.float 0.798724
	.float -0.817146
	.float 0.580151
	.float -0.263407
	.float 0.028670
	.float 0.073423
	.float -0.106417
	.float 0.169064
	.float -0.304285
	.float 0.465502
	.float -0.559455
	.float 0.525680
	.float -0.389950
	.float 0.253544
	.float -0.228195
	.float 0.361427
	.float -0.599882
	.float 0.811784
	.float -0.855797
	.float 0.659846
	.float -0.268507
	.float -0.168820
	.float 0.467734
	.float -0.502853
	.float 0.273729
	.float 0.096425
	.float -0.428103
	.float 0.575233
	.float -0.483110
	.float 0.189628
	.float 0.211713
	.float -0.608642
	.float 0.887953
	.float -0.949124
	.float 0.738173
	.float -0.296534
	.float -0.217285
	.float 0.577233
	.float -0.603971
	.float 0.274591
	.float 0.256130
	.float -0.749507
	.float 1.028843
	.float -1.069345
	.float 0.968766
	.float -0.834096
	.float 0.688342
	.float -0.477566
	.float 0.163260
	.float 0.195143
	.float -0.452319
	.float 0.478932
	.float -0.263411
	.float -0.075528
	.float 0.372225
	.float -0.516438
	.float 0.492439
	.float -0.343141
	.float 0.117979
	.float 0.137616
	.float -0.356068
	.float 0.440498
	.float -0.314591
	.float -0.000161
	.float 0.353770
	.float -0.530428
	.float 0.374299
	.float 0.108151
	.float -0.742772
	.float 1.285005
	.float -1.554556
	.float 1.521571
	.float -1.295532
	.float 1.034184
	.float -0.839643
	.float 0.709819
	.float -0.570533
	.float 0.355430
	.float -0.071837
	.float -0.193030
	.float 0.324749
	.float -0.252372
	.float -0.008776
	.float 0.362976
	.float -0.677315
	.float 0.834406
	.float -0.772311
	.float 0.501610
	.float -0.099429
	.float -0.316496
	.float 0.626784
	.float -0.750384
	.float 0.668743
	.float -0.424213
	.float 0.095814
	.float 0.231086
	.float -0.485003
	.float 0.614880
	.float -0.592157
	.float 0.417936
	.float -0.131885
	.float -0.190961
	.float 0.464715
	.float -0.629657
	.float 0.677604
	.float -0.645614
	.float 0.580384
	.float -0.498767
	.float 0.374642
	.float -0.163782
	.float -0.149907
	.float 0.521138
	.float -0.851073
	.float 1.036485
	.float -1.029436
	.float 0.865862
	.float -0.640929
	.float 0.447711
	.float -0.324317
	.float 0.248245
	.float -0.179128
	.float 0.111970
	.float -0.094221
	.float 0.189414
	.float -0.412667
	.float 0.687520
	.float -0.862345
	.float 0.786981
	.float -0.408151
	.float -0.176881
	.float 0.752583
	.float -1.096893
	.float 1.107864
	.float -0.859898
	.float 0.544287
	.float -0.331896
	.float 0.259823
	.float -0.230413
	.float 0.123425
	.float 0.074653
	.float -0.239483
	.float 0.212240
	.float 0.045500
	.float -0.382141
	.float 0.545789
	.float -0.371951
	.float -0.083558
	.float 0.582315
	.float -0.885083
	.float 0.925847
	.float -0.831595
	.float 0.776698
	.float -0.807507
	.float 0.798760
	.float -0.582855
	.float 0.136991
	.float 0.342247
	.float -0.551679
	.float 0.299582
	.float 0.340292
	.float -1.055605
	.float 1.481001
	.float -1.409800
	.float 0.895029
	.float -0.195254
	.float -0.375605
	.float 0.593694
	.float -0.399422
	.float -0.104647
	.float 0.703638
	.float -1.144861
	.float 1.228469
	.float -0.895431
	.float 0.270494
	.float 0.383175
	.float -0.793311
	.float 0.821936
	.float -0.529519
	.float 0.116236
	.float 0.214272
	.float -0.368976
	.float 0.383098
	.float -0.349156
	.float 0.330766
	.float -0.330796
	.float 0.322689
	.float -0.296198
	.float 0.266028
	.float -0.240166
	.float 0.190766
	.float -0.069934
	.float -0.135841
	.float 0.364365
	.float -0.499175
	.float 0.450349
	.float -0.233146
	.float -0.025609
	.float 0.171494
	.float -0.140223
	.float 0.018145
	.float 0.009826
	.float 0.203374
	.float -0.641331
	.float 1.103864
	.float -1.315546
	.float 1.095686
	.float -0.479376
	.float -0.288018
	.float 0.876136
	.float -1.036553
	.float 0.717604
	.float -0.075295
	.float -0.611699
	.float 1.073472
	.float -1.167274
	.float 0.932177
	.float -0.553399
	.float 0.247955
	.float -0.131032
	.float 0.147683
	.float -0.124762
	.float -0.084106
	.float 0.465296
	.float -0.832069
	.float 0.952588
	.float -0.726236
	.float 0.269648
	.float 0.158173
	.float -0.334817
	.float 0.219018
	.float 0.045865
	.float -0.260536
	.float 0.319882
	.float -0.268591
	.float 0.232336
	.float -0.294859
	.float 0.424919
	.float -0.505139
	.float 0.429268
	.float -0.187850
	.float -0.118416
	.float 0.337437
	.float -0.348649
	.float 0.119088
	.float 0.287999
	.float -0.740474
	.float 1.081141
	.float -1.177756
	.float 0.974923
	.float -0.532514
	.float 0.021869
	.float 0.340018
	.float -0.399815
	.float 0.158819
	.float 0.221375
	.float -0.514784
	.float 0.568870
	.float -0.385938
	.float 0.088779
	.float 0.196275
	.float -0.436874
	.float 0.687988
	.float -0.989361
	.float 1.266175
	.float -1.336445
	.float 1.038595
	.float -0.385035
	.float -0.386677
	.float 0.920720
	.float -0.943846
	.float 0.426127
	.float 0.402083
	.float -1.178936
	.float 1.595657
	.float -1.528530
	.float 1.060785
	.float -0.409344
	.float -0.187087
	.float 0.563321
	.float -0.674680
	.float 0.587847
	.float -0.425724
	.float 0.293779
	.float -0.227282
	.float 0.190693
	.float -0.128591
	.float 0.028903
	.float 0.053029
	.float -0.032505
	.float -0.130500
	.float 0.378585
	.float -0.569246
	.float 0.549551
	.float -0.246822
	.float -0.280219
	.float 0.859391
	.float -1.281134
	.float 1.393235
	.float -1.168892
	.float 0.716120
	.float -0.224131
	.float -0.126866
	.float 0.245174
	.float -0.153990
	.float -0.044121
	.float 0.233564
	.float -0.336400
	.float 0.323288
	.float -0.198275
	.float -0.014425
	.float 0.271713
	.float -0.516062
	.float 0.697236
	.float -0.797225
	.float 0.827795
	.float -0.793803
	.float 0.659366
	.float -0.367277
	.float -0.085112
	.float 0.579803
	.float -0.903562
	.float 0.878144
	.float -0.505797
	.float 0.002666
	.float 0.330319
	.float -0.313557
	.float 0.011803
	.float 0.326284
	.float -0.462631
	.float 0.338829
	.float -0.087327
	.float -0.108892
	.float 0.175615
	.float -0.189504
	.float 0.280311
	.float -0.493443
	.float 0.737279
	.float -0.854262
	.float 0.747660
	.float -0.459096
	.float 0.145554
	.float 0.014674
	.float 0.082138
	.float -0.417310
	.float 0.859719
	.float -1.219000
	.float 1.322854
	.float -1.095242
	.float 0.601754
	.float -0.029560
	.float -0.399711
	.float 0.539441
	.float -0.382671
	.float 0.042308
	.float 0.331443
	.float -0.631585
	.float 0.817870
	.float -0.884168
	.float 0.818934
	.float -0.607253
	.float 0.273380
	.float 0.086330
	.float -0.330170
	.float 0.353797
	.float -0.167470
	.float -0.099941
	.float 0.282800
	.float -0.288931
	.float 0.157317
	.float -0.024057
	.float 0.025302
	.float -0.205302
	.float 0.483912
	.float -0.695230
	.float 0.672969
	.float -0.343395
	.float -0.214747
	.float 0.778791
	.float -1.074966
	.float 0.926270
	.float -0.376424
	.float -0.300321
	.float 0.738289
	.float -0.701540
	.float 0.246465
	.float 0.296299
	.float -0.527921
	.float 0.248508
	.float 0.397031
	.float -1.002838
	.float 1.167277
	.float -0.760818
	.float 0.011004
	.float 0.655831
	.float -0.904927
	.float 0.709903
	.float -0.344033
	.float 0.158515
	.float -0.316758
	.float 0.684205
	.float -0.951902
	.float 0.890251
	.float -0.529316
	.float 0.124047
	.float 0.061335
	.float 0.029722
	.float -0.204554
	.float 0.183798
	.float 0.168878
	.float -0.735153
	.float 1.229622
	.float -1.407118
	.float 1.225149
	.float -0.847374
	.float 0.506552
	.float -0.345740
	.float 0.353364
	.float -0.417590
	.float 0.432058
	.float -0.361161
	.float 0.226430
	.float -0.051291
	.float -0.168904
	.float 0.441378
	.float -0.727982
	.float 0.934136
	.float -0.958948
	.float 0.769485
	.float -0.436484
	.float 0.101511
	.float 0.097075
	.float -0.085618
	.float -0.125963
	.float 0.458506
	.float -0.788200
	.float 0.976399
	.float -0.915159
	.float 0.583510
	.float -0.080164
	.float -0.406312
	.float 0.688211
	.float -0.676057
	.float 0.415155
	.float -0.036685
	.float -0.334087
	.float 0.639796
	.float -0.881420
	.float 1.059050
	.float -1.125908
	.float 1.003577
	.float -0.650335
	.float 0.126303
	.float 0.403871
	.float -0.745162
	.float 0.780582
	.float -0.543918
	.float 0.206420
	.float 0.019152
	.float -0.000856
	.float -0.237783
	.float 0.536422
	.float -0.698857
	.float 0.613890
	.float -0.323265
	.float -0.002317
	.float 0.161035
	.float -0.032469
	.float -0.356369
	.float 0.842170
	.float -1.202276
	.float 1.258098
	.float -0.957443
	.float 0.399010
	.float 0.214468
	.float -0.673160
	.float 0.858876
	.float -0.792128
	.float 0.602448
	.float -0.443169
	.float 0.404310
	.float -0.474827
	.float 0.569809
	.float -0.597465
	.float 0.520071
	.float -0.371715
	.float 0.225093
	.float -0.133391
	.float 0.089703
	.float -0.036158
	.float -0.080964
	.float 0.251544
	.float -0.387580
	.float 0.373658
	.float -0.149600
	.float -0.235730
	.float 0.641206
	.float -0.912068
	.float 0.967773
	.float -0.842832
	.float 0.658532
	.float -0.547143
	.float 0.574533
	.float -0.704628
	.float 0.823414
	.float -0.808339
	.float 0.603909
	.float -0.259250
	.float -0.096052
	.float 0.323819
	.float -0.352178
	.float 0.208193
	.float 0.006075
	.float -0.170167
	.float 0.194642
	.float -0.042206
	.float -0.270576
	.float 0.671947
	.float -1.034163
	.float 1.196810
	.float -1.032261
	.float 0.531611
	.float 0.149240
	.float -0.736742
	.float 0.973970
	.float -0.766124
	.float 0.241472
	.float 0.317220
	.float -0.628968
	.float 0.559741
	.float -0.172079
	.float -0.335213
	.float 0.742444
	.float -0.905744
	.float 0.794644
	.float -0.479110
	.float 0.094428
	.float 0.200792
	.float -0.276051
	.float 0.086722
	.float 0.289680
	.float -0.674516
	.float 0.872276
	.float -0.774770
	.float 0.419662
	.float 0.033834
	.float -0.392313
	.float 0.522008
	.float -0.400658
	.float 0.114562
	.float 0.184578
	.float -0.343338
	.float 0.273549
	.float 0.000932
	.float -0.347329
	.float 0.589924
	.float -0.610653
	.float 0.421268
	.float -0.154132
	.float -0.025507
	.float 0.023521
	.float 0.136590
	.float -0.352071
	.float 0.525501
	.float -0.626793
	.float 0.689230
	.float -0.754163
	.float 0.818049
	.float -0.827196
	.float 0.720740
	.float -0.481408
	.float 0.151669
	.float 0.192658
	.float -0.482514
	.float 0.676140
	.float -0.754002
	.float 0.710997
	.float -0.563848
	.float 0.363805
	.float -0.186958
	.float 0.093805
	.float -0.087681
	.float 0.113673
	.float -0.106884
	.float 0.051843
	.float 0.000318
	.float 0.026826
	.float -0.168959
	.float 0.383193
	.float -0.564185
	.float 0.598663
	.float -0.422443
	.float 0.054372
	.float 0.400322
	.float -0.777151
	.float 0.908673
	.float -0.699197
	.float 0.186988
	.float 0.447991
	.float -0.952495
	.float 1.120370
	.float -0.899184
	.float 0.417155
	.float 0.089845
	.float -0.407916
	.float 0.452748
	.float -0.292867
	.float 0.082149
	.float 0.047656
	.float -0.064533
	.float 0.039198
	.float -0.081159
	.float 0.256841
	.float -0.544099
	.float 0.846388
	.float -1.047656
	.float 1.066924
	.float -0.882275
	.float 0.524467
	.float -0.060925
	.float -0.413600
	.float 0.785544
	.float -0.946800
	.float 0.839088
	.float -0.494734
	.float 0.037771
	.float 0.370672
	.float -0.616295
	.float 0.689248
	.float -0.672260
	.float 0.666126
	.float -0.708052
	.float 0.745305
	.float -0.683424
	.float 0.470494
	.float -0.152275
	.float -0.142037
	.float 0.272201
	.float -0.168742
	.float -0.124829
	.float 0.469904
	.float -0.698255
	.float 0.692014
	.float -0.439884
	.float 0.041367
	.float 0.344494
	.float -0.578968
	.float 0.607318
	.float -0.472020
	.float 0.275082
	.float -0.118964
	.float 0.061349
	.float -0.099724
	.float 0.180904
	.float -0.224588
	.float 0.155452
	.float 0.059930
	.float -0.383053
	.float 0.699734
	.float -0.856169
	.float 0.726856
	.float -0.284391
	.float -0.365632
	.float 1.008910
	.float -1.403008
	.float 1.383477
	.float -0.948260
	.float 0.276167
	.float 0.338867
	.float -0.616686
	.float 0.426484
	.float 0.139655
	.float -0.800342
	.float 1.218061
	.float -1.167983
	.float 0.652684
	.float 0.101197
	.float -0.762002
	.float 1.058710
	.float -0.901476
	.float 0.399577
	.float 0.215874
	.float -0.709244
	.float 0.935504
	.float -0.878976
	.float 0.634309
	.float -0.348268
	.float 0.148056
	.float -0.085228
	.float 0.121135
	.float -0.164349
	.float 0.140041
	.float -0.046812
	.float -0.041020
	.float 0.032575
	.float 0.098027
	.float -0.268052
	.float 0.319950
	.float -0.120263
	.float -0.337353
	.float 0.896281
	.float -1.303097
	.float 1.345723
	.float -0.981895
	.float 0.374070
	.float 0.197471
	.float -0.492725
	.float 0.442004
	.float -0.167823
	.float -0.107731
	.float 0.202782
	.float -0.073455
	.float -0.180057
	.float 0.387357
	.float -0.409001
	.float 0.210227
	.float 0.124659
	.float -0.440546
	.float 0.598034
	.float -0.552776
	.float 0.379464
	.float -0.220574
	.float 0.190016
	.float -0.296276
	.float 0.439434
	.float -0.483375
	.float 0.351382
	.float -0.080726
	.float -0.195389
	.float 0.322725
	.float -0.213315
	.float -0.098209
	.float 0.455970
	.float -0.647793
	.float 0.514041
	.float -0.051092
	.float -0.556194
	.float 1.014498
	.float -1.088718
	.float 0.756771
	.float -0.239566
	.float -0.133913
	.float 0.147244
	.float 0.151611
	.float -0.484985
	.float 0.552278
	.float -0.261127
	.float -0.191513
	.float 0.458590
	.float -0.307742
	.float -0.182820
	.float 0.649671
	.float -0.684933
	.float 0.127942
	.float 0.798944
	.float -1.610109
	.float 1.854412
	.float -1.392552
	.float 0.474923
	.float 0.420431
	.float -0.873817
	.float 0.750112
	.float -0.236267
	.float -0.309352
	.float 0.582738
	.float -0.493476
	.float 0.175791
	.float 0.130005
	.float -0.234420
	.float 0.096430
	.float 0.183642
	.float -0.451276
	.float 0.598830
	.float -0.617780
	.float 0.579654
	.float -0.567943
	.float 0.609461
	.float -0.649519
	.float 0.587590
	.float -0.353028
	.float -0.025844
	.float 0.407522
	.float -0.596696
	.float 0.451589
	.float 0.021495
	.float -0.646869
	.float 1.153462
	.float -1.309415
	.float 1.043200
	.float -0.480675
	.float -0.125584
	.float 0.534246
	.float -0.638235
	.float 0.498904
	.float -0.275144
	.float 0.102815
	.float -0.013190
	.float -0.052035
	.float 0.150653
	.float -0.258984
	.float 0.277500
	.float -0.125523
	.float -0.155736
	.float 0.389091
	.float -0.365799
	.float -0.001541
	.float 0.594088
	.float -1.140929
	.float 1.379313
	.float -1.210002
	.float 0.743159
	.float -0.212112
	.float -0.174749
	.float 0.339687
	.float -0.337231
	.float 0.270889
	.float -0.200814
	.float 0.112138
	.float 0.042737
	.float -0.274335
	.float 0.521698
	.float -0.682015
	.float 0.677338
	.float -0.503294
	.float 0.222956
	.float 0.082632
	.float -0.362681
	.float 0.605667
	.float -0.810214
	.float 0.953070
	.float -0.988824
	.float 0.884743
	.float -0.661676
	.float 0.405168
	.float -0.232921
	.float 0.236071
	.float -0.428559
	.float 0.733797
	.float -1.016566
	.float 1.144956
	.float -1.051146
	.float 0.760669
	.float -0.375858
	.float 0.024310
	.float 0.198668
	.float -0.263757
	.float 0.205777
	.float -0.094828
	.float -0.000544
	.float 0.042600
	.float -0.037788
	.float 0.029651
	.float -0.070884
	.float 0.185154
	.float -0.341744
	.float 0.466479
	.float -0.489008
	.float 0.395344
	.float -0.243550
	.float 0.124681
	.float -0.095503
	.float 0.135652
	.float -0.164929
	.float 0.109561
	.float 0.033087
	.float -0.181613
	.float 0.220798
	.float -0.080543
	.float -0.210637
	.float 0.533498
	.float -0.741958
	.float 0.743853
	.float -0.551229
	.float 0.272307
	.float -0.051539
	.float -0.006970
	.float -0.110384
	.float 0.329062
	.float -0.534404
	.float 0.630944
	.float -0.576697
	.float 0.379363
	.float -0.073170
	.float -0.295521
	.float 0.663831
	.float -0.946516
	.float 1.053387
	.float -0.932517
	.float 0.611521
	.float -0.201718
	.float -0.146268
	.float 0.311119
	.float -0.252768
	.float 0.020098
	.float 0.282470
	.float -0.543790
	.float 0.683579
	.float -0.667270
	.float 0.503628
	.float -0.235956
	.float -0.068499
	.float 0.334251
	.float -0.502066
	.float 0.556278
	.float -0.538332
	.float 0.532529
	.float -0.625439
	.float 0.857922
	.float -1.194813
	.float 1.528301
	.float -1.717248
	.float 1.651764
	.float -1.320401
	.float 0.844069
	.float -0.441235
	.float 0.319587
	.float -0.545330
	.float 0.979570
	.float -1.345989
	.float 1.404075
	.float -1.112529
	.float 0.659763
	.float -0.330737
	.float 0.305027
	.float -0.535641
	.float 0.795967
	.float -0.853100
	.float 0.632503
	.float -0.254333
	.float -0.074474
	.float 0.219826
	.float -0.209088
	.float 0.188985
	.float -0.294602
	.float 0.532467
	.float -0.762300
	.float 0.786123
	.float -0.481957
	.float -0.103225
	.float 0.755239
	.float -1.189311
	.float 1.194333
	.float -0.754228
	.float 0.078655
	.float 0.488889
	.float -0.652466
	.float 0.338343
	.float 0.249192
	.float -0.740453
	.float 0.822398
	.float -0.429715
	.float -0.220514
	.float 0.771214
	.float -0.945300
	.float 0.697439
	.float -0.208789
	.float -0.251153
	.float 0.488782
	.float -0.469528
	.float 0.285363
	.float -0.056587
	.float -0.146793
	.float 0.310022
	.float -0.420797
	.float 0.424046
	.float -0.241087
	.float -0.152052
	.float 0.655569
	.float -1.061768
	.float 1.168472
	.float -0.917081
	.float 0.446936
	.float -0.012770
	.float -0.182802
	.float 0.118831
	.float 0.049685
	.float -0.125840
	.float 0.026932
	.float 0.156927
	.float -0.241865
	.float 0.099622
	.float 0.238790
	.float -0.599772
	.float 0.784680
	.float -0.698813
	.float 0.403374
	.float -0.064970
	.float -0.152420
	.float 0.178065
	.float -0.055674
	.float -0.105253
	.float 0.207177
	.float -0.220105
	.float 0.184488
	.float -0.167316
	.float 0.206427
	.float -0.283259
	.float 0.341863
	.float -0.336090
	.float 0.265894
	.float -0.173837
	.float 0.108538
	.float -0.089789
	.float 0.106635
	.float -0.146784
	.float 0.224931
	.float -0.377128
	.float 0.620122
	.float -0.909427
	.float 1.137073
	.float -1.182361
	.float 0.987388
	.float -0.606853
	.float 0.193586
	.float 0.078781
	.float -0.113429
	.float -0.049872
	.float 0.252553
	.float -0.306932
	.float 0.107573
	.float 0.302923
	.float -0.757558
	.float 1.065962
	.float -1.128224
	.float 0.984452
	.float -0.766451
	.float 0.588628
	.float -0.461883
	.float 0.297202
	.float 0.005541
	.float -0.455782
	.float 0.939298
	.float -1.280287
	.float 1.351517
	.float -1.152669
	.float 0.806667
	.float -0.483384
	.float 0.304905
	.float -0.288845
	.float 0.356014
	.float -0.390644
	.float 0.315176
	.float -0.135312
	.float -0.070872
	.float 0.212482
	.float -0.252194
	.float 0.231008
	.float -0.232019
	.float 0.311054
	.float -0.449821
	.float 0.569410
	.float -0.593215
	.float 0.506906
	.float -0.364920
	.float 0.238191
	.float -0.148172
	.float 0.047353
	.float 0.130710
	.float -0.389908
	.float 0.632286
	.float -0.708189
	.float 0.531593
	.float -0.172382
	.float -0.158641
	.float 0.240046
	.float 0.000172
	.float -0.414744
	.float 0.717855
	.float -0.667989
	.float 0.227772
	.float 0.407537
	.float -0.927579
	.float 1.085880
	.float -0.824693
	.float 0.279790
	.float 0.315322
	.float -0.749317
	.float 0.906152
	.float -0.770520
	.float 0.394271
	.float 0.133321
	.float -0.693314
	.float 1.138932
	.float -1.320389
	.float 1.140834
	.float -0.615491
	.float -0.109888
	.float 0.805984
	.float -1.253481
	.float 1.333047
	.float -1.066081
	.float 0.592851
	.float -0.107634
	.float -0.217928
	.float 0.296871
	.float -0.156512
	.float -0.076797
	.float 0.237547
	.float -0.203024
	.float -0.044099
	.float 0.408470
	.float -0.735124
	.float 0.890695
	.float -0.826895
	.float 0.593838
	.float -0.302079
	.float 0.057554
	.float 0.095186
	.float -0.190989
	.float 0.311358
	.float -0.518292
	.float 0.795934
	.float -1.043903
	.float 1.134966
	.float -1.004165
	.float 0.706359
	.float -0.394939
	.float 0.227360
	.float -0.258681
	.float 0.398429
	.float -0.466178
	.float 0.312910
	.float 0.072420
	.float -0.543733
	.float 0.880433
	.float -0.918825
	.float 0.649343
	.float -0.220659
	.float -0.148329
	.float 0.293623
	.float -0.194109
	.float -0.026875
	.float 0.185566
	.float -0.156486
	.float -0.046837
	.float 0.281596
	.float -0.372505
	.float 0.232973
	.float 0.072492
	.float -0.370925
	.float 0.499747
	.float -0.416518
	.float 0.218860
	.float -0.062396
	.float 0.041315
	.float -0.123934
	.float 0.190525
	.float -0.139473
	.float -0.024127
	.float 0.187032
	.float -0.212670
	.float 0.045387
	.float 0.244809
	.float -0.507478
	.float 0.610394
	.float -0.519484
	.float 0.306583
	.float -0.086119
	.float -0.070499
	.float 0.181329
	.float -0.330003
	.float 0.589954
	.float -0.952194
	.float 1.311156
	.float -1.522093
	.float 1.492347
	.float -1.242280
	.float 0.893115
	.float -0.591325
	.float 0.421489
	.float -0.363492
	.float 0.315569
	.float -0.163958
	.float -0.142066
	.float 0.549411
	.float -0.917579
	.float 1.090092
	.float -0.987763
	.float 0.667330
	.float -0.298095
	.float 0.060379
	.float -0.032494
	.float 0.151002
	.float -0.275602
	.float 0.302926
	.float -0.232256
	.float 0.132060
	.float -0.050025
	.float -0.038789
	.float 0.192226
	.float -0.410062
	.float 0.588395
	.float -0.578578
	.float 0.313665
	.float 0.102495
	.float -0.427575
	.float 0.427140
	.float -0.039275
	.float -0.557211
	.float 1.024688
	.float -1.057554
	.float 0.570182
	.float 0.232381
	.float -0.950388
	.float 1.204273
	.float -0.847145
	.float 0.049354
	.float 0.798050
	.float -1.305430
	.float 1.298629
	.float -0.897210
	.float 0.415328
	.float -0.156444
	.float 0.236816
	.float -0.545927
	.float 0.854781
	.float -0.982208
	.float 0.898692
	.float -0.704395
	.float 0.519499
	.float -0.387073
	.float 0.266162
	.float -0.105773
	.float -0.079767
	.float 0.206847
	.float -0.189394
	.float 0.007679
	.float 0.285775
	.float -0.620295
	.float 0.956707
	.float -1.277691
	.float 1.533868
	.float -1.618520
	.float 1.423698
	.float -0.947196
	.float 0.352989
	.float 0.090980
	.float -0.174353
	.float -0.109133
	.float 0.545453
	.float -0.833679
	.float 0.775941
	.float -0.392516
	.float -0.108894
	.float 0.473608
	.float -0.547128
	.float 0.338405
	.float 0.020892
	.float -0.372869
	.float 0.615017
	.float -0.723625
	.float 0.724618
	.float -0.650657
	.float 0.521215
	.float -0.352169
	.float 0.171567
	.float -0.015585
	.float -0.094137
	.float 0.164579
	.float -0.214147
	.float 0.237127
	.float -0.191788
	.float 0.038736
	.float 0.195157
	.float -0.391207
	.float 0.395422
	.float -0.131409
	.float -0.315813
	.float 0.722335
	.float -0.855839
	.float 0.629564
	.float -0.169261
	.float -0.260545
	.float 0.425074
	.float -0.267170
	.float -0.067339
	.float 0.341004
	.float -0.388877
	.float 0.217408
	.float 0.025635
	.float -0.174549
	.float 0.160955
	.float -0.038157
	.float -0.088121
	.float 0.152209
	.float -0.166521
	.float 0.184760
	.float -0.234779
	.float 0.285344
	.float -0.273168
	.float 0.161896
	.float 0.019492
	.float -0.190249
	.float 0.270710
	.float -0.233442
	.float 0.117370
	.float 0.001131
	.float -0.058561
	.float 0.043687
	.float -0.002953
	.float 0.009454
	.float -0.113991
	.float 0.308568
	.float -0.527370
	.float 0.686849
	.float -0.739204
	.float 0.701474
	.float -0.638917
	.float 0.615330
	.float -0.648455
	.float 0.702932
	.float -0.721989
	.float 0.668248
	.float -0.543268
	.float 0.380305
	.float -0.229320
	.float 0.150262
	.float -0.204917
	.float 0.426371
	.float -0.769882
	.float 1.091176
	.float -1.202563
	.float 0.999700
	.float -0.570641
	.float 0.179324
	.float -0.098957
	.float 0.401976
	.float -0.874681
	.float 1.146202
	.float -0.952269
	.float 0.336206
	.float 0.371146
	.float -0.779735
	.float 0.700619
	.float -0.243773
	.float -0.304029
	.float 0.703262
	.float -0.902411
	.float 0.999143
	.float -1.085132
	.float 1.130420
	.float -1.012468
	.float 0.656335
	.float -0.148363
	.float -0.290633
	.float 0.461263
	.float -0.341901
	.float 0.111295
	.float -0.013437
	.float 0.170286
	.float -0.490409
	.float 0.742187
	.float -0.730826
	.float 0.442570
	.float -0.052786
	.float -0.198742
	.float 0.168613
	.float 0.105745
	.float -0.446972
	.float 0.665402
	.float -0.682226
	.float 0.567305
	.float -0.473087
	.float 0.515222
	.float -0.686664
	.float 0.866914
	.float -0.920211
	.float 0.808431
	.float -0.630232
	.float 0.550150
	.float -0.666343
	.float 0.917111
	.float -1.103334
	.float 1.020372
	.float -0.610334
	.float 0.025831
	.float 0.445783
	.float -0.552954
	.float 0.234252
	.float 0.344477
	.float -0.893521
	.float 1.173133
	.float -1.124429
	.float 0.879036
	.float -0.654594
	.float 0.616325
	.float -0.793952
	.float 1.090083
	.float -1.349801
	.float 1.433886
	.float -1.261084
	.float 0.824150
	.float -0.197576
	.float -0.465102
	.float 0.967934
	.float -1.152202
	.float 0.983883
	.float -0.584166
	.float 0.164290
	.float 0.101279
	.float -0.171675
	.float 0.131421
	.float -0.086389
	.float 0.054994
	.float 0.048333
	.float -0.320061
	.float 0.744283
	.float -1.149117
	.float 1.291059
	.float -1.014525
	.float 0.373715
	.float 0.371754
	.float -0.890120
	.float 0.957815
	.float -0.577853
	.float -0.030743
	.float 0.558769
	.float -0.768645
	.float 0.600010
	.float -0.171000
	.float -0.307254
	.float 0.642142
	.float -0.737583
	.float 0.612394
	.float -0.367048
	.float 0.123666
	.float 0.034262
	.float -0.098517
	.float 0.131100
	.float -0.215531
	.float 0.388990
	.float -0.598714
	.float 0.717205
	.float -0.614233
	.float 0.242286
	.float 0.319214
	.float -0.889879
	.float 1.269528
	.float -1.329381
	.float 1.068161
	.float -0.611050
	.float 0.155728
	.float 0.111395
	.float -0.094809
	.float -0.167689
	.float 0.521555
	.float -0.765635
	.float 0.744217
	.float -0.417284
	.float -0.121379
	.float 0.682468
	.float -1.057038
	.float 1.100192
	.float -0.791794
	.float 0.248186
	.float 0.325750
	.float -0.727449
	.float 0.846310
	.float -0.703048
	.float 0.418294
	.float -0.135053
	.float -0.052509
	.float 0.122940
	.float -0.102316
	.float 0.022201
	.float 0.102754
	.float -0.265560
	.float 0.442623
	.float -0.582252
	.float 0.621103
	.float -0.520512
	.float 0.296959
	.float -0.022452
	.float -0.209849
	.float 0.335344
	.float -0.351487
	.float 0.314004
	.float -0.299290
	.float 0.357179
	.float -0.482565
	.float 0.619729
	.float -0.694664
	.float 0.656305
	.float -0.504766
	.float 0.290549
	.float -0.084811
	.float -0.061910
	.float 0.145213
	.float -0.198436
	.float 0.256368
	.float -0.318460
	.float 0.339443
	.float -0.255364
	.float 0.027671
	.float 0.322019
	.float -0.705814
	.float 0.995548
	.float -1.071020
	.float 0.873966
	.float -0.446960
	.float -0.065622
	.float 0.468762
	.float -0.609577
	.float 0.468327
	.float -0.187721
	.float 0.003416
	.float -0.100213
	.float 0.479483
	.float -0.933811
	.float 1.163101
	.float -0.966793
	.float 0.384746
	.float 0.312615
	.float -0.782504
	.float 0.811442
	.float -0.430508
	.float -0.120712
	.float 0.543599
	.float -0.641549
	.float 0.400909
	.float 0.034926
	.float -0.460205
	.float 0.706300
	.float -0.700067
	.float 0.471501
	.float -0.126638
	.float -0.194450
	.float 0.363802
	.float -0.310374
	.float 0.052471
	.float 0.300881
	.float -0.592297
	.float 0.690938
	.float -0.562340
	.float 0.288992
	.float -0.023015
	.float -0.105202
	.float 0.067200
	.float 0.046989
	.float -0.090975
	.float -0.032219
	.float 0.288629
	.float -0.515630
	.float 0.517859
	.float -0.202291
	.float -0.337964
	.float 0.855657
	.float -1.086062
	.float 0.902826
	.float -0.391198
	.float -0.207251
	.float 0.637916
	.float -0.770785
	.float 0.651671
	.float -0.448456
	.float 0.337654
	.float -0.402918
	.float 0.599316
	.float -0.792930
	.float 0.845601
	.float -0.694947
	.float 0.389672
	.float -0.064918
	.float -0.127954
	.float 0.102109
	.float 0.114028
	.float -0.386251
	.float 0.546079
	.float -0.489491
	.float 0.244120
	.float 0.043056
	.float -0.195752
	.float 0.118070
	.float 0.152542
	.float -0.485292
	.float 0.753293
	.float -0.908197
	.float 0.975394
	.float -0.985483
	.float 0.916399
	.float -0.710892
	.float 0.359752
	.float 0.029982
	.float -0.263645
	.float 0.185820
	.float 0.186512
	.float -0.639624
	.float 0.885861
	.float -0.755114
	.float 0.317196
	.float 0.156503
	.float -0.365316
	.float 0.166187
	.float 0.346992
	.float -0.910933
	.float 1.247135
	.float -1.199689
	.float 0.784379
	.float -0.147009
	.float -0.518998
	.float 1.042556
	.float -1.312750
	.float 1.296435
	.float -1.049301
	.float 0.711578
	.float -0.465639
	.float 0.451937
	.float -0.681821
	.float 1.011079
	.float -1.211713
	.float 1.111333
	.float -0.709697
	.float 0.184178
	.float 0.229551
	.float -0.401812
	.float 0.397189
	.float -0.416813
	.float 0.634294
	.float -1.048487
	.float 1.465941
	.float -1.626788
	.float 1.379227
	.float -0.775068
	.float 0.027306
	.float 0.623028
	.float -1.027472
	.float 1.164559
	.float -1.093865
	.float 0.889223
	.float -0.603563
	.float 0.272937
	.float 0.066670
	.float -0.373816
	.float 0.609932
	.float -0.750583
	.float 0.792066
	.float -0.752819
	.float 0.668734
	.float -0.578157
	.float 0.497974
	.float -0.406470
	.float 0.254917
	.float -0.012353
	.float -0.285172
	.float 0.526303
	.float -0.580935
	.float 0.391619
	.float -0.031745
	.float -0.322919
	.float 0.498075
	.float -0.425471
	.float 0.169713
	.float 0.138530
	.float -0.403484
	.float 0.616248
	.float -0.823068
	.float 1.048487
	.float -1.247106
	.float 1.326550
	.float -1.219736
	.float 0.943101
	.float -0.591289
	.float 0.272454
	.float -0.036655
	.float -0.144347
	.float 0.328206
	.float -0.523418
	.float 0.650434
	.float -0.586011
	.float 0.268423
	.float 0.217204
	.float -0.652353
	.float 0.807159
	.float -0.593402
	.float 0.135348
	.float 0.301960
	.float -0.482451
	.float 0.345946
	.float -0.028162
	.float -0.253073
	.float 0.350649
	.float -0.263746
	.float 0.094376
	.float 0.054391
	.float -0.138753
	.float 0.150681
	.float -0.062197
	.float -0.176958
	.float 0.565839
	.float -0.977206
	.float 1.182364
	.float -0.994314
	.float 0.427840
	.float 0.265323
	.float -0.737708
	.float 0.769641
	.float -0.407141
	.float -0.087357
	.float 0.425474
	.float -0.474824
	.float 0.304649
	.float -0.085152
	.float -0.059999
	.float 0.131291
	.float -0.217753
	.float 0.396334
	.float -0.653325
	.float 0.883709
	.float -0.959926
	.float 0.816356
	.float -0.493348
	.float 0.117323
	.float 0.167098
	.float -0.271207
	.float 0.201494
	.float -0.044818
	.float -0.088924
	.float 0.131124
	.float -0.087987
	.float 0.024931
	.float -0.013576
	.float 0.076798
	.float -0.168663
	.float 0.204784
	.float -0.125838
	.float -0.047706
	.float 0.210795
	.float -0.231177
	.float 0.039900
	.float 0.302831
	.float -0.616155
	.float 0.688613
	.float -0.403108
	.float -0.178138
	.float 0.825900
	.float -1.255278
	.float 1.277506
	.float -0.905362
	.float 0.347201
	.float 0.111990
	.float -0.275011
	.float 0.142318
	.float 0.103649
	.float -0.229768
	.float 0.110558
	.float 0.195000
	.float -0.497103
	.float 0.610844
	.float -0.469168
	.float 0.136893
	.float 0.262449
	.float -0.628754
	.float 0.909275
	.float -1.068626
	.float 1.065053
	.float -0.877852
	.float 0.563115
	.float -0.267913
	.float 0.161427
	.float -0.319918
	.float 0.656314
	.float -0.959356
	.float 1.023183
	.float -0.778311
	.float 0.337097
	.float 0.070162
	.float -0.222522
	.float 0.024015
	.float 0.448125
	.float -0.979597
	.float 1.320705
	.float -1.308375
	.float 0.951148
	.float -0.430088
	.float 0.007330
	.float 0.111944
	.float 0.112663
	.float -0.540818
	.float 0.932100
	.float -1.071446
	.float 0.868661
	.float -0.387431
	.float -0.196224
	.float 0.674498
	.float -0.889533
	.float 0.787771
	.float -0.432189
	.float -0.028534
	.float 0.420031
	.float -0.605539
	.float 0.527716
	.float -0.220137
	.float -0.205068
	.float 0.585725
	.float -0.757269
	.float 0.622232
	.float -0.220384
	.float -0.251753
	.float 0.516512
	.float -0.371185
	.float -0.165700
	.float 0.828991
	.float -1.243911
	.float 1.149695
	.float -0.560280
	.float -0.249214
	.float 0.917347
	.float -1.205099
	.float 1.097087
	.float -0.746631
	.float 0.335568
	.float 0.030140
	.float -0.322394
	.float 0.524983
	.float -0.590464
	.float 0.475003
	.float -0.216456
	.float -0.034426
	.float 0.087121
	.float 0.148701
	.float -0.564838
	.float 0.889578
	.float -0.851672
	.float 0.368645
	.float 0.371456
	.float -0.999271
	.float 1.176215
	.float -0.798259
	.float 0.063091
	.float 0.641904
	.float -0.960775
	.float 0.763313
	.float -0.199734
	.float -0.404271
	.float 0.736405
	.float -0.657307
	.float 0.251459
	.float 0.239698
	.float -0.552925
	.float 0.534452
	.float -0.205620
	.float -0.265543
	.float 0.668212
	.float -0.866992
	.float 0.861591
	.float -0.752601
	.float 0.644577
	.float -0.563425
	.float 0.449923
	.float -0.226667
	.float -0.122773
	.float 0.526008
	.float -0.860020
	.float 1.017747
	.float -0.955699
	.float 0.704070
	.float -0.352384
	.float 0.026698
	.float 0.143034
	.float -0.073380
	.float -0.216556
	.float 0.584047
	.float -0.815209
	.float 0.743815
	.float -0.367963
	.float -0.124145
	.float 0.456900
	.float -0.442260
	.float 0.106130
	.float 0.328033
	.float -0.590756
	.float 0.545128
	.float -0.267933
	.float -0.014531
	.float 0.079443
	.float 0.158477
	.float -0.609518
	.float 1.072730
	.float -1.348981
	.float 1.337691
	.float -1.074101
	.float 0.698965
	.float -0.382597
	.float 0.243869
	.float -0.301629
	.float 0.476038
	.float -0.631156
	.float 0.636002
	.float -0.422401
	.float 0.022956
	.float 0.428120
	.float -0.745660
	.float 0.787717
	.float -0.548102
	.float 0.180533
	.float 0.083532
	.float -0.086606
	.float -0.136033
	.float 0.367769
	.float -0.362029
	.float 0.032095
	.float 0.464023
	.float -0.817459
	.float 0.780045
	.float -0.339669
	.float -0.269679
	.float 0.727458
	.float -0.835393
	.float 0.626995
	.float -0.311513
	.float 0.109113
	.float -0.103191
	.float 0.208937
	.float -0.265433
	.float 0.172809
	.float 0.027613
	.float -0.185391
	.float 0.158315
	.float 0.072639
	.float -0.376374
	.float 0.554558
	.float -0.475385
	.float 0.162154
	.float 0.224691
	.float -0.493405
	.float 0.534863
	.float -0.368645
	.float 0.104528
	.float 0.135384
	.float -0.274333
	.float 0.292910
	.float -0.214141
	.float 0.091178
	.float -0.002930
	.float 0.035276
	.float -0.232902
	.float 0.545798
	.float -0.823426
	.float 0.889318
	.float -0.662454
	.float 0.237570
	.float 0.150772
	.float -0.271449
	.float 0.050627
	.float 0.376800
	.float -0.756377
	.float 0.876911
	.float -0.690056
	.float 0.312988
	.float 0.067351
	.float -0.305015
	.float 0.347561
	.float -0.219417
	.float -0.021880
	.float 0.310043
	.float -0.568593
	.float 0.710690
	.float -0.665220
	.float 0.419918
	.float -0.043779
	.float -0.340057
	.float 0.621380
	.float -0.765489
	.float 0.826085
	.float -0.897917
	.float 1.039722
	.float -1.218729
	.float 1.315197
	.float -1.190992
	.float 0.786891
	.float -0.190291
	.float -0.377610
	.float 0.663956
	.float -0.526857
	.float 0.032313
	.float 0.564295
	.float -0.953380
	.float 0.946806
	.float -0.585090
	.float 0.107431
	.float 0.197046
	.float -0.161519
	.float -0.170900
	.float 0.595361
	.float -0.889938
	.float 0.956066
	.float -0.860449
	.float 0.756246
	.float -0.747916
	.float 0.804399
	.float -0.786713
	.float 0.567896
	.float -0.150613
	.float -0.311206
	.float 0.606680
	.float -0.608609
	.float 0.357740
	.float -0.032329
	.float -0.171169
	.float 0.161433
	.float -0.000367
	.float -0.147696
	.float 0.126439
	.float 0.112099
	.float -0.476216
	.float 0.790113
	.float -0.903997
	.float 0.791648
	.float -0.569383
	.float 0.416604
	.float -0.445452
	.float 0.610233
	.float -0.727374
	.float 0.599584
	.float -0.159972
	.float -0.465877
	.float 1.025460
	.float -1.288460
	.float 1.180477
	.float -0.818774
	.float 0.434695
	.float -0.237773
	.float 0.305272
	.float -0.557494
	.float 0.823515
	.float -0.949759
	.float 0.884049
	.float -0.690241
	.float 0.494645
	.float -0.406020
	.float 0.458959
	.float -0.608534
	.float 0.769807
	.float -0.872657
	.float 0.898593
	.float -0.880427
	.float 0.867638
	.float -0.881942
	.float 0.895923
	.float -0.854181
	.float 0.725378
	.float -0.546216
	.float 0.417552
	.float -0.444424
	.float 0.654034
	.float -0.949017
	.float 1.137588
	.float -1.036151
	.float 0.591134
	.float 0.056147
	.float -0.615720
	.float 0.799225
	.float -0.497726
	.float -0.124156
	.float 0.695668
	.float -0.850715
	.float 0.461806
	.float 0.258009
	.float -0.869340
	.float 0.978187
	.float -0.491187
	.float -0.318988
	.float 0.983438
	.float -1.125812
	.float 0.675291
	.float 0.125468
	.float -0.896421
	.float 1.340207
	.float -1.364363
	.float 1.061479
	.float -0.607852
	.float 0.172653
	.float 0.117613
	.float -0.179905
	.float -0.017370
	.float 0.428904
	.float -0.920795
	.float 1.307824
	.float -1.437069
	.float 1.269134
	.float -0.899121
	.float 0.498477
	.float -0.215794
	.float 0.104241
	.float -0.120710
	.float 0.186182
	.float -0.252341
	.float 0.322698
	.float -0.420568
	.float 0.540788
	.float -0.631481
	.float 0.620382
	.float -0.463049
	.float 0.177302
	.float 0.156174
	.float -0.422884
	.float 0.518947
	.float -0.395395
	.float 0.086451
	.float 0.295528
	.float -0.606040
	.float 0.737088
	.float -0.668445
	.float 0.466756
	.float -0.235208
	.float 0.052605
	.float 0.053912
	.float -0.092113
	.float 0.071566
	.float 0.009109
	.float -0.144212
	.float 0.296383
	.float -0.398200
	.float 0.389604
	.float -0.264690
	.float 0.087989
	.float 0.039583
	.float -0.044894
	.float -0.070408
	.float 0.236449
	.float -0.370878
	.float 0.440594
	.float -0.480601
	.float 0.555539
	.float -0.694288
	.float 0.848683
	.float -0.910208
	.float 0.775911
	.float -0.422267
	.float -0.060693
	.float 0.498263
	.float -0.710881
	.float 0.604174
	.float -0.222134
	.float -0.266578
	.float 0.644377
	.float -0.745245
	.float 0.529099
	.float -0.093273
	.float -0.380505
	.float 0.712040
	.float -0.796623
	.float 0.634908
	.float -0.314147
	.float -0.040505
	.float 0.317000
	.float -0.448686
	.float 0.421748
	.float -0.264359
	.float 0.029719
	.float 0.219228
	.float -0.423066
	.float 0.539775
	.float -0.558254
	.float 0.502579
	.float -0.420213
	.float 0.358002
	.float -0.340927
	.float 0.366213
	.float -0.411960
	.float 0.448972
	.float -0.449061
	.float 0.393967
	.float -0.289569
	.float 0.176338
	.float -0.116961
	.float 0.155277
	.float -0.272249
	.float 0.380630
	.float -0.376654
	.float 0.217293
	.float 0.038719
	.float -0.265173
	.float 0.356840
	.float -0.303093
	.float 0.188618
	.float -0.121853
	.float 0.149514
	.float -0.223216
	.float 0.239274
	.float -0.115587
	.float -0.152548
	.float 0.491816
	.float -0.794688
	.float 0.970679
	.float -0.975287
	.float 0.811579
	.float -0.519394
	.float 0.165417
	.float 0.164644
	.float -0.380090
	.float 0.411910
	.float -0.246316
	.float -0.051500
	.float 0.344480
	.float -0.472130
	.float 0.327935
	.float 0.072966
	.float -0.581680
	.float 0.980586
	.float -1.097695
	.float 0.903058
	.float -0.523755
	.float 0.165840
	.float 0.005701
	.float 0.049705
	.float -0.250468
	.float 0.467597
	.float -0.610495
	.float 0.663303
	.float -0.654708
	.float 0.598126
	.float -0.460521
	.float 0.192556
	.float 0.202633
	.float -0.623860
	.float 0.900865
	.float -0.891643
	.float 0.582899
	.float -0.116919
	.float -0.280189
	.float 0.421560
	.float -0.250888
	.float -0.151750
	.float 0.636977
	.float -1.066453
	.float 1.352605
	.float -1.451181
	.float 1.341411
	.float -1.029922
	.float 0.577958
	.float -0.115377
	.float -0.195112
	.float 0.238891
	.float -0.024719
	.float -0.305498
	.float 0.550776
	.float -0.564706
	.float 0.333705
	.float 0.029336
	.float -0.363227
	.float 0.549309
	.float -0.558108
	.float 0.437232
	.float -0.266854
	.float 0.118946
	.float -0.036568
	.float 0.028939
	.float -0.073626
	.float 0.125651
	.float -0.136527
	.float 0.078289
	.float 0.042070
	.float -0.188534
	.float 0.317390
	.float -0.396191
	.float 0.405931
	.float -0.330296
	.float 0.151700
	.float 0.130268
	.float -0.466682
	.float 0.745013
	.float -0.823572
	.float 0.610779
	.float -0.142054
	.float -0.407755
	.float 0.802435
	.float -0.873158
	.float 0.614367
	.float -0.181094
	.float -0.209563
	.float 0.402944
	.float -0.376672
	.float 0.222605
	.float -0.071433
	.float 0.019073
	.float -0.092693
	.float 0.254841
	.float -0.423653
	.float 0.498415
	.float -0.396966
	.float 0.106616
	.float 0.276668
	.float -0.564137
	.float 0.564769
	.float -0.211675
	.float -0.361555
	.float 0.867594
	.float -1.028214
	.float 0.755838
	.float -0.225747
	.float -0.224999
	.float 0.316362
	.float -0.016815
	.float -0.427754
	.float 0.655366
	.float -0.435423
	.float -0.165346
	.float 0.813519
	.float -1.118647
	.float 0.883855
	.float -0.232395
	.float -0.470816
	.float 0.848861
	.float -0.743937
	.float 0.303436
	.float 0.129721
	.float -0.247610
	.float -0.022005
	.float 0.475352
	.float -0.778209
	.float 0.698598
	.float -0.268052
	.float -0.239363
	.float 0.493876
	.float -0.330251
	.float -0.152053
	.float 0.671339
	.float -0.958462
	.float 0.919782
	.float -0.659780
	.float 0.366398
	.float -0.160149
	.float 0.022291
	.float 0.154527
	.float -0.445702
	.float 0.805087
	.float -1.078053
	.float 1.108168
	.float -0.857338
	.float 0.448948
	.float -0.099430
	.float -0.015219
	.float -0.136110
	.float 0.435855
	.float -0.710439
	.float 0.845180
	.float -0.836737
	.float 0.754530
	.float -0.657324
	.float 0.541340
	.float -0.360416
	.float 0.091011
	.float 0.221748
	.float -0.477885
	.float 0.580452
	.float -0.486332
	.float 0.214584
	.float 0.177113
	.float -0.611798
	.float 0.989402
	.float -1.181201
	.float 1.059640
	.float -0.570670
	.float -0.194814
	.float 0.994830
	.float -1.525300
	.float 1.566919
	.float -1.104618
	.float 0.344208
	.float 0.388421
	.float -0.810589
	.float 0.819373
	.float -0.529868
	.float 0.198475
	.float -0.074316
	.float 0.259923
	.float -0.657575
	.float 1.033102
	.float -1.160908
	.float 0.963243
	.float -0.555297
	.float 0.165902
	.float 0.014201
	.float 0.046765
	.float -0.214596
	.float 0.299045
	.float -0.198994
	.float -0.024986
	.float 0.204939
	.float -0.204969
	.float 0.036357
	.float 0.144820
	.float -0.160300
	.float -0.042203
	.float 0.335702
	.float -0.504525
	.float 0.413501
	.float -0.124155
	.float -0.137847
	.float 0.146611
	.float 0.147870
	.float -0.563049
	.float 0.794030
	.float -0.618179
	.float 0.054256
	.float 0.634855
	.float -1.101161
	.float 1.129139
	.float -0.768872
	.float 0.296783
	.float -0.029689
	.float 0.115695
	.float -0.441068
	.float 0.715104
	.float -0.674584
	.float 0.267702
	.float 0.307283
	.float -0.731210
	.float 0.767372
	.float -0.399556
	.float -0.178569
	.float 0.696232
	.float -0.956650
	.float 0.911758
	.float -0.637484
	.float 0.256468
	.float 0.128743
	.float -0.460271
	.float 0.714138
	.float -0.877361
	.float 0.932344
	.float -0.857764
	.float 0.646189
	.float -0.327425
	.float -0.023029
	.float 0.306240
	.float -0.446218
	.float 0.431465
	.float -0.321208
	.float 0.211640
	.float -0.185825
	.float 0.277775
	.float -0.464929
	.float 0.682140
	.float -0.844692
	.float 0.874732
	.float -0.729345
	.float 0.422446
	.float -0.025772
	.float -0.358741
	.float 0.643343
	.float -0.787866
	.float 0.799949
	.float -0.705501
	.float 0.517552
	.float -0.233719
	.float -0.132448
	.float 0.515216
	.float -0.796444
	.float 0.858754
	.float -0.664382
	.float 0.301385
	.float 0.046826
	.float -0.198504
	.float 0.075886
	.float 0.256230
	.float -0.638223
	.float 0.911180
	.float -0.993727
	.float 0.897962
	.float -0.692780
	.float 0.454957
	.float -0.242145
	.float 0.091554
	.float -0.025237
	.float 0.045423
	.float -0.121152
	.float 0.182967
	.float -0.141096
	.float -0.071478
	.float 0.448438
	.float -0.881521
	.float 1.182492
	.float -1.163426
	.float 0.747618
	.float -0.050776
	.float -0.629657
	.float 0.938114
	.float -0.648359
	.float -0.187488
	.float 1.226332
	.float -1.985940
	.float 2.091645
	.float -1.482908
	.float 0.456515
	.float 0.488624
	.float -0.922506
	.float 0.713697
	.float -0.079620
	.float -0.570092
	.float 0.890719
	.float -0.788999
	.float 0.424079
	.float -0.047583
	.float -0.178932
	.float 0.250722
	.float -0.244453
	.float 0.197810
	.float -0.067337
	.float -0.200222
	.float 0.564751
	.float -0.872186
	.float 0.951845
	.float -0.751376
	.float 0.388573
	.float -0.070557
	.float -0.053349
	.float -0.015563
	.float 0.154463
	.float -0.231303
	.float 0.199675
	.float -0.105486
	.float 0.018927
	.float 0.036778
	.float -0.099040
	.float 0.219596
	.float -0.402691
	.float 0.577657
	.float -0.625737
	.float 0.446596
	.float -0.028626
	.float -0.517722
	.float 0.991235
	.float -1.191508
	.float 1.026789
	.float -0.572751
	.float 0.038393
	.float 0.346333
	.float -0.453526
	.float 0.313197
	.float -0.070283
	.float -0.122670
	.float 0.201884
	.float -0.215597
	.float 0.266965
	.float -0.425423
	.float 0.672361
	.float -0.914980
	.float 1.048547
	.float -1.014584
	.float 0.816049
	.float -0.493080
	.float 0.093888
	.float 0.330907
	.float -0.715262
	.float 0.974789
	.float -1.034306
	.float 0.873522
	.float -0.555232
	.float 0.206517
	.float 0.043181
	.float -0.129838
	.float 0.083470
	.float 0.001702
	.float -0.032993
	.float -0.026976
	.float 0.155208
	.float -0.305546
	.float 0.446754
	.float -0.564498
	.float 0.633317
	.float -0.602842
	.float 0.431342
	.float -0.146768
	.float -0.128366
	.float 0.234413
	.float -0.088229
	.float -0.234490
	.float 0.524849
	.float -0.569073
	.float 0.290681
	.float 0.197075
	.float -0.663810
	.float 0.903806
	.float -0.848450
	.float 0.582375
	.float -0.269852
	.float 0.052055
	.float 0.020050
	.float 0.012447
	.float -0.067044
	.float 0.085520
	.float -0.076139
	.float 0.108030
	.float -0.258410
	.float 0.541816
	.float -0.868240
	.float 1.068689
	.float -0.987227
	.float 0.588523
	.float -0.006257
	.float -0.514021
	.float 0.754839
	.float -0.662651
	.float 0.384287
	.float -0.170047
	.float 0.202908
	.float -0.470756
	.float 0.773217
	.float -0.861656
	.float 0.616373
	.float -0.139020
	.float -0.300536
	.float 0.424282
	.float -0.108853
	.float -0.544201
	.float 1.260673
	.float -1.728168
	.float 1.738177
	.float -1.270696
	.float 0.489312
	.float 0.342998
	.float -0.982926
	.float 1.301293
	.float -1.309836
	.float 1.118376
	.float -0.861218
	.float 0.639594
	.float -0.501357
	.float 0.447473
	.float -0.445556
	.float 0.446033
	.float -0.406238
	.float 0.318302
	.float -0.218013
	.float 0.157145
	.float -0.153097
	.float 0.160081
	.float -0.095824
	.float -0.088303
	.float 0.349573
	.float -0.561413
	.float 0.588514
	.float -0.376538
	.float -0.008527
	.float 0.417263
	.float -0.699835
	.float 0.777601
	.float -0.665682
	.float 0.449482
	.float -0.243058
	.float 0.150624
	.float -0.231909
	.float 0.468658
	.float -0.748229
	.float 0.895673
	.float -0.764195
	.float 0.341851
	.float 0.205778
	.float -0.611264
	.float 0.669395
	.float -0.379900
	.float -0.040650
	.float 0.296992
	.float -0.208821
	.float -0.177752
	.float 0.636256
	.float -0.921352
	.float 0.925659
	.float -0.726775
	.float 0.506313
	.float -0.409710
	.float 0.444880
	.float -0.482249
	.float 0.350157
	.float 0.037467
	.float -0.602460
	.float 1.125413
	.float -1.362843
	.float 1.189738
	.float -0.677770
	.float 0.055956
	.float 0.422437
	.float -0.619115
	.float 0.565094
	.float -0.401073
	.float 0.256295
	.float -0.159066
	.float 0.040675
	.float 0.179566
	.float -0.501962
	.float 0.820955
	.float -0.985915
	.float 0.901765
	.float -0.597730
	.float 0.219576
	.float 0.045529
	.float -0.064491
	.float -0.175624
	.float 0.558355
	.float -0.888549
	.float 0.985900
	.float -0.785085
	.float 0.390465
	.float -0.039421
	.float -0.027380
	.float -0.276863
	.float 0.803722
	.float -1.234802
	.float 1.268678
	.float -0.813897
	.float 0.057802
	.float 0.638941
	.float -0.955318
	.float 0.792525
	.float -0.313536
	.float -0.175368
	.float 0.416696
	.float -0.345594
	.float 0.104752
	.float 0.065443
	.float 0.015782
	.float -0.362505
	.float 0.824600
	.float -1.187607
	.float 1.298966
	.float -1.138596
	.float 0.796211
	.float -0.386293
	.float -0.027231
	.float 0.440981
	.float -0.860646
	.float 1.243616
	.float -1.491924
	.float 1.504389
	.float -1.245839
	.float 0.779530
	.float -0.241695
	.float -0.218036
	.float 0.490570
	.float -0.531972
	.float 0.363713
	.float -0.063842
	.float -0.247321
	.float 0.436934
	.float -0.410816
	.float 0.167113
	.float 0.185487
	.float -0.473063
	.float 0.550645
	.float -0.388370
	.float 0.087820
	.float 0.187714
	.float -0.321834
	.float 0.314478
	.float -0.263322
	.float 0.276175
	.float -0.384904
	.float 0.526571
	.float -0.601152
	.float 0.555172
	.float -0.423000
	.float 0.295963
	.float -0.248231
	.float 0.281239
	.float -0.329586
	.float 0.319837
	.float -0.232945
	.float 0.122029
	.float -0.075279
	.float 0.154880
	.float -0.354571
	.float 0.600004
	.float -0.787255
	.float 0.837342
	.float -0.741225
	.float 0.573389
	.float -0.460521
	.float 0.509389
	.float -0.727306
	.float 0.987230
	.float -1.077228
	.float 0.823435
	.float -0.217445
	.float -0.540943
	.float 1.131410
	.float -1.290379
	.float 0.966909
	.float -0.349701
	.float -0.256944
	.float 0.621157
	.float -0.699957
	.float 0.606078
	.float -0.469966
	.float 0.326266
	.float -0.124675
	.float -0.155524
	.float 0.410697
	.float -0.448531
	.float 0.143175
	.float 0.421513
	.float -0.957023
	.float 1.142572
	.float -0.841509
	.float 0.197819
	.float 0.459970
	.float -0.834189
	.float 0.836129
	.float -0.607712
	.float 0.386904
	.float -0.323926
	.float 0.379366
	.float -0.368699
	.float 0.114667
	.float 0.403442
	.float -1.009756
	.float 1.430321
	.float -1.461690
	.float 1.091522
	.float -0.491280
	.float -0.102373
	.float 0.520438
	.float -0.713697
	.float 0.707671
	.float -0.527659
	.float 0.175523
	.float 0.323402
	.float -0.861576
	.float 1.255469
	.float -1.335918
	.float 1.063032
	.float -0.575180
	.float 0.125590
	.float 0.058953
	.float 0.091959
	.float -0.453916
	.float 0.779914
	.float -0.835211
	.float 0.516006
	.float 0.107658
	.float -0.835074
	.float 1.429230
	.float -1.710366
	.float 1.611197
	.float -1.185070
	.float 0.578119
	.float 0.020166
	.float -0.438811
	.float 0.587969
	.float -0.498096
	.float 0.307125
	.float -0.187259
	.float 0.243906
	.float -0.449350
	.float 0.659807
	.float -0.709858
	.float 0.521752
	.float -0.154939
	.float -0.234669
	.float 0.492350
	.float -0.549375
	.float 0.441637
	.float -0.260227
	.float 0.077760
	.float 0.093914
	.float -0.286068
	.float 0.512694
	.float -0.718207
	.float 0.782740
	.float -0.595319
	.float 0.150948
	.float 0.400667
	.float -0.804616
	.float 0.833169
	.float -0.423355
	.float -0.271077
	.float 0.954483
	.float -1.351348
	.float 1.357589
	.float -1.086294
	.float 0.777297
	.float -0.626870
	.float 0.648422
	.float -0.660618
	.float 0.417677
	.float 0.200489
	.float -1.068561
	.float 1.854674
	.float -2.200599
	.float 1.929770
	.float -1.152920
	.float 0.211702
	.float 0.495566
	.float -0.699409
	.float 0.361906
	.float 0.334841
	.float -1.085528
	.float 1.589430
	.float -1.661030
	.float 1.291369
	.float -0.641176
	.float -0.034148
	.float 0.500152
	.float -0.645662
	.float 0.518846
	.float -0.278291
	.float 0.092262
	.float -0.049172
	.float 0.130482
	.float -0.250230
	.float 0.323262
	.float -0.313250
	.float 0.236502
	.float -0.131631
	.float 0.023995
	.float 0.091210
	.float -0.240282
	.float 0.444594
	.float -0.691567
	.float 0.921007
	.float -1.040568
	.float 0.972497
	.float -0.710425
	.float 0.348441
	.float -0.050714
	.float -0.034181
	.float -0.134093
	.float 0.453761
	.float -0.738814
	.float 0.835929
	.float -0.717938
	.float 0.483056
	.float -0.261745
	.float 0.109328
	.float 0.024601
	.float -0.226201
	.float 0.513815
	.float -0.798667
	.float 0.948317
	.float -0.896009
	.float 0.696214
	.float -0.478806
	.float 0.346542
	.float -0.308750
	.float 0.303230
	.float -0.273771
	.float 0.225194
	.float -0.207661
	.float 0.253713
	.float -0.332886
	.float 0.367396
	.float -0.294097
	.float 0.119714
	.float 0.073959
	.float -0.175761
	.float 0.107656
	.float 0.133338
	.float -0.471462
	.float 0.782534
	.float -0.944344
	.float 0.890057
	.float -0.644541
	.float 0.322251
	.float -0.077286
	.float 0.023175
	.float -0.166459
	.float 0.398939
	.float -0.560209
	.float 0.532941
	.float -0.309069
	.float -0.015644
	.float 0.309388
	.float -0.482311
	.float 0.521975
	.float -0.472470
	.float 0.386659
	.float -0.293190
	.float 0.196438
	.float -0.095513
	.float -0.001628
	.float 0.078106
	.float -0.113118
	.float 0.084395
	.float 0.026713
	.float -0.217566
	.float 0.442436
	.float -0.614158
	.float 0.649250
	.float -0.535087
	.float 0.362198
	.float -0.275550
	.float 0.363605
	.float -0.568346
	.float 0.701605
	.float -0.576315
	.float 0.163584
	.float 0.350485
	.float -0.667816
	.float 0.579695
	.float -0.121132
	.float -0.440323
	.float 0.779974
	.float -0.730650
	.float 0.381572
	.float 0.005924
	.float -0.195705
	.float 0.136746
	.float 0.027091
	.float -0.089332
	.float -0.057901
	.float 0.355519
	.float -0.638875
	.float 0.765155
	.float -0.705602
	.float 0.546490
	.float -0.417537
	.float 0.409800
	.float -0.532780
	.float 0.720552
	.float -0.869352
	.float 0.885548
	.float -0.730125
	.float 0.444427
	.float -0.139037
	.float -0.061510
	.float 0.095697
	.float -0.014465
	.float -0.040704
	.float -0.069793
	.float 0.377402
	.float -0.762246
	.float 1.013628
	.float -0.961142
	.float 0.588330
	.float -0.048873
	.float -0.426046
	.float 0.663214
	.float -0.632634
	.float 0.432704
	.float -0.201004
	.float 0.024094
	.float 0.094200
	.float -0.201870
	.float 0.345961
	.float -0.540848
	.float 0.768189
	.float -0.990052
	.float 1.157057
	.float -1.213435
	.float 1.113354
	.float -0.849603
	.float 0.475167
	.float -0.091935
	.float -0.195619
	.float 0.334063
	.float -0.343216
	.float 0.291345
	.float -0.244078
	.float 0.228028
	.float -0.236057
	.float 0.263489
	.float -0.335514
	.float 0.491163
	.float -0.729094
	.float 0.963761
	.float -1.045906
	.float 0.854378
	.float -0.399281
	.float -0.150867
	.float 0.557977
	.float -0.666621
	.float 0.506984
	.float -0.267161
	.float 0.154517
	.float -0.254375
	.float 0.491661
	.float -0.712743
	.float 0.809182
	.float -0.782325
	.float 0.709459
	.float -0.656201
	.float 0.614695
	.float -0.513797
	.float 0.284879
	.float 0.071640
	.float -0.465716
	.float 0.755605
	.float -0.821900
	.float 0.636753
	.float -0.289004
	.float -0.054517
	.float 0.235946
	.float -0.193092
	.float -0.009495
	.float 0.227556
	.float -0.330689
	.float 0.277945
	.float -0.125631
	.float -0.029788
	.float 0.123244
	.float -0.151690
	.float 0.147768
	.float -0.128944
	.float 0.072367
	.float 0.059731
	.float -0.266553
	.float 0.477081
	.float -0.576193
	.float 0.478240
	.float -0.196943
	.float -0.142155
	.float 0.362371
	.float -0.334823
	.float 0.054822
	.float 0.351007
	.float -0.691636
	.float 0.814607
	.float -0.687570
	.float 0.412711
	.float -0.165105
	.float 0.089512
	.float -0.216751
	.float 0.451589
	.float -0.640103
	.float 0.671830
	.float -0.546782
	.float 0.361188
	.float -0.225906
	.float 0.180855
	.float -0.172540
	.float 0.111267
	.float 0.039655
	.float -0.216819
	.float 0.293257
	.float -0.173615
	.float -0.124233
	.float 0.463749
	.float -0.667387
	.float 0.625663
	.float -0.365823
	.float 0.036475
	.float 0.181881
	.float -0.185889
	.float 0.010799
	.float 0.195457
	.float -0.272761
	.float 0.159531
	.float 0.063492
	.float -0.233540
	.float 0.232763
	.float -0.087989
	.float -0.040022
	.float -0.017648
	.float 0.286804
	.float -0.595992
	.float 0.679231
	.float -0.374830
	.float -0.226118
	.float 0.805710
	.float -1.019678
	.float 0.737228
	.float -0.144383
	.float -0.371930
	.float 0.483560
	.float -0.141666
	.float -0.397112
	.float 0.754786
	.float -0.692884
	.float 0.266651
	.float 0.228306
	.float -0.468473
	.float 0.317739
	.float 0.100632
	.float -0.509168
	.float 0.667682
	.float -0.513350
	.float 0.167966
	.float 0.166205
	.float -0.332895
	.float 0.290614
	.float -0.103387
	.float -0.114059
	.float 0.254810
	.float -0.260710
	.float 0.144214
	.float 0.011383
	.float -0.082797
	.float -0.029951
	.float 0.333982
	.float -0.714248
	.float 0.978631
	.float -0.964340
	.float 0.644046
	.float -0.158803
	.float -0.253235
	.float 0.394715
	.float -0.228138
	.float -0.103144
	.float 0.369823
	.float -0.408965
	.float 0.233313
	.float -0.020753
	.float -0.014973
	.float -0.212295
	.float 0.577978
	.float -0.809722
	.float 0.663053
	.float -0.096041
	.float -0.676322
	.float 1.290382
	.float -1.440621
	.float 1.056308
	.float -0.339329
	.float -0.356431
	.float 0.725097
	.float -0.665458
	.float 0.307620
	.float 0.090613
	.float -0.300482
	.float 0.235946
	.float 0.028624
	.float -0.324731
	.float 0.486439
	.float -0.425560
	.float 0.160537
	.float 0.200175
	.float -0.507350
	.float 0.635090
	.float -0.536016
	.float 0.262049
	.float 0.062843
	.float -0.305665
	.float 0.389243
	.float -0.324579
	.float 0.196903
	.float -0.118235
	.float 0.172389
	.float -0.376460
	.float 0.672072
	.float -0.950004
	.float 1.100800
	.float -1.071893
	.float 0.901332
	.float -0.701710
	.float 0.592714
	.float -0.616438
	.float 0.693010
	.float -0.659438
	.float 0.381428
	.float 0.130771
	.float -0.690250
	.float 1.024611
	.float -0.944007
	.float 0.475632
	.float 0.131125
	.float -0.540964
	.float 0.524962
	.float -0.087012
	.float -0.552239
	.float 1.095102
	.float -1.335027
	.float 1.247004
	.float -0.952787
	.float 0.599986
	.float -0.251877
	.float -0.129458
	.float 0.598222
	.float -1.114928
	.float 1.513056
	.float -1.587097
	.float 1.246381
	.float -0.617258
	.float 0.004362
	.float 0.277460
	.float -0.092984
	.float -0.428609
	.float 0.971415
	.float -1.222708
	.float 1.053771
	.float -0.579904
	.float 0.068023
	.float 0.242275
	.float -0.285319
	.float 0.189727
	.float -0.166107
	.float 0.345275
	.float -0.682018
	.float 0.989352
	.float -1.073690
	.float 0.871063
	.float -0.488904
	.float 0.129911
	.float 0.042294
	.float -0.000497
	.float -0.147468
	.float 0.248880
	.float -0.217493
	.float 0.090435
	.float 0.004128
	.float 0.055822
	.float -0.289929
	.float 0.585582
	.float -0.757856
	.float 0.664045
	.float -0.299710
	.float -0.189382
	.float 0.589909
	.float -0.744986
	.float 0.637156
	.float -0.377453
	.float 0.115261
	.float 0.060845
	.float -0.158365
	.float 0.233089
	.float -0.305066
	.float 0.314568
	.float -0.160969
	.float -0.201496
	.float 0.687991
	.float -1.095176
	.float 1.205689
	.float -0.919934
	.float 0.326913
	.float 0.333580
	.float -0.793684
	.float 0.888943
	.float -0.623803
	.float 0.142937
	.float 0.361242
	.float -0.743442
	.float 0.949661
	.float -0.998958
	.float 0.932651
	.float -0.777226
	.float 0.547375
	.float -0.277883
	.float 0.047154
	.float 0.039589
	.float 0.093989
	.float -0.434835
	.float 0.860217
	.float -1.181598
	.float 1.238128
	.float -0.989733
	.float 0.551330
	.float -0.138279
	.float -0.052514
	.float -0.045339
	.float 0.335851
	.float -0.630265
	.float 0.768168
	.float -0.704356
	.float 0.506501
	.float -0.280469
	.float 0.091882
	.float 0.056758
	.float -0.191351
	.float 0.321193
	.float -0.430699
	.float 0.508948
	.float -0.578247
	.float 0.683830
	.float -0.848161
	.float 1.030899
	.float -1.136071
	.float 1.070155
	.float -0.811793
	.float 0.441786
	.float -0.107402
	.float -0.061147
	.float 0.031056
	.float 0.108966
	.float -0.202416
	.float 0.128337
	.float 0.111126
	.float -0.381190
	.float 0.496400
	.float -0.343401
	.float -0.038153
	.float 0.472676
	.float -0.751808
	.float 0.755000
	.float -0.511806
	.float 0.176089
	.float 0.062311
	.float -0.072842
	.float -0.159384
	.float 0.533108
	.float -0.877623
	.float 1.026250
	.float -0.890725
	.float 0.506289
	.float -0.021649
	.float -0.370985
	.float 0.535528
	.float -0.463704
	.float 0.272042
	.float -0.123480
	.float 0.125871
	.float -0.273688
	.float 0.463749
	.float -0.562033
	.float 0.471224
	.float -0.166761
	.float -0.297788
	.float 0.800041
	.float -1.171709
	.float 1.247681
	.float -0.940630
	.float 0.306821
	.float 0.446778
	.float -1.039084
	.float 1.244572
	.float -1.005258
	.float 0.458435
	.float 0.139031
	.float -0.548579
	.float 0.671854
	.float -0.584735
	.float 0.463245
	.float -0.450593
	.float 0.558254
	.float -0.673461
	.float 0.666126
	.float -0.507687
	.float 0.301209
	.float -0.195445
	.float 0.255870
	.float -0.405445
	.float 0.488737
	.float -0.405657
	.float 0.200335
	.float -0.029201
	.float 0.035485
	.float -0.235119
	.float 0.505654
	.float -0.681940
	.float 0.676170
	.float -0.526536
	.float 0.344244
	.float -0.212443
	.float 0.124018
	.float -0.003860
	.float -0.211321
	.float 0.506096
	.float -0.783971
	.float 0.925471
	.float -0.859412
	.float 0.599873
	.float -0.234750
	.float -0.116983
	.float 0.353773
	.float -0.429703
	.float 0.374725
	.float -0.287421
	.float 0.291477
	.float -0.462309
	.float 0.759441
	.float -1.016253
	.float 1.018277
	.float -0.641710
	.float -0.033251
	.float 0.725941
	.float -1.098130
	.float 0.957946
	.float -0.388877
	.float -0.291217
	.float 0.718171
	.float -0.689373
	.float 0.255002
	.float 0.352038
	.float -0.875891
	.float 1.167384
	.float -1.211301
	.float 1.070918
	.float -0.821739
	.float 0.526998
	.float -0.248321
	.float 0.049046
	.float 0.032913
	.float -0.020301
	.float -0.004619
	.float -0.046989
	.float 0.201516
	.float -0.397481
	.float 0.530425
	.float -0.534422
	.float 0.432865
	.float -0.317459
	.float 0.275846
	.float -0.329616
	.float 0.428514
	.float -0.494159
	.float 0.469570
	.float -0.339994
	.float 0.127935
	.float 0.113930
	.float -0.304601
	.float 0.352139
	.float -0.205364
	.float -0.081133
	.float 0.329240
	.float -0.315223
	.float -0.079794
	.float 0.746435
	.float -1.361091
	.float 1.563497
	.float -1.197964
	.float 0.448364
	.float 0.249346
	.float -0.480326
	.float 0.130092
	.float 0.529188
	.float -1.014903
	.float 0.953872
	.float -0.322454
	.float -0.556558
	.float 1.244057
	.float -1.466948
	.float 1.255707
	.float -0.864518
	.float 0.563398
	.float -0.467999
	.float 0.516181
	.float -0.572325
	.float 0.551035
	.float -0.462202
	.float 0.364714
	.float -0.291615
	.float 0.217670
	.float -0.087332
	.float -0.132599
	.float 0.420440
	.float -0.703054
	.float 0.883405
	.float -0.878773
	.float 0.664534
	.float -0.310538
	.float -0.021279
	.float 0.143865
	.float 0.043346
	.float -0.472076
	.float 0.925415
	.float -1.163718
	.float 1.071499
	.float -0.717265
	.float 0.286266
	.float 0.052258
	.float -0.236071
	.float 0.299472
	.float -0.293733
	.float 0.224395
	.float -0.061330
	.float -0.199420
	.float 0.493050
	.float -0.713277
	.float 0.790009
	.float -0.747186
	.float 0.684515
	.float -0.694378
	.float 0.784328
	.float -0.871701
	.float 0.855040
	.float -0.700690
	.float 0.471397
	.float -0.276246
	.float 0.188665
	.float -0.203746
	.float 0.266753
	.float -0.339347
	.float 0.437840
	.float -0.606648
	.float 0.853079
	.float -1.108514
	.float 1.259072
	.float -1.224251
	.float 1.015025
	.float -0.718105
	.float 0.419659
	.float -0.138136
	.float -0.170724
	.float 0.539569
	.float -0.913660
	.float 1.147781
	.float -1.090220
	.float 0.695594
	.float -0.082703
	.float -0.507288
	.float 0.827146
	.float -0.743895
	.float 0.296304
	.float 0.333655
	.float -0.910825
	.float 1.248822
	.float -1.277882
	.float 1.055032
	.float -0.719625
	.float 0.420452
	.float -0.250503
	.float 0.220640
	.float -0.280820
	.float 0.368204
	.float -0.445550
	.float 0.503085
	.float -0.529275
	.float 0.485873
	.float -0.320576
	.float 0.017678
	.float 0.354613
	.float -0.649903
	.float 0.716791
	.float -0.497428
	.float 0.080832
	.float 0.335309
	.float -0.555726
	.float 0.499038
	.float -0.235338
	.float -0.071987
	.float 0.275221
	.float -0.325065
	.float 0.275862
	.float -0.220949
	.float 0.215015
	.float -0.243001
	.float 0.253053
	.float -0.218494
	.float 0.170918
	.float -0.172118
	.float 0.246112
	.float -0.332734
	.float 0.313468
	.float -0.103361
	.float -0.258132
	.float 0.596887
	.float -0.698983
	.float 0.451720
	.float 0.071157
	.float -0.646562
	.float 1.037480
	.float -1.130256
	.float 0.979743
	.float -0.741794
	.float 0.554457
	.float -0.456995
	.float 0.395478
	.float -0.293422
	.float 0.124604
	.float 0.064146
	.float -0.186683
	.float 0.173478
	.float -0.009663
	.float -0.262004
	.float 0.562417
	.float -0.803078
	.float 0.909633
	.float -0.844087
	.float 0.623988
	.float -0.324585
	.float 0.049630
	.float 0.122326
	.float -0.181100
	.float 0.179590
	.float -0.175856
	.float 0.167704
	.float -0.081825
	.float -0.159107
	.float 0.538639
	.float -0.906432
	.float 1.050746
	.float -0.847100
	.float 0.372255
	.float 0.117604
	.float -0.346593
	.float 0.207871
	.float 0.158331
	.float -0.459293
	.float 0.449964
	.float -0.095816
	.float -0.412363
	.float 0.791079
	.float -0.843318
	.float 0.565481
	.float -0.126654
	.float -0.247166
	.float 0.401815
	.float -0.323598
	.float 0.120499
	.float 0.062427
	.float -0.140367
	.float 0.141119
	.float -0.178852
	.float 0.363474
	.float -0.705668
	.float 1.088008
	.float -1.329241
	.float 1.299219
	.float -1.000031
	.float 0.553756
	.float -0.111245
	.float -0.242030
	.float 0.510009
	.float -0.731249
	.float 0.904897
	.float -0.968876
	.float 0.849472
	.float -0.533754
	.float 0.095400
	.float 0.350891
	.float -0.724588
	.float 1.015523
	.float -1.250730
	.float 1.427665
	.float -1.481686
	.float 1.324729
	.float -0.927310
	.float 0.374746
	.float 0.153086
	.float -0.471349
	.float 0.490472
	.float -0.261867
	.float -0.059101
	.float 0.307516
	.float -0.401126
	.float 0.373819
	.float -0.330987
	.float 0.358422
	.float -0.449082
	.float 0.503136
	.float -0.405481
	.float 0.125208
	.float 0.241071
	.float -0.521660
	.float 0.584047
	.float -0.426416
	.float 0.177852
	.float -0.008770
	.float 0.020923
	.float -0.194672
	.float 0.421307
	.float -0.583948
	.float 0.624873
	.float -0.559774
	.float 0.443574
	.float -0.321777
	.float 0.202684
	.float -0.066418
	.float -0.099392
	.float 0.266090
	.float -0.363602
	.float 0.321429
	.float -0.125151
	.float -0.157196
	.float 0.407308
	.float -0.529549
	.float 0.510274
	.float -0.417090
	.float 0.340235
	.float -0.326624
	.float 0.359671
	.float -0.395213
	.float 0.413358
	.float -0.436078
	.float 0.496284
	.float -0.592464
	.float 0.675681
	.float -0.684772
	.float 0.598475
	.float -0.457806
	.float 0.337601
	.float -0.291065
	.float 0.312744
	.float -0.348041
	.float 0.339526
	.float -0.272277
	.float 0.184099
	.float -0.133087
	.float 0.145976
	.float -0.185646
	.float 0.166412
	.float -0.014568
	.float -0.262837
	.float 0.552472
	.float -0.682986
	.float 0.528297
	.float -0.102060
	.float -0.424279
	.float 0.803850
	.float -0.854411
	.float 0.569881
	.float -0.129685
	.float -0.206213
	.float 0.253664
	.float -0.012630
	.float -0.344161
	.float 0.594934
	.float -0.617610
	.float 0.456149
	.float -0.256822
	.float 0.127817
	.float -0.040042
	.float -0.141840
	.float 0.516313
	.float -1.008284
	.float 1.366229
	.float -1.319886
	.float 0.792152
	.float 0.000801
	.float -0.655840
	.float 0.838999
	.float -0.514772
	.float -0.020224
	.float 0.333339
	.float -0.150894
	.float -0.453860
	.float 1.113566
	.float -1.424002
	.float 1.223819
	.float -0.699018
	.float 0.240295
	.float -0.159229
	.float 0.468497
	.float -0.880758
	.float 1.020268
	.float -0.690494
	.float 0.010860
	.float 0.661452
	.float -0.956859
	.float 0.709921
	.float -0.038448
	.float -0.740521
	.float 1.286779
	.float -1.400522
	.float 1.097537
	.float -0.575055
	.float 0.097186
	.float 0.140103
	.float -0.096906
	.float -0.114651
	.float 0.319113
	.float -0.392862
	.float 0.331219
	.float -0.229481
	.float 0.200917
	.float -0.294083
	.float 0.461749
	.float -0.591388
	.float 0.569192
	.float -0.340164
	.float -0.060306
	.float 0.511955
	.float -0.850736
	.float 0.933271
	.float -0.700076
	.float 0.207509
	.float 0.390620
	.float -0.904674
	.float 1.184128
	.float -1.170743
	.float 0.909714
	.float -0.520062
	.float 0.142491
	.float 0.110302
	.float -0.180996
	.float 0.067364
	.float 0.193551
	.float -0.538490
	.float 0.880627
	.float -1.114391
	.float 1.141293
	.float -0.917913
	.float 0.498066
	.float -0.031626
	.float -0.293025
	.float 0.336471
	.float -0.077268
	.float -0.372654
	.float 0.810085
	.float -1.020161
	.float 0.866175
	.float -0.360160
	.float -0.319855
	.float 0.892072
	.float -1.103095
	.float 0.867149
	.float -0.323771
	.float -0.235604
	.float 0.534756
	.float -0.466297
	.float 0.132898
	.float 0.240062
	.float -0.448078
	.float 0.409054
	.float -0.174140
	.float -0.129833
	.float 0.370147
	.float -0.453478
	.float 0.346560
	.float -0.084286
	.float -0.237066
	.float 0.494585
	.float -0.598919
	.float 0.545739
	.float -0.415784
	.float 0.313721
	.float -0.286401
	.float 0.284243
	.float -0.200246
	.float -0.039806
	.float 0.403648
	.float -0.753272
	.float 0.923772
	.float -0.828791
	.float 0.522530
	.float -0.177114
	.float -0.012608
	.float -0.060919
	.float 0.359588
	.float -0.727747
	.float 0.987921
	.float -1.041030
	.float 0.906802
	.float -0.684661
	.float 0.473522
	.float -0.316272
	.float 0.205808
	.float -0.131785
	.float 0.110856
	.float -0.164620
	.float 0.267520
	.float -0.325124
	.float 0.221438
	.float 0.089321
	.float -0.520014
	.float 0.876115
	.float -0.962873
	.float 0.703438
	.float -0.188412
	.float -0.373289
	.float 0.764329
	.float -0.859001
	.float 0.660904
	.float -0.274420
	.float -0.156266
	.float 0.501842
	.float -0.679255
	.float 0.662347
	.float -0.479528
	.float 0.199057
	.float 0.098623
	.float -0.352309
	.float 0.538085
	.float -0.661813
	.float 0.732864
	.float -0.741734
	.float 0.661473
	.float -0.473462
	.float 0.197196
	.float 0.101114
	.float -0.332379
	.float 0.428532
	.float -0.379962
	.float 0.242918
	.float -0.113253
	.float 0.080915
	.float -0.188212
	.float 0.408437
	.float -0.652287
	.float 0.801922
	.float -0.765116
	.float 0.528708
	.float -0.180748
	.float -0.122345
	.float 0.236228
	.float -0.112414
	.float -0.169650
	.float 0.447595
	.float -0.571863
	.float 0.490785
	.float -0.270859
	.float 0.042642
	.float 0.088909
	.float -0.109778
	.float 0.095800
	.float -0.147234
	.float 0.303936
	.float -0.501297
	.float 0.603193
	.float -0.496790
	.float 0.186187
	.float 0.187192
	.float -0.424764
	.float 0.404876
	.float -0.173814
	.float -0.083183
	.float 0.179473
	.float -0.070606
	.float -0.113921
	.float 0.181970
	.float -0.042774
	.float -0.217444
	.float 0.416377
	.float -0.441697
	.float 0.350762
	.float -0.309334
	.float 0.421423
	.float -0.607497
	.float 0.652061
	.float -0.391178
	.float -0.120834
	.float 0.619586
	.float -0.823036
	.float 0.657810
	.float -0.330787
	.float 0.175508
	.float -0.384904
	.float 0.837398
	.float -1.159152
	.float 0.987930
	.float -0.250964
	.float -0.745949
	.float 1.488911
	.float -1.573744
	.float 0.957085
	.float 0.026166
	.float -0.884517
	.float 1.275605
	.float -1.190471
	.float 0.903362
	.float -0.740199
	.float 0.840117
	.float -1.077541
	.float 1.185627
	.float -0.974038
	.float 0.473856
	.float 0.089067
	.float -0.455130
	.float 0.494522
	.float -0.258954
	.float -0.089793
	.float 0.391821
	.float -0.549384
	.float 0.515877
	.float -0.266695
	.float -0.191019
	.float 0.774609
	.float -1.310041
	.float 1.592634
	.float -1.499709
	.float 1.070805
	.float -0.486737
	.float -0.039655
	.float 0.377533
	.float -0.516500
	.float 0.519034
	.float -0.445905
	.float 0.321986
	.float -0.159111
	.float -0.004013
	.float 0.094889
	.float -0.046222
	.float -0.151301
	.float 0.427739
	.float -0.663998
	.float 0.755689
	.float -0.670594
	.float 0.464804
	.float -0.248115
	.float 0.120297
	.float -0.117605
	.float 0.203007
	.float -0.304041
	.float 0.367504
	.float -0.387479
	.float 0.386784
	.float -0.373134
	.float 0.315733
	.float -0.168922
	.float -0.075379
	.float 0.355692
	.float -0.564203
	.float 0.612939
	.float -0.492332
	.float 0.276083
	.float -0.068716
	.float -0.064575
	.float 0.135708
	.float -0.216111
	.float 0.380373
	.float -0.651417
	.float 0.980389
	.float -1.267948
	.float 1.407824
	.float -1.326982
	.float 1.009640
	.float -0.507654
	.float -0.058632
	.float 0.517955
	.float -0.698801
	.float 0.509824
	.float -0.010846
	.float -0.582130
	.float 0.985820
	.float -0.995760
	.float 0.603101
	.float -0.004213
	.float -0.507529
	.float 0.701155
	.float -0.522151
	.float 0.100120
	.float 0.340191
	.float -0.599790
	.float 0.588163
	.float -0.335347
	.float -0.050104
	.float 0.436657
	.float -0.708481
	.float 0.785419
	.float -0.639060
	.float 0.311799
	.float 0.077786
	.float -0.368249
	.float 0.431205
	.float -0.253379
	.float -0.034771
	.float 0.221019
	.float -0.140104
	.float -0.212022
	.float 0.662698
	.float -0.967263
	.float 0.966575
	.float -0.685371
	.float 0.300607
	.float -0.007837
	.float -0.108448
	.float 0.102841
	.float -0.085583
	.float 0.110270
	.float -0.132338
	.float 0.070256
	.float 0.091091
	.float -0.250808
	.float 0.246104
	.float 0.026111
	.float -0.512253
	.float 1.006558
	.float -1.263063
	.float 1.145400
	.float -0.715342
	.float 0.197791
	.float 0.158274
	.float -0.231140
	.float 0.087817
	.float 0.083461
	.float -0.114739
	.float -0.033243
	.float 0.270869
	.float -0.473999
	.float 0.586881
	.float -0.650773
	.float 0.743764
	.float -0.890558
	.float 1.018456
	.float -0.992195
	.float 0.699313
	.float -0.127242
	.float -0.611542
	.float 1.313913
	.float -1.758381
	.float 1.786383
	.float -1.365222
	.float 0.609178
	.float 0.255991
	.float -0.977787
	.float 1.372926
	.float -1.383808
	.float 1.068555
	.float -0.545283
	.float -0.058303
	.float 0.616945
	.float -0.998168
	.float 1.078125
	.float -0.803153
	.float 0.257096
	.float 0.336817
	.float -0.712329
	.float 0.705820
	.float -0.351129
	.float -0.147306
	.float 0.545831
	.float -0.705975
	.float 0.657694
	.float -0.551804
	.float 0.547122
	.float -0.710240
	.float 0.984049
	.float -1.231205
	.float 1.317668
	.float -1.186751
	.float 0.885476
	.float -0.533608
	.float 0.257138
	.float -0.127011
	.float 0.136839
	.float -0.224643
	.float 0.315208
	.float -0.353454
	.float 0.316395
	.float -0.212398
	.float 0.078382
	.float 0.027487
	.float -0.047685
	.float -0.039834
	.float 0.196487
	.float -0.334245
	.float 0.366550
	.float -0.268484
	.float 0.102165
	.float 0.016134
	.float 0.010361
	.float -0.193822
	.float 0.450474
	.float -0.652651
	.float 0.708761
	.float -0.616459
	.float 0.454849
	.float -0.326928
	.float 0.296877
	.float -0.363268
	.float 0.474941
	.float -0.567231
	.float 0.592782
	.float -0.539471
	.float 0.438865
	.float -0.362416
	.float 0.394519
	.float -0.583373
	.float 0.895699
	.float -1.212711
	.float 1.381552
	.float -1.293228
	.float 0.937188
	.float -0.400220
	.float -0.179663
	.float 0.666430
	.float -0.958042
	.float 0.998296
	.float -0.786775
	.float 0.391860
	.float 0.051849
	.float -0.384668
	.float 0.494889
	.float -0.379879
	.float 0.145140
	.float 0.067290
	.float -0.171750
	.float 0.180787
	.float -0.163307
	.float 0.157877
	.float -0.121416
	.float -0.035776
	.float 0.354598
	.float -0.754929
	.float 1.056439
	.float -1.088068
	.float 0.808297
	.float -0.347278
	.float -0.061804
	.float 0.217465
	.float -0.063705
	.float -0.285321
	.float 0.620161
	.float -0.761402
	.float 0.659894
	.float -0.412989
	.float 0.189739
	.float -0.115125
	.float 0.191380
	.float -0.308315
	.float 0.330588
	.float -0.194484
	.float -0.054900
	.float 0.303611
	.float -0.445270
	.float 0.437101
	.float -0.309379
	.float 0.141356
	.float -0.026903
	.float 0.037877
	.float -0.184531
	.float 0.388132
	.float -0.499267
	.float 0.378552
	.float -0.003690
	.float -0.477289
	.float 0.808321
	.float -0.782218
	.float 0.387196
	.float 0.171286
	.float -0.602010
	.float 0.723515
	.float -0.579770
	.float 0.389726
	.float -0.371188
	.float 0.575320
	.float -0.855073
	.float 0.983948
	.float -0.825748
	.float 0.425572
	.float 0.035959
	.float -0.373959
	.float 0.507970
	.float -0.475102
	.float 0.361486
	.float -0.226610
	.float 0.082150
	.float 0.074307
	.float -0.221286
	.float 0.314949
	.float -0.325870
	.float 0.267701
	.float -0.182626
	.float 0.094144
	.float 0.025398
	.float -0.234262
	.float 0.557327
	.float -0.931617
	.float 1.213352
	.float -1.253144
	.float 0.991265
	.float -0.506960
	.float -0.013261
	.float 0.367751
	.float -0.433822
	.float 0.212168
	.float 0.191176
	.float -0.618489
	.float 0.913818
	.float -0.959839
	.float 0.705331
	.float -0.190582
	.float -0.441700
	.float 0.976560
	.float -1.208151
	.float 1.040887
	.float -0.547774
	.float -0.061040
	.float 0.548993
	.float -0.773125
	.float 0.733544
	.float -0.524434
	.float 0.234386
	.float 0.116203
	.float -0.546535
	.float 1.022426
	.float -1.391316
	.float 1.426578
	.float -0.976214
	.float 0.113538
	.float 0.838027
	.float -1.455220
	.float 1.458907
	.float -0.887971
	.float 0.076808
	.float 0.555217
	.float -0.759981
	.float 0.589438
	.float -0.317876
	.float 0.224909
	.float -0.397493
	.float 0.683213
	.float -0.813707
	.float 0.601017
	.float -0.070797
	.float -0.549172
	.float 0.966182
	.float -0.989402
	.float 0.623598
	.float -0.045762
	.float -0.502695
	.float 0.831491
	.float -0.863001
	.float 0.627281
	.float -0.221592
	.float -0.229916
	.float 0.604794
	.float -0.808020
	.float 0.800137
	.float -0.614054
	.float 0.341031
	.float -0.085997
	.float -0.081024
	.float 0.144552
	.float -0.125361
	.float 0.046404
	.float 0.084864
	.float -0.265527
	.float 0.473108
	.float -0.655614
	.float 0.748163
	.float -0.704663
	.float 0.522709
	.float -0.248259
	.float -0.037058
	.float 0.236689
	.float -0.264478
	.float 0.075584
	.float 0.303784
	.float -0.768025
	.float 1.164201
	.float -1.358837
	.float 1.303126
	.float -1.054496
	.float 0.741395
	.float -0.497032
	.float 0.403496
	.float -0.467701
	.float 0.624697
	.float -0.757814
	.float 0.738244
	.float -0.488970
	.float 0.051960
	.float 0.391964
	.float -0.591528
	.float 0.364055
	.float 0.276441
	.float -1.092565
	.float 1.726764
	.float -1.876572
	.float 1.440630
	.float -0.560751
	.float -0.448820
	.float 1.238224
	.float -1.560922
	.float 1.362125
	.float -0.786224
	.float 0.101247
	.float 0.427864
	.float -0.655956
	.float 0.602621
	.float -0.403594
	.float 0.206349
	.float -0.083575
	.float 0.019954
	.float 0.031685
	.float -0.081376
	.float 0.081325
	.float 0.030493
	.float -0.262355
	.float 0.536350
	.float -0.722239
	.float 0.716061
	.float -0.508325
	.float 0.194627
	.float 0.078478
	.float -0.198387
	.float 0.149617
	.float -0.018076
	.float -0.065027
	.float 0.002907
	.float 0.214801
	.float -0.519138
	.float 0.815614
	.float -1.038586
	.float 1.165429
	.float -1.190659
	.float 1.099862
	.float -0.879676
	.float 0.558114
	.float -0.229332
	.float 0.022874
	.float -0.026557
	.float 0.219430
	.float -0.471665
	.float 0.619842
	.float -0.570036
	.float 0.358580
	.float -0.128559
	.float 0.034196
	.float -0.133617
	.float 0.342480
	.float -0.486192
	.float 0.423423
	.float -0.157142
	.float -0.152150
	.float 0.291805
	.float -0.152197
	.float -0.182344
	.float 0.479391
	.float -0.512146
	.float 0.210914
	.float 0.295076
	.float -0.768690
	.float 1.015592
	.float -0.987513
	.float 0.778349
	.float -0.535867
	.float 0.362607
	.float -0.268404
	.float 0.187882
	.float -0.035557
	.float -0.236731
	.float 0.602919
	.float -0.959300
	.float 1.162296
	.float -1.100899
	.float 0.768719
	.float -0.284952
	.float -0.162564
	.float 0.421018
	.float -0.450167
	.float 0.319178
	.float -0.136198
	.float -0.021701
	.float 0.122956
	.float -0.150124
	.float 0.080548
	.float 0.083889
	.float -0.269335
	.float 0.334918
	.float -0.160347
	.float -0.241251
	.float 0.689841
	.float -0.938937
	.float 0.850444
	.float -0.506751
	.float 0.159171
	.float -0.040700
	.float 0.188045
	.float -0.418759
	.float 0.486284
	.float -0.288911
	.float -0.040500
	.float 0.240615
	.float -0.140109
	.float -0.189291
	.float 0.470556
	.float -0.422815
	.float -0.028772
	.float 0.692530
	.float -1.238665
	.float 1.414882
	.float -1.193070
	.float 0.754214
	.float -0.343860
	.float 0.115743
	.float -0.072269
	.float 0.123020
	.float -0.191809
	.float 0.277992
	.float -0.428669
	.float 0.656943
	.float -0.885208
	.float 0.969287
	.float -0.793442
	.float 0.368231
	.float 0.144231
	.float -0.506772
	.float 0.543164
	.float -0.246740
	.float -0.213593
	.float 0.596818
	.float -0.733949
	.float 0.614802
	.float -0.363534
	.float 0.132473
	.float -0.000833
	.float -0.049681
	.float 0.079539
	.float -0.115660
	.float 0.120205
	.float -0.022539
	.float -0.218762
	.float 0.572354
	.float -0.935036
	.float 1.171467
	.float -1.170752
	.float 0.898316
	.float -0.424431
	.float -0.087663
	.float 0.441643
	.float -0.498877
	.float 0.255893
	.float 0.142298
	.float -0.473430
	.float 0.560939
	.float -0.375399
	.float 0.045944
	.float 0.229904
	.float -0.319515
	.float 0.239651
	.float -0.132802
	.float 0.155305
	.float -0.361769
	.float 0.669157
	.float -0.919761
	.float 0.988505
	.float -0.855305
	.float 0.601161
	.float -0.346137
	.float 0.179418
	.float -0.121605
	.float 0.128818
	.float -0.127753
	.float 0.064118
	.float 0.055030
	.float -0.148896
	.float 0.099241
	.float 0.171824
	.float -0.625425
	.float 1.089227
	.float -1.330821
	.float 1.190983
	.float -0.695033
	.float 0.061410
	.float 0.411820
	.float -0.518646
	.float 0.265118
	.float 0.142888
	.float -0.436946
	.float 0.455267
	.float -0.230838
	.float -0.053937
	.float 0.203588
	.float -0.135493
	.float -0.086516
	.float 0.318660
	.float -0.441357
	.float 0.425104
	.float -0.324317
	.float 0.221745
	.float -0.172042
	.float 0.179095
	.float -0.209098
	.float 0.218784
	.float -0.178770
	.float 0.084391
	.float 0.042256
	.float -0.154939
	.float 0.191796
	.float -0.095069
	.float -0.156065
	.float 0.511535
	.float -0.839658
	.float 0.964426
	.float -0.750634
	.float 0.198771
	.float 0.513588
	.float -1.089826
	.float 1.257707
	.float -0.918637
	.float 0.205710
	.float 0.591832
	.float -1.188411
	.float 1.438124
	.float -1.363502
	.float 1.081254
	.float -0.706285
	.float 0.315518
	.float 0.018201
	.float -0.186455
	.float 0.070191
	.float 0.367346
	.float -0.995095
	.float 1.527556
	.float -1.662506
	.float 1.269039
	.float -0.496478
	.float -0.286079
	.float 0.698980
	.float -0.580649
	.float 0.082868
	.float 0.434072
	.float -0.635403
	.float 0.413790
	.float 0.073487
	.float -0.540940
	.float 0.771056
	.float -0.727881
	.float 0.523943
	.float -0.293776
	.float 0.087649
	.float 0.133824
	.float -0.414860
	.float 0.713196
	.float -0.887372
	.float 0.780814
	.float -0.341991
	.float -0.311498
	.float 0.937164
	.float -1.293318
	.float 1.262759
	.float -0.898111
	.float 0.374317
	.float 0.103505
	.float -0.374648
	.float 0.353653
	.float -0.037718
	.float -0.483694
	.float 1.026035
	.float -1.353958
	.float 1.290850
	.float -0.843058
	.float 0.239047
	.float 0.181354
	.float -0.179807
	.float -0.210851
	.float 0.694247
	.float -0.904542
	.float 0.653527
	.float -0.055930
	.float -0.550266
	.float 0.824904
	.float -0.634503
	.float 0.119613
	.float 0.406527
	.float -0.651533
	.float 0.509380
	.float -0.106219
	.float -0.291634
	.float 0.446173
	.float -0.290070
	.float -0.042673
	.float 0.313304
	.float -0.338113
	.float 0.108829
	.float 0.201357
	.float -0.348381
	.float 0.174957
	.float 0.280335
	.float -0.789094
	.float 1.054234
	.float -0.880100
	.float 0.293372
	.float 0.459782
	.float -1.045402
	.float 1.228221
	.float -1.000049
	.float 0.570345
	.float -0.227506
	.float 0.162719
	.float -0.369086
	.float 0.671643
	.float -0.854471
	.float 0.794328
	.float -0.521120
	.float 0.183724
	.float 0.043169
	.float -0.052772
	.float -0.145153
	.float 0.436594
	.float -0.664686
	.float 0.708118
	.float -0.538890
	.float 0.233268
	.float 0.065581
	.float -0.211615
	.float 0.117849
	.float 0.205480
	.float -0.646809
	.float 1.027052
	.float -1.167453
	.float 0.972122
	.float -0.487879
	.float -0.098859
	.float 0.541626
	.float -0.658585
	.float 0.434174
	.float -0.031463
	.float -0.303117
	.float 0.390978
	.float -0.230546
	.float -0.014861
	.float 0.148095
	.float -0.094264
	.float -0.039500
	.float 0.053565
	.float 0.170715
	.float -0.552185
	.float 0.847923
	.float -0.826776
	.float 0.446456
	.float 0.105104
	.float -0.539018
	.float 0.666260
	.float -0.516494
	.float 0.288465
	.float -0.181250
	.float 0.246473
	.float -0.375378
	.float 0.415430
	.float -0.304067
	.float 0.104390
	.float 0.075262
	.float -0.190133
	.float 0.291200
	.float -0.454697
	.float 0.681678
	.float -0.866419
	.float 0.867972
	.float -0.627886
	.float 0.237021
	.float 0.105293
	.float -0.214264
	.float 0.041392
	.float 0.287159
	.float -0.542565
	.float 0.533787
	.float -0.231171
	.float -0.204797
	.float 0.514161
	.float -0.496999
	.float 0.141978
	.float 0.363346
	.float -0.751942
	.float 0.846978
	.float -0.664609
	.float 0.381703
	.float -0.201318
	.float 0.220648
	.float -0.393058
	.float 0.592967
	.float -0.715813
	.float 0.734623
	.float -0.687782
	.float 0.630396
	.float -0.595015
	.float 0.580035
	.float -0.555261
	.float 0.472550
	.float -0.284280
	.float -0.025144
	.float 0.408545
	.float -0.755799
	.float 0.940868
	.float -0.895622
	.float 0.660284
	.float -0.371217
	.float 0.190277
	.float -0.220679
	.float 0.460408
	.float -0.814088
	.float 1.147549
	.float -1.351207
	.float 1.383328
	.float -1.278013
	.float 1.116275
	.float -0.972491
	.float 0.864127
	.float -0.740050
	.float 0.524899
	.float -0.197643
	.float -0.153142
	.float 0.350211
	.float -0.228827
	.float -0.241185
	.float 0.898570
	.float -1.450564
	.float 1.625670
	.float -1.328836
	.float 0.701266
	.float -0.043499
	.float -0.353349
	.float 0.364756
	.float -0.084117
	.float -0.255656
	.float 0.430407
	.float -0.343422
	.float 0.046563
	.float 0.329720
	.float -0.670176
	.float 0.923501
	.float -1.087206
	.float 1.165095
	.float -1.146187
	.float 1.020417
	.float -0.804870
	.float 0.544102
	.float -0.280687
	.float 0.026424
	.float 0.230868
	.float -0.485036
	.float 0.673294
	.float -0.686956
	.float 0.438573
	.float 0.057084
	.float -0.651948
	.float 1.117849
	.float -1.260014
	.float 1.022590
	.float -0.520041
	.float -0.023952
	.float 0.390614
	.float -0.465275
	.float 0.270668
	.float 0.070041
	.float -0.404879
	.float 0.613953
	.float -0.635251
	.float 0.461624
	.float -0.130787
	.float -0.277863
	.float 0.647933
	.float -0.851580
	.float 0.802557
	.float -0.511955
	.float 0.103177
	.float 0.239655
	.float -0.367006
	.float 0.240871
	.float 0.060133
	.float -0.406145
	.float 0.695323
	.float -0.885846
	.float 0.968426
	.float -0.924282
	.float 0.721980
	.float -0.361111
	.float -0.083460
	.float 0.471525
	.float -0.668039
	.float 0.623106
	.float -0.397523
	.float 0.115632
	.float 0.111522
	.float -0.229776
	.float 0.228423
	.float -0.103653
	.float -0.148086
	.float 0.492594
	.float -0.820842
	.float 0.972554
	.float -0.829527
	.float 0.415024
	.float 0.091051
	.float -0.454015
	.float 0.539182
	.float -0.401001
	.float 0.230791
	.float -0.198698
	.float 0.314386
	.float -0.420797
	.float 0.329693
	.float 0.009242
	.float -0.444039
	.float 0.716612
	.float -0.646750
	.float 0.261061
	.float 0.229579
	.float -0.580178
	.float 0.669592
	.float -0.551956
	.float 0.380770
	.float -0.282413
	.float 0.279768
	.float -0.308476
	.float 0.289440
	.float -0.189893
	.float 0.034178
	.float 0.123554
	.float -0.230438
	.float 0.250032
	.float -0.166831
	.float -0.007730
	.float 0.227790
	.float -0.416443
	.float 0.489110
	.float -0.392099
	.float 0.138454
	.float 0.181285
	.float -0.428937
	.float 0.485110
	.float -0.320570
	.float 0.023933
	.float 0.245324
	.float -0.357388
	.float 0.295355
	.float -0.153773
	.float 0.050867
	.float -0.028171
	.float 0.026166
	.float 0.043234
	.float -0.195358
	.float 0.339413
	.float -0.348304
	.float 0.171383
	.float 0.110952
	.float -0.341618
	.float 0.406771
	.float -0.321572
	.float 0.212713
	.float -0.213716
	.float 0.358085
	.float -0.552919
	.float 0.649334
	.float -0.552671
	.float 0.290627
	.float 0.005697
	.float -0.187880
	.float 0.180280
	.float -0.015739
	.float -0.199192
	.float 0.358288
	.float -0.417117
	.float 0.403997
	.float -0.381098
	.float 0.390194
	.float -0.425769
	.float 0.453741
	.float -0.455553
	.float 0.456241
	.float -0.508513
	.float 0.642658
	.float -0.822550
	.float 0.946579
	.float -0.899830
	.float 0.626498
	.float -0.175494
	.float -0.312463
	.float 0.672212
	.float -0.797764
	.float 0.692560
	.float -0.456125
	.float 0.218054
	.float -0.065583
	.float 0.013107
	.float -0.027190
	.float 0.076225
	.float -0.156780
	.float 0.274740
	.float -0.404256
	.float 0.469513
	.float -0.374579
	.float 0.063780
	.float 0.431536
	.float -0.992454
	.float 1.457247
	.float -1.683545
	.float 1.599376
	.float -1.229297
	.float 0.692548
	.float -0.170183
	.float -0.159546
	.float 0.200791
	.float 0.005033
	.float -0.292466
	.float 0.461743
	.float -0.398393
	.float 0.144121
	.float 0.134309
	.float -0.262191
	.float 0.179514
	.float 0.016962
	.float -0.141849
	.float 0.052288
	.float 0.247551
	.float -0.597882
	.float 0.776269
	.float -0.633376
	.float 0.186906
	.float 0.383935
	.float -0.837950
	.float 1.001446
	.float -0.848107
	.float 0.487685
	.float -0.085515
	.float -0.225924
	.float 0.392885
	.float -0.435703
	.float 0.417501
	.float -0.409671
	.float 0.460181
	.float -0.567115
	.float 0.671270
	.float -0.685126
	.float 0.551476
	.float -0.292285
	.float 0.005899
	.float 0.191263
	.float -0.233741
	.float 0.132726
	.float 0.056599
	.float -0.287723
	.float 0.541799
	.float -0.795827
	.float 0.978998
	.float -0.977403
	.float 0.709328
	.float -0.222228
	.float -0.279112
	.float 0.528726
	.float -0.376842
	.float -0.079127
	.float 0.526267
	.float -0.631868
	.float 0.270219
	.float 0.388677
	.float -0.997894
	.float 1.268750
	.float -1.145642
	.float 0.800065
	.float -0.471057
	.float 0.290995
	.float -0.226885
	.float 0.157967
	.float -0.002030
	.float -0.220835
	.float 0.428001
	.float -0.565499
	.float 0.660075
	.float -0.784254
	.float 0.967007
	.float -1.131979
	.float 1.125526
	.float -0.825378
	.float 0.255154
	.float 0.381113
	.float -0.781691
	.float 0.708103
	.float -0.132113
	.float -0.723855
	.float 1.487936
	.float -1.833036
	.float 1.652491
	.float -1.107801
	.float 0.515275
	.float -0.145503
	.float 0.070302
	.float -0.158762
	.float 0.211388
	.float -0.119998
	.float -0.069830
	.float 0.227918
	.float -0.263650
	.float 0.191779
	.float -0.091309
	.float 0.010533
	.float 0.083167
	.float -0.259929
	.float 0.533370
	.float -0.808774
	.float 0.929259
	.float -0.789717
	.float 0.428019
	.float -0.018777
	.float -0.229932
	.float 0.202842
	.float 0.061317
	.float -0.410509
	.float 0.683255
	.float -0.796611
	.float 0.761870
	.float -0.634113
	.float 0.451768
	.float -0.219576
	.float -0.058481
	.float 0.338289
	.float -0.535650
	.float 0.577424
	.float -0.465597
	.float 0.298577
	.float -0.223907
	.float 0.347573
	.float -0.659867
	.float 1.028718
	.float -1.267996
	.float 1.240417
	.float -0.934419
	.float 0.471477
	.float -0.041725
	.float -0.193284
	.float 0.176323
	.float 0.029938
	.float -0.287370
	.float 0.452191
	.float -0.427772
	.float 0.183143
	.float 0.248342
	.float -0.768109
	.float 1.212869
	.float -1.387539
	.float 1.150327
	.float -0.518059
	.float -0.288496
	.float 0.923513
	.float -1.098550
	.float 0.757877
	.float -0.122022
	.float -0.440081
	.float 0.628640
	.float -0.376725
	.float -0.138152
	.float 0.623079
	.float -0.840567
	.float 0.716144
	.float -0.340259
	.float -0.107395
	.float 0.451803
	.float -0.590115
	.float 0.516429
	.float -0.306970
	.float 0.076194
	.float 0.079056
	.float -0.121996
	.float 0.082053
	.float -0.022536
	.float -0.006824
	.float -0.001949
	.float 0.022725
	.float -0.025380
	.float -0.000976
	.float 0.047699
	.float -0.100358
	.float 0.145034
	.float -0.160183
	.float 0.109493
	.float 0.043118
	.float -0.296879
	.float 0.584041
	.float -0.780770
	.float 0.766317
	.float -0.498704
	.float 0.054483
	.float 0.400095
	.float -0.692786
	.float 0.731264
	.float -0.536356
	.float 0.207201
	.float 0.147790
	.float -0.459281
	.float 0.695233
	.float -0.826538
	.float 0.806112
	.float -0.591483
	.float 0.196149
	.float 0.277078
	.float -0.659459
	.float 0.792969
	.float -0.615804
	.float 0.201696
	.float 0.274236
	.float -0.624375
	.float 0.739427
	.float -0.627904
	.float 0.386024
	.float -0.125410
	.float -0.088031
	.float 0.246849
	.float -0.369966
	.float 0.462455
	.float -0.502096
	.float 0.457770
	.float -0.317623
	.float 0.103097
	.float 0.136689
	.float -0.339747
	.float 0.446298
	.float -0.415522
	.float 0.247825
	.float -0.004084
	.float -0.200116
	.float 0.240475
	.float -0.056935
	.float -0.291534
	.float 0.638700
	.float -0.799463
	.float 0.686098
	.float -0.371340
	.float 0.045180
	.float 0.111272
	.float -0.045430
	.float -0.142449
	.float 0.286943
	.float -0.286160
	.float 0.170972
	.float -0.064613
	.float 0.071254
	.float -0.184526
	.float 0.286059
	.float -0.231810
	.float -0.040407
	.float 0.458646
	.float -0.852429
	.float 1.047760
	.float -0.959654
	.float 0.628745
	.float -0.189383
	.float -0.202923
	.float 0.439914
	.float -0.492230
	.float 0.398247
	.float -0.228872
	.float 0.054429
	.float 0.070119
	.float -0.104056
	.float 0.019708
	.float 0.185042
	.float -0.466014
	.float 0.728319
	.float -0.860715
	.float 0.800867
	.float -0.586810
	.float 0.344459
	.float -0.204488
	.float 0.204891
	.float -0.260790
	.float 0.236131
	.float -0.064592
	.float -0.184577
	.float 0.360166
	.float -0.362854
	.float 0.241807
	.float -0.161607
	.float 0.258578
	.float -0.507675
	.float 0.719989
	.float -0.682262
	.float 0.327217
	.float 0.205518
	.float -0.668766
	.float 0.885628
	.float -0.862166
	.float 0.749496
	.float -0.696115
	.float 0.717631
	.float -0.690610
	.float 0.470524
	.float -0.034574
	.float -0.465946
	.float 0.784441
	.float -0.731026
	.float 0.292559
	.float 0.354774
	.float -0.940326
	.float 1.238569
	.float -1.174165
	.float 0.842349
	.float -0.443199
	.float 0.170987
	.float -0.118237
	.float 0.242153
	.float -0.405430
	.float 0.462193
	.float -0.337422
	.float 0.058363
	.float 0.270927
	.float -0.527549
	.float 0.624554
	.float -0.539086
	.float 0.310881
	.float -0.021211
	.float -0.237083
	.float 0.392221
	.float -0.422452
	.float 0.368356
	.float -0.313873
	.float 0.334373
	.float -0.435676
	.float 0.527704
	.float -0.465218
	.float 0.144680
	.float 0.402575
	.float -0.992040
	.float 1.369850
	.float -1.354143
	.float 0.943584
	.float -0.321923
	.float -0.243526
	.float 0.543384
	.float -0.522190
	.float 0.280810
	.float 0.002812
	.float -0.179070
	.float 0.198331
	.float -0.115706
	.float 0.036049
	.float -0.037528
	.float 0.121682
	.float -0.219861
	.float 0.250447
	.float -0.186953
	.float 0.087994
	.float -0.064625
	.float 0.204648
	.float -0.506253
	.float 0.869546
	.float -1.154854
	.float 1.268452
	.float -1.215438
	.float 1.083457
	.float -0.971484
	.float 0.916202
	.float -0.867638
	.float 0.726009
	.float -0.408500
	.float -0.099293
	.float 0.732268
	.float -1.366873
	.float 1.853366
	.float -2.050318
	.float 1.868787
	.float -1.325823
	.float 0.577761
	.float 0.113538
	.float -0.498463
	.float 0.489250
	.float -0.236340
	.float 0.051724
	.float -0.203532
	.float 0.716830
	.float -1.332553
	.float 1.672249
	.float -1.499784
	.float 0.888406
	.float -0.165992
	.float -0.321357
	.float 0.448167
	.float -0.372201
	.float 0.379750
	.float -0.641787
	.float 1.073300
	.float -1.403446
	.float 1.395235
	.float -1.038276
	.float 0.561479
	.float -0.257858
	.float 0.261823
	.float -0.455001
	.float 0.572107
	.float -0.418899
	.float 0.029195
	.float 0.358234
	.float -0.476941
	.float 0.221764
	.float 0.289561
	.float -0.812330
	.float 1.138614
	.float -1.204729
	.float 1.082116
	.float -0.887157
	.float 0.693805
	.float -0.506882
	.float 0.293337
	.float -0.029420
	.float -0.272636
	.float 0.565225
	.float -0.780448
	.float 0.848948
	.float -0.722275
	.float 0.399726
	.float 0.050316
	.float -0.493631
	.float 0.769921
	.float -0.760735
	.float 0.454343
	.float 0.031846
	.float -0.495187
	.float 0.746312
	.float -0.710791
	.float 0.468932
	.float -0.199046
	.float 0.055014
	.float -0.063204
	.float 0.118278
	.float -0.085019
	.float -0.073263
	.float 0.246740
	.float -0.257758
	.float 0.008664
	.float 0.418309
	.float -0.793535
	.float 0.887825
	.float -0.631278
	.float 0.167739
	.float 0.237434
	.float -0.376546
	.float 0.243237
	.float -0.037414
	.float 0.020147
	.float -0.314472
	.float 0.795442
	.float -1.158267
	.float 1.125783
	.float -0.648097
	.float -0.054175
	.float 0.635773
	.float -0.851648
	.float 0.695501
	.float -0.362660
	.float 0.086381
	.float 0.016626
	.float 0.014083
	.float -0.058135
	.float 0.021750
	.float 0.107408
	.float -0.277759
	.float 0.424025
	.float -0.501428
	.float 0.489965
	.float -0.388284
	.float 0.217011
	.float -0.027868
	.float -0.102356
	.float 0.104461
	.float 0.039149
	.float -0.271946
	.float 0.485018
	.float -0.574867
	.float 0.501559
	.float -0.309197
	.float 0.095934
	.float 0.045893
	.float -0.080442
	.float 0.039961
	.float 0.005896
	.float 0.000529
	.float -0.068235
	.float 0.154775
	.float -0.195551
	.float 0.145377
	.float -0.005803
	.float -0.178138
	.float 0.349469
	.float -0.477391
	.float 0.575084
	.float -0.682766
	.float 0.826165
	.float -0.981325
	.float 1.075642
	.float -1.030601
	.float 0.818928
	.float -0.494820
	.float 0.171231
	.float 0.043949
	.float -0.111526
	.float 0.082215
	.float -0.061894
	.float 0.142445
	.float -0.338915
	.float 0.567830
	.float -0.679693
	.float 0.534347
	.float -0.085863
	.float -0.567738
	.float 1.206553
	.float -1.585457
	.float 1.558773
	.float -1.158320
	.float 0.571863
	.float -0.032775
	.float -0.305677
	.float 0.430061
	.float -0.431772
	.float 0.418681
	.float -0.445005
	.float 0.502427
	.float -0.558710
	.float 0.598174
	.float -0.630736
	.float 0.673911
	.float -0.734015
	.float 0.803791
	.float -0.870193
	.float 0.916461
	.float -0.915737
	.float 0.829494
	.float -0.623875
	.float 0.297882
	.float 0.098678
	.float -0.474520
	.float 0.730084
	.float -0.795124
	.float 0.653667
	.float -0.350387
	.float -0.020694
	.float 0.345755
	.float -0.536210
	.float 0.572202
	.float -0.515019
	.float 0.468661
	.float -0.506477
	.float 0.612662
	.float -0.687159
	.float 0.618629
	.float -0.375268
	.float 0.043377
	.float 0.221127
	.float -0.298175
	.float 0.190325
	.float -0.025238
	.float -0.031678
	.float -0.105234
	.float 0.377813
	.float -0.620656
	.float 0.675154
	.float -0.500477
	.float 0.200721
	.float 0.054539
	.float -0.159616
	.float 0.154127
	.float -0.189671
	.float 0.402354
	.float -0.788435
	.float 1.182853
	.float -1.361958
	.float 1.193466
	.float -0.721104
	.float 0.127020
	.float 0.387771
	.float -0.709438
	.float 0.835440
	.float -0.823793
	.float 0.727670
	.float -0.568721
	.float 0.354837
	.float -0.110253
	.float -0.113998
	.float 0.256470
	.float -0.273845
	.float 0.162838
	.float 0.035232
	.float -0.250370
	.float 0.415892
	.float -0.502969
	.float 0.535784
	.float -0.570369
	.float 0.643981
	.float -0.730477
	.float 0.742655
	.float -0.591519
	.float 0.263440
	.float 0.146378
	.float -0.477248
	.float 0.594902
	.float -0.462894
	.float 0.143877
	.float 0.257929
	.float -0.655539
	.float 0.993560
	.float -1.226254
	.float 1.304527
	.float -1.200664
	.float 0.948937
	.float -0.652261
	.float 0.431819
	.float -0.352476
	.float 0.383914
	.float -0.430195
	.float 0.403371
	.float -0.283175
	.float 0.121405
	.float 0.004167
	.float -0.045957
	.float 0.013386
	.float 0.042242
	.float -0.068473
	.float 0.049457
	.float -0.018231
	.float 0.037536
	.float -0.159940
	.float 0.388799
	.float -0.660973
	.float 0.862658
	.float -0.875429
	.float 0.635969
	.float -0.183767
	.float -0.331690
	.float 0.700491
	.float -0.746953
	.float 0.423835
	.float 0.151205
	.float -0.746804
	.float 1.130757
	.float -1.178018
	.float 0.911502
	.float -0.463439
	.float -0.004481
	.float 0.369051
	.float -0.573120
	.float 0.619061
	.float -0.549551
	.float 0.428270
	.float -0.321181
	.float 0.275501
	.float -0.300395
	.float 0.357701
	.float -0.369337
	.float 0.244531
	.float 0.075927
	.float -0.571326
	.float 1.116096
	.float -1.510102
	.float 1.571342
	.float -1.250208
	.float 0.687636
	.float -0.156643
	.float -0.097179
	.float 0.017187
	.float 0.219188
	.float -0.318129
	.float 0.078604
	.float 0.451893
	.float -0.989447
	.float 1.193523
	.float -0.897759
	.float 0.238004
	.float 0.411492
	.float -0.660830
	.float 0.351028
	.float 0.332018
	.float -0.958310
	.float 1.118791
	.float -0.692202
	.float -0.064603
	.float 0.675434
	.float -0.758234
	.float 0.283070
	.float 0.406789
	.float -0.829938
	.float 0.694729
	.float -0.090514
	.float -0.586839
	.float 0.911931
	.float -0.707200
	.float 0.132447
	.float 0.454697
	.float -0.745207
	.float 0.651870
	.float -0.308133
	.float -0.068511
	.float 0.323005
	.float -0.417602
	.float 0.390355
	.float -0.288744
	.float 0.145694
	.float -0.001030
	.float -0.081168
	.float 0.039773
	.float 0.126815
	.float -0.331330
	.float 0.437333
	.float -0.350590
	.float 0.094029
	.float 0.196346
	.float -0.359048
	.float 0.315852
	.float -0.119882
	.float -0.093473
	.float 0.213115
	.float -0.230061
	.float 0.224566
	.float -0.276972
	.float 0.382186
	.float -0.445178
	.float 0.364508
	.float -0.132714
	.float -0.135586
	.float 0.277807
	.float -0.204316
	.float -0.028661
	.float 0.250467
	.float -0.286316
	.float 0.064893
	.float 0.347129
	.float -0.793171
	.float 1.111163
	.float -1.199245
	.float 1.039662
	.float -0.692023
	.float 0.274072
	.float 0.068501
	.float -0.210518
	.float 0.106890
	.float 0.169919
	.float -0.452304
	.float 0.564787
	.float -0.430719
	.float 0.126978
	.float 0.159242
	.float -0.250644
	.float 0.098035
	.float 0.187868
	.float -0.416357
	.float 0.453276
	.float -0.314532
	.float 0.146874
	.float -0.108632
	.float 0.239199
	.float -0.416547
	.float 0.439050
	.float -0.175815
	.float -0.322174
	.float 0.833744
	.float -1.100088
	.float 0.990586
	.float -0.587984
	.float 0.132474
	.float 0.137085
	.float -0.132873
	.float -0.046990
	.float 0.219003
	.float -0.268197
	.float 0.235358
	.float -0.273679
	.float 0.516485
	.float -0.964509
	.float 1.475666
	.float -1.852206
	.float 1.948329
	.float -1.725152
	.float 1.240113
	.float -0.610460
	.float -0.013496
	.float 0.470321
	.float -0.631454
	.float 0.466870
	.float -0.086257
	.float -0.296526
	.float 0.474333
	.float -0.362795
	.float 0.036082
	.float 0.343243
	.float -0.640938
	.float 0.821697
	.float -0.927579
	.float 0.999613
	.float -1.020617
	.float 0.927862
	.float -0.677344
	.float 0.298893
	.float 0.105581
	.float -0.417856
	.float 0.569636
	.float -0.571854
	.float 0.490567
	.float -0.392373
	.float 0.301158
	.float -0.196403
	.float 0.049989
	.float 0.130785
	.float -0.290033
	.float 0.350333
	.float -0.258497
	.float 0.017441
	.float 0.313054
	.float -0.639165
	.float 0.861826
	.float -0.903383
	.float 0.735311
	.float -0.404953
	.float 0.041674
	.float 0.183009
	.float -0.142949
	.float -0.151335
	.float 0.526622
	.float -0.727896
	.float 0.573988
	.float -0.088677
	.float -0.491676
	.float 0.852870
	.float -0.794545
	.float 0.348041
	.float 0.257865
	.float -0.750950
	.float 0.975212
	.float -0.951497
	.float 0.816493
	.float -0.704815
	.float 0.663068
	.float -0.642720
	.float 0.555363
	.float -0.340218
	.float 0.003177
	.float 0.383866
	.float -0.714111
	.float 0.892695
	.float -0.882535
	.float 0.727148
	.float -0.531939
	.float 0.406023
	.float -0.399058
	.float 0.478839
	.float -0.569511
	.float 0.620242
	.float -0.646049
	.float 0.704461
	.float -0.827527
	.float 0.971388
	.float -1.031806
	.float 0.919200
	.float -0.634512
	.float 0.284269
	.float -0.019512
	.float -0.059999
	.float -0.030194
	.float 0.169815
	.float -0.211056
	.float 0.072615
	.float 0.208481
	.float -0.496582
	.float 0.633919
	.float -0.526738
	.float 0.192688
	.float 0.252140
	.float -0.653104
	.float 0.888284
	.float -0.916458
	.float 0.783282
	.float -0.588160
	.float 0.430764
	.float -0.363635
	.float 0.374904
	.float -0.409394
	.float 0.414690
	.float -0.381169
	.float 0.347159
	.float -0.364181
	.float 0.448406
	.float -0.557780
	.float 0.616489
	.float -0.570667
	.float 0.431721
	.float -0.272270
	.float 0.178167
	.float -0.195164
	.float 0.310264
	.float -0.474768
	.float 0.641498
	.float -0.783357
	.float 0.885077
	.float -0.927787
	.float 0.888415
	.float -0.756896
	.float 0.553819
	.float -0.330108
	.float 0.145060
	.float -0.035581
	.float -0.004458
	.float 0.020310
	.float -0.065390
	.float 0.157529
	.float -0.251459
	.float 0.254656
	.float -0.087757
	.float -0.246175
	.float 0.637460
	.float -0.919752
	.float 0.968810
	.float -0.781789
	.float 0.477784
	.float -0.218032
	.float 0.105543
	.float -0.137573
	.float 0.238573
	.float -0.334698
	.float 0.401281
	.float -0.446349
	.float 0.457728
	.float -0.377295
	.float 0.141868
	.float 0.237396
	.float -0.631230
	.float 0.840552
	.float -0.719983
	.float 0.292268
	.float 0.235867
	.float -0.581215
	.float 0.552388
	.float -0.170628
	.float -0.337067
	.float 0.671881
	.float -0.642339
	.float 0.277694
	.float 0.194145
	.float -0.488427
	.float 0.433971
	.float -0.064358
	.float -0.421176
	.float 0.790754
	.float -0.911788
	.float 0.799785
	.float -0.569594
	.float 0.342411
	.float -0.179013
	.float 0.073593
	.float 0.009135
	.float -0.095560
	.float 0.192043
	.float -0.297537
	.float 0.417140
	.float -0.558000
	.float 0.708821
	.float -0.823012
	.float 0.827986
	.float -0.667899
	.float 0.360363
	.float -0.025729
	.float -0.148674
	.float 0.010368
	.float 0.443300
	.float -1.020033
	.float 1.411964
	.float -1.372148
	.float 0.879116
	.float -0.168765
	.float -0.403314
	.float 0.583156
	.float -0.369724
	.float -0.009241
	.float 0.271956
	.float -0.275009
	.float 0.086858
	.float 0.094200
	.float -0.099752
	.float -0.092750
	.float 0.357874
	.float -0.514587
	.float 0.436031
	.float -0.108432
	.float -0.378335
	.float 0.879587
	.float -1.246074
	.float 1.359916
	.float -1.165119
	.float 0.700178
	.float -0.115885
	.float -0.355871
	.float 0.497568
	.float -0.227930
	.float -0.327974
	.float 0.883801
	.float -1.142452
	.float 0.964307
	.float -0.445351
	.float -0.144299
	.float 0.520065
	.float -0.538100
	.float 0.255060
	.float 0.130667
	.float -0.404783
	.float 0.445917
	.float -0.259482
	.float -0.061337
	.float 0.399943
	.float -0.657700
	.float 0.763566
	.float -0.676984
	.float 0.406184
	.float -0.028810
	.float -0.320669
	.float 0.511723
	.float -0.493914
	.float 0.330039
	.float -0.153942
	.float 0.079021
	.float -0.121265
	.float 0.188115
	.float -0.137158
	.float -0.134068
	.float 0.617419
	.float -1.177312
	.float 1.598035
	.float -1.680892
	.float 1.352024
	.float -0.724466
	.float 0.066963
	.float 0.322049
	.float -0.273627
	.float -0.156191
	.float 0.720877
	.float -1.131815
	.float 1.223921
	.float -1.029770
	.float 0.719497
	.float -0.461645
	.float 0.313188
	.float -0.215609
	.float 0.085089
	.float 0.088917
	.float -0.222908
	.float 0.211466
	.float -0.027113
	.float -0.239313
	.float 0.432478
	.float -0.435864
	.float 0.243957
	.float 0.045077
	.float -0.296327
	.float 0.406748
	.float -0.335037
	.float 0.097763
	.float 0.241105
	.float -0.578262
	.float 0.794000
	.float -0.801606
	.float 0.598663
	.float -0.273649
	.float -0.050702
	.float 0.296787
	.float -0.464384
	.float 0.584699
	.float -0.642404
	.float 0.549679
	.float -0.214008
	.float -0.348414
	.float 0.956418
	.float -1.332404
	.float 1.266076
	.float -0.761307
	.float 0.055648
	.float 0.512974
	.float -0.709647
	.float 0.539515
	.float -0.223172
	.float 0.026779
	.float -0.069592
	.float 0.250753
	.float -0.349198
	.float 0.216724
	.float 0.090593
	.float -0.349117
	.float 0.344375
	.float -0.047403
	.float -0.349245
	.float 0.565797
	.float -0.438436
	.float 0.040874
	.float 0.363653
	.float -0.503327
	.float 0.282281
	.float 0.160593
	.float -0.556480
	.float 0.697865
	.float -0.578077
	.float 0.380025
	.float -0.326388
	.float 0.506128
	.float -0.809170
	.float 1.016814
	.float -0.975510
	.float 0.718409
	.float -0.440835
	.float 0.350184
	.float -0.504945
	.float 0.763641
	.float -0.879635
	.float 0.671431
	.float -0.148123
	.float -0.492239
	.float 0.982249
	.float -1.137597
	.float 0.946877
	.float -0.555649
	.float 0.172556
	.float 0.034919
	.float 0.000330
	.float -0.245076
	.float 0.602117
	.float -0.950817
	.float 1.175029
	.float -1.180984
	.float 0.916137
	.float -0.392254
	.float -0.297689
	.float 0.987605
	.float -1.484190
	.float 1.642352
	.float -1.437957
	.float 0.995378
	.float -0.542657
	.float 0.305415
	.float -0.389038
	.float 0.714299
	.float -1.050076
	.float 1.135720
	.float -0.831619
	.float 0.210904
	.float 0.470336
	.float -0.916303
	.float 0.964822
	.float -0.678817
	.float 0.294290
	.float -0.061187
	.float 0.089088
	.float -0.301468
	.float 0.517269
	.float -0.586899
	.float 0.482988
	.float -0.296250
	.float 0.160706
	.float -0.170112
	.float 0.332352
	.float -0.572384
	.float 0.771083
	.float -0.822550
	.float 0.688590
	.float -0.422616
	.float 0.141717
	.float 0.043881
	.float -0.098558
	.float 0.075070
	.float -0.062962
	.float 0.114024
	.float -0.205882
	.float 0.269539
	.float -0.249936
	.float 0.144063
	.float 0.010332
	.float -0.173909
	.float 0.329428
	.float -0.472103
	.float 0.587409
	.float -0.649772
	.float 0.648639
	.float -0.612856
	.float 0.598785
	.float -0.640708
	.float 0.702213
	.float -0.677034
	.float 0.452647
	.float 0.002925
	.float -0.597199
	.float 1.150848
	.float -1.494726
	.float 1.555173
	.float -1.367254
	.float 1.017848
	.float -0.581171
	.float 0.109885
	.float 0.319533
	.float -0.575490
	.float 0.520277
	.float -0.124945
	.float -0.450405
	.float 0.909910
	.float -1.003169
	.float 0.706478
	.float -0.252161
	.float -0.034085
	.float -0.028875
	.float 0.349198
	.float -0.642088
	.float 0.650556
	.float -0.332033
	.float -0.124661
	.float 0.446277
	.float -0.460575
	.float 0.187954
	.float 0.201915
	.float -0.510015
	.float 0.614722
	.float -0.513442
	.float 0.301671
	.float -0.117373
	.float 0.074621
	.float -0.204324
	.float 0.424797
	.float -0.568775
	.float 0.471886
	.float -0.084104
	.float -0.467260
	.float 0.921352
	.float -1.026292
	.float 0.697430
	.float -0.083341
	.float -0.513666
	.float 0.813886
	.float -0.714636
	.float 0.321804
	.float 0.149010
	.float -0.517549
	.float 0.725699
	.float -0.821906
	.float 0.880368
	.float -0.928947
	.float 0.934156
	.float -0.840164
	.float 0.623332
	.float -0.323497
	.float 0.032771
	.float 0.151904
	.float -0.185989
	.float 0.107148
	.float -0.012403
	.float -0.008736
	.float -0.061768
	.float 0.160600
	.float -0.199518
	.float 0.143346
	.float -0.042952
	.float -0.007058
	.float -0.049447
	.float 0.179989
	.float -0.289886
	.float 0.303057
	.float -0.226841
	.float 0.144690
	.float -0.143746
	.float 0.240100
	.float -0.365465
	.float 0.423566
	.float -0.364046
	.float 0.209770
	.float -0.019966
	.float -0.167679
	.float 0.356083
	.float -0.551905
	.float 0.716374
	.float -0.763811
	.float 0.622140
	.float -0.304613
	.float -0.077142
	.float 0.380338
	.float -0.528044
	.float 0.556290
	.float -0.572664
	.float 0.662266
	.float -0.818088
	.float 0.949491
	.float -0.956242
	.float 0.805957
	.float -0.555547
	.float 0.306073
	.float -0.131584
	.float 0.036401
	.float 0.032947
	.float -0.138352
	.float 0.304121
	.float -0.503538
	.float 0.677005
	.float -0.760142
	.float 0.704192
	.float -0.488743
	.float 0.134728
	.float 0.284652
	.float -0.652019
	.float 0.846897
	.float -0.807492
	.float 0.575716
	.float -0.287585
	.float 0.105123
	.float -0.126992
	.float 0.332734
	.float -0.594094
	.float 0.744879
	.float -0.667652
	.float 0.351812
	.float 0.100556
	.float -0.517651
	.float 0.729061
	.float -0.638846
	.float 0.274360
	.float 0.212115
	.float -0.599378
	.float 0.695364
	.float -0.432025
	.float -0.096162
	.float 0.676030
	.float -1.078387
	.float 1.160589
	.float -0.915606
	.float 0.454358
	.float 0.052729
	.float -0.439178
	.float 0.592884
	.float -0.491327
	.float 0.216163
	.float 0.070287
	.float -0.197235
	.float 0.083153
	.float 0.200483
	.float -0.456092
	.float 0.479617
	.float -0.202765
	.float -0.244635
	.float 0.609390
	.float -0.688008
	.float 0.478493
	.float -0.196577
	.float 0.132744
	.float -0.443616
	.float 1.023964
	.float -1.553194
	.float 1.688784
	.float -1.278055
	.float 0.450847
	.float 0.458140
	.float -1.095734
	.float 1.262556
	.float -0.976196
	.float 0.413460
	.float 0.204638
	.float -0.705304
	.float 0.994353
	.float -1.040732
	.float 0.856238
	.float -0.494028
	.float 0.052754
	.float 0.341925
	.float -0.586953
	.float 0.653068
	.float -0.594237
	.float 0.498552
	.float -0.414816
	.float 0.315891
	.float -0.135371
	.float -0.148401
	.float 0.453976
	.float -0.624021
	.float 0.530434
	.float -0.180081
	.float -0.265396
	.float 0.579302
	.float -0.607548
	.float 0.354619
	.float 0.040004
	.float -0.406631
	.float 0.646121
	.float -0.756225
	.float 0.782316
	.float -0.751132
	.float 0.648583
	.float -0.454536
	.float 0.194302
	.float 0.045873
	.float -0.159930
	.float 0.092621
	.float 0.111992
	.float -0.322734
	.float 0.392176
	.float -0.245455
	.float -0.065839
	.float 0.378552
	.float -0.496412
	.float 0.293086
	.float 0.211922
	.float -0.844733
	.float 1.345676
	.float -1.488071
	.float 1.191427
	.float -0.568346
	.float -0.125061
	.float 0.613175
	.float -0.733422
	.float 0.506385
	.float -0.110363
	.float -0.218138
	.float 0.302020
	.float -0.101969
	.float -0.276102
	.float 0.642377
	.float -0.821441
	.float 0.738703
	.float -0.449955
	.float 0.098597
	.float 0.171648
	.float -0.293124
	.float 0.294204
	.float -0.258767
	.float 0.261528
	.float -0.323002
	.float 0.404450
	.float -0.432198
	.float 0.331908
	.float -0.060471
	.float -0.367587
	.float 0.866914
	.float -1.295577
	.float 1.503325
	.float -1.397500
	.float 0.991143
	.float -0.401988
	.float -0.200308
	.float 0.668755
	.float -0.932651
	.float 1.002555
	.float -0.932666
	.float 0.775166
	.float -0.562441
	.float 0.325732
	.float -0.121864
	.float 0.029928
	.float -0.106995
	.float 0.335595
	.float -0.611962
	.float 0.794432
	.float -0.781002
	.float 0.561711
	.float -0.214272
	.float -0.144042
	.float 0.411561
	.float -0.536288
	.float 0.524047
	.float -0.427623
	.float 0.323283
	.float -0.281220
	.float 0.342220
	.float -0.511797
	.float 0.768606
	.float -1.070221
	.float 1.345446
	.float -1.488360
	.float 1.384660
	.float -0.978863
	.float 0.344396
	.float 0.308905
	.float -0.723956
	.float 0.741249
	.float -0.401255
	.float -0.077274
	.float 0.437399
	.float -0.545578
	.float 0.458754
	.float -0.352941
	.float 0.374713
	.float -0.531385
	.float 0.697728
	.float -0.722871
	.float 0.549366
	.float -0.257106
	.float 0.009018
	.float 0.055776
	.float 0.091746
	.float -0.353242
	.float 0.556877
	.float -0.545998
	.float 0.256101
	.float 0.254151
	.float -0.826436
	.float 1.265829
	.float -1.414834
	.float 1.210151
	.float -0.704168
	.float 0.046398
	.float 0.567678
	.float -0.963267
	.float 1.044896
	.float -0.824880
	.float 0.411352
	.float 0.036083
	.float -0.361012
	.float 0.453487
	.float -0.273763
	.float -0.138627
	.float 0.667044
	.float -1.138295
	.float 1.374011
	.float -1.266652
	.float 0.843780
	.float -0.271054
	.float -0.225305
	.float 0.476887
	.float -0.454226
	.float 0.254869
	.float -0.014095
	.float -0.185585
	.float 0.335973
	.float -0.452873
	.float 0.515660
	.float -0.461704
	.float 0.242516
	.float 0.112622
	.float -0.488502
	.float 0.745329
	.float -0.804238
	.float 0.693150
	.float -0.522041
	.float 0.410214
	.float -0.418872
	.float 0.530678
	.float -0.678849
	.float 0.793130
	.float -0.827912
	.float 0.764058
	.float -0.604144
	.float 0.380895
	.float -0.170347
	.float 0.077330
	.float -0.175134
	.float 0.429706
	.float -0.676259
	.float 0.694869
	.float -0.355901
	.float -0.263610
	.float 0.889801
	.float -1.200452
	.float 1.020915
	.float -0.435843
	.float -0.258373
	.float 0.727008
	.float -0.782066
	.float 0.467144
	.float -0.005303
	.float -0.340089
	.float 0.400149
	.float -0.160118
	.float -0.268529
	.float 0.724820
	.float -1.070295
	.float 1.224320
	.float -1.164520
	.float 0.915019
	.float -0.539510
	.float 0.136984
	.float 0.175016
	.float -0.296983
	.float 0.190556
	.float 0.099732
	.float -0.465695
	.float 0.789246
	.float -0.999306
	.float 1.096291
	.float -1.129675
	.float 1.145946
	.float -1.145182
	.float 1.080256
	.float -0.901693
	.float 0.616039
	.float -0.308943
	.float 0.105791
	.float -0.089163
	.float 0.231487
	.float -0.397296
	.float 0.422660
	.float -0.222485
	.float -0.146020
	.float 0.507675
	.float -0.668349
	.float 0.529656
	.float -0.152040
	.float -0.271246
	.float 0.516637
	.float -0.452390
	.float 0.108153
	.float 0.351567
	.float -0.732650
	.float 0.922995
	.float -0.933423
	.float 0.846623
	.float -0.726805
	.float 0.571991
	.float -0.347263
	.float 0.059333
	.float 0.207083
	.float -0.334638
	.float 0.264206
	.float -0.048248
	.float -0.185127
	.float 0.327190
	.float -0.357856
	.float 0.328716
	.float -0.281770
	.float 0.187932
	.float 0.028271
	.float -0.394486
	.float 0.815081
	.float -1.095698
	.float 1.063750
	.float -0.693984
	.float 0.136168
	.float 0.381670
	.float -0.699924
	.float 0.812389
	.float -0.831900
	.float 0.878267
	.float -0.986723
	.float 1.105560
	.float -1.167006
	.float 1.153430
	.float -1.095805
	.float 1.013300
	.float -0.864658
	.float 0.572479
	.float -0.111400
	.float -0.419516
	.float 0.820693
	.float -0.917975
	.float 0.702821
	.float -0.370353
	.float 0.205949
	.float -0.388254
	.float 0.851034
	.float -1.312527
	.float 1.460826
	.float -1.166365
	.float 0.570903
	.float 0.008662
	.float -0.291473
	.float 0.211616
	.float 0.052592
	.float -0.210420
	.float 0.058142
	.float 0.383747
	.float -0.877981
	.float 1.112999
	.float -0.891810
	.float 0.255227
	.float 0.529999
	.float -1.108791
	.float 1.220717
	.float -0.827390
	.float 0.120431
	.float 0.583772
	.float -0.998824
	.float 0.992222
	.float -0.623818
	.float 0.091877
	.float 0.378061
	.float -0.641531
	.float 0.685719
	.float -0.599846
	.float 0.490442
	.float -0.401845
	.float 0.295862
	.float -0.099087
	.float -0.224389
	.float 0.632488
	.float -1.022703
	.float 1.286430
	.float -1.356086
	.float 1.219381
	.float -0.907836
	.float 0.481998
	.float -0.023786
	.float -0.373837
	.float 0.632098
	.float -0.720075
	.float 0.670814
	.float -0.558695
	.float 0.446140
	.float -0.338385
	.float 0.184785
	.float 0.069803
	.float -0.423560
	.float 0.797281
	.float -1.073502
	.float 1.164478
	.float -1.057199
	.float 0.808783
	.float -0.507985
	.float 0.238161
	.float -0.058856
	.float -0.003623
	.float -0.031429
	.float 0.094238
	.float -0.091928
	.float -0.029500
	.float 0.228662
	.float -0.374183
	.float 0.329226
	.float -0.062911
	.float -0.301215
	.float 0.552138
	.float -0.536672
	.float 0.276723
	.float 0.035449
	.float -0.168274
	.float 0.014816
	.float 0.329825
	.float -0.631496
	.float 0.670650
	.float -0.376862
	.float -0.141088
	.float 0.673526
	.float -1.030277
	.float 1.124734
	.float -0.985948
	.float 0.714830
	.float -0.426037
	.float 0.206297
	.float -0.095245
	.float 0.080476
	.float -0.102011
	.float 0.072541
	.float 0.079661
	.float -0.356676
	.float 0.661330
	.float -0.829849
	.float 0.727902
	.float -0.355826
	.float -0.118579
	.float 0.441986
	.float -0.429304
	.float 0.083869
	.float 0.403734
	.float -0.776200
	.float 0.860676
	.float -0.648699
	.float 0.266853
	.float 0.120355
	.float -0.400995
	.float 0.551211
	.float -0.614102
	.float 0.649799
	.float -0.688154
	.float 0.706884
	.float -0.646729
	.float 0.457383
	.float -0.146027
	.float -0.207817
	.float 0.487390
	.float -0.601184
	.float 0.526881
	.float -0.306783
	.float 0.007703
	.float 0.314109
	.float -0.615151
	.float 0.847124
	.float -0.955708
	.float 0.913317
	.float -0.759045
	.float 0.598064
	.float -0.539548
	.float 0.609121
	.float -0.707468
	.float 0.663375
	.float -0.359686
	.float -0.155149
	.float 0.662591
	.float -0.900492
	.float 0.745558
	.float -0.321289
	.float -0.060198
	.float 0.098601
	.float 0.285558
	.float -0.885259
	.float 1.338734
	.float -1.370834
	.float 0.974649
	.float -0.407776
	.float 0.012406
	.float 0.008979
	.float 0.291799
	.float -0.669994
	.float 0.866378
	.float -0.773226
	.float 0.481390
	.float -0.192686
	.float 0.068921
	.float -0.122106
	.float 0.215674
	.float -0.173305
	.float -0.077501
	.float 0.427653
	.float -0.638026
	.float 0.498781
	.float 0.008862
	.float -0.669392
	.float 1.154675
	.float -1.234021
	.float 0.922419
	.float -0.455347
	.float 0.109240
	.float -0.005433
	.float 0.048288
	.float -0.039346
	.float -0.131236
	.float 0.375128
	.float -0.468706
	.float 0.239206
	.float 0.274047
	.float -0.812038
	.float 1.051852
	.float -0.814458
	.float 0.180178
	.float 0.560465
	.float -1.078971
	.float 1.189708
	.float -0.933036
	.float 0.523916
	.float -0.209150
	.float 0.122307
	.float -0.220946
	.float 0.338554
	.float -0.313262
	.float 0.105486
	.float 0.176206
	.float -0.357492
	.float 0.327241
	.float -0.117724
	.float -0.121042
	.float 0.229243
	.float -0.145928
	.float -0.058001
	.float 0.236765
	.float -0.267482
	.float 0.119505
	.float 0.142108
	.float -0.406160
	.float 0.578089
	.float -0.621300
	.float 0.565595
	.float -0.486436
	.float 0.463132
	.float -0.528974
	.float 0.638106
	.float -0.678125
	.float 0.537534
	.float -0.196116
	.float -0.223098
	.float 0.490260
	.float -0.389196
	.float -0.141832
	.float 0.935143
	.float -1.639690
	.float 1.876551
	.float -1.429060
	.float 0.369140
	.float 0.950671
	.float -2.042888
	.float 2.500202
	.float -2.176317
	.float 1.242870
	.float -0.102625
	.float -0.796912
	.float 1.153036
	.float -0.912685
	.float 0.253706
	.float 0.529874
	.float -1.167265
	.float 1.505327
	.float -1.527744
	.float 1.315203
	.float -0.984032
	.float 0.634345
	.float -0.323533
	.float 0.069837
	.float 0.118072
	.float -0.206733
	.float 0.133082
	.float 0.149785
	.float -0.599959
	.float 1.052544
	.float -1.277333
	.float 1.112445
	.float -0.583287
	.float -0.090338
	.float 0.619005
	.float -0.818586
	.float 0.712946
	.float -0.495962
	.float 0.386856
	.float -0.482353
	.float 0.699784
	.float -0.837503
	.float 0.707685
	.float -0.261815
	.float -0.359838
	.float 0.884514
	.float -1.046189
	.float 0.737699
	.float -0.088263
	.float -0.588577
	.float 0.956325
	.float -0.834242
	.float 0.286890
	.float 0.425074
	.float -0.993650
	.float 1.217143
	.float -1.075401
	.float 0.703140
	.float -0.297936
	.float 0.022806
	.float 0.050422
	.float 0.057726
	.float -0.274753
	.float 0.528848
	.float -0.783130
	.float 1.035102
	.float -1.286800
	.float 1.510305
	.float -1.635875
	.float 1.575807
	.float -1.273930
	.float 0.753197
	.float -0.131264
	.float -0.412545
	.float 0.711602
	.float -0.693743
	.float 0.424776
	.float -0.080733
	.float -0.144270
	.float 0.143705
	.float 0.048983
	.float -0.297512
	.float 0.463698
	.float -0.498644
	.float 0.456790
	.float -0.426228
	.float 0.437020
	.float -0.429149
	.float 0.313232
	.float -0.075649
	.float -0.164696
	.float 0.210305
	.float 0.075573
	.float -0.643987
	.float 1.250301
	.float -1.581598
	.float 1.441575
	.float -0.867415
	.float 0.097823
	.float 0.581725
	.float -1.003163
	.float 1.175249
	.float -1.210565
	.float 1.197481
	.float -1.130775
	.float 0.953366
	.float -0.655909
	.float 0.327863
	.float -0.101473
	.float 0.035889
	.float -0.052584
	.float -0.008067
	.float 0.249427
	.float -0.618665
	.float 0.934168
	.float -1.019785
	.float 0.833691
	.float -0.486815
	.float 0.143179
	.float 0.106458
	.float -0.290295
	.float 0.489926
	.float -0.728710
	.float 0.916435
	.float -0.901666
	.float 0.593149
	.float -0.054857
	.float -0.503115
	.float 0.839363
	.float -0.827733
	.float 0.536809
	.float -0.185760
	.float 0.001077
	.float -0.066529
	.float 0.267982
	.float -0.375560
	.float 0.212034
	.float 0.207839
	.float -0.668850
	.float 0.890454
	.float -0.715211
	.float 0.219420
	.float 0.332990
	.float -0.662096
	.float 0.651924
	.float -0.417841
	.float 0.219010
	.float -0.276559
	.float 0.617282
	.float -1.044893
	.float 1.259007
	.float -1.049322
	.float 0.443744
	.float 0.285476
	.float -0.766958
	.float 0.742909
	.float -0.220860
	.float -0.526986
	.float 1.116949
	.float -1.267188
	.float 0.945864
	.float -0.369870
	.float -0.137896
	.float 0.341115
	.float -0.214314
	.float -0.071892
	.float 0.283335
	.float -0.277123
	.float 0.075875
	.float 0.177715
	.float -0.338027
	.float 0.352697
	.float -0.273525
	.float 0.190110
	.float -0.151422
	.float 0.138427
	.float -0.099149
	.float 0.003548
	.float 0.133504
	.float -0.276466
	.float 0.409066
	.float -0.545113
	.float 0.698157
	.float -0.842122
	.float 0.908456
	.float -0.832460
	.float 0.610641
	.float -0.315426
	.float 0.049543
	.float 0.121145
	.float -0.196467
	.float 0.210175
	.float -0.176394
	.float 0.075648
	.float 0.098929
	.float -0.282318
	.float 0.337213
	.float -0.137347
	.float -0.321363
	.float 0.878484
	.float -1.287127
	.float 1.368357
	.float -1.129321
	.float 0.753024
	.float -0.464652
	.float 0.376022
	.float -0.426496
	.float 0.460697
	.float -0.373331
	.float 0.198387
	.float -0.068813
	.float 0.082554
	.float -0.192127
	.float 0.219754
	.float 0.002764
	.float -0.476458
	.float 0.992109
	.float -1.251624
	.float 1.077740
	.float -0.559351
	.float 0.017387
	.float 0.198002
	.float 0.055911
	.float -0.609419
	.float 1.083409
	.float -1.133043
	.float 0.667574
	.float 0.098086
	.float -0.785732
	.float 1.086277
	.float -0.928648
	.float 0.489515
	.float -0.060189
	.float -0.128409
	.float 0.014980
	.float 0.296488
	.float -0.627398
	.float 0.831762
	.float -0.856345
	.float 0.732039
	.float -0.522208
	.float 0.277348
	.float -0.029863
	.float -0.180145
	.float 0.290583
	.float -0.246527
	.float 0.055359
	.float 0.189459
	.float -0.357474
	.float 0.377366
	.float -0.298339
	.float 0.253040
	.float -0.341645
	.float 0.532568
	.float -0.668859
	.float 0.581421
	.float -0.220296
	.float -0.298983
	.float 0.764523
	.float -0.993828
	.float 0.925975
	.float -0.631526
	.float 0.258211
	.float 0.038192
	.float -0.144931
	.float 0.023586
	.float 0.274130
	.float -0.617842
	.float 0.854688
	.float -0.897744
	.float 0.790441
	.float -0.683439
	.float 0.718025
	.float -0.894352
	.float 1.038336
	.float -0.917695
	.float 0.435220
	.float 0.252326
	.float -0.799481
	.float 0.891431
	.float -0.460918
	.float -0.258546
	.float 0.882284
	.float -1.116501
	.float 0.922568
	.float -0.502790
	.float 0.140103
	.float -0.015897
	.float 0.122206
	.float -0.301173
	.float 0.359752
	.float -0.177964
	.float -0.240501
	.float 0.778218
	.float -1.251529
	.float 1.476408
	.float -1.342627
	.float 0.877462
	.float -0.262000
	.float -0.234073
	.float 0.388495
	.float -0.162930
	.float -0.255520
	.float 0.555085
	.float -0.493646
	.float 0.061569
	.float 0.502540
	.float -0.863245
	.float 0.808631
	.float -0.389759
	.float -0.115722
	.float 0.388403
	.float -0.271811
	.float -0.138424
	.float 0.570188
	.float -0.754351
	.float 0.588100
	.float -0.186951
	.float -0.193961
	.float 0.314353
	.float -0.090630
	.float -0.351695
	.float 0.744694
	.float -0.830534
	.float 0.515281
	.float 0.068946
	.float -0.636792
	.float 0.915037
	.float -0.796167
	.float 0.384117
	.float 0.088691
	.float -0.408598
	.float 0.495849
	.float -0.426335
	.float 0.364693
	.float -0.459246
	.float 0.755409
	.float -1.164439
	.float 1.500791
	.float -1.575521
	.float 1.304059
	.float -0.766314
	.float 0.171589
	.float 0.261879
	.float -0.437887
	.float 0.431658
	.float -0.419719
	.float 0.542290
	.float -0.802095
	.float 1.074277
	.float -1.214094
	.float 1.173452
	.float -1.033638
	.float 0.930183
	.float -0.932061
	.float 0.973490
	.float -0.896766
	.float 0.577543
	.float -0.037110
	.float -0.547202
	.float 0.946946
	.float -1.027886
	.float 0.830904
	.float -0.534911
	.float 0.337911
	.float -0.345329
	.float 0.533802
	.float -0.790495
	.float 0.978902
	.float -0.988279
	.float 0.762177
	.float -0.322499
	.float -0.213450
	.float 0.652705
	.float -0.803871
	.float 0.583489
	.float -0.080109
	.float -0.480729
	.float 0.858679
	.float -0.927549
	.float 0.723148
	.float -0.385068
	.float 0.045917
	.float 0.244635
	.float -0.510188
	.float 0.774341
	.float -0.995983
	.float 1.075368
	.float -0.932902
	.float 0.598275
	.float -0.230466
	.float 0.035032
	.float -0.124928
	.float 0.425140
	.float -0.702777
	.float 0.716740
	.float -0.386483
	.float -0.146959
	.float 0.619538
	.float -0.832299
	.float 0.784892
	.float -0.650526
	.float 0.615088
	.float -0.713098
	.float 0.795451
	.float -0.656368
	.float 0.218338
	.float 0.373843
	.float -0.829301
	.float 0.907559
	.float -0.594070
	.float 0.125057
	.float 0.162433
	.float -0.055264
	.float -0.392033
	.float 0.896909
	.float -1.144294
	.float 0.997867
	.float -0.575418
	.float 0.139492
	.float 0.105957
	.float -0.153307
	.float 0.161363
	.float -0.292260
	.float 0.553506
	.float -0.774213
	.float 0.732403
	.float -0.331148
	.float -0.310735
	.float 0.915323
	.float -1.200712
	.float 1.026393
	.float -0.446555
	.float -0.335440
	.float 1.060963
	.float -1.503813
	.float 1.529860
	.float -1.132015
	.float 0.441235
	.float 0.301767
	.float -0.827286
	.float 0.951032
	.float -0.666889
	.float 0.155711
	.float 0.309984
	.float -0.517621
	.float 0.430559
	.float -0.193013
	.float 0.020019
	.float -0.047746
	.float 0.247144
	.float -0.458745
	.float 0.518771
	.float -0.382287
	.float 0.153958
	.float -0.008019
	.float 0.060955
	.float -0.291208
	.float 0.560462
	.float -0.712603
	.float 0.674465
	.float -0.489834
	.float 0.274456
	.float -0.134282
	.float 0.104840
	.float -0.144002
	.float 0.172134
	.float -0.129356
	.float 0.017155
	.float 0.098280
	.float -0.125284
	.float 0.011404
	.float 0.204857
	.float -0.395860
	.float 0.413773
	.float -0.192043
	.float -0.189368
	.float 0.531984
	.float -0.636947
	.float 0.441783
	.float -0.079501
	.float -0.191572
	.float 0.152250
	.float 0.224092
	.float -0.734814
	.float 1.061574
	.float -0.967481
	.float 0.451759
	.float 0.241308
	.float -0.767301
	.float 0.885116
	.float -0.585078
	.float 0.063326
	.float 0.424884
	.float -0.719902
	.float 0.816577
	.float -0.809847
	.float 0.795171
	.float -0.807174
	.float 0.825217
	.float -0.812938
	.float 0.745931
	.float -0.615959
	.float 0.430731
	.float -0.221296
	.float 0.042957
	.float 0.048953
	.float -0.039004
	.float -0.029645
	.float 0.083346
	.float -0.075943
	.float 0.028544
	.float -0.016232
	.float 0.111571
	.float -0.327747
	.float 0.599652
	.float -0.810383
	.float 0.843479
	.float -0.634491
	.float 0.202056
	.float 0.351302
	.float -0.870643
	.float 1.203635
	.float -1.259302
	.float 1.046139
	.float -0.671985
	.float 0.303170
	.float -0.096681
	.float 0.131367
	.float -0.368988
	.float 0.667348
	.float -0.845213
	.float 0.769930
	.float -0.423423
	.float -0.087949
	.float 0.582983
	.float -0.887998
	.float 0.912956
	.float -0.689764
	.float 0.358050
	.float -0.101226
	.float 0.055315
	.float -0.232077
	.float 0.503979
	.float -0.672969
	.float 0.593462
	.float -0.273157
	.float -0.122658
	.float 0.376871
	.float -0.368344
	.float 0.155863
	.float 0.066700
	.float -0.114416
	.float -0.051196
	.float 0.294281
	.float -0.408533
	.float 0.275647
	.float 0.040360
	.float -0.334859
	.float 0.411045
	.float -0.226131
	.float -0.072496
	.float 0.248463
	.float -0.142967
	.float -0.210989
	.float 0.604135
	.float -0.781804
	.float 0.600156
	.float -0.108727
	.float -0.483360
	.float 0.925498
	.float -1.051736
	.float 0.847180
	.float -0.431941
	.float -0.012157
	.float 0.324451
	.float -0.419087
	.float 0.297924
	.float -0.033081
	.float -0.264524
	.float 0.481492
	.float -0.538541
	.float 0.419125
	.float -0.175880
	.float -0.093776
	.float 0.294897
	.float -0.380832
	.float 0.371673
	.float -0.335499
	.float 0.343028
	.float -0.421063
	.float 0.531105
	.float -0.587877
	.float 0.511162
	.float -0.281560
	.float -0.037017
	.float 0.328242
	.float -0.491283
	.float 0.500152
	.float -0.411612
	.float 0.316231
	.float -0.269963
	.float 0.258697
	.float -0.222241
	.float 0.117006
	.float 0.035480
	.float -0.157805
	.float 0.179300
	.float -0.100124
	.float -0.003019
	.float 0.040913
	.float 0.008801
	.float -0.082664
	.float 0.096971
	.float -0.038859
	.float -0.009340
	.float -0.053351
	.float 0.235242
	.float -0.415617
	.float 0.430412
	.float -0.212777
	.float -0.136069
	.float 0.414270
	.float -0.473531
	.float 0.333795
	.float -0.164978
	.float 0.151085
	.float -0.343568
	.float 0.614093
	.float -0.739457
	.float 0.555246
	.float -0.070242
	.float -0.534696
	.float 1.017821
	.float -1.219205
	.float 1.139877
	.float -0.909964
	.float 0.677759
	.float -0.504400
	.float 0.339916
	.float -0.092811
	.float -0.265840
	.float 0.649063
	.float -0.897830
	.float 0.892433
	.float -0.646285
	.float 0.307209
	.float -0.061480
	.float 0.012941
	.float -0.127884
	.float 0.282109
	.float -0.363990
	.float 0.347606
	.float -0.285678
	.float 0.245362
	.float -0.252706
	.float 0.289429
	.float -0.327160
	.float 0.352378
	.float -0.357716
	.float 0.320803
	.float -0.207675
	.float 0.006880
	.float 0.241171
	.float -0.459958
	.float 0.594463
	.float -0.661241
	.float 0.739162
	.float -0.899899
	.float 1.135669
	.float -1.351023
	.float 1.432702
	.float -1.340105
	.float 1.135907
	.float -0.927650
	.float 0.772147
	.float -0.632074
	.float 0.426499
	.float -0.128060
	.float -0.186325
	.float 0.382263
	.float -0.372991
	.float 0.192338
	.float 0.021573
	.float -0.110411
	.float -0.021017
	.float 0.371170
	.float -0.855913
	.float 1.341244
	.float -1.678806
	.float 1.748769
	.float -1.508013
	.float 1.020107
	.float -0.437351
	.float -0.066894
	.float 0.377581
	.float -0.479623
	.float 0.438755
	.float -0.342620
	.float 0.246964
	.float -0.159967
	.float 0.064252
	.float 0.051217
	.float -0.177490
	.float 0.295528
	.float -0.392033
	.float 0.460190
	.float -0.484067
	.float 0.427140
	.float -0.247586
	.float -0.060306
	.float 0.428901
	.float -0.722314
	.float 0.796876
	.float -0.587534
	.float 0.163356
	.float 0.292624
	.float -0.575740
	.float 0.569973
	.float -0.306023
	.float -0.069053
	.float 0.386933
	.float -0.552165
	.float 0.575916
	.float -0.536568
	.float 0.504936
	.float -0.491572
	.float 0.451785
	.float -0.340346
	.float 0.171973
	.float -0.038413
	.float 0.061402
	.float -0.307286
	.float 0.721732
	.float -1.136450
	.float 1.353401
	.float -1.255677
	.float 0.872729
	.float -0.357528
	.float -0.105038
	.float 0.393842
	.float -0.490466
	.float 0.447088
	.float -0.320514
	.float 0.129572
	.float 0.132389
	.float -0.445991
	.float 0.726689
	.float -0.843711
	.float 0.697641
	.float -0.304637
	.float -0.181337
	.float 0.538374
	.float -0.600478
	.float 0.352166
	.float 0.071264
	.float -0.473498
	.float 0.709337
	.float -0.743126
	.float 0.627880
	.float -0.441536
	.float 0.237776
	.float -0.040787
	.float -0.132617
	.float 0.258191
	.float -0.313319
	.float 0.295327
	.float -0.224537
	.float 0.125764
	.float -0.006515
	.float -0.145509
	.float 0.342340
	.float -0.572682
	.float 0.796775
	.float -0.962656
	.float 1.027740
	.float -0.970357
	.float 0.791362
	.float -0.516927
	.float 0.206488
	.float 0.046430
	.float -0.137243
	.float -0.002694
	.float 0.358226
	.float -0.813695
	.float 1.184730
	.float -1.290561
	.float 1.036813
	.float -0.472521
	.float -0.210399
	.float 0.747871
	.float -0.925635
	.float 0.695990
	.float -0.217881
	.float -0.221275
	.float 0.370198
	.float -0.166082
	.float -0.230184
	.float 0.545161
	.float -0.575970
	.float 0.315793
	.float 0.062787
	.float -0.344593
	.float 0.419277
	.float -0.332066
	.float 0.212951
	.float -0.154298
	.float 0.138377
	.float -0.068078
	.float -0.132331
	.float 0.433062
	.float -0.701462
	.float 0.791016
	.float -0.648323
	.float 0.356607
	.float -0.083609
	.float -0.028234
	.float -0.048061
	.float 0.213107
	.float -0.312952
	.float 0.244221
	.float -0.024610
	.float -0.217029
	.float 0.327109
	.float -0.236984
	.float 0.020374
	.float 0.149730
	.float -0.125507
	.float -0.094702
	.float 0.344393
	.float -0.397025
	.float 0.136252
	.float 0.336701
	.float -0.747287
	.float 0.823647
	.float -0.484100
	.float -0.097992
	.float 0.600713
	.float -0.760380
	.float 0.537992
	.float -0.136245
	.float -0.137954
	.float 0.069073
	.float 0.340802
	.float -0.887229
	.float 1.296382
	.float -1.381104
	.float 1.123470
	.float -0.647683
	.float 0.121289
	.float 0.338084
	.float -0.692148
	.float 0.945068
	.float -1.087806
	.float 1.078456
	.float -0.877325
	.float 0.504698
	.float -0.066178
	.float -0.285588
	.float 0.433092
	.float -0.361087
	.float 0.159091
	.float 0.042676
	.float -0.154771
	.float 0.168289
	.float -0.130475
	.float 0.086487
	.float -0.039967
	.float -0.036567
	.float 0.157566
	.float -0.291826
	.float 0.375020
	.float -0.359504
	.float 0.259263
	.float -0.151115
	.float 0.129249
	.float -0.247486
	.float 0.490883
	.float -0.789952
	.float 1.057992
	.float -1.221572
	.float 1.233717
	.float -1.080873
	.float 0.794518
	.float -0.457451
	.float 0.181925
	.float -0.055366
	.float 0.084600
	.float -0.186354
	.float 0.242226
	.float -0.181999
	.float 0.030419
	.float 0.119902
	.float -0.183397
	.float 0.138254
	.float -0.020314
	.float -0.128816
	.float 0.300753
	.float -0.506507
	.float 0.728850
	.float -0.897878
	.float 0.926055
	.float -0.779422
	.float 0.521379
	.float -0.284397
	.float 0.185455
	.float -0.249646
	.float 0.400271
	.float -0.520327
	.float 0.534452
	.float -0.448981
	.float 0.326898
	.float -0.229474
	.float 0.179417
	.float -0.172888
	.float 0.217058
	.float -0.343824
	.float 0.574041
	.float -0.859904
	.float 1.065440
	.float -1.023731
	.float 0.647474
	.float -0.017611
	.float -0.623657
	.float 0.988100
	.float -0.900149
	.float 0.397240
	.float 0.294546
	.float -0.891980
	.float 1.201978
	.float -1.188906
	.float 0.932714
	.float -0.533379
	.float 0.049476
	.float 0.485024
	.float -0.999244
	.float 1.355952
	.float -1.401494
	.float 1.069905
	.float -0.459651
	.float -0.188179
	.float 0.613073
	.float -0.684661
	.float 0.476240
	.float -0.206904
	.float 0.088063
	.float -0.181251
	.float 0.367072
	.float -0.443351
	.float 0.275583
	.float 0.109572
	.float -0.545766
	.float 0.832537
	.float -0.843890
	.float 0.577296
	.float -0.137889
	.float -0.310520
	.float 0.600499
	.float -0.617082
	.float 0.351305
	.float 0.072870
	.float -0.433849
	.float 0.516694
	.float -0.238390
	.float -0.286848
	.float 0.797147
	.float -1.027040
	.float 0.857129
	.float -0.374004
	.float -0.192995
	.float 0.607065
	.float -0.738009
	.float 0.590279
	.float -0.251552
	.float -0.178193
	.float 0.619961
	.float -1.003577
	.float 1.247991
	.float -1.275137
	.float 1.059330
	.float -0.671574
	.float 0.270958
	.float -0.031428
	.float 0.043730
	.float -0.259083
	.float 0.518461
	.float -0.653802
	.float 0.593668
	.float -0.399004
	.float 0.205048
	.float -0.115195
	.float 0.128628
	.float -0.153847
	.float 0.090069
	.float 0.092381
	.float -0.333348
	.float 0.529573
	.float -0.600767
	.float 0.524092
	.float -0.324913
	.float 0.050693
	.float 0.239814
	.float -0.467239
	.float 0.527486
	.float -0.320329
	.float -0.189504
	.float 0.915120
	.float -1.641901
	.float 2.097329
	.float -2.071891
	.float 1.529034
	.float -0.641155
	.float -0.272876
	.float 0.880362
	.float -0.974288
	.float 0.556361
	.float 0.170440
	.float -0.893723
	.float 1.326338
	.float -1.325054
	.float 0.939843
	.float -0.372737
	.float -0.130165
	.float 0.395770
	.float -0.390951
	.float 0.211665
	.float -0.010535
	.float -0.092501
	.float 0.070076
	.float 0.007907
	.float -0.022871
	.float -0.117290
	.float 0.416440
	.float -0.776940
	.float 1.043411
	.float -1.079314
	.float 0.832940
	.float -0.358869
	.float -0.207160
	.float 0.696711
	.float -0.956361
	.float 0.886996
	.float -0.478556
	.float -0.166498
	.float 0.844790
	.float -1.318768
	.float 1.422983
	.float -1.153516
	.float 0.677255
	.float -0.243333
	.float 0.045636
	.float -0.122518
	.float 0.355647
	.float -0.562736
	.float 0.619106
	.float -0.530297
	.float 0.415546
	.float -0.418508
	.float 0.603199
	.float -0.899616
	.float 1.134360
	.float -1.131970
	.float 0.827921
	.float -0.321450
	.float -0.171204
	.float 0.439768
	.float -0.403380
	.float 0.154406
	.float 0.106360
	.float -0.199174
	.float 0.072050
	.float 0.184865
	.float -0.419435
	.float 0.527501
	.float -0.510969
	.float 0.448501
	.float -0.414315
	.float 0.417585
	.float -0.409987
	.float 0.345803
	.float -0.235215
	.float 0.142417
	.float -0.132614
	.float 0.215584
	.float -0.332853
	.float 0.397058
	.float -0.351254
	.float 0.206001
	.float -0.032392
	.float -0.078824
	.float 0.064864
	.float 0.078691
	.float -0.294161
	.float 0.482028
	.float -0.537703
	.float 0.394703
	.float -0.059104
	.float -0.383965
	.float 0.801937
	.float -1.071443
	.float 1.125681
	.float -0.963800
	.float 0.626053
	.float -0.169591
	.float -0.325759
	.float 0.734718
	.float -0.896221
	.float 0.687186
	.float -0.125847
	.float -0.582613
	.float 1.124471
	.float -1.251207
	.float 0.932621
	.float -0.372600
	.float -0.129884
	.float 0.374848
	.float -0.370586
	.float 0.288048
	.float -0.307948
	.float 0.482088
	.float -0.707420
	.float 0.820013
	.float -0.729228
	.float 0.489405
	.float -0.256635
	.float 0.164778
	.float -0.215166
	.float 0.268385
	.float -0.152474
	.float -0.189879
	.float 0.631785
	.float -0.935453
	.float 0.922384
	.float -0.609679
	.float 0.198850
	.float 0.083050
	.float -0.166096
	.float 0.192011
	.float -0.386203
	.float 0.842614
	.float -1.397062
	.float 1.705239
	.float -1.484434
	.float 0.744935
	.float 0.167496
	.float -0.765870
	.float 0.729434
	.float -0.116057
	.float -0.667464
	.float 1.118835
	.float -0.948555
	.float 0.242675
	.float 0.614135
	.float -1.186331
	.float 1.234108
	.float -0.810640
	.float 0.178680
	.float 0.367644
	.float -0.652812
	.float 0.667714
	.float -0.520297
	.float 0.344825
	.float -0.227111
	.float 0.175049
	.float -0.134602
	.float 0.033393
	.float 0.171785
	.float -0.464783
	.float 0.769798
	.float -0.979626
	.float 0.999062
	.float -0.784886
	.float 0.366592
	.float 0.158580
	.float -0.653784
	.float 0.985179
	.float -1.066900
	.float 0.893977
	.float -0.547298
	.float 0.160637
	.float 0.141362
	.float -0.302273
	.float 0.351245
	.float -0.362991
	.float 0.389184
	.float -0.416020
	.float 0.385148
	.float -0.260465
	.float 0.081415
	.float 0.048507
	.float -0.034088
	.float -0.135555
	.float 0.369161
	.float -0.529012
	.float 0.517168
	.float -0.330167
	.float 0.048722
	.float 0.220477
	.float -0.404545
	.float 0.487781
	.float -0.493545
	.float 0.448668
	.float -0.360655
	.float 0.223397
	.float -0.044009
	.float -0.132524
	.float 0.225575
	.float -0.156851
	.float -0.092930
	.float 0.446465
	.float -0.747043
	.float 0.835187
	.float -0.645209
	.float 0.257922
	.float 0.134449
	.float -0.337416
	.float 0.268769
	.float -0.002248
	.float -0.287837
	.float 0.440033
	.float -0.399523
	.float 0.235204
	.float -0.079893
	.float 0.040196
	.float -0.132187
	.float 0.274162
	.float -0.334355
	.float 0.206319
	.float 0.126054
	.float -0.568331
	.float 0.954134
	.float -1.123604
	.float 0.998287
	.float -0.611020
	.float 0.079892
	.float 0.450355
	.float -0.863448
	.float 1.101554
	.float -1.168481
	.float 1.113190
	.float -0.999691
	.float 0.870541
	.float -0.721923
	.float 0.510986
	.float -0.200164
	.float -0.188539
	.float 0.552868
	.float -0.749880
	.float 0.678843
	.float -0.355293
	.float -0.073750
	.float 0.387121
	.float -0.390963
	.float 0.015388
	.float 0.637555
	.float -1.319582
	.float 1.735581
	.float -1.685458
	.float 1.182719
	.float -0.473898
	.float -0.076849
	.float 0.189733
	.float 0.162692
	.float -0.738486
	.float 1.181261
	.float -1.244891
	.float 0.932213
	.float -0.455422
	.float 0.060853
	.float 0.140161
	.float -0.208890
	.float 0.274477
	.float -0.392638
	.float 0.494004
	.float -0.460405
	.float 0.250590
	.float 0.044557
	.float -0.269458
	.float 0.332474
	.float -0.278106
	.float 0.237794
	.float -0.304038
	.float 0.441977
	.float -0.517350
	.float 0.416416
	.float -0.152904
	.float -0.131684
	.float 0.275911
	.float -0.225532
	.float 0.074552
	.float 0.013742
	.float 0.058676
	.float -0.244173
	.float 0.389878
	.float -0.366997
	.float 0.182947
	.float 0.018536
	.float -0.072821
	.float -0.068132
	.float 0.291115
	.float -0.410107
	.float 0.317205
	.float -0.072135
	.float -0.143861
	.float 0.173251
	.float -0.009366
	.float -0.196190
	.float 0.251626
	.float -0.076931
	.float -0.226966
	.float 0.445321
	.float -0.405359
	.float 0.107416
	.float 0.264927
	.float -0.466777
	.float 0.360833
	.float -0.012102
	.float -0.361105
	.float 0.543608
	.float -0.470819
	.float 0.258432
	.float -0.097760
	.float 0.104812
	.float -0.243770
	.float 0.379354
	.float -0.403988
	.float 0.325867
	.float -0.242299
	.float 0.227256
	.float -0.239853
	.float 0.145151
	.float 0.160594
	.float -0.625049
	.float 1.031335
	.float -1.131341
	.float 0.827277
	.float -0.259545
	.float -0.274462
	.float 0.515094
	.float -0.405660
	.float 0.108331
	.float 0.132029
	.float -0.166637
	.float 0.033123
	.float 0.095279
	.float -0.047948
	.float -0.222002
	.float 0.607586
	.float -0.911588
	.float 0.954474
	.float -0.669652
	.float 0.147755
	.float 0.386877
	.float -0.666033
	.float 0.505270
	.float 0.089348
	.float -0.900847
	.float 1.593815
	.float -1.877585
	.float 1.648312
	.float -1.029344
	.float 0.294454
	.float 0.271972
	.float -0.498236
	.float 0.377959
	.float -0.044643
	.float -0.306619
	.float 0.512354
	.float -0.512414
	.float 0.370589
	.float -0.233006
	.float 0.242494
	.float -0.453285
	.float 0.793314
	.float -1.096032
	.float 1.185905
	.float -0.972944
	.float 0.507353
	.float 0.037143
	.float -0.447935
	.float 0.585591
	.float -0.461135
	.float 0.228851
	.float -0.092423
	.float 0.178404
	.float -0.456575
	.float 0.759429
	.float -0.889807
	.float 0.747505
	.float -0.394176
	.float 0.016797
	.float 0.185689
	.float -0.121709
	.float -0.139491
	.float 0.409975
	.float -0.494597
	.float 0.306923
	.float 0.076542
	.float -0.455588
	.float 0.616695
	.float -0.449604
	.float 0.000227
	.float 0.569389
	.float -1.079541
	.float 1.417699
	.float -1.555116
	.float 1.502898
	.float -1.265379
	.float 0.843190
	.float -0.281676
	.float -0.292194
	.float 0.697546
	.float -0.787422
	.float 0.533999
	.float -0.045813
	.float -0.494248
	.float 0.920121
	.float -1.139821
	.float 1.136167
	.float -0.938728
	.float 0.606159
	.float -0.225916
	.float -0.093940
	.float 0.261265
	.float -0.247093
	.float 0.102163
	.float 0.078857
	.float -0.218940
	.float 0.294981
	.float -0.323172
	.float 0.317420
	.float -0.268476
	.float 0.164177
	.float -0.025021
	.float -0.088733
	.float 0.114549
	.float -0.040119
	.float -0.076088
	.float 0.138811
	.float -0.082388
	.float -0.077673
	.float 0.245252
	.float -0.298303
	.float 0.165407
	.float 0.121548
	.float -0.432830
	.float 0.607861
	.float -0.549950
	.float 0.292242
	.float 0.012118
	.float -0.178419
	.float 0.105785
	.float 0.157085
	.float -0.442531
	.float 0.571019
	.float -0.459952
	.float 0.160452
	.float 0.195095
	.float -0.485530
	.float 0.662031
	.float -0.741395
	.float 0.753922
	.float -0.700771
	.float 0.558307
	.float -0.319661
	.float 0.031132
	.float 0.213715
	.float -0.322686
	.float 0.262361
	.float -0.083588
	.float -0.103517
	.float 0.189866
	.float -0.127134
	.float -0.047745
	.float 0.236890
	.float -0.341481
	.float 0.323414
	.float -0.231569
	.float 0.172100
	.float -0.234195
	.float 0.415614
	.float -0.602147
	.float 0.628941
	.float -0.396241
	.float -0.037624
	.float 0.462771
	.float -0.639784
	.float 0.464595
	.float -0.058570
	.float -0.295465
	.float 0.342363
	.float -0.041813
	.float -0.385249
	.float 0.596535
	.float -0.366195
	.float -0.245855
	.float 0.917716
	.float -1.271581
	.float 1.120421
	.float -0.583457
	.float -0.006032
	.float 0.328668
	.float -0.279559
	.float 0.009429
	.float 0.204774
	.float -0.154189
	.float -0.176654
	.float 0.622390
	.float -0.957535
	.float 1.034902
	.float -0.857055
	.float 0.550472
	.float -0.272165
	.float 0.113301
	.float -0.059374
	.float 0.027197
	.float 0.052072
	.float -0.166242
	.float 0.222333
	.float -0.115071
	.float -0.185858
	.float 0.593584
	.float -0.939035
	.float 1.061938
	.float -0.901282
	.float 0.531978
	.float -0.127562
	.float -0.129951
	.float 0.144916
	.float 0.042709
	.float -0.282931
	.float 0.405746
	.float -0.327384
	.float 0.107607
	.float 0.084616
	.float -0.084918
	.float -0.142634
	.float 0.460146
	.float -0.634640
	.float 0.500835
	.float -0.097513
	.float -0.330194
	.float 0.481367
	.float -0.206900
	.float -0.374353
	.float 0.940123
	.float -1.168365
	.float 0.937721
	.float -0.390429
	.float -0.171458
	.float 0.471507
	.float -0.401913
	.float 0.050734
	.float 0.374624
	.float -0.663241
	.float 0.692512
	.float -0.465060
	.float 0.090705
	.float 0.269368
	.float -0.471307
	.float 0.442328
	.float -0.198783
	.float -0.173930
	.float 0.561491
	.float -0.856739
	.float 0.981048
	.float -0.897917
	.float 0.629308
	.float -0.268140
	.float -0.037641
	.float 0.145297
	.float -0.001927
	.float -0.302431
	.float 0.564012
	.float -0.574920
	.float 0.248142
	.float 0.326665
	.float -0.934773
	.float 1.357046
	.float -1.476596
	.float 1.308229
	.float -0.951702
	.float 0.521737
	.float -0.107706
	.float -0.225948
	.float 0.427676
	.float -0.466980
	.float 0.362756
	.float -0.200699
	.float 0.109007
	.float -0.193618
	.float 0.470091
	.float -0.838051
	.float 1.120960
	.float -1.155191
	.float 0.882359
	.float -0.393657
	.float -0.103397
	.float 0.385387
	.float -0.331073
	.float -0.008594
	.float 0.432594
	.float -0.697331
	.float 0.651006
	.float -0.317962
	.float -0.116897
	.float 0.416050
	.float -0.428204
	.float 0.176926
	.float 0.154474
	.float -0.334480
	.float 0.224124
	.float 0.140504
	.float -0.574920
	.float 0.861665
	.float -0.876767
	.float 0.647829
	.float -0.316600
	.float 0.043567
	.float 0.078176
	.float -0.053151
	.float -0.042141
	.float 0.107666
	.float -0.058692
	.float -0.153071
	.float 0.524679
	.float -0.984607
	.float 1.386273
	.float -1.540262
	.float 1.298864
	.float -0.662481
	.float -0.162689
	.float 0.820818
	.float -0.977621
	.float 0.520008
	.float 0.345651
	.float -1.180352
	.float 1.551584
	.float -1.283563
	.float 0.559565
	.float 0.191146
	.float -0.549983
	.float 0.346295
	.float 0.266906
	.float -0.929498
	.float 1.291753
	.float -1.192584
	.float 0.705551
	.float -0.056002
	.float -0.512647
	.float 0.838948
	.float -0.873778
	.float 0.659691
	.float -0.298056
	.float -0.076487
	.float 0.322388
	.float -0.332933
	.float 0.087266
	.float 0.318827
	.float -0.693466
	.float 0.825110
	.float -0.584607
	.float 0.003382
	.float 0.714293
	.float -1.260571
	.float 1.355893
	.float -0.892221
	.float 0.016508
	.float 0.905884
	.float -1.452797
	.float 1.358682
	.float -0.656535
	.float -0.343916
	.float 1.230069
	.float -1.698018
	.float 1.668538
	.float -1.257296
	.float 0.660019
	.float -0.056693
	.float -0.413272
	.float 0.638944
	.float -0.551890
	.float 0.179779
	.float 0.317480
	.float -0.693525
	.float 0.740378
	.float -0.409922
	.float -0.160779
	.float 0.739910
	.float -1.135782
	.float 1.276770
	.float -1.194292
	.float 0.952230
	.float -0.602156
	.float 0.199698
	.float 0.157287
	.float -0.337902
	.float 0.256984
	.float 0.034839
	.float -0.342280
	.float 0.435485
	.float -0.214728
	.float -0.194769
	.float 0.503491
	.float -0.443199
	.float -0.051466
	.float 0.795064
	.float -1.467413
	.float 1.805705
	.float -1.738391
	.float 1.383420
	.float -0.938925
	.float 0.562438
	.float -0.318484
	.float 0.201633
	.float -0.182555
	.float 0.225507
	.float -0.275199
	.float 0.252867
	.float -0.093085
	.float -0.195442
	.float 0.501124
	.float -0.655608
	.float 0.539298
	.float -0.174496
	.float -0.268018
	.float 0.566620
	.float -0.591027
	.float 0.391058
	.float -0.164459
	.float 0.118832
	.float -0.319473
	.float 0.631165
	.float -0.800354
	.float 0.626423
	.float -0.105960
	.float -0.549432
	.float 1.033588
	.float -1.123130
	.float 0.796867
	.float -0.229104
	.float -0.323980
	.float 0.663244
	.float -0.727965
	.float 0.589441
	.float -0.383819
	.float 0.236519
	.float -0.213744
	.float 0.307188
	.float -0.442945
	.float 0.510378
	.float -0.412565
	.float 0.125903
	.float 0.264752
	.float -0.592264
	.float 0.696148
	.float -0.526103
	.float 0.187592
	.float 0.112097
	.float -0.192435
	.float 0.021508
	.float 0.253287
	.float -0.395377
	.float 0.239489
	.float 0.181662
	.float -0.637475
	.float 0.840269
	.float -0.641236
	.float 0.144391
	.float 0.351996
	.float -0.555920
	.float 0.382287
	.float -0.003206
	.float -0.292500
	.float 0.322847
	.float -0.145073
	.float -0.003942
	.float -0.094445
	.float 0.465075
	.float -0.919066
	.float 1.190659
	.float -1.112645
	.float 0.702708
	.float -0.123827
	.float -0.419546
	.float 0.765057
	.float -0.824252
	.float 0.588258
	.float -0.137555
	.float -0.353844
	.float 0.658606
	.float -0.595614
	.float 0.146112
	.float 0.495840
	.float -0.996934
	.float 1.061342
	.float -0.609151
	.float -0.163003
	.float 0.890186
	.float -1.252739
	.float 1.154771
	.float -0.749618
	.float 0.305418
	.float -0.017457
	.float -0.095993
	.float 0.152053
	.float -0.267702
	.float 0.445544
	.float -0.567511
	.float 0.492871
	.float -0.179544
	.float -0.264720
	.float 0.639245
	.float -0.775470
	.float 0.644821
	.float -0.377846
	.float 0.184441
	.float -0.227357
	.float 0.526598
	.float -0.946844
	.float 1.269161
	.float -1.304533
	.float 0.991590
	.float -0.432228
	.float -0.152744
	.float 0.530911
	.float -0.578899
	.float 0.351910
	.float -0.055367
	.float -0.075116
	.float -0.079570
	.float 0.440653
	.float -0.773798
	.float 0.834856
	.float -0.527030
	.float -0.033801
	.float 0.586926
	.float -0.878457
	.float 0.794304
	.float -0.396924
	.float -0.136212
	.float 0.611455
	.float -0.889992
	.float 0.911356
	.float -0.691609
	.float 0.319128
	.float 0.059035
	.float -0.283130
	.float 0.259886
	.float -0.031822
	.float -0.222248
	.float 0.280090
	.float -0.018595
	.float -0.484812
	.float 0.970095
	.float -1.137755
	.float 0.838009
	.float -0.185517
	.float -0.484037
	.float 0.802643
	.float -0.593808
	.float -0.010580
	.float 0.642073
	.float -0.918485
	.float 0.679836
	.float -0.085652
	.float -0.490704
	.float 0.702783
	.float -0.450522
	.float -0.063751
	.float 0.475349
	.float -0.496835
	.float 0.097988
	.float 0.487825
	.float -0.925239
	.float 0.990049
	.float -0.691069
	.float 0.229101
	.float 0.161520
	.float -0.367134
	.float 0.438320
	.float -0.506990
	.float 0.655280
	.float -0.842584
	.float 0.941876
	.float -0.847112
	.float 0.561470
	.float -0.198197
	.float -0.099750
	.float 0.253195
	.float -0.281949
	.float 0.263336
	.float -0.258453
	.float 0.270263
	.float -0.264613
	.float 0.227998
	.float -0.205108
	.float 0.275814
	.float -0.482216
	.float 0.761960
	.float -0.948746
	.float 0.859564
	.float -0.423182
	.float -0.237126
	.float 0.837977
	.float -1.084894
	.float 0.850271
	.float -0.262806
	.float -0.355796
	.float 0.669923
	.float -0.513803
	.float -0.028023
	.float 0.678364
	.float -1.117989
	.float 1.144864
	.float -0.767056
	.float 0.190151
	.float 0.295549
	.float -0.476014
	.float 0.334525
	.float -0.052335
	.float -0.123546
	.float 0.060749
	.float 0.161985
	.float -0.322245
	.float 0.239488
	.float 0.066768
	.float -0.377229
	.float 0.440260
	.float -0.179938
	.float -0.220134
	.float 0.430696
	.float -0.211657
	.float -0.401880
	.float 1.099161
	.float -1.481356
	.float 1.306700
	.float -0.626185
	.float -0.272497
	.float 1.056764
	.float -1.532891
	.float 1.703019
	.float -1.685604
	.float 1.590008
	.float -1.450225
	.float 1.251576
	.float -0.999074
	.float 0.751659
	.float -0.592872
	.float 0.570670
	.float -0.661521
	.float 0.784340
	.float -0.847276
	.float 0.793702
	.float -0.624754
	.float 0.395422
	.float -0.188732
	.float 0.076041
	.float -0.078235
	.float 0.148634
	.float -0.193878
	.float 0.128063
	.float 0.069634
	.float -0.330927
	.float 0.528988
	.float -0.552281
	.float 0.380358
	.float -0.111646
	.float -0.084649
	.float 0.073827
	.float 0.145644
	.float -0.421543
	.float 0.533912
	.float -0.341913
	.float -0.106166
	.float 0.584181
	.float -0.825283
	.float 0.697853
	.float -0.295444
	.float -0.129188
	.float 0.343264
	.float -0.293646
	.float 0.123127
	.float -0.028084
	.float 0.071764
	.float -0.110349
	.float -0.096953
	.float 0.672567
	.float -1.471732
	.float 2.127217
	.float -2.268649
	.float 1.764575
	.float -0.818317
	.float -0.146948
	.float 0.734480
	.float -0.791550
	.float 0.466879
	.float -0.085512
	.float -0.066848
	.float -0.091375
	.float 0.422702
	.float -0.699927
	.float 0.777369
	.float -0.678951
	.float 0.545515
	.float -0.492973
	.float 0.500632
	.float -0.423203
	.float 0.119831
	.float 0.402918
	.float -0.952409
	.float 1.255764
	.float -1.138491
	.float 0.646300
	.float -0.021306
	.float -0.449774
	.float 0.606087
	.float -0.485459
	.float 0.260585
	.float -0.098753
	.float 0.051870
	.float -0.049265
	.float -0.017332
	.float 0.191496
	.float -0.411054
	.float 0.552332
	.float -0.518491
	.float 0.303105
	.float 0.012320
	.float -0.313390
	.float 0.509738
	.float -0.554552
	.float 0.430904
	.float -0.142198
	.float -0.268818
	.float 0.693257
	.float -0.970715
	.float 0.966003
	.float -0.663893
	.float 0.200561
	.float 0.211550
	.float -0.419122
	.float 0.419036
	.float -0.333169
	.float 0.293256
	.float -0.336486
	.float 0.395306
	.float -0.376415
	.float 0.249613
	.float -0.071278
	.float -0.064601
	.float 0.094845
	.float -0.018014
	.float -0.123064
	.float 0.276681
	.float -0.401278
	.float 0.462149
	.float -0.425256
	.float 0.268336
	.float -0.007373
	.float -0.284155
	.float 0.487870
	.float -0.488907
	.float 0.237188
	.float 0.214939
	.float -0.724245
	.float 1.114072
	.float -1.247463
	.float 1.079687
	.float -0.668445
	.float 0.143902
	.float 0.343141
	.float -0.672438
	.float 0.788999
	.float -0.712642
	.float 0.521862
	.float -0.318731
	.float 0.188246
	.float -0.167373
	.float 0.234239
	.float -0.320251
	.float 0.340674
	.float -0.234493
	.float 0.000586
	.float 0.286991
	.float -0.498886
	.float 0.507261
	.float -0.258596
	.float -0.176049
	.float 0.608975
	.float -0.811260
	.float 0.625010
	.float -0.055711
	.float -0.709685
	.float 1.376965
	.float -1.678069
	.float 1.495850
	.float -0.914390
	.float 0.172271
	.float 0.449362
	.float -0.740694
	.float 0.628071
	.float -0.177959
	.float -0.439184
	.float 1.001828
	.float -1.299571
	.float 1.203483
	.float -0.726349
	.float 0.035259
	.float 0.611795
	.float -0.987861
	.float 1.012528
	.float -0.787499
	.float 0.525478
	.float -0.414851
	.float 0.504844
	.float -0.682653
	.float 0.753728
	.float -0.572968
	.float 0.143710
	.float 0.376624
	.float -0.767018
	.float 0.871242
	.float -0.681961
	.float 0.327780
	.float 0.021597
	.float -0.261741
	.float 0.395121
	.float -0.485515
	.float 0.571934
	.float -0.618799
	.float 0.545330
	.float -0.306383
	.float -0.047153
	.float 0.383372
	.float -0.568384
	.float 0.546251
	.float -0.360416
	.float 0.110297
	.float 0.112070
	.float -0.255925
	.float 0.304517
	.float -0.252906
	.float 0.101855
	.float 0.127757
	.float -0.380907
	.float 0.575692
	.float -0.632521
	.float 0.507711
	.float -0.213208
	.float -0.183834
	.float 0.577442
	.float -0.850551
	.float 0.912473
	.float -0.738560
	.float 0.394364
	.float -0.021159
	.float -0.223691
	.float 0.246767
	.float -0.071119
	.float -0.176609
	.float 0.341156
	.float -0.329085
	.float 0.157134
	.float 0.068778
	.float -0.224248
	.float 0.238042
	.float -0.122263
	.float -0.050680
	.float 0.204231
	.float -0.309948
	.float 0.403654
	.float -0.553858
	.float 0.799248
	.float -1.094297
	.float 1.304351
	.float -1.266836
	.float 0.893518
	.float -0.254099
	.float -0.420645
	.float 0.838802
	.float -0.808506
	.float 0.366288
	.float 0.219126
	.float -0.590944
	.float 0.519612
	.float -0.050719
	.float -0.521752
	.float 0.847377
	.float -0.747815
	.float 0.322376
	.float 0.139777
	.float -0.369560
	.float 0.293540
	.float -0.054262
	.float -0.122766
	.float 0.103568
	.float 0.067303
	.float -0.218329
	.float 0.188166
	.float 0.056528
	.float -0.400030
	.float 0.655727
	.float -0.682480
	.float 0.463856
	.float -0.110610
	.float -0.202107
	.float 0.318719
	.float -0.166943
	.float -0.217783
	.float 0.704735
	.float -1.109047
	.float 1.254619
	.float -1.045900
	.float 0.522327
	.float 0.137393
	.float -0.677320
	.float 0.873614
	.float -0.639781
	.float 0.072609
	.float 0.588547
	.float -1.070537
	.float 1.188143
	.float -0.917463
	.float 0.387968
	.float 0.193690
	.float -0.639311
	.float 0.845318
	.float -0.809060
	.float 0.607426
	.float -0.359307
	.float 0.182657
	.float -0.147618
	.float 0.237733
	.float -0.346101
	.float 0.326832
	.float -0.086225
	.float -0.339711
	.float 0.778433
	.float -0.999804
	.float 0.840087
	.float -0.299564
	.float -0.442382
	.float 1.104624
	.float -1.435528
	.float 1.333474
	.float -0.896036
	.float 0.369760
	.float -0.020723
	.float -0.009058
	.float -0.220658
	.float 0.486261
	.float -0.537915
	.float 0.257858
	.float 0.257768
	.float -0.747129
	.float 0.934097
	.float -0.692285
	.float 0.123992
	.float 0.489497
	.float -0.834579
	.float 0.726984
	.float -0.205863
	.float -0.482520
	.float 1.000323
	.float -1.079973
	.float 0.659661
	.float 0.073279
	.float -0.760514
	.float 1.046461
	.float -0.766124
	.float 0.044485
	.float 0.758809
	.float -1.241774
	.float 1.185571
	.float -0.677842
	.float 0.053293
	.float 0.315402
	.float -0.243660
	.float -0.169201
	.float 0.633981
	.float -0.883715
	.float 0.851505
	.float -0.691320
	.float 0.636893
	.float -0.810383
	.float 1.122898
	.float -1.334710
	.float 1.226537
	.float -0.759385
	.float 0.117249
	.float 0.390206
	.float -0.501240
	.float 0.150885
	.float 0.483963
	.float -1.065073
	.float 1.260714
	.float -0.920106
	.float 0.162359
	.float 0.679541
	.float -1.242665
	.float 1.344430
	.float -1.082819
	.float 0.750446
	.float -0.615163
	.float 0.724805
	.float -0.884859
	.float 0.828427
	.float -0.447219
	.float -0.098370
	.float 0.478255
	.float -0.427405
	.float -0.058280
	.float 0.705942
	.float -1.136921
	.float 1.103063
	.float -0.631415
	.float -0.008694
	.float 0.482627
	.float -0.590586
	.float 0.365262
	.float -0.015654
	.float -0.231635
	.float 0.279568
	.float -0.200218
	.float 0.153274
	.float -0.255003
	.float 0.495613
	.float -0.755644
	.float 0.895643
	.float -0.846346
	.float 0.639531
	.float -0.371766
	.float 0.139807
	.float 0.004697
	.float -0.060293
	.float 0.053500
	.float -0.016936
	.float -0.017053
	.float 0.014144
	.float 0.055975
	.float -0.200691
	.float 0.387583
	.float -0.550209
	.float 0.619669
	.float -0.562084
	.float 0.394456
	.float -0.170195
	.float -0.051038
	.float 0.225441
	.float -0.329533
	.float 0.355329
	.float -0.308160
	.float 0.208690
	.float -0.092140
	.float 0.000154
	.float 0.031525
	.float 0.014566
	.float -0.125239
	.float 0.246548
	.float -0.289504
	.float 0.167160
	.float 0.143655
	.float -0.557157
	.float 0.899577
	.float -1.003199
	.float 0.815155
	.float -0.437753
	.float 0.063697
	.float 0.144923
	.float -0.140956
	.float -0.015433
	.float 0.229434
	.float -0.434025
	.float 0.594764
	.float -0.676748
	.float 0.629764
	.float -0.420124
	.float 0.080616
	.float 0.275004
	.float -0.498144
	.float 0.484594
	.float -0.232370
	.float -0.159259
	.float 0.544421
	.float -0.801722
	.float 0.881948
	.float -0.812515
	.float 0.666111
	.float -0.517514
	.float 0.412393
	.float -0.358187
	.float 0.331538
	.float -0.290909
	.float 0.189589
	.float 0.006351
	.float -0.290910
	.float 0.592946
	.float -0.778379
	.float 0.700780
	.float -0.290861
	.float -0.363292
	.float 1.009342
	.float -1.330902
	.float 1.120311
	.float -0.425864
	.float -0.433602
	.float 1.023895
	.float -1.046469
	.float 0.530795
	.float 0.166783
	.float -0.574634
	.float 0.402748
	.float 0.267660
	.float -1.029427
	.float 1.403938
	.float -1.139064
	.float 0.356998
	.float 0.538016
	.float -1.120820
	.float 1.196542
	.float -0.881462
	.float 0.478702
	.float -0.252774
	.float 0.263793
	.float -0.362967
	.float 0.330513
	.float -0.044195
	.float -0.437509
	.float 0.920241
	.float -1.198110
	.float 1.166317
	.float -0.856357
	.float 0.393663
	.float 0.072350
	.float -0.414890
	.float 0.543819
	.float -0.414294
	.float 0.052387
	.float 0.420747
	.float -0.811823
	.float 0.945417
	.float -0.775232
	.float 0.430189
	.float -0.142588
	.float 0.095451
	.float -0.297693
	.float 0.580998
	.float -0.720782
	.float 0.590511
	.float -0.239198
	.float -0.153828
	.float 0.402083
	.float -0.421552
	.float 0.260396
	.float -0.047075
	.float -0.095004
	.float 0.111466
	.float -0.031608
	.float -0.062013
	.float 0.087593
	.float -0.014583
	.float -0.115061
	.float 0.211490
	.float -0.200023
	.float 0.085780
	.float 0.028388
	.float 0.005181
	.float -0.280769
	.float 0.759307
	.float -1.265218
	.float 1.571100
	.float -1.524876
	.float 1.144887
	.float -0.624867
	.float 0.238952
	.float -0.192214
	.float 0.495694
	.float -0.940165
	.float 1.196515
	.float -1.000967
	.float 0.326516
	.float 0.565133
	.float -1.239869
	.float 1.326115
	.float -0.737893
	.float -0.252895
	.float 1.153075
	.float -1.524233
	.float 1.234668
	.float -0.530935
	.float -0.118319
	.float 0.308997
	.float 0.061167
	.float -0.749466
	.float 1.336347
	.float -1.488065
	.float 1.146434
	.float -0.536195
	.float 0.002199
	.float 0.209674
	.float -0.089952
	.float -0.155286
	.float 0.258453
	.float -0.073425
	.float -0.330048
	.float 0.716797
	.float -0.842543
	.float 0.609744
	.float -0.122405
	.float -0.386701
	.float 0.697454
	.float -0.717205
	.float 0.506593
	.float -0.220179
	.float 0.013723
	.float 0.026222
	.float 0.097743
	.float -0.318821
	.float 0.550308
	.float -0.719828
	.float 0.776928
	.float -0.683287
	.float 0.413147
	.float 0.016764
	.float -0.505899
	.float 0.868157
	.float -0.907025
	.float 0.541229
	.float 0.108756
	.float -0.758532
	.float 1.121923
	.float -1.092184
	.float 0.805481
	.float -0.529668
	.float 0.457129
	.float -0.560060
	.float 0.621613
	.float -0.417945
	.float -0.092855
	.float 0.721598
	.float -1.172075
	.float 1.237717
	.float -0.923960
	.float 0.419397
	.float 0.041772
	.float -0.313089
	.float 0.378803
	.float -0.304404
	.float 0.159872
	.float 0.018150
	.float -0.209435
	.float 0.373950
	.float -0.442051
	.float 0.345424
	.float -0.064064
	.float -0.349514
	.float 0.787935
	.float -1.134512
	.float 1.304763
	.float -1.261722
	.float 1.008453
	.float -0.578962
	.float 0.042535
	.float 0.485608
	.float -0.852876
	.float 0.916548
	.float -0.617663
	.float 0.037834
	.float 0.609542
	.float -1.066757
	.float 1.156526
	.float -0.871716
	.float 0.375047
	.float 0.090053
	.float -0.323783
	.float 0.262448
	.float 0.002903
	.float -0.283038
	.float 0.392140
	.float -0.247284
	.float -0.084566
	.float 0.423170
	.float -0.582542
	.float 0.486398
	.float -0.212631
	.float -0.067713
	.float 0.212780
	.float -0.200224
	.float 0.118494
	.float -0.075480
	.float 0.108136
	.float -0.167980
	.float 0.184879
	.float -0.141555
	.float 0.089255
	.float -0.095138
	.float 0.176433
	.float -0.283004
	.float 0.340557
	.float -0.311116
	.float 0.217983
	.float -0.120814
	.float 0.070547
	.float -0.083027
	.float 0.144304
	.float -0.230075
	.float 0.315489
	.float -0.369828
	.float 0.350894
	.float -0.217147
	.float -0.039697
	.float 0.360950
	.float -0.616677
	.float 0.652901
	.float -0.380308
	.float -0.143521
	.float 0.701951
	.float -1.011127
	.float 0.879366
	.float -0.336152
	.float -0.365975
	.float 0.894892
	.float -1.039647
	.float 0.831071
	.float -0.497491
	.float 0.290621
	.float -0.312013
	.float 0.464265
	.float -0.552808
	.float 0.449332
	.float -0.189072
	.float -0.066315
	.float 0.161863
	.float -0.069644
	.float -0.094878
	.float 0.166570
	.float -0.057720
	.float -0.178558
	.float 0.390170
	.float -0.434260
	.float 0.269649
	.float 0.024645
	.float -0.301767
	.float 0.422782
	.float -0.311215
	.float -0.024949
	.float 0.493089
	.float -0.933948
	.float 1.168478
	.float -1.073771
	.float 0.654729
	.float -0.058074
	.float -0.496558
	.float 0.832195
	.float -0.899386
	.float 0.774719
	.float -0.585495
	.float 0.427155
	.float -0.331717
	.float 0.290699
	.float -0.289262
	.float 0.313700
	.float -0.336742
	.float 0.314541
	.float -0.214869
	.float 0.055339
	.float 0.089756
	.float -0.131340
	.float 0.028736
	.float 0.175177
	.float -0.374043
	.float 0.456888
	.float -0.363862
	.float 0.107998
	.float 0.237373
	.float -0.567988
	.float 0.781437
	.float -0.809898
	.float 0.648744
	.float -0.365951
	.float 0.076746
	.float 0.111093
	.float -0.150401
	.float 0.071348
	.float 0.048417
	.float -0.136956
	.float 0.168190
	.float -0.167627
	.float 0.187452
	.float -0.269591
	.float 0.415015
	.float -0.572649
	.float 0.656800
	.float -0.592449
	.float 0.367858
	.float -0.056628
	.float -0.219562
	.float 0.374073
	.float -0.424523
	.float 0.483647
	.float -0.662031
	.float 0.951267
	.float -1.187738
	.float 1.145949
	.float -0.707060
	.float -0.021892
	.float 0.738611
	.float -1.118799
	.float 1.017323
	.float -0.558042
	.float 0.050665
	.float 0.207296
	.float -0.110218
	.float -0.208534
	.float 0.482419
	.float -0.490985
	.float 0.193021
	.float 0.265465
	.float -0.659757
	.float 0.828198
	.float -0.751770
	.float 0.529921
	.float -0.288043
	.float 0.095331
	.float 0.049537
	.float -0.171033
	.float 0.264996
	.float -0.295743
	.float 0.242881
	.float -0.147241
	.float 0.102677
	.float -0.188551
	.float 0.395228
	.float -0.607977
	.float 0.673207
	.float -0.505434
	.float 0.156655
	.float 0.207359
	.float -0.414857
	.float 0.406903
	.float -0.280915
	.float 0.221525
	.float -0.360944
	.float 0.665560
	.float -0.933694
	.float 0.914789
	.float -0.475009
	.float -0.301188
	.float 1.143704
	.float -1.743696
	.float 1.919729
	.float -1.697022
	.float 1.255433
	.float -0.791684
	.float 0.396224
	.float -0.028370
	.float -0.403082
	.float 0.924023
	.float -1.436568
	.float 1.762262
	.float -1.752116
	.float 1.382127
	.float -0.769539
	.float 0.109146
	.float 0.416184
	.float -0.692521
	.float 0.681636
	.float -0.403719
	.float -0.069913
	.float 0.610194
	.float -1.038413
	.float 1.177160
	.float -0.934672
	.float 0.372272
	.float 0.299618
	.float -0.809755
	.float 0.954501
	.float -0.694294
	.float 0.166242
	.float 0.387199
	.float -0.729359
	.float 0.725816
	.float -0.391222
	.float -0.122174
	.float 0.585862
	.float -0.789118
	.float 0.635952
	.float -0.201816
	.float -0.290666
	.float 0.582059
	.float -0.521519
	.float 0.158832
	.float 0.283714
	.float -0.548624
	.float 0.498290
	.float -0.180637
	.float -0.233800
	.float 0.581582
	.float -0.792784
	.float 0.872410
	.float -0.816175
	.float 0.563148
	.float -0.050137
	.float -0.671750
	.float 1.374246
	.float -1.731444
	.float 1.515503
	.float -0.775253
	.float -0.143006
	.float 0.770269
	.float -0.784024
	.float 0.200328
	.float 0.634393
	.float -1.244495
	.float 1.291014
	.float -0.742560
	.float -0.137049
	.float 0.955234
	.float -1.398797
	.float 1.367084
	.float -0.976953
	.float 0.464038
	.float -0.051968
	.float -0.139854
	.float 0.114415
	.float 0.048749
	.float -0.259817
	.float 0.457275
	.float -0.600147
	.float 0.638351
	.float -0.508447
	.float 0.177356
	.float 0.296685
	.float -0.750849
	.float 0.989727
	.float -0.905955
	.float 0.557917
	.float -0.134456
	.float -0.175090
	.float 0.305421
	.float -0.335070
	.float 0.389300
	.float -0.512536
	.float 0.621383
	.float -0.576810
	.float 0.310276
	.float 0.106098
	.float -0.503643
	.float 0.734051
	.float -0.758187
	.float 0.636825
	.float -0.444293
	.float 0.195023
	.float 0.142676
	.float -0.557118
	.float 0.919588
	.float -1.016978
	.float 0.692810
	.float 0.005332
	.float -0.799552
	.float 1.321468
	.float -1.332928
	.float 0.872607
	.float -0.223852
	.float -0.270063
	.float 0.411060
	.float -0.237730
	.float -0.037507
	.float 0.180055
	.float -0.066810
	.float -0.268708
	.float 0.680128
	.float -0.992633
	.float 1.075392
	.float -0.876067
	.float 0.421707
	.float 0.194238
	.float -0.825173
	.float 1.291410
	.float -1.425138
	.float 1.144786
	.float -0.525013
	.float -0.197191
	.float 0.716654
	.float -0.820991
	.float 0.518870
	.float -0.040529
	.float -0.301015
	.float 0.298092
	.float 0.039308
	.float -0.512632
	.float 0.869096
	.float -0.943017
	.float 0.724072
	.float -0.336689
	.float -0.034190
	.float 0.226228
	.float -0.164384
	.float -0.108909
	.float 0.451285
	.float -0.688062
	.float 0.703823
	.float -0.506727
	.float 0.221306
	.float -0.010412
	.float -0.023538
	.float -0.106671
	.float 0.294035
	.float -0.412551
	.float 0.392519
	.float -0.250317
	.float 0.062651
	.float 0.089793
	.float -0.171599
	.float 0.206826
	.float -0.252339
	.float 0.347853
	.float -0.475000
	.float 0.555562
	.float -0.497109
	.float 0.261316
	.float 0.091436
	.float -0.418464
	.float 0.570205
	.float -0.479280
	.float 0.203704
	.float 0.106423
	.float -0.297355
	.float 0.296502
	.float -0.140198
	.float -0.066536
	.float 0.222750
	.float -0.284262
	.float 0.266560
	.float -0.208160
	.float 0.130910
	.float -0.029190
	.float -0.108141
	.float 0.266489
	.float -0.395359
	.float 0.432225
	.float -0.345126
	.float 0.161557
	.float 0.041271
	.float -0.180425
	.float 0.213776
	.float -0.154461
	.float 0.045902
	.float 0.077072
	.float -0.206259
	.float 0.344429
	.float -0.475245
	.float 0.549679
	.float -0.503964
	.float 0.298473
	.float 0.046476
	.float -0.437727
	.float 0.729449
	.float -0.776037
	.float 0.503860
	.float 0.030531
	.float -0.636214
	.float 1.058141
	.float -1.096240
	.float 0.709501
	.float -0.042567
	.float -0.642518
	.float 1.091638
	.float -1.175592
	.float 0.943685
	.float -0.591170
	.float 0.353507
	.float -0.372645
	.float 0.604275
	.float -0.830600
	.float 0.792981
	.float -0.377008
	.float -0.273712
	.float 0.812017
	.float -0.897243
	.float 0.430508
	.float 0.347904
	.float -0.978336
	.float 1.052350
	.float -0.464393
	.float -0.516390
	.float 1.402293
	.float -1.776473
	.float 1.535874
	.float -0.934302
	.float 0.397842
	.float -0.234679
	.float 0.437145
	.float -0.713140
	.float 0.721646
	.float -0.335774
	.float -0.263213
	.float 0.726099
	.float -0.794027
	.float 0.472783
	.float 0.000669
	.float -0.352455
	.float 0.459401
	.float -0.389422
	.float 0.290640
	.float -0.247560
	.float 0.229935
	.float -0.159012
	.float 0.008998
	.float 0.157968
	.float -0.251371
	.float 0.242207
	.float -0.195686
	.float 0.215380
	.float -0.349701
	.float 0.542585
	.float -0.671091
	.float 0.639492
	.float -0.456423
	.float 0.236215
	.float -0.124546
	.float 0.201450
	.float -0.426720
	.float 0.659667
	.float -0.735884
	.float 0.553899
	.float -0.128356
	.float -0.407934
	.float 0.848390
	.float -0.990583
	.float 0.728358
	.float -0.124195
	.float -0.583564
	.float 1.068778
	.float -1.076381
	.float 0.568805
	.float 0.235872
	.float -0.971496
	.float 1.319531
	.float -1.174683
	.float 0.683392
	.float -0.143907
	.float -0.159125
	.float 0.085633
	.float 0.322409
	.float -0.891530
	.float 1.407684
	.float -1.700113
	.float 1.693252
	.float -1.421341
	.float 1.007470
	.float -0.611422
	.float 0.361358
	.float -0.296261
	.float 0.348134
	.float -0.377196
	.float 0.247821
	.float 0.089417
	.float -0.552403
	.float 0.950626
	.float -1.077478
	.float 0.830031
	.float -0.286963
	.float -0.312773
	.float 0.689058
	.float -0.670164
	.float 0.280420
	.float 0.285034
	.float -0.773169
	.float 0.997181
	.float -0.901848
	.float 0.551828
	.float -0.072241
	.float -0.413889
	.float 0.821241
	.float -1.103411
	.float 1.230528
	.float -1.166144
	.float 0.870339
	.float -0.340769
	.float -0.331741
	.float 0.946424
	.float -1.257779
	.float 1.106082
	.float -0.531042
	.float -0.223893
	.float 0.839693
	.float -1.104365
	.float 1.024095
	.float -0.786099
	.float 0.607029
	.float -0.582264
	.float 0.642494
	.float -0.634908
	.float 0.454289
	.float -0.122126
	.float -0.236734
	.float 0.488195
	.float -0.573582
	.float 0.522142
	.float -0.394647
	.float 0.219946
	.float 0.011214
	.float -0.288711
	.float 0.524190
	.float -0.567779
	.float 0.314380
	.float 0.177759
	.float -0.667705
	.float 0.858077
	.float -0.591891
	.float -0.026109
	.float 0.683392
	.float -1.056460
	.float 1.008331
	.float -0.648872
	.float 0.230081
	.float 0.029983
	.float -0.064162
	.float -0.051035
	.float 0.191065
	.float -0.278460
	.float 0.311459
	.float -0.326075
	.float 0.338751
	.float -0.319330
	.float 0.211403
	.float 0.019029
	.float -0.343532
	.float 0.669786
	.float -0.883304
	.float 0.907869
	.float -0.744900
	.float 0.466697
	.float -0.171185
	.float -0.065417
	.float 0.206620
	.float -0.243755
	.float 0.180319
	.float -0.034295
	.float -0.149582
	.float 0.303504
	.float -0.367125
	.float 0.322308
	.float -0.197078
	.float 0.032130
	.float 0.156553
	.float -0.375691
	.float 0.610898
	.float -0.788698
	.float 0.799451
	.float -0.582142
	.float 0.202686
	.float 0.155837
	.float -0.308028
	.float 0.206951
	.float 0.005203
	.float -0.091429
	.float -0.103328
	.float 0.528279
	.float -0.955598
	.float 1.142560
	.float -1.003133
	.float 0.658523
	.float -0.333863
	.float 0.187624
	.float -0.208013
	.float 0.252117
	.float -0.187759
	.float 0.018055
	.float 0.113998
	.float -0.045032
	.float -0.262332
	.float 0.666480
	.float -0.934329
	.float 0.905803
	.float -0.610367
	.float 0.247816
	.float -0.048797
	.float 0.119207
	.float -0.378877
	.float 0.629591
	.float -0.692878
	.float 0.516026
	.float -0.181633
	.float -0.166989
	.float 0.416798
	.float -0.529781
	.float 0.528714
	.float -0.457740
	.float 0.356929
	.float -0.260136
	.float 0.196844
	.float -0.180871
	.float 0.194477
	.float -0.191312
	.float 0.126430
	.float 0.009433
	.float -0.184518
	.float 0.356953
	.float -0.511800
	.float 0.665309
	.float -0.829253
	.float 0.970730
	.float -1.011592
	.float 0.876565
	.float -0.553291
	.float 0.115411
	.float 0.309924
	.float -0.604981
	.float 0.712347
	.float -0.647102
	.float 0.474246
	.float -0.271478
	.float 0.097522
	.float 0.023374
	.float -0.097491
	.float 0.143039
	.float -0.169847
	.float 0.172973
	.float -0.145486
	.float 0.097919
	.float -0.062854
	.float 0.075792
	.float -0.146914
	.float 0.251119
	.float -0.349260
	.float 0.424043
	.float -0.496633
	.float 0.604412
	.float -0.755972
	.float 0.904367
	.float -0.968012
	.float 0.887676
	.float -0.674468
	.float 0.409257
	.float -0.195313
	.float 0.104016
	.float -0.152529
	.float 0.316240
	.float -0.547950
	.float 0.781804
	.float -0.932419
	.float 0.916908
	.float -0.703367
	.float 0.349776
	.float 0.011644
	.float -0.248781
	.float 0.311200
	.float -0.254292
	.float 0.186843
	.float -0.186805
	.float 0.253003
	.float -0.324004
	.float 0.335932
	.float -0.265300
	.float 0.128297
	.float 0.045655
	.float -0.229161
	.float 0.386284
	.float -0.459123
	.float 0.384212
	.float -0.141487
	.float -0.202133
	.float 0.502668
	.float -0.612990
	.float 0.476541
	.float -0.171169
	.float -0.134955
	.float 0.288928
	.float -0.246111
	.float 0.084785
	.float 0.065127
	.float -0.123461
	.float 0.115921
	.float -0.144747
	.float 0.297793
	.float -0.565374
	.float 0.827897
	.float -0.926115
	.float 0.766141
	.float -0.386817
	.float -0.055102
	.float 0.369641
	.float -0.431164
	.float 0.232878
	.float 0.121765
	.float -0.471573
	.float 0.662335
	.float -0.602359
	.float 0.300264
	.float 0.126161
	.float -0.484892
	.float 0.591247
	.float -0.366276
	.float -0.103927
	.float 0.594905
	.float -0.854295
	.float 0.737141
	.float -0.285895
	.float -0.293933
	.float 0.747177
	.float -0.903440
	.float 0.755140
	.float -0.440406
	.float 0.147989
	.float -0.004925
	.float 0.012593
	.float -0.066267
	.float 0.042819
	.float 0.102181
	.float -0.295021
	.float 0.395312
	.float -0.307608
	.float 0.072871
	.float 0.137436
	.float -0.135194
	.float -0.137263
	.float 0.539331
	.float -0.807871
	.float 0.735022
	.float -0.323116
	.float -0.198750
	.float 0.514366
	.float -0.419763
	.float -0.054875
	.float 0.677455
	.float -1.164570
	.float 1.337372
	.float -1.182510
	.float 0.800611
	.float -0.309319
	.float -0.212939
	.float 0.708618
	.float -1.090297
	.float 1.231303
	.float -1.031481
	.float 0.515216
	.float 0.127095
	.float -0.610889
	.float 0.712606
	.float -0.405117
	.float -0.123941
	.float 0.586592
	.float -0.763751
	.float 0.617103
	.float -0.279366
	.float -0.053211
	.float 0.242394
	.float -0.265928
	.float 0.191045
	.float -0.104078
	.float 0.055788
	.float -0.054787
	.float 0.093017
	.float -0.164515
	.float 0.255553
	.float -0.324940
	.float 0.311739
	.float -0.181772
	.float -0.023650
	.float 0.192314
	.float -0.214894
	.float 0.075893
	.float 0.119957
	.float -0.221667
	.float 0.154152
	.float 0.013099
	.float -0.113398
	.float 0.012146
	.float 0.285660
	.float -0.633919
	.float 0.844721
	.float -0.806518
	.float 0.536902
	.float -0.151393
	.float -0.205333
	.float 0.410783
	.float -0.385917
	.float 0.111678
	.float 0.343246
	.float -0.809412
	.float 1.064018
	.float -0.945935
	.float 0.474813
	.float 0.123033
	.float -0.530264
	.float 0.538291
	.float -0.194067
	.float -0.223202
	.float 0.395890
	.float -0.202800
	.float -0.177666
	.float 0.383503
	.float -0.133862
	.float -0.544028
	.float 1.298402
	.float -1.675196
	.float 1.430798
	.float -0.710305
	.float -0.048000
	.float 0.421948
	.float -0.304216
	.float -0.034835
	.float 0.169492
	.float 0.143535
	.float -0.772204
	.float 1.306676
	.float -1.365743
	.float 0.874580
	.float -0.109973
	.float -0.502307
	.float 0.671526
	.float -0.403240
	.float -0.052302
	.float 0.392620
	.float -0.444009
	.float 0.220309
	.float 0.142083
	.float -0.491017
	.float 0.721807
	.float -0.774233
	.float 0.604865
	.float -0.190757
	.float -0.423951
	.float 1.084718
	.float -1.549912
	.float 1.598965
	.float -1.169861
	.float 0.428004
	.float 0.300208
	.float -0.705453
	.float 0.676930
	.float -0.364335
	.float 0.072382
	.float -0.054233
	.float 0.343892
	.float -0.742083
	.float 0.962280
	.float -0.830692
	.float 0.399979
	.float 0.095297
	.float -0.397827
	.float 0.382487
	.float -0.105316
	.float -0.267654
	.float 0.580470
	.float -0.764177
	.float 0.829020
	.float -0.803144
	.float 0.686140
	.float -0.460298
	.float 0.143475
	.float 0.175111
	.float -0.363608
	.float 0.333356
	.float -0.118810
	.float -0.119059
	.float 0.186723
	.float 0.004847
	.float -0.358199
	.float 0.634426
	.float -0.611884
	.float 0.255330
	.float 0.230192
	.float -0.516468
	.float 0.372302
	.float 0.165539
	.float -0.798098
	.float 1.150500
	.float -1.010886
	.float 0.457347
	.float 0.206975
	.float -0.651983
	.float 0.709930
	.float -0.440203
	.float 0.054681
	.float 0.221769
	.float -0.262717
	.float 0.075949
	.float 0.227598
	.float -0.496650
	.float 0.605119
	.float -0.502570
	.float 0.234922
	.float 0.077401
	.float -0.301042
	.float 0.360804
	.float -0.275997
	.float 0.136245
	.float -0.033460
	.float 0.000831
	.float -0.003559
	.float -0.017187
	.float 0.089401
	.float -0.192263
	.float 0.285856
	.float -0.352279
	.float 0.402214
	.float -0.439264
	.float 0.422619
	.float -0.280038
	.float -0.024054
	.float 0.420938
	.float -0.741883
	.float 0.812252
	.float -0.573240
	.float 0.135162
	.float 0.285994
	.float -0.504781
	.float 0.473617
	.float -0.285903
	.float 0.084937
	.float 0.040187
	.float -0.092760
	.float 0.127845
	.float -0.186453
	.float 0.267027
	.float -0.347967
	.float 0.421438
	.float -0.493616
	.float 0.550347
	.float -0.532607
	.float 0.363113
	.float -0.015525
	.float -0.431247
	.float 0.810291
	.float -0.958519
	.float 0.823030
	.float -0.503893
	.float 0.195714
	.float -0.062607
	.float 0.131418
	.float -0.279988
	.float 0.333118
	.float -0.198591
	.float -0.059496
	.float 0.271368
	.float -0.300950
	.float 0.163668
	.float -0.021855
	.float 0.054722
	.float -0.306711
	.float 0.641430
	.float -0.843777
	.float 0.788677
	.float -0.537238
	.float 0.281844
	.float -0.188420
	.float 0.270020
	.float -0.397368
	.float 0.433551
	.float -0.370869
	.float 0.343839
	.float -0.499077
	.float 0.832847
	.float -1.145689
	.float 1.171023
	.float -0.784036
	.float 0.118457
	.float 0.513120
	.float -0.838775
	.float 0.811480
	.float -0.611190
	.float 0.468458
	.float -0.460336
	.float 0.447324
	.float -0.202005
	.float -0.377819
	.float 1.144089
	.float -1.763934
	.float 1.930178
	.float -1.563941
	.float 0.864810
	.float -0.177358
	.float -0.227781
	.float 0.307608
	.float -0.238726
	.float 0.267444
	.float -0.529251
	.float 0.957359
	.float -1.329995
	.float 1.414191
	.float -1.110710
	.float 0.515052
	.float 0.133771
	.float -0.582050
	.float 0.694053
	.float -0.516679
	.float 0.241617
	.float -0.087722
	.float 0.172828
	.float -0.451845
	.float 0.756380
	.float -0.904304
	.float 0.803701
	.float -0.484991
	.float 0.053737
	.float 0.385762
	.float -0.773405
	.float 1.079159
	.float -1.263176
	.float 1.262932
	.float -1.031341
	.float 0.597945
	.float -0.094381
	.float -0.294062
	.float 0.431760
	.float -0.320463
	.float 0.101529
	.float 0.039359
	.float -0.000894
	.float -0.167741
	.float 0.316001
	.float -0.318627
	.float 0.177891
	.float -0.017777
	.float -0.024491
	.float -0.081895
	.float 0.231452
	.float -0.267745
	.float 0.113506
	.float 0.160862
	.float -0.384051
	.float 0.406080
	.float -0.200913
	.float -0.122441
	.float 0.396465
	.float -0.494883
	.float 0.390412
	.float -0.150039
	.float -0.108513
	.float 0.267614
	.float -0.253566
	.float 0.069419
	.float 0.195367
	.float -0.396703
	.float 0.408205
	.float -0.196616
	.float -0.151561
	.float 0.474893
	.float -0.623231
	.float 0.528056
	.float -0.220650
	.float -0.194234
	.float 0.578348
	.float -0.796041
	.float 0.750074
	.float -0.419859
	.float -0.116599
	.float 0.704458
	.float -1.179225
	.float 1.441742
	.float -1.490619
	.float 1.392925
	.float -1.222916
	.float 1.019192
	.float -0.787225
	.float 0.531602
	.float -0.278705
	.float 0.066886
	.float 0.083316
	.float -0.185218
	.float 0.266576
	.float -0.329011
	.float 0.326817
	.float -0.196453
	.float -0.075845
	.float 0.404953
	.float -0.632494
	.float 0.628411
	.float -0.398605
	.float 0.105763
	.float 0.031249
	.float 0.105905
	.float -0.443369
	.float 0.766428
	.float -0.877152
	.float 0.733288
	.float -0.459177
	.float 0.228565
	.float -0.124671
	.float 0.095184
	.float -0.030109
	.float -0.118045
	.float 0.283304
	.float -0.349186
	.float 0.266211
	.float -0.117270
	.float 0.067907
	.float -0.236165
	.float 0.585132
	.float -0.928830
	.float 1.056353
	.float -0.887083
	.float 0.538389
	.float -0.247220
	.float 0.195892
	.float -0.370863
	.float 0.565985
	.float -0.535325
	.float 0.183629
	.float 0.350387
	.float -0.781321
	.float 0.867895
	.float -0.564128
	.float 0.028345
	.float 0.496841
	.float -0.827044
	.float 0.898897
	.float -0.736742
	.float 0.389792
	.float 0.086299
	.float -0.595757
	.float 0.978103
	.float -1.054272
	.float 0.736772
	.float -0.122169
	.float -0.522238
	.float 0.893255
	.float -0.828386
	.float 0.404923
	.float 0.109214
	.float -0.422398
	.float 0.394933
	.float -0.112581
	.float -0.182362
	.float 0.251198
	.float -0.006791
	.float -0.437408
	.float 0.838832
	.float -0.968423
	.float 0.740050
	.float -0.256251
	.float -0.250476
	.float 0.545318
	.float -0.515609
	.float 0.223771
	.float 0.138273
	.float -0.362070
	.float 0.333166
	.float -0.077014
	.float -0.276110
	.float 0.571997
	.float -0.706240
	.float 0.657295
	.float -0.479146
	.float 0.270549
	.float -0.134994
	.float 0.136881
	.float -0.265669
	.float 0.429256
	.float -0.494376
	.float 0.363572
	.float -0.045838
	.float -0.330391
	.float 0.580872
	.float -0.571645
	.float 0.299931
	.float 0.104742
	.float -0.459082
	.float 0.630345
	.float -0.598156
	.float 0.441226
	.float -0.270043
	.float 0.158399
	.float -0.115992
	.float 0.107415
	.float -0.091169
	.float 0.048199
	.float 0.013640
	.float -0.070978
	.float 0.097820
	.float -0.071769
	.float -0.022715
	.float 0.186954
	.float -0.397422
	.float 0.603020
	.float -0.741916
	.float 0.774359
	.float -0.709110
	.float 0.598714
	.float -0.500018
	.float 0.426255
	.float -0.329825
	.float 0.134705
	.float 0.199713
	.float -0.628038
	.float 1.020664
	.float -1.224087
	.float 1.147430
	.float -0.823429
	.float 0.403073
	.float -0.080864
	.float -0.008198
	.float -0.143317
	.float 0.425733
	.float -0.691844
	.float 0.847595
	.float -0.890341
	.float 0.876028
	.float -0.852870
	.float 0.820821
	.float -0.744500
	.float 0.596818
	.float -0.388567
	.float 0.159996
	.float 0.049405
	.float -0.220061
	.float 0.344763
	.float -0.408315
	.float 0.380236
	.float -0.232482
	.float -0.028735
	.float 0.341016
	.float -0.593909
	.float 0.672257
	.float -0.519233
	.float 0.185282
	.float 0.174960
	.float -0.371453
	.float 0.282805
	.float 0.069618
	.float -0.532058
	.float 0.910942
	.float -1.084286
	.float 1.054526
	.float -0.914506
	.float 0.764809
	.float -0.651372
	.float 0.561109
	.float -0.458575
	.float 0.319426
	.float -0.136333
	.float -0.088964
	.float 0.341910
	.float -0.577373
	.float 0.714806
	.float -0.670334
	.float 0.415176
	.float -0.017145
	.float -0.373700
	.float 0.595021
	.float -0.556245
	.float 0.284923
	.float 0.091559
	.float -0.416991
	.float 0.589286
	.float -0.609455
	.float 0.568390
	.float -0.577490
	.float 0.684584
	.float -0.832072
	.float 0.892019
	.float -0.761358
	.float 0.450420
	.float -0.094108
	.float -0.133310
	.float 0.143626
	.float -0.003302
	.float -0.116445
	.float 0.079036
	.float 0.095009
	.float -0.225556
	.float 0.104186
	.float 0.335932
	.float -0.944323
	.float 1.435829
	.float -1.573616
	.float 1.315969
	.float -0.820282
	.float 0.309811
	.float 0.085951
	.float -0.390856
	.float 0.700756
	.float -1.038497
	.float 1.279020
	.float -1.223602
	.float 0.776356
	.float -0.077042
	.float -0.538654
	.float 0.749460
	.float -0.481107
	.float -0.024851
	.float 0.377229
	.float -0.321897
	.float -0.070618
	.float 0.468130
	.float -0.546084
	.float 0.251563
	.float 0.150573
	.float -0.291994
	.float 0.009871
	.float 0.493366
	.float -0.772108
	.float 0.458333
	.float 0.452390
	.float -1.558377
	.float 2.286034
	.float -2.242105
	.float 1.451461
	.float -0.332909
	.float -0.561327
	.float 0.871421
	.float -0.618608
	.float 0.148615
	.float 0.122483
	.float 0.011787
	.float -0.427691
	.float 0.784689
	.float -0.785130
	.float 0.390435
	.float 0.159070
	.float -0.524258
	.float 0.503643
	.float -0.151680
	.float -0.292703
	.float 0.591033
	.float -0.654633
	.float 0.558361
	.float -0.436341
	.float 0.362374
	.float -0.310168
	.float 0.207364
	.float -0.019803
	.float -0.212294
	.float 0.411832
	.float -0.533364
	.float 0.595674
	.float -0.648788
	.float 0.709802
	.float -0.732894
	.float 0.649209
	.float -0.445604
	.float 0.208743
	.float -0.083914
	.float 0.169954
	.float -0.431366
	.float 0.701140
	.float -0.779345
	.float 0.558456
	.float -0.090103
	.float -0.444036
	.float 0.826889
	.float -0.904912
	.float 0.646011
	.float -0.145802
	.float -0.409561
	.float 0.813030
	.float -0.921874
	.float 0.724448
	.float -0.347159
	.float -0.013315
	.float 0.197428
	.float -0.162849
	.float -0.012244
	.float 0.196020
	.float -0.285638
	.float 0.249923
	.float -0.116715
	.float -0.066561
	.float 0.260077
	.float -0.431327
	.float 0.543843
	.float -0.560152
	.float 0.466241
	.float -0.297666
	.float 0.139039
	.float -0.087418
	.float 0.199606
	.float -0.458566
	.float 0.780674
	.float -1.055533
	.float 1.190873
	.float -1.138643
	.float 0.899702
	.float -0.517651
	.float 0.069137
	.float 0.352983
	.float -0.668430
	.float 0.840969
	.float -0.891044
	.float 0.873888
	.float -0.833384
	.float 0.764466
	.float -0.617771
	.float 0.350673
	.float 0.008216
	.float -0.333684
	.float 0.451213
	.float -0.242668
	.float -0.253461
	.float 0.822755
	.float -1.170260
	.float 1.086586
	.float -0.581859
	.float -0.107892
	.float 0.657161
	.float -0.844397
	.float 0.672537
	.float -0.335994
	.float 0.065152
	.float 0.033190
	.float -0.023674
	.float 0.054422
	.float -0.213868
	.float 0.448960
	.float -0.605795
	.float 0.553738
	.float -0.291917
	.float -0.042652
	.float 0.266962
	.float -0.271807
	.float 0.083372
	.float 0.169482
	.float -0.348932
	.float 0.393049
	.float -0.337300
	.float 0.269410
	.float -0.258501
	.float 0.309325
	.float -0.366943
	.float 0.359284
	.float -0.242448
	.float 0.018824
	.float 0.277168
	.float -0.605867
	.float 0.934520
	.float -1.222740
	.float 1.397285
	.float -1.349994
	.float 0.984619
	.float -0.298953
	.float -0.553041
	.float 1.284180
	.float -1.599424
	.float 1.361538
	.float -0.684813
	.float -0.122807
	.float 0.742828
	.float -1.030059
	.float 1.065610
	.float -1.048001
	.float 1.117333
	.float -1.253913
	.float 1.321489
	.float -1.202583
	.float 0.904557
	.float -0.554021
	.float 0.298279
	.float -0.204028
	.float 0.231439
	.float -0.289297
	.float 0.313292
	.float -0.304583
	.float 0.309149
	.float -0.366714
	.float 0.472482
	.float -0.575323
	.float 0.607393
	.float -0.524661
	.float 0.337756
	.float -0.117629
	.float -0.032663
	.float 0.034861
	.float 0.107965
	.float -0.298270
	.float 0.398408
	.float -0.326630
	.float 0.124176
	.float 0.067980
	.float -0.115786
	.float 0.001689
	.float 0.154811
	.float -0.187645
	.float 0.014490
	.float 0.299248
	.float -0.593316
	.float 0.735720
	.float -0.714117
	.float 0.625842
	.float -0.582500
	.float 0.611804
	.float -0.634932
	.float 0.532455
	.float -0.243910
	.float -0.174408
	.float 0.571874
	.float -0.785833
	.float 0.727246
	.float -0.420783
	.float -0.014042
	.float 0.420020
	.float -0.666531
	.float 0.697042
	.float -0.548207
	.float 0.333932
	.float -0.195274
	.float 0.230831
	.float -0.440543
	.float 0.718096
	.float -0.903344
	.float 0.867993
	.float -0.584258
	.float 0.136356
	.float 0.326960
	.float -0.665807
	.float 0.805651
	.float -0.752553
	.float 0.569454
	.float -0.333479
	.float 0.098050
	.float 0.122222
	.float -0.338051
	.float 0.552731
	.float -0.733279
	.float 0.809087
	.float -0.705709
	.float 0.395848
	.float 0.064281
	.float -0.538124
	.float 0.853243
	.float -0.867823
	.float 0.532091
	.float 0.078738
	.float -0.774275
	.float 1.305520
	.float -1.454832
	.float 1.127094
	.float -0.399946
	.float -0.496123
	.float 1.264434
	.float -1.658866
	.float 1.580587
	.float -1.114984
	.float 0.494031
	.float 0.003444
	.float -0.177831
	.float 0.006851
	.float 0.338796
	.float -0.585674
	.float 0.516700
	.float -0.108424
	.float -0.446182
	.float 0.854816
	.float -0.910670
	.float 0.619696
	.float -0.181978
	.float -0.154048
	.float 0.252819
	.float -0.151385
	.float -0.013002
	.float 0.132071
	.float -0.200316
	.float 0.279673
	.float -0.402068
	.float 0.510167
	.float -0.498701
	.float 0.322689
	.float -0.071810
	.float -0.068184
	.float -0.048088
	.float 0.396644
	.float -0.772666
	.float 0.918786
	.float -0.702929
	.float 0.212494
	.float 0.304723
	.float -0.603891
	.float 0.587191
	.float -0.332134
	.float 0.006101
	.float 0.248639
	.float -0.373539
	.float 0.376222
	.float -0.280517
	.float 0.098733
	.float 0.157873
	.float -0.454390
	.float 0.723312
	.float -0.880386
	.float 0.854444
	.float -0.617914
	.float 0.209848
	.float 0.258217
	.float -0.628286
	.float 0.759963
	.float -0.609479
	.float 0.272079
	.float 0.057558
	.float -0.199261
	.float 0.104271
	.float 0.114767
	.float -0.273015
	.float 0.259308
	.float -0.121754
	.float 0.018088
	.float -0.067536
	.float 0.229556
	.float -0.319429
	.float 0.157687
	.float 0.265173
	.float -0.747171
	.float 0.999292
	.float -0.846981
	.float 0.358899
	.float 0.190773
	.float -0.495506
	.float 0.400271
	.float 0.026059
	.float -0.562862
	.float 0.984085
	.float -1.168999
	.float 1.112985
	.float -0.863329
	.float 0.461871
	.float 0.046926
	.float -0.563392
	.float 0.915502
	.float -0.934007
	.float 0.582288
	.float -0.029095
	.float -0.423471
	.float 0.528747
	.float -0.265204
	.float -0.146446
	.float 0.394742
	.float -0.282135
	.float -0.166060
	.float 0.749549
	.float -1.234421
	.float 1.470784
	.float -1.418727
	.float 1.105879
	.float -0.586276
	.float -0.059178
	.float 0.702309
	.float -1.176424
	.float 1.334272
	.float -1.122167
	.float 0.615711
	.float 0.009702
	.float -0.553062
	.float 0.860962
	.float -0.868053
	.float 0.602842
	.float -0.171430
	.float -0.274204
	.float 0.583257
	.float -0.660537
	.float 0.504173
	.float -0.202790
	.float -0.108356
	.float 0.306011
	.float -0.319944
	.float 0.144191
	.float 0.171541
	.float -0.536443
	.float 0.838027
	.float -0.974563
	.float 0.898298
	.float -0.648025
	.float 0.342966
	.float -0.130404
	.float 0.112350
	.float -0.294504
	.float 0.588717
	.float -0.863370
	.float 1.006823
	.float -0.966715
	.float 0.754142
	.float -0.427843
	.float 0.077394
	.float 0.193694
	.float -0.298384
	.float 0.211000
	.float 0.000981
	.float -0.195765
	.float 0.232756
	.float -0.060441
	.float -0.249283
	.float 0.549122
	.float -0.710097
	.float 0.688953
	.float -0.525284
	.float 0.288314
	.float -0.030597
	.float -0.213777
	.float 0.400992
	.float -0.464756
	.float 0.345410
	.float -0.042501
	.float -0.355737
	.float 0.699266
	.float -0.850647
	.float 0.761131
	.float -0.497515
	.float 0.199489
	.float 0.005545
	.float -0.072498
	.float 0.046354
	.float -0.007764
	.float 0.004523
	.float -0.024126
	.float 0.022645
	.float 0.025595
	.float -0.106906
	.float 0.190313
	.float -0.263126
	.float 0.338984
	.float -0.429959
	.float 0.512578
	.float -0.524384
	.float 0.399192
	.float -0.115153
	.float -0.277113
	.float 0.661914
	.float -0.896212
	.float 0.865319
	.float -0.541688
	.float 0.023717
	.float 0.478949
	.float -0.733478
	.float 0.617592
	.float -0.216988
	.float -0.198811
	.float 0.336704
	.float -0.082884
	.float -0.398510
	.float 0.760219
	.float -0.708416
	.float 0.214388
	.float 0.457052
	.float -0.927966
	.float 0.966351
	.float -0.636089
	.float 0.235866
	.float -0.082832
	.float 0.303713
	.float -0.774224
	.float 1.226463
	.float -1.426572
	.float 1.296638
	.float -0.920801
	.float 0.465081
	.float -0.082990
	.float -0.141925
	.float 0.207727
	.float -0.173516
	.float 0.120185
	.float -0.103710
	.float 0.121723
	.float -0.117640
	.float 0.027134
	.float 0.162961
	.float -0.389729
	.float 0.546812
	.float -0.553071
	.float 0.407168
	.float -0.189672
	.float 0.013745
	.float 0.040862
	.float 0.029325
	.float -0.150972
	.float 0.211406
	.float -0.115353
	.float -0.161093
	.float 0.543211
	.float -0.877927
	.float 1.005944
	.float -0.857022
	.float 0.510280
	.float -0.167011
	.float 0.035551
	.float -0.195990
	.float 0.539685
	.float -0.834463
	.float 0.876386
	.float -0.623633
	.float 0.219677
	.float 0.106625
	.float -0.190804
	.float 0.030223
	.float 0.228482
	.float -0.392537
	.float 0.343147
	.float -0.098699
	.float -0.207312
	.float 0.407725
	.float -0.389580
	.float 0.143648
	.float 0.237903
	.float -0.603715
	.float 0.803362
	.float -0.746655
	.float 0.445073
	.float -0.016599
	.float -0.358184
	.float 0.518855
	.float -0.408122
	.float 0.104569
	.float 0.221073
	.float -0.404828
	.float 0.382209
	.float -0.215494
	.float 0.040728
	.float 0.025753
	.float 0.043580
	.float -0.184040
	.float 0.292584
	.float -0.293940
	.float 0.176879
	.float 0.010221
	.float -0.186771
	.float 0.269245
	.float -0.195552
	.float -0.052146
	.float 0.429819
	.float -0.832838
	.float 1.127571
	.float -1.205635
	.float 1.033749
	.float -0.670242
	.float 0.235918
	.float 0.147949
	.float -0.422514
	.float 0.618832
	.float -0.827253
	.float 1.119515
	.float -1.470849
	.float 1.742629
	.float -1.754814
	.float 1.411842
	.float -0.794915
	.float 0.143489
	.float 0.276717
	.float -0.335425
	.float 0.117022
	.float 0.139795
	.float -0.199261
	.float -0.027505
	.float 0.447383
	.float -0.871224
	.float 1.147093
	.float -1.241413
	.float 1.218448
	.float -1.152309
	.float 1.054770
	.float -0.882165
	.float 0.609175
	.float -0.294322
	.float 0.064346
	.float -0.017876
	.float 0.130201
	.float -0.253702
	.float 0.232350
	.float -0.042647
	.float -0.164360
	.float 0.172812
	.float 0.113497
	.float -0.563529
	.float 0.887986
	.float -0.844724
	.float 0.425793
	.float 0.122053
	.float -0.465725
	.float 0.420416
	.float -0.076630
	.float -0.273854
	.float 0.355138
	.float -0.103835
	.float -0.299641
	.float 0.582616
	.float -0.592446
	.float 0.404250
	.float -0.242791
	.float 0.283353
	.float -0.491667
	.float 0.633961
	.float -0.457827
	.float -0.089451
	.float 0.774242
	.float -1.200366
	.float 1.069291
	.float -0.396519
	.float -0.474252
	.float 1.079964
	.float -1.132748
	.float 0.698956
	.float -0.140765
	.float -0.136648
	.float -0.044143
	.float 0.526854
	.float -0.943745
	.float 0.973093
	.float -0.554454
	.float -0.077018
	.float 0.550433
	.float -0.600308
	.float 0.232284
	.float 0.286622
	.float -0.596833
	.float 0.461314
	.float 0.104823
	.float -0.857695
	.float 1.469806
	.float -1.699305
	.float 1.487746
	.float -0.950701
	.float 0.291698
	.float 0.298118
	.float -0.706925
	.float 0.922109
	.float -1.011777
	.float 1.079269
	.float -1.201099
	.float 1.369797
	.float -1.478920
	.float 1.379242
	.float -0.988878
	.float 0.384349
	.float 0.210164
	.float -0.553631
	.float 0.556364
	.float -0.352247
	.float 0.201138
	.float -0.282301
	.float 0.541253
	.float -0.724430
	.float 0.587614
	.float -0.115064
	.float -0.435169
	.float 0.710562
	.float -0.535417
	.float 0.061283
	.float 0.327318
	.float -0.285667
	.float -0.242059
	.float 0.979743
	.float -1.507151
	.float 1.536557
	.float -1.082441
	.float 0.419775
	.float 0.116233
	.float -0.332790
	.float 0.249621
	.float -0.017873
	.float -0.217449
	.float 0.395034
	.float -0.513225
	.float 0.560853
	.float -0.490993
	.float 0.268958
	.float 0.059664
	.float -0.363543
	.float 0.508548
	.float -0.466443
	.float 0.350530
	.float -0.333953
	.float 0.505845
	.float -0.780087
	.float 0.938424
	.float -0.786355
	.float 0.308738
	.float 0.295395
	.float -0.732972
	.float 0.810723
	.float -0.563586
	.float 0.224435
	.float -0.056700
	.float 0.170977
	.float -0.455335
	.float 0.663509
	.float -0.590571
	.float 0.207668
	.float 0.333061
	.float -0.811623
	.float 1.076653
	.float -1.107238
	.float 0.974321
	.float -0.756997
	.float 0.493130
	.float -0.195368
	.float -0.103808
	.float 0.336996
	.float -0.436278
	.float 0.379974
	.float -0.202292
	.float -0.042192
	.float 0.315942
	.float -0.593644
	.float 0.821831
	.float -0.899547
	.float 0.728218
	.float -0.309623
	.float -0.192168
	.float 0.502260
	.float -0.392552
	.float -0.155287
	.float 0.904304
	.float -1.481552
	.float 1.592739
	.float -1.192411
	.float 0.499992
	.float 0.143355
	.float -0.478651
	.float 0.464241
	.float -0.266654
	.float 0.127413
	.float -0.199400
	.float 0.453812
	.float -0.707188
	.float 0.743111
	.float -0.450799
	.float -0.101697
	.float 0.700067
	.float -1.100160
	.float 1.159006
	.float -0.904343
	.float 0.505410
	.float -0.169078
	.float 0.027391
	.float -0.080740
	.float 0.218669
	.float -0.291601
	.float 0.188109
	.float 0.113998
	.float -0.531385
	.float 0.895044
	.float -1.010906
	.float 0.755871
	.float -0.171463
	.float -0.510834
	.float 0.958766
	.float -0.916888
	.float 0.368753
	.float 0.431989
	.float -1.099102
	.float 1.339032
	.float -1.116841
	.float 0.654243
	.float -0.268389
	.float 0.167992
	.float -0.343642
	.float 0.612609
	.float -0.767119
	.float 0.711080
	.float -0.494627
	.float 0.241329
	.float -0.040825
	.float -0.106317
	.float 0.258524
	.float -0.458256
	.float 0.684336
	.float -0.872875
	.float 0.983230
	.float -1.042392
	.float 1.119494
	.float -1.246316
	.float 1.355562
	.float -1.304897
	.float 0.985495
	.float -0.434445
	.float -0.148697
	.float 0.513830
	.float -0.527293
	.float 0.266139
	.float 0.038220
	.float -0.167270
	.float 0.064875
	.float 0.142671
	.float -0.261429
	.float 0.181436
	.float 0.050384
	.float -0.276101
	.float 0.338116
	.float -0.167137
	.float -0.200865
	.float 0.661169
	.float -1.082232
	.float 1.328657
	.float -1.281357
	.float 0.880392
	.float -0.182764
	.float -0.613944
	.float 1.230117
	.float -1.437793
	.float 1.193433
	.float -0.673756
	.float 0.176308
	.float 0.057516
	.float 0.020609
	.float -0.259516
	.float 0.429167
	.float -0.377432
	.float 0.116089
	.float 0.210618
	.float -0.435148
	.float 0.468524
	.float -0.330519
	.float 0.107392
	.float 0.112610
	.float -0.273500
	.float 0.344930
	.float -0.307358
	.float 0.163577
	.float 0.027164
	.float -0.138512
	.float 0.030259
	.float 0.349090
	.float -0.884383
	.float 1.317382
	.float -1.380911
	.float 0.966149
	.float -0.209595
	.float -0.563696
	.float 1.009017
	.float -0.940651
	.float 0.420112
	.float 0.283957
	.float -0.829208
	.float 0.952540
	.float -0.574634
	.float -0.179266
	.float 1.040204
	.float -1.708160
	.float 1.970176
	.float -1.778017
	.float 1.254962
	.float -0.630995
	.float 0.137554
	.float 0.087612
	.float -0.041015
	.float -0.175636
	.float 0.428720
	.float -0.621434
	.float 0.718168
	.float -0.722537
	.float 0.641281
	.float -0.472154
	.float 0.224625
	.float 0.052257
	.float -0.270635
	.float 0.344056
	.float -0.241634
	.float 0.014677
	.float 0.227588
	.float -0.379649
	.float 0.398349
	.float -0.320728
	.float 0.232112
	.float -0.207326
	.float 0.262819
	.float -0.347052
	.float 0.371942
	.float -0.266061
	.float 0.020672
	.float 0.295046
	.float -0.558433
	.float 0.647552
	.float -0.499944
	.float 0.147025
	.float 0.293560
	.float -0.664445
	.float 0.832528
	.float -0.742971
	.float 0.441139
	.float -0.052874
	.float -0.270326
	.float 0.417588
	.float -0.362118
	.float 0.156908
	.float 0.111821
	.float -0.377011
	.float 0.608278
	.float -0.786283
	.float 0.867862
	.float -0.787285
	.float 0.505306
	.float -0.067124
	.float -0.388895
	.float 0.697278
	.float -0.769274
	.float 0.658958
	.float -0.533149
	.float 0.553902
	.float -0.750419
	.float 0.976771
	.float -0.999593
	.float 0.667488
	.float -0.044633
	.float -0.596055
	.float 0.929614
	.float -0.782215
	.float 0.236367
	.float 0.436260
	.float -0.958593
	.float 1.206252
	.float -1.226940
	.float 1.128903
	.float -0.953172
	.float 0.648651
	.float -0.167721
	.float -0.414604
	.float 0.882150
	.float -0.998403
	.float 0.681445
	.float -0.091351
	.float -0.451130
	.float 0.666445
	.float -0.495586
	.float 0.127042
	.float 0.147081
	.float -0.139684
	.float -0.107713
	.float 0.371077
	.float -0.417754
	.float 0.175854
	.float 0.221861
	.float -0.539912
	.float 0.599190
	.float -0.373351
	.float -0.032495
	.float 0.475859
	.float -0.852983
	.float 1.104836
	.float -1.180814
	.float 1.027919
	.float -0.636548
	.float 0.102792
	.float 0.368457
	.float -0.554877
	.float 0.355975
	.float 0.118584
	.float -0.586738
	.float 0.748539
	.float -0.465072
	.float -0.151256
	.float 0.793988
	.float -1.134033
	.float 1.002272
	.float -0.478073
	.float -0.160768
	.float 0.588804
	.float -0.596279
	.float 0.183212
	.float 0.450957
	.float -1.004832
	.float 1.210884
	.float -0.952549
	.float 0.315357
	.float 0.452516
	.float -1.055611
	.float 1.286752
	.float -1.109673
	.float 0.644315
	.float -0.073289
	.float -0.460909
	.float 0.899154
	.float -1.234251
	.float 1.451494
	.float -1.505015
	.float 1.354489
	.float -1.027007
	.float 0.641242
	.float -0.358974
	.float 0.289830
	.float -0.416684
	.float 0.599050
	.float -0.656365
	.float 0.476845
	.float -0.081566
	.float -0.392227
	.float 0.769807
	.float -0.927447
	.float 0.843082
	.float -0.593098
	.float 0.307194
	.float -0.104090
	.float 0.031768
	.float -0.038486
	.float -0.001568
	.float 0.206778
	.float -0.590434
	.float 1.016191
	.float -1.254420
	.float 1.117834
	.float -0.586926
	.float -0.165898
	.float 0.871927
	.float -1.308885
	.float 1.389873
	.float -1.153656
	.float 0.696553
	.float -0.122324
	.float -0.456530
	.float 0.901079
	.float -1.069672
	.float 0.892469
	.float -0.439068
	.float -0.093400
	.float 0.484761
	.float -0.620796
	.float 0.550239
	.float -0.427319
	.float 0.387139
	.float -0.451449
	.float 0.531462
	.float -0.513785
	.float 0.354098
	.float -0.107672
	.float -0.117388
	.float 0.239288
	.float -0.254736
	.float 0.233182
	.float -0.265527
	.float 0.404301
	.float -0.631380
	.float 0.868160
	.float -1.018358
	.float 1.015997
	.float -0.851964
	.float 0.568739
	.float -0.234570
	.float -0.083537
	.float 0.337794
	.float -0.510295
	.float 0.618948
	.float -0.710997
	.float 0.835121
	.float -1.000886
	.float 1.154660
	.float -1.200789
	.float 1.063750
	.float -0.750670
	.float 0.365876
	.float -0.061895
	.float -0.042746
	.float -0.073418
	.float 0.326543
	.float -0.572736
	.float 0.677005
	.float -0.572283
	.float 0.286318
	.float 0.071119
	.float -0.356366
	.float 0.458000
	.float -0.349645
	.float 0.098170
	.float 0.181081
	.float -0.393473
	.float 0.510122
	.float -0.558388
	.float 0.573365
	.float -0.558897
	.float 0.494376
	.float -0.376475
	.float 0.247515
	.float -0.173721
	.float 0.187214
	.float -0.247000
	.float 0.263266
	.float -0.171503
	.float -0.006367
	.float 0.170048
	.float -0.214417
	.float 0.106123
	.float 0.100686
	.float -0.316249
	.float 0.481072
	.float -0.586011
	.float 0.639257
	.float -0.628334
	.float 0.527385
	.float -0.345863
	.float 0.162978
	.float -0.097848
	.float 0.226083
	.float -0.511270
	.float 0.815069
	.float -0.984350
	.float 0.947452
	.float -0.743955
	.float 0.470276
	.float -0.194319
	.float -0.085298
	.float 0.403669
	.float -0.756231
	.float 1.061628
	.float -1.203621
	.float 1.124626
	.float -0.892135
	.float 0.674569
	.float -0.634271
	.float 0.814002
	.float -1.102428
	.float 1.304873
	.float -1.268234
	.float 0.971838
	.float -0.527433
	.float 0.097975
	.float 0.203117
	.float -0.365283
	.float 0.458420
	.float -0.556844
	.float 0.666117
	.float -0.706475
	.float 0.568483
	.float -0.204833
	.float -0.308014
	.float 0.787842
	.float -1.038276
	.float 0.954796
	.float -0.577457
	.float 0.062516
	.float 0.399258
	.float -0.665291
	.float 0.685693
	.float -0.502874
	.float 0.219781
	.float 0.046511
	.float -0.211755
	.float 0.255284
	.float -0.219382
	.float 0.175098
	.float -0.175696
	.float 0.228768
	.float -0.302661
	.float 0.354470
	.float -0.351597
	.float 0.273580
	.float -0.107139
	.float -0.144423
	.float 0.437247
	.float -0.677261
	.float 0.754473
	.float -0.613532
	.float 0.309695
	.float 0.005367
	.float -0.175068
	.float 0.145865
	.float -0.006121
	.float -0.083194
	.float 0.017699
	.float 0.163357
	.float -0.304994
	.float 0.258277
	.float 0.004108
	.float -0.372743
	.float 0.693835
	.float -0.884058
	.float 0.968864
	.float -1.019162
	.float 1.056323
	.float -1.020721
	.float 0.835565
	.float -0.503661
	.float 0.140130
	.float 0.099707
	.float -0.140655
	.float 0.050701
	.float 0.014124
	.float 0.056816
	.float -0.228202
	.float 0.338993
	.float -0.233181
	.float -0.102821
	.float 0.509085
	.float -0.756190
	.float 0.706726
	.float -0.411171
	.float 0.069657
	.float 0.105718
	.float -0.023699
	.float -0.247204
	.float 0.544862
	.float -0.723801
	.float 0.732936
	.float -0.623836
	.float 0.502790
	.float -0.465376
	.float 0.546341
	.float -0.700258
	.float 0.817036
	.float -0.769804
	.float 0.481376
	.float 0.019475
	.float -0.587307
	.float 1.015380
	.float -1.140530
	.float 0.942529
	.float -0.571469
	.float 0.269903
	.float -0.224272
	.float 0.439682
	.float -0.733148
	.float 0.866395
	.float -0.732516
	.float 0.454638
	.float -0.305573
	.float 0.493545
	.float -0.974786
	.float 1.448928
	.float -1.558067
	.float 1.146631
	.float -0.382510
	.float -0.356953
	.float 0.748351
	.float -0.733958
	.float 0.525814
	.float -0.411141
	.float 0.519144
	.float -0.729336
	.float 0.782480
	.float -0.497491
	.float -0.076453
	.float 0.684381
	.float -1.039367
	.float 1.010933
	.float -0.693352
	.float 0.319998
	.float -0.102576
	.float 0.115163
	.float -0.288114
	.float 0.486380
	.float -0.596505
	.float 0.567562
	.float -0.405359
	.float 0.150924
	.float 0.136397
	.float -0.395267
	.float 0.583686
	.float -0.693597
	.float 0.739350
	.float -0.724451
	.float 0.620841
	.float -0.392981
	.float 0.055168
	.float 0.293252
	.float -0.504787
	.float 0.481349
	.float -0.257207
	.float -0.010159
	.float 0.147925
	.float -0.093710
	.float -0.064355
	.float 0.170781
	.float -0.142563
	.float 0.048015
	.float -0.053908
	.float 0.278683
	.float -0.669881
	.float 1.009300
	.float -1.052436
	.float 0.704791
	.float -0.106579
	.float -0.440126
	.float 0.657488
	.float -0.468115
	.float 0.043332
	.float 0.308744
	.float -0.340733
	.float 0.019216
	.float 0.462420
	.float -0.811516
	.float 0.814658
	.float -0.454757
	.float -0.094761
	.float 0.580852
	.float -0.813886
	.float 0.762183
	.float -0.550773
	.float 0.368905
	.float -0.341901
	.float 0.449109
	.float -0.546958
	.float 0.485354
	.float -0.231652
	.float -0.098220
	.float 0.331437
	.float -0.379363
	.float 0.307894
	.float -0.274088
	.float 0.381569
	.float -0.580017
	.float 0.699453
	.float -0.595495
	.float 0.286511
	.float 0.035471
	.float -0.139331
	.float -0.062941
	.float 0.427566
	.float -0.661372
	.float 0.526288
	.float -0.022227
	.float -0.587367
	.float 0.934565
	.float -0.786230
	.float 0.200288
	.float 0.507613
	.float -0.962757
	.float 0.961499
	.float -0.585176
	.float 0.134217
	.float 0.063417
	.float 0.154300
	.float -0.698965
	.float 1.291765
	.float -1.621897
	.float 1.511846
	.float -1.004433
	.float 0.332048
	.float 0.212129
	.float -0.431801
	.float 0.328764
	.float -0.090199
	.float -0.033166
	.float -0.112021
	.float 0.479632
	.float -0.847762
	.float 0.958781
	.float -0.690750
	.float 0.148758
	.float 0.389041
	.float -0.642440
	.float 0.506197
	.float -0.111678
	.float -0.272172
	.float 0.429265
	.float -0.339717
	.float 0.170842
	.float -0.126636
	.float 0.275953
	.float -0.493926
	.float 0.559586
	.float -0.329369
	.float -0.147710
	.float 0.654970
	.float -0.944409
	.float 0.880153
	.float -0.496150
	.float -0.050109
	.float 0.573222
	.float -0.935337
	.float 1.069887
	.float -0.971514
	.float 0.685821
	.float -0.309388
	.float -0.022542
	.float 0.184365
	.float -0.132262
	.float -0.052560
	.float 0.200655
	.float -0.165116
	.float -0.067951
	.float 0.359346
	.float -0.514253
	.float 0.428046
	.float -0.165469
	.float -0.092571
	.float 0.192655
	.float -0.125201
	.float 0.018909
	.float -0.020692
	.float 0.164118
	.float -0.337154
	.float 0.375503
	.float -0.202418
	.float -0.100837
	.float 0.351007
	.float -0.398232
	.float 0.232243
	.float 0.020661
	.float -0.199686
	.float 0.224063
	.float -0.131532
	.float 0.021301
	.float 0.039653
	.float -0.062635
	.float 0.099408
	.float -0.161725
	.float 0.180579
	.float -0.055187
	.float -0.241912
	.float 0.597903
	.float -0.807850
	.float 0.721446
	.float -0.378338
	.float 0.013102
	.float 0.094985
	.float 0.174493
	.float -0.680966
	.float 1.106046
	.float -1.164263
	.float 0.786692
	.float -0.149296
	.float -0.458372
	.float 0.812261
	.float -0.852500
	.float 0.658526
	.float -0.359167
	.float 0.066176
	.float 0.134304
	.float -0.169289
	.float -0.002930
	.float 0.344962
	.float -0.718546
	.float 0.938123
	.float -0.880928
	.float 0.573093
	.float -0.178710
	.float -0.104579
	.float 0.165255
	.float -0.026586
	.float -0.199876
	.float 0.405725
	.float -0.548591
	.float 0.649000
	.float -0.741558
	.float 0.828517
	.float -0.870237
	.float 0.812184
	.float -0.622882
	.float 0.316857
	.float 0.047396
	.float -0.387962
	.float 0.625517
	.float -0.706246
	.float 0.619359
	.float -0.406596
	.float 0.155238
	.float 0.033450
	.float -0.094740
	.float 0.041181
	.float 0.040704
	.float -0.047001
	.float -0.067560
	.float 0.251116
	.float -0.387377
	.float 0.377828
	.float -0.210914
	.float -0.033668
	.float 0.244066
	.float -0.348628
	.float 0.347433
	.float -0.289609
	.float 0.227168
	.float -0.186371
	.float 0.169712
	.float -0.170468
	.float 0.176063
	.float -0.160413
	.float 0.085685
	.float 0.072978
	.float -0.295699
	.float 0.513177
	.float -0.645105
	.float 0.656019
	.float -0.580479
	.float 0.490806
	.float -0.432865
	.float 0.386784
	.float -0.290554
	.float 0.106499
	.float 0.131249
	.float -0.336403
	.float 0.444445
	.float -0.473483
	.float 0.510393
	.float -0.625815
	.float 0.790799
	.float -0.876478
	.float 0.751346
	.float -0.402468
	.float -0.022817
	.float 0.301135
	.float -0.287827
	.float 0.027068
	.float 0.267904
	.float -0.354112
	.float 0.122393
	.float 0.324636
	.float -0.729684
	.float 0.835342
	.float -0.539757
	.float -0.040231
	.float 0.635665
	.float -0.980372
	.float 0.958733
	.float -0.656213
	.float 0.287452
	.float -0.059092
	.float 0.063495
	.float -0.265514
	.float 0.567264
	.float -0.881000
	.float 1.153212
	.float -1.343396
	.float 1.405699
	.float -1.307666
	.float 1.067532
	.float -0.760732
	.float 0.473450
	.float -0.240541
	.float 0.030201
	.float 0.201867
	.float -0.437342
	.float 0.578157
	.float -0.519150
	.float 0.256585
	.float 0.066240
	.float -0.232584
	.float 0.102126
	.float 0.275678
	.float -0.677148
	.float 0.844087
	.float -0.648970
	.float 0.172096
	.float 0.354053
	.float -0.683752
	.float 0.686271
	.float -0.395610
	.float -0.026021
	.float 0.375029
	.float -0.499369
	.float 0.363498
	.float -0.060344
	.float -0.241729
	.float 0.397997
	.float -0.376770
	.float 0.275954
	.float -0.249158
	.float 0.392394
	.float -0.676578
	.float 0.973618
	.float -1.148106
	.float 1.139326
	.float -0.979662
	.float 0.755197
	.float -0.553628
	.float 0.433676
	.float -0.413600
	.float 0.462819
	.float -0.498412
	.float 0.409189
	.float -0.117805
	.float -0.348572
	.float 0.835929
	.float -1.126102
	.float 1.061074
	.float -0.651522
	.float 0.090286
	.float 0.351060
	.float -0.483176
	.float 0.312675
	.float -0.028887
	.float -0.131021
	.float 0.046029
	.float 0.211927
	.float -0.442817
	.float 0.474622
	.float -0.292958
	.float 0.048197
	.float 0.059658
	.float 0.072695
	.float -0.382504
	.float 0.691463
	.float -0.828651
	.float 0.734110
	.float -0.477251
	.float 0.192725
	.float 0.009905
	.float -0.099526
	.float 0.113510
	.float -0.105994
	.float 0.101340
	.float -0.088677
	.float 0.054761
	.float -0.017493
	.float 0.020132
	.float -0.083275
	.float 0.157588
	.float -0.131163
	.float -0.095904
	.float 0.519555
	.float -0.998806
	.float 1.319951
	.float -1.321027
	.float 0.991524
	.float -0.479197
	.float 0.004008
	.float 0.260756
	.float -0.268300
	.float 0.102595
	.float 0.080286
	.float -0.133983
	.float -0.013116
	.float 0.331649
	.float -0.707256
	.float 0.988031
	.float -1.045972
	.float 0.832102
	.float -0.405648
	.float -0.078514
	.float 0.430049
	.float -0.513818
	.float 0.327819
	.float -0.014990
	.float -0.216660
	.float 0.229010
	.float -0.055896
	.float -0.109550
	.float 0.048260
	.float 0.318514
	.float -0.852748
	.float 1.276809
	.float -1.355407
	.float 1.053625
	.float -0.558078
	.float 0.147179
	.float -0.003194
	.float 0.097309
	.float -0.224584
	.float 0.161108
	.float 0.167591
	.float -0.624265
	.float 0.947330
	.float -0.929107
	.float 0.562915
	.float -0.058957
	.float -0.281303
	.float 0.247638
	.float 0.156767
	.float -0.723497
	.float 1.160985
	.float -1.251102
	.float 0.954766
	.float -0.421921
	.float -0.087952
	.float 0.331529
	.float -0.196000
	.float -0.250547
	.float 0.797332
	.float -1.198730
	.float 1.293157
	.float -1.068102
	.float 0.642681
	.float -0.192333
	.float -0.131057
	.float 0.243066
	.float -0.133855
	.float -0.137700
	.float 0.448829
	.float -0.630912
	.float 0.526321
	.float -0.080811
	.float -0.580813
	.float 1.169602
	.float -1.369353
	.float 1.035474
	.float -0.322749
	.float -0.372928
	.float 0.654424
	.float -0.396838
	.float -0.144588
	.float 0.491756
	.float -0.275070
	.float -0.490511
	.float 1.388124
	.float -1.862942
	.float 1.589231
	.float -0.688917
	.float -0.343177
	.float 0.949258
	.float -0.842796
	.float 0.155163
	.float 0.679189
	.float -1.202211
	.float 1.189028
	.float -0.734435
	.float 0.145895
	.float 0.261884
	.float -0.336143
	.float 0.132858
	.float 0.157712
	.float -0.340566
	.float 0.322606
	.float -0.148947
	.float -0.036756
	.float 0.080372
	.float 0.090905
	.float -0.420291
	.float 0.745928
	.float -0.890406
	.float 0.765423
	.float -0.425814
	.float 0.035837
	.float 0.231095
	.float -0.291412
	.float 0.185297
	.float -0.031853
	.float -0.053040
	.float 0.017061
	.float 0.120611
	.float -0.301305
	.float 0.465984
	.float -0.578476
	.float 0.629734
	.float -0.630453
	.float 0.595542
	.float -0.524881
	.float 0.392280
	.float -0.158552
	.float -0.190749
	.float 0.608367
	.float -0.984982
	.float 1.198673
	.float -1.185058
	.float 0.976056
	.float -0.675371
	.float 0.387512
	.float -0.154070
	.float -0.056369
	.float 0.301087
	.float -0.598195
	.float 0.892489
	.float -1.075902
	.float 1.049021
	.float -0.785804
	.float 0.363936
	.float 0.058776
	.float -0.314311
	.float 0.307170
	.float -0.065707
	.float -0.268696
	.float 0.511317
	.float -0.522643
	.float 0.267020
	.float 0.184272
	.float -0.694428
	.float 1.115885
	.float -1.335053
	.float 1.301279
	.float -1.040574
	.float 0.646926
	.float -0.243453
	.float -0.076622
	.float 0.294914
	.float -0.463984
	.float 0.652532
	.float -0.878827
	.float 1.083746
	.float -1.165441
	.float 1.050526
	.float -0.751504
	.float 0.371590
	.float -0.054137
	.float -0.093267
	.float 0.058005
	.float 0.068298
	.float -0.138227
	.float 0.030819
	.float 0.279483
	.float -0.710168
	.float 1.121744
	.float -1.395691
	.float 1.484542
	.float -1.405595
	.float 1.197868
	.float -0.888862
	.float 0.501318
	.float -0.086564
	.float -0.256635
	.float 0.408080
	.float -0.288366
	.float -0.083436
	.float 0.579931
	.float -1.016388
	.float 1.237190
	.float -1.188313
	.float 0.932613
	.float -0.601035
	.float 0.313656
	.float -0.123942
	.float 0.019343
	.float 0.034059
	.float -0.047706
	.float 0.007193
	.float 0.091327
	.float -0.203018
	.float 0.236019
	.float -0.100892
	.float -0.223551
	.float 0.654720
	.float -1.028301
	.float 1.170847
	.float -0.987244
	.float 0.520041
	.float 0.052174
	.float -0.485879
	.float 0.589233
	.float -0.327431
	.float -0.148823
	.float 0.584291
	.float -0.771262
	.float 0.674733
	.float -0.437935
	.float 0.259268
	.float -0.234245
	.float 0.289902
	.float -0.265658
	.float 0.069964
	.float 0.224202
	.float -0.428037
	.float 0.387726
	.float -0.108341
	.float -0.249550
	.float 0.489172
	.float -0.508328
	.float 0.340495
	.float -0.091217
	.float -0.158118
	.float 0.392793
	.float -0.628193
	.float 0.844683
	.float -0.967824
	.float 0.920968
	.float -0.703939
	.float 0.419188
	.float -0.207685
	.float 0.138614
	.float -0.146523
	.float 0.078980
	.float 0.174160
	.float -0.573144
	.float 0.934967
	.float -1.057366
	.float 0.867144
	.float -0.478455
	.float 0.116425
	.float 0.035266
	.float 0.050688
	.float -0.246672
	.float 0.374591
	.float -0.326349
	.float 0.113299
	.float 0.173726
	.float -0.439512
	.float 0.624194
	.float -0.688351
	.float 0.584890
	.float -0.272022
	.float -0.228560
	.float 0.783389
	.float -1.172972
	.float 1.199037
	.float -0.808354
	.float 0.142546
	.float 0.530303
	.float -0.963055
	.float 1.060344
	.float -0.907773
	.float 0.685791
	.float -0.533969
	.float 0.463821
	.float -0.379992
	.float 0.188710
	.float 0.092691
	.float -0.313542
	.float 0.280784
	.float 0.094230
	.float -0.695579
	.float 1.228078
	.float -1.367952
	.float 0.955005
	.float -0.107634
	.float -0.817045
	.float 1.402218
	.float -1.386624
	.float 0.790608
	.float 0.114877
	.float -0.966489
	.float 1.492169
	.float -1.616576
	.float 1.445706
	.float -1.164857
	.float 0.926172
	.float -0.789326
	.float 0.731660
	.float -0.697936
	.float 0.646419
	.float -0.565034
	.float 0.460909
	.float -0.342059
	.float 0.206496
	.float -0.043254
	.float -0.156659
	.float 0.382194
	.float -0.585841
	.float 0.686330
	.float -0.605145
	.float 0.328099
	.float 0.050322
	.float -0.348631
	.float 0.396551
	.float -0.154766
	.float -0.233633
	.float 0.516026
	.float -0.493059
	.float 0.159616
	.float 0.284068
	.float -0.567761
	.float 0.538681
	.float -0.263237
	.float -0.030295
	.float 0.121197
	.float 0.050894
	.float -0.358133
	.float 0.589722
	.float -0.600913
	.float 0.397305
	.float -0.108141
	.float -0.112428
	.float 0.176885
	.float -0.094176
	.float -0.062204
	.float 0.210154
	.float -0.301549
	.float 0.336408
	.float -0.352354
	.float 0.398837
	.float -0.505947
	.float 0.661107
	.float -0.808229
	.float 0.873882
	.float -0.806509
	.float 0.603697
	.float -0.310601
	.float -0.005416
	.float 0.283292
	.float -0.482705
	.float 0.583087
	.float -0.578563
	.float 0.478711
	.float -0.314284
	.float 0.138742
	.float -0.017460
	.float 0.005318
	.float -0.122364
	.float 0.340781
	.float -0.591519
	.float 0.788420
	.float -0.859001
	.float 0.770275
	.float -0.542135
	.float 0.245233
	.float 0.019120
	.float -0.156511
	.float 0.122749
	.float 0.050764
	.float -0.270821
	.float 0.433223
	.float -0.479888
	.float 0.423793
	.float -0.326674
	.float 0.249073
	.float -0.209594
	.float 0.177886
	.float -0.101966
	.float -0.048688
	.float 0.247637
	.float -0.406566
	.float 0.414097
	.float -0.208874
	.float -0.155757
	.float 0.510858
	.float -0.659193
	.float 0.506462
	.float -0.141427
	.float -0.208283
	.float 0.328960
	.float -0.175054
	.float -0.093539
	.float 0.225925
	.float -0.065670
	.float -0.328111
	.float 0.710228
	.float -0.806002
	.float 0.485980
	.float 0.151979
	.float -0.834341
	.float 1.254491
	.float -1.221873
	.float 0.745689
	.float -0.023963
	.float -0.647772
	.float 1.005422
	.float -0.928887
	.float 0.489509
	.float 0.091065
	.float -0.553318
	.float 0.728197
	.float -0.613446
	.float 0.356089
	.float -0.152122
	.float 0.124264
	.float -0.252626
	.float 0.401517
	.float -0.424353
	.float 0.276269
	.float -0.054866
	.float -0.064867
	.float -0.037505
	.float 0.321110
	.float -0.585278
	.float 0.591808
	.float -0.231611
	.float -0.381077
	.float 0.962298
	.float -1.232969
	.float 1.098857
	.float -0.710523
	.float 0.359287
	.float -0.280882
	.float 0.502370
	.float -0.835378
	.float 1.014814
	.float -0.882559
	.float 0.491235
	.float -0.063240
	.float -0.160298
	.float 0.076209
	.float 0.220457
	.float -0.506912
	.float 0.582735
	.float -0.398790
	.float 0.082514
	.float 0.152618
	.float -0.149786
	.float -0.089862
	.float 0.408494
	.float -0.589000
	.float 0.485193
	.float -0.109368
	.float -0.368982
	.float 0.710028
	.float -0.730191
	.float 0.401833
	.float 0.129838
	.float -0.625648
	.float 0.883056
	.float -0.838367
	.float 0.576983
	.float -0.252266
	.float -0.020827
	.float 0.218070
	.float -0.375208
	.float 0.516754
	.float -0.615816
	.float 0.619940
	.float -0.512703
	.float 0.347988
	.float -0.222060
	.float 0.208719
	.float -0.315152
	.float 0.493348
	.float -0.687636
	.float 0.868208
	.float -1.021574
	.float 1.117914
	.float -1.101513
	.float 0.926982
	.float -0.612692
	.float 0.257611
	.float 0.004387
	.float -0.082617
	.float -0.022175
	.float 0.236524
	.float -0.478201
	.float 0.706061
	.float -0.914315
	.float 1.085615
	.float -1.158070
	.float 1.048842
	.float -0.722284
	.float 0.244822
	.float 0.227719
	.float -0.531781
	.float 0.591680
	.float -0.460506
	.float 0.278055
	.float -0.180389
	.float 0.227436
	.float -0.394870
	.float 0.620739
	.float -0.856715
	.float 1.079329
	.float -1.261358
	.float 1.343879
	.float -1.249579
	.float 0.936737
	.float -0.450724
	.float -0.075430
	.float 0.480502
	.float -0.655560
	.float 0.588172
	.float -0.344301
	.float 0.010494
	.float 0.352771
	.float -0.712740
	.float 1.031224
	.float -1.239362
	.float 1.256333
	.float -1.046696
	.float 0.672367
	.float -0.288601
	.float 0.071951
	.float -0.120945
	.float 0.397472
	.float -0.752920
	.float 1.022852
	.float -1.121682
	.float 1.069613
	.float -0.939927
	.float 0.780576
	.float -0.584065
	.float 0.331491
	.float -0.062942
	.float -0.106689
	.float 0.061681
	.float 0.202262
	.float -0.530640
	.float 0.689204
	.float -0.526166
	.float 0.093924
	.float 0.372651
	.float -0.613172
	.float 0.516551
	.float -0.181289
	.float -0.177023
	.float 0.388251
	.float -0.429348
	.float 0.395726
	.float -0.385255
	.float 0.404426
	.float -0.375342
	.float 0.227122
	.float 0.017712
	.float -0.242168
	.float 0.319008
	.float -0.204600
	.float -0.037834
	.float 0.297985
	.float -0.496963
	.float 0.609855
	.float -0.621243
	.float 0.477578
	.float -0.108471
	.float -0.482922
	.float 1.143844
	.float -1.603352
	.float 1.620183
	.float -1.149841
	.float 0.401964
	.float 0.264926
	.float -0.544374
	.float 0.344578
	.float 0.184988
	.float -0.760577
	.float 1.120898
	.float -1.140289
	.float 0.855141
	.float -0.417531
	.float 0.015373
	.float 0.206185
	.float -0.199177
	.float 0.025546
	.float 0.180480
	.float -0.288311
	.float 0.245443
	.float -0.103886
	.float -0.021340
	.float 0.035527
	.float 0.066913
	.float -0.194223
	.float 0.214556
	.float -0.041109
	.float -0.306076
	.float 0.696649
	.float -0.948010
	.float 0.919308
	.float -0.596732
	.float 0.121859
	.float 0.265678
	.float -0.354691
	.float 0.090043
	.float 0.384677
	.float -0.810282
	.float 0.973356
	.float -0.832391
	.float 0.514840
	.float -0.191481
	.float -0.063268
	.float 0.303909
	.float -0.612540
	.float 0.959645
	.float -1.164463
	.float 1.009547
	.float -0.426362
	.float -0.404712
	.float 1.135720
	.float -1.464310
	.float 1.319620
	.float -0.883193
	.float 0.437452
	.float -0.166310
	.float 0.056821
	.float 0.040645
	.float -0.260812
	.float 0.603548
	.float -0.924622
	.float 1.027236
	.float -0.783079
	.float 0.212387
	.float 0.509598
	.float -1.115595
	.float 1.353067
	.float -1.097203
	.float 0.422654
	.float 0.407981
	.float -1.050055
	.float 1.237973
	.float -0.920551
	.float 0.289789
	.float 0.325771
	.float -0.650592
	.float 0.620012
	.float -0.400566
	.float 0.253230
	.float -0.333729
	.float 0.577218
	.float -0.757829
	.float 0.678677
	.float -0.342232
	.float -0.037935
	.float 0.198131
	.float -0.033552
	.float -0.308783
	.float 0.526440
	.float -0.373936
	.float -0.167282
	.float 0.879608
	.float -1.452579
	.float 1.662732
	.float -1.466993
	.float 0.973069
	.float -0.347719
	.float -0.251658
	.float 0.691662
	.float -0.861168
	.float 0.699596
	.float -0.248322
	.float -0.331997
	.float 0.821831
	.float -1.055691
	.float 1.006060
	.float -0.774442
	.float 0.500999
	.float -0.269132
	.float 0.077361
	.float 0.113642
	.float -0.312943
	.float 0.473343
	.float -0.525901
	.float 0.441610
	.float -0.269205
	.float 0.120709
	.float -0.113152
	.float 0.299182
	.float -0.623866
	.float 0.934010
	.float -1.047074
	.float 0.855299
	.float -0.410175
	.float -0.076327
	.float 0.338465
	.float -0.221777
	.float -0.200735
	.float 0.652839
	.float -0.818985
	.float 0.542797
	.float 0.075136
	.float -0.743883
	.float 1.159298
	.float -1.168871
	.float 0.826904
	.float -0.330555
	.float -0.099155
	.float 0.314833
	.float -0.280036
	.float 0.052266
	.float 0.261640
	.float -0.553506
	.float 0.750059
	.float -0.829393
	.float 0.813465
	.float -0.740518
	.float 0.630390
	.float -0.464265
	.float 0.198269
	.float 0.188477
	.float -0.640163
	.float 1.013270
	.float -1.138667
	.float 0.931924
	.float -0.472550
	.float -0.023647
	.float 0.339830
	.float -0.407832
	.float 0.351144
	.float -0.377292
	.float 0.600266
	.float -0.938332
	.float 1.174409
	.float -1.131133
	.float 0.816794
	.float -0.423993
	.float 0.186690
	.float -0.214250
	.float 0.430991
	.float -0.656076
	.float 0.747066
	.float -0.691549
	.float 0.586896
	.float -0.541825
	.float 0.587972
	.float -0.667700
	.float 0.695895
	.float -0.636998
	.float 0.534902
	.float -0.477239
	.float 0.527066
	.float -0.674751
	.float 0.841625
	.float -0.928565
	.float 0.874085
	.float -0.686965
	.float 0.438981
	.float -0.227851
	.float 0.133083
	.float -0.185166
	.float 0.357647
	.float -0.580655
	.float 0.768886
	.float -0.854161
	.float 0.810658
	.float -0.660672
	.float 0.456384
	.float -0.248106
	.float 0.061800
	.float 0.097083
	.float -0.220493
	.float 0.282744
	.float -0.254719
	.float 0.137626
	.float 0.019454
	.float -0.142958
	.float 0.183217
	.float -0.143137
	.float 0.057664
	.float 0.054884
	.float -0.216578
	.float 0.455517
	.float -0.739949
	.float 0.947569
	.float -0.917621
	.float 0.565064
	.float 0.024864
	.float -0.604454
	.float 0.891142
	.float -0.745141
	.float 0.277427
	.float 0.199625
	.float -0.367250
	.float 0.121284
	.float 0.337803
	.float -0.627728
	.float 0.453937
	.float 0.159184
	.float -0.851702
	.float 1.156863
	.float -0.824958
	.float 0.011947
	.float 0.806455
	.float -1.138310
	.float 0.785640
	.float 0.047611
	.float -0.907600
	.float 1.379871
	.float -1.316396
	.float 0.869149
	.float -0.344679
	.float 0.005143
	.float 0.053181
	.float 0.107591
	.float -0.359191
	.float 0.598889
	.float -0.781884
	.float 0.895801
	.float -0.923442
	.float 0.837601
	.float -0.632533
	.float 0.357144
	.float -0.108576
	.float -0.021463
	.float 0.010652
	.float 0.073218
	.float -0.118327
	.float 0.052389
	.float 0.099079
	.float -0.226767
	.float 0.216458
	.float -0.034607
	.float -0.243235
	.float 0.483206
	.float -0.586133
	.float 0.554519
	.float -0.484147
	.float 0.486088
	.float -0.596174
	.float 0.739848
	.float -0.781488
	.float 0.625696
	.float -0.297511
	.float -0.058504
	.float 0.262374
	.float -0.208058
	.float -0.077069
	.float 0.458825
	.float -0.783073
	.float 0.958656
	.float -0.983716
	.float 0.910006
	.float -0.782543
	.float 0.604293
	.float -0.350721
	.float 0.019765
	.float 0.324958
	.float -0.558594
	.float 0.556322
	.float -0.277456
	.float -0.184722
	.float 0.628784
	.float -0.839464
	.float 0.697519
	.float -0.241253
	.float -0.353212
	.float 0.857138
	.float -1.092232
	.float 1.001458
	.float -0.660642
	.float 0.233190
	.float 0.106422
	.float -0.244407
	.float 0.164418
	.float 0.062108
	.float -0.320323
	.float 0.504447
	.float -0.553461
	.float 0.459481
	.float -0.254165
	.float -0.012885
	.float 0.292053
	.float -0.543608
	.float 0.741815
	.float -0.875486
	.float 0.943959
	.float -0.947202
	.float 0.874526
	.float -0.704216
	.float 0.423006
	.float -0.056021
	.float -0.319891
	.float 0.602889
	.float -0.724626
	.float 0.697385
	.float -0.605220
	.float 0.538070
	.float -0.519341
	.float 0.491342
	.float -0.376046
	.float 0.161745
	.float 0.061662
	.float -0.157590
	.float 0.051302
	.float 0.192221
	.float -0.386623
	.float 0.334295
	.float 0.042700
	.float -0.638232
	.float 1.207856
	.float -1.499137
	.float 1.388830
	.float -0.945932
	.float 0.384632
	.float 0.062535
	.float -0.273110
	.float 0.286939
	.float -0.252323
	.float 0.305409
	.float -0.465165
	.float 0.616304
	.float -0.594282
	.float 0.317283
	.float 0.124466
	.float -0.488681
	.float 0.508843
	.float -0.058512
	.float -0.748893
	.float 1.593156
	.float -2.104837
	.float 2.060753
	.float -1.501861
	.float 0.700810
	.float 0.001138
	.float -0.382859
	.float 0.438460
	.float -0.327977
	.float 0.236061
	.float -0.250865
	.float 0.344065
	.float -0.441184
	.float 0.501166
	.float -0.533486
	.float 0.554191
	.float -0.543700
	.float 0.461019
	.float -0.302661
	.float 0.141373
	.float -0.092712
	.float 0.225247
	.float -0.487375
	.float 0.717828
	.float -0.741654
	.float 0.485059
	.float -0.025939
	.float -0.455109
	.float 0.785506
	.float -0.893658
	.float 0.823566
	.float -0.674540
	.float 0.523442
	.float -0.390501
	.float 0.262672
	.float -0.137155
	.float 0.037372
	.float 0.010560
	.float -0.010588
	.float 0.001033
	.float -0.024939
	.float 0.095242
	.float -0.187600
	.float 0.264265
	.float -0.302863
	.float 0.303498
	.float -0.273237
	.float 0.210916
	.float -0.112368
	.float -0.009194
	.float 0.113745
	.float -0.154114
	.float 0.112992
	.float -0.023607
	.float -0.049180
	.float 0.055578
	.float 0.002972
	.float -0.077576
	.float 0.110225
	.float -0.072967
	.float -0.021509
	.float 0.138668
	.float -0.248438
	.float 0.337473
	.float -0.404089
	.float 0.447073
	.float -0.459761
	.float 0.432719
	.float -0.361590
	.float 0.255361
	.float -0.140794
	.float 0.058026
	.float -0.044754
	.float 0.113315
	.float -0.234625
	.float 0.344542
	.float -0.377786
	.float 0.312359
	.float -0.191308
	.float 0.096811
	.float -0.085243
	.float 0.131142
	.float -0.133603
	.float -0.003788
	.float 0.272386
	.float -0.522020
	.float 0.536708
	.float -0.186649
	.float -0.447598
	.float 1.075735
	.float -1.341333
	.float 1.029171
	.float -0.209857
	.float -0.771357
	.float 1.464304
	.float -1.551316
	.float 1.020817
	.float -0.179021
	.float -0.508602
	.float 0.659655
	.float -0.170380
	.float -0.735985
	.float 1.625399
	.float -2.066949
	.float 1.838207
	.float -1.029683
	.float 0.005287
	.float 0.764919
	.float -0.930613
	.float 0.442039
	.float 0.412953
	.float -1.154100
	.float 1.372887
	.float -0.969108
	.float 0.210661
	.float 0.429489
	.float -0.561338
	.float 0.106179
	.float 0.677961
	.float -1.376148
	.float 1.666833
	.float -1.476968
	.float 0.964983
	.float -0.383920
	.float -0.057717
	.float 0.256319
	.float -0.199886
	.float -0.062606
	.float 0.432415
	.float -0.767879
	.float 0.921516
	.float -0.809808
	.float 0.472130
	.float -0.068100
	.float -0.196629
	.float 0.174219
	.float 0.153039
	.float -0.668048
	.float 1.175947
	.float -1.487609
	.float 1.490604
	.float -1.183949
	.float 0.670477
	.float -0.113646
	.float -0.326099
	.float 0.554406
	.float -0.578741
	.float 0.495422
	.float -0.427906
	.float 0.448933
	.float -0.537349
	.float 0.602251
	.float -0.558132
	.float 0.393005
	.float -0.175134
	.float -0.004528
	.float 0.103603
	.float -0.153280
	.float 0.219335
	.float -0.336039
	.float 0.467978
	.float -0.527296
	.float 0.429295
	.float -0.145797
	.float -0.273652
	.float 0.716994
	.float -1.047074
	.float 1.145349
	.float -0.950528
	.float 0.483375
	.float 0.151654
	.float -0.792530
	.float 1.268633
	.float -1.455229
	.float 1.313725
	.float -0.902295
	.float 0.353576
	.float 0.173203
	.float -0.548469
	.float 0.715599
	.float -0.702517
	.float 0.597751
	.float -0.504274
	.float 0.494451
	.float -0.584258
	.float 0.730945
	.float -0.849991
	.float 0.848435
	.float -0.671830
	.float 0.349540
	.float -0.008032
	.float -0.174709
	.float 0.064544
	.float 0.338084
	.float -0.878690
	.float 1.325358
	.float -1.497566
	.float 1.363439
	.float -1.043993
	.float 0.729011
	.float -0.565377
	.float 0.586294
	.float -0.712386
	.float 0.809170
	.float -0.760964
	.float 0.525621
	.float -0.151532
	.float -0.243852
	.float 0.525370
	.float -0.602436
	.float 0.477465
	.float -0.252981
	.float 0.083667
	.float -0.089112
	.float 0.274495
	.float -0.516578
	.float 0.639433
	.float -0.542174
	.float 0.291136
	.float -0.099752
	.float 0.191214
	.float -0.629436
	.float 1.237750
	.float -1.674642
	.float 1.630701
	.float -1.026092
	.float 0.081940
	.float 0.784972
	.float -1.186173
	.float 0.972959
	.float -0.311271
	.float -0.421945
	.float 0.854652
	.float -0.816014
	.float 0.400343
	.float 0.123352
	.float -0.481057
	.float 0.531173
	.float -0.300872
	.float -0.068831
	.float 0.410479
	.float -0.597974
	.float 0.581513
	.float -0.399040
	.float 0.165719
	.float -0.029225
	.float 0.091912
	.float -0.337261
	.float 0.618713
	.float -0.738214
	.float 0.575403
	.float -0.179622
	.float -0.245599
	.float 0.461010
	.float -0.334131
	.float -0.087133
	.float 0.609753
	.float -1.004659
	.float 1.116296
	.float -0.917490
	.float 0.500552
	.float -0.028417
	.float -0.327467
	.float 0.448140
	.float -0.313977
	.float 0.017168
	.float 0.279330
	.float -0.427202
	.float 0.377205
	.float -0.205756
	.float 0.060317
	.float -0.057797
	.float 0.205147
	.float -0.395982
	.float 0.481826
	.float -0.367957
	.float 0.073051
	.float 0.278951
	.float -0.524500
	.float 0.544827
	.float -0.325494
	.float -0.037618
	.float 0.387649
	.float -0.584664
	.float 0.569359
	.float -0.378973
	.float 0.113275
	.float 0.120127
	.float -0.244560
	.float 0.222398
	.float -0.047216
	.float -0.256542
	.float 0.621499
	.float -0.932380
	.float 1.052603
	.float -0.882782
	.float 0.421543
	.float 0.211514
	.float -0.810369
	.float 1.161775
	.float -1.132873
	.float 0.729613
	.float -0.101637
	.float -0.512080
	.float 0.881730
	.float -0.890919
	.float 0.594851
	.float -0.192492
	.float -0.083369
	.float 0.100571
	.float 0.094903
	.float -0.309692
	.float 0.325345
	.float -0.035271
	.float -0.489318
	.float 1.043468
	.float -1.410647
	.float 1.483028
	.float -1.305192
	.float 1.019475
	.float -0.758452
	.float 0.564954
	.float -0.396441
	.float 0.202961
	.float -0.007278
	.float -0.087351
	.float -0.024589
	.float 0.348295
	.float -0.748974
	.float 1.014641
	.float -0.978872
	.float 0.615050
	.float -0.039704
	.float -0.564641
	.float 1.041355
	.float -1.305183
	.float 1.332770
	.float -1.136253
	.float 0.758404
	.float -0.287868
	.float -0.142426
	.float 0.401946
	.float -0.434680
	.float 0.297871
	.float -0.122332
	.float 0.013795
	.float 0.027175
	.float -0.094675
	.float 0.279423
	.float -0.565711
	.float 0.817659
	.float -0.874347
	.float 0.677097
	.float -0.320737
	.float -0.015578
	.float 0.199918
	.float -0.232959
	.float 0.222062
	.float -0.275101
	.float 0.407594
	.float -0.537179
	.float 0.560960
	.float -0.443923
	.float 0.244800
	.float -0.063501
	.float -0.040209
	.float 0.086859
	.float -0.144563
	.float 0.253582
	.float -0.375074
	.float 0.411087
	.float -0.284699
	.float 0.017934
	.float 0.257759
	.float -0.374064
	.float 0.232636
	.float 0.128747
	.float -0.556346
	.float 0.868079
	.float -0.944955
	.float 0.768964
	.float -0.399276
	.float -0.074630
	.float 0.559032
	.float -0.953094
	.float 1.147612
	.float -1.056183
	.float 0.672495
	.float -0.106647
	.float -0.443342
	.float 0.781747
	.float -0.811212
	.float 0.569529
	.float -0.187927
	.float -0.190331
	.float 0.469269
	.float -0.607625
	.float 0.594678
	.float -0.436141
	.float 0.167636
	.float 0.127558
	.float -0.334051
	.float 0.362327
	.float -0.213557
	.float -0.002850
	.float 0.125257
	.float -0.040610
	.float -0.237726
	.float 0.572787
	.float -0.791031
	.float 0.796116
	.float -0.631046
	.float 0.446000
	.float -0.394960
	.float 0.532991
	.float -0.782167
	.float 0.984422
	.float -1.002224
	.float 0.801731
	.float -0.470154
	.float 0.162504
	.float -0.013299
	.float 0.065153
	.float -0.251745
	.float 0.439947
	.float -0.503136
	.float 0.384150
	.float -0.116742
	.float -0.199797
	.float 0.453529
	.float -0.569332
	.float 0.530187
	.float -0.364470
	.float 0.114564
	.float 0.185326
	.float -0.502751
	.float 0.780731
	.float -0.925236
	.float 0.837610
	.float -0.485581
	.float -0.036510
	.float 0.516986
	.float -0.721342
	.float 0.522914
	.float 0.014861
	.float -0.662156
	.float 1.141114
	.float -1.266091
	.float 1.024149
	.float -0.557297
	.float 0.069617
	.float 0.279653
	.float -0.438850
	.float 0.459007
	.float -0.436871
	.float 0.446072
	.float -0.496218
	.float 0.538946
	.float -0.511270
	.float 0.384624
	.float -0.187446
	.float -0.010810
	.float 0.137926
	.float -0.150725
	.float 0.043705
	.float 0.157602
	.float -0.399237
	.float 0.593373
	.float -0.624730
	.float 0.392620
	.float 0.118019
	.float -0.782826
	.float 1.356060
	.float -1.574504
	.float 1.297794
	.float -0.599289
	.float -0.255872
	.float 0.938541
	.float -1.215060
	.float 1.046285
	.float -0.577275
	.float 0.039700
	.float 0.362330
	.float -0.519472
	.float 0.421006
	.float -0.124736
	.float -0.271007
	.float 0.644222
	.float -0.872744
	.float 0.876908
	.float -0.664364
	.float 0.339922
	.float -0.058218
	.float -0.060319
	.float -0.002650
	.float 0.158853
	.float -0.277606
	.float 0.276788
	.float -0.178894
	.float 0.092791
	.float -0.130787
	.float 0.315447
	.float -0.541128
	.float 0.623612
	.float -0.415188
	.float -0.084547
	.float 0.697197
	.float -1.146691
	.float 1.215203
	.float -0.879924
	.float 0.336799
	.float 0.117206
	.float -0.274378
	.float 0.150468
	.float 0.037326
	.float -0.040193
	.float -0.225879
	.float 0.605649
	.float -0.813036
	.float 0.642354
	.float -0.121196
	.float -0.511186
	.float 0.977245
	.float -1.144917
	.float 1.079973
	.float -0.941119
	.float 0.824755
	.float -0.700559
	.float 0.488937
	.float -0.197869
	.float -0.019446
	.float -0.044246
	.float 0.475176
	.float -1.125145
	.float 1.663525
	.float -1.770378
	.float 1.336597
	.float -0.532389
	.float -0.298279
	.float 0.839008
	.float -0.963234
	.float 0.762142
	.float -0.440379
	.float 0.167345
	.float 0.011263
	.float -0.152318
	.float 0.319402
	.float -0.498674
	.float 0.595441
	.float -0.510375
	.float 0.229039
	.float 0.149582
	.float -0.467612
	.float 0.601688
	.float -0.526592
	.float 0.311322
	.float -0.062794
	.float -0.137129
	.float 0.265532
	.float -0.353865
	.float 0.455687
	.float -0.603217
	.float 0.772305
	.float -0.879429
	.float 0.825092
	.float -0.567615
	.float 0.177315
	.float 0.181018
	.float -0.341803
	.float 0.248317
	.float 0.005682
	.float -0.240456
	.float 0.315775
	.float -0.222633
	.float 0.073414
	.float -0.003243
	.float 0.061919
	.float -0.176515
	.float 0.207236
	.float -0.052080
	.float -0.273052
	.float 0.630870
	.float -0.836847
	.float 0.765808
	.float -0.426350
	.float -0.042055
	.float 0.448459
	.float -0.656869
	.float 0.652192
	.float -0.525767
	.float 0.396855
	.float -0.329869
	.float 0.305239
	.float -0.256196
	.float 0.133442
	.float 0.055891
	.float -0.259505
	.float 0.421814
	.float -0.516921
	.float 0.549587
	.float -0.535182
	.float 0.484916
	.float -0.409266
	.float 0.328063
	.float -0.267156
	.float 0.238264
	.float -0.222048
	.float 0.177807
	.float -0.080713
	.float -0.041237
	.float 0.106280
	.float -0.026020
	.float -0.225298
	.float 0.568802
	.float -0.843520
	.float 0.889482
	.float -0.643215
	.float 0.183811
	.float 0.304574
	.float -0.633740
	.float 0.712839
	.float -0.585263
	.float 0.380257
	.float -0.215856
	.float 0.120156
	.float -0.023559
	.float -0.175927
	.float 0.518789
	.float -0.925123
	.float 1.214291
	.float -1.201978
	.float 0.824374
	.float -0.212735
	.float -0.342647
	.float 0.538291
	.float -0.237198
	.float -0.431637
	.float 1.128945
	.float -1.493382
	.float 1.347866
	.float -0.793755
	.float 0.136507
	.float 0.302434
	.float -0.363832
	.float 0.112539
	.float 0.239313
	.float -0.480019
	.float 0.514390
	.float -0.381557
	.float 0.184688
	.float -0.001477
	.float -0.154345
	.float 0.304035
	.float -0.449634
	.float 0.552594
	.float -0.563085
	.float 0.466035
	.float -0.294380
	.float 0.096671
	.float 0.106689
	.float -0.332278
	.float 0.596586
	.float -0.867972
	.float 1.055524
	.float -1.051906
	.float 0.803326
	.float -0.357784
	.float -0.142352
	.float 0.522101
	.float -0.656082
	.float 0.526831
	.float -0.229555
	.float -0.076676
	.float 0.243212
	.float -0.195459
	.float -0.039478
	.float 0.347344
	.float -0.577972
	.float 0.618742
	.float -0.463096
	.float 0.231687
	.float -0.112441
	.float 0.233748
	.float -0.548221
	.float 0.824919
	.float -0.785488
	.float 0.307453
	.float 0.454623
	.float -1.136784
	.float 1.391983
	.float -1.117104
	.float 0.514682
	.float 0.054507
	.float -0.313146
	.float 0.223337
	.float 0.044400
	.float -0.277497
	.float 0.373673
	.float -0.364330
	.float 0.320669
	.float -0.254875
	.float 0.116316
	.float 0.121882
	.float -0.384624
	.float 0.517824
	.float -0.407588
	.float 0.093955
	.float 0.227966
	.float -0.335368
	.float 0.140511
	.float 0.237124
	.float -0.546853
	.float 0.576664
	.float -0.295788
	.float -0.125989
	.float 0.428392
	.float -0.420282
	.float 0.086612
	.float 0.414595
	.float -0.850080
	.float 1.037155
	.float -0.927093
	.float 0.609410
	.float -0.247281
	.float -0.013855
	.float 0.113703
	.float -0.088172
	.float 0.024422
	.float 0.007074
	.float 0.003495
	.float -0.015854
	.float -0.004240
	.float 0.028951
	.float 0.036989
	.float -0.294424
	.float 0.756887
	.float -1.293962
	.float 1.663930
	.float -1.633714
	.float 1.123425
	.float -0.285869
	.float -0.539027
	.float 0.984431
	.float -0.848703
	.float 0.209875
	.float 0.607798
	.float -1.200780
	.float 1.293672
	.float -0.871096
	.float 0.164275
	.float 0.493050
	.float -0.851711
	.float 0.869942
	.float -0.706276
	.float 0.594294
	.float -0.681386
	.float 0.934359
	.float -1.171023
	.float 1.193409
	.float -0.929462
	.float 0.485769
	.float -0.078443
	.float -0.103398
	.float 0.003666
	.float 0.291637
	.float -0.631540
	.float 0.891801
	.float -1.014382
	.float 0.985543
	.float -0.799731
	.float 0.460512
	.float -0.020299
	.float -0.391663
	.float 0.605587
	.float -0.509729
	.float 0.144379
	.float 0.289204
	.float -0.529790
	.float 0.410208
	.float 0.037920
	.float -0.600308
	.float 1.007953
	.float -1.092950
	.float 0.873227
	.float -0.518163
	.float 0.226322
	.float -0.102042
	.float 0.111467
	.float -0.139485
	.float 0.096287
	.float 0.010657
	.float -0.092743
	.float 0.066889
	.float 0.062030
	.float -0.194615
	.float 0.214510
	.float -0.087053
	.float -0.105443
	.float 0.226208
	.float -0.197223
	.float 0.069989
	.float 0.009273
	.float 0.080731
	.float -0.324555
	.float 0.558689
	.float -0.578986
	.float 0.292791
	.float 0.197479
	.float -0.644851
	.float 0.810765
	.float -0.614141
	.float 0.175171
	.float 0.268387
	.float -0.505768
	.float 0.458965
	.float -0.192987
	.float -0.151698
	.float 0.441682
	.float -0.597924
	.float 0.601769
	.float -0.482645
	.float 0.303269
	.float -0.137337
	.float 0.033239
	.float 0.019360
	.float -0.085015
	.float 0.226204
	.float -0.429474
	.float 0.581549
	.float -0.535173
	.float 0.230051
	.float 0.226371
	.float -0.598293
	.float 0.670623
	.float -0.402164
	.float -0.038109
	.float 0.387512
	.float -0.474005
	.float 0.327270
	.float -0.133306
	.float 0.074097
	.float -0.183158
	.float 0.329488
	.float -0.335514
	.float 0.129364
	.float 0.189265
	.float -0.417334
	.float 0.395136
	.float -0.122554
	.float -0.235975
	.float 0.457034
	.float -0.401684
	.float 0.103675
	.float 0.252151
	.float -0.446865
	.float 0.367268
	.float -0.079419
	.float -0.214556
	.float 0.312177
	.float -0.149557
	.float -0.154648
	.float 0.386936
	.float -0.398936
	.float 0.221145
	.float -0.040043
	.float 0.049278
	.float -0.285930
	.float 0.581862
	.float -0.676423
	.float 0.410965
	.float 0.142380
	.float -0.720019
	.float 1.048547
	.float -1.032387
	.float 0.807078
	.float -0.621079
	.float 0.640875
	.float -0.828159
	.float 0.977576
	.float -0.878276
	.float 0.472625
	.float 0.102571
	.float -0.611404
	.float 0.869763
	.float -0.842203
	.float 0.630375
	.float -0.383464
	.float 0.205908
	.float -0.119194
	.float 0.081639
	.float -0.035096
	.float -0.052459
	.float 0.161947
	.float -0.222009
	.float 0.138901
	.float 0.143595
	.float -0.583576
	.float 1.028163
	.float -1.277948
	.float 1.201036
	.float -0.821358
	.float 0.312928
	.float 0.102466
	.float -0.284408
	.float 0.239825
	.float -0.084978
	.float -0.058794
	.float 0.150403
	.float -0.229700
	.float 0.340101
	.float -0.447139
	.float 0.435238
	.float -0.201005
	.float -0.228063
	.float 0.659491
	.float -0.840412
	.float 0.640994
	.float -0.175695
	.float -0.247225
	.float 0.330158
	.float -0.001312
	.float -0.521192
	.float 0.870550
	.float -0.780516
	.float 0.266173
	.float 0.389038
	.float -0.824520
	.float 0.833440
	.float -0.476052
	.float 0.010982
	.float 0.288707
	.float -0.296914
	.float 0.072263
	.float 0.223663
	.float -0.439482
	.float 0.491810
	.float -0.354568
	.float 0.033705
	.float 0.422082
	.float -0.887646
	.float 1.168847
	.float -1.092682
	.float 0.638044
	.float -0.001433
	.float -0.481310
	.float 0.528714
	.float -0.094376
	.float -0.599405
	.float 1.205552
	.float -1.473040
	.float 1.387825
	.float -1.140137
	.float 0.954760
	.float -0.918649
	.float 0.932806
	.float -0.814383
	.float 0.462888
	.float 0.037904
	.float -0.456256
	.float 0.556868
	.float -0.249897
	.float -0.354196
	.float 1.010552
	.float -1.473243
	.float 1.609137
	.float -1.434383
	.float 1.072712
	.float -0.677776
	.float 0.365775
	.float -0.182747
	.float 0.106368
	.float -0.071772
	.float 0.011409
	.float 0.104328
	.float -0.245316
	.float 0.337699
	.float -0.315900
	.float 0.178095
	.float 0.000640
	.float -0.116934
	.float 0.118180
	.float -0.047495
	.float 0.011268
	.float -0.089395
	.float 0.261043
	.float -0.410986
	.float 0.417513
	.float -0.253099
	.float 0.014922
	.float 0.144226
	.float -0.133660
	.float -0.001134
	.float 0.110445
	.float -0.057457
	.float -0.169724
	.float 0.441932
	.float -0.584392
	.float 0.509762
	.float -0.283276
	.float 0.069401
	.float -0.005892
	.float 0.104875
	.float -0.253812
	.float 0.306675
	.float -0.191131
	.float -0.043497
	.float 0.262403
	.float -0.334069
	.float 0.214487
	.float 0.021024
	.float -0.216107
	.float 0.223241
	.float 0.003086
	.float -0.366621
	.float 0.674575
	.float -0.747841
	.float 0.530482
	.float -0.127701
	.float -0.255111
	.float 0.435348
	.float -0.361146
	.float 0.137852
	.float 0.042218
	.float -0.023001
	.float -0.213688
	.float 0.530965
	.float -0.718120
	.float 0.625740
	.float -0.272726
	.float -0.147909
	.float 0.380257
	.float -0.272220
	.float -0.110779
	.float 0.510584
	.float -0.636285
	.float 0.357913
	.float 0.200639
	.float -0.738590
	.float 0.974080
	.float -0.821834
	.float 0.431962
	.float -0.073197
	.float -0.047583
	.float -0.094804
	.float 0.351093
	.float -0.505887
	.float 0.406631
	.float -0.041095
	.float -0.461704
	.float 0.892352
	.float -1.052493
	.float 0.845100
	.float -0.329834
	.float -0.287788
	.float 0.744011
	.float -0.849600
	.float 0.595665
	.float -0.161564
	.float -0.192333
	.float 0.285729
	.float -0.126723
	.float -0.108253
	.float 0.209192
	.float -0.083663
	.float -0.186277
	.float 0.419662
	.float -0.481849
	.float 0.384755
	.float -0.265184
	.float 0.261715
	.float -0.390200
	.float 0.518941
	.float -0.466813
	.float 0.150261
	.float 0.334158
	.float -0.757906
	.float 0.906092
	.float -0.715110
	.float 0.307137
	.float 0.093282
	.float -0.291443
	.float 0.213720
	.float 0.083920
	.float -0.466393
	.float 0.779205
	.float -0.890153
	.float 0.718636
	.float -0.263694
	.float -0.378728
	.float 1.032503
	.float -1.499581
	.float 1.636328
	.float -1.408751
	.float 0.902265
	.float -0.289490
	.float -0.225040
	.float 0.467481
	.float -0.355314
	.float -0.059713
	.float 0.593018
	.float -0.992988
	.float 1.056451
	.float -0.736709
	.float 0.175578
	.float 0.370356
	.float -0.670433
	.float 0.642053
	.float -0.380603
	.float 0.086019
	.float 0.060374
	.float 0.008351
	.float -0.226274
	.float 0.452450
	.float -0.563866
	.float 0.528687
	.float -0.419105
	.float 0.356387
	.float -0.421358
	.float 0.589990
	.float -0.743567
	.float 0.752342
	.float -0.574581
	.float 0.295280
	.float -0.072199
	.float 0.027447
	.float -0.164716
	.float 0.370276
	.float -0.491101
	.float 0.430788
	.float -0.200731
	.float -0.097160
	.float 0.334271
	.float -0.423617
	.float 0.358074
	.float -0.205201
	.float 0.066693
	.float -0.025877
	.float 0.110808
	.float -0.290009
	.float 0.495920
	.float -0.654612
	.float 0.703429
	.float -0.597584
	.float 0.321736
	.float 0.087043
	.float -0.522741
	.float 0.829581
	.float -0.866732
	.float 0.588890
	.float -0.090736
	.float -0.421778
	.float 0.724391
	.float -0.682870
	.float 0.318779
	.float 0.200691
	.float -0.642795
	.float 0.819364
	.float -0.673720
	.float 0.300321
	.float 0.113429
	.float -0.391440
	.float 0.458173
	.float -0.360559
	.float 0.214695
	.float -0.120248
	.float 0.103171
	.float -0.119564
	.float 0.105231
	.float -0.026486
	.float -0.101503
	.float 0.230828
	.float -0.308595
	.float 0.295352
	.float -0.170267
	.float -0.067806
	.float 0.395177
	.float -0.756073
	.float 1.064170
	.float -1.221944
	.float 1.156738
	.float -0.858068
	.float 0.394569
	.float 0.103811
	.float -0.493879
	.float 0.674415
	.float -0.620817
	.float 0.383235
	.float -0.053344
	.float -0.278686
	.float 0.552305
	.float -0.735547
	.float 0.802286
	.float -0.713480
	.float 0.428681
	.float 0.049523
	.float -0.629800
	.float 1.131806
	.float -1.353288
	.float 1.175795
	.float -0.643522
	.float -0.040015
	.float 0.600919
	.float -0.819328
	.float 0.622432
	.float -0.104732
	.float -0.523829
	.float 1.029976
	.float -1.248295
	.float 1.137016
	.float -0.779756
	.float 0.335535
	.float 0.037902
	.float -0.249359
	.float 0.296497
	.float -0.238393
	.float 0.140551
	.float -0.030240
	.float -0.107768
	.float 0.293801
	.float -0.504629
	.float 0.658314
	.float -0.657739
	.float 0.471310
	.float -0.189594
	.float -0.000508
	.float -0.073034
	.float 0.438189
	.float -0.927087
	.float 1.252280
	.float -1.172791
	.float 0.644547
	.float 0.144318
	.float -0.876991
	.float 1.283962
	.float -1.281664
	.float 0.992806
	.float -0.645307
	.float 0.421277
	.float -0.354107
	.float 0.334897
	.float -0.216791
	.float -0.058343
	.float 0.399562
	.float -0.615640
	.float 0.540615
	.float -0.150636
	.float -0.408527
	.float 0.902847
	.float -1.145835
	.float 1.097769
	.float -0.864574
	.float 0.603810
	.float -0.410184
	.float 0.264581
	.float -0.080617
	.float -0.193348
	.float 0.501452
	.float -0.699430
	.float 0.655286
	.float -0.355770
	.float -0.065120
	.float 0.402286
	.float -0.509639
	.float 0.394146
	.float -0.207728
	.float 0.141354
	.float -0.291564
	.float 0.589590
	.float -0.842689
	.float 0.863555
	.float -0.602210
	.float 0.189977
	.float 0.136739
	.float -0.182163
	.float -0.092020
	.float 0.553077
	.float -0.985954
	.float 1.216770
	.float -1.192244
	.float 0.980267
	.float -0.711974
	.float 0.510182
	.float -0.438326
	.float 0.481477
	.float -0.558746
	.float 0.564238
	.float -0.426147
	.float 0.157996
	.float 0.133159
	.float -0.299725
	.float 0.245304
	.float 0.002189
	.float -0.291422
	.float 0.432818
	.float -0.319283
	.float 0.003225
	.float 0.326090
	.float -0.456918
	.float 0.291142
	.float 0.086746
	.float -0.456325
	.float 0.597104
	.float -0.425304
	.float 0.039976
	.float 0.351674
	.float -0.574238
	.float 0.587996
	.float -0.485280
	.float 0.393431
	.float -0.369492
	.float 0.370603
	.float -0.314538
	.float 0.167893
	.float 0.018803
	.float -0.156797
	.float 0.200741
	.float -0.191360
	.float 0.221178
	.float -0.352104
	.float 0.554048
	.float -0.717196
	.float 0.731482
	.float -0.574178
	.float 0.337920
	.float -0.174636
	.float 0.193659
	.float -0.387634
	.float 0.640136
	.float -0.806837
	.float 0.807463
	.float -0.662460
	.float 0.456957
	.float -0.271338
	.float 0.134319
	.float -0.023949
	.float -0.099978
	.float 0.262864
	.float -0.457275
	.float 0.639522
	.float -0.740655
	.float 0.697555
	.float -0.497470
	.float 0.205804
	.float 0.055989
	.float -0.179628
	.float 0.136546
	.float 0.014704
	.float -0.187196
	.float 0.334781
	.float -0.466241
	.float 0.595721
	.float -0.687472
	.float 0.662454
	.float -0.469835
	.float 0.155577
	.float 0.146152
	.float -0.303707
	.float 0.286896
	.float -0.188307
	.float 0.149068
	.float -0.252046
	.float 0.467528
	.float -0.683502
	.float 0.780784
	.float -0.690125
	.float 0.404169
	.float 0.033649
	.float -0.532809
	.float 0.955046
	.float -1.141758
	.float 0.985915
	.float -0.513579
	.float -0.091935
	.float 0.562707
	.float -0.683886
	.float 0.409087
	.float 0.122965
	.float -0.676671
	.float 1.048428
	.float -1.152812
	.float 1.025341
	.float -0.763304
	.float 0.459246
	.float -0.169576
	.float -0.076580
	.float 0.252099
	.float -0.318955
	.float 0.241134
	.float -0.016246
	.float -0.297337
	.float 0.583322
	.float -0.711751
	.float 0.607923
	.float -0.304321
	.float -0.064253
	.float 0.329178
	.float -0.381166
	.float 0.228718
	.float 0.015779
	.float -0.210718
	.float 0.270260
	.float -0.207630
	.float 0.116511
	.float -0.108515
	.float 0.244551
	.float -0.494442
	.float 0.742858
	.float -0.840179
	.float 0.679639
	.float -0.265711
	.float -0.265833
	.float 0.699459
	.float -0.847237
	.float 0.654204
	.float -0.233772
	.float -0.198442
	.float 0.456319
	.float -0.494901
	.float 0.424556
	.float -0.417227
	.float 0.572098
	.float -0.838498
	.float 1.051804
	.float -1.054424
	.float 0.812443
	.float -0.443816
	.float 0.140735
	.float -0.043455
	.float 0.153088
	.float -0.339198
	.float 0.432207
	.float -0.337425
	.float 0.096787
	.float 0.140092
	.float -0.215909
	.float 0.071581
	.float 0.213035
	.float -0.472103
	.float 0.563794
	.float -0.459538
	.float 0.250272
	.float -0.071508
	.float 0.010354
	.float -0.065322
	.float 0.180036
	.float -0.308329
	.float 0.447500
	.float -0.612996
	.float 0.785985
	.float -0.891360
	.float 0.836430
	.float -0.585021
	.float 0.207713
	.float 0.136397
	.float -0.280110
	.float 0.140555
	.float 0.233298
	.float -0.683171
	.float 1.017136
	.float -1.095862
	.float 0.887044
	.float -0.466640
	.float -0.026535
	.float 0.453425
	.float -0.721008
	.float 0.795442
	.float -0.691657
	.float 0.461320
	.float -0.188306
	.float -0.021756
	.float 0.074402
	.float 0.065754
	.float -0.346563
	.float 0.648309
	.float -0.843911
	.float 0.857490
	.float -0.684596
	.float 0.375727
	.float -0.012211
	.float -0.306824
	.float 0.478687
	.float -0.433661
	.float 0.184652
	.float 0.153842
	.float -0.414527
	.float 0.475844
	.float -0.340441
	.float 0.130112
	.float 0.002045
	.float 0.025839
	.float -0.182857
	.float 0.364860
	.float -0.470834
	.float 0.454203
	.float -0.323816
	.float 0.116225
	.float 0.125203
	.float -0.351332
	.float 0.503306
	.float -0.522276
	.float 0.373459
	.float -0.068924
	.float -0.326621
	.float 0.709483
	.float -0.963791
	.float 0.995474
	.float -0.769354
	.float 0.339270
	.float 0.148905
	.float -0.500465
	.float 0.557062
	.float -0.285269
	.float -0.187809
	.float 0.626846
	.float -0.810348
	.float 0.653682
	.float -0.256299
	.float -0.159776
	.float 0.383789
	.float -0.338179
	.float 0.111944
	.float 0.111920
	.float -0.179374
	.float 0.051154
	.float 0.203504
	.float -0.486153
	.float 0.745877
	.float -0.987853
	.float 1.216669
	.float -1.381790
	.float 1.392177
	.float -1.199364
	.float 0.875268
	.float -0.602156
	.float 0.561643
	.float -0.797722
	.float 1.161119
	.float -1.387718
	.float 1.264932
	.float -0.772970
	.float 0.103878
	.float 0.451544
	.float -0.669437
	.float 0.502501
	.float -0.075327
	.float -0.408899
	.float 0.772901
	.float -0.919728
	.float 0.831300
	.float -0.547566
	.float 0.155293
	.float 0.220832
	.float -0.452769
	.float 0.473516
	.float -0.332376
	.float 0.186325
	.float -0.210825
	.float 0.478622
	.float -0.892695
	.float 1.231011
	.float -1.281837
	.float 0.979945
	.float -0.448328
	.float -0.083191
	.float 0.422768
	.float -0.520932
	.float 0.464682
	.float -0.377238
	.float 0.309999
	.float -0.213646
	.float 0.007251
	.float 0.318663
	.float -0.657074
	.float 0.841064
	.float -0.761158
	.float 0.451022
	.float -0.073486
	.float -0.184425
	.float 0.230973
	.float -0.120925
	.float 0.009320
	.float -0.046094
	.float 0.281616
	.float -0.636285
	.float 0.943336
	.float -1.035600
	.float 0.831548
	.float -0.381011
	.float -0.150819
	.float 0.556874
	.float -0.687245
	.float 0.524327
	.float -0.191487
	.float -0.114002
	.float 0.229678
	.float -0.117608
	.float -0.116909
	.float 0.290184
	.float -0.253247
	.float -0.012049
	.float 0.373062
	.float -0.621151
	.float 0.603128
	.float -0.330376
	.float -0.008418
	.float 0.150287
	.float 0.079471
	.float -0.646371
	.float 1.308307
	.float -1.745214
	.float 1.740349
	.float -1.303517
	.float 0.661262
	.float -0.120245
	.float -0.114099
	.float 0.052693
	.float 0.101233
	.float -0.103584
	.float -0.148246
	.float 0.526834
	.float -0.749445
	.float 0.574020
	.float 0.018236
	.float -0.787687
	.float 1.379617
	.float -1.546267
	.float 1.288677
	.float -0.822133
	.float 0.404110
	.float -0.161649
	.float 0.042239
	.float 0.093839
	.float -0.330799
	.float 0.620093
	.float -0.819042
	.float 0.801675
	.float -0.552352
	.float 0.179821
	.float 0.146182
	.float -0.285680
	.float 0.192352
	.float 0.075416
	.float -0.391493
	.float 0.624450
	.float -0.698279
	.float 0.625788
	.float -0.497089
	.float 0.425218
	.float -0.476076
	.float 0.624387
	.float -0.766043
	.float 0.783625
	.float -0.626396
	.float 0.355126
	.float -0.121180
	.float 0.087564
	.float -0.333038
	.float 0.791908
	.float -1.266955
	.float 1.516895
	.float -1.379495
	.float 0.865671
	.float -0.166856
	.float -0.438376
	.float 0.733505
	.float -0.683270
	.float 0.447497
	.float -0.275288
	.float 0.341761
	.float -0.631034
	.float 0.943762
	.float -1.028175
	.float 0.751486
	.float -0.199847
	.float -0.359895
	.float 0.633075
	.float -0.467850
	.float -0.061461
	.float 0.702762
	.float -1.166976
	.float 1.271536
	.float -1.009258
	.float 0.521993
	.float -0.013088
	.float -0.346539
	.float 0.477999
	.float -0.406232
	.float 0.229767
	.float -0.064581
	.float -0.013902
	.float 0.003080
	.float 0.039504
	.float -0.047040
	.float -0.002440
	.float 0.069327
	.float -0.088082
	.float 0.027093
	.float 0.076551
	.float -0.138789
	.float 0.092259
	.float 0.057920
	.float -0.229804
	.float 0.316243
	.float -0.255085
	.float 0.070535
	.float 0.139502
	.float -0.260098
	.float 0.226092
	.float -0.061199
	.float -0.132465
	.float 0.231286
	.float -0.162386
	.float -0.052044
	.float 0.308631
	.float -0.487274
	.float 0.522515
	.float -0.431628
	.float 0.283459
	.float -0.138787
	.float 0.014277
	.float 0.102157
	.float -0.205940
	.float 0.250787
	.float -0.175854
	.float -0.034592
	.float 0.315044
	.float -0.546979
	.float 0.636187
	.float -0.577397
	.float 0.451806
	.float -0.358819
	.float 0.338528
	.float -0.347117
	.float 0.301158
	.float -0.152076
	.float -0.067292
	.float 0.254771
	.float -0.297998
	.float 0.142045
	.float 0.171729
	.float -0.514748
	.float 0.726656
	.float -0.695415
	.float 0.424192
	.float -0.044445
	.float -0.243067
	.float 0.274532
	.float -0.015594
	.float -0.418291
	.float 0.826514
	.float -1.030408
	.float 0.956993
	.float -0.658320
	.float 0.272017
	.float 0.042628
	.float -0.163689
	.float 0.050178
	.float 0.235778
	.float -0.541858
	.float 0.686968
	.float -0.556504
	.float 0.180099
	.float 0.266447
	.float -0.551527
	.float 0.521916
	.float -0.196031
	.float -0.244504
	.float 0.558680
	.float -0.576759
	.float 0.279369
	.float 0.212614
	.float -0.715545
	.float 1.071079
	.float -1.196238
	.float 1.083499
	.float -0.773581
	.float 0.332027
	.float 0.157571
	.float -0.594943
	.float 0.878982
	.float -0.942883
	.float 0.789935
	.float -0.500197
	.float 0.192793
	.float 0.040138
	.float -0.186693
	.float 0.316967
	.float -0.525621
	.float 0.849842
	.float -1.220129
	.float 1.486080
	.float -1.509315
	.float 1.262926
	.float -0.861689
	.float 0.490332
	.float -0.275102
	.float 0.196035
	.float -0.115212
	.float -0.094761
	.float 0.424928
	.float -0.715375
	.float 0.771190
	.float -0.517722
	.float 0.068286
	.float 0.350050
	.float -0.549902
	.float 0.494361
	.float -0.288112
	.float 0.075020
	.float 0.063100
	.float -0.130075
	.float 0.162149
	.float -0.162902
	.float 0.090540
	.float 0.094467
	.float -0.370207
	.float 0.641430
	.float -0.791148
	.float 0.755892
	.float -0.564668
	.float 0.313107
	.float -0.098876
	.float -0.026572
	.float 0.056439
	.float 0.005606
	.float -0.165676
	.float 0.419039
	.float -0.710606
	.float 0.926622
	.float -0.945208
	.float 0.719265
	.float -0.329032
	.float -0.043939
	.float 0.213381
	.float -0.096521
	.float -0.235254
	.float 0.595817
	.float -0.790110
	.float 0.723381
	.float -0.449163
	.float 0.127813
	.float 0.079045
	.float -0.112680
	.float 0.052584
	.float -0.056820
	.float 0.243103
	.float -0.589724
	.float 0.929113
	.float -1.048568
	.float 0.839023
	.float -0.390596
	.float -0.039742
	.float 0.180348
	.float 0.078435
	.float -0.604967
	.float 1.104657
	.float -1.305815
	.float 1.124903
	.float -0.699808
	.float 0.279385
	.float -0.060673
	.float 0.089956
	.float -0.279935
	.float 0.502003
	.float -0.669589
	.float 0.759081
	.float -0.778284
	.float 0.730090
	.float -0.606209
	.float 0.408822
	.float -0.171080
	.float -0.047247
	.float 0.188942
	.float -0.230808
	.float 0.192116
	.float -0.112281
	.float 0.015932
	.float 0.102729
	.float -0.259107
	.float 0.437256
	.float -0.570006
	.float 0.568396
	.float -0.384936
	.float 0.059366
	.float 0.296047
	.float -0.564084
	.float 0.689806
	.float -0.694840
	.float 0.634136
	.float -0.539700
	.float 0.402372
	.float -0.202375
	.float -0.046946
	.float 0.288494
	.float -0.456536
	.float 0.527495
	.float -0.539957
	.float 0.563428
	.float -0.637725
	.float 0.730668
	.float -0.749645
	.float 0.603092
	.float -0.270614
	.float -0.168920
	.float 0.573925
	.float -0.819778
	.float 0.868374
	.float -0.779097
	.float 0.653560
	.float -0.554752
	.float 0.462429
	.float -0.301507
	.float 0.024423
	.float 0.316475
	.float -0.569818
	.float 0.570244
	.float -0.253863
	.float -0.278699
	.float 0.801982
	.float -1.087561
	.float 1.030005
	.float -0.696142
	.float 0.270781
	.float 0.059939
	.float -0.209179
	.float 0.214262
	.float -0.180682
	.float 0.191951
	.float -0.247754
	.float 0.267069
	.float -0.148532
	.float -0.152296
	.float 0.575585
	.float -0.966974
	.float 1.144116
	.float -0.990940
	.float 0.533236
	.float 0.052138
	.float -0.514450
	.float 0.663476
	.float -0.484666
	.float 0.155730
	.float 0.060414
	.float 0.013904
	.float -0.349642
	.float 0.726439
	.float -0.880743
	.float 0.687704
	.float -0.252078
	.float -0.154858
	.float 0.269028
	.float -0.001527
	.float -0.506376
	.float 0.969567
	.float -1.124826
	.float 0.872338
	.float -0.314976
	.float -0.314279
	.float 0.781959
	.float -0.961097
	.float 0.859561
	.float -0.569413
	.float 0.188628
	.float 0.221672
	.float -0.618048
	.float 0.927370
	.float -1.036142
	.float 0.850694
	.float -0.391479
	.float -0.164123
	.float 0.550972
	.float -0.570456
	.float 0.224531
	.float 0.275071
	.float -0.638899
	.float 0.682584
	.float -0.429623
	.float 0.065075
	.float 0.214604
	.float -0.335067
	.float 0.363358
	.float -0.414494
	.float 0.536425
	.float -0.671255
	.float 0.713894
	.float -0.603914
	.float 0.366729
	.float -0.079227
	.float -0.191906
	.float 0.414199
	.float -0.562355
	.float 0.588431
	.float -0.442972
	.float 0.141736
	.float 0.189685
	.float -0.358884
	.float 0.229717
	.float 0.164204
	.float -0.615380
	.float 0.867519
	.float -0.782969
	.float 0.423835
	.float 0.015304
	.float -0.364359
	.float 0.592171
	.float -0.786978
	.float 1.030122
	.float -1.283700
	.float 1.397232
	.float -1.230692
	.float 0.789452
	.float -0.255021
	.float -0.117850
	.float 0.162762
	.float 0.093382
	.float -0.450435
	.float 0.660105
	.float -0.571693
	.float 0.210093
	.float 0.252799
	.float -0.606630
	.float 0.720642
	.float -0.602040
	.float 0.366449
	.float -0.148011
	.float 0.010566
	.float 0.083539
	.float -0.232112
	.float 0.510366
	.float -0.904033
	.float 1.302474
	.float -1.556478
	.float 1.564058
	.float -1.329352
	.float 0.958382
	.float -0.595524
	.float 0.341618
	.float -0.204663
	.float 0.111379
	.float 0.031363
	.float -0.267125
	.float 0.557902
	.float -0.808053
	.float 0.924643
	.float -0.870830
	.float 0.679171
	.float -0.424452
	.float 0.184729
	.float -0.018014
	.float -0.042657
	.float -0.007936
	.float 0.137918
	.float -0.277466
	.float 0.346679
	.float -0.307274
	.float 0.199528
	.float -0.125227
	.float 0.177868
	.float -0.370085
	.float 0.616671
	.float -0.789955
	.float 0.806810
	.float -0.683103
	.float 0.518187
	.float -0.425140
	.float 0.457946
	.float -0.583567
	.float 0.710633
	.float -0.747776
	.float 0.649590
	.float -0.424726
	.float 0.113528
	.float 0.235425
	.float -0.570190
	.float 0.830281
	.float -0.957288
	.float 0.929629
	.float -0.793595
	.float 0.648475
	.float -0.578253
	.float 0.578050
	.float -0.544442
	.float 0.353642
	.float 0.026734
	.float -0.484782
	.float 0.822586
	.float -0.888388
	.float 0.684375
	.float -0.370523
	.float 0.163787
	.float -0.205068
	.float 0.480949
	.float -0.840847
	.float 1.087946
	.float -1.085445
	.float 0.822225
	.float -0.410980
	.float 0.026556
	.float 0.182125
	.float -0.161485
	.float -0.031013
	.float 0.272144
	.float -0.450182
	.float 0.525266
	.float -0.534687
	.float 0.543626
	.float -0.580741
	.float 0.608963
	.float -0.555130
	.float 0.377104
	.float -0.115812
	.float -0.112508
	.float 0.187794
	.float -0.075890
	.float -0.129155
	.float 0.250651
	.float -0.143744
	.float -0.194798
	.float 0.601822
	.float -0.835470
	.float 0.723401
	.float -0.272442
	.float -0.334549
	.float 0.850241
	.float -1.103203
	.float 1.075335
	.float -0.877808
	.float 0.659044
	.float -0.515132
	.float 0.452671
	.float -0.408873
	.float 0.301373
	.float -0.078695
	.float -0.245512
	.float 0.585287
	.float -0.812458
	.float 0.822538
	.float -0.606585
	.float 0.278713
	.float -0.025844
	.float -0.001149
	.float -0.214459
	.float 0.537674
	.float -0.761119
	.float 0.730212
	.float -0.434499
	.float 0.011413
	.float 0.333601
	.float -0.440126
	.float 0.275857
	.float 0.051911
	.float -0.358327
	.float 0.480133
	.float -0.356339
	.float 0.046981
	.float 0.315098
	.float -0.603247
	.float 0.753922
	.float -0.769956
	.float 0.680328
	.float -0.498579
	.float 0.218043
	.float 0.152838
	.float -0.549968
	.float 0.851964
	.float -0.932526
	.float 0.737612
	.float -0.334391
	.float -0.106106
	.float 0.387428
	.float -0.385315
	.float 0.112644
	.float 0.281556
	.float -0.580718
	.float 0.608108
	.float -0.322987
	.float -0.145204
	.float 0.551306
	.float -0.656773
	.float 0.356372
	.float 0.262060
	.float -0.958951
	.float 1.461461
	.float -1.591719
	.float 1.337402
	.float -0.833074
	.float 0.271650
	.float 0.198331
	.float -0.529385
	.float 0.756851
	.float -0.926962
	.float 1.031224
	.float -1.001780
	.float 0.774689
	.float -0.369930
	.float -0.080871
	.float 0.390352
	.float -0.420967
	.float 0.167242
	.float 0.240229
	.float -0.607712
	.float 0.776278
	.float -0.686918
	.float 0.386540
	.float 0.011566
	.float -0.380966
	.float 0.625258
	.float -0.702929
	.float 0.633570
	.float -0.485241
	.float 0.344027
	.float -0.277129
	.float 0.308142
	.float -0.417343
	.float 0.561485
	.float -0.693430
	.float 0.767590
	.float -0.736569
	.float 0.557881
	.float -0.219227
	.float -0.231795
	.float 0.681836
	.float -0.985462
	.float 1.026619
	.float -0.775002
	.float 0.307128
	.float 0.217994
	.float -0.617115
	.float 0.751358
	.float -0.579654
	.float 0.176015
	.float 0.299534
	.float -0.667512
	.float 0.803689
	.float -0.685246
	.float 0.386698
	.float -0.035197
	.float -0.244916
	.float 0.371453
	.float -0.323017
	.float 0.144802
	.float 0.058994
	.float -0.160287
	.float 0.073652
	.float 0.177265
	.float -0.449973
	.float 0.561160
	.float -0.414500
	.float 0.085339
	.float 0.214451
	.float -0.280487
	.float 0.067222
	.float 0.269543
	.float -0.476723
	.float 0.381437
	.float -0.012596
	.float -0.418923
	.float 0.661944
	.float -0.582926
	.float 0.234113
	.float 0.200116
	.float -0.523537
	.float 0.627648
	.float -0.518912
	.float 0.284478
	.float -0.040356
	.float -0.106018
	.float 0.079365
	.float 0.140644
	.float -0.499747
	.float 0.874210
	.float -1.115843
	.float 1.120695
	.float -0.878809
	.float 0.469442
	.float -0.006586
	.float -0.423003
	.float 0.784376
	.float -1.071726
	.float 1.268857
	.float -1.333709
	.float 1.219939
	.float -0.913809
	.float 0.452876
	.float 0.085438
	.float -0.609118
	.float 1.028151
	.float -1.260244
	.float 1.244411
	.float -0.975063
	.float 0.539229
	.float -0.114956
	.float -0.096812
	.float -0.015746
	.float 0.390149
	.float -0.800390
	.float 0.974056
	.float -0.749293
	.float 0.172559
	.float 0.524437
	.float -1.048952
	.float 1.192652
	.float -0.918387
	.float 0.359319
	.float 0.248116
	.float -0.657691
	.float 0.704192
	.float -0.370338
	.float -0.195617
	.float 0.735371
	.float -1.001321
	.float 0.884827
	.float -0.471197
	.float -0.021548
	.float 0.382916
	.float -0.531400
	.float 0.532631
	.float -0.509833
	.float 0.525683
	.float -0.532863
	.float 0.429256
	.float -0.165007
	.float -0.193790
	.float 0.500632
	.float -0.634026
	.float 0.583606
	.float -0.445687
	.float 0.334865
	.float -0.290578
	.float 0.259897
	.float -0.169877
	.float 0.022505
	.float 0.076601
	.float 0.010593
	.float -0.335428
	.float 0.792113
	.float -1.158124
	.float 1.223172
	.float -0.918616
	.float 0.360416
	.float 0.216717
	.float -0.584369
	.float 0.625618
	.float -0.369656
	.float -0.044189
	.float 0.436826
	.float -0.656603
	.float 0.624897
	.float -0.356288
	.float -0.047541
	.float 0.434454
	.float -0.665861
	.float 0.685082
	.float -0.550135
	.float 0.399103
	.float -0.355469
	.float 0.431256
	.float -0.503044
	.float 0.395559
	.float -0.026571
	.float -0.492370
	.float 0.888266
	.float -0.889548
	.float 0.416449
	.float 0.334757
	.float -0.980679
	.float 1.163992
	.float -0.759066
	.float -0.054943
	.float 0.894558
	.float -1.382031
	.float 1.343107
	.float -0.883792
	.float 0.309853
	.float 0.060620
	.float -0.083063
	.float -0.137628
	.float 0.327875
	.float -0.234340
	.float -0.200746
	.float 0.798325
	.float -1.267257
	.float 1.407312
	.float -1.239833
	.float 0.968047
	.float -0.800485
	.float 0.779777
	.float -0.753203
	.float 0.507088
	.float 0.041805
	.float -0.746119
	.float 1.294474
	.float -1.398472
	.float 0.974259
	.float -0.203825
	.float -0.557485
	.float 0.969052
	.float -0.880660
	.float 0.400554
	.float 0.176494
	.float -0.535587
	.float 0.507121
	.float -0.140747
	.float -0.344584
	.float 0.694437
	.float -0.753987
	.float 0.533563
	.float -0.182097
	.float -0.103203
	.float 0.179536
	.float -0.026417
	.float -0.248391
	.float 0.466497
	.float -0.473382
	.float 0.222823
	.float 0.195323
	.float -0.599897
	.float 0.809093
	.float -0.724138
	.float 0.365656
	.float 0.144268
	.float -0.632277
	.float 0.931239
	.float -0.931975
	.float 0.621639
	.float -0.096995
	.float -0.462309
	.float 0.861499
	.float -0.974187
	.float 0.799260
	.float -0.457213
	.float 0.124509
	.float 0.058976
	.float -0.057482
	.float -0.056604
	.float 0.162932
	.float -0.178771
	.float 0.113820
	.float -0.057151
	.float 0.104807
	.float -0.278858
	.float 0.497491
	.float -0.621723
	.float 0.549229
	.float -0.289533
	.float -0.033755
	.float 0.256617
	.float -0.272952
	.float 0.090777
	.float 0.187307
	.float -0.437065
	.float 0.584649
	.float -0.631996
	.float 0.629219
	.float -0.621678
	.float 0.608731
	.float -0.537700
	.float 0.336322
	.float 0.030702
	.float -0.510364
	.float 0.951622
	.float -1.161873
	.float 1.013413
	.float -0.538469
	.float -0.062116
	.float 0.523341
	.float -0.676724
	.float 0.555446
	.float -0.361450
	.float 0.312496
	.float -0.480922
	.float 0.744485
	.float -0.882922
	.float 0.742953
	.float -0.347678
	.float -0.123219
	.float 0.457600
	.float -0.545396
	.float 0.434731
	.float -0.283531
	.float 0.249461
	.float -0.391610
	.float 0.640598
	.float -0.845419
	.float 0.860491
	.float -0.618945
	.float 0.156798
	.float 0.411087
	.float -0.939322
	.float 1.300033
	.float -1.420596
	.float 1.306491
	.float -1.039126
	.float 0.739791
	.float -0.509949
	.float 0.382633
	.float -0.320433
	.float 0.261671
	.float -0.176801
	.float 0.088904
	.float -0.044896
	.float 0.067010
	.float -0.128402
	.float 0.170403
	.float -0.142862
	.float 0.033431
	.float 0.132332
	.float -0.312451
	.float 0.470741
	.float -0.584798
	.float 0.639832
	.float -0.619172
	.float 0.503899
	.float -0.287570
	.float -0.000945
	.float 0.286237
	.float -0.465859
	.float 0.460840
	.float -0.267612
	.float -0.029607
	.float 0.302303
	.float -0.448072
	.float 0.433995
	.float -0.283577
	.float 0.030803
	.float 0.304389
	.float -0.692700
	.float 1.054585
	.float -1.260655
	.float 1.197031
	.float -0.852718
	.float 0.354336
	.float 0.089641
	.float -0.300494
	.float 0.220128
	.float 0.073620
	.float -0.422183
	.float 0.665458
	.float -0.701725
	.float 0.514632
	.float -0.172151
	.float -0.199561
	.float 0.467874
	.float -0.556653
	.float 0.484821
	.float -0.347669
	.float 0.246647
	.float -0.218332
	.float 0.219814
	.float -0.182082
	.float 0.082730
	.float 0.029252
	.float -0.081111
	.float 0.053049
	.float -0.010264
	.float 0.052675
	.float -0.219541
	.float 0.433295
	.float -0.541790
	.float 0.436648
	.float -0.153419
	.float -0.136880
	.float 0.251036
	.float -0.138922
	.float -0.069481
	.float 0.161628
	.float -0.012372
	.float -0.308020
	.float 0.573910
	.float -0.560954
	.float 0.200640
	.float 0.375128
	.float -0.916163
	.float 1.191186
	.float -1.089391
	.float 0.643444
	.float 0.008490
	.float -0.679657
	.float 1.184790
	.float -1.381772
	.float 1.209072
	.float -0.711304
	.float 0.035884
	.float 0.608919
	.float -1.025693
	.float 1.102478
	.float -0.858068
	.float 0.433217
	.float -0.025427
	.float -0.205890
	.float 0.214019
	.float -0.074740
	.float -0.075981
	.float 0.134536
	.float -0.089279
	.float 0.010723
	.float 0.010799
	.float 0.072236
	.float -0.243834
	.float 0.447154
	.float -0.621076
	.float 0.723366
	.float -0.736322
	.float 0.666454
	.float -0.543339
	.float 0.409391
	.float -0.294179
	.float 0.185848
	.float -0.028050
	.float -0.239688
	.float 0.617288
	.float -1.006185
	.float 1.242832
	.float -1.197534
	.float 0.874145
	.float -0.430967
	.float 0.092982
	.float -0.008491
	.float 0.152087
	.float -0.348307
	.float 0.402149
	.float -0.242233
	.float -0.028948
	.float 0.213651
	.float -0.167535
	.float -0.092225
	.float 0.397019
	.float -0.544421
	.float 0.434609
	.float -0.129319
	.float -0.200413
	.float 0.389500
	.float -0.372353
	.float 0.199442
	.float 0.015730
	.float -0.169662
	.float 0.214964
	.float -0.165057
	.float 0.071015
	.float 0.008565
	.float -0.032417
	.float -0.008512
	.float 0.087750
	.float -0.152870
	.float 0.146260
	.float -0.031682
	.float -0.182457
	.float 0.433876
	.float -0.620310
	.float 0.638208
	.float -0.433333
	.float 0.037843
	.float 0.431354
	.float -0.818314
	.float 0.995918
	.float -0.917996
	.float 0.628614
	.float -0.229955
	.float -0.163805
	.float 0.459019
	.float -0.594753
	.float 0.548421
	.float -0.347719
	.float 0.081385
	.float 0.114512
	.float -0.108282
	.float -0.155278
	.float 0.605986
	.float -1.060993
	.float 1.302852
	.float -1.186414
	.float 0.717879
	.float -0.062224
	.float -0.529746
	.float 0.841359
	.float -0.796626
	.float 0.495986
	.float -0.158296
	.float -0.001692
	.float -0.107319
	.float 0.405290
	.float -0.690974
	.float 0.760327
	.float -0.523114
	.float 0.053303
	.float 0.451323
	.float -0.772248
	.float 0.777956
	.float -0.482636
	.float 0.032722
	.float 0.366896
	.float -0.550743
	.float 0.470017
	.float -0.211885
	.float -0.050841
	.float 0.153959
	.float -0.025720
	.float -0.288109
	.float 0.663962
	.float -0.966184
	.float 1.092294
	.float -0.986163
	.float 0.643796
	.float -0.130866
	.float -0.407016
	.float 0.780948
	.float -0.848811
	.float 0.604970
	.float -0.195042
	.float -0.168730
	.float 0.335255
	.float -0.293853
	.float 0.154231
	.float -0.054788
	.float 0.072683
	.float -0.192372
	.float 0.336614
	.float -0.424127
	.float 0.414610
	.float -0.322236
	.float 0.200211
	.float -0.108567
	.float 0.080418
	.float -0.102030
	.float 0.118652
	.float -0.066550
	.float -0.083956
	.float 0.300291
	.float -0.494558
	.float 0.565490
	.float -0.453279
	.float 0.176173
	.float 0.171218
	.float -0.456962
	.float 0.570435
	.float -0.475593
	.float 0.235156
	.float 0.011331
	.float -0.115559
	.float 0.005521
	.float 0.265168
	.float -0.546073
	.float 0.689189
	.float -0.650642
	.float 0.514956
	.float -0.417552
	.float 0.426711
	.float -0.484511
	.float 0.458333
	.float -0.259220
	.float -0.075358
	.float 0.404539
	.float -0.589876
	.float 0.590684
	.float -0.470094
	.float 0.316210
	.float -0.157942
	.float -0.044228
	.float 0.324242
	.float -0.624691
	.float 0.787139
	.float -0.644517
	.float 0.153176
	.float 0.538848
	.float -1.149337
	.float 1.414635
	.float -1.236728
	.float 0.728859
	.float -0.136680
	.float -0.305731
	.float 0.492305
	.float -0.471415
	.float 0.383068
	.float -0.357600
	.float 0.438263
	.float -0.568307
	.float 0.641799
	.float -0.581513
	.float 0.391210
	.float -0.148688
	.float -0.051018
	.float 0.156268
	.float -0.177498
	.float 0.157389
	.float -0.128200
	.float 0.095866
	.float -0.055797
	.float 0.009689
	.float 0.043018
	.float -0.126893
	.float 0.286681
	.float -0.540940
	.float 0.829342
	.float -1.015127
	.float 0.965177
	.float -0.654854
	.float 0.207284
	.float 0.179179
	.float -0.366616
	.float 0.369209
	.float -0.326585
	.float 0.383697
	.float -0.578119
	.float 0.823667
	.float -0.993280
	.float 1.022307
	.float -0.944832
	.float 0.840340
	.float -0.746074
	.float 0.616307
	.float -0.367259
	.float -0.027441
	.float 0.471698
	.float -0.775187
	.float 0.768264
	.float -0.425358
	.float -0.098230
	.float 0.552591
	.float -0.747356
	.float 0.662627
	.float -0.436999
	.float 0.247989
	.float -0.182893
	.float 0.199443
	.float -0.197660
	.float 0.133416
	.float -0.076028
	.float 0.163061
	.float -0.488397
	.float 1.007258
	.float -1.526659
	.float 1.790868
	.float -1.615286
	.float 0.997813
	.float -0.146839
	.float -0.597316
	.float 0.921105
	.float -0.701641
	.float 0.082369
	.float 0.598743
	.float -1.001750
	.float 0.986523
	.float -0.690443
	.float 0.423513
	.float -0.446927
	.float 0.787514
	.float -1.218600
	.float 1.420742
	.float -1.207638
	.float 0.657852
	.float -0.061112
	.float -0.281041
	.float 0.260352
	.float -0.030971
	.float -0.103735
	.float -0.091923
	.float 0.614319
	.float -1.211796
	.float 1.545150
	.float -1.409416
	.float 0.867686
	.float -0.208740
	.float -0.240703
	.float 0.321029
	.float -0.125649
	.float -0.084183
	.float 0.069705
	.float 0.223557
	.float -0.639826
	.float 0.930735
	.float -0.926938
	.float 0.645996
	.float -0.273449
	.float 0.043379
	.float -0.103932
	.float 0.447300
	.float -0.929778
	.float 1.351243
	.float -1.541555
	.float 1.416635
	.float -0.996350
	.float 0.393741
	.float 0.216075
	.float -0.647093
	.float 0.769420
	.float -0.571001
	.float 0.177762
	.float 0.194410
	.float -0.344882
	.float 0.195375
	.float 0.170382
	.float -0.566268
	.float 0.826782
	.float -0.907186
	.float 0.888376
	.float -0.887530
	.float 0.952230
	.float -1.029120
	.float 1.031209
	.float -0.938424
	.float 0.834108
	.float -0.839896
	.float 1.007121
	.float -1.264467
	.float 1.469341
	.float -1.514674
	.float 1.395953
	.float -1.187651
	.float 0.964441
	.float -0.747230
	.float 0.517979
	.float -0.275230
	.float 0.067184
	.float 0.031198
	.float 0.026660
	.float -0.222537
	.float 0.483602
	.float -0.724930
	.float 0.888937
	.float -0.958656
	.float 0.946090
	.float -0.870798
	.float 0.742640
	.float -0.556799
	.float 0.305501
	.float -0.003824
	.float -0.287808
	.float 0.471471
	.float -0.463192
	.float 0.262978
	.float 0.014704
	.float -0.194764
	.float 0.160566
	.float 0.049362
	.float -0.257494
	.float 0.284366
	.float -0.107256
	.float -0.095655
	.float 0.070240
	.float 0.304228
	.float -0.885903
	.float 1.332532
	.float -1.320243
	.float 0.763912
	.float 0.114675
	.float -0.911129
	.float 1.264610
	.float -1.041116
	.float 0.377441
	.float 0.415710
	.float -1.017273
	.float 1.235756
	.float -1.066468
	.float 0.657056
	.float -0.214565
	.float -0.093398
	.float 0.197016
	.float -0.125021
	.float -0.036496
	.float 0.193560
	.float -0.276414
	.float 0.250761
	.float -0.120136
	.float -0.072753
	.float 0.253299
	.float -0.342948
	.float 0.304309
	.float -0.175609
	.float 0.060419
	.float -0.066184
	.float 0.228317
	.float -0.478923
	.float 0.692226
	.float -0.777607
	.float 0.745713
	.float -0.689555
	.float 0.694008
	.float -0.752583
	.float 0.769414
	.float -0.649373
	.float 0.397532
	.float -0.135154
	.float 0.010351
	.float -0.076834
	.float 0.245805
	.float -0.355549
	.float 0.301924
	.float -0.120623
	.float -0.046324
	.float 0.069021
	.float 0.068008
	.float -0.263695
	.float 0.395589
	.float -0.428004
	.float 0.439783
	.float -0.548153
	.float 0.791756
	.float -1.070334
	.float 1.193418
	.float -1.005038
	.float 0.494102
	.float 0.187856
	.float -0.809761
	.float 1.183622
	.float -1.245514
	.float 1.053631
	.float -0.723968
	.float 0.360184
	.float -0.022587
	.float -0.259629
	.float 0.461281
	.float -0.550862
	.float 0.505672
	.float -0.337058
	.float 0.101846
	.float 0.113915
	.float -0.232965
	.float 0.225645
	.float -0.125741
	.float 0.012432
	.float 0.032033
	.float 0.035240
	.float -0.198805
	.float 0.396799
	.float -0.552752
	.float 0.608910
	.float -0.547998
	.float 0.400015
	.float -0.234842
	.float 0.140921
	.float -0.191221
	.float 0.406754
	.float -0.736900
	.float 1.074286
	.float -1.303019
	.float 1.354480
	.float -1.235309
	.float 1.009133
	.float -0.747740
	.float 0.490463
	.float -0.241462
	.float 0.000863
	.float 0.204364
	.float -0.322058
	.float 0.309990
	.float -0.173281
	.float -0.030150
	.float 0.223876
	.float -0.360985
	.float 0.449151
	.float -0.534273
	.float 0.654884
	.float -0.800152
	.float 0.901157
	.float -0.864065
	.float 0.627079
	.float -0.207390
	.float -0.290501
	.float 0.711864
	.float -0.914086
	.float 0.823363
	.float -0.463007
	.float -0.051008
	.float 0.541787
	.float -0.826436
	.float 0.788191
	.float -0.443559
	.float -0.037197
	.float 0.392093
	.float -0.402325
	.float 0.029823
	.float 0.535599
	.float -0.967940
	.float 0.992723
	.float -0.555348
	.float -0.140639
	.float 0.753606
	.float -1.005780
	.float 0.838114
	.float -0.424782
	.float 0.049409
	.float 0.068285
	.float 0.113414
	.float -0.461028
	.float 0.764103
	.float -0.858092
	.float 0.702675
	.float -0.385974
	.float 0.066686
	.float 0.109985
	.float -0.082530
	.float -0.101460
	.float 0.315945
	.float -0.428425
	.float 0.373971
	.float -0.188104
	.float -0.023180
	.float 0.156602
	.float -0.178033
	.float 0.134427
	.float -0.102424
	.float 0.114671
	.float -0.125954
	.float 0.052641
	.float 0.140817
	.float -0.379804
	.float 0.501956
	.float -0.360532
	.float -0.060840
	.float 0.608582
	.float -1.032050
	.float 1.128671
	.float -0.869883
	.float 0.425599
	.float -0.066855
	.float 0.001525
	.float -0.241764
	.float 0.587629
	.float -0.744795
	.float 0.509776
	.float 0.091154
	.float -0.800962
	.float 1.273745
	.float -1.271340
	.float 0.790492
	.float -0.045807
	.float -0.666919
	.float 1.125660
	.float -1.257451
	.float 1.109834
	.float -0.774522
	.float 0.339264
	.float 0.105864
	.float -0.448155
	.float 0.573752
	.float -0.436680
	.float 0.117167
	.float 0.198148
	.float -0.321372
	.float 0.183817
	.float 0.119344
	.float -0.394739
	.float 0.477277
	.float -0.326621
	.float 0.035606
	.float 0.238543
	.float -0.362902
	.float 0.284021
	.float -0.033417
	.float -0.302643
	.float 0.625901
	.float -0.863457
	.float 0.986064
	.float -1.001047
	.float 0.927313
	.float -0.775491
	.float 0.552296
	.float -0.283571
	.float 0.024712
	.float 0.166027
	.float -0.276288
	.float 0.360738
	.float -0.498451
	.float 0.708395
	.float -0.897050
	.float 0.899577
	.float -0.600132
	.float 0.040500
	.float 0.577716
	.float -1.010778
	.float 1.124546
	.float -0.963532
	.float 0.689198
	.float -0.447792
	.float 0.281049
	.float -0.145302
	.float 0.003141
	.float 0.110036
	.float -0.108828
	.float -0.057192
	.float 0.344819
	.float -0.646991
	.float 0.886579
	.float -1.085025
	.float 1.335110
	.float -1.692829
	.float 2.081169
	.float -2.298433
	.float 2.142695
	.float -1.565917
	.float 0.738590
	.float 0.032672
	.float -0.482094
	.float 0.532389
	.float -0.314264
	.float 0.058053
	.float 0.053008
	.float 0.034654
	.float -0.260998
	.float 0.524023
	.float -0.738071
	.float 0.848328
	.float -0.822299
	.float 0.652150
	.float -0.372156
	.float 0.063086
	.float 0.179547
	.float -0.299013
	.float 0.308297
	.float -0.267821
	.float 0.227328
	.float -0.184785
	.float 0.101238
	.float 0.043862
	.float -0.213636
	.float 0.334102
	.float -0.357629
	.float 0.306708
	.float -0.250651
	.float 0.233066
	.float -0.220305
	.float 0.126150
	.float 0.102134
	.float -0.411218
	.float 0.650010
	.float -0.660475
	.float 0.386623
	.float 0.074043
	.float -0.508855
	.float 0.694464
	.float -0.511574
	.float 0.014698
	.float 0.578086
	.float -0.979409
	.float 0.974250
	.float -0.538529
	.float -0.137791
	.float 0.746563
	.float -1.025484
	.float 0.892984
	.float -0.474413
	.float 0.013183
	.float 0.269713
	.float -0.282443
	.float 0.084562
	.float 0.170842
	.float -0.330918
	.float 0.321065
	.float -0.171566
	.float -0.013898
	.float 0.126424
	.float -0.117035
	.float 0.020746
	.float 0.073284
	.float -0.085352
	.float 0.000137
	.float 0.123323
	.float -0.193322
	.float 0.151536
	.float -0.019249
	.float -0.108723
	.float 0.121283
	.float 0.036299
	.float -0.323458
	.float 0.626825
	.float -0.830239
	.float 0.884707
	.float -0.831470
	.float 0.765742
	.float -0.769852
	.float 0.860688
	.float -0.980148
	.float 1.027150
	.float -0.909758
	.float 0.594171
	.float -0.133533
	.float -0.337654
	.float 0.651918
	.float -0.690288
	.float 0.458101
	.float -0.102363
	.float -0.158922
	.float 0.167513
	.float 0.064334
	.float -0.344796
	.float 0.415430
	.float -0.121375
	.float -0.472613
	.float 1.100675
	.float -1.441304
	.float 1.298155
	.float -0.705459
	.float -0.097759
	.float 0.795669
	.float -1.142587
	.float 1.051635
	.float -0.598422
	.float -0.037667
	.float 0.651185
	.float -1.074909
	.float 1.216964
	.float -1.070716
	.float 0.701400
	.float -0.217748
	.float -0.259649
	.float 0.621768
	.float -0.784403
	.float 0.700884
	.float -0.383664
	.float -0.072239
	.float 0.491327
	.float -0.671872
	.float 0.485626
	.float 0.030544
	.float -0.662198
	.float 1.116543
	.float -1.186167
	.float 0.873671
	.float -0.389181
	.float 0.019354
	.float 0.043383
	.float 0.201195
	.float -0.589248
	.float 0.910009
	.float -1.024480
	.float 0.916977
	.float -0.669729
	.float 0.397890
	.float -0.191235
	.float 0.087590
	.float -0.077653
	.float 0.125675
	.float -0.189033
	.float 0.228119
	.float -0.209529
	.float 0.113013
	.float 0.053414
	.float -0.241493
	.float 0.373807
	.float -0.384758
	.float 0.269545
	.float -0.101720
	.float -0.004620
	.float -0.030824
	.float 0.195840
	.float -0.389613
	.float 0.490689
	.float -0.441416
	.float 0.286724
	.float -0.138607
	.float 0.092537
	.float -0.156922
	.float 0.246536
	.float -0.243713
	.float 0.084047
	.float 0.192335
	.float -0.457365
	.float 0.567398
	.float -0.444614
	.float 0.118206
	.float 0.295520
	.float -0.656708
	.float 0.868848
	.float -0.913433
	.float 0.841532
	.float -0.736262
	.float 0.669878
	.float -0.673523
	.float 0.727681
	.float -0.775017
	.float 0.750452
	.float -0.615336
	.float 0.376803
	.float -0.080417
	.float -0.216159
	.float 0.465770
	.float -0.633865
	.float 0.687034
	.float -0.592359
	.float 0.342411
	.float 0.009346
	.float -0.339651
	.float 0.498567
	.float -0.390456
	.float 0.043087
	.float 0.387553
	.float -0.690917
	.float 0.714907
	.float -0.448990
	.float 0.024608
	.float 0.365486
	.float -0.573141
	.float 0.558292
	.float -0.379989
	.float 0.138455
	.float 0.081609
	.float -0.235133
	.float 0.313551
	.float -0.336867
	.float 0.348676
	.float -0.402280
	.float 0.528887
	.float -0.704142
	.float 0.846137
	.float -0.861099
	.float 0.711554
	.float -0.454724
	.float 0.213870
	.float -0.096708
	.float 0.120197
	.float -0.202246
	.float 0.232292
	.float -0.168334
	.float 0.080007
	.float -0.093602
	.float 0.274409
	.float -0.542404
	.float 0.704040
	.float -0.594499
	.float 0.226649
	.float 0.180402
	.float -0.337633
	.float 0.099317
	.float 0.408503
	.float -0.854363
	.float 0.927042
	.float -0.559866
	.float -0.012185
	.float 0.405701
	.float -0.343600
	.float -0.164851
	.float 0.832937
	.float -1.273858
	.float 1.223837
	.float -0.678951
	.float -0.115349
	.float 0.797833
	.float -1.071452
	.float 0.845514
	.float -0.277573
	.float -0.307286
	.float 0.586869
	.float -0.416002
	.float -0.097030
	.float 0.663205
	.float -0.992273
	.float 0.962039
	.float -0.665831
	.float 0.314973
	.float -0.077516
	.float -0.024751
	.float 0.093941
	.float -0.242689
	.float 0.490487
	.float -0.749203
	.float 0.895395
	.float -0.858575
	.float 0.655518
	.float -0.359597
	.float 0.050166
	.float 0.212259
	.float -0.381065
	.float 0.419561
	.float -0.318678
	.float 0.119436
	.float 0.094716
	.float -0.245985
	.float 0.318538
	.float -0.374886
	.float 0.512158
	.float -0.784895
	.float 1.147555
	.float -1.457580
	.float 1.540899
	.float -1.285291
	.float 0.711748
	.float 0.014562
	.float -0.643227
	.float 0.943420
	.float -0.807662
	.float 0.304962
	.float 0.344977
	.float -0.868580
	.float 1.061837
	.float -0.879334
	.float 0.443884
	.float 0.026149
	.float -0.329085
	.float 0.370076
	.float -0.186901
	.float -0.089838
	.float 0.308306
	.float -0.359597
	.float 0.211479
	.float 0.090072
	.float -0.443684
	.float 0.731794
	.float -0.866705
	.float 0.827631
	.float -0.669896
	.float 0.495574
	.float -0.396885
	.float 0.403544
	.float -0.467224
	.float 0.494087
	.float -0.403961
	.float 0.177396
	.float 0.136784
	.float -0.451115
	.float 0.681308
	.float -0.777205
	.float 0.736525
	.float -0.605366
	.float 0.464861
	.float -0.398104
	.float 0.444668
	.float -0.571359
	.float 0.690163
	.float -0.720081
	.float 0.647280
	.float -0.530121
	.float 0.442057
	.float -0.404947
	.float 0.377673
	.float -0.311894
	.float 0.217694
	.float -0.166553
	.float 0.218774
	.float -0.342036
	.float 0.408864
	.float -0.294111
	.float -0.001866
	.float 0.316153
	.float -0.421927
	.float 0.198254
	.float 0.260842
	.float -0.690783
	.float 0.828302
	.float -0.583257
	.float 0.083700
	.float 0.431402
	.float -0.778653
	.float 0.924294
	.float -0.945426
	.float 0.913394
	.float -0.813486
	.float 0.571266
	.float -0.152192
	.float -0.363853
	.float 0.805230
	.float -1.011455
	.float 0.932082
	.float -0.648449
	.float 0.313334
	.float -0.062644
	.float -0.042099
	.float 0.018712
	.float 0.067313
	.float -0.144904
	.float 0.170915
	.float -0.142936
	.float 0.085617
	.float -0.017944
	.float -0.073078
	.float 0.225202
	.float -0.457681
	.float 0.725327
	.float -0.915493
	.float 0.905934
	.float -0.650532
	.float 0.230673
	.float 0.172828
	.float -0.378412
	.float 0.309042
	.float -0.031648
	.float -0.297229
	.float 0.539128
	.float -0.654231
	.float 0.697415
	.float -0.742378
	.float 0.804181
	.float -0.827611
	.float 0.746852
	.float -0.557190
	.float 0.328704
	.float -0.145258
	.float 0.022431
	.float 0.117545
	.float -0.380084
	.float 0.787040
	.float -1.213316
	.float 1.438243
	.float -1.290024
	.float 0.780272
	.float -0.120359
	.float -0.404262
	.float 0.615279
	.float -0.545071
	.float 0.388152
	.float -0.344474
	.float 0.478231
	.float -0.694878
	.float 0.838978
	.float -0.823691
	.float 0.688980
	.float -0.553455
	.float 0.511320
	.float -0.560254
	.float 0.611911
	.float -0.567526
	.float 0.396832
	.float -0.164134
	.float -0.010138
	.float 0.021932
	.float 0.156301
	.float -0.460441
	.float 0.770433
	.float -0.975859
	.float 1.033993
	.float -0.983832
	.float 0.904933
	.float -0.849544
	.float 0.802199
	.float -0.704550
	.float 0.528273
	.float -0.329249
	.float 0.223020
	.float -0.289128
	.float 0.483974
	.float -0.648896
	.float 0.624766
	.float -0.387112
	.float 0.086496
	.float 0.050241
	.float 0.112180
	.float -0.509058
	.float 0.908462
	.float -1.055950
	.float 0.823745
	.float -0.268546
	.float -0.418121
	.float 1.011118
	.float -1.336555
	.float 1.312289
	.float -0.956748
	.float 0.385431
	.float 0.207513
	.float -0.598615
	.float 0.617043
	.float -0.227817
	.float -0.434290
	.float 1.112815
	.float -1.545373
	.float 1.587997
	.float -1.278845
	.float 0.806026
	.float -0.399278
	.float 0.207903
	.float -0.232214
	.float 0.342927
	.float -0.373566
	.float 0.229976
	.float 0.048219
	.float -0.312237
	.float 0.399967
	.float -0.240935
	.float -0.099425
	.float 0.464995
	.float -0.708139
	.float 0.770669
	.float -0.693284
	.float 0.558707
	.float -0.422979
	.float 0.288739
	.float -0.131479
	.float -0.055902
	.float 0.243763
	.float -0.384793
	.float 0.448406
	.float -0.437101
	.float 0.373468
	.float -0.276172
	.float 0.151532
	.float -0.007824
	.float -0.126614
	.float 0.205712
	.float -0.192323
	.float 0.086244
	.float 0.073368
	.float -0.235881
	.float 0.372866
	.float -0.486290
	.float 0.583173
	.float -0.640291
	.float 0.594425
	.float -0.373930
	.float -0.045787
	.float 0.601324
	.float -1.145943
	.float 1.502812
	.float -1.541442
	.float 1.240569
	.float -0.707483
	.float 0.142246
	.float 0.242577
	.float -0.315763
	.float 0.091255
	.float 0.276354
	.float -0.573499
	.float 0.649864
	.float -0.509803
	.float 0.308660
	.float -0.244536
	.float 0.410798
	.float -0.712734
	.float 0.917135
	.float -0.811212
	.float 0.362195
	.float 0.239735
	.float -0.691481
	.float 0.764755
	.float -0.440919
	.float -0.093814
	.float 0.574098
	.float -0.803204
	.float 0.726799
	.float -0.409218
	.float -0.037538
	.float 0.505797
	.float -0.900859
	.float 1.133177
	.float -1.132614
	.float 0.890054
	.float -0.489715
	.float 0.089663
	.float 0.152890
	.float -0.165060
	.float -0.011019
	.float 0.263305
	.float -0.492660
	.float 0.664946
	.float -0.793225
	.float 0.875298
	.float -0.853705
	.float 0.645590
	.float -0.225070
	.float -0.312776
	.float 0.769807
	.float -0.945935
	.float 0.758419
	.float -0.296432
	.float -0.227637
	.float 0.598383
	.float -0.711751
	.float 0.614933
	.float -0.455624
	.float 0.380907
	.float -0.452414
	.float 0.625931
	.float -0.797296
	.float 0.873933
	.float -0.818580
	.float 0.639519
	.float -0.348026
	.float -0.065768
	.float 0.603011
	.float -1.191061
	.float 1.649785
	.float -1.748325
	.float 1.341429
	.float -0.497422
	.float -0.485009
	.float 1.204476
	.float -1.359052
	.float 0.898975
	.float -0.042321
	.float -0.842927
	.float 1.411273
	.float -1.476083
	.float 1.059503
	.float -0.357069
	.float -0.354023
	.float 0.826219
	.float -0.936562
	.float 0.729371
	.float -0.383631
	.float 0.112656
	.float -0.045731
	.float 0.161675
	.float -0.320070
	.float 0.372624
	.float -0.276474
	.float 0.124593
	.float -0.067419
	.float 0.185290
	.float -0.412729
	.float 0.577412
	.float -0.524998
	.float 0.232362
	.float 0.177707
	.float -0.526530
	.float 0.698580
	.float -0.697349
	.float 0.605157
	.float -0.495288
	.float 0.378046
	.float -0.223969
	.float 0.032370
	.float 0.128035
	.float -0.154513
	.float -0.001761
	.float 0.271537
	.float -0.490317
	.float 0.501681
	.float -0.266151
	.float -0.108625
	.float 0.441509
	.float -0.599953
	.float 0.579186
	.float -0.481933
	.float 0.420851
	.float -0.424049
	.float 0.417698
	.float -0.296218
	.float 0.021388
	.float 0.328686
	.float -0.598684
	.float 0.654049
	.float -0.466607
	.float 0.130162
	.float 0.199872
	.float -0.397484
	.float 0.427778
	.float -0.344918
	.float 0.236390
	.float -0.156711
	.float 0.095458
	.float 0.001557
	.float -0.177053
	.float 0.415591
	.float -0.641710
	.float 0.765277
	.float -0.740032
	.float 0.590872
	.float -0.391327
	.float 0.213588
	.float -0.094361
	.float 0.041441
	.float -0.064799
	.float 0.191498
	.float -0.439408
	.float 0.769041
	.float -1.061726
	.float 1.159471
	.float -0.953097
	.float 0.461570
	.float 0.156142
	.float -0.672337
	.float 0.905261
	.float -0.807606
	.float 0.476815
	.float -0.086035
	.float -0.214950
	.float 0.363569
	.float -0.378540
	.float 0.303847
	.float -0.158472
	.float -0.063264
	.float 0.347409
	.float -0.623729
	.float 0.784170
	.float -0.751588
	.float 0.539626
	.float -0.245112
	.float -0.027874
	.float 0.246531
	.float -0.456957
	.float 0.708812
	.float -0.965129
	.float 1.087451
	.float -0.926020
	.float 0.451332
	.float 0.182769
	.float -0.707823
	.float 0.902504
	.float -0.732552
	.float 0.366392
	.float -0.055328
	.float -0.035048
	.float -0.075809
	.float 0.216737
	.float -0.199447
	.float -0.042547
	.float 0.402757
	.float -0.666728
	.float 0.647772
	.float -0.307981
	.float -0.207787
	.float 0.645429
	.float -0.781246
	.float 0.547375
	.float -0.068379
	.float -0.414464
	.float 0.686217
	.float -0.679782
	.float 0.500498
	.float -0.342507
	.float 0.356211
	.float -0.554761
	.float 0.815847
	.float -0.968843
	.float 0.905124
	.float -0.641781
	.float 0.305427
	.float -0.053217
	.float -0.017740
	.float -0.079954
	.float 0.240496
	.float -0.333795
	.float 0.283559
	.float -0.107517
	.float -0.102568
	.float 0.245386
	.float -0.276344
	.float 0.234301
	.float -0.215070
	.float 0.311274
	.float -0.554954
	.float 0.892439
	.float -1.201788
	.float 1.344889
	.float -1.234075
	.float 0.886546
	.float -0.436087
	.float 0.083275
	.float 0.003526
	.float 0.214542
	.float -0.615970
	.float 0.985459
	.float -1.141844
	.float 1.041373
	.float -0.783470
	.float 0.518470
	.float -0.333029
	.float 0.203888
	.float -0.051113
	.float -0.161321
	.float 0.367590
	.float -0.436335
	.float 0.274121
	.float 0.085616
	.float -0.478550
	.float 0.697150
	.float -0.611741
	.float 0.246341
	.float 0.235369
	.float -0.618829
	.float 0.743487
	.float -0.564230
	.float 0.146234
	.float 0.386179
	.float -0.905425
	.float 1.313132
	.float -1.548455
	.float 1.588158
	.float -1.448108
	.float 1.179839
	.float -0.851693
	.float 0.517150
	.float -0.191348
	.float -0.143609
	.float 0.504164
	.float -0.866935
	.float 1.158028
	.float -1.281995
	.float 1.173709
	.float -0.840588
	.float 0.370496
	.float 0.098373
	.float -0.429131
	.float 0.536928
	.float -0.419871
	.float 0.159917
	.float 0.107255
	.float -0.244585
	.float 0.170768
	.float 0.099477
	.float -0.450712
	.float 0.705516
	.float -0.698547
	.float 0.359626
	.float 0.233837
	.float -0.870175
	.float 1.289858
	.float -1.308691
	.float 0.911022
	.float -0.256962
	.float -0.401597
	.float 0.843210
	.float -0.964381
	.float 0.791383
	.float -0.431721
	.float 0.015038
	.float 0.340626
	.float -0.539277
	.float 0.520992
	.float -0.291773
	.float -0.054718
	.float 0.362336
	.float -0.493840
	.float 0.421707
	.float -0.254248
	.float 0.158295
	.float -0.223979
	.float 0.378019
	.float -0.429313
	.float 0.226749
	.float 0.191872
	.float -0.589578
	.float 0.685857
	.float -0.369814
	.float -0.192206
	.float 0.644175
	.float -0.668874
	.float 0.199909
	.float 0.526708
	.float -1.111917
	.float 1.229297
	.float -0.807966
	.float 0.058564
	.float 0.657661
	.float -1.026509
	.float 0.929826
	.float -0.476941
	.float -0.076304
	.float 0.461046
	.float -0.514629
	.float 0.240303
	.float 0.206787
	.float -0.598204
	.float 0.743916
	.float -0.585963
	.float 0.221757
	.float 0.161548
	.float -0.403928
	.float 0.463162
	.float -0.416285
	.float 0.374108
	.float -0.378379
	.float 0.365021
	.float -0.223961
	.float -0.093135
	.float 0.507165
	.float -0.845914
	.float 0.956677
	.float -0.811969
	.float 0.527471
	.float -0.278990
	.float 0.181599
	.float -0.218859
	.float 0.267787
	.float -0.192942
	.float -0.062303
	.float 0.446355
	.float -0.838355
	.float 1.115521
	.float -1.202303
	.float 1.084700
	.float -0.803147
	.float 0.440981
	.float -0.106250
	.float -0.105484
	.float 0.161125
	.float -0.118020
	.float 0.094011
	.float -0.186586
	.float 0.399639
	.float -0.641439
	.float 0.801624
	.float -0.843237
	.float 0.827929
	.float -0.849687
	.float 0.934055
	.float -0.992922
	.float 0.878517
	.float -0.497810
	.float -0.099071
	.float 0.721530
	.float -1.130376
	.float 1.161027
	.float -0.808136
	.float 0.229964
	.float 0.324558
	.float -0.628715
	.float 0.576786
	.float -0.222695
	.float -0.259285
	.float 0.670143
	.float -0.886880
	.float 0.915376
	.float -0.868458
	.float 0.882430
	.float -1.019061
	.float 1.211629
	.float -1.295026
	.float 1.113551
	.float -0.644395
	.float 0.048968
	.float 0.401141
	.float -0.490904
	.float 0.210422
	.float 0.227311
	.float -0.522408
	.float 0.484669
	.float -0.148220
	.float -0.274599
	.float 0.555515
	.float -0.599253
	.float 0.471802
	.float -0.304321
	.float 0.164957
	.float -0.005717
	.float -0.278924
	.float 0.735443
	.float -1.272189
	.float 1.682156
	.float -1.757311
	.float 1.421552
	.float -0.794241
	.float 0.136974
	.float 0.292812
	.float -0.394632
	.float 0.284038
	.float -0.210001
	.float 0.375429
	.float -0.778794
	.float 1.190712
	.float -1.292743
	.float 0.890981
	.float -0.059671
	.float -0.886543
	.float 1.573920
	.float -1.779095
	.float 1.524283
	.float -1.005238
	.float 0.427217
	.float 0.111357
	.float -0.601223
	.float 1.011857
	.float -1.219188
	.float 1.067634
	.float -0.529716
	.float -0.185393
	.float 0.702198
	.float -0.711521
	.float 0.200048
	.float 0.507601
	.float -0.945977
	.float 0.815224
	.float -0.180416
	.float -0.578080
	.float 1.026837
	.float -0.967269
	.float 0.547548
	.float -0.128809
	.float 0.015052
	.float -0.251456
	.float 0.632947
	.float -0.894984
	.float 0.917964
	.float -0.781151
	.float 0.642136
	.float -0.569389
	.float 0.484687
	.float -0.261352
	.float -0.121783
	.float 0.517746
	.float -0.700640
	.float 0.532342
	.float -0.070314
	.float -0.464175
	.float 0.823766
	.float -0.873382
	.float 0.641665
	.float -0.273917
	.float -0.061389
	.float 0.248924
	.float -0.255007
	.float 0.114714
	.float 0.098222
	.float -0.298774
	.float 0.409203
	.float -0.374025
	.float 0.178363
	.float 0.132853
	.float -0.452086
	.float 0.643236
	.float -0.612194
	.float 0.378177
	.float -0.089275
	.float -0.049033
	.float -0.096933
	.float 0.487423
	.float -0.916500
	.float 1.138709
	.float -1.034494
	.float 0.694428
	.float -0.354440
	.float 0.224586
	.float -0.339383
	.float 0.544457
	.float -0.627952
	.float 0.487998
	.float -0.200648
	.float -0.061737
	.float 0.183495
	.float -0.195386
	.float 0.227889
	.float -0.377715
	.float 0.610844
	.float -0.785941
	.float 0.773649
	.float -0.566507
	.float 0.290346
	.float -0.115524
	.float 0.144612
	.float -0.359084
	.float 0.650070
	.float -0.894501
	.float 1.017973
	.float -1.012242
	.float 0.914312
	.float -0.772916
	.float 0.623434
	.float -0.478046
	.float 0.329607
	.float -0.164685
	.float -0.020114
	.float 0.207196
	.float -0.359373
	.float 0.434618
	.float -0.407648
	.float 0.288430
	.float -0.128115
	.float 0.007416
	.float -0.006991
	.float 0.168306
	.float -0.462196
	.float 0.785726
	.float -0.997444
	.float 0.980765
	.float -0.703829
	.float 0.241164
	.float 0.259253
	.float -0.647191
	.float 0.838638
	.float -0.842638
	.float 0.735162
	.float -0.604347
	.float 0.506426
	.float -0.455788
	.float 0.441768
	.float -0.446739
	.float 0.449946
	.float -0.425256
	.float 0.350810
	.float -0.232482
	.float 0.119275
	.float -0.085102
	.float 0.177718
	.float -0.369858
	.float 0.555211
	.float -0.603259
	.float 0.442623
	.float -0.118363
	.float -0.217414
	.float 0.381735
	.float -0.262934
	.float -0.108437
	.float 0.562206
	.float -0.868059
	.float 0.851812
	.float -0.484684
	.float -0.104588
	.float 0.699686
	.float -1.104463
	.float 1.226302
	.float -1.094470
	.float 0.816413
	.float -0.505797
	.float 0.222725
	.float 0.047174
	.float -0.366174
	.float 0.782379
	.float -1.266368
	.float 1.690620
	.float -1.878891
	.float 1.705913
	.float -1.185118
	.float 0.480949
	.float 0.167389
	.float -0.561055
	.float 0.621750
	.float -0.396075
	.float 0.001848
	.float 0.433357
	.float -0.804312
	.float 1.032562
	.float -1.067628
	.float 0.900167
	.float -0.576247
	.float 0.190477
	.float 0.150039
	.float -0.374159
	.float 0.477322
	.float -0.514289
	.float 0.557237
	.float -0.642628
	.float 0.739714
	.float -0.764258
	.float 0.636926
	.float -0.352735
	.float 0.008849
	.float 0.242720
	.float -0.296097
	.float 0.173027
	.float -0.014545
	.float -0.020978
	.float -0.123077
	.float 0.362041
	.float -0.542693
	.float 0.565964
	.float -0.457097
	.float 0.330471
	.float -0.290537
	.float 0.360675
	.float -0.495205
	.float 0.645686
	.float -0.803111
	.float 0.970375
	.float -1.100291
	.float 1.081377
	.float -0.814041
	.float 0.325449
	.float 0.187785
	.float -0.457669
	.float 0.334483
	.float 0.076139
	.float -0.451645
	.float 0.460676
	.float 0.003188
	.float -0.736408
	.float 1.356241
	.float -1.553948
	.float 1.286478
	.float -0.774615
	.float 0.323849
	.float -0.111388
	.float 0.094993
	.float -0.093263
	.float -0.045148
	.float 0.322218
	.float -0.604642
	.float 0.743171
	.float -0.692241
	.float 0.538326
	.float -0.426487
	.float 0.451162
	.float -0.594943
	.float 0.752249
	.float -0.809954
	.float 0.723595
	.float -0.541614
	.float 0.371337
	.float -0.314580
	.float 0.409269
	.float -0.602412
	.float 0.764973
	.float -0.747543
	.float 0.461108
	.float 0.052294
	.float -0.606040
	.float 0.940892
	.float -0.860730
	.float 0.357156
	.float 0.361582
	.float -0.969758
	.float 1.200718
	.float -0.994570
	.float 0.525403
	.float -0.092769
	.float -0.053425
	.float -0.151776
	.float 0.569115
	.float -0.953023
	.float 1.098821
	.float -0.948868
	.float 0.601259
	.float -0.230317
	.float -0.019641
	.float 0.099597
	.float -0.050537
	.float -0.050619
	.float 0.146053
	.float -0.217217
	.float 0.269275
	.float -0.304362
	.float 0.309385
	.float -0.266015
	.float 0.172790
	.float -0.060844
	.float -0.009912
	.float -0.023216
	.float 0.188031
	.float -0.448686
	.float 0.708329
	.float -0.851094
	.float 0.805910
	.float -0.594297
	.float 0.325843
	.float -0.136370
	.float 0.103722
	.float -0.197075
	.float 0.297486
	.float -0.279719
	.float 0.101281
	.float 0.161744
	.float -0.356548
	.float 0.345290
	.float -0.088879
	.float -0.324683
	.float 0.716767
	.float -0.895646
	.float 0.739365
	.float -0.254360
	.float -0.411367
	.float 1.013756
	.float -1.312974
	.float 1.192617
	.float -0.734000
	.float 0.188789
	.float 0.151854
	.float -0.121947
	.float -0.224360
	.float 0.651966
	.float -0.894457
	.float 0.815814
	.float -0.480514
	.float 0.093593
	.float 0.140858
	.float -0.146296
	.float 0.007737
	.float 0.099790
	.float -0.034289
	.float -0.219679
	.float 0.543393
	.float -0.762952
	.float 0.760997
	.float -0.550698
	.float 0.266842
	.float -0.081528
	.float 0.098090
	.float -0.289724
	.float 0.519913
	.float -0.629275
	.float 0.531775
	.float -0.260581
	.float -0.058373
	.float 0.278382
	.float -0.300881
	.float 0.108749
	.float 0.237282
	.float -0.623049
	.float 0.916500
	.float -1.012713
	.float 0.879328
	.float -0.578119
	.float 0.240461
	.float -0.002576
	.float -0.062039
	.float -0.029724
	.float 0.196971
	.float -0.351475
	.float 0.445029
	.float -0.481361
	.float 0.494820
	.float -0.518265
	.float 0.563172
	.float -0.621219
	.float 0.678408
	.float -0.725407
	.float 0.755501
	.float -0.757292
	.float 0.717596
	.float -0.638184
	.float 0.549899
	.float -0.501249
	.float 0.518920
	.float -0.570837
	.float 0.571949
	.float -0.442173
	.float 0.176353
	.float 0.135562
	.float -0.366183
	.float 0.445458
	.float -0.411937
	.float 0.370293
	.float -0.387500
	.float 0.421802
	.float -0.357060
	.float 0.120092
	.float 0.224669
	.float -0.499458
	.float 0.548621
	.float -0.370478
	.float 0.123846
	.float 0.006274
	.float 0.028807
	.float -0.094960
	.float -0.009250
	.float 0.370589
	.float -0.867406
	.float 1.243312
	.float -1.286698
	.float 0.971612
	.float -0.458050
	.float -0.030206
	.float 0.341365
	.float -0.447336
	.float 0.399821
	.float -0.254857
	.float 0.034436
	.float 0.259970
	.float -0.615300
	.float 0.991605
	.float -1.328648
	.float 1.558442
	.float -1.617897
	.float 1.471159
	.float -1.144655
	.float 0.748399
	.float -0.445368
	.float 0.362643
	.float -0.496817
	.float 0.693284
	.float -0.737365
	.float 0.508092
	.float -0.083484
	.float -0.290549
	.float 0.357966
	.float -0.029622
	.float -0.547157
	.float 1.076638
	.float -1.296319
	.float 1.124611
	.float -0.679338
	.float 0.171060
	.float 0.238647
	.float -0.512173
	.float 0.706118
	.float -0.878913
	.float 1.014328
	.float -1.014575
	.float 0.762198
	.float -0.208904
	.float -0.559309
	.float 1.317740
	.float -1.772935
	.float 1.690134
	.float -1.024262
	.float -0.021719
	.float 1.065720
	.float -1.726067
	.float 1.815824
	.float -1.431066
	.float 0.874085
	.float -0.461147
	.float 0.342879
	.float -0.451526
	.float 0.595659
	.float -0.619198
	.float 0.505419
	.float -0.358941
	.float 0.295358
	.float -0.333842
	.float 0.376213
	.float -0.282638
	.float -0.019616
	.float 0.476637
	.float -0.936216
	.float 1.236802
	.float -1.293091
	.float 1.127225
	.float -0.837694
	.float 0.538639
	.float -0.311590
	.float 0.193055
	.float -0.190426
	.float 0.300202
	.float -0.506718
	.float 0.762973
	.float -0.977776
	.float 1.035117
	.float -0.848715
	.float 0.423352
	.float 0.119790
	.float -0.579680
	.float 0.763355
	.float -0.581045
	.float 0.097577
	.float 0.489530
	.float -0.937861
	.float 1.072489
	.float -0.867406
	.float 0.452593
	.float -0.040649
	.float -0.187375
	.float 0.170471
	.float 0.021709
	.float -0.255652
	.float 0.423990
	.float -0.491810
	.float 0.475003
	.float -0.386659
	.float 0.211643
	.float 0.064034
	.float -0.402250
	.float 0.699874
	.float -0.840370
	.float 0.774037
	.float -0.558746
	.float 0.322591
	.float -0.175265
	.float 0.138655
	.float -0.150546
	.float 0.132874
	.float -0.062893
	.float -0.013353
	.float 0.033216
	.float 0.014386
	.float -0.066585
	.float 0.031538
	.float 0.134495
	.float -0.379315
	.float 0.573713
	.float -0.586151
	.float 0.364350
	.float 0.027565
	.float -0.439720
	.float 0.716055
	.float -0.773247
	.float 0.628468
	.float -0.360839
	.float 0.041641
	.float 0.306011
	.float -0.683690
	.float 1.056117
	.float -1.317802
	.float 1.333667
	.float -1.031958
	.float 0.476622
	.float 0.142330
	.float -0.599480
	.float 0.745937
	.float -0.576137
	.float 0.218973
	.float 0.131487
	.float -0.307540
	.float 0.240940
	.float 0.014370
	.float -0.322284
	.float 0.548728
	.float -0.640088
	.float 0.643316
	.float -0.652589
	.float 0.722051
	.float -0.811513
	.float 0.807340
	.float -0.603584
	.float 0.185020
	.float 0.344897
	.float -0.807725
	.float 1.036664
	.float -0.955702
	.float 0.610439
	.float -0.138171
	.float -0.303942
	.float 0.613470
	.float -0.779056
	.float 0.858444
	.float -0.914861
	.float 0.959583
	.float -0.945777
	.float 0.819796
	.float -0.584532
	.float 0.313048
	.float -0.090760
	.float -0.068342
	.float 0.251321
	.float -0.579120
	.float 1.082873
	.float -1.623169
	.float 1.931266
	.float -1.762646
	.float 1.065848
	.float -0.049682
	.float -0.903803
	.float 1.434321
	.float -1.390574
	.float 0.898748
	.float -0.274276
	.float -0.164735
	.float 0.265647
	.float -0.091649
	.float -0.163715
	.float 0.324189
	.float -0.335258
	.float 0.264185
	.float -0.218969
	.float 0.261753
	.float -0.378165
	.float 0.505422
	.float -0.578634
	.float 0.557947
	.float -0.433575
	.float 0.227906
	.float -0.001961
	.float -0.150749
	.float 0.142787
	.float 0.046494
	.float -0.332492
	.float 0.552340
	.float -0.555810
	.float 0.303751
	.float 0.098763
	.float -0.465463
	.float 0.648112
	.float -0.627433
	.float 0.510638
	.float -0.440075
	.float 0.484624
	.float -0.596180
	.float 0.661643
	.float -0.603873
	.float 0.447079
	.float -0.292992
	.float 0.229795
	.float -0.254401
	.float 0.276644
	.float -0.202119
	.float 0.019772
	.float 0.184847
	.float -0.302664
	.float 0.294939
	.float -0.224948
	.float 0.202119
	.float -0.291127
	.float 0.465180
	.float -0.638020
	.float 0.738480
	.float -0.758908
	.float 0.739597
	.float -0.711214
	.float 0.652440
	.float -0.502984
	.float 0.222334
	.float 0.155003
	.float -0.515103
	.float 0.719840
	.float -0.685874
	.float 0.433935
	.float -0.075376
	.float -0.254453
	.float 0.470777
	.float -0.571931
	.float 0.608701
	.float -0.616006
	.float 0.564340
	.float -0.378827
	.float 0.021074
	.float 0.429974
	.float -0.778537
	.float 0.819748
	.float -0.490311
	.float -0.055333
	.float 0.519841
	.float -0.652788
	.float 0.422422
	.float -0.038918
	.float -0.193323
	.float 0.088092
	.float 0.299829
	.float -0.726182
	.float 0.935998
	.float -0.832898
	.float 0.518861
	.float -0.188967
	.float -0.025397
	.float 0.140807
	.float -0.274219
	.float 0.511216
	.float -0.802879
	.float 0.978568
	.float -0.868261
	.float 0.440773
	.float 0.149004
	.float -0.642678
	.float 0.833926
	.float -0.689946
	.float 0.359400
	.float -0.068346
	.float -0.021792
	.float -0.098951
	.float 0.307841
	.float -0.452140
	.float 0.460369
	.float -0.385047
	.float 0.350786
	.float -0.449604
	.float 0.661801
	.float -0.858128
	.float 0.878141
	.float -0.628387
	.float 0.140047
	.float 0.438588
	.float -0.901097
	.float 1.064996
	.float -0.850122
	.float 0.326576
	.float 0.297667
	.float -0.763027
	.float 0.887470
	.float -0.664856
	.float 0.262712
	.float 0.086215
	.float -0.226214
	.float 0.156007
	.float 0.005259
	.float -0.124168
	.float 0.143529
	.float -0.095807
	.float 0.049006
	.float -0.043504
	.float 0.069830
	.float -0.090147
	.float 0.070104
	.float 0.006667
	.float -0.139474
	.float 0.308377
	.float -0.463803
	.float 0.526759
	.float -0.420049
	.float 0.124005
	.float 0.281600
	.float -0.631526
	.float 0.753737
	.float -0.573964
	.float 0.179260
	.float 0.212808
	.float -0.376576
	.float 0.224267
	.float 0.124096
	.float -0.409290
	.float 0.407844
	.float -0.093263
	.float -0.342647
	.float 0.636387
	.float -0.660618
	.float 0.526708
	.float -0.490487
	.float 0.729508
	.float -1.172883
	.float 1.531258
	.float -1.513673
	.float 1.061777
	.float -0.410113
	.float -0.082001
	.float 0.196705
	.float -0.010497
	.float -0.185875
	.float 0.130520
	.float 0.203980
	.float -0.606695
	.float 0.818878
	.float -0.751188
	.float 0.545253
	.float -0.436451
	.float 0.545259
	.float -0.778334
	.float 0.918047
	.float -0.814291
	.float 0.510116
	.float -0.198636
	.float 0.058204
	.float -0.113049
	.float 0.234707
	.float -0.271364
	.float 0.183434
	.float -0.066587
	.float 0.049359
	.float -0.164132
	.float 0.309155
	.float -0.334274
	.float 0.172526
	.float 0.097969
	.float -0.312544
	.float 0.345523
	.float -0.197159
	.float -0.022090
	.float 0.183485
	.float -0.224481
	.float 0.161665
	.float -0.039205
	.float -0.126026
	.float 0.347973
	.float -0.625296
	.float 0.897765
	.float -1.057527
	.float 1.017401
	.float -0.782418
	.float 0.461034
	.float -0.199863
	.float 0.090886
	.float -0.124657
	.float 0.222451
	.float -0.311903
	.float 0.376383
	.float -0.439238
	.float 0.509544
	.float -0.551059
	.float 0.508835
	.float -0.368434
	.float 0.188997
	.float -0.074981
	.float 0.106213
	.float -0.279594
	.float 0.503833
	.float -0.647918
	.float 0.610787
	.float -0.374111
	.float 0.014511
	.float 0.328817
	.float -0.517105
	.float 0.476985
	.float -0.235214
	.float -0.095776
	.float 0.373450
	.float -0.491110
	.float 0.421191
	.float -0.219766
	.float -0.004424
	.float 0.141673
	.float -0.133563
	.float 0.001735
	.float 0.167753
	.float -0.284207
	.float 0.321524
	.float -0.343860
	.float 0.456846
	.float -0.711313
	.float 1.033522
	.float -1.248736
	.float 1.196897
	.float -0.862729
	.float 0.417561
	.float -0.126231
	.float 0.171834
	.float -0.519534
	.float 0.921337
	.float -1.067720
	.float 0.786421
	.float -0.154418
	.float -0.549297
	.float 1.012775
	.float -1.068808
	.float 0.774534
	.float -0.358631
	.float 0.082527
	.float -0.098918
	.float 0.378373
	.float -0.732587
	.float 0.917391
	.float -0.764460
	.float 0.276038
	.float 0.366878
	.float -0.890317
	.float 1.062793
	.float -0.808741
	.float 0.242062
	.float 0.393344
	.float -0.842054
	.float 0.955967
	.float -0.758887
	.float 0.426884
	.float -0.191402
	.float 0.209716
	.float -0.469749
	.float 0.786674
	.float -0.902671
	.float 0.639561
	.float -0.016189
	.float -0.743174
	.float 1.320640
	.float -1.474623
	.float 1.167840
	.float -0.577186
	.float -0.018371
	.float 0.400581
	.float -0.522151
	.float 0.498167
	.float -0.492570
	.float 0.585290
	.float -0.716359
	.float 0.744140
	.float -0.569508
	.float 0.227669
	.float 0.125309
	.float -0.322931
	.float 0.310949
	.float -0.186364
	.float 0.120661
	.float -0.226098
	.float 0.469060
	.float -0.697856
	.float 0.759462
	.float -0.609557
	.float 0.328266
	.float -0.035996
	.float -0.212303
	.float 0.461043
	.float -0.787717
	.float 1.196071
	.float -1.564078
	.float 1.697893
	.float -1.459321
	.float 0.876267
	.float -0.157359
	.float -0.404336
	.float 0.581793
	.float -0.330740
	.float -0.193025
	.float 0.723691
	.float -1.030640
	.float 1.037334
	.float -0.848152
	.float 0.669321
	.float -0.671172
	.float 0.875203
	.float -1.137567
	.float 1.243088
	.float -1.053393
	.float 0.611652
	.float -0.129073
	.float -0.145591
	.float 0.089639
	.float 0.209565
	.float -0.510718
	.float 0.577454
	.float -0.329005
	.float -0.119410
	.float 0.546108
	.float -0.768427
	.float 0.739234
	.float -0.538499
	.float 0.287672
	.float -0.063885
	.float -0.125640
	.float 0.308076
	.float -0.494132
	.float 0.656961
	.float -0.749212
	.float 0.733413
	.float -0.597700
	.float 0.353323
	.float -0.030567
	.float -0.314165
	.float 0.590842
	.float -0.693641
	.float 0.554582
	.float -0.205146
	.float -0.207005
	.float 0.479864
	.float -0.472690
	.float 0.198239
	.float 0.180692
	.float -0.455022
	.float 0.499860
	.float -0.336328
	.float 0.086663
	.float 0.129586
	.float -0.270065
	.float 0.364380
	.float -0.453463
	.float 0.538899
	.float -0.584717
	.float 0.557017
	.float -0.456748
	.float 0.317712
	.float -0.180351
	.float 0.068315
	.float 0.017956
	.float -0.097261
	.float 0.200822
	.float -0.358029
	.float 0.568191
	.float -0.771161
	.float 0.849493
	.float -0.684748
	.float 0.247559
	.float 0.341177
	.float -0.838549
	.float 1.001914
	.float -0.736587
	.float 0.169018
	.float 0.413895
	.float -0.729497
	.float 0.663706
	.float -0.327124
	.float -0.031616
	.float 0.192363
	.float -0.095044
	.float -0.148501
	.float 0.358834
	.float -0.425459
	.float 0.376380
	.float -0.337455
	.float 0.421122
	.float -0.631812
	.float 0.857064
	.float -0.947506
	.float 0.824588
	.float -0.538592
	.float 0.237251
	.float -0.069733
	.float 0.093739
	.float -0.247926
	.float 0.402959
	.float -0.449482
	.float 0.359087
	.float -0.179513
	.float -0.021634
	.float 0.212169
	.float -0.402700
	.float 0.605557
	.float -0.789806
	.float 0.881691
	.float -0.816938
	.float 0.599089
	.float -0.308139
	.float 0.048014
	.float 0.119507
	.float -0.193383
	.float 0.192417
	.float -0.108321
	.float -0.083595
	.float 0.354381
	.float -0.567732
	.float 0.525752
	.float -0.112141
	.float -0.575093
	.float 1.229801
	.float -1.511884
	.float 1.275432
	.float -0.675926
	.float 0.065989
	.float 0.247591
	.float -0.202264
	.float -0.013254
	.float 0.138028
	.float -0.053917
	.float -0.135487
	.float 0.218211
	.float -0.077971
	.float -0.184765
	.float 0.318091
	.float -0.117490
	.float -0.404169
	.float 1.011640
	.float -1.404829
	.float 1.408993
	.float -1.056308
	.float 0.524622
	.float -0.013741
	.float -0.337207
	.float 0.460941
	.float -0.348336
	.float 0.056774
	.float 0.275399
	.float -0.463335
	.float 0.374284
	.float -0.025668
	.float -0.408485
	.float 0.708854
	.float -0.761641
	.float 0.630903
	.float -0.496790
	.float 0.513052
	.float -0.696142
	.float 0.921829
	.float -1.015607
	.float 0.861355
	.float -0.460608
	.float -0.072894
	.float 0.557515
	.float -0.800944
	.float 0.663497
	.float -0.124022
	.float -0.677437
	.float 1.462906
	.float -1.924098
	.float 1.873421
	.float -1.348486
	.float 0.594666
	.float 0.072929
	.float -0.441899
	.float 0.499196
	.float -0.398349
	.float 0.335341
	.float -0.424276
	.float 0.645209
	.float -0.874005
	.float 0.956227
	.float -0.782808
	.float 0.344918
	.float 0.243450
	.float -0.770558
	.float 1.008230
	.float -0.824934
	.float 0.268860
	.float 0.437700
	.float -1.000975
	.float 1.197543
	.float -0.973761
	.float 0.452763
	.float 0.142011
	.float -0.595837
	.float 0.787905
	.float -0.718153
	.float 0.473498
	.float -0.160997
	.float -0.147951
	.float 0.426860
	.float -0.658505
	.float 0.795240
	.float -0.763674
	.float 0.524142
	.float -0.139417
	.float -0.215839
	.float 0.336209
	.float -0.115118
	.float -0.367963
	.float 0.876153
	.float -1.153650
	.float 1.086434
	.float -0.774528
	.float 0.461999
	.float -0.370633
	.float 0.552814
	.float -0.867331
	.float 1.092848
	.float -1.091928
	.float 0.901970
	.float -0.687472
	.float 0.599176
	.float -0.658177
	.float 0.757641
	.float -0.770842
	.float 0.664159
	.float -0.515874
	.float 0.433196
	.float -0.452414
	.float 0.516289
	.float -0.543211
	.float 0.515085
	.float -0.496501
	.float 0.566754
	.float -0.727699
	.float 0.873459
	.float -0.855049
	.float 0.595837
	.float -0.170486
	.float -0.217804
	.float 0.358738
	.float -0.180687
	.float -0.181468
	.float 0.458047
	.float -0.424195
	.float 0.068469
	.float 0.378987
	.float -0.597092
	.float 0.407037
	.float 0.084337
	.float -0.547870
	.float 0.666492
	.float -0.370171
	.float -0.106404
	.float 0.389413
	.float -0.233539
	.float -0.305680
	.float 0.917201
	.float -1.255916
	.float 1.171530
	.float -0.780427
	.float 0.342334
	.float -0.052118
	.float -0.087774
	.float 0.223386
	.float -0.484454
	.float 0.842832
	.float -1.110016
	.float 1.072149
	.float -0.652988
	.float -0.017116
	.float 0.667163
	.float -1.029576
	.float 0.967299
	.float -0.522157
	.float -0.118252
	.float 0.702604
	.float -1.011699
	.float 0.940347
	.float -0.538991
	.float -0.007210
	.float 0.462405
	.float -0.651900
	.float 0.543813
	.float -0.254672
	.float -0.023605
	.float 0.131803
	.float -0.025387
	.float -0.212887
	.float 0.430976
	.float -0.499190
	.float 0.381920
	.float -0.150356
	.float -0.068767
	.float 0.174770
	.float -0.153945
	.float 0.081072
	.float -0.061100
	.float 0.149967
	.float -0.308684
	.float 0.424604
	.float -0.389580
	.float 0.184716
	.float 0.088943
	.float -0.262504
	.float 0.207867
	.float 0.069099
	.float -0.421233
	.float 0.652112
	.float -0.645158
	.float 0.432892
	.float -0.152763
	.float -0.071646
	.float 0.221456
	.float -0.367238
	.float 0.566232
	.float -0.772239
	.float 0.849821
	.float -0.690446
	.float 0.331819
	.float 0.028366
	.float -0.149422
	.float -0.086788
	.float 0.583659
	.float -1.079368
	.float 1.302971
	.float -1.132772
	.float 0.657980
	.float -0.115279
	.float -0.249821
	.float 0.309656
	.float -0.100976
	.float -0.221341
	.float 0.482550
	.float -0.575073
	.float 0.488782
	.float -0.281004
	.float 0.020350
	.float 0.251320
	.float -0.517433
	.float 0.760407
	.float -0.945169
	.float 1.032813
	.float -1.010915
	.float 0.906656
	.float -0.764100
	.float 0.605846
	.float -0.420517
	.float 0.194064
	.float 0.045084
	.float -0.219336
	.float 0.252854
	.float -0.138191
	.float -0.048393
	.float 0.206249
	.float -0.293273
	.float 0.350697
	.float -0.439425
	.float 0.545703
	.float -0.553562
	.float 0.327163
	.float 0.156435
	.float -0.740044
	.float 1.156702
	.float -1.197290
	.float 0.850936
	.float -0.311006
	.float -0.156236
	.float 0.377467
	.float -0.350715
	.float 0.193856
	.float -0.028099
	.float -0.096588
	.float 0.181536
	.float -0.208127
	.float 0.105022
	.float 0.200381
	.float -0.689794
	.float 1.211790
	.float -1.541504
	.float 1.505950
	.float -1.083889
	.float 0.412133
	.float 0.294903
	.float -0.847642
	.float 1.144008
	.float -1.176150
	.float 1.005223
	.float -0.731893
	.float 0.470169
	.float -0.317986
	.float 0.323834
	.float -0.462855
	.float 0.639957
	.float -0.727109
	.float 0.625156
	.float -0.324332
	.float -0.070525
	.float 0.377345
	.float -0.433590
	.float 0.203670
	.float 0.178161
	.float -0.477096
	.float 0.511219
	.float -0.286975
	.float 0.011689
	.float 0.041612
	.float 0.269301
	.float -0.837625
	.float 1.357735
	.float -1.514820
	.float 1.186513
	.float -0.523230
	.float -0.139920
	.float 0.474419
	.float -0.331172
	.float -0.198945
	.float 0.851565
	.float -1.327337
	.float 1.426539
	.float -1.123383
	.float 0.559070
	.float 0.035815
	.float -0.452256
	.float 0.594112
	.float -0.501994
	.float 0.298974
	.float -0.097796
	.float -0.063406
	.float 0.212920
	.float -0.379977
	.float 0.535447
	.float -0.596872
	.float 0.499020
	.float -0.269847
	.float 0.040796
	.float 0.029709
	.float 0.132561
	.float -0.455860
	.float 0.760786
	.float -0.873671
	.float 0.735851
	.float -0.434466
	.float 0.138678
	.float 0.010056
	.float 0.020497
	.float -0.148550
	.float 0.244358
	.float -0.216984
	.float 0.064415
	.float 0.138752
	.float -0.297529
	.float 0.352712
	.float -0.303135
	.float 0.192654
	.float -0.084015
	.float 0.039331
	.float -0.106609
	.float 0.301346
	.float -0.583924
	.float 0.853383
	.float -0.980133
	.float 0.873155
	.float -0.543566
	.float 0.116093
	.float 0.230660
	.float -0.364893
	.float 0.279042
	.float -0.090020
	.float -0.041731
	.float 0.022200
	.float 0.113411
	.float -0.231181
	.float 0.203390
	.float -0.013322
	.float -0.218638
	.float 0.312049
	.float -0.154213
	.float -0.214168
	.float 0.619532
	.float -0.868193
	.float 0.869039
	.float -0.678200
	.float 0.440024
	.float -0.275698
	.float 0.204761
	.float -0.151718
	.float 0.022326
	.float 0.212914
	.float -0.486907
	.float 0.670999
	.float -0.647984
	.float 0.378210
	.float 0.073128
	.float -0.554758
	.float 0.883664
	.float -0.915368
	.float 0.607285
	.float -0.049706
	.float -0.556233
	.float 0.976026
	.float -1.048088
	.float 0.766040
	.float -0.285453
	.float -0.159916
	.float 0.389681
	.float -0.375062
	.float 0.237832
	.float -0.150932
	.float 0.211855
	.float -0.378517
	.float 0.507037
	.float -0.454125
	.float 0.166253
	.float 0.298121
	.float -0.808154
	.float 1.218886
	.float -1.413154
	.float 1.324777
	.float -0.957693
	.float 0.401827
	.float 0.175027
	.float -0.578780
	.float 0.671559
	.float -0.439348
	.float -0.003115
	.float 0.478955
	.float -0.844233
	.float 1.047384
	.float -1.117884
	.float 1.106830
	.float -1.037155
	.float 0.903690
	.float -0.709936
	.float 0.493724
	.float -0.310007
	.float 0.188184
	.float -0.111522
	.float 0.044144
	.float 0.018483
	.float -0.027429
	.float -0.085237
	.float 0.338915
	.float -0.659447
	.float 0.897968
	.float -0.907112
	.float 0.626757
	.float -0.124347
	.float -0.434683
	.float 0.867021
	.float -1.054213
	.float 0.982872
	.float -0.728531
	.float 0.403678
	.float -0.106628
	.float -0.101990
	.float 0.192715
	.float -0.148657
	.float -0.041615
	.float 0.368365
	.float -0.773080
	.float 1.137928
	.float -1.318896
	.float 1.219992
	.float -0.865716
	.float 0.413081
	.float -0.077235
	.float 0.008391
	.float -0.201446
	.float 0.503815
	.float -0.717989
	.float 0.728430
	.float -0.567896
	.float 0.384123
	.float -0.334441
	.float 0.478219
	.float -0.732462
	.float 0.916151
	.float -0.857967
	.float 0.505336
	.float 0.032581
	.float -0.541074
	.float 0.826392
	.float -0.831995
	.float 0.663199
	.float -0.499553
	.float 0.459401
	.float -0.521370
	.float 0.565225
	.float -0.496954
	.float 0.348527
	.float -0.261135
	.float 0.359138
	.float -0.621842
	.float 0.869763
	.float -0.889551
	.float 0.601187
	.float -0.128874
	.float -0.287357
	.float 0.470473
	.float -0.429804
	.float 0.329151
	.float -0.329753
	.float 0.441869
	.float -0.510313
	.float 0.345562
	.float 0.108625
	.float -0.708046
	.float 1.194485
	.float -1.364840
	.float 1.191392
	.float -0.809725
	.float 0.400495
	.float -0.068626
	.float -0.191534
	.float 0.439589
	.float -0.709134
	.float 0.975191
	.float -1.182596
	.float 1.293193
	.float -1.305359
	.float 1.238063
	.float -1.108362
	.float 0.929644
	.float -0.728734
	.float 0.556948
	.float -0.474500
	.float 0.512611
	.float -0.638506
	.float 0.751644
	.float -0.722829
	.float 0.463260
	.float 0.011610
	.float -0.563413
	.float 0.978625
	.float -1.068048
	.float 0.770186
	.float -0.201500
	.float -0.381369
	.float 0.698404
	.float -0.589018
	.float 0.106035
	.float 0.497962
	.float -0.896725
	.float 0.866601
	.float -0.411212
	.float -0.244642
	.float 0.791949
	.float -1.018682
	.float 0.916035
	.float -0.642741
	.float 0.382504
	.float -0.206759
	.float 0.046756
	.float 0.210962
	.float -0.590708
	.float 0.970789
	.float -1.153179
	.float 1.005914
	.float -0.566572
	.float 0.028911
	.float 0.374171
	.float -0.504859
	.float 0.383470
	.float -0.151125
	.float -0.029064
	.float 0.064339
	.float 0.030596
	.float -0.158861
	.float 0.202313
	.float -0.082620
	.float -0.202470
	.float 0.576449
	.float -0.912360
	.float 1.082560
	.float -1.012504
	.float 0.713611
	.float -0.273607
	.float -0.194606
	.float 0.613214
	.float -0.963296
	.float 1.251564
	.float -1.449140
	.float 1.465014
	.float -1.196479
	.float 0.633436
	.float 0.067070
	.float -0.617759
	.float 0.755522
	.float -0.420580
	.float -0.173920
	.float 0.654565
	.float -0.723923
	.float 0.358044
	.float 0.182706
	.float -0.543652
	.float 0.526965
	.float -0.216315
	.float -0.112162
	.float 0.211830
	.float -0.042220
	.float -0.228037
	.float 0.374928
	.float -0.294272
	.float 0.064513
	.float 0.134537
	.float -0.168136
	.float 0.043269
	.float 0.106520
	.float -0.125058
	.float -0.053620
	.float 0.358753
	.float -0.627436
	.float 0.705110
	.float -0.534550
	.float 0.179335
	.float 0.225362
	.float -0.553601
	.float 0.744509
	.float -0.803403
	.float 0.763128
	.float -0.646294
	.float 0.458024
	.float -0.206383
	.float -0.076196
	.float 0.332316
	.float -0.500725
	.float 0.541611
	.float -0.449955
	.float 0.252913
	.float 0.000539
	.float -0.249001
	.float 0.425951
	.float -0.472154
	.float 0.359340
	.float -0.119037
	.float -0.144027
	.float 0.277893
	.float -0.152050
	.float -0.262224
	.float 0.851565
	.float -1.397524
	.float 1.679765
	.float -1.587225
	.float 1.169032
	.float -0.596025
	.float 0.062996
	.float 0.302914
	.float -0.475862
	.float 0.502990
	.float -0.452507
	.float 0.380513
	.float -0.328624
	.float 0.333112
	.float -0.423212
	.float 0.606856
	.float -0.860885
	.float 1.137269
	.float -1.377149
	.float 1.517777
	.float -1.493668
	.float 1.250712
	.float -0.783500
	.float 0.173352
	.float 0.416050
	.float -0.806884
	.float 0.904912
	.float -0.755659
	.float 0.507776
	.float -0.303227
	.float 0.175024
	.float -0.033402
	.float -0.245405
	.float 0.693719
	.float -1.187788
	.float 1.499229
	.float -1.434214
	.float 0.967716
	.float -0.280247
	.float -0.332588
	.float 0.624977
	.float -0.537921
	.float 0.222229
	.float 0.067557
	.float -0.140887
	.float -0.008087
	.float 0.205468
	.float -0.224639
	.float -0.050796
	.float 0.538064
	.float -0.998788
	.float 1.183824
	.float -0.983161
	.float 0.488815
	.float 0.059095
	.float -0.401097
	.float 0.385330
	.float -0.032032
	.float -0.484401
	.float 0.918032
	.float -1.061744
	.float 0.841562
	.float -0.354926
	.float -0.170090
	.float 0.483179
	.float -0.437738
	.float 0.066939
	.float 0.435145
	.float -0.817379
	.float 0.900564
	.float -0.658839
	.float 0.214518
	.float 0.239116
	.float -0.535760
	.float 0.601533
	.float -0.462622
	.float 0.204181
	.float 0.087355
	.float -0.363027
	.float 0.611103
	.float -0.824392
	.float 0.967758
	.float -0.981090
	.float 0.826037
	.float -0.542323
	.float 0.258265
	.float -0.127087
	.float 0.222188
	.float -0.469111
	.float 0.677183
	.float -0.661271
	.float 0.371620
	.float 0.063249
	.float -0.415048
	.float 0.501941
	.float -0.301358
	.float -0.044313
	.float 0.324972
	.float -0.390605
	.float 0.226015
	.float 0.063753
	.float -0.330197
	.float 0.459827
	.float -0.409320
	.float 0.194600
	.float 0.135931
	.float -0.514927
	.float 0.853103
	.float -1.042258
	.float 0.986568
	.float -0.657792
	.float 0.138195
	.float 0.391628
	.float -0.731434
	.float 0.766988
	.float -0.533075
	.float 0.185870
	.float 0.099408
	.float -0.232317
	.float 0.237208
	.float -0.193253
	.float 0.141616
	.float -0.043698
	.float -0.170903
	.float 0.506885
	.float -0.845020
	.float 0.986911
	.float -0.785413
	.float 0.268939
	.float 0.340310
	.float -0.744265
	.float 0.752607
	.float -0.405597
	.float -0.056450
	.float 0.361397
	.float -0.391407
	.float 0.247941
	.float -0.145242
	.float 0.217328
	.float -0.397800
	.float 0.478017
	.float -0.302503
	.float -0.061250
	.float 0.333702
	.float -0.227494
	.float -0.305161
	.float 0.982553
	.float -1.351145
	.float 1.092384
	.float -0.260125
	.float -0.728289
	.float 1.349944
	.float -1.308187
	.float 0.711337
	.float 0.018892
	.float -0.436585
	.float 0.353436
	.float 0.074052
	.float -0.491238
	.float 0.600997
	.float -0.343749
	.float -0.105270
	.float 0.486269
	.float -0.624480
	.float 0.507043
	.float -0.246557
	.float -0.009508
	.float 0.152463
	.float -0.141687
	.float 0.004222
	.float 0.176483
	.float -0.284838
	.float 0.221097
	.float 0.037495
	.float -0.401243
	.float 0.695799
	.float -0.751448
	.float 0.504492
	.float -0.045145
	.float -0.421328
	.float 0.678671
	.float -0.608388
	.float 0.245091
	.float 0.245109
	.float -0.645018
	.float 0.783783
	.float -0.608528
	.float 0.203617
	.float 0.249187
	.float -0.553479
	.float 0.589549
	.float -0.371199
	.float 0.037174
	.float 0.222313
	.float -0.267778
	.float 0.086478
	.float 0.199847
	.float -0.400059
	.float 0.357924
	.float -0.041460
	.float -0.428118
	.float 0.825798
	.float -0.931903
	.float 0.651381
	.float -0.081789
	.float -0.514891
	.float 0.835762
	.float -0.698613
	.float 0.151748
	.float 0.539268
	.float -1.030011
	.float 1.083686
	.float -0.693439
	.float 0.068099
	.float 0.502510
	.float -0.809629
	.float 0.814881
	.float -0.627073
	.float 0.406613
	.float -0.274006
	.float 0.274036
	.float -0.393952
	.float 0.597113
	.float -0.838769
	.float 1.060305
	.float -1.182999
	.float 1.124105
	.float -0.837899
	.float 0.360202
	.float 0.178445
	.float -0.594446
	.float 0.737210
	.float -0.572161
	.float 0.203111
	.float 0.188906
	.float -0.454328
	.float 0.556018
	.float -0.564611
	.float 0.575540
	.float -0.617252
	.float 0.627076
	.float -0.515797
	.float 0.267365
	.float 0.012317
	.float -0.146073
	.float 0.005605
	.float 0.386081
	.float -0.847875
	.float 1.138581
	.float -1.094324
	.float 0.715211
	.float -0.151298
	.float -0.391717
	.float 0.758345
	.float -0.896978
	.float 0.843657
	.float -0.667911
	.float 0.429739
	.float -0.173264
	.float -0.056604
	.float 0.209280
	.float -0.253535
	.float 0.213042
	.float -0.170773
	.float 0.219298
	.float -0.382963
	.float 0.573442
	.float -0.626679
	.float 0.410706
	.float 0.066620
	.float -0.631988
	.float 1.033621
	.float -1.090774
	.float 0.806214
	.float -0.362663
	.float 0.005190
	.float 0.108061
	.float 0.016744
	.float -0.249084
	.float 0.448096
	.float -0.556012
	.float 0.603652
	.float -0.638700
	.float 0.649367
	.float -0.554218
	.float 0.268296
	.float 0.208120
	.float -0.749293
	.float 1.146667
	.float -1.210562
	.float 0.870824
	.float -0.221170
	.float -0.511815
	.float 1.056967
	.float -1.204428
	.float 0.888326
	.float -0.215131
	.float -0.576861
	.float 1.216305
	.float -1.515339
	.float 1.445691
	.float -1.131893
	.float 0.766630
	.float -0.503973
	.float 0.396918
	.float -0.408059
	.float 0.467290
	.float -0.523883
	.float 0.560286
	.float -0.573880
	.float 0.555130
	.float -0.482660
	.float 0.334018
	.float -0.100204
	.float -0.204754
	.float 0.541167
	.float -0.847618
	.float 1.051939
	.float -1.088032
	.float 0.915207
	.float -0.536624
	.float 0.012394
	.float 0.540505
	.float -0.973600
	.float 1.161697
	.float -1.068471
	.float 0.782558
	.float -0.487599
	.float 0.367566
	.float -0.496370
	.float 0.783553
	.float -1.019171
	.float 0.998576
	.float -0.652735
	.float 0.101288
	.float 0.407886
	.float -0.638315
	.float 0.499857
	.float -0.098016
	.float -0.330114
	.float 0.553017
	.float -0.473337
	.float 0.174022
	.float 0.140906
	.float -0.272427
	.float 0.144601
	.float 0.152866
	.float -0.419996
	.float 0.465806
	.float -0.221640
	.float -0.217744
	.float 0.649161
	.float -0.879170
	.float 0.832794
	.float -0.586017
	.float 0.305054
	.float -0.138320
	.float 0.137903
	.float -0.260111
	.float 0.429489
	.float -0.601101
	.float 0.766228
	.float -0.907478
	.float 0.962620
	.float -0.849338
	.float 0.540419
	.float -0.120586
	.float -0.238203
	.float 0.376618
	.float -0.248208
	.float -0.057829
	.float 0.384030
	.float -0.602663
	.float 0.669795
	.float -0.609369
	.float 0.462536
	.float -0.255501
	.float 0.007253
	.float 0.244957
	.float -0.437363
	.float 0.502501
	.float -0.407397
	.float 0.179533
	.float 0.097421
	.float -0.317295
	.float 0.398459
	.float -0.320922
	.float 0.134715
	.float 0.065286
	.float -0.183460
	.float 0.162227
	.float 0.002755
	.float -0.269907
	.float 0.568420
	.float -0.813698
	.float 0.923990
	.float -0.846009
	.float 0.586041
	.float -0.226069
	.float -0.097730
	.float 0.255180
	.float -0.190100
	.float -0.048625
	.float 0.337049
	.float -0.549160
	.float 0.623720
	.float -0.583123
	.float 0.499783
	.float -0.443890
	.float 0.450885
	.float -0.521642
	.float 0.637025
	.float -0.763587
	.float 0.848098
	.float -0.822159
	.float 0.635803
	.float -0.309146
	.float -0.040030
	.float 0.233057
	.float -0.130157
	.float -0.263798
	.float 0.766186
	.float -1.097865
	.float 1.041614
	.float -0.578536
	.float -0.092048
	.float 0.667038
	.float -0.912894
	.float 0.782573
	.float -0.406736
	.float -0.016760
	.float 0.343875
	.float -0.534017
	.float 0.616271
	.float -0.625028
	.float 0.566823
	.float -0.434406
	.float 0.236645
	.float -0.005774
	.float -0.223583
	.float 0.435545
	.float -0.628053
	.float 0.787404
	.float -0.873030
	.float 0.837154
	.float -0.668346
	.float 0.421090
	.float -0.197887
	.float 0.088291
	.float -0.106103
	.float 0.173712
	.float -0.171628
	.float 0.023649
	.float 0.241081
	.float -0.496799
	.float 0.601524
	.float -0.498331
	.float 0.265904
	.float -0.076203
	.float 0.081212
	.float -0.305260
	.float 0.622092
	.float -0.836928
	.float 0.815561
	.float -0.565571
	.float 0.212830
	.float 0.099904
	.float -0.305477
	.float 0.424821
	.float -0.503586
	.float 0.543032
	.float -0.493327
	.float 0.312422
	.float -0.029170
	.float -0.253909
	.float 0.425778
	.float -0.445169
	.float 0.366043
	.float -0.292519
	.float 0.303570
	.float -0.405475
	.float 0.537772
	.float -0.612579
	.float 0.552543
	.float -0.313581
	.float -0.096280
	.float 0.593590
	.float -1.013139
	.float 1.155152
	.float -0.891634
	.float 0.276594
	.float 0.429551
	.float -0.871546
	.float 0.799195
	.float -0.228864
	.float -0.550361
	.float 1.139949
	.float -1.259209
	.float 0.887587
	.float -0.238252
	.float -0.399177
	.float 0.825784
	.float -1.002046
	.float 0.998967
	.float -0.900781
	.float 0.748390
	.float -0.558594
	.float 0.377995
	.float -0.299552
	.float 0.407412
	.float -0.688315
	.float 0.991253
	.float -1.091284
	.float 0.833896
	.float -0.263363
	.float -0.366571
	.float 0.725941
	.float -0.608409
	.float 0.065389
	.float 0.617634
	.float -1.087141
	.float 1.119160
	.float -0.724039
	.float 0.107304
	.float 0.467260
	.float -0.814345
	.float 0.887578
	.float -0.751683
	.float 0.507428
	.float -0.224360
	.float -0.084999
	.float 0.445261
	.float -0.871444
	.float 1.324693
	.float -1.701386
	.float 1.871728
	.float -1.754521
	.float 1.382559
	.float -0.907535
	.float 0.527817
	.float -0.379569
	.float 0.463892
	.float -0.658961
	.float 0.802697
	.float -0.783389
	.float 0.582100
	.float -0.259626
	.float -0.079740
	.float 0.318371
	.float -0.350616
	.float 0.119522
	.float 0.339386
	.float -0.882210
	.float 1.302969
	.float -1.433400
	.float 1.238325
	.float -0.838445
	.float 0.437974
	.float -0.202763
	.float 0.172215
	.float -0.262163
	.float 0.346810
	.float -0.349925
	.float 0.276365
	.float -0.172302
	.float 0.064094
	.float 0.062326
	.float -0.226116
	.float 0.402581
	.float -0.516867
	.float 0.494689
	.float -0.328015
	.float 0.096431
	.float 0.078831
	.float -0.115122
	.float 0.021974
	.float 0.110855
	.float -0.179466
	.float 0.135363
	.float -0.007931
	.float -0.133332
	.float 0.244121
	.float -0.343466
	.float 0.489375
	.float -0.706863
	.float 0.927695
	.float -1.002025
	.float 0.792784
	.float -0.294138
	.float -0.317384
	.float 0.753752
	.float -0.776719
	.float 0.346032
	.float 0.347380
	.float -0.987888
	.float 1.309025
	.float -1.220606
	.float 0.816607
	.float -0.279922
	.float -0.232638
	.float 0.644437
	.float -0.933376
	.float 1.074226
	.float -1.016620
	.float 0.726674
	.float -0.256154
	.float -0.231392
	.float 0.523263
	.float -0.485024
	.float 0.166769
	.float 0.199127
	.float -0.327950
	.float 0.065199
	.float 0.500921
	.float -1.079818
	.float 1.349988
	.float -1.147206
	.float 0.546535
	.float 0.203763
	.float -0.833229
	.float 1.175205
	.float -1.199370
	.float 0.966331
	.float -0.570334
	.float 0.115702
	.float 0.282600
	.float -0.515079
	.float 0.526071
	.float -0.361456
	.float 0.163722
	.float -0.096205
	.float 0.237464
	.float -0.519201
	.float 0.757790
	.float -0.767539
	.float 0.485426
	.float -0.024340
	.float -0.385392
	.float 0.533090
	.float -0.356360
	.float -0.023228
	.float 0.378606
	.float -0.514989
	.float 0.375423
	.float -0.053727
	.float -0.277902
	.float 0.467659
	.float -0.448930
	.float 0.247423
	.float 0.054352
	.float -0.364383
	.float 0.616230
	.float -0.781834
	.float 0.863710
	.float -0.876252
	.float 0.829378
	.float -0.725026
	.float 0.566939
	.float -0.374433
	.float 0.187353
	.float -0.054783
	.float 0.010525
	.float -0.047083
	.float 0.106242
	.float -0.099479
	.float -0.044675
	.float 0.331917
	.float -0.687329
	.float 0.991533
	.float -1.146211
	.float 1.121410
	.float -0.951079
	.float 0.688795
	.float -0.370660
	.float 0.022739
	.float 0.298732
	.float -0.484979
	.float 0.412029
	.float -0.025717
	.float -0.586383
	.float 1.197955
	.float -1.534476
	.float 1.405234
	.float -0.804205
	.float -0.073676
	.float 0.909734
	.float -1.396385
	.float 1.368902
	.float -0.873769
	.float 0.139436
	.float 0.536165
	.float -0.923105
	.float 0.948463
	.float -0.694917
	.float 0.324662
	.float 0.012461
	.float -0.231358
	.float 0.311393
	.float -0.271439
	.float 0.154261
	.float -0.026182
	.float -0.030140
	.float -0.050867
	.float 0.271247
	.float -0.549780
	.float 0.758550
	.float -0.801487
	.float 0.679937
	.float -0.492114
	.float 0.360786
	.float -0.340614
	.float 0.376234
	.float -0.345365
	.float 0.156089
	.float 0.175395
	.float -0.526085
	.float 0.746014
	.float -0.757486
	.float 0.601745
	.float -0.402670
	.float 0.277968
	.float -0.263484
	.float 0.301701
	.float -0.296523
	.float 0.190240
	.float -0.006580
	.float -0.168554
	.float 0.250464
	.float -0.213416
	.float 0.100467
	.float 0.017041
	.float -0.091929
	.float 0.121262
	.float -0.123355
	.float 0.104211
	.float -0.052375
	.float -0.032531
	.float 0.114615
	.float -0.137854
	.float 0.078481
	.float 0.016933
	.float -0.054313
	.float -0.031775
	.float 0.211912
	.float -0.367188
	.float 0.369185
	.float -0.172546
	.float -0.152892
	.float 0.471352
	.float -0.666609
	.float 0.696771
	.float -0.588592
	.float 0.396596
	.float -0.172540
	.float -0.035990
	.float 0.179554
	.float -0.221855
	.float 0.171626
	.float -0.094813
	.float 0.076978
	.float -0.155044
	.float 0.278200
	.float -0.344632
	.float 0.294038
	.float -0.175766
	.float 0.119606
	.float -0.217521
	.float 0.413761
	.float -0.513660
	.float 0.331336
	.float 0.129416
	.float -0.618277
	.float 0.782015
	.float -0.422994
	.float -0.322400
	.float 1.038285
	.float -1.296730
	.float 0.949491
	.float -0.228698
	.float -0.418348
	.float 0.637454
	.float -0.393484
	.float -0.041260
	.float 0.309253
	.float -0.222620
	.float -0.135242
	.float 0.514244
	.float -0.701555
	.float 0.656365
	.float -0.485700
	.float 0.312466
	.float -0.168700
	.float 0.004979
	.float 0.209960
	.float -0.408169
	.float 0.445145
	.float -0.213165
	.float -0.250790
	.float 0.754434
	.float -1.051095
	.float 0.983295
	.float -0.574670
	.float 0.015771
	.float 0.442001
	.float -0.618745
	.float 0.489891
	.float -0.179054
	.float -0.128819
	.float 0.296989
	.float -0.301626
	.float 0.217189
	.float -0.142695
	.float 0.128041
	.float -0.153050
	.float 0.166353
	.float -0.144201
	.float 0.116841
	.float -0.142278
	.float 0.251743
	.float -0.413927
	.float 0.546707
	.float -0.567079
	.float 0.443831
	.float -0.220583
	.float -0.000706
	.float 0.105394
	.float -0.021903
	.float -0.234577
	.float 0.553744
	.float -0.772347
	.float 0.755972
	.float -0.477638
	.float 0.039879
	.float 0.380779
	.float -0.634035
	.float 0.671830
	.float -0.550528
	.float 0.365629
	.float -0.176403
	.float -0.020247
	.float 0.252096
	.float -0.509404
	.float 0.718373
	.float -0.781434
	.float 0.659488
	.float -0.430532
	.float 0.265871
	.float -0.322588
	.float 0.620090
	.float -0.995775
	.float 1.190036
	.float -1.016975
	.float 0.504048
	.float 0.106694
	.float -0.507255
	.float 0.522086
	.float -0.216658
	.float -0.156947
	.float 0.331464
	.float -0.188804
	.float -0.187048
	.float 0.583901
	.float -0.794828
	.float 0.725351
	.float -0.426833
	.float 0.058477
	.float 0.192541
	.float -0.198105
	.float -0.050633
	.float 0.438004
	.float -0.781029
	.float 0.922029
	.float -0.805808
	.float 0.499226
	.float -0.149047
	.float -0.090841
	.float 0.123968
	.float 0.055487
	.float -0.365400
	.float 0.671622
	.float -0.848092
	.float 0.837759
	.float -0.678712
	.float 0.471889
	.float -0.306228
	.float 0.197047
	.float -0.090308
	.float -0.066901
	.float 0.250688
	.float -0.353361
	.float 0.263812
	.float 0.025505
	.float -0.378171
	.float 0.585594
	.float -0.506033
	.float 0.167082
	.float 0.247160
	.float -0.515946
	.float 0.521689
	.float -0.312297
	.float 0.051165
	.float 0.099531
	.float -0.078436
	.float -0.051824
	.float 0.158045
	.float -0.121512
	.float -0.095350
	.float 0.427551
	.float -0.732957
	.float 0.853043
	.float -0.689150
	.float 0.263397
	.float 0.271702
	.float -0.692497
	.float 0.808860
	.float -0.557249
	.float 0.029186
	.float 0.576679
	.float -1.044952
	.float 1.228019
	.float -1.094106
	.float 0.731395
	.float -0.310475
	.float 0.011268
	.float 0.065293
	.float 0.042387
	.float -0.170757
	.float 0.127965
	.float 0.177557
	.float -0.662591
	.float 1.106919
	.float -1.285846
	.float 1.110478
	.float -0.680212
	.float 0.212000
	.float 0.102916
	.float -0.214188
	.float 0.221061
	.float -0.274558
	.float 0.450945
	.float -0.693186
	.float 0.862077
	.float -0.851290
	.float 0.669878
	.float -0.425137
	.float 0.225285
	.float -0.091809
	.float -0.037833
	.float 0.219857
	.float -0.412205
	.float 0.474962
	.float -0.276953
	.float -0.174090
	.float 0.689308
	.float -0.990186
	.float 0.875057
	.float -0.345815
	.float -0.388707
	.float 1.027502
	.float -1.332329
	.float 1.232334
	.float -0.831607
	.float 0.333052
	.float 0.069228
	.float -0.271143
	.float 0.278247
	.float -0.165416
	.float 0.011324
	.float 0.145187
	.float -0.299349
	.float 0.438609
	.float -0.510352
	.float 0.440212
	.float -0.197495
	.float -0.144480
	.float 0.416184
	.float -0.445130
	.float 0.180778
	.float 0.241781
	.float -0.560143
	.float 0.541116
	.float -0.135455
	.float -0.474887
	.float 0.973356
	.float -1.091197
	.float 0.763155
	.float -0.163495
	.float -0.397687
	.float 0.656365
	.float -0.548394
	.float 0.242078
	.float -0.025026
	.float 0.111718
	.float -0.495762
	.float 0.948853
	.float -1.171646
	.float 0.993155
	.float -0.480320
	.float -0.113760
	.float 0.515979
	.float -0.590216
	.float 0.382785
	.float -0.046437
	.float -0.280262
	.float 0.545029
	.float -0.766532
	.float 0.966822
	.float -1.120063
	.float 1.161694
	.float -1.046103
	.float 0.800992
	.float -0.530795
	.float 0.361757
	.float -0.364684
	.float 0.506671
	.float -0.664540
	.float 0.694428
	.float -0.517722
	.float 0.171879
	.float 0.207417
	.float -0.465537
	.float 0.522288
	.float -0.418011
	.float 0.280359
	.float -0.233782
	.float 0.316061
	.float -0.460348
	.float 0.551238
	.float -0.508665
	.float 0.337422
	.float -0.114024
	.float -0.066028
	.float 0.134666
	.float -0.065546
	.float -0.131349
	.float 0.408753
	.float -0.671929
	.float 0.787032
	.float -0.635287
	.float 0.197026
	.float 0.393917
	.float -0.883906
	.float 1.022471
	.float -0.706082
	.float 0.050314
	.float 0.658868
	.float -1.107068
	.float 1.104076
	.float -0.665577
	.float -0.010745
	.float 0.652088
	.float -1.040380
	.float 1.100806
	.float -0.908796
	.float 0.619049
	.float -0.363739
	.float 0.185224
	.float -0.044644
	.float -0.107066
	.float 0.256437
	.float -0.315322
	.float 0.182701
	.float 0.166220
	.float -0.634127
	.float 1.038309
	.float -1.208476
	.float 1.081842
	.float -0.735675
	.float 0.341004
	.float -0.069890
	.float 0.010849
	.float -0.135742
	.float 0.329360
	.float -0.461555
	.float 0.464303
	.float -0.373545
	.float 0.308389
	.float -0.389681
	.float 0.639015
	.float -0.927620
	.float 1.028852
	.float -0.762437
	.float 0.140865
	.float 0.595668
	.float -1.102082
	.float 1.137463
	.float -0.713578
	.float 0.075560
	.float 0.466917
	.float -0.727333
	.float 0.715235
	.float -0.562867
	.float 0.390334
	.float -0.226460
	.float 0.035972
	.float 0.194783
	.float -0.402655
	.float 0.472631
	.float -0.317953
	.float -0.053429
	.float 0.536771
	.float -0.989984
	.float 1.308605
	.float -1.465195
	.float 1.493426
	.float -1.437045
	.float 1.306417
	.float -1.076551
	.float 0.726301
	.float -0.284940
	.float -0.155753
	.float 0.478857
	.float -0.604460
	.float 0.532163
	.float -0.335660
	.float 0.117785
	.float 0.040739
	.float -0.110267
	.float 0.110840
	.float -0.090077
	.float 0.091785
	.float -0.125733
	.float 0.152605
	.float -0.101117
	.float -0.078731
	.float 0.353445
	.float -0.585233
	.float 0.589927
	.float -0.255666
	.float -0.353782
	.float 0.995089
	.float -1.364783
	.float 1.274377
	.float -0.764466
	.float 0.078945
	.float 0.481337
	.float -0.721813
	.float 0.628807
	.float -0.325038
	.float -0.036555
	.float 0.352446
	.float -0.576232
	.float 0.678605
	.float -0.619276
	.float 0.366824
	.float 0.050721
	.float -0.516688
	.float 0.856849
	.float -0.923454
	.float 0.682429
	.float -0.245460
	.float -0.180164
	.float 0.401880
	.float -0.350417
	.float 0.119879
	.float 0.091458
	.float -0.109616
	.float -0.096415
	.float 0.385127
	.float -0.527954
	.float 0.359194
	.float 0.106369
	.float -0.665914
	.float 1.038711
	.float -1.026619
	.float 0.626968
	.float -0.030573
	.float -0.491414
	.float 0.740429
	.float -0.688801
	.float 0.465642
	.float -0.248019
	.float 0.138356
	.float -0.114879
	.float 0.083543
	.float 0.017930
	.float -0.150186
	.float 0.191641
	.float -0.031940
	.float -0.330459
	.float 0.756610
	.float -1.027135
	.float 0.963869
	.float -0.546883
	.float -0.043041
	.float 0.494588
	.float -0.528515
	.float 0.069555
	.float 0.681460
	.float -1.340385
	.float 1.559492
	.float -1.241243
	.float 0.600678
	.float -0.026314
	.float -0.171698
	.float -0.045051
	.float 0.438755
	.float -0.675857
	.float 0.560477
	.float -0.158125
	.float -0.267671
	.float 0.450039
	.float -0.303105
	.float -0.028923
	.float 0.282348
	.float -0.259264
	.float -0.043642
	.float 0.447318
	.float -0.725044
	.float 0.755489
	.float -0.584404
	.float 0.361352
	.float -0.215522
	.float 0.174869
	.float -0.186012
	.float 0.200685
	.float -0.240027
	.float 0.375959
	.float -0.649498
	.float 1.004344
	.float -1.299937
	.float 1.397777
	.float -1.253481
	.float 0.943941
	.float -0.613243
	.float 0.381354
	.float -0.282532
	.float 0.271814
	.float -0.284753
	.float 0.298187
	.float -0.341159
	.float 0.445935
	.float -0.581260
	.float 0.631898
	.float -0.459696
	.float 0.013380
	.float 0.596070
	.float -1.126748
	.float 1.338117
	.float -1.137514
	.float 0.636452
	.float -0.078601
	.float -0.305611
	.float 0.416595
	.float -0.309337
	.float 0.131063
	.float -0.029408
	.float 0.083680
	.float -0.278377
	.float 0.516110
	.float -0.664376
	.float 0.625243
	.float -0.396885
	.float 0.081473
	.float 0.181428
	.float -0.317712
	.float 0.376827
	.float -0.486964
	.float 0.733213
	.float -1.056967
	.float 1.268556
	.float -1.175688
	.float 0.733800
	.float -0.102251
	.float -0.438952
	.float 0.653706
	.float -0.482705
	.float 0.063342
	.float 0.362261
	.float -0.580896
	.float 0.502811
	.float -0.178006
	.float -0.251630
	.float 0.623198
	.float -0.813441
	.float 0.776987
	.float -0.560939
	.float 0.290481
	.float -0.119356
	.float 0.154954
	.float -0.394015
	.float 0.712669
	.float -0.928371
	.float 0.903005
	.float -0.624209
	.float 0.212627
	.float 0.149178
	.float -0.319500
	.float 0.267431
	.float -0.071258
	.float -0.144320
	.float 0.282986
	.float -0.314827
	.float 0.263113
	.float -0.166857
	.float 0.059806
	.float 0.019281
	.float -0.009655
	.float -0.155811
	.float 0.492874
	.float -0.905952
	.float 1.189767
	.float -1.122790
	.float 0.612847
	.float 0.199963
	.float -0.968933
	.float 1.305603
	.float -1.000162
	.float 0.164308
	.float 0.802742
	.float -1.422321
	.float 1.405494
	.float -0.822746
	.float 0.063748
	.float 0.397058
	.float -0.288966
	.float -0.293601
	.float 0.960757
	.float -1.281947
	.float 1.057905
	.float -0.431050
	.float -0.232579
	.float 0.600329
	.float -0.587510
	.float 0.384817
	.float -0.291110
	.float 0.482508
	.float -0.887297
	.float 1.251278
	.float -1.333730
	.float 1.082295
	.float -0.661241
	.float 0.325574
	.float -0.244929
	.float 0.404092
	.float -0.634759
	.float 0.734286
	.float -0.581510
	.float 0.186106
	.float 0.331831
	.float -0.798199
	.float 1.046797
	.float -0.976503
	.float 0.597208
	.float -0.043921
	.float -0.466756
	.float 0.736772
	.float -0.695415
	.float 0.444632
	.float -0.198848
	.float 0.147814
	.float -0.329878
	.float 0.601837
	.float -0.728960
	.float 0.539042
	.float -0.043263
	.float -0.552838
	.float 0.957195
	.float -0.955285
	.float 0.533260
	.float 0.114106
	.float -0.695439
	.float 0.984374
	.float -0.929441
	.float 0.648782
	.float -0.327744
	.float 0.100394
	.float 0.005630
	.float -0.042175
	.float 0.076575
	.float -0.147838
	.float 0.262023
	.float -0.402518
	.float 0.527775
	.float -0.564316
	.float 0.427667
	.float -0.084241
	.float -0.384248
	.float 0.780847
	.float -0.890412
	.float 0.626259
	.float -0.119612
	.float -0.332999
	.float 0.449705
	.float -0.152282
	.float -0.377005
	.float 0.820243
	.float -0.941834
	.float 0.735153
	.float -0.390814
	.float 0.125330
	.float -0.020586
	.float 0.004649
	.float 0.028387
	.float -0.085482
	.float 0.059532
	.float 0.152938
	.float -0.512811
	.float 0.813745
	.float -0.808625
	.float 0.392647
	.float 0.302723
	.float -0.980375
	.float 1.358298
	.float -1.324401
	.float 0.960489
	.float -0.441992
	.float -0.084528
	.float 0.545983
	.float -0.897401
	.float 1.065184
	.float -0.961723
	.float 0.572330
	.float -0.027082
	.float -0.433777
	.float 0.602445
	.float -0.451928
	.float 0.166703
	.float -0.017243
	.float 0.164351
	.float -0.538830
	.float 0.888290
	.float -0.957699
	.float 0.670445
	.float -0.178891
	.float -0.248039
	.float 0.412336
	.float -0.311545
	.float 0.115666
	.float -0.023476
	.float 0.111456
	.float -0.284454
	.float 0.355543
	.float -0.186621
	.float -0.214705
	.float 0.703873
	.float -1.094166
	.float 1.262136
	.float -1.195499
	.float 0.969085
	.float -0.685541
	.float 0.428815
	.float -0.250320
	.float 0.175224
	.float -0.206311
	.float 0.318457
	.float -0.455630
	.float 0.545164
	.float -0.528667
	.float 0.392107
	.float -0.173898
	.float -0.056079
	.float 0.233312
	.float -0.326323
	.float 0.337401
	.float -0.279884
	.float 0.155229
	.float 0.045656
	.float -0.313021
	.float 0.584598
	.float -0.742950
	.float 0.663184
	.float -0.293989
	.float -0.276952
	.float 0.826719
	.float -1.091048
	.float 0.912000
	.float -0.354846
	.float -0.292566
	.float 0.663005
	.float -0.524354
	.float -0.069745
	.float 0.802104
	.float -1.281968
	.float 1.277894
	.float -0.835703
	.float 0.211501
	.float 0.312893
	.float -0.588482
	.float 0.630691
	.float -0.537709
	.float 0.391914
	.float -0.226475
	.float 0.058352
	.float 0.073609
	.float -0.116903
	.float 0.051146
	.float 0.080806
	.float -0.193188
	.float 0.213904
	.float -0.128364
	.float -0.023534
	.float 0.187271
	.float -0.330087
	.float 0.444382
	.float -0.523370
	.float 0.540475
	.float -0.457883
	.float 0.260138
	.float 0.015608
	.float -0.282095
	.float 0.442093
	.float -0.442972
	.float 0.309095
	.float -0.127599
	.float -0.006144
	.float 0.047809
	.float -0.025171
	.float 0.002414
	.float -0.013570
	.float 0.021131
	.float 0.057004
	.float -0.263833
	.float 0.530577
	.float -0.688479
	.float 0.577335
	.float -0.179643
	.float -0.327148
	.float 0.657590
	.float -0.596591
	.float 0.145447
	.float 0.471686
	.float -0.948591
	.float 1.085776
	.float -0.897738
	.float 0.574506
	.float -0.339970
	.float 0.313113
	.float -0.460575
	.float 0.651948
	.float -0.760037
	.float 0.733332
	.float -0.604397
	.float 0.448227
	.float -0.331294
	.float 0.283394
	.float -0.298065
	.float 0.346789
	.float -0.392045
	.float 0.397279
	.float -0.341368
	.float 0.237772
	.float -0.141927
	.float 0.126857
	.float -0.229518
	.float 0.403988
	.float -0.526810
	.float 0.467346
	.float -0.181622
	.float -0.238368
	.float 0.601471
	.float -0.720546
	.float 0.516664
	.float -0.061502
	.float -0.461415
	.float 0.848614
	.float -0.970166
	.float 0.820764
	.float -0.507824
	.float 0.186349
	.float 0.025000
	.float -0.101114
	.float 0.108799
	.float -0.148647
	.float 0.279314
	.float -0.475686
	.float 0.649203
	.float -0.714001
	.float 0.648556
	.float -0.506680
	.float 0.370472
	.float -0.285240
	.float 0.230275
	.float -0.149073
	.float 0.010710
	.float 0.154180
	.float -0.275508
	.float 0.303674
	.float -0.252200
	.float 0.186092
	.float -0.170317
	.float 0.226710
	.float -0.333130
	.float 0.454730
	.float -0.570062
	.float 0.669550
	.float -0.739314
	.float 0.758631
	.float -0.720284
	.float 0.651939
	.float -0.607598
	.float 0.623499
	.float -0.669503
	.float 0.642246
	.float -0.423256
	.float -0.024070
	.float 0.583716
	.float -1.005694
	.float 1.025350
	.float -0.523534
	.float -0.371885
	.float 1.319048
	.float -1.924214
	.float 1.943498
	.float -1.405109
	.float 0.580157
	.float 0.174926
	.float -0.604880
	.float 0.662043
	.float -0.484502
	.float 0.280724
	.float -0.203025
	.float 0.281003
	.float -0.435524
	.float 0.547309
	.float -0.534935
	.float 0.402354
	.float -0.233263
	.float 0.134936
	.float -0.163442
	.float 0.281179
	.float -0.382779
	.float 0.375313
	.float -0.249866
	.float 0.083364
	.float 0.033225
	.float -0.076262
	.float 0.103880
	.float -0.186038
	.float 0.313027
	.float -0.373083
	.float 0.235039
	.float 0.122384
	.float -0.545628
	.float 0.778999
	.float -0.641445
	.float 0.180155
	.float 0.327649
	.float -0.549771
	.float 0.338620
	.float 0.142473
	.float -0.514289
	.float 0.445744
	.float 0.100062
	.float -0.822764
	.float 1.284665
	.float -1.212830
	.float 0.684104
	.float -0.061837
	.float -0.262818
	.float 0.132566
	.float 0.293950
	.float -0.679276
	.float 0.745388
	.float -0.440376
	.float -0.063877
	.float 0.510092
	.float -0.715506
	.float 0.652058
	.float -0.421963
	.float 0.172986
	.float -0.018814
	.float 0.003981
	.float -0.113456
	.float 0.301653
	.float -0.514486
	.float 0.695856
	.float -0.790659
	.float 0.760422
	.float -0.610886
	.float 0.405323
	.float -0.236839
	.float 0.164533
	.float -0.160187
	.float 0.118017
	.float 0.064935
	.float -0.393961
	.float 0.747052
	.float -0.946120
	.float 0.885447
	.float -0.622605
	.float 0.358282
	.float -0.309858
	.float 0.561181
	.float -0.992419
	.float 1.342496
	.float -1.368530
	.float 1.000198
	.float -0.388865
	.float -0.180889
	.float 0.460482
	.float -0.379297
	.float 0.071935
	.float 0.222022
	.float -0.316648
	.float 0.192397
	.float 0.009292
	.float -0.101840
	.float -0.003914
	.float 0.232568
	.float -0.399025
	.float 0.340539
	.float -0.025601
	.float -0.436457
	.float 0.877152
	.float -1.166335
	.float 1.254292
	.float -1.151540
	.float 0.894600
	.float -0.540171
	.float 0.178069
	.float 0.079814
	.float -0.153311
	.float 0.053906
	.float 0.108739
	.float -0.193842
	.float 0.124869
	.float 0.059360
	.float -0.235273
	.float 0.280655
	.float -0.152898
	.float -0.089711
	.float 0.328895
	.float -0.457380
	.float 0.435962
	.float -0.305480
	.float 0.149058
	.float -0.031021
	.float -0.042863
	.float 0.111895
	.float -0.203920
	.float 0.287317
	.float -0.281285
	.float 0.123859
	.float 0.159893
	.float -0.455159
	.float 0.631010
	.float -0.633281
	.float 0.519806
	.float -0.410130
	.float 0.392641
	.float -0.463937
	.float 0.542675
	.float -0.539015
	.float 0.423420
	.float -0.247251
	.float 0.107963
	.float -0.087103
	.float 0.199606
	.float -0.381005
	.float 0.516974
	.float -0.500117
	.float 0.286645
	.float 0.074414
	.float -0.455687
	.float 0.705972
	.float -0.722749
	.float 0.508876
	.float -0.182164
	.float -0.075408
	.float 0.110743
	.float 0.113452
	.float -0.491476
	.float 0.830615
	.float -0.960489
	.float 0.828457
	.float -0.521776
	.float 0.207541
	.float -0.035158
	.float 0.063184
	.float -0.245840
	.float 0.471197
	.float -0.618459
	.float 0.606034
	.float -0.420574
	.float 0.125851
	.float 0.152831
	.float -0.274490
	.float 0.150140
	.float 0.199653
	.float -0.638300
	.float 0.974965
	.float -1.065804
	.float 0.892227
	.float -0.563526
	.float 0.242204
	.float -0.045090
	.float -0.011599
	.float -0.008797
	.float 0.034734
	.float -0.047889
	.float 0.087953
	.float -0.202053
	.float 0.382844
	.float -0.547765
	.float 0.581367
	.float -0.416583
	.float 0.098603
	.float 0.219609
	.float -0.360109
	.float 0.236408
	.float 0.073498
	.float -0.356103
	.float 0.387875
	.float -0.082170
	.float -0.440138
	.float 0.908808
	.float -1.058531
	.float 0.783401
	.float -0.197604
	.float -0.429351
	.float 0.817978
	.float -0.819581
	.float 0.479262
	.float 0.003748
	.float -0.391058
	.float 0.533558
	.float -0.446987
	.float 0.292895
	.float -0.271786
	.float 0.486129
	.float -0.857385
	.float 1.156815
	.float -1.141999
	.float 0.717545
	.float -0.013953
	.float -0.672468
	.float 1.043590
	.float -0.962417
	.float 0.514646
	.float 0.058010
	.float -0.498018
	.float 0.656237
	.float -0.539432
	.float 0.275151
	.float -0.028305
	.float -0.085950
	.float 0.054874
	.float 0.036358
	.float -0.066392
	.float -0.036175
	.float 0.236978
	.float -0.412059
	.float 0.428842
	.float -0.235151
	.float -0.106892
	.float 0.462941
	.float -0.709134
	.float 0.797508
	.float -0.768147
	.float 0.712043
	.float -0.713718
	.float 0.803156
	.float -0.937369
	.float 1.021889
	.float -0.967988
	.float 0.758726
	.float -0.479930
	.float 0.283736
	.float -0.295795
	.float 0.523984
	.float -0.835589
	.float 1.027746
	.float -0.950698
	.float 0.602967
	.float -0.134684
	.float -0.244980
	.float 0.396045
	.float -0.329428
	.float 0.191450
	.float -0.164037
	.float 0.346104
	.float -0.689019
	.float 1.021374
	.float -1.143093
	.float 0.933289
	.float -0.416270
	.float -0.243019
	.float 0.810297
	.float -1.089188
	.float 1.017204
	.float -0.700169
	.float 0.356315
	.float -0.189636
	.float 0.262999
	.float -0.455988
	.float 0.545283
	.float -0.361582
	.float -0.082445
	.float 0.583877
	.float -0.869671
	.float 0.765793
	.float -0.304556
	.float -0.296448
	.float 0.766073
	.float -0.937214
	.float 0.832415
	.float -0.625499
	.float 0.503818
	.float -0.522747
	.float 0.555613
	.float -0.385312
	.float -0.115872
	.float 0.845803
	.float -1.486157
	.float 1.683488
	.float -1.286531
	.float 0.473796
	.float 0.329449
	.float -0.701733
	.float 0.480174
	.float 0.150950
	.float -0.792608
	.float 1.086420
	.float -0.917749
	.float 0.442501
	.float 0.053054
	.float -0.340685
	.float 0.359820
	.float -0.201339
	.float 0.012627
	.float 0.094908
	.float -0.085944
	.float -0.007437
	.float 0.114045
	.float -0.153954
	.float 0.071962
	.float 0.126264
	.float -0.355349
	.float 0.477614
	.float -0.380335
	.float 0.061070
	.float 0.343314
	.float -0.620048
	.float 0.604448
	.float -0.282812
	.float -0.198677
	.float 0.625454
	.float -0.844072
	.float 0.845085
	.float -0.750694
	.float 0.720403
	.float -0.835014
	.float 1.030363
	.float -1.125309
	.float 0.937265
	.float -0.420654
	.float -0.263770
	.float 0.811716
	.float -0.948585
	.float 0.605756
	.float 0.025066
	.float -0.608248
	.float 0.877984
	.float -0.801442
	.float 0.576417
	.float -0.468115
	.float 0.605697
	.float -0.887208
	.float 1.060078
	.float -0.915964
	.float 0.454825
	.float 0.103319
	.float -0.467472
	.float 0.473811
	.float -0.186551
	.float -0.166199
	.float 0.360872
	.float -0.315205
	.float 0.098603
	.float 0.164588
	.float -0.394089
	.float 0.568167
	.float -0.663330
	.float 0.606019
	.float -0.308318
	.float -0.231665
	.float 0.861406
	.float -1.320449
	.float 1.390040
	.float -1.040631
	.float 0.463043
	.float 0.046250
	.float -0.265486
	.float 0.167476
	.float 0.096893
	.float -0.324490
	.float 0.395523
	.float -0.327261
	.float 0.226863
	.float -0.196666
	.float 0.265880
	.float -0.385467
	.float 0.471361
	.float -0.455130
	.float 0.313456
	.float -0.073163
	.float -0.198257
	.float 0.412130
	.float -0.490704
	.float 0.406908
	.float -0.210714
	.float 0.017004
	.float 0.049593
	.float 0.075272
	.float -0.354622
	.float 0.665336
	.float -0.859001
	.float 0.830022
	.float -0.554591
	.float 0.089876
	.float 0.452694
	.float -0.940561
	.float 1.250384
	.float -1.297049
	.float 1.061193
	.float -0.604967
	.float 0.060104
	.float 0.417522
	.float -0.711191
	.float 0.791568
	.float -0.720332
	.float 0.606257
	.float -0.541954
	.float 0.562331
	.float -0.645838
	.float 0.745278
	.float -0.815215
	.float 0.815072
	.float -0.698968
	.float 0.421030
	.float 0.029912
	.float -0.588046
	.float 1.103864
	.float -1.399014
	.float 1.363091
	.float -1.031850
	.float 0.586556
	.float -0.259716
	.float 0.198125
	.float -0.372055
	.float 0.596967
	.float -0.660353
	.float 0.469308
	.float -0.115772
	.float -0.185930
	.float 0.242222
	.float -0.001010
	.float -0.429021
	.float 0.860664
	.float -1.142110
	.float 1.225065
	.float -1.156246
	.float 1.017896
	.float -0.866136
	.float 0.702559
	.float -0.487390
	.float 0.181175
	.float 0.208530
	.float -0.603619
	.float 0.876252
	.float -0.911985
	.float 0.680951
	.float -0.268082
	.float -0.165113
	.float 0.466372
	.float -0.568584
	.float 0.505088
	.float -0.360884
	.float 0.203179
	.float -0.044559
	.float -0.140390
	.float 0.367766
	.float -0.607741
	.float 0.785929
	.float -0.819075
	.float 0.660454
	.float -0.328957
	.float -0.092541
	.float 0.488448
	.float -0.756196
	.float 0.844093
	.float -0.760988
	.float 0.554591
	.float -0.275625
	.float -0.045363
	.float 0.394185
	.float -0.750500
	.float 1.069789
	.float -1.285664
	.float 1.331933
	.float -1.171652
	.float 0.820982
	.float -0.358899
	.float -0.086308
	.float 0.378946
	.float -0.435843
	.float 0.273159
	.float -0.004289
	.float -0.220580
	.float 0.301063
	.float -0.243212
	.float 0.146555
	.float -0.127919
	.float 0.233223
	.float -0.398200
	.float 0.488973
	.float -0.399556
	.float 0.139954
	.float 0.154097
	.float -0.308324
	.float 0.238790
	.float -0.024757
	.float -0.140592
	.float 0.094249
	.float 0.166409
	.float -0.473585
	.float 0.613607
	.float -0.491008
	.float 0.203382
	.float 0.032409
	.float -0.046025
	.float -0.153215
	.float 0.372770
	.float -0.364598
	.float -0.003947
	.float 0.647465
	.float -1.292504
	.float 1.623083
	.float -1.458886
	.float 0.865734
	.float -0.133832
	.float -0.370705
	.float 0.404828
	.float 0.012439
	.float -0.606105
	.float 1.002543
	.float -0.951026
	.float 0.476380
	.float 0.135005
	.float -0.509669
	.float 0.413203
	.float 0.112244
	.float -0.778707
	.float 1.224064
	.float -1.216043
	.float 0.772505
	.float -0.138335
	.float -0.358679
	.float 0.489771
	.float -0.244647
	.float -0.176875
	.float 0.494469
	.float -0.518694
	.float 0.256481
	.float 0.114882
	.float -0.383995
	.float 0.453478
	.float -0.396307
	.float 0.382031
	.float -0.529352
	.float 0.795562
	.float -0.988946
	.float 0.902140
	.float -0.473850
	.float -0.141757
	.float 0.656287
	.float -0.827760
	.float 0.613953
	.float -0.190685
	.float -0.172036
	.float 0.281374
	.float -0.122051
	.float -0.167451
	.float 0.403040
	.float -0.461225
	.float 0.322457
	.float -0.048768
	.float -0.268247
	.float 0.553080
	.float -0.770257
	.float 0.925674
	.float -1.047524
	.float 1.153564
	.float -1.222514
	.float 1.193621
	.float -1.003965
	.float 0.643063
	.float -0.183230
	.float -0.243842
	.float 0.512951
	.float -0.566480
	.float 0.425808
	.float -0.150456
	.float -0.211712
	.float 0.632861
	.float -1.065306
	.float 1.400993
	.float -1.490765
	.float 1.235345
	.float -0.687391
	.float 0.074358
	.float 0.301808
	.float -0.238519
	.float -0.233915
	.float 0.854816
	.float -1.276648
	.float 1.259728
	.float -0.796834
	.float 0.098025
	.float 0.542469
	.float -0.905276
	.float 0.935477
	.float -0.723291
	.float 0.410136
	.float -0.095226
	.float -0.197488
	.float 0.484842
	.float -0.764717
	.float 0.984410
	.float -1.062293
	.float 0.946809
	.float -0.670445
	.float 0.357847
	.float -0.172421
	.float 0.221787
	.float -0.475966
	.float 0.758562
	.float -0.836320
	.float 0.566316
	.float -0.006559
	.float -0.595337
	.float 0.942985
	.float -0.874282
	.float 0.462628
	.float 0.033033
	.float -0.332406
	.float 0.297578
	.float 0.008638
	.float -0.392745
	.float 0.662350
	.float -0.724337
	.float 0.596562
	.float -0.353427
	.float 0.066268
	.float 0.217991
	.float -0.464935
	.float 0.643793
	.float -0.742438
	.float 0.787693
	.float -0.834534
	.float 0.915555
	.float -0.989510
	.float 0.944666
	.float -0.674251
	.float 0.176081
	.float 0.403526
	.float -0.828788
	.float 0.908027
	.float -0.614489
	.float 0.112613
	.float 0.329026
	.float -0.482872
	.float 0.277351
	.float 0.181176
	.float -0.681827
	.float 1.026286
	.float -1.121082
	.float 1.001205
	.float -0.784722
	.float 0.594607
	.float -0.494698
	.float 0.471501
	.float -0.464488
	.float 0.419900
	.float -0.331559
	.float 0.243049
	.float -0.213375
	.float 0.273134
	.float -0.402939
	.float 0.544964
	.float -0.632903
	.float 0.616942
	.float -0.475266
	.float 0.220893
	.float 0.089935
	.float -0.359796
	.float 0.482332
	.float -0.402372
	.float 0.165216
	.float 0.093014
	.float -0.224984
	.float 0.172483
	.float -0.010249
	.float -0.108139
	.float 0.067816
	.float 0.114387
	.float -0.294899
	.float 0.304911
	.float -0.073886
	.float -0.314717
	.float 0.671908
	.float -0.817361
	.float 0.680778
	.float -0.331705
	.float -0.067664
	.float 0.349034
	.float -0.415364
	.float 0.277016
	.float -0.037676
	.float -0.160395
	.float 0.206898
	.float -0.076250
	.float -0.164655
	.float 0.398176
	.float -0.522029
	.float 0.501732
	.float -0.382355
	.float 0.259300
	.float -0.228692
	.float 0.342381
	.float -0.583823
	.float 0.870041
	.float -1.079192
	.float 1.098380
	.float -0.877232
	.float 0.462727
	.float 0.009714
	.float -0.375813
	.float 0.526393
	.float -0.465323
	.float 0.300404
	.float -0.168825
	.float 0.147562
	.float -0.211849
	.float 0.268724
	.float -0.234056
	.float 0.090274
	.float 0.116126
	.float -0.322999
	.float 0.495104
	.float -0.621991
	.float 0.682232
	.float -0.621648
	.float 0.381235
	.float 0.040551
	.float -0.546457
	.float 0.965535
	.float -1.136676
	.float 0.992973
	.float -0.588681
	.float 0.056242
	.float 0.466124
	.float -0.883187
	.float 1.146542
	.float -1.235389
	.float 1.149409
	.float -0.922840
	.float 0.634202
	.float -0.381145
	.float 0.224906
	.float -0.148744
	.float 0.076816
	.float 0.049396
	.float -0.198795
	.float 0.254269
	.float -0.106215
	.float -0.233135
	.float 0.594931
	.float -0.745171
	.float 0.547557
	.float -0.078278
	.float -0.399764
	.float 0.594454
	.float -0.369107
	.float -0.171189
	.float 0.747308
	.float -1.078661
	.float 1.044943
	.float -0.736298
	.float 0.371810
	.float -0.152440
	.float 0.146906
	.float -0.274119
	.float 0.375146
	.float -0.316269
	.float 0.061308
	.float 0.315247
	.float -0.667607
	.float 0.846563
	.float -0.770630
	.float 0.473915
	.float -0.103007
	.float -0.151833
	.float 0.168484
	.float 0.015732
	.float -0.203701
	.float 0.150710
	.float 0.269646
	.float -0.957303
	.float 1.620499
	.float -1.943125
	.float 1.776544
	.float -1.224591
	.float 0.564972
	.float -0.067972
	.float -0.157955
	.float 0.192819
	.float -0.204404
	.float 0.310121
	.float -0.503839
	.float 0.686521
	.float -0.758523
	.float 0.695418
	.float -0.555866
	.float 0.427238
	.float -0.357939
	.float 0.325813
	.float -0.260158
	.float 0.095952
	.float 0.178699
	.float -0.510259
	.float 0.803466
	.float -0.961148
	.float 0.919880
	.float -0.674415
	.float 0.292548
	.float 0.085374
	.float -0.280346
	.float 0.152262
	.float 0.304187
	.float -0.908301
	.float 1.348752
	.float -1.345908
	.float 0.835354
	.float -0.044684
	.float -0.613470
	.float 0.784597
	.float -0.396471
	.float -0.293202
	.float 0.864798
	.float -1.005533
	.float 0.692446
	.float -0.172538
	.float -0.225054
	.float 0.296113
	.float -0.049262
	.float -0.353883
	.float 0.726874
	.float -0.952796
	.float 1.002534
	.float -0.905997
	.float 0.723965
	.float -0.535376
	.float 0.421048
	.float -0.428049
	.float 0.532017
	.float -0.633323
	.float 0.606040
	.float -0.376871
	.float -0.017690
	.float 0.438451
	.float -0.717163
	.float 0.754282
	.float -0.579013
	.float 0.329410
	.float -0.159272
	.float 0.130172
	.float -0.165379
	.float 0.107890
	.float 0.148204
	.float -0.545637
	.float 0.865841
	.float -0.864697
	.float 0.458733
	.float 0.175827
	.float -0.682056
	.float 0.745442
	.float -0.312574
	.float -0.353671
	.float 0.833908
	.float -0.823635
	.float 0.330147
	.float 0.338811
	.float -0.780200
	.float 0.747463
	.float -0.281997
	.float -0.344050
	.float 0.808953
	.float -0.915081
	.float 0.658755
	.float -0.189381
	.float -0.282460
	.float 0.565580
	.float -0.535695
	.float 0.161002
	.float 0.483501
	.float -1.222201
	.float 1.823028
	.float -2.079750
	.float 1.900943
	.float -1.358343
	.float 0.660549
	.float -0.057716
	.float -0.275598
	.float 0.315429
	.float -0.179274
	.float 0.041615
	.float -0.028520
	.float 0.155551
	.float -0.340504
	.float 0.471051
	.float -0.477143
	.float 0.363990
	.float -0.196255
	.float 0.054821
	.float 0.003205
	.float 0.035754
	.float -0.141350
	.float 0.250295
	.float -0.285382
	.float 0.184393
	.float 0.065609
	.float -0.406324
	.float 0.720907
	.float -0.885372
	.float 0.832195
	.float -0.584389
	.float 0.236499
	.float 0.101152
	.float -0.353123
	.float 0.493709
	.float -0.530443
	.float 0.483259
	.float -0.378421
	.float 0.250735
	.float -0.135600
	.float 0.046689
	.float 0.042131
	.float -0.186813
	.float 0.430913
	.float -0.756285
	.float 1.065827
	.float -1.221369
	.float 1.122298
	.float -0.776645
	.float 0.312180
	.float 0.088497
	.float -0.291800
	.float 0.287801
	.float -0.185363
	.float 0.133512
	.float -0.224829
	.float 0.443667
	.float -0.684748
	.float 0.818383
	.float -0.755620
	.float 0.479632
	.float -0.042563
	.float -0.452429
	.float 0.869605
	.float -1.065923
	.float 0.938535
	.float -0.490332
	.float -0.127549
	.float 0.649560
	.float -0.820028
	.float 0.546698
	.float 0.024509
	.float -0.586887
	.float 0.868276
	.float -0.810711
	.float 0.598249
	.float -0.506549
	.float 0.685478
	.float -1.042437
	.float 1.315287
	.float -1.274890
	.float 0.897681
	.float -0.377610
	.float -0.022308
	.float 0.156207
	.float -0.078401
	.float -0.026404
	.float -0.004783
	.float 0.201602
	.float -0.464357
	.float 0.661280
	.float -0.729723
	.float 0.703757
	.float -0.659459
	.float 0.635481
	.float -0.598174
	.float 0.476729
	.float -0.234029
	.float -0.088197
	.float 0.387124
	.float -0.565279
	.float 0.593176
	.float -0.520747
	.float 0.432487
	.float -0.385398
	.float 0.378618
	.float -0.373396
	.float 0.339821
	.float -0.287882
	.float 0.260127
	.float -0.298220
	.float 0.413904
	.float -0.583868
	.float 0.764389
	.float -0.910643
	.float 0.991080
	.float -0.995939
	.float 0.938353
	.float -0.843634
	.float 0.729294
	.float -0.591084
	.float 0.412533
	.float -0.195662
	.float -0.014152
	.float 0.138803
	.float -0.115798
	.float -0.048575
	.float 0.264345
	.float -0.398977
	.float 0.351877
	.float -0.117320
	.float -0.201575
	.float 0.437160
	.float -0.440159
	.float 0.162852
	.float 0.299990
	.float -0.742429
	.float 0.946981
	.float -0.804908
	.float 0.383837
	.float 0.108899
	.float -0.452075
	.float 0.543816
	.float -0.449583
	.float 0.333070
	.float -0.325667
	.float 0.434299
	.float -0.552522
	.float 0.556087
	.float -0.401776
	.float 0.154498
	.float 0.069576
	.float -0.190462
	.float 0.213988
	.float -0.213587
	.float 0.268513
	.float -0.408479
	.float 0.597074
	.float -0.752038
	.float 0.781038
	.float -0.617294
	.float 0.252076
	.float 0.241923
	.float -0.714675
	.float 0.988219
	.float -0.939974
	.float 0.572736
	.float -0.018680
	.float -0.533081
	.float 0.937110
	.float -1.148392
	.float 1.199075
	.float -1.127318
	.float 0.929391
	.float -0.583060
	.float 0.121293
	.float 0.318019
	.float -0.530571
	.float 0.367861
	.float 0.137201
	.float -0.743451
	.float 1.117875
	.float -1.038082
	.float 0.547244
	.float 0.057973
	.float -0.417629
	.float 0.354232
	.float 0.004316
	.float -0.323780
	.float 0.318177
	.float 0.031494
	.float -0.463090
	.float 0.634098
	.float -0.381059
	.float -0.159818
	.float 0.653626
	.float -0.801865
	.float 0.535048
	.float -0.037088
	.float -0.392450
	.float 0.525585
	.float -0.321357
	.float -0.081535
	.float 0.461308
	.float -0.626363
	.float 0.486934
	.float -0.068853
	.float -0.514176
	.float 1.104118
	.float -1.541472
	.float 1.703856
	.float -1.539490
	.float 1.088357
	.float -0.476818
	.float -0.122784
	.float 0.556454
	.float -0.746336
	.float 0.710451
	.float -0.535718
	.float 0.324859
	.float -0.150885
	.float 0.039814
	.float 0.021298
	.float -0.066393
	.float 0.133916
	.float -0.251743
	.float 0.421510
	.float -0.607351
	.float 0.740110
	.float -0.743496
	.float 0.575239
	.float -0.262614
	.float -0.091724
	.float 0.346462
	.float -0.391067
	.float 0.212338
	.float 0.086457
	.float -0.336963
	.float 0.405162
	.float -0.275543
	.float 0.059075
	.float 0.085246
	.float -0.060438
	.float -0.107749
	.float 0.302908
	.float -0.413325
	.float 0.412524
	.float -0.362404
	.float 0.342319
	.float -0.368592
	.float 0.375125
	.float -0.273640
	.float 0.042828
	.float 0.231917
	.float -0.410598
	.float 0.407958
	.float -0.271491
	.float 0.154977
	.float -0.196953
	.float 0.398659
	.float -0.607706
	.float 0.632351
	.float -0.398727
	.float 0.018429
	.float 0.296919
	.float -0.407138
	.float 0.356831
	.float -0.331804
	.float 0.493193
	.float -0.829247
	.float 1.150139
	.float -1.232230
	.float 0.993381
	.float -0.557500
	.float 0.158486
	.float 0.037395
	.float -0.048223
	.float 0.042492
	.float -0.184272
	.float 0.481492
	.float -0.757891
	.float 0.771843
	.float -0.392555
	.float -0.299069
	.float 1.057095
	.float -1.622776
	.float 1.863580
	.float -1.802245
	.float 1.538050
	.float -1.150068
	.float 0.673553
	.float -0.156897
	.float -0.279139
	.float 0.464956
	.float -0.291925
	.float -0.179661
	.float 0.717864
	.float -1.044177
	.float 1.002430
	.float -0.646875
	.float 0.186877
	.float 0.164603
	.float -0.321143
	.float 0.340402
	.float -0.330817
	.float 0.334635
	.float -0.284771
	.float 0.066534
	.float 0.369432
	.float -0.934207
	.float 1.425114
	.float -1.633702
	.float 1.466718
	.float -1.005118
	.float 0.466411
	.float -0.091678
	.float 0.019239
	.float -0.213840
	.float 0.491351
	.float -0.626715
	.float 0.483173
	.float -0.086203
	.float -0.399821
	.float 0.772043
	.float -0.898453
	.float 0.769259
	.float -0.470574
	.float 0.113197
	.float 0.227308
	.float -0.522816
	.float 0.761870
	.float -0.911967
	.float 0.912760
	.float -0.711685
	.float 0.318037
	.float 0.167396
	.float -0.578130
	.float 0.758145
	.float -0.647155
	.float 0.323494
	.float 0.025112
	.float -0.192640
	.float 0.062103
	.float 0.328859
	.float -0.804065
	.float 1.143105
	.float -1.201954
	.float 0.986923
	.float -0.635242
	.float 0.320186
	.float -0.150946
	.float 0.135843
	.float -0.220193
	.float 0.348882
	.float -0.492087
	.float 0.620364
	.float -0.671288
	.float 0.560808
	.float -0.245815
	.float -0.212894
	.float 0.651012
	.float -0.881992
	.float 0.809683
	.float -0.491616
	.float 0.103814
	.float 0.171274
	.float -0.256332
	.float 0.212720
	.float -0.174804
	.float 0.234793
	.float -0.363382
	.float 0.426842
	.float -0.292419
	.float -0.051086
	.float 0.447893
	.float -0.649614
	.float 0.472887
	.float 0.060445
	.float -0.702654
	.float 1.109894
	.float -1.051974
	.float 0.566507
	.float 0.053256
	.float -0.440588
	.float 0.390456
	.float 0.013577
	.float -0.470646
	.float 0.679335
	.float -0.540165
	.float 0.196371
	.float 0.107381
	.float -0.226698
	.float 0.214153
	.float -0.237412
	.float 0.397398
	.float -0.609735
	.float 0.658359
	.float -0.380785
	.float -0.171465
	.float 0.737365
	.float -1.019204
	.float 0.886403
	.float -0.449169
	.float -0.048010
	.float 0.414029
	.float -0.622641
	.float 0.767003
	.float -0.917323
	.float 1.020369
	.float -0.932991
	.float 0.557348
	.float 0.043830
	.float -0.652925
	.float 1.021454
	.float -1.015139
	.float 0.677923
	.float -0.185416
	.float -0.258960
	.float 0.509270
	.float -0.507428
	.float 0.274368
	.float 0.106328
	.float -0.504876
	.float 0.778421
	.float -0.829086
	.float 0.661357
	.float -0.393446
	.float 0.200094
	.float -0.216229
	.float 0.463531
	.float -0.845833
	.float 1.207853
	.float -1.411359
	.float 1.385119
	.float -1.137091
	.float 0.743853
	.float -0.330227
	.float 0.036046
	.float 0.034665
	.float 0.132813
	.float -0.442835
	.float 0.727145
	.float -0.830761
	.float 0.697099
	.float -0.397189
	.float 0.081834
	.float 0.112478
	.float -0.141151
	.float 0.061429
	.float 0.027112
	.float -0.063556
	.float 0.065831
	.float -0.102370
	.float 0.223025
	.float -0.408753
	.float 0.580718
	.float -0.657643
	.float 0.611860
	.float -0.480371
	.float 0.329479
	.float -0.208921
	.float 0.131882
	.float -0.087791
	.float 0.064628
	.float -0.055946
	.float 0.050292
	.float -0.022191
	.float -0.055383
	.float 0.179105
	.float -0.290191
	.float 0.287665
	.float -0.089220
	.float -0.290603
	.float 0.703894
	.float -0.920521
	.float 0.756935
	.float -0.206994
	.float -0.520813
	.float 1.102300
	.float -1.280248
	.float 1.012590
	.float -0.486496
	.float -0.009887
	.float 0.269167
	.float -0.278967
	.float 0.199733
	.float -0.231527
	.float 0.466035
	.float -0.822469
	.float 1.103918
	.float -1.128724
	.float 0.843842
	.float -0.347108
	.float -0.186584
	.float 0.611273
	.float -0.870073
	.float 0.977498
	.float -0.960191
	.float 0.821232
	.float -0.561616
	.float 0.229428
	.float 0.064171
	.float -0.193743
	.float 0.101650
	.float 0.154460
	.float -0.430964
	.float 0.582947
	.float -0.539876
	.float 0.322505
	.float -0.005738
	.float -0.327697
	.float 0.605253
	.float -0.758735
	.float 0.728522
	.float -0.498275
	.float 0.137692
	.float 0.197715
	.float -0.339267
	.float 0.218505
	.float 0.061693
	.float -0.269902
	.float 0.195884
	.float 0.190498
	.float -0.695486
	.float 1.022316
	.float -0.979868
	.float 0.622778
	.float -0.209391
	.float 0.004113
	.float -0.077119
	.float 0.262287
	.float -0.308088
	.float 0.098827
	.float 0.235889
	.float -0.415915
	.float 0.236264
	.float 0.256507
	.float -0.779220
	.float 1.009887
	.float -0.817659
	.float 0.351740
	.float 0.073435
	.float -0.205255
	.float 0.020164
	.float 0.287477
	.float -0.473480
	.float 0.431515
	.float -0.258171
	.float 0.157371
	.float -0.270910
	.float 0.569326
	.float -0.877963
	.float 1.004543
	.float -0.866005
	.float 0.528303
	.float -0.146631
	.float -0.139298
	.float 0.282846
	.float -0.338927
	.float 0.409856
	.float -0.568131
	.float 0.803400
	.float -1.022807
	.float 1.102714
	.float -0.960617
	.float 0.605449
	.float -0.138266
	.float -0.295860
	.float 0.576420
	.float -0.658624
	.float 0.581421
	.float -0.432117
	.float 0.292577
	.float -0.200162
	.float 0.144054
	.float -0.090686
	.float 0.013143
	.float 0.097424
	.float -0.239772
	.float 0.411543
	.float -0.603581
	.float 0.784364
	.float -0.896072
	.float 0.877775
	.float -0.705429
	.float 0.416813
	.float -0.095837
	.float -0.177734
	.float 0.375119
	.float -0.522831
	.float 0.658785
	.float -0.778311
	.float 0.820991
	.float -0.717855
	.float 0.462154
	.float -0.138722
	.float -0.124513
	.float 0.250909
	.float -0.275487
	.float 0.312592
	.float -0.450391
	.float 0.661169
	.float -0.809331
	.float 0.757406
	.float -0.482600
	.float 0.102787
	.float 0.213546
	.float -0.379953
	.float 0.455645
	.float -0.585334
	.float 0.863224
	.float -1.231658
	.float 1.499131
	.float -1.468996
	.float 1.085010
	.float -0.486830
	.float -0.065876
	.float 0.346879
	.float -0.288861
	.float 0.001055
	.float 0.320290
	.float -0.516056
	.float 0.537992
	.float -0.436451
	.float 0.292831
	.float -0.158075
	.float 0.037818
	.float 0.081308
	.float -0.200094
	.float 0.300020
	.float -0.362744
	.float 0.393094
	.float -0.421835
	.float 0.483662
	.float -0.587209
	.float 0.700574
	.float -0.764118
	.float 0.721762
	.float -0.549461
	.float 0.263368
	.float 0.092797
	.float -0.467296
	.float 0.811430
	.float -1.078939
	.float 1.223870
	.float -1.209573
	.float 1.029084
	.float -0.722010
	.float 0.368556
	.float -0.056662
	.float -0.158596
	.float 0.272910
	.float -0.313411
	.float 0.299862
	.float -0.222752
	.float 0.059740
	.float 0.185796
	.float -0.463108
	.float 0.691868
	.float -0.803069
	.float 0.765492
	.float -0.580935
	.float 0.268328
	.float 0.132869
	.float -0.540004
	.float 0.823122
	.float -0.854050
	.float 0.594708
	.float -0.158815
	.float -0.216647
	.float 0.294208
	.float 0.018086
	.float -0.594896
	.float 1.150848
	.float -1.397095
	.float 1.201898
	.float -0.656433
	.float 0.007942
	.float 0.491897
	.float -0.721935
	.float 0.725553
	.float -0.634432
	.float 0.550379
	.float -0.477060
	.float 0.345108
	.float -0.098769
	.float -0.232398
	.float 0.532887
	.float -0.669580
	.float 0.576593
	.float -0.297935
	.float -0.037633
	.float 0.290205
	.float -0.383500
	.float 0.336713
	.float -0.238491
	.float 0.185872
	.float -0.229673
	.float 0.357319
	.float -0.511791
	.float 0.622811
	.float -0.630512
	.float 0.502531
	.float -0.251735
	.float -0.053325
	.float 0.309504
	.float -0.439118
	.float 0.453949
	.float -0.462342
	.float 0.590648
	.float -0.865904
	.float 1.157119
	.float -1.243410
	.float 0.977328
	.float -0.423641
	.float -0.143585
	.float 0.402605
	.float -0.199191
	.float -0.336373
	.float 0.857314
	.float -1.011917
	.float 0.660681
	.float 0.038585
	.float -0.726036
	.float 1.051012
	.float -0.870529
	.float 0.322591
	.float 0.260892
	.float -0.545882
	.float 0.383142
	.float 0.112243
	.float -0.629079
	.float 0.835571
	.float -0.563467
	.float -0.098955
	.float 0.852745
	.float -1.343840
	.float 1.341631
	.float -0.845440
	.float 0.068515
	.float 0.683183
	.float -1.164505
	.float 1.294322
	.float -1.161310
	.float 0.943071
	.float -0.794009
	.float 0.766678
	.float -0.803710
	.float 0.794268
	.float -0.653426
	.float 0.375164
	.float -0.031299
	.float -0.274443
	.float 0.460885
	.float -0.498260
	.float 0.403794
	.float -0.222824
	.float 0.016762
	.float 0.141391
	.float -0.181168
	.float 0.068044
	.float 0.161670
	.float -0.399559
	.float 0.516530
	.float -0.443783
	.float 0.229206
	.float -0.023084
	.float -0.007891
	.float -0.210841
	.float 0.600141
	.float -0.957237
	.float 1.067619
	.float -0.835515
	.float 0.351153
	.float 0.154181
	.float -0.445807
	.float 0.432141
	.float -0.221629
	.float 0.046556
	.float -0.100284
	.float 0.399439
	.float -0.769664
	.float 0.967114
	.float -0.849150
	.float 0.470702
	.float -0.039311
	.float -0.230609
	.float 0.250980
	.float -0.087021
	.float -0.122127
	.float 0.265674
	.float -0.301874
	.float 0.228088
	.float -0.043791
	.float -0.235586
	.float 0.530240
	.float -0.689329
	.float 0.573031
	.float -0.174941
	.float -0.328704
	.float 0.671255
	.float -0.674567
	.float 0.371778
	.float 0.029872
	.float -0.315462
	.float 0.417024
	.float -0.431095
	.float 0.498486
	.float -0.661938
	.float 0.824517
	.float -0.831977
	.float 0.596165
	.float -0.157388
	.float -0.347275
	.float 0.762279
	.float -0.973475
	.float 0.928795
	.float -0.642047
	.float 0.198050
	.float 0.257211
	.float -0.567395
	.float 0.646648
	.float -0.532303
	.float 0.355630
	.float -0.241062
	.float 0.213054
	.float -0.191920
	.float 0.085138
	.float 0.106525
	.float -0.266095
	.float 0.246420
	.float 0.007390
	.float -0.405219
	.float 0.774314
	.float -0.981939
	.float 1.014471
	.float -0.953470
	.float 0.881730
	.float -0.808002
	.float 0.672453
	.float -0.417102
	.float 0.052516
	.float 0.334438
	.float -0.628149
	.float 0.740518
	.float -0.636947
	.float 0.333598
	.float 0.107611
	.float -0.574476
	.float 0.911043
	.float -0.964194
	.float 0.666060
	.float -0.102183
	.float -0.495601
	.float 0.849490
	.float -0.779402
	.float 0.302401
	.float 0.375032
	.float -0.965648
	.float 1.241794
	.float -1.128528
	.float 0.710478
	.float -0.169993
	.float -0.296237
	.float 0.543936
	.float -0.519210
	.float 0.270821
	.float 0.065814
	.float -0.320007
	.float 0.365802
	.float -0.193907
	.float -0.073745
	.float 0.248858
	.float -0.188374
	.float -0.117842
	.float 0.539897
	.float -0.882088
	.float 0.987867
	.float -0.814342
	.float 0.445061
	.float -0.046400
	.float -0.207228
	.float 0.209744
	.float 0.027324
	.float -0.377235
	.float 0.657784
	.float -0.722972
	.float 0.536797
	.float -0.186879
	.float -0.167581
	.float 0.379053
	.float -0.378186
	.float 0.193157
	.float 0.078004
	.float -0.319989
	.float 0.451440
	.float -0.455586
	.float 0.381136
	.float -0.314699
	.float 0.336027
	.float -0.475623
	.float 0.694801
	.float -0.899967
	.float 0.986791
	.float -0.893819
	.float 0.638309
	.float -0.312419
	.float 0.038103
	.float 0.097805
	.float -0.090534
	.float 0.016148
	.float 0.020557
	.float 0.043164
	.float -0.185629
	.float 0.316320
	.float -0.339484
	.float 0.222810
	.float -0.024885
	.float -0.135984
	.float 0.151563
	.float 0.010785
	.float -0.284654
	.float 0.536380
	.float -0.634455
	.float 0.520438
	.float -0.244238
	.float -0.054460
	.float 0.210736
	.float -0.113600
	.float -0.238112
	.float 0.730361
	.float -1.181175
	.float 1.418503
	.float -1.351973
	.float 1.006418
	.float -0.504251
	.float 0.006869
	.float 0.356157
	.float -0.537215
	.float 0.576280
	.float -0.560492
	.float 0.562447
	.float -0.596162
	.float 0.619830
	.float -0.580354
	.float 0.461698
	.float -0.296757
	.float 0.135403
	.float -0.002412
	.float -0.111488
	.float 0.215154
	.float -0.274065
	.float 0.208496
	.float 0.049800
	.float -0.478443
	.float 0.927760
	.float -1.171876
	.float 1.033227
	.float -0.507583
	.float -0.198389
	.float 0.759760
	.float -0.912926
	.float 0.612495
	.float -0.059127
	.float -0.425107
	.float 0.592353
	.float -0.406783
	.float 0.041391
	.float 0.248212
	.float -0.278752
	.float 0.028247
	.float 0.376025
	.float -0.740641
	.float 0.903285
	.float -0.798152
	.float 0.471325
	.float -0.051529
	.float -0.303573
	.float 0.462450
	.float -0.361102
	.float 0.026764
	.float 0.416503
	.float -0.771119
	.float 0.833020
	.float -0.495715
	.float -0.157843
	.float 0.850483
	.float -1.233547
	.float 1.089096
	.float -0.485086
	.float -0.238945
	.float 0.670328
	.float -0.583340
	.float 0.080428
	.float 0.488394
	.float -0.768568
	.float 0.628801
	.float -0.216074
	.float -0.180978
	.float 0.337458
	.float -0.213484
	.float -0.071802
	.float 0.355877
	.float -0.531725
	.float 0.569946
	.float -0.484806
	.float 0.301600
	.float -0.055627
	.float -0.194978
	.float 0.377822
	.float -0.444021
	.float 0.405678
	.float -0.335142
	.float 0.316722
	.float -0.383306
	.float 0.486666
	.float -0.529051
	.float 0.439169
	.float -0.239428
	.float 0.052209
	.float -0.029788
	.float 0.245934
	.float -0.620903
	.float 0.939080
	.float -0.962894
	.float 0.579585
	.float 0.113600
	.float -0.847860
	.float 1.327388
	.float -1.389843
	.float 1.080298
	.float -0.595846
	.float 0.147382
	.float 0.161324
	.float -0.356363
	.float 0.515210
	.float -0.660815
	.float 0.719679
	.float -0.582026
	.float 0.215947
	.float 0.262122
	.float -0.630837
	.float 0.702705
	.float -0.459448
	.float 0.079835
	.float 0.168219
	.float -0.100243
	.float -0.265058
	.float 0.716058
	.float -0.975931
	.float 0.861990
	.float -0.382093
	.float -0.279208
	.float 0.865957
	.float -1.183470
	.float 1.188608
	.float -0.994672
	.float 0.793383
	.float -0.739729
	.float 0.864378
	.float -1.063315
	.float 1.169858
	.float -1.065735
	.float 0.763057
	.float -0.405353
	.float 0.183377
	.float -0.215188
	.float 0.464774
	.float -0.754601
	.float 0.871274
	.float -0.703540
	.float 0.326084
	.float 0.030302
	.float -0.113015
	.float -0.191419
	.float 0.772242
	.float -1.347246
	.float 1.628936
	.float -1.500761
	.float 1.084450
	.float -0.647832
	.float 0.413972
	.float -0.407493
	.float 0.451985
	.float -0.321244
	.float -0.070658
	.float 0.586407
	.float -0.953816
	.float 0.958605
	.float -0.597238
	.float 0.080273
	.float 0.309984
	.float -0.399740
	.float 0.216314
	.float 0.060672
	.float -0.240184
	.float 0.244783
	.float -0.133792
	.float 0.020811
	.float 0.039337
	.float -0.100023
	.float 0.268558
	.float -0.592297
	.float 0.979346
	.float -1.224469
	.float 1.132617
	.float -0.657909
	.float -0.039300
	.float 0.663342
	.float -0.944955
	.float 0.796843
	.float -0.366273
	.float -0.051540
	.float 0.190541
	.float 0.025768
	.float -0.440039
	.float 0.760812
	.float -0.742417
	.float 0.334090
	.float 0.289145
	.float -0.823548
	.float 0.998907
	.float -0.716511
	.float 0.096754
	.float 0.581391
	.float -1.018003
	.float 1.041531
	.float -0.693278
	.float 0.197147
	.float 0.172945
	.float -0.249184
	.float 0.051388
	.float 0.252980
	.float -0.470124
	.float 0.490892
	.float -0.322522
	.float 0.045889
	.float 0.244576
	.float -0.470691
	.float 0.572703
	.float -0.517093
	.float 0.322967
	.float -0.077981
	.float -0.094198
	.float 0.111167
	.float 0.003005
	.float -0.125438
	.float 0.119076
	.float 0.068746
	.float -0.370824
	.float 0.651074
	.float -0.794253
	.float 0.763420
	.float -0.593456
	.float 0.346202
	.float -0.075085
	.float -0.179300
	.float 0.379026
	.float -0.490627
	.float 0.503023
	.float -0.441777
	.float 0.359349
	.float -0.304058
	.float 0.290961
	.float -0.297284
	.float 0.284415
	.float -0.227258
	.float 0.127132
	.float -0.000658
	.float -0.140968
	.float 0.298071
	.float -0.463803
	.float 0.597441
	.float -0.622170
	.float 0.465415
	.float -0.122749
	.float -0.304112
	.float 0.636828
	.float -0.714275
	.float 0.495616
	.float -0.101662
	.float -0.242158
	.float 0.333428
	.float -0.114350
	.float -0.289345
	.float 0.638169
	.float -0.716838
	.float 0.458989
	.float 0.014799
	.float -0.466637
	.float 0.678450
	.float -0.576518
	.float 0.270203
	.float 0.020071
	.float -0.103128
	.float -0.063472
	.float 0.355573
	.float -0.580935
	.float 0.624557
	.float -0.531587
	.float 0.461555
	.float -0.547515
	.float 0.771930
	.float -0.962173
	.float 0.913138
	.float -0.542216
	.float -0.043624
	.float 0.616710
	.float -0.974136
	.float 1.047572
	.float -0.905759
	.float 0.669878
	.float -0.424481
	.float 0.192031
	.float 0.029907
	.float -0.224623
	.float 0.355472
	.float -0.404634
	.float 0.402855
	.float -0.410920
	.float 0.465856
	.float -0.545259
	.float 0.591018
	.float -0.574035
	.float 0.537072
	.float -0.566063
	.float 0.706633
	.float -0.899410
	.float 0.999944
	.float -0.878243
	.float 0.520601
	.float -0.048595
	.float -0.363093
	.float 0.604955
	.float -0.693236
	.float 0.730564
	.float -0.807567
	.float 0.931632
	.float -1.037221
	.float 1.058263
	.float -0.990893
	.float 0.889136
	.float -0.799022
	.float 0.694375
	.float -0.478380
	.float 0.061269
	.float 0.542174
	.float -1.174582
	.float 1.598527
	.float -1.627384
	.float 1.240179
	.float -0.604397
	.float -0.007738
	.float 0.355218
	.float -0.335017
	.float 0.007599
	.float 0.455827
	.float -0.861203
	.float 1.069324
	.float -1.039221
	.float 0.833426
	.float -0.587215
	.float 0.447884
	.float -0.502421
	.float 0.728120
	.float -1.000147
	.float 1.160302
	.float -1.109637
	.float 0.865773
	.float -0.547208
	.float 0.296385
	.float -0.193676
	.float 0.217387
	.float -0.269765
	.float 0.246517
	.float -0.103983
	.float -0.114660
	.float 0.306371
	.float -0.371656
	.float 0.278163
	.float -0.087811
	.float -0.071175
	.float 0.074901
	.float 0.121610
	.float -0.449002
	.float 0.750270
	.float -0.858217
	.float 0.685237
	.float -0.280168
	.float -0.181764
	.float 0.480145
	.float -0.468560
	.float 0.167434
	.float 0.233210
	.float -0.478267
	.float 0.404152
	.float -0.045823
	.float -0.383184
	.float 0.628938
	.float -0.558856
	.float 0.236681
	.float 0.134798
	.float -0.353066
	.float 0.336659
	.float -0.151177
	.float -0.061654
	.float 0.189555
	.float -0.214759
	.float 0.202294
	.float -0.233882
	.float 0.343225
	.float -0.498719
	.float 0.635576
	.float -0.702437
	.float 0.684378
	.float -0.594383
	.float 0.454530
	.float -0.288124
	.float 0.121397
	.float 0.021941
	.float -0.137108
	.float 0.246899
	.float -0.383199
	.float 0.550844
	.float -0.709584
	.float 0.799880
	.float -0.794363
	.float 0.725616
	.float -0.657623
	.float 0.622340
	.float -0.581403
	.float 0.455147
	.float -0.200093
	.float -0.131452
	.float 0.405815
	.float -0.492180
	.float 0.354843
	.float -0.084344
	.float -0.156349
	.float 0.233659
	.float -0.127109
	.float -0.056943
	.float 0.149715
	.float -0.026422
	.float -0.305939
	.float 0.695588
	.float -0.926839
	.float 0.856122
	.float -0.517225
	.float 0.115124
	.float 0.103480
	.float -0.021940
	.float -0.257338
	.float 0.481602
	.float -0.433444
	.float 0.098932
	.float 0.310416
	.float -0.504209
	.float 0.323128
	.float 0.141624
	.float -0.606445
	.float 0.785514
	.float -0.573624
	.float 0.095700
	.float 0.397350
	.float -0.696294
	.float 0.744467
	.float -0.633522
	.float 0.516181
	.float -0.511940
	.float 0.658737
	.float -0.913216
	.float 1.177670
	.float -1.338555
	.float 1.313189
	.float -1.092398
	.float 0.753066
	.float -0.422830
	.float 0.213414
	.float -0.167784
	.float 0.257111
	.float -0.421414
	.float 0.613267
	.float -0.808640
	.float 0.985766
	.float -1.104106
	.float 1.112314
	.float -0.982085
	.float 0.737240
	.float -0.449136
	.float 0.196742
	.float -0.019099
	.float -0.104307
	.float 0.227933
	.float -0.384403
	.float 0.539492
	.float -0.598419
	.float 0.471942
	.float -0.161399
	.float -0.206758
	.float 0.441080
	.float -0.411957
	.float 0.150913
	.float 0.165774
	.float -0.349841
	.float 0.347317
	.float -0.272405
	.float 0.291860
	.float -0.454793
	.float 0.619404
	.float -0.552370
	.float 0.129293
	.float 0.527930
	.float -1.097018
	.float 1.260619
	.float -0.922124
	.float 0.275737
	.float 0.316869
	.float -0.554308
	.float 0.374773
	.float 0.023308
	.float -0.319470
	.float 0.271964
	.float 0.143645
	.float -0.733809
	.float 1.210744
	.float -1.356718
	.float 1.130444
	.float -0.664314
	.float 0.170815
	.float 0.174286
	.float -0.305698
	.float 0.270543
	.float -0.173378
	.float 0.104018
	.float -0.086683
	.float 0.074067
	.float 0.012175
	.float -0.217469
	.float 0.505613
	.float -0.760416
	.float 0.843204
	.float -0.672599
	.float 0.274898
	.float 0.228063
	.float -0.681627
	.float 0.965803
	.float -1.027365
	.float 0.871990
	.float -0.543971
	.float 0.117783
	.float 0.303135
	.float -0.605113
	.float 0.709271
	.float -0.616963
	.float 0.414059
	.float -0.219829
	.float 0.112825
	.float -0.086457
	.float 0.064101
	.float 0.041474
	.float -0.264354
	.float 0.552370
	.float -0.779103
	.float 0.799263
	.float -0.530273
	.float 0.022539
	.float 0.531760
	.float -0.880287
	.float 0.850343
	.float -0.459827
	.float -0.085154
	.float 0.514849
	.float -0.659536
	.float 0.536961
	.float -0.306222
	.float 0.132309
	.float -0.070344
	.float 0.054754
	.float 0.009130
	.float -0.136507
	.float 0.233631
	.float -0.176925
	.float -0.062624
	.float 0.356518
	.float -0.482216
	.float 0.278412
	.float 0.221391
	.float -0.784877
	.float 1.122304
	.float -1.078217
	.float 0.734626
	.float -0.348855
	.float 0.170218
	.float -0.269915
	.float 0.507061
	.float -0.648842
	.float 0.548436
	.float -0.247057
	.float -0.066754
	.float 0.196705
	.float -0.065859
	.float -0.254765
	.float 0.617905
	.float -0.902671
	.float 1.072119
	.float -1.158356
	.float 1.203397
	.float -1.207114
	.float 1.117834
	.float -0.869963
	.float 0.444212
	.float 0.087977
	.float -0.570471
	.float 0.829023
	.float -0.770189
	.float 0.454676
	.float -0.090286
	.float -0.068130
	.float -0.135592
	.float 0.651957
	.float -1.229414
	.float 1.539236
	.float -1.357440
	.float 0.698437
	.float 0.182164
	.float -0.919659
	.float 1.227819
	.float -1.030947
	.float 0.471817
	.float 0.188553
	.float -0.701996
	.float 0.919239
	.float -0.808181
	.float 0.431357
	.float 0.081491
	.float -0.559422
	.float 0.831900
	.float -0.794390
	.float 0.470279
	.float -0.020803
	.float -0.322934
	.float 0.377843
	.float -0.107510
	.float -0.360082
	.float 0.804891
	.float -1.029296
	.float 0.948129
	.float -0.612597
	.float 0.170159
	.float 0.207514
	.float -0.393103
	.float 0.344986
	.float -0.113026
	.float -0.188711
	.float 0.430207
	.float -0.517341
	.float 0.429530
	.float -0.229469
	.float 0.038575
	.float 0.017603
	.float 0.125986
	.float -0.432141
	.float 0.772666
	.float -0.993766
	.float 0.999244
	.float -0.798158
	.float 0.486970
	.float -0.182498
	.float -0.044631
	.float 0.194062
	.float -0.311045
	.float 0.441044
	.float -0.596422
	.float 0.749403
	.float -0.845338
	.float 0.825050
	.float -0.650723
	.float 0.332856
	.float 0.052913
	.float -0.377774
	.float 0.509869
	.float -0.384823
	.float 0.053916
	.float 0.328957
	.float -0.583045
	.float 0.596511
	.float -0.382320
	.float 0.061157
	.float 0.214837
	.float -0.347916
	.float 0.340375
	.float -0.276723
	.float 0.256956
	.float -0.322549
	.float 0.423191
	.float -0.450319
	.float 0.319935
	.float -0.047868
	.float -0.242736
	.float 0.396310
	.float -0.333109
	.float 0.110122
	.float 0.113780
	.float -0.184727
	.float 0.054970
	.float 0.191732
	.float -0.400247
	.float 0.438862
	.float -0.263600
	.float -0.076575
	.float 0.475462
	.float -0.809355
	.float 0.964381
	.float -0.861865
	.float 0.494144
	.float 0.042854
	.float -0.557208
	.float 0.831911
	.float -0.734772
	.float 0.301352
	.float 0.269281
	.float -0.711676
	.float 0.828007
	.float -0.580583
	.float 0.095551
	.float 0.413364
	.float -0.751066
	.float 0.823474
	.float -0.665026
	.float 0.409385
	.float -0.221707
	.float 0.220885
	.float -0.423095
	.float 0.733273
	.float -0.992201
	.float 1.058350
	.float -0.880267
	.float 0.517341
	.float -0.097557
	.float -0.256994
	.float 0.487247
	.float -0.604445
	.float 0.654943
	.float -0.678522
	.float 0.691946
	.float -0.702386
	.float 0.728841
	.float -0.806071
	.float 0.961532
	.float -1.179261
	.float 1.377555
	.float -1.425967
	.float 1.206538
	.float -0.693501
	.float 0.002141
	.float 0.638154
	.float -0.989587
	.float 0.936126
	.float -0.553986
	.float 0.067888
	.float 0.285685
	.float -0.399356
	.float 0.344945
	.float -0.302640
	.float 0.423638
	.float -0.723545
	.float 1.073320
	.float -1.282982
	.float 1.215685
	.float -0.863013
	.float 0.347672
	.float 0.137167
	.float -0.418580
	.float 0.425840
	.float -0.228016
	.float 0.004045
	.float 0.051832
	.float 0.154658
	.float -0.551297
	.float 0.933164
	.float -1.085710
	.float 0.919758
	.float -0.526986
	.float 0.118047
	.float 0.109863
	.float -0.082584
	.float -0.133186
	.float 0.399979
	.float -0.604335
	.float 0.708004
	.float -0.733377
	.float 0.712126
	.float -0.646192
	.float 0.509559
	.float -0.282917
	.float -0.010492
	.float 0.296434
	.float -0.475927
	.float 0.470628
	.float -0.263016
	.float -0.088755
	.float 0.469626
	.float -0.753674
	.float 0.858077
	.float -0.776916
	.float 0.573123
	.float -0.331690
	.float 0.106733
	.float 0.096634
	.float -0.292049
	.float 0.464497
	.float -0.556480
	.float 0.510796
	.float -0.336614
	.float 0.135537
	.float -0.051367
	.float 0.173717
	.float -0.470226
	.float 0.804187
	.float -1.025538
	.float 1.064251
	.float -0.955526
	.float 0.784629
	.float -0.605706
	.float 0.405239
	.float -0.138207
	.float -0.199131
	.float 0.527263
	.float -0.714192
	.float 0.660692
	.float -0.376770
	.float -0.010312
	.float 0.326603
	.float -0.452358
	.float 0.382400
	.float -0.204830
	.float 0.019918
	.float 0.132516
	.float -0.277348
	.float 0.439878
	.float -0.577627
	.float 0.582384
	.float -0.367697
	.float -0.026016
	.float 0.408020
	.float -0.538767
	.float 0.295587
	.float 0.222939
	.float -0.742852
	.float 0.987897
	.float -0.856715
	.float 0.477298
	.float -0.106145
	.float -0.045783
	.float -0.067890
	.float 0.338453
	.float -0.610436
	.float 0.792137
	.float -0.886833
	.float 0.940159
	.float -0.967386
	.float 0.930720
	.float -0.783255
	.float 0.533960
	.float -0.271518
	.float 0.122133
	.float -0.171698
	.float 0.407958
	.float -0.719762
	.float 0.949840
	.float -0.969403
	.float 0.738450
	.float -0.327372
	.float -0.109823
	.float 0.404208
	.float -0.455353
	.float 0.286793
	.float -0.037162
	.float -0.115186
	.float 0.051961
	.float 0.222024
	.float -0.590896
	.float 0.901377
	.float -1.045161
	.float 0.999488
	.float -0.814353
	.float 0.574119
	.float -0.366237
	.float 0.263904
	.float -0.304988
	.float 0.459833
	.float -0.614281
	.float 0.607852
	.float -0.332310
	.float -0.166685
	.float 0.670969
	.float -0.896006
	.float 0.671208
	.float -0.075026
	.float -0.578846
	.float 0.914351
	.float -0.725363
	.float 0.118505
	.float 0.535975
	.float -0.828788
	.float 0.576920
	.float 0.044268
	.float -0.600049
	.float 0.672880
	.float -0.137464
	.float -0.750196
	.float 1.509417
	.float -1.729062
	.float 1.303314
	.float -0.465376
	.float -0.379581
	.float 0.892269
	.float -0.955270
	.float 0.673517
	.float -0.257859
	.float -0.108071
	.float 0.335938
	.float -0.420687
	.float 0.391604
	.float -0.277624
	.float 0.104855
	.float 0.093074
	.float -0.277681
	.float 0.423030
	.float -0.525826
	.float 0.591304
	.float -0.608069
	.float 0.545065
	.float -0.385977
	.float 0.173826
	.float -0.014294
	.float 0.013449
	.float -0.186147
	.float 0.411755
	.float -0.488845
	.float 0.266072
	.float 0.240406
	.float -0.831694
	.float 1.233515
	.float -1.258890
	.float 0.920416
	.float -0.420890
	.float 0.031793
	.float 0.060752
	.float 0.149961
	.float -0.506990
	.float 0.795970
	.float -0.872434
	.float 0.736045
	.float -0.513180
	.float 0.364395
	.float -0.376064
	.float 0.503368
	.float -0.600624
	.float 0.519418
	.float -0.210573
	.float -0.238363
	.float 0.654517
	.float -0.883339
	.float 0.872711
	.float -0.684569
	.float 0.437986
	.float -0.235450
	.float 0.124967
	.float -0.110663
	.float 0.180502
	.float -0.314231
	.float 0.467436
	.float -0.563174
	.float 0.522411
	.float -0.324329
	.float 0.046358
	.float 0.164494
	.float -0.185846
	.float 0.013776
	.float 0.223015
	.float -0.351880
	.float 0.286350
	.float -0.094799
	.float -0.051719
	.float 0.013728
	.float 0.207270
	.float -0.471841
	.float 0.611410
	.float -0.550776
	.float 0.347359
	.float -0.126712
	.float -0.019203
	.float 0.082835
	.float -0.108622
	.float 0.121893
	.float -0.092198
	.float -0.034980
	.float 0.270855
	.float -0.545253
	.float 0.736253
	.float -0.746768
	.float 0.568065
	.float -0.280904
	.float -0.003411
	.float 0.213314
	.float -0.344128
	.float 0.426463
	.float -0.470527
	.float 0.440481
	.float -0.284142
	.float -0.007681
	.float 0.366505
	.float -0.671306
	.float 0.817861
	.float -0.779014
	.float 0.611369
	.float -0.408852
	.float 0.244497
	.float -0.143067
	.float 0.093060
	.float -0.071923
	.float 0.055807
	.float -0.012917
	.float -0.095706
	.float 0.290063
	.float -0.534598
	.float 0.730486
	.float -0.761775
	.float 0.573672
	.float -0.224953
	.float -0.133897
	.float 0.349520
	.float -0.359820
	.float 0.225224
	.float -0.077571
	.float 0.030427
	.float -0.119136
	.float 0.306249
	.float -0.530392
	.float 0.745248
	.float -0.916622
	.float 0.993998
	.float -0.901818
	.float 0.577671
	.float -0.036010
	.float -0.596967
	.float 1.117211
	.float -1.335474
	.float 1.174761
	.float -0.713259
	.float 0.148734
	.float 0.292503
	.float -0.452328
	.float 0.298476
	.float 0.075899
	.float -0.500626
	.float 0.799198
	.float -0.855040
	.float 0.654034
	.float -0.291754
	.float -0.061058
	.float 0.229938
	.float -0.121200
	.float -0.223032
	.float 0.638264
	.float -0.922568
	.float 0.946585
	.float -0.717548
	.float 0.354685
	.float 0.001709
	.float -0.276029
	.float 0.474869
	.float -0.634107
	.float 0.753930
	.float -0.785985
	.float 0.684503
	.float -0.470342
	.float 0.242507
	.float -0.119070
	.float 0.153364
	.float -0.294584
	.float 0.422788
	.float -0.428785
	.float 0.278475
	.float -0.024142
	.float -0.232284
	.float 0.392164
	.float -0.402846
	.float 0.278682
	.float -0.096669
	.float -0.037137
	.float 0.042700
	.float 0.084808
	.float -0.268104
	.float 0.397156
	.float -0.405791
	.float 0.318508
	.float -0.227432
	.float 0.211942
	.float -0.262662
	.float 0.274624
	.float -0.125691
	.float -0.212104
	.float 0.614447
	.float -0.856834
	.float 0.755322
	.float -0.302211
	.float -0.304875
	.float 0.772606
	.float -0.891434
	.float 0.660788
	.float -0.272003
	.float -0.034080
	.float 0.125620
	.float -0.038562
	.float -0.096615
	.float 0.186027
	.float -0.246453
	.float 0.363689
	.float -0.580419
	.float 0.821924
	.float -0.934693
	.float 0.812735
	.float -0.503759
	.float 0.195531
	.float -0.079372
	.float 0.193803
	.float -0.377023
	.float 0.376678
	.float -0.040823
	.float -0.553846
	.float 1.136056
	.float -1.414718
	.float 1.269006
	.float -0.821840
	.float 0.353266
	.float -0.122101
	.float 0.217579
	.float -0.528965
	.float 0.835646
	.float -0.946150
	.float 0.797275
	.float -0.462497
	.float 0.081338
	.float 0.232803
	.float -0.443348
	.float 0.572354
	.float -0.638288
	.float 0.608394
	.float -0.414059
	.float 0.026838
	.float 0.464110
	.float -0.848745
	.float 0.896418
	.float -0.509100
	.float -0.177959
	.float 0.833837
	.float -1.104058
	.float 0.816493
	.float -0.088857
	.float -0.733481
	.float 1.270613
	.float -1.311695
	.float 0.908816
	.float -0.317387
	.float -0.165839
	.float 0.362872
	.float -0.282917
	.float 0.074857
	.float 0.090131
	.float -0.124225
	.float 0.053132
	.float 0.035237
	.float -0.073397
	.float 0.061662
	.float -0.047791
	.float 0.064555
	.float -0.083222
	.float 0.023812
	.float 0.187060
	.float -0.558316
	.float 1.018560
	.float -1.446228
	.float 1.718440
	.float -1.749797
	.float 1.514537
	.float -1.059083
	.float 0.503052
	.float -0.012228
	.float -0.266114
	.float 0.281743
	.float -0.121086
	.float -0.034375
	.float 0.019070
	.float 0.204630
	.float -0.512548
	.float 0.691081
	.float -0.569699
	.float 0.127057
	.float 0.493190
	.float -1.057756
	.float 1.357201
	.float -1.294200
	.float 0.911213
	.float -0.359191
	.float -0.169335
	.float 0.513979
	.float -0.602520
	.float 0.470860
	.float -0.240400
	.float 0.061872
	.float -0.048877
	.float 0.228325
	.float -0.527442
	.float 0.804065
	.float -0.910962
	.float 0.770201
	.float -0.422467
	.float 0.020261
	.float 0.242714
	.float -0.235331
	.float -0.032546
	.float 0.409639
	.float -0.689621
	.float 0.734960
	.float -0.558999
	.float 0.310335
	.float -0.167877
	.float 0.218071
	.float -0.399812
	.float 0.555592
	.float -0.551616
	.float 0.379026
	.float -0.161476
	.float 0.062113
	.float -0.157855
	.float 0.373962
	.float -0.529608
	.float 0.463993
	.float -0.153628
	.float -0.262149
	.float 0.564939
	.float -0.592484
	.float 0.336867
	.float 0.052342
	.float -0.355355
	.float 0.404295
	.float -0.172772
	.float -0.211596
	.float 0.535990
	.float -0.617869
	.float 0.408098
	.float -0.022763
	.float -0.321277
	.float 0.437074
	.float -0.286517
	.float 0.006134
	.float 0.186821
	.float -0.152396
	.float -0.059664
	.float 0.231694
	.float -0.131379
	.float -0.305862
	.float 0.900087
	.float -1.323114
	.float 1.311621
	.float -0.850375
	.float 0.192772
	.float 0.301030
	.float -0.397764
	.float 0.133836
	.float 0.230369
	.float -0.405025
	.float 0.269711
	.float 0.065347
	.float -0.369060
	.float 0.475236
	.float -0.399284
	.float 0.304723
	.float -0.359582
	.float 0.603175
	.float -0.923221
	.float 1.147516
	.float -1.168338
	.float 1.004954
	.float -0.769885
	.float 0.579814
	.float -0.483769
	.float 0.454557
	.float -0.436093
	.float 0.401073
	.float -0.373164
	.float 0.399469
	.float -0.497002
	.float 0.617875
	.float -0.667285
	.float 0.569913
	.float -0.339523
	.float 0.093297
	.float 0.014440
	.float 0.096692
	.float -0.356759
	.float 0.568989
	.float -0.528726
	.float 0.160367
	.float 0.423453
	.float -0.981292
	.float 1.277828
	.float -1.203233
	.float 0.808321
	.float -0.253475
	.float -0.277709
	.float 0.646198
	.float -0.788191
	.float 0.721524
	.float -0.539465
	.float 0.384850
	.float -0.391428
	.float 0.605113
	.float -0.932475
	.float 1.168672
	.float -1.111393
	.float 0.700041
	.float -0.082781
	.float -0.450900
	.float 0.644172
	.float -0.441807
	.float 0.032719
	.float 0.274328
	.float -0.263013
	.float -0.039120
	.float 0.382117
	.float -0.476604
	.float 0.206615
	.float 0.285079
	.float -0.701593
	.float 0.806637
	.float -0.586947
	.float 0.244550
	.float -0.034747
	.float 0.082175
	.float -0.314290
	.float 0.549247
	.float -0.651721
	.float 0.626018
	.float -0.579665
	.float 0.601924
	.float -0.667497
	.float 0.647778
	.float -0.418893
	.float -0.021107
	.float 0.521892
	.float -0.865257
	.float 0.906688
	.float -0.672394
	.float 0.340638
	.float -0.117304
	.float 0.091296
	.float -0.171472
	.float 0.151901
	.float 0.136080
	.float -0.687794
	.float 1.299130
	.float -1.672886
	.float 1.594214
	.float -1.066135
	.float 0.320076
	.float 0.308863
	.float -0.569258
	.float 0.430827
	.float -0.087395
	.float -0.177442
	.float 0.177007
	.float 0.060870
	.float -0.322436
	.float 0.361951
	.float -0.074704
	.float -0.428138
	.float 0.889870
	.float -1.070119
	.float 0.888201
	.float -0.459120
	.float 0.011546
	.float 0.249261
	.float -0.247059
	.float 0.055165
	.float 0.164647
	.float -0.258975
	.float 0.160546
	.float 0.087039
	.float -0.362103
	.float 0.534091
	.float -0.534958
	.float 0.396629
	.float -0.232114
	.float 0.166019
	.float -0.253509
	.float 0.441923
	.float -0.606159
	.float 0.636929
	.float -0.516935
	.float 0.326028
	.float -0.173325
	.float 0.115168
	.float -0.127749
	.float 0.151269
	.float -0.156929
	.float 0.170556
	.float -0.232575
	.float 0.338042
	.float -0.420735
	.float 0.403365
	.float -0.273220
	.float 0.115590
	.float -0.070295
	.float 0.237548
	.float -0.600630
	.float 1.021675
	.float -1.316410
	.float 1.360638
	.float -1.160723
	.float 0.844257
	.float -0.578461
	.float 0.468622
	.float -0.499512
	.float 0.553869
	.float -0.493002
	.float 0.248782
	.float 0.126808
	.float -0.481226
	.float 0.637633
	.float -0.487211
	.float 0.051414
	.float 0.516849
	.float -0.995500
	.float 1.192077
	.float -1.034205
	.float 0.608463
	.float -0.126133
	.float -0.171629
	.float 0.127356
	.float 0.254487
	.float -0.805010
	.float 1.269203
	.float -1.428095
	.float 1.202515
	.float -0.684956
	.float 0.085395
	.float 0.374433
	.float -0.559482
	.float 0.465999
	.float -0.201628
	.float -0.076263
	.float 0.230176
	.float -0.193478
	.float -0.009607
	.float 0.277964
	.float -0.476535
	.float 0.494028
	.float -0.292372
	.float -0.074260
	.float 0.481632
	.float -0.788459
	.float 0.895297
	.float -0.781065
	.float 0.501899
	.float -0.157334
	.float -0.154966
	.float 0.371977
	.float -0.474249
	.float 0.474994
	.float -0.402247
	.float 0.283695
	.float -0.136077
	.float -0.040876
	.float 0.261584
	.float -0.538347
	.float 0.856006
	.float -1.155960
	.float 1.349360
	.float -1.362259
	.float 1.188650
	.float -0.913874
	.float 0.684810
	.float -0.636592
	.float 0.814753
	.float -1.136593
	.float 1.415371
	.float -1.440243
	.float 1.079168
	.float -0.361212
	.float -0.503318
	.float 1.187317
	.float -1.383429
	.float 0.958325
	.float -0.045153
	.float -0.988839
	.float 1.700161
	.float -1.778994
	.float 1.199645
	.float -0.228076
	.float -0.717247
	.float 1.274919
	.float -1.310068
	.float 0.960346
	.float -0.541182
	.float 0.363230
	.float -0.558787
	.float 1.010743
	.float -1.426783
	.float 1.519216
	.float -1.183139
	.float 0.560483
	.float 0.051692
	.float -0.385559
	.float 0.354309
	.float -0.074321
	.float -0.242180
	.float 0.434460
	.float -0.475719
	.float 0.447401
	.float -0.444656
	.float 0.492230
	.float -0.527993
	.float 0.456024
	.float -0.224394
	.float -0.126842
	.float 0.479483
	.float -0.704240
	.float 0.736840
	.float -0.610996
	.float 0.424952
	.float -0.268720
	.float 0.170714
	.float -0.105400
	.float 0.048077
	.float -0.018858
	.float 0.070568
	.float -0.231755
	.float 0.462661
	.float -0.668454
	.float 0.757805
	.float -0.693352
	.float 0.495804
	.float -0.213557
	.float -0.101006
	.float 0.388313
	.float -0.574381
	.float 0.592490
	.float -0.432740
	.float 0.176146
	.float 0.030863
	.float -0.059016
	.float -0.117511
	.float 0.394313
	.float -0.593286
	.float 0.569887
	.float -0.305498
	.float -0.072551
	.float 0.359585
	.float -0.394277
	.float 0.159442
	.float 0.202971
	.float -0.476669
	.float 0.501371
	.float -0.260376
	.float -0.130167
	.float 0.509541
	.float -0.762848
	.float 0.850131
	.float -0.777458
	.float 0.564057
	.float -0.248520
	.float -0.082010
	.float 0.295058
	.float -0.279548
	.float 0.037822
	.float 0.278143
	.float -0.437566
	.float 0.275170
	.float 0.190044
	.float -0.751549
	.float 1.135433
	.float -1.163354
	.float 0.848122
	.float -0.364204
	.float -0.075658
	.float 0.345362
	.float -0.451019
	.float 0.483289
	.float -0.530103
	.float 0.620134
	.float -0.726704
	.float 0.805832
	.float -0.821450
	.float 0.739293
	.float -0.516441
	.float 0.123440
	.float 0.400605
	.float -0.910825
	.float 1.193842
	.float -1.081922
	.float 0.573061
	.float 0.136821
	.float -0.747606
	.float 1.017612
	.float -0.885616
	.float 0.474556
	.float 0.009946
	.float -0.401582
	.float 0.633367
	.float -0.716573
	.float 0.684009
	.float -0.556138
	.float 0.350840
	.float -0.110806
	.float -0.090953
	.float 0.181807
	.float -0.134387
	.float -0.011995
	.float 0.172791
	.float -0.269585
	.float 0.275066
	.float -0.220620
	.float 0.164293
	.float -0.146024
	.float 0.164637
	.float -0.190667
	.float 0.198371
	.float -0.185297
	.float 0.161506
	.float -0.122420
	.float 0.038092
	.float 0.120354
	.float -0.334155
	.float 0.515705
	.float -0.548636
	.float 0.374436
	.float -0.061135
	.float -0.213438
	.float 0.272182
	.float -0.071474
	.float -0.247817
	.float 0.443845
	.float -0.342253
	.float -0.031966
	.float 0.460521
	.float -0.676683
	.float 0.546302
	.float -0.155751
	.float -0.252551
	.float 0.447762
	.float -0.362738
	.float 0.131338
	.float 0.006749
	.float 0.135880
	.float -0.574587
	.float 1.139436
	.float -1.567202
	.float 1.640119
	.float -1.294817
	.float 0.650589
	.float 0.049230
	.float -0.547986
	.float 0.684685
	.float -0.454241
	.float -0.002761
	.float 0.470404
	.float -0.753993
	.float 0.761304
	.float -0.535167
	.float 0.223348
	.float 0.003466
	.float -0.047611
	.float -0.058976
	.float 0.179743
	.float -0.174767
	.float 0.014780
	.float 0.180357
	.float -0.222372
	.float 0.006393
	.float 0.383190
	.float -0.707703
	.float 0.738030
	.float -0.424916
	.float -0.060191
	.float 0.449121
	.float -0.565520
	.float 0.426210
	.float -0.182282
	.float -0.033422
	.float 0.209830
	.float -0.423668
	.float 0.711164
	.float -0.976765
	.float 1.034759
	.float -0.758038
	.float 0.208763
	.float 0.363343
	.float -0.664734
	.float 0.543161
	.float -0.084991
	.float -0.438811
	.float 0.736921
	.float -0.663423
	.float 0.282894
	.float 0.195403
	.float -0.559181
	.float 0.711423
	.float -0.691981
	.float 0.605011
	.float -0.522771
	.float 0.445261
	.float -0.338095
	.float 0.199799
	.float -0.085751
	.float 0.060408
	.float -0.120051
	.float 0.162726
	.float -0.046902
	.float -0.295722
	.float 0.781798
	.float -1.204306
	.float 1.360173
	.float -1.188930
	.float 0.815751
	.float -0.458384
	.float 0.262619
	.float -0.191860
	.float 0.061649
	.float 0.300416
	.float -0.888737
	.float 1.478596
	.float -1.751800
	.float 1.508028
	.float -0.816622
	.float 0.001258
	.float 0.537551
	.float -0.551592
	.float 0.084000
	.float 0.563353
	.float -1.007655
	.float 0.996135
	.float -0.527030
	.float -0.178223
	.float 0.816479
	.float -1.162296
	.float 1.155781
	.float -0.888943
	.float 0.524354
	.float -0.207349
	.float 0.014824
	.float 0.050930
	.float -0.038092
	.float 0.007476
	.float 0.006272
	.float -0.019628
	.float 0.092356
	.float -0.279191
	.float 0.562993
	.float -0.819814
	.float 0.860116
	.float -0.541268
	.float -0.115792
	.float 0.894376
	.float -1.475606
	.float 1.608923
	.float -1.248873
	.float 0.565523
	.float 0.174100
	.float -0.762979
	.float 1.138530
	.float -1.347807
	.float 1.443298
	.float -1.408036
	.float 1.174028
	.float -0.713819
	.float 0.119701
	.float 0.406479
	.float -0.658880
	.float 0.555631
	.float -0.193871
	.float -0.211060
	.float 0.459129
	.float -0.475957
	.float 0.326329
	.float -0.135827
	.float -0.006525
	.float 0.088063
	.float -0.137328
	.float 0.163276
	.float -0.132800
	.float 0.006462
	.float 0.207202
	.float -0.436034
	.float 0.586649
	.float -0.607816
	.float 0.517725
	.float -0.372401
	.float 0.209370
	.float -0.024418
	.float -0.194663
	.float 0.414306
	.float -0.545214
	.float 0.503088
	.float -0.295733
	.float 0.054326
	.float 0.036209
	.float 0.131501
	.float -0.493348
	.float 0.835342
	.float -0.923442
	.float 0.653149
	.float -0.117179
	.float -0.449362
	.float 0.803451
	.float -0.821495
	.float 0.550645
	.float -0.169055
	.float -0.110228
	.float 0.139887
	.float 0.098454
	.float -0.489906
	.float 0.840087
	.float -0.966533
	.float 0.789732
	.float -0.379113
	.float -0.074942
	.float 0.356673
	.float -0.342441
	.float 0.074889
	.float 0.253503
	.float -0.406014
	.float 0.239083
	.float 0.211062
	.float -0.749191
	.float 1.138739
	.float -1.239479
	.float 1.074218
	.float -0.782808
	.float 0.504573
	.float -0.281329
	.float 0.054328
	.float 0.247877
	.float -0.606874
	.float 0.886064
	.float -0.907735
	.float 0.582989
	.float 0.002060
	.float -0.613076
	.float 0.996099
	.float -1.024563
	.float 0.766913
	.float -0.430609
	.float 0.220867
	.float -0.207805
	.float 0.289270
	.float -0.272854
	.float 0.022086
	.float 0.430508
	.float -0.880246
	.float 1.062513
	.float -0.810556
	.float 0.160450
	.float 0.658758
	.float -1.337894
	.float 1.631839
	.float -1.456817
	.float 0.903139
	.float -0.177538
	.float -0.484290
	.float 0.898892
	.float -0.989048
	.float 0.799675
	.float -0.469251
	.float 0.162889
	.float 0.004033
	.float -0.010667
	.float -0.083085
	.float 0.196564
	.float -0.289304
	.float 0.379581
	.float -0.514161
	.float 0.720728
	.float -0.982702
	.float 1.248176
	.float -1.454025
	.float 1.541665
	.float -1.463404
	.float 1.196259
	.float -0.769217
	.float 0.281825
	.float 0.118416
	.float -0.302828
	.float 0.232583
	.float 0.021147
	.float -0.326403
	.float 0.572861
	.float -0.725533
	.float 0.815847
	.float -0.888114
	.float 0.950430
	.float -0.965839
	.float 0.881983
	.float -0.670656
	.float 0.349889
	.float 0.020121
	.float -0.358682
	.float 0.592216
	.float -0.679699
	.float 0.630295
	.float -0.506191
	.float 0.403162
	.float -0.409895
	.float 0.561204
	.float -0.811495
	.float 1.049754
	.float -1.153224
	.float 1.050314
	.float -0.753173
	.float 0.340706
	.float 0.092366
	.float -0.482139
	.float 0.807722
	.float -1.070125
	.float 1.262074
	.float -1.353440
	.float 1.297467
	.float -1.050103
	.float 0.595274
	.float 0.025789
	.float -0.690497
	.float 1.202005
	.float -1.351729
	.float 1.027740
	.float -0.310186
	.float -0.522551
	.float 1.109006
	.float -1.188754
	.float 0.742384
	.float 0.007842
	.float -0.739612
	.float 1.218511
	.float -1.405345
	.float 1.418399
	.float -1.394341
	.float 1.362262
	.float -1.227587
	.float 0.873072
	.float -0.292317
	.float -0.353880
	.float 0.810464
	.float -0.885819
	.float 0.583513
	.float -0.110145
	.float -0.253439
	.float 0.331404
	.float -0.155675
	.float -0.082083
	.float 0.192394
	.float -0.138906
	.float 0.060861
	.float -0.149643
	.float 0.477918
	.float -0.918330
	.float 1.219635
	.float -1.186718
	.float 0.832168
	.float -0.387297
	.float 0.161359
	.float -0.341136
	.float 0.862491
	.float -1.437394
	.float 1.722127
	.float -1.524245
	.float 0.920449
	.float -0.210516
	.float -0.265790
	.float 0.332775
	.float -0.072106
	.float -0.253683
	.float 0.389932
	.float -0.255404
	.float -0.030183
	.float 0.265878
	.float -0.334513
	.float 0.281118
	.float -0.248227
	.float 0.329890
	.float -0.472613
	.float 0.511204
	.float -0.312869
	.float -0.090069
	.float 0.493122
	.float -0.652100
	.float 0.454611
	.float 0.002412
	.float -0.486120
	.float 0.788882
	.float -0.849964
	.float 0.752288
	.float -0.616453
	.float 0.492984
	.float -0.341729
	.float 0.103660
	.float 0.208786
	.float -0.486869
	.float 0.589698
	.float -0.447029
	.float 0.119904
	.float 0.228504
	.float -0.433116
	.float 0.428615
	.float -0.282732
	.float 0.139710
	.float -0.116046
	.float 0.222065
	.float -0.362461
	.float 0.409728
	.float -0.293808
	.float 0.044462
	.float 0.236058
	.float -0.441804
	.float 0.520819
	.float -0.487629
	.float 0.394528
	.float -0.293993
	.float 0.220359
	.float -0.194509
	.float 0.230923
	.float -0.328400
	.float 0.449479
	.float -0.517603
	.float 0.455529
	.float -0.249632
	.float -0.012698
	.float 0.181121
	.float -0.145496
	.float -0.071212
	.float 0.313438
	.float -0.400486
	.float 0.261360
	.float 0.013016
	.float -0.244350
	.float 0.305203
	.float -0.206817
	.float 0.071348
	.float -0.024809
	.float 0.107174
	.float -0.265796
	.float 0.417066
	.float -0.508867
	.float 0.533945
	.float -0.501339
	.float 0.408443
	.float -0.242193
	.float 0.000517
	.float 0.293344
	.float -0.597351
	.float 0.867635
	.float -1.068203
	.float 1.168985
	.float -1.142894
	.float 0.973183
	.float -0.669503
	.float 0.279022
	.float 0.121299
	.float -0.452161
	.float 0.663813
	.float -0.751272
	.float 0.742283
	.float -0.668796
	.float 0.546660
	.float -0.380826
	.float 0.188836
	.float -0.016438
	.float -0.075036
	.float 0.042698
	.float 0.111006
	.float -0.342507
	.float 0.597846
	.float -0.843035
	.float 1.068334
	.float -1.267176
	.float 1.413639
	.float -1.462054
	.float 1.371379
	.float -1.133335
	.float 0.781199
	.float -0.375029
	.float -0.020475
	.float 0.346393
	.float -0.547551
	.float 0.575880
	.float -0.414541
	.float 0.113401
	.float 0.198066
	.float -0.350819
	.float 0.222599
	.float 0.177620
	.float -0.688187
	.float 1.063175
	.float -1.099006
	.float 0.744822
	.float -0.129924
	.float -0.506608
	.float 0.937846
	.float -1.049408
	.float 0.869340
	.float -0.527284
	.float 0.180725
	.float 0.051311
	.float -0.125564
	.float 0.078925
	.float -0.001140
	.float -0.017400
	.float -0.059678
	.float 0.192859
	.float -0.300175
	.float 0.326898
	.float -0.295682
	.float 0.288180
	.float -0.365414
	.float 0.492514
	.float -0.539918
	.float 0.374567
	.float 0.023665
	.float -0.514462
	.float 0.867519
	.float -0.910903
	.float 0.652657
	.float -0.283473
	.float 0.050631
	.float -0.087368
	.float 0.318234
	.float -0.511201
	.float 0.442990
	.float -0.061723
	.float -0.468509
	.float 0.871766
	.float -0.936824
	.float 0.643131
	.float -0.158061
	.float -0.275308
	.float 0.470536
	.float -0.367987
	.float 0.024325
	.float 0.439697
	.float -0.888788
	.float 1.207579
	.float -1.330392
	.float 1.264279
	.float -1.082309
	.float 0.873397
	.float -0.676504
	.float 0.457448
	.float -0.160803
	.float -0.198142
	.float 0.485888
	.float -0.507607
	.float 0.144621
	.float 0.526515
	.float -1.232570
	.float 1.638590
	.float -1.539555
	.float 0.983272
	.float -0.242331
	.float -0.348029
	.float 0.581627
	.float -0.482001
	.float 0.254357
	.float -0.131437
	.float 0.222251
	.float -0.463207
	.float 0.693102
	.float -0.785517
	.float 0.735767
	.float -0.640273
	.float 0.592526
	.float -0.586190
	.float 0.510694
	.float -0.250664
	.float -0.187812
	.float 0.632256
	.float -0.833580
	.float 0.640440
	.float -0.133133
	.float -0.391496
	.float 0.592425
	.float -0.306678
	.float -0.330844
	.float 0.960227
	.float -1.221703
	.float 0.985674
	.float -0.430764
	.float -0.085072
	.float 0.272275
	.float -0.102942
	.float -0.186783
	.float 0.286063
	.float -0.051796
	.float -0.374457
	.float 0.663604
	.float -0.541262
	.float -0.000909
	.float 0.678748
	.float -1.092899
	.float 0.982848
	.float -0.381610
	.float -0.425125
	.float 1.090098
	.float -1.403705
	.float 1.373856
	.float -1.159319
	.float 0.932735
	.float -0.780519
	.float 0.696074
	.float -0.640840
	.float 0.603062
	.float -0.601620
	.float 0.640607
	.float -0.666111
	.float 0.575156
	.float -0.281821
	.float -0.206249
	.float 0.762532
	.float -1.195052
	.float 1.347240
	.float -1.178218
	.float 0.770496
	.float -0.268104
	.float -0.200983
	.float 0.562331
	.float -0.780519
	.float 0.830016
	.float -0.695656
	.float 0.407406
	.float -0.067979
	.float -0.173303
	.float 0.200989
	.float -0.013982
	.float -0.260797
	.float 0.442787
	.float -0.413358
	.float 0.190459
	.float 0.092037
	.float -0.284434
	.float 0.326793
	.float -0.282187
	.float 0.274619
	.float -0.380990
	.float 0.561079
	.float -0.680653
	.float 0.610323
	.float -0.324958
	.float -0.071982
	.float 0.416011
	.float -0.589432
	.float 0.590750
	.float -0.520899
	.float 0.503350
	.float -0.597825
	.float 0.763379
	.float -0.887449
	.float 0.856465
	.float -0.626128
	.float 0.255922
	.float 0.107411
	.float -0.291966
	.float 0.183498
	.float 0.207783
	.float -0.733937
	.float 1.165375
	.float -1.295434
	.float 1.042058
	.float -0.491810
	.float -0.137596
	.float 0.595524
	.float -0.707313
	.float 0.444778
	.float 0.067550
	.float -0.607956
	.float 0.950945
	.float -0.961332
	.float 0.649575
	.float -0.160809
	.float -0.298744
	.float 0.561321
	.float -0.571374
	.float 0.398191
	.float -0.188537
	.float 0.089872
	.float -0.180977
	.float 0.434916
	.float -0.724516
	.float 0.871897
	.float -0.732748
	.float 0.286049
	.float 0.320836
	.float -0.816371
	.float 0.938344
	.float -0.591325
	.float -0.073129
	.float 0.722141
	.float -1.028226
	.float 0.863224
	.float -0.369450
	.float -0.142621
	.float 0.400474
	.float -0.337675
	.float 0.112289
	.float 0.026762
	.float 0.077915
	.float -0.389377
	.float 0.715304
	.float -0.848200
	.float 0.703921
	.float -0.369441
	.float 0.040424
	.float 0.100541
	.float 0.013565
	.float -0.307158
	.float 0.616403
	.float -0.785929
	.float 0.749543
	.float -0.551715
	.float 0.305590
	.float -0.121672
	.float 0.055055
	.float -0.098749
	.float 0.212088
	.float -0.349895
	.float 0.468255
	.float -0.514110
	.float 0.427399
	.float -0.173370
	.float -0.212417
	.float 0.608913
	.float -0.853672
	.float 0.831393
	.float -0.549002
	.float 0.139387
	.float 0.215718
	.float -0.391541
	.float 0.378263
	.float -0.254257
	.float 0.107813
	.float 0.020123
	.float -0.126881
	.float 0.196111
	.float -0.168523
	.float -0.024249
	.float 0.389655
	.float -0.836606
	.float 1.212297
	.float -1.388141
	.float 1.326067
	.float -1.077299
	.float 0.726176
	.float -0.333368
	.float -0.076923
	.float 0.486013
	.float -0.843893
	.float 1.064573
	.float -1.063291
	.float 0.811704
	.float -0.372746
	.float -0.112492
	.float 0.483238
	.float -0.629871
	.float 0.534777
	.float -0.262873
	.float -0.081944
	.float 0.396769
	.float -0.592958
	.float 0.593465
	.float -0.343356
	.float -0.154022
	.float 0.799824
	.float -1.403184
	.float 1.745020
	.float -1.677330
	.float 1.201099
	.float -0.474589
	.float -0.255854
	.float 0.763858
	.float -0.931483
	.float 0.776963
	.float -0.420952
	.float 0.024787
	.float 0.262071
	.float -0.332507
	.float 0.142201
	.float 0.268437
	.float -0.763015
	.float 1.138921
	.float -1.211200
	.float 0.918318
	.float -0.381575
	.float -0.137575
	.float 0.376335
	.float -0.229263
	.float -0.175640
	.float 0.543092
	.float -0.590482
	.float 0.234854
	.float 0.334119
	.float -0.752118
	.float 0.700291
	.float -0.116195
	.float -0.739812
	.float 1.416030
	.float -1.529323
	.float 0.998317
	.float -0.102621
	.float -0.675574
	.float 0.934419
	.float -0.585176
	.float -0.108965
	.float 0.706559
	.float -0.857853
	.float 0.499255
	.float 0.141065
	.float -0.712737
	.float 0.964873
	.float -0.876019
	.float 0.620909
	.float -0.416422
	.float 0.365650
	.float -0.408443
	.float 0.401025
	.float -0.250406
	.float -0.004869
	.float 0.224422
	.float -0.272567
	.float 0.112806
	.float 0.176320
	.float -0.461281
	.float 0.632303
	.float -0.645730
	.float 0.516769
	.float -0.288746
	.float 0.010020
	.float 0.270915
	.float -0.502915
	.float 0.636792
	.float -0.641522
	.float 0.521737
	.float -0.320850
	.float 0.101378
	.float 0.088831
	.float -0.239488
	.float 0.368496
	.float -0.483477
	.float 0.547482
	.float -0.487122
	.float 0.249073
	.float 0.135360
	.float -0.536759
	.float 0.791568
	.float -0.806682
	.float 0.627773
	.float -0.414762
	.float 0.336161
	.float -0.456545
	.float 0.696801
	.float -0.892096
	.float 0.902382
	.float -0.698565
	.float 0.373694
	.float -0.084669
	.float -0.030528
	.float -0.085246
	.float 0.386489
	.float -0.740581
	.float 0.974786
	.float -0.949050
	.float 0.635212
	.float -0.158472
	.float -0.244271
	.float 0.352229
	.float -0.106475
	.float -0.331392
	.float 0.669380
	.float -0.677464
	.float 0.347409
	.float 0.104579
	.float -0.401359
	.float 0.411624
	.float -0.238504
	.float 0.121498
	.float -0.232974
	.float 0.534523
	.float -0.805949
	.float 0.818738
	.float -0.513201
	.float 0.042603
	.float 0.339800
	.float -0.455952
	.float 0.308374
	.float -0.049205
	.float -0.146779
	.float 0.202394
	.float -0.167349
	.float 0.149521
	.float -0.213687
	.float 0.329148
	.float -0.401377
	.float 0.355138
	.float -0.199622
	.float 0.026528
	.float 0.052756
	.float 0.020053
	.float -0.218310
	.float 0.455559
	.float -0.643078
	.float 0.739791
	.float -0.764359
	.float 0.765322
	.float -0.771038
	.float 0.756109
	.float -0.653679
	.float 0.412953
	.float -0.062460
	.float -0.273521
	.float 0.429959
	.float -0.297324
	.float -0.107312
	.float 0.645125
	.float -1.130849
	.float 1.422974
	.float -1.470471
	.float 1.300057
	.float -0.975984
	.float 0.573842
	.float -0.181263
	.float -0.099090
	.float 0.173981
	.float -0.011239
	.float -0.317789
	.float 0.647510
	.float -0.789535
	.float 0.632160
	.float -0.210836
	.float -0.294354
	.float 0.638583
	.float -0.633105
	.float 0.247287
	.float 0.362875
	.float -0.921898
	.float 1.169816
	.float -0.995944
	.float 0.495890
	.float 0.082716
	.float -0.475263
	.float 0.535665
	.float -0.295032
	.float -0.082305
	.float 0.406452
	.float -0.561225
	.float 0.541572
	.float -0.424684
	.float 0.312285
	.float -0.284682
	.float 0.380677
	.float -0.589465
	.float 0.841535
	.float -1.009237
	.float 0.942883
	.float -0.549694
	.float -0.121854
	.float 0.857332
	.float -1.353380
	.float 1.370825
	.float -0.875203
	.float 0.071535
	.float 0.697638
	.float -1.133174
	.float 1.129931
	.float -0.808711
	.float 0.419194
	.float -0.183363
	.float 0.179342
	.float -0.328752
	.float 0.479179
	.float -0.515034
	.float 0.423888
	.float -0.286432
	.float 0.212005
	.float -0.269677
	.float 0.454364
	.float -0.696583
	.float 0.900522
	.float -0.988592
	.float 0.936240
	.float -0.784325
	.float 0.620972
	.float -0.536210
	.float 0.571475
	.float -0.695039
	.float 0.821241
	.float -0.860899
	.float 0.768654
	.float -0.558441
	.float 0.285346
	.float -0.013731
	.float -0.205881
	.float 0.344641
	.float -0.393011
	.float 0.354867
	.float -0.240583
	.float 0.063058
	.float 0.157051
	.float -0.375158
	.float 0.510563
	.float -0.463666
	.float 0.173134
	.float 0.314344
	.float -0.820687
	.float 1.103948
	.float -0.997062
	.float 0.528568
	.float 0.073731
	.float -0.519776
	.float 0.648797
	.float -0.532932
	.float 0.406873
	.float -0.470759
	.float 0.718275
	.float -0.929912
	.float 0.844817
	.float -0.381542
	.float -0.267309
	.float 0.749546
	.float -0.800232
	.float 0.437387
	.float 0.043923
	.float -0.282240
	.float 0.113574
	.float 0.306166
	.float -0.613017
	.float 0.501318
	.float 0.050332
	.float -0.759456
	.float 1.239547
	.float -1.270303
	.float 0.939134
	.float -0.554591
	.float 0.405746
	.float -0.554093
	.float 0.809290
	.float -0.891333
	.float 0.641296
	.float -0.122497
	.float -0.442132
	.float 0.821936
	.float -0.898725
	.float 0.690381
	.float -0.301969
	.float -0.133869
	.float 0.493396
	.float -0.684888
	.float 0.674504
	.float -0.505189
	.float 0.281362
	.float -0.113426
	.float 0.053627
	.float -0.069193
	.float 0.072625
	.float 0.012871
	.float -0.196515
	.float 0.404855
	.float -0.513925
	.float 0.412083
	.float -0.066773
	.float -0.434901
	.float 0.898757
	.float -1.099826
	.float 0.898874
	.float -0.338918
	.float -0.345848
	.float 0.835747
	.float -0.899160
	.float 0.529999
	.float 0.045979
	.float -0.510274
	.float 0.649465
	.float -0.478201
	.float 0.204596
	.float -0.068328
	.float 0.174172
	.float -0.442308
	.float 0.700944
	.float -0.835926
	.float 0.871951
	.float -0.922941
	.float 1.060776
	.float -1.218302
	.float 1.214353
	.float -0.889038
	.float 0.248449
	.float 0.493712
	.float -1.019258
	.float 1.093319
	.float -0.716603
	.float 0.138681
	.float 0.286682
	.float -0.322326
	.float 0.006006
	.float 0.364678
	.float -0.426967
	.float 0.009463
	.float 0.723422
	.float -1.351511
	.float 1.464441
	.float -0.936916
	.float 0.021167
	.float 0.811296
	.float -1.168907
	.float 0.973648
	.float -0.476341
	.float 0.060477
	.float 0.016489
	.float 0.231010
	.float -0.564844
	.float 0.709381
	.float -0.538770
	.float 0.145131
	.float 0.241641
	.float -0.414625
	.float 0.319357
	.float -0.071833
	.float -0.136320
	.float 0.173474
	.float -0.051678
	.float -0.093276
	.float 0.105129
	.float 0.079782
	.float -0.384951
	.float 0.641296
	.float -0.697898
	.float 0.523710
	.float -0.233939
	.float 0.021541
	.float -0.035794
	.float 0.287159
	.float -0.641126
	.float 0.903180
	.float -0.934079
	.float 0.718263
	.float -0.350759
	.float -0.030267
	.float 0.307671
	.float -0.411355
	.float 0.316776
	.float -0.046833
	.float -0.312902
	.float 0.610957
	.float -0.671956
	.float 0.384436
	.float 0.211569
	.float -0.903315
	.float 1.386690
	.float -1.422703
	.float 0.983227
	.float -0.288972
	.float -0.301209
	.float 0.497044
	.float -0.252696
	.float -0.207998
	.float 0.542186
	.float -0.517418
	.float 0.163448
	.float 0.256916
	.float -0.432967
	.float 0.214162
	.float 0.299302
	.float -0.832212
	.float 1.110240
	.float -1.015064
	.float 0.630757
	.float -0.174694
	.float -0.128670
	.float 0.157515
	.float 0.062355
	.float -0.387291
	.float 0.639668
	.float -0.703853
	.float 0.585278
	.float -0.396903
	.float 0.278278
	.float -0.296553
	.float 0.398182
	.float -0.448212
	.float 0.332230
	.float -0.048168
	.float -0.278570
	.float 0.468029
	.float -0.396474
	.float 0.071666
	.float 0.371614
	.float -0.746810
	.float 0.911564
	.float -0.829661
	.float 0.569267
	.float -0.247080
	.float -0.042531
	.float 0.268873
	.float -0.453797
	.float 0.623779
	.float -0.768085
	.float 0.839252
	.float -0.794566
	.float 0.639293
	.float -0.430532
	.float 0.236564
	.float -0.087411
	.float -0.039104
	.float 0.184278
	.float -0.357352
	.float 0.509747
	.float -0.556722
	.float 0.433205
	.float -0.148037
	.float -0.198276
	.float 0.447631
	.float -0.457812
	.float 0.178649
	.float 0.314368
	.float -0.854122
	.float 1.266237
	.float -1.450046
	.float 1.404895
	.float -1.192906
	.float 0.880717
	.float -0.513571
	.float 0.137881
	.float 0.164652
	.float -0.282952
	.float 0.136431
	.float 0.254766
	.float -0.752902
	.float 1.165936
	.float -1.352704
	.float 1.297073
	.float -1.099805
	.float 0.896850
	.float -0.764037
	.float 0.673014
	.float -0.526342
	.float 0.246628
	.float 0.141300
	.float -0.495109
	.float 0.628193
	.float -0.434344
	.float -0.015967
	.float 0.482785
	.float -0.681791
	.float 0.459377
	.float 0.096192
	.float -0.689594
	.float 0.987170
	.float -0.815394
	.float 0.262988
	.float 0.375605
	.float -0.773181
	.float 0.747394
	.float -0.340206
	.float -0.231262
	.float 0.703271
	.float -0.889995
	.float 0.743138
	.float -0.338537
	.float -0.177870
	.float 0.644923
	.float -0.923796
	.float 0.924997
	.float -0.636071
	.float 0.144707
	.float 0.366768
	.float -0.676972
	.float 0.621648
	.float -0.185087
	.float -0.469397
	.float 1.058794
	.float -1.308605
	.float 1.088575
	.float -0.485864
	.float -0.228709
	.float 0.734972
	.float -0.836567
	.float 0.577496
	.float -0.221494
	.float 0.089475
	.float -0.346718
	.float 0.882097
	.float -1.371540
	.float 1.491233
	.float -1.133991
	.float 0.476404
	.float 0.144330
	.float -0.446087
	.float 0.353949
	.float 0.002874
	.float -0.416994
	.float 0.738360
	.float -0.925847
	.float 1.006799
	.float -1.010120
	.float 0.940728
	.float -0.807567
	.float 0.660359
	.float -0.583012
	.float 0.635045
	.float -0.786054
	.float 0.903598
	.float -0.817987
	.float 0.430016
	.float 0.208314
	.float -0.896048
	.float 1.373910
	.float -1.455515
	.float 1.126337
	.float -0.553151
	.float -0.005729
	.float 0.341168
	.float -0.401645
	.float 0.300965
	.float -0.220702
	.float 0.276907
	.float -0.446942
	.float 0.605664
	.float -0.635648
	.float 0.520920
	.float -0.353162
	.float 0.253008
	.float -0.274013
	.float 0.365563
	.float -0.420967
	.float 0.371822
	.float -0.255775
	.float 0.203722
	.float -0.350348
	.float 0.729872
	.float -1.233714
	.float 1.664631
	.float -1.849876
	.float 1.731918
	.float -1.375793
	.float 0.901327
	.float -0.406005
	.float -0.058192
	.float 0.448221
	.float -0.685436
	.float 0.661643
	.float -0.306911
	.float -0.327619
	.float 1.040914
	.float -1.545048
	.float 1.597960
	.float -1.134256
	.float 0.315256
	.float 0.539730
	.float -1.110901
	.float 1.238012
	.float -0.991012
	.float 0.611306
	.float -0.362333
	.float 0.382096
	.float -0.622909
	.float 0.903440
	.float -1.029081
	.float 0.903705
	.float -0.571895
	.float 0.178393
	.float 0.122671
	.float -0.253257
	.float 0.244388
	.float -0.200586
	.float 0.220556
	.float -0.327142
	.float 0.455553
	.float -0.510328
	.float 0.450733
	.float -0.338972
	.float 0.308246
	.float -0.467168
	.float 0.808905
	.float -1.195856
	.float 1.438201
	.float -1.414119
	.float 1.145800
	.float -0.774838
	.float 0.454647
	.float -0.239138
	.float 0.051722
	.float 0.240715
	.float -0.702496
	.float 1.246802
	.float -1.660547
	.float 1.724866
	.float -1.351401
	.float 0.645710
	.float 0.139318
	.float -0.726081
	.float 0.937441
	.float -0.761960
	.float 0.340471
	.float 0.104855
	.float -0.362222
	.float 0.310842
	.float 0.031400
	.float -0.509574
	.float 0.891396
	.float -0.973460
	.float 0.691516
	.float -0.170328
	.float -0.332954
	.float 0.575591
	.float -0.477978
	.float 0.167222
	.float 0.125806
	.float -0.244407
	.float 0.218743
	.float -0.217586
	.float 0.375864
	.float -0.645140
	.float 0.804402
	.float -0.636202
	.float 0.129406
	.float 0.464271
	.float -0.782075
	.float 0.607121
	.float -0.038290
	.float -0.558784
	.float 0.791159
	.float -0.500391
	.float -0.135689
	.float 0.726907
	.float -0.927179
	.float 0.643909
	.float -0.066884
	.float -0.482872
	.float 0.761808
	.float -0.725488
	.float 0.499926
	.float -0.252959
	.float 0.074934
	.float 0.051746
	.float -0.194488
	.float 0.388006
	.float -0.594451
	.float 0.728829
	.float -0.721333
	.float 0.568968
	.float -0.344417
	.float 0.160701
	.float -0.113792
	.float 0.232906
	.float -0.462390
	.float 0.686178
	.float -0.787312
	.float 0.714269
	.float -0.514617
	.float 0.307370
	.float -0.202129
	.float 0.214652
	.float -0.240895
	.float 0.118168
	.float 0.259321
	.float -0.845675
	.float 1.434935
	.float -1.749595
	.float 1.578647
	.float -0.892969
	.float -0.117569
	.float 1.104189
	.float -1.697451
	.float 1.672624
	.float -1.067851
	.float 0.183690
	.float 0.560513
	.float -0.852563
	.float 0.664764
	.float -0.258786
	.float -0.001943
	.float -0.086325
	.float 0.419039
	.float -0.664531
	.float 0.524148
	.float 0.019826
	.float -0.659420
	.float 0.962829
	.float -0.682125
	.float -0.054314
	.float 0.804896
	.float -1.094282
	.float 0.723771
	.float 0.090579
	.float -0.840295
	.float 1.030113
	.float -0.476902
	.float -0.580634
	.float 1.625589
	.float -2.165296
	.float 2.001871
	.float -1.308256
	.float 0.481086
	.float 0.113067
	.float -0.326415
	.float 0.250686
	.float -0.095359
	.float 0.036296
	.float -0.136690
	.float 0.360386
	.float -0.625353
	.float 0.838617
	.float -0.901628
	.float 0.720332
	.float -0.249688
	.float -0.444942
	.float 1.166657
	.float -1.650604
	.float 1.694987
	.float -1.280016
	.float 0.590181
	.float 0.083646
	.float -0.500868
	.float 0.584577
	.float -0.425247
	.float 0.189781
	.float -0.013956
	.float -0.049257
	.float 0.011551
	.float 0.095500
	.float -0.242892
	.float 0.394256
	.float -0.494478
	.float 0.487810
	.float -0.359933
	.float 0.165818
	.float -0.010750
	.float -0.009517
	.float -0.132000
	.float 0.377262
	.float -0.619464
	.float 0.765262
	.float -0.781401
	.float 0.698640
	.float -0.574065
	.float 0.439044
	.float -0.269758
	.float 0.006417
	.float 0.385276
	.float -0.851401
	.float 1.239982
	.float -1.369567
	.float 1.145340
	.float -0.646869
	.float 0.117898
	.float 0.152075
	.float 0.008898
	.float -0.545128
	.float 1.185776
	.float -1.577917
	.float 1.469109
	.float -0.841890
	.float -0.071078
	.float 0.900289
	.float -1.322860
	.float 1.220058
	.float -0.724480
	.float 0.132088
	.float 0.267287
	.float -0.338933
	.float 0.145080
	.float 0.134404
	.float -0.335875
	.float 0.404116
	.float -0.387595
	.float 0.359573
	.float -0.340873
	.float 0.289085
	.float -0.157266
	.float -0.034606
	.float 0.182933
	.float -0.160795
	.float -0.085792
	.float 0.479429
	.float -0.841866
	.float 1.001438
	.float -0.907308
	.float 0.668820
	.float -0.485298
	.float 0.507979
	.float -0.727073
	.float 0.966474
	.float -0.996865
	.float 0.694446
	.float -0.136749
	.float -0.432952
	.float 0.751042
	.float -0.691475
	.float 0.332257
	.float 0.107344
	.float -0.406241
	.float 0.458739
	.float -0.298095
	.float 0.032066
	.float 0.241929
	.float -0.473468
	.float 0.635397
	.float -0.686014
	.float 0.572557
	.float -0.283374
	.float -0.100477
	.float 0.416261
	.float -0.504695
	.float 0.313951
	.float 0.058352
	.float -0.422589
	.float 0.614716
	.float -0.588437
	.float 0.419283
	.float -0.228339
	.float 0.092660
	.float -0.010100
	.float -0.066063
	.float 0.163912
	.float -0.257199
	.float 0.282197
	.float -0.187613
	.float -0.022117
	.float 0.276815
	.float -0.466583
	.float 0.490159
	.float -0.307966
	.float -0.022965
	.float 0.356852
	.float -0.522819
	.float 0.422687
	.float -0.104004
	.float -0.251545
	.float 0.433920
	.float -0.342316
	.float 0.058317
	.float 0.203127
	.float -0.236130
	.float -0.018054
	.float 0.431631
	.float -0.772770
	.float 0.850146
	.float -0.624149
	.float 0.220296
	.float 0.152334
	.float -0.320904
	.float 0.237553
	.float 0.005085
	.float -0.233637
	.float 0.295610
	.float -0.150766
	.float -0.099131
	.float 0.266404
	.float -0.194458
	.float -0.135156
	.float 0.581644
	.float -0.932180
	.float 1.039343
	.float -0.907174
	.float 0.660913
	.float -0.427909
	.float 0.230295
	.float 0.019651
	.float -0.415859
	.float 0.932908
	.float -1.386443
	.float 1.524382
	.float -1.193341
	.float 0.464554
	.float 0.373900
	.float -0.963100
	.float 1.068653
	.float -0.703391
	.float 0.103938
	.float 0.416214
	.float -0.638011
	.float 0.528056
	.float -0.210116
	.float -0.140618
	.float 0.396906
	.float -0.513535
	.float 0.497425
	.float -0.361844
	.float 0.111335
	.float 0.234118
	.float -0.607729
	.float 0.897357
	.float -0.992287
	.float 0.847544
	.float -0.517785
	.float 0.131681
	.float 0.179452
	.float -0.349546
	.float 0.395547
	.float -0.377798
	.float 0.340328
	.float -0.279968
	.float 0.163437
	.float 0.030908
	.float -0.286280
	.float 0.554713
	.float -0.783026
	.float 0.929507
	.float -0.962063
	.float 0.854602
	.float -0.602725
	.float 0.254731
	.float 0.074761
	.float -0.241217
	.float 0.152908
	.float 0.151261
	.float -0.495628
	.float 0.659545
	.float -0.520277
	.float 0.148145
	.float 0.224834
	.float -0.353913
	.float 0.148086
	.float 0.267879
	.float -0.644264
	.float 0.784441
	.float -0.677976
	.float 0.491464
	.float -0.428329
	.float 0.566984
	.float -0.800253
	.float 0.920482
	.float -0.784492
	.float 0.433757
	.float -0.078953
	.float -0.042051
	.float -0.169225
	.float 0.599912
	.float -0.999649
	.float 1.146333
	.float -0.987742
	.float 0.663521
	.float -0.399895
	.float 0.356097
	.float -0.527826
	.float 0.763566
	.float -0.869143
	.float 0.722638
	.float -0.330662
	.float -0.190663
	.float 0.677115
	.float -0.977245
	.float 0.994684
	.float -0.716409
	.float 0.229206
	.float 0.293756
	.float -0.655524
	.float 0.733255
	.float -0.554767
	.float 0.290966
	.float -0.152200
	.float 0.249781
	.float -0.517985
	.float 0.754676
	.float -0.753960
	.float 0.439908
	.float 0.087335
	.float -0.616984
	.float 0.953315
	.float -1.017136
	.float 0.865790
	.float -0.634035
	.float 0.446263
	.float -0.357266
	.float 0.348688
	.float -0.368025
	.float 0.374806
	.float -0.363778
	.float 0.357635
	.float -0.382794
	.float 0.449264
	.float -0.546144
	.float 0.650252
	.float -0.736414
	.float 0.781777
	.float -0.767387
	.float 0.685830
	.float -0.555890
	.float 0.430508
	.float -0.379813
	.float 0.447672
	.float -0.606740
	.float 0.751069
	.float -0.746283
	.float 0.516107
	.float -0.109921
	.float -0.302023
	.float 0.517216
	.float -0.427337
	.float 0.101821
	.float 0.236942
	.float -0.347934
	.float 0.138408
	.float 0.252035
	.float -0.525853
	.float 0.430392
	.float 0.043257
	.float -0.616191
	.float 0.886952
	.float -0.607658
	.float -0.122143
	.float 0.894156
	.float -1.250664
	.float 0.989224
	.float -0.297948
	.float -0.374317
	.float 0.617353
	.float -0.314487
	.float -0.317706
	.float 0.908676
	.float -1.178987
	.float 1.071893
	.float -0.705164
	.float 0.226836
	.float 0.283029
	.float -0.793335
	.float 1.237860
	.float -1.478828
	.float 1.377439
	.float -0.919525
	.float 0.280943
	.float 0.242541
	.float -0.407704
	.float 0.180070
	.float 0.240321
	.float -0.547306
	.float 0.527620
	.float -0.195594
	.float -0.228795
	.float 0.483194
	.float -0.451183
	.float 0.238036
	.float -0.077338
	.float 0.139000
	.float -0.387041
	.float 0.598961
	.float -0.533897
	.float 0.121519
	.float 0.470825
	.float -0.940460
	.float 1.043000
	.float -0.739797
	.float 0.205964
	.float 0.289766
	.float -0.539596
	.float 0.487015
	.float -0.215825
	.float -0.127128
	.float 0.410995
	.float -0.561607
	.float 0.565824
	.float -0.461523
	.float 0.323962
	.float -0.241357
	.float 0.275312
	.float -0.423280
	.float 0.611041
	.float -0.726254
	.float 0.673032
	.float -0.414732
	.float -0.012339
	.float 0.508307
	.float -0.930401
	.float 1.125956
	.float -0.984270
	.float 0.497133
	.float 0.206341
	.float -0.886189
	.float 1.283223
	.float -1.236325
	.float 0.765253
	.float -0.073343
	.float -0.536955
	.float 0.802020
	.float -0.625687
	.float 0.132154
	.float 0.394510
	.float -0.661676
	.float 0.529418
	.float -0.084764
	.float -0.417456
	.float 0.707539
	.float -0.648961
	.float 0.293392
	.float 0.175300
	.float -0.554382
	.float 0.715798
	.float -0.635257
	.float 0.364374
	.float 0.013748
	.float -0.411314
	.float 0.740539
	.float -0.917531
	.float 0.885414
	.float -0.651215
	.float 0.304520
	.float 0.012339
	.float -0.177133
	.float 0.157620
	.float -0.024360
	.float -0.107951
	.float 0.170163
	.float -0.191507
	.float 0.274305
	.float -0.506543
	.float 0.873063
	.float -1.228621
	.float 1.358158
	.float -1.095456
	.float 0.433768
	.float 0.441205
	.float -1.226746
	.float 1.653591
	.float -1.625944
	.float 1.263367
	.float -0.815349
	.float 0.502775
	.float -0.390733
	.float 0.375682
	.float -0.288387
	.float 0.034198
	.float 0.330808
	.float -0.638628
	.float 0.728757
	.float -0.558686
	.float 0.228408
	.float 0.090427
	.float -0.260471
	.float 0.241977
	.float -0.078380
	.float -0.166110
	.float 0.454676
	.float -0.773086
	.float 1.086020
	.float -1.304188
	.float 1.302527
	.float -0.986544
	.float 0.364708
	.float 0.422630
	.float -1.143314
	.float 1.568579
	.float -1.578361
	.float 1.220040
	.float -0.682101
	.float 0.188725
	.float 0.125776
	.float -0.279642
	.float 0.394596
	.float -0.566867
	.float 0.759212
	.float -0.810273
	.float 0.568405
	.float -0.050648
	.float -0.507332
	.float 0.769220
	.float -0.513544
	.float -0.205071
	.float 1.065938
	.float -1.660953
	.float 1.723364
	.float -1.261653
	.float 0.525033
	.float 0.161167
	.float -0.576509
	.float 0.693779
	.float -0.636172
	.float 0.551932
	.float -0.500638
	.float 0.426198
	.float -0.223960
	.float -0.156134
	.float 0.647882
	.float -1.090688
	.float 1.315820
	.float -1.238838
	.float 0.903860
	.float -0.462116
	.float 0.105226
	.float 0.011269
	.float 0.173985
	.float -0.603068
	.float 1.112347
	.float -1.486068
	.float 1.539072
	.float -1.198825
	.float 0.545745
	.float 0.215719
	.float -0.845157
	.float 1.166529
	.float -1.128057
	.float 0.798167
	.float -0.315143
	.float -0.172504
	.float 0.548341
	.float -0.748265
	.float 0.764720
	.float -0.636870
	.float 0.426761
	.float -0.190484
	.float -0.037512
	.float 0.234986
	.float -0.370124
	.float 0.397219
	.float -0.287765
	.float 0.077223
	.float 0.119461
	.float -0.157396
	.float -0.042052
	.float 0.415936
	.float -0.773089
	.float 0.904897
	.float -0.724689
	.float 0.334105
	.float 0.039755
	.float -0.195930
	.float 0.089005
	.float 0.159656
	.float -0.370124
	.float 0.435500
	.float -0.366654
	.float 0.223348
	.float -0.012421
	.float -0.333887
	.float 0.864735
	.float -1.487957
	.float 1.950547
	.float -1.976322
	.float 1.471282
	.float -0.628626
	.float -0.169135
	.float 0.591957
	.float -0.567606
	.float 0.296283
	.float -0.071980
	.float 0.058633
	.float -0.193682
	.float 0.278517
	.float -0.165178
	.float -0.116372
	.float 0.383944
	.float -0.448602
	.float 0.259684
	.float 0.057726
	.float -0.291611
	.float 0.284644
	.float -0.027779
	.float -0.350590
	.float 0.678903
	.float -0.847392
	.float 0.856259
	.float -0.787771
	.float 0.734829
	.float -0.739916
	.float 0.779533
	.float -0.792444
	.float 0.722332
	.float -0.544660
	.float 0.267744
	.float 0.079096
	.float -0.451097
	.float 0.783139
	.float -0.989873
	.float 0.989471
	.float -0.748798
	.float 0.320695
	.float 0.161092
	.float -0.537143
	.float 0.696389
	.float -0.622170
	.float 0.384379
	.float -0.091728
	.float -0.159694
	.float 0.314869
	.float -0.364791
	.float 0.341314
	.float -0.307084
	.float 0.334787
	.float -0.474008
	.float 0.722159
	.float -1.023570
	.float 1.301016
	.float -1.494088
	.float 1.570024
	.float -1.501927
	.float 1.248542
	.float -0.775986
	.float 0.119511
	.float 0.569296
	.float -1.052436
	.float 1.119387
	.float -0.718466
	.float 0.011394
	.float 0.695773
	.float -1.107551
	.float 1.085788
	.float -0.704130
	.float 0.186916
	.float 0.224220
	.float -0.398068
	.float 0.367173
	.float -0.281709
	.float 0.295597
	.float -0.457985
	.float 0.681550
	.float -0.808458
	.float 0.725187
	.float -0.440728
	.float 0.070886
	.float 0.253547
	.float -0.477495
	.float 0.637942
	.float -0.797746
	.float 0.958322
	.float -1.029481
	.float 0.886636
	.float -0.474419
	.float -0.122918
	.float 0.700810
	.float -1.037480
	.float 1.016790
	.float -0.693096
	.float 0.257830
	.float 0.070375
	.float -0.162585
	.float 0.033241
	.float 0.195821
	.float -0.387524
	.float 0.473313
	.float -0.478806
	.float 0.487307
	.float -0.576348
	.float 0.768675
	.float -1.018453
	.float 1.230510
	.float -1.299824
	.float 1.158589
	.float -0.814479
	.float 0.359752
	.float 0.063053
	.float -0.329795
	.float 0.400271
	.float -0.336227
	.float 0.254492
	.float -0.243530
	.float 0.302148
	.float -0.346238
	.float 0.280030
	.float -0.077242
	.float -0.192523
	.float 0.415421
	.float -0.522986
	.float 0.546853
	.float -0.590812
	.float 0.739776
	.float -0.977466
	.float 1.179816
	.float -1.193311
	.float 0.943148
	.float -0.495342
	.float 0.031340
	.float 0.246632
	.float -0.220093
	.float -0.090066
	.float 0.541611
	.float -0.943888
	.float 1.142282
	.float -1.073073
	.float 0.770934
	.float -0.338224
	.float -0.101827
	.float 0.447821
	.float -0.649054
	.float 0.715462
	.float -0.705584
	.float 0.693364
	.float -0.725345
	.float 0.789803
	.float -0.817245
	.float 0.715080
	.float -0.420544
	.float -0.054222
	.float 0.606621
	.float -1.067479
	.float 1.259645
	.float -1.072575
	.float 0.521955
	.float 0.238143
	.float -0.967916
	.float 1.443095
	.float -1.556231
	.float 1.360727
	.float -1.028628
	.float 0.745216
	.float -0.605175
	.float 0.575287
	.float -0.543336
	.float 0.412834
	.float -0.173280
	.float -0.101639
	.float 0.317158
	.float -0.424165
	.float 0.435727
	.float -0.387562
	.float 0.288334
	.float -0.112683
	.float -0.152166
	.float 0.450510
	.float -0.652580
	.float 0.620700
	.float -0.306389
	.float -0.194497
	.float 0.677148
	.float -0.938550
	.float 0.894275
	.float -0.625830
	.float 0.327485
	.float -0.187168
	.float 0.276889
	.float -0.519901
	.float 0.749963
	.float -0.818654
	.float 0.680003
	.float -0.404396
	.float 0.125023
	.float 0.039891
	.float -0.042127
	.float -0.084661
	.float 0.248817
	.float -0.342825
	.float 0.288593
	.float -0.073497
	.float -0.238386
	.float 0.530210
	.float -0.684632
	.float 0.636846
	.float -0.398620
	.float 0.044630
	.float 0.322406
	.float -0.603751
	.float 0.724826
	.float -0.650642
	.float 0.402769
	.float -0.068403
	.float -0.218588
	.float 0.332108
	.float -0.223233
	.float -0.038211
	.float 0.285938
	.float -0.344733
	.float 0.139464
	.float 0.242417
	.float -0.585948
	.float 0.674230
	.float -0.432508
	.float -0.006085
	.float 0.368335
	.float -0.407001
	.float 0.057141
	.float 0.524622
	.float -1.063494
	.float 1.337712
	.float -1.298110
	.float 1.062421
	.float -0.804735
	.float 0.630697
	.float -0.523841
	.float 0.385735
	.float -0.125826
	.float -0.265873
	.float 0.703623
	.float -1.046168
	.float 1.161927
	.float -0.985805
	.float 0.546916
	.float 0.039363
	.float -0.610078
	.float 1.010653
	.float -1.148601
	.float 1.025976
	.float -0.737380
	.float 0.431414
	.float -0.247757
	.float 0.252842
	.float -0.404667
	.float 0.570012
	.float -0.594648
	.float 0.395484
	.float -0.021865
	.float -0.358336
	.float 0.549882
	.float -0.448471
	.float 0.109559
	.float 0.281779
	.float -0.522813
	.float 0.510826
	.float -0.286968
	.float -0.017200
	.float 0.279847
	.float -0.455901
	.float 0.567779
	.float -0.644133
	.float 0.671014
	.float -0.599086
	.float 0.395562
	.float -0.090156
	.float -0.225499
	.float 0.443267
	.float -0.491843
	.float 0.362985
	.float -0.102792
	.float -0.213848
	.float 0.505392
	.float -0.697012
	.float 0.733684
	.float -0.598854
	.float 0.331547
	.float -0.025167
	.float -0.203470
	.float 0.267503
	.float -0.158757
	.float -0.040823
	.float 0.199745
	.float -0.212564
	.float 0.065479
	.float 0.153013
	.float -0.308616
	.float 0.310013
	.float -0.169735
	.float -0.005227
	.float 0.084704
	.float 0.002494
	.float -0.229635
	.float 0.492970
	.float -0.668999
	.float 0.671055
	.float -0.482994
	.float 0.167109
	.float 0.153090
	.float -0.336659
	.float 0.289229
	.float -0.018966
	.float -0.354536
	.float 0.655897
	.float -0.747481
	.float 0.602171
	.float -0.308028
	.float 0.005743
	.float 0.194534
	.float -0.260992
	.float 0.230062
	.float -0.161116
	.float 0.097972
	.float -0.062441
	.float 0.068637
	.float -0.129809
	.float 0.243180
	.float -0.370287
	.float 0.442778
	.float -0.403544
	.float 0.255122
	.float -0.073134
	.float -0.034430
	.float -0.002910
	.float 0.169424
	.float -0.371050
	.float 0.494236
	.float -0.475763
	.float 0.338134
	.float -0.170082
	.float 0.067034
	.float -0.072259
	.float 0.158862
	.float -0.264813
	.float 0.352765
	.float -0.443604
	.float 0.590321
	.float -0.808586
	.float 1.023573
	.float -1.088211
	.float 0.874899
	.float -0.379509
	.float -0.240411
	.float 0.729953
	.float -0.867170
	.float 0.578247
	.float 0.031580
	.float -0.741719
	.float 1.325480
	.float -1.636230
	.float 1.630990
	.float -1.341560
	.float 0.835774
	.float -0.202940
	.float -0.438361
	.float 0.941399
	.float -1.168239
	.float 1.054093
	.float -0.655924
	.float 0.141969
	.float 0.283984
	.float -0.481835
	.float 0.435992
	.float -0.241464
	.float 0.031178
	.float 0.100254
	.float -0.125235
	.float 0.057373
	.float 0.089561
	.float -0.311423
	.float 0.584148
	.float -0.835342
	.float 0.964360
	.float -0.911493
	.float 0.718320
	.float -0.513168
	.float 0.416675
	.float -0.441077
	.float 0.475719
	.float -0.381762
	.float 0.119946
	.float 0.201802
	.float -0.408712
	.float 0.402685
	.float -0.244995
	.float 0.103547
	.float -0.105936
	.float 0.222009
	.float -0.278364
	.float 0.098440
	.float 0.341031
	.float -0.861570
	.float 1.182987
	.float -1.098699
	.float 0.601634
	.float 0.119662
	.float -0.795833
	.float 1.213826
	.float -1.293380
	.float 1.081764
	.float -0.701099
	.float 0.292625
	.float 0.024204
	.float -0.181163
	.float 0.179325
	.float -0.083856
	.float -0.013939
	.float 0.052351
	.float -0.037978
	.float 0.038037
	.float -0.127771
	.float 0.326558
	.float -0.566620
	.float 0.720257
	.float -0.675112
	.float 0.413415
	.float -0.041268
	.float -0.260835
	.float 0.344712
	.float -0.191350
	.float -0.071372
	.float 0.250306
	.float -0.215701
	.float -0.013818
	.float 0.291569
	.float -0.450009
	.float 0.411582
	.float -0.221949
	.float -0.006290
	.float 0.178856
	.float -0.260763
	.float 0.255840
	.float -0.171791
	.float 0.024165
	.float 0.124274
	.float -0.148655
	.float -0.078306
	.float 0.577624
	.float -1.196557
	.float 1.659620
	.float -1.723200
	.float 1.330657
	.float -0.656338
	.float 0.005557
	.float 0.360965
	.float -0.363817
	.float 0.123631
	.float 0.135265
	.float -0.225835
	.float 0.097280
	.float 0.158144
	.float -0.382427
	.float 0.458763
	.float -0.382633
	.float 0.257240
	.float -0.218707
	.float 0.338143
	.float -0.562259
	.float 0.733076
	.float -0.681255
	.float 0.340173
	.float 0.189626
	.float -0.672599
	.float 0.858372
	.float -0.625666
	.float 0.064103
	.float 0.561795
	.float -0.953655
	.float 0.944627
	.float -0.587063
	.float 0.106895
	.float 0.242709
	.float -0.328322
	.float 0.188292
	.float 0.030626
	.float -0.188135
	.float 0.227054
	.float -0.169109
	.float 0.059991
	.float 0.073360
	.float -0.219740
	.float 0.355337
	.float -0.435384
	.float 0.424183
	.float -0.336578
	.float 0.244328
	.float -0.229504
	.float 0.316272
	.float -0.437986
	.float 0.472673
	.float -0.326332
	.float 0.003511
	.float 0.386379
	.float -0.690047
	.float 0.793109
	.float -0.670343
	.float 0.380829
	.float -0.027933
	.float -0.279757
	.float 0.448334
	.float -0.409755
	.float 0.143301
	.float 0.293295
	.float -0.751972
	.float 1.034485
	.float -0.985373
	.float 0.590389
	.float -0.008949
	.float -0.499986
	.float 0.727351
	.float -0.643444
	.float 0.413093
	.float -0.277897
	.float 0.385762
	.float -0.691812
	.float 1.001414
	.float -1.116248
	.float 0.966933
	.float -0.635692
	.float 0.270103
	.float 0.023850
	.float -0.219615
	.float 0.326904
	.float -0.334027
	.float 0.206374
	.float 0.057286
	.float -0.377879
	.float 0.621672
	.float -0.689523
	.float 0.590413
	.float -0.427220
	.float 0.302395
	.float -0.230514
	.float 0.141443
	.float 0.025463
	.float -0.226092
	.float 0.312916
	.float -0.146841
	.float -0.269330
	.float 0.752160
	.float -1.036819
	.float 0.945426
	.float -0.501559
	.float -0.088739
	.float 0.566510
	.float -0.763036
	.float 0.665661
	.float -0.384117
	.float 0.064277
	.float 0.184782
	.float -0.315635
	.float 0.327783
	.float -0.241991
	.float 0.084518
	.float 0.115536
	.float -0.322904
	.float 0.494114
	.float -0.581686
	.float 0.546809
	.float -0.377920
	.float 0.106362
	.float 0.193370
	.float -0.426985
	.float 0.523168
	.float -0.477376
	.float 0.369116
	.float -0.329637
	.float 0.461478
	.float -0.749394
	.float 1.029490
	.float -1.064322
	.float 0.701581
	.float -0.014646
	.float -0.692867
	.float 1.054290
	.float -0.882275
	.float 0.312398
	.float 0.271766
	.float -0.494397
	.float 0.245393
	.float 0.248906
	.float -0.596851
	.float 0.531081
	.float -0.106181
	.float -0.338393
	.float 0.422517
	.float -0.002016
	.float -0.718084
	.float 1.312393
	.float -1.415869
	.float 0.963270
	.float -0.226974
	.float -0.366085
	.float 0.508861
	.float -0.196584
	.float -0.294056
	.float 0.600383
	.float -0.505154
	.float 0.055250
	.float 0.496361
	.float -0.872160
	.float 0.948999
	.float -0.819244
	.float 0.701367
	.float -0.767268
	.float 1.007339
	.float -1.228290
	.float 1.187240
	.float -0.770618
	.float 0.092098
	.float 0.562090
	.float -0.906927
	.float 0.835291
	.float -0.479715
	.float 0.121483
	.float -0.013280
	.float 0.234445
	.float -0.666585
	.float 1.090294
	.float -1.325811
	.float 1.324574
	.float -1.165849
	.float 0.979468
	.float -0.855001
	.float 0.792206
	.float -0.712308
	.float 0.515481
	.float -0.150524
	.float -0.339186
	.float 0.817751
	.float -1.111092
	.float 1.091141
	.float -0.749081
	.float 0.216171
	.float 0.284848
	.float -0.538660
	.float 0.438320
	.float -0.036507
	.float -0.480481
	.float 0.882982
	.float -1.005983
	.float 0.820285
	.float -0.434233
	.float 0.032108
	.float 0.214330
	.float -0.218448
	.float 0.008325
	.float 0.291783
	.float -0.518369
	.float 0.544898
	.float -0.348855
	.float 0.035256
	.float 0.207203
	.float -0.206638
	.float -0.087634
	.float 0.564644
	.float -1.009398
	.float 1.227136
	.float -1.153570
	.float 0.879381
	.float -0.579364
	.float 0.403865
	.float -0.407773
	.float 0.552418
	.float -0.754723
	.float 0.932359
	.float -1.017052
	.float 0.951655
	.float -0.702160
	.float 0.291311
	.float 0.175727
	.float -0.531635
	.float 0.618593
	.float -0.374049
	.float -0.125228
	.float 0.692387
	.float -1.117631
	.float 1.261120
	.float -1.099116
	.float 0.705388
	.float -0.194091
	.float -0.328987
	.float 0.777452
	.float -1.069598
	.float 1.126444
	.float -0.905779
	.float 0.451586
	.float 0.090510
	.float -0.524375
	.float 0.698240
	.float -0.579537
	.float 0.255944
	.float 0.134154
	.float -0.485405
	.float 0.761137
	.float -0.964578
	.float 1.085126
	.float -1.078349
	.float 0.903449
	.float -0.585582
	.float 0.239089
	.float -0.014491
	.float -0.002999
	.float -0.135423
	.float 0.267906
	.float -0.237219
	.float 0.011602
	.float 0.285227
	.float -0.462584
	.float 0.402131
	.float -0.139432
	.float -0.171856
	.float 0.378195
	.float -0.431369
	.float 0.404777
	.float -0.419304
	.float 0.541781
	.float -0.729464
	.float 0.854038
	.float -0.786394
	.float 0.489688
	.float -0.064627
	.float -0.286620
	.float 0.368848
	.float -0.118605
	.float -0.333410
	.float 0.715465
	.float -0.766669
	.float 0.398062
	.float 0.244565
	.float -0.864208
	.float 1.190003
	.float -1.128313
	.float 0.787651
	.float -0.372815
	.float 0.040430
	.float 0.173166
	.float -0.311030
	.float 0.400378
	.float -0.402596
	.float 0.257585
	.float 0.022236
	.float -0.305167
	.float 0.400387
	.float -0.191349
	.float -0.259503
	.float 0.723241
	.float -0.936135
	.float 0.763915
	.float -0.286870
	.float -0.249697
	.float 0.583084
	.float -0.579677
	.float 0.289495
	.float 0.113606
	.float -0.452683
	.float 0.642953
	.float -0.704380
	.float 0.700160
	.float -0.661634
	.float 0.563172
	.float -0.363921
	.float 0.075403
	.float 0.209259
	.float -0.358482
	.float 0.290047
	.float -0.034860
	.float -0.276845
	.float 0.499008
	.float -0.558471
	.float 0.482168
	.float -0.349123
	.float 0.216090
	.float -0.081213
	.float -0.090232
	.float 0.311271
	.float -0.543688
	.float 0.717393
	.float -0.776066
	.float 0.707703
	.float -0.540305
	.float 0.318162
	.float -0.086681
	.float -0.104539
	.float 0.196023
	.float -0.131688
	.float -0.107060
	.float 0.469698
	.float -0.836701
	.float 1.062609
	.float -1.043528
	.float 0.771286
	.float -0.342143
	.float -0.086906
	.float 0.370976
	.float -0.440945
	.float 0.325554
	.float -0.122913
	.float -0.059696
	.float 0.162898
	.float -0.197569
	.float 0.221625
	.float -0.288668
	.float 0.402450
	.float -0.505717
	.float 0.508805
	.float -0.339335
	.float -0.013246
	.float 0.477328
	.float -0.910903
	.float 1.146691
	.float -1.062355
	.float 0.648937
	.float -0.035080
	.float -0.564036
	.float 0.956105
	.float -1.072385
	.float 0.987239
	.float -0.842117
	.float 0.735598
	.float -0.667837
	.float 0.577391
	.float -0.427557
	.float 0.259762
	.float -0.168466
	.float 0.224391
	.float -0.414729
	.float 0.646973
	.float -0.806861
	.float 0.822311
	.float -0.692661
	.float 0.476428
	.float -0.257631
	.float 0.113075
	.float -0.089749
	.float 0.191334
	.float -0.373566
	.float 0.553881
	.float -0.640381
	.float 0.575737
	.float -0.376090
	.float 0.137181
	.float 0.008823
	.float 0.028702
	.float -0.231801
	.float 0.469212
	.float -0.569925
	.float 0.434326
	.float -0.107215
	.float -0.243291
	.float 0.432001
	.float -0.375256
	.float 0.138999
	.float 0.114815
	.float -0.239885
	.float 0.192697
	.float -0.037533
	.float -0.120379
	.float 0.211376
	.float -0.228454
	.float 0.197613
	.float -0.134267
	.float 0.032590
	.float 0.106179
	.float -0.243932
	.float 0.313337
	.float -0.262654
	.float 0.098407
	.float 0.112944
	.float -0.286188
	.float 0.366934
	.float -0.353555
	.float 0.282943
	.float -0.199542
	.float 0.130478
	.float -0.076275
	.float 0.014229
	.float 0.088926
	.float -0.255980
	.float 0.475343
	.float -0.687067
	.float 0.794030
	.float -0.701921
	.float 0.374746
	.float 0.121838
	.float -0.619774
	.float 0.908346
	.float -0.840769
	.float 0.436057
	.float 0.094764
	.float -0.439893
	.float 0.363158
	.float 0.139530
	.float -0.815516
	.float 1.295908
	.float -1.318223
	.float 0.884022
	.float -0.246034
	.float -0.260925
	.float 0.423203
	.float -0.247689
	.float -0.095496
	.float 0.423873
	.float -0.663870
	.float 0.857195
	.float -1.066906
	.float 1.276937
	.float -1.377144
	.float 1.246310
	.float -0.859514
	.float 0.327172
	.float 0.166197
	.float -0.470151
	.float 0.536776
	.float -0.407156
	.float 0.148209
	.float 0.192335
	.float -0.575827
	.float 0.932675
	.float -1.147093
	.float 1.096735
	.float -0.726790
	.float 0.106303
	.float 0.575031
	.float -1.076039
	.float 1.209766
	.float -0.936583
	.float 0.395851
	.float 0.149508
	.float -0.438078
	.float 0.341818
	.float 0.072427
	.float -0.590842
	.float 0.979519
	.float -1.107602
	.float 0.991292
	.float -0.744187
	.float 0.484588
	.float -0.269969
	.float 0.094994
	.float 0.064232
	.float -0.207530
	.float 0.305063
	.float -0.327735
	.float 0.283255
	.float -0.224713
	.float 0.222751
	.float -0.320704
	.float 0.505288
	.float -0.712958
	.float 0.865579
	.float -0.909025
	.float 0.830281
	.float -0.649894
	.float 0.405368
	.float -0.142421
	.float -0.086061
	.float 0.226385
	.float -0.244651
	.float 0.150993
	.float -0.005016
	.float -0.109602
	.float 0.128641
	.float -0.039337
	.float -0.119631
	.float 0.285726
	.float -0.405004
	.float 0.450054
	.float -0.421638
	.float 0.342915
	.float -0.252050
	.float 0.188976
	.float -0.175079
	.float 0.196787
	.float -0.210074
	.float 0.169728
	.float -0.063553
	.float -0.077359
	.float 0.203102
	.float -0.284441
	.float 0.334373
	.float -0.395610
	.float 0.506110
	.float -0.669074
	.float 0.844248
	.float -0.961529
	.float 0.949148
	.float -0.768910
	.float 0.445804
	.float -0.071083
	.float -0.236063
	.float 0.394489
	.float -0.409966
	.float 0.365236
	.float -0.353513
	.float 0.407612
	.float -0.483334
	.float 0.508176
	.float -0.448507
	.float 0.335413
	.float -0.231870
	.float 0.178268
	.float -0.167291
	.float 0.163549
	.float -0.139234
	.float 0.087869
	.float -0.009118
	.float -0.107704
	.float 0.272948
	.float -0.463978
	.float 0.607402
	.float -0.608460
	.float 0.418842
	.float -0.092300
	.float -0.224138
	.float 0.371179
	.float -0.280929
	.float 0.029317
	.float 0.205631
	.float -0.257517
	.float 0.082929
	.float 0.205540
	.float -0.408464
	.float 0.366174
	.float -0.059724
	.float -0.378132
	.float 0.744530
	.float -0.883304
	.float 0.762145
	.float -0.470437
	.float 0.153961
	.float 0.061898
	.float -0.116789
	.float 0.019709
	.float 0.168436
	.float -0.356205
	.float 0.448119
	.float -0.384248
	.float 0.182132
	.float 0.052735
	.float -0.177287
	.float 0.105867
	.float 0.115507
	.float -0.323244
	.float 0.346399
	.float -0.139289
	.float -0.166973
	.float 0.342843
	.float -0.217576
	.float -0.198644
	.float 0.715256
	.float -1.078834
	.float 1.118734
	.float -0.823486
	.float 0.314562
	.float 0.239920
	.float -0.701525
	.float 0.988756
	.float -1.066909
	.float 0.934979
	.float -0.626614
	.float 0.214349
	.float 0.201991
	.float -0.523266
	.float 0.677693
	.float -0.629767
	.float 0.375459
	.float 0.058091
	.float -0.600144
	.float 1.125726
	.float -1.474769
	.float 1.512704
	.float -1.207564
	.float 0.672134
	.float -0.127866
	.float -0.205457
	.float 0.235222
	.float -0.054819
	.float -0.113972
	.float 0.068826
	.float 0.228134
	.float -0.609783
	.float 0.805507
	.float -0.623586
	.float 0.090968
	.float 0.549491
	.float -0.986312
	.float 1.030220
	.float -0.716648
	.float 0.255909
	.float 0.120616
	.float -0.299531
	.float 0.316418
	.float -0.278713
	.float 0.262092
	.float -0.265257
	.float 0.244012
	.float -0.175209
	.float 0.085860
	.float -0.027011
	.float 0.024799
	.float -0.055826
	.float 0.065042
	.float -0.005651
	.float -0.130152
	.float 0.304225
	.float -0.444298
	.float 0.468706
	.float -0.324943
	.float 0.034947
	.float 0.283782
	.float -0.460155
	.float 0.376076
	.float -0.073083
	.float -0.236149
	.float 0.292688
	.float 0.017550
	.float -0.552680
	.float 0.987411
	.float -1.034035
	.float 0.650729
	.float -0.074869
	.float -0.349290
	.float 0.419584
	.float -0.213776
	.float 0.016201
	.float -0.093896
	.float 0.493092
	.float -1.004397
	.float 1.316214
	.float -1.239958
	.float 0.845225
	.float -0.413841
	.float 0.250613
	.float -0.482487
	.float 0.977370
	.float -1.428336
	.float 1.542807
	.float -1.216091
	.float 0.587528
	.float 0.045847
	.float -0.399019
	.float 0.349269
	.float 0.014917
	.float -0.463594
	.float 0.762818
	.float -0.797183
	.float 0.613896
	.float -0.375009
	.float 0.252864
	.float -0.328200
	.float 0.543632
	.float -0.736283
	.float 0.733404
	.float -0.459964
	.float -0.005764
	.float 0.467564
	.float -0.723145
	.float 0.685415
	.float -0.432806
	.float 0.152104
	.float -0.009540
	.float 0.038577
	.float -0.122507
	.float 0.084292
	.float 0.179680
	.float -0.614170
	.float 1.025442
	.float -1.191693
	.float 0.991969
	.float -0.476801
	.float -0.155463
	.float 0.656657
	.float -0.845875
	.float 0.688148
	.float -0.302670
	.float -0.097374
	.float 0.301907
	.float -0.194866
	.float -0.198081
	.float 0.722460
	.float -1.161757
	.float 1.330991
	.float -1.158031
	.float 0.715798
	.float -0.187487
	.float -0.219777
	.float 0.369551
	.float -0.249793
	.float -0.038171
	.float 0.342501
	.float -0.537408
	.float 0.576086
	.float -0.500969
	.float 0.412264
	.float -0.409794
	.float 0.531626
	.float -0.721133
	.float 0.847827
	.float -0.781798
	.float 0.483855
	.float -0.049863
	.float -0.333821
	.float 0.508212
	.float -0.454927
	.float 0.315626
	.float -0.288795
	.float 0.471397
	.float -0.768922
	.float 0.956426
	.float -0.855904
	.float 0.493661
	.float -0.105594
	.float -0.026210
	.float -0.214525
	.float 0.681520
	.float -1.060764
	.float 1.085710
	.float -0.713298
	.float 0.139155
	.float 0.344417
	.float -0.533090
	.float 0.409406
	.float -0.107337
	.float -0.205617
	.float 0.431530
	.float -0.566218
	.float 0.650922
	.float -0.707888
	.float 0.713694
	.float -0.624620
	.float 0.425829
	.float -0.161329
	.float -0.082336
	.float 0.230931
	.float -0.278269
	.float 0.299033
	.float -0.400742
	.float 0.640691
	.float -0.966211
	.float 1.228424
	.float -1.271215
	.float 1.039576
	.float -0.630137
	.float 0.241641
	.float -0.052383
	.float 0.106062
	.float -0.286006
	.float 0.398250
	.float -0.308070
	.float 0.035087
	.float 0.259520
	.float -0.384171
	.float 0.247966
	.float 0.079131
	.float -0.413865
	.float 0.575794
	.float -0.489476
	.float 0.210280
	.float 0.128198
	.float -0.394611
	.float 0.511115
	.float -0.455279
	.float 0.236661
	.float 0.114175
	.float -0.532160
	.float 0.903619
	.float -1.087358
	.float 0.978685
	.float -0.580610
	.float 0.026786
	.float 0.473161
	.float -0.741162
	.float 0.726117
	.float -0.526524
	.float 0.326004
	.float -0.280949
	.float 0.427489
	.float -0.661682
	.float 0.803651
	.float -0.709292
	.float 0.364449
	.float 0.094702
	.float -0.450641
	.float 0.525215
	.float -0.282024
	.float -0.150345
	.float 0.548165
	.float -0.713855
	.float 0.578089
	.float -0.225111
	.float -0.168813
	.float 0.442480
	.float -0.534398
	.float 0.494630
	.float -0.423364
	.float 0.385044
	.float -0.361200
	.float 0.272003
	.float -0.044993
	.float -0.321843
	.float 0.744080
	.float -1.085865
	.float 1.220845
	.float -1.086485
	.float 0.711146
	.float -0.201578
	.float -0.308443
	.float 0.727538
	.float -1.050457
	.float 1.336284
	.float -1.626352
	.float 1.865970
	.float -1.908701
	.float 1.622025
	.float -1.019544
	.float 0.303030
	.float 0.241245
	.float -0.425489
	.float 0.280966
	.float -0.017109
	.float -0.147859
	.float 0.146771
	.float -0.086305
	.float 0.123569
	.float -0.307838
	.float 0.522581
	.float -0.574208
	.float 0.353767
	.float 0.057950
	.float -0.424073
	.float 0.502072
	.float -0.205730
	.float -0.330948
	.float 0.828621
	.float -1.025862
	.float 0.826654
	.float -0.343416
	.float -0.183655
	.float 0.532845
	.float -0.620093
	.float 0.523057
	.float -0.407439
	.float 0.411588
	.float -0.564215
	.float 0.780391
	.float -0.928511
	.float 0.917817
	.float -0.750053
	.float 0.506280
	.float -0.284428
	.float 0.134044
	.float -0.033893
	.float -0.072780
	.float 0.212806
	.float -0.339153
	.float 0.348688
	.float -0.158153
	.float -0.212568
	.float 0.617005
	.float -0.850668
	.float 0.776719
	.float -0.422595
	.float -0.027863
	.float 0.349365
	.float -0.417850
	.float 0.277104
	.float -0.083869
	.float -0.018533
	.float -0.005570
	.float 0.091702
	.float -0.164631
	.float 0.221170
	.float -0.330200
	.float 0.551828
	.float -0.852107
	.float 1.094682
	.float -1.125538
	.float 0.885941
	.float -0.463564
	.float 0.039521
	.float 0.228828
	.float -0.301975
	.float 0.262795
	.float -0.235625
	.float 0.285698
	.float -0.374046
	.float 0.396861
	.float -0.275829
	.float 0.030879
	.float 0.219247
	.float -0.331398
	.float 0.236369
	.float 0.010294
	.float -0.264500
	.float 0.394668
	.float -0.372991
	.float 0.285882
	.float -0.251300
	.float 0.305146
	.float -0.349376
	.float 0.212819
	.float 0.209450
	.float -0.838692
	.float 1.411753
	.float -1.614675
	.float 1.272446
	.float -0.470890
	.float -0.474291
	.float 1.186617
	.float -1.429564
	.float 1.213528
	.float -0.750306
	.float 0.299954
	.float -0.020156
	.float -0.087947
	.float 0.122135
	.float -0.172295
	.float 0.247865
	.float -0.282500
	.float 0.196853
	.float 0.034198
	.float -0.354902
	.float 0.652535
	.float -0.811456
	.float 0.765900
	.float -0.526974
	.float 0.175557
	.float 0.170837
	.float -0.398673
	.float 0.429638
	.float -0.238003
	.float -0.140428
	.float 0.605479
	.float -1.006010
	.float 1.183645
	.float -1.041757
	.float 0.604773
	.float -0.023037
	.float -0.492528
	.float 0.771938
	.float -0.760741
	.float 0.524118
	.float -0.188873
	.float -0.126338
	.float 0.345383
	.float -0.427536
	.float 0.352262
	.float -0.129833
	.float -0.166286
	.float 0.389351
	.float -0.373754
	.float 0.042693
	.float 0.505130
	.float -1.013842
	.float 1.209969
	.float -0.978315
	.float 0.443333
	.float 0.115480
	.float -0.456152
	.float 0.527787
	.float -0.468133
	.float 0.457797
	.float -0.560289
	.float 0.680599
	.float -0.666001
	.float 0.451487
	.float -0.123072
	.float -0.146117
	.float 0.221724
	.float -0.090293
	.float -0.155351
	.float 0.392510
	.float -0.532252
	.float 0.530732
	.float -0.371161
	.float 0.063213
	.float 0.329589
	.float -0.674686
	.float 0.814726
	.float -0.665127
	.float 0.294573
	.float 0.089720
	.float -0.262164
	.float 0.123995
	.float 0.236574
	.float -0.614930
	.float 0.831783
	.float -0.833172
	.float 0.682113
	.float -0.475805
	.float 0.278803
	.float -0.125899
	.float 0.061818
	.float -0.143232
	.float 0.377175
	.float -0.656070
	.float 0.777944
	.float -0.571195
	.float 0.037910
	.float 0.607318
	.float -1.053703
	.float 1.091153
	.float -0.745391
	.float 0.253927
	.float 0.095065
	.float -0.143342
	.float -0.057331
	.float 0.305102
	.float -0.392552
	.float 0.237685
	.float 0.071518
	.float -0.332519
	.float 0.344220
	.float -0.021170
	.float -0.550153
	.float 1.143129
	.float -1.499325
	.float 1.459446
	.float -1.043286
	.float 0.428797
	.float 0.156361
	.float -0.558349
	.float 0.753299
	.float -0.806789
	.float 0.782501
	.float -0.682715
	.float 0.470002
	.float -0.145025
	.float -0.196715
	.float 0.391523
	.float -0.310142
	.float -0.039455
	.float 0.493324
	.float -0.821915
	.float 0.872607
	.float -0.665208
	.float 0.372085
	.float -0.196538
	.float 0.235341
	.float -0.421292
	.float 0.582634
	.float -0.572876
	.float 0.376910
	.float -0.120649
	.float -0.017601
	.float -0.071657
	.float 0.359418
	.float -0.702666
	.float 0.940004
	.float -0.990294
	.float 0.890361
	.float -0.752536
	.float 0.676027
	.float -0.673193
	.float 0.659351
	.float -0.512486
	.float 0.163733
	.float 0.341365
	.float -0.853368
	.float 1.196527
	.float -1.262547
	.float 1.059011
	.float -0.685359
	.float 0.263351
	.float 0.121658
	.float -0.431092
	.float 0.644959
	.float -0.736182
	.float 0.677729
	.float -0.474270
	.float 0.183753
	.float 0.096780
	.float -0.275384
	.float 0.310243
	.float -0.227938
	.float 0.106220
	.float -0.031862
	.float 0.055044
	.float -0.163290
	.float 0.290442
	.float -0.357129
	.float 0.319226
	.float -0.191686
	.float 0.032542
	.float 0.098477
	.float -0.174098
	.float 0.203562
	.float -0.211289
	.float 0.213781
	.float -0.212428
	.float 0.200076
	.float -0.167539
	.float 0.103934
	.float 0.002303
	.float -0.153102
	.float 0.325926
	.float -0.471275
	.float 0.533277
	.float -0.483283
	.float 0.341684
	.float -0.168699
	.float 0.029723
	.float 0.040103
	.float -0.047916
	.float 0.026917
	.float -0.007946
	.float -0.000057
	.float 0.009200
	.float -0.035580
	.float 0.079536
	.float -0.117109
	.float 0.110113
	.float -0.031106
	.float -0.111060
	.float 0.263861
	.float -0.353424
	.float 0.328337
	.float -0.197872
	.float 0.034891
	.float 0.063828
	.float -0.036049
	.float -0.108899
	.float 0.298357
	.float -0.439822
	.float 0.466616
	.float -0.359772
	.float 0.147026
	.float 0.105707
	.float -0.304544
	.float 0.351937
	.float -0.192591
	.float -0.139694
	.float 0.517317
	.float -0.779822
	.float 0.829977
	.float -0.695141
	.float 0.500892
	.float -0.374126
	.float 0.352092
	.float -0.370991
	.float 0.338802
	.float -0.224085
	.float 0.080666
	.float 0.011123
	.float -0.027712
	.float 0.027881
	.float -0.093511
	.float 0.241443
	.float -0.394823
	.float 0.449094
	.float -0.376102
	.float 0.267431
	.float -0.268212
	.float 0.453347
	.float -0.753770
	.float 0.999959
	.float -1.047721
	.float 0.883232
	.float -0.626340
	.float 0.438424
	.float -0.412083
	.float 0.520896
	.float -0.650183
	.float 0.673705
	.float -0.523472
	.float 0.219634
	.float 0.145839
	.float -0.458506
	.float 0.639156
	.float -0.680259
	.float 0.638959
	.float -0.589751
	.float 0.568721
	.float -0.548511
	.float 0.460524
	.float -0.246897
	.float -0.092448
	.float 0.482887
	.float -0.794068
	.float 0.886749
	.float -0.675237
	.float 0.183853
	.float 0.434937
	.float -0.949491
	.float 1.158165
	.float -1.003342
	.float 0.613723
	.float -0.234807
	.float 0.083900
	.float -0.222720
	.float 0.531128
	.float -0.794214
	.float 0.838266
	.float -0.625720
	.float 0.258204
	.float 0.098798
	.float -0.313641
	.float 0.353534
	.float -0.290249
	.float 0.251216
	.float -0.341708
	.float 0.576229
	.float -0.858277
	.float 1.027117
	.float -0.950236
	.float 0.605452
	.float -0.098087
	.float -0.396307
	.float 0.720162
	.float -0.795124
	.float 0.631096
	.float -0.303713
	.float -0.068868
	.float 0.346575
	.float -0.408092
	.float 0.217372
	.float 0.124183
	.float -0.401359
	.float 0.402029
	.float -0.063770
	.float -0.458381
	.float 0.869686
	.float -0.918902
	.float 0.563988
	.float -0.002192
	.float -0.456965
	.float 0.587152
	.float -0.374892
	.float 0.001960
	.float 0.294743
	.float -0.378001
	.float 0.271788
	.float -0.100613
	.float -0.028690
	.float 0.101963
	.float -0.176548
	.float 0.298613
	.float -0.443270
	.float 0.532321
	.float -0.506277
	.float 0.376982
	.float -0.210535
	.float 0.062136
	.float 0.068731
	.float -0.217645
	.float 0.394015
	.float -0.547145
	.float 0.601572
	.float -0.532550
	.float 0.407880
	.float -0.348393
	.float 0.434189
	.float -0.636285
	.float 0.835515
	.float -0.914736
	.float 0.846808
	.float -0.704231
	.float 0.585528
	.float -0.526121
	.float 0.472819
	.float -0.343055
	.float 0.113032
	.float 0.145939
	.float -0.318362
	.float 0.341386
	.float -0.265997
	.float 0.228530
	.float -0.349305
	.float 0.631377
	.float -0.933301
	.float 1.040476
	.float -0.794521
	.float 0.201997
	.float 0.546177
	.float -1.161408
	.float 1.403133
	.float -1.199970
	.float 0.677493
	.float -0.080786
	.float -0.358246
	.float 0.531969
	.float -0.490147
	.float 0.386570
	.float -0.374892
	.float 0.511115
	.float -0.714910
	.float 0.813564
	.float -0.648401
	.float 0.183763
	.float 0.451908
	.float -1.026044
	.float 1.330875
	.float -1.299517
	.float 1.033162
	.float -0.725595
	.float 0.541337
	.float -0.531832
	.float 0.637212
	.float -0.754407
	.float 0.808908
	.float -0.779112
	.float 0.674027
	.float -0.504999
	.float 0.286986
	.float -0.063846
	.float -0.081061
	.float 0.058324
	.float 0.165302
	.float -0.525841
	.float 0.883608
	.float -1.100022
	.float 1.117405
	.float -0.983698
	.float 0.805475
	.float -0.664633
	.float 0.559541
	.float -0.410861
	.float 0.126626
	.float 0.317429
	.float -0.834490
	.float 1.249418
	.float -1.380756
	.float 1.143123
	.float -0.614295
	.float 0.020772
	.float 0.366204
	.float -0.376615
	.float 0.044265
	.float 0.405087
	.float -0.682012
	.float 0.600901
	.float -0.181283
	.float -0.375748
	.float 0.808440
	.float -0.929367
	.float 0.699230
	.float -0.219420
	.float -0.329100
	.float 0.762356
	.float -0.960599
	.float 0.910709
	.float -0.704476
	.float 0.482234
	.float -0.343726
	.float 0.283810
	.float -0.207234
	.float 0.018869
	.float 0.280201
	.float -0.573713
	.float 0.710559
	.float -0.622694
	.float 0.385697
	.float -0.173270
	.float 0.140148
	.float -0.319813
	.float 0.606192
	.float -0.825068
	.float 0.841759
	.float -0.635040
	.float 0.297003
	.float 0.031070
	.float -0.239659
	.float 0.298092
	.float -0.248155
	.float 0.162504
	.float -0.103268
	.float 0.102774
	.float -0.162573
	.float 0.257096
	.float -0.339061
	.float 0.355844
	.float -0.279072
	.float 0.129461
	.float 0.029377
	.float -0.133087
	.float 0.164638
	.float -0.166180
	.float 0.199428
	.float -0.284411
	.float 0.369447
	.float -0.362619
	.float 0.205772
	.float 0.063841
	.float -0.312931
	.float 0.379920
	.float -0.171763
	.float -0.270160
	.float 0.778314
	.float -1.141919
	.float 1.219203
	.float -1.012996
	.float 0.662332
	.float -0.355418
	.float 0.220805
	.float -0.267513
	.float 0.407442
	.float -0.532449
	.float 0.581969
	.float -0.555109
	.float 0.473298
	.float -0.341010
	.float 0.145515
	.float 0.107672
	.float -0.365307
	.float 0.541077
	.float -0.570557
	.float 0.461457
	.float -0.293689
	.float 0.165561
	.float -0.129568
	.float 0.170485
	.float -0.240683
	.float 0.316734
	.float -0.425021
	.float 0.613810
	.float -0.898522
	.float 1.227932
	.float -1.497414
	.float 1.596896
	.float -1.460799
	.float 1.097221
	.float -0.593271
	.float 0.098660
	.float 0.214798
	.float -0.217887
	.float -0.107858
	.float 0.639206
	.float -1.150395
	.float 1.415943
	.float -1.323739
	.float 0.931081
	.float -0.427495
	.float 0.027266
	.float 0.141530
	.float -0.085571
	.float -0.088637
	.float 0.257534
	.float -0.348825
	.float 0.354270
	.float -0.295535
	.float 0.186789
	.float -0.030546
	.float -0.156325
	.float 0.323646
	.float -0.407096
	.float 0.377876
	.float -0.279275
	.float 0.209847
	.float -0.255148
	.float 0.417662
	.float -0.603166
	.float 0.681052
	.float -0.576619
	.float 0.323333
	.float -0.033039
	.float -0.190142
	.float 0.319646
	.float -0.402483
	.float 0.490472
	.float -0.573794
	.float 0.580017
	.float -0.439703
	.float 0.157745
	.float 0.174356
	.float -0.435986
	.float 0.555500
	.float -0.547530
	.float 0.488555
	.float -0.459448
	.float 0.500090
	.float -0.598654
	.float 0.708720
	.float -0.776239
	.float 0.765462
	.float -0.677845
	.float 0.553065
	.float -0.443425
	.float 0.372201
	.float -0.310988
	.float 0.206687
	.float -0.046504
	.float -0.097634
	.float 0.101720
	.float 0.109587
	.float -0.475507
	.float 0.811376
	.float -0.926637
	.float 0.757441
	.float -0.403660
	.float 0.042431
	.float 0.201810
	.float -0.321038
	.float 0.383518
	.float -0.450310
	.float 0.534607
	.float -0.625851
	.float 0.724823
	.float -0.831253
	.float 0.895622
	.float -0.806354
	.float 0.461529
	.float 0.116250
	.float -0.730501
	.float 1.100464
	.float -1.047432
	.float 0.637889
	.float -0.157701
	.float -0.082670
	.float -0.025427
	.float 0.303832
	.float -0.415552
	.float 0.116670
	.float 0.551935
	.float -1.272213
	.float 1.648924
	.float -1.460093
	.float 0.790191
	.float 0.031909
	.float -0.635668
	.float 0.817248
	.float -0.630620
	.float 0.321008
	.float -0.156355
	.float 0.265073
	.float -0.575779
	.float 0.886594
	.float -1.009372
	.float 0.889497
	.float -0.622793
	.float 0.366142
	.float -0.213140
	.float 0.127724
	.float 0.018317
	.float -0.335854
	.float 0.820118
	.float -1.333807
	.float 1.680922
	.float -1.718261
	.float 1.433474
	.float -0.949622
	.float 0.465341
	.float -0.169889
	.float 0.171253
	.float -0.457714
	.float 0.899744
	.float -1.294155
	.float 1.444144
	.float -1.250170
	.float 0.767116
	.float -0.187666
	.float -0.253910
	.float 0.411171
	.float -0.310860
	.float 0.134705
	.float -0.100636
	.float 0.316702
	.float -0.705119
	.float 1.051003
	.float -1.144873
	.float 0.922896
	.float -0.512152
	.float 0.154580
	.float -0.063007
	.float 0.298738
	.float -0.739544
	.float 1.149433
	.float -1.308745
	.float 1.133830
	.float -0.720633
	.float 0.284602
	.float -0.028012
	.float 0.014635
	.float -0.134500
	.float 0.184960
	.float -0.014004
	.float -0.373176
	.float 0.817158
	.float -1.109956
	.float 1.125890
	.float -0.886570
	.float 0.521978
	.float -0.163981
	.float -0.145530
	.float 0.463347
	.float -0.865773
	.float 1.343661
	.float -1.758685
	.float 1.907756
	.float -1.662336
	.float 1.086819
	.float -0.442188
	.float 0.054148
	.float -0.118694
	.float 0.568346
	.float -1.090527
	.float 1.297553
	.float -0.951840
	.float 0.112957
	.float 0.883080
	.float -1.602413
	.float 1.745544
	.float -1.296376
	.float 0.504775
	.float 0.277032
	.float -0.793404
	.float 0.993748
	.float -0.993763
	.float 0.936666
	.float -0.867012
	.float 0.711068
	.float -0.370973
	.float -0.148999
	.float 0.691844
	.float -1.023439
	.float 0.986327
	.float -0.616963
	.float 0.132332
	.float 0.213457
	.float -0.299847
	.float 0.209051
	.float -0.140932
	.float 0.241699
	.float -0.484827
	.float 0.699859
	.float -0.722433
	.float 0.537978
	.float -0.298583
	.float 0.200973
	.float -0.329452
	.float 0.593128
	.float -0.802408
	.float 0.814288
	.float -0.626942
	.float 0.357644
	.float -0.139451
	.float 0.030331
	.float -0.001500
	.float -0.006914
	.float 0.029438
	.float -0.069854
	.float 0.136533
	.float -0.262743
	.float 0.473275
	.float -0.723086
	.float 0.879632
	.float -0.795919
	.float 0.437062
	.float 0.045291
	.float -0.376442
	.float 0.338963
	.float 0.058713
	.float -0.563711
	.float 0.838987
	.float -0.689946
	.float 0.188668
	.float 0.392885
	.float -0.780561
	.float 0.872330
	.float -0.766502
	.float 0.645531
	.float -0.623988
	.float 0.679621
	.float -0.702234
	.float 0.598749
	.float -0.361024
	.float 0.053617
	.float 0.245349
	.float -0.485524
	.float 0.636464
	.float -0.658707
	.float 0.503869
	.float -0.157716
	.float -0.314788
	.float 0.777616
	.float -1.093424
	.float 1.201624
	.float -1.137567
	.float 0.979686
	.float -0.779881
	.float 0.547214
	.float -0.296086
	.float 0.097832
	.float -0.062889
	.float 0.249619
	.float -0.578399
	.float 0.842954
	.float -0.833157
	.float 0.484046
	.float 0.065329
	.float -0.551509
	.float 0.747254
	.float -0.589713
	.float 0.197528
	.float 0.217004
	.float -0.470154
	.float 0.489912
	.float -0.328233
	.float 0.117195
	.float -0.002768
	.float 0.086088
	.float -0.387136
	.float 0.834966
	.float -1.284430
	.float 1.558246
	.float -1.510564
	.float 1.096655
	.float -0.418815
	.float -0.286951
	.float 0.738873
	.float -0.743183
	.float 0.304434
	.float 0.359257
	.float -0.919129
	.float 1.106523
	.float -0.854029
	.float 0.323271
	.float 0.196308
	.float -0.454319
	.float 0.369834
	.float -0.050292
	.float -0.302750
	.float 0.529868
	.float -0.598186
	.float 0.583528
	.float -0.577281
	.float 0.599572
	.float -0.589823
	.float 0.478470
	.float -0.273705
	.float 0.082831
	.float -0.041546
	.float 0.202684
	.float -0.474219
	.float 0.662177
	.float -0.594320
	.float 0.237420
	.float 0.275472
	.float -0.724734
	.float 0.931751
	.float -0.847174
	.float 0.550591
	.float -0.180525
	.float -0.143716
	.float 0.358598
	.float -0.447052
	.float 0.414088
	.float -0.276205
	.float 0.066941
	.float 0.160993
	.float -0.351335
	.float 0.471731
	.float -0.531021
	.float 0.568715
	.float -0.618757
	.float 0.671681
	.float -0.666054
	.float 0.523838
	.float -0.212248
	.float -0.210994
	.float 0.607890
	.float -0.829408
	.float 0.803159
	.float -0.583084
	.float 0.327321
	.float -0.214524
	.float 0.343785
	.float -0.672027
	.float 1.025845
	.float -1.191979
	.float 1.047113
	.float -0.652812
	.float 0.243870
	.float -0.095270
	.float 0.341445
	.float -0.871173
	.float 1.382410
	.float -1.567372
	.float 1.299648
	.float -0.693665
	.float 0.006421
	.float 0.531573
	.float -0.829909
	.float 0.931545
	.float -0.921120
	.float 0.838248
	.float -0.661560
	.float 0.360178
	.float 0.041443
	.float -0.441813
	.float 0.702640
	.float -0.725732
	.float 0.516617
	.float -0.191387
	.float -0.084238
	.float 0.190523
	.float -0.122788
	.float -0.015638
	.float 0.094544
	.float -0.053456
	.float -0.060898
	.float 0.146165
	.float -0.142346
	.float 0.093144
	.float -0.115580
	.float 0.298595
	.float -0.611667
	.float 0.899681
	.float -0.974047
	.float 0.737395
	.float -0.255394
	.float -0.273415
	.float 0.629958
	.float -0.699367
	.float 0.532723
	.float -0.307924
	.float 0.211528
	.float -0.313116
	.float 0.515934
	.float -0.625150
	.float 0.496218
	.float -0.159620
	.float -0.176846
	.float 0.263423
	.float 0.010203
	.float -0.521877
	.float 0.986008
	.float -1.136861
	.float 0.895515
	.float -0.407365
	.float -0.062635
	.float 0.293221
	.float -0.220294
	.float -0.055918
	.float 0.350223
	.float -0.496230
	.float 0.417590
	.float -0.144409
	.float -0.216191
	.float 0.531164
	.float -0.691060
	.float 0.644476
	.float -0.412625
	.float 0.083440
	.float 0.215384
	.float -0.363182
	.float 0.301889
	.float -0.075862
	.float -0.173127
	.float 0.268397
	.float -0.097021
	.float -0.308005
	.float 0.758950
	.float -1.000335
	.float 0.854497
	.float -0.341863
	.float -0.306982
	.float 0.770707
	.float -0.826335
	.float 0.491327
	.float -0.021636
	.float -0.242610
	.float 0.090858
	.float 0.421701
	.float -1.005372
	.float 1.314825
	.float -1.158255
	.float 0.603089
	.float 0.080029
	.float -0.583653
	.float 0.723837
	.float -0.502927
	.float 0.065512
	.float 0.393255
	.float -0.703149
	.float 0.758568
	.float -0.539796
	.float 0.127616
	.float 0.307385
	.float -0.567630
	.float 0.534055
	.float -0.254370
	.float -0.058447
	.float 0.141264
	.float 0.149332
	.float -0.722928
	.float 1.285011
	.float -1.507676
	.float 1.238030
	.float -0.604794
	.float -0.055159
	.float 0.407212
	.float -0.326436
	.float -0.037283
	.float 0.374561
	.float -0.424401
	.float 0.129081
	.float 0.359924
	.float -0.807841
	.float 1.050278
	.float -1.068349
	.float 0.951053
	.float -0.794349
	.float 0.621535
	.float -0.380779
	.float 0.013726
	.float 0.462306
	.float -0.924404
	.float 1.195591
	.float -1.148854
	.float 0.793803
	.float -0.283885
	.float -0.164661
	.float 0.388084
	.float -0.350074
	.float 0.136131
	.float 0.112984
	.float -0.274535
	.float 0.281872
	.float -0.125093
	.float -0.162588
	.float 0.513928
	.float -0.833792
	.float 1.015407
	.float -0.972375
	.float 0.675255
	.float -0.172786
	.float -0.417456
	.float 0.948114
	.float -1.294376
	.float 1.396192
	.float -1.273495
	.float 1.011204
	.float -0.722370
	.float 0.503234
	.float -0.394930
	.float 0.369691
	.float -0.354774
	.float 0.289851
	.float -0.182846
	.float 0.116028
	.float -0.181268
	.float 0.383762
	.float -0.595912
	.float 0.619422
	.float -0.330281
	.float -0.198331
	.float 0.700303
	.float -0.866595
	.float 0.547852
	.float 0.129812
	.float -0.820049
	.float 1.152371
	.float -0.946969
	.float 0.317500
	.float 0.394960
	.float -0.811790
	.float 0.717473
	.float -0.160849
	.float -0.589456
	.float 1.197305
	.float -1.427630
	.float 1.240760
	.float -0.774239
	.float 0.239870
	.float 0.192432
	.float -0.456271
	.float 0.572232
	.float -0.584917
	.float 0.513606
	.float -0.355573
	.float 0.129728
	.float 0.091435
	.float -0.203857
	.float 0.139397
	.float 0.076055
	.float -0.325920
	.float 0.470583
	.float -0.431819
	.float 0.237007
	.float 0.000185
	.float -0.143646
	.float 0.104662
	.float 0.115381
	.float -0.425787
	.float 0.690795
	.float -0.799225
	.float 0.723491
	.float -0.530783
	.float 0.333675
	.float -0.209620
	.float 0.144862
	.float -0.045605
	.float -0.186507
	.float 0.564092
	.float -0.972134
	.float 1.212020
	.float -1.116057
	.float 0.667968
	.float -0.048037
	.float -0.444343
	.float 0.561562
	.float -0.268318
	.float -0.224340
	.float 0.593069
	.float -0.622077
	.float 0.350545
	.float -0.031071
	.float -0.075400
	.float -0.089331
	.float 0.333494
	.float -0.375104
	.float 0.084683
	.float 0.384355
	.float -0.688610
	.float 0.547065
	.float 0.038405
	.float -0.764836
	.float 1.229977
	.float -1.207185
	.float 0.792644
	.float -0.321882
	.float 0.123439
	.float -0.292734
	.float 0.646678
	.float -0.881319
	.float 0.807123
	.float -0.486970
	.float 0.180084
	.float -0.139876
	.float 0.417039
	.float -0.810667
	.float 1.000350
	.float -0.763930
	.float 0.130216
	.float 0.633049
	.float -1.180027
	.float 1.285479
	.float -0.957744
	.float 0.407981
	.float 0.087703
	.float -0.340858
	.float 0.331577
	.float -0.186924
	.float 0.087402
	.float -0.163875
	.float 0.437920
	.float -0.823319
	.float 1.171896
	.float -1.333331
	.float 1.206914
	.float -0.776966
	.float 0.128749
	.float 0.563958
	.float -1.089928
	.float 1.284236
	.float -1.109772
	.float 0.685305
	.float -0.229406
	.float -0.055383
	.float 0.084546
	.float 0.090634
	.float -0.357507
	.float 0.640723
	.float -0.936663
	.float 1.254664
	.float -1.527213
	.float 1.590152
	.float -1.277924
	.float 0.572652
	.float 0.318687
	.float -1.042088
	.float 1.295488
	.float -1.014871
	.float 0.416756
	.float 0.132650
	.float -0.330731
	.float 0.095345
	.float 0.420756
	.float -0.943375
	.float 1.230504
	.float -1.176969
	.float 0.832868
	.float -0.354190
	.float -0.071698
	.float 0.291427
	.float -0.227933
	.float -0.100096
	.float 0.581129
	.float -1.039546
	.float 1.292981
	.float -1.227390
	.float 0.857672
	.float -0.333356
	.float -0.128529
	.float 0.354786
	.float -0.304875
	.float 0.078973
	.float 0.158108
	.float -0.280556
	.float 0.261054
	.float -0.154693
	.float 0.035915
	.float 0.054210
	.float -0.114554
	.float 0.154318
	.float -0.166496
	.float 0.133236
	.float -0.056391
	.float -0.022778
	.float 0.044527
	.float 0.015148
	.float -0.104673
	.float 0.120080
	.float 0.007901
	.float -0.225623
	.float 0.350676
	.float -0.178418
	.float -0.361251
	.float 1.115020
	.float -1.764724
	.float 2.006464
	.float -1.730415
	.float 1.078700
	.float -0.346715
	.float -0.197302
	.float 0.450554
	.float -0.488147
	.float 0.459630
	.float -0.457609
	.float 0.456435
	.float -0.361105
	.float 0.121470
	.float 0.184114
	.float -0.370344
	.float 0.267307
	.float 0.141435
	.float -0.670597
	.float 1.021484
	.float -0.958268
	.float 0.460125
	.float 0.249581
	.float -0.817400
	.float 0.950120
	.float -0.571076
	.float -0.144804
	.float 0.873599
	.float -1.320172
	.float 1.366941
	.float -1.107021
	.float 0.748697
	.float -0.461594
	.float 0.273238
	.float -0.086290
	.float -0.205262
	.float 0.597185
	.float -0.950331
	.float 1.081949
	.float -0.902927
	.float 0.494907
	.float -0.066245
	.float -0.184307
	.float 0.201368
	.float -0.111502
	.float 0.138105
	.float -0.445762
	.float 1.012432
	.float -1.614091
	.float 1.940238
	.float -1.779131
	.float 1.160556
	.float -0.360166
	.float -0.251389
	.float 0.428314
	.float -0.195980
	.float -0.179450
	.float 0.381539
	.float -0.261107
	.float -0.076128
	.float 0.372445
	.float -0.427107
	.float 0.246919
	.float -0.024736
	.float -0.028145
	.float -0.144943
	.float 0.405812
	.float -0.538997
	.float 0.425614
	.float -0.133404
	.float -0.141469
	.float 0.225508
	.float -0.089581
	.float -0.146842
	.float 0.320371
	.float -0.348697
	.float 0.282743
	.float -0.255288
	.float 0.373378
	.float -0.635350
	.float 0.928166
	.float -1.099102
	.float 1.047212
	.float -0.774198
	.float 0.371039
	.float 0.038149
	.float -0.351940
	.float 0.518238
	.float -0.531471
	.float 0.417221
	.float -0.217793
	.float -0.019542
	.float 0.253748
	.float -0.457207
	.float 0.613619
	.float -0.709703
	.float 0.732656
	.float -0.680954
	.float 0.578408
	.float -0.470062
	.float 0.391735
	.float -0.335014
	.float 0.245054
	.float -0.066249
	.float -0.195931
	.float 0.454825
	.float -0.593417
	.float 0.551375
	.float -0.372597
	.float 0.166049
	.float -0.010667
	.float -0.110527
	.float 0.284057
	.float -0.568119
	.float 0.912047
	.float -1.169733
	.float 1.202703
	.float -0.989602
	.float 0.652019
	.float -0.375986
	.float 0.292013
	.float -0.406134
	.float 0.626816
	.float -0.851305
	.float 1.029794
	.float -1.154610
	.float 1.198056
	.float -1.076325
	.float 0.696318
	.float -0.060016
	.float -0.668069
	.float 1.211268
	.float -1.336859
	.float 1.009583
	.float -0.422523
	.float -0.125712
	.float 0.418807
	.float -0.437044
	.float 0.320457
	.float -0.223387
	.float 0.185664
	.float -0.123479
	.float -0.059928
	.float 0.343329
	.float -0.552928
	.float 0.464652
	.float 0.026287
	.float -0.794200
	.float 1.519392
	.float -1.858051
	.float 1.638227
	.float -0.956829
	.float 0.119668
	.float 0.532464
	.float -0.802244
	.float 0.716239
	.float -0.471516
	.float 0.293313
	.float -0.294204
	.float 0.417358
	.float -0.492421
	.float 0.363832
	.float -0.006820
	.float -0.446906
	.float 0.791568
	.float -0.881038
	.float 0.718883
	.float -0.441398
	.float 0.210647
	.float -0.101053
	.float 0.064487
	.float 0.006713
	.float -0.176207
	.float 0.404083
	.float -0.574992
	.float 0.585948
	.float -0.421692
	.float 0.161752
	.float 0.079979
	.float -0.231314
	.float 0.295775
	.float -0.325279
	.float 0.362088
	.float -0.401770
	.float 0.407066
	.float -0.355934
	.float 0.275893
	.float -0.226755
	.float 0.240605
	.float -0.271765
	.float 0.209846
	.float 0.039073
	.float -0.460298
	.float 0.903750
	.float -1.156762
	.float 1.074525
	.float -0.678942
	.float 0.155629
	.float 0.250645
	.float -0.372758
	.float 0.204069
	.float 0.118688
	.float -0.411677
	.float 0.552466
	.float -0.532786
	.float 0.430502
	.float -0.329541
	.float 0.249347
	.float -0.134603
	.float -0.089081
	.float 0.435411
	.float -0.812953
	.float 1.052895
	.float -0.999378
	.float 0.612665
	.float -0.022978
	.float -0.506578
	.float 0.702347
	.float -0.431262
	.float -0.205443
	.float 0.903461
	.float -1.312554
	.float 1.237529
	.float -0.757719
	.float 0.177418
	.float 0.172247
	.float -0.151919
	.float -0.101860
	.float 0.293585
	.float -0.204763
	.float -0.130545
	.float 0.452793
	.float -0.493110
	.float 0.209555
	.float 0.153095
	.float -0.242435
	.float -0.113810
	.float 0.738757
	.float -1.199636
	.float 1.105363
	.float -0.390117
	.float -0.626068
	.float 1.440148
	.float -1.679610
	.float 1.305511
	.float -0.584783
	.float -0.112821
	.float 0.527796
	.float -0.599918
	.float 0.420783
	.float -0.134199
	.float -0.130303
	.float 0.275121
	.float -0.242414
	.float 0.038330
	.float 0.248977
	.float -0.480013
	.float 0.544436
	.float -0.435685
	.float 0.253945
	.float -0.128354
	.float 0.118868
	.float -0.176432
	.float 0.188947
	.float -0.070396
	.float -0.177731
	.float 0.472971
	.float -0.710162
	.float 0.824344
	.float -0.819531
	.float 0.755477
	.float -0.708186
	.float 0.726254
	.float -0.801147
	.float 0.864816
	.float -0.820335
	.float 0.597822
	.float -0.208774
	.float -0.235664
	.float 0.564468
	.float -0.632491
	.float 0.406178
	.float 0.005956
	.float -0.405233
	.float 0.611917
	.float -0.565258
	.float 0.349669
	.float -0.130001
	.float 0.041537
	.float -0.110974
	.float 0.260066
	.float -0.380901
	.float 0.420184
	.float -0.408098
	.float 0.415170
	.float -0.478064
	.float 0.556713
	.float -0.556462
	.float 0.397168
	.float -0.077089
	.float -0.312037
	.float 0.625815
	.float -0.736358
	.float 0.592359
	.float -0.245568
	.float -0.163864
	.float 0.459028
	.float -0.501643
	.float 0.263223
	.float 0.147953
	.float -0.532103
	.float 0.702830
	.float -0.590869
	.float 0.276626
	.float 0.073798
	.float -0.321822
	.float 0.434394
	.float -0.472047
	.float 0.507133
	.float -0.546991
	.float 0.526965
	.float -0.374615
	.float 0.086824
	.float 0.246503
	.float -0.491381
	.float 0.552394
	.float -0.427155
	.float 0.198758
	.float 0.017984
	.float -0.131975
	.float 0.100061
	.float 0.075971
	.float -0.354682
	.float 0.650300
	.float -0.836734
	.float 0.788036
	.float -0.453899
	.float -0.077028
	.float 0.587030
	.float -0.832132
	.float 0.685564
	.float -0.226446
	.float -0.294662
	.float 0.599509
	.float -0.543229
	.float 0.188024
	.float 0.254467
	.float -0.566089
	.float 0.652252
	.float -0.577946
	.float 0.496090
	.float -0.523519
	.float 0.648169
	.float -0.727190
	.float 0.579034
	.float -0.114173
	.float -0.577341
	.float 1.242715
	.float -1.587144
	.float 1.433307
	.float -0.826320
	.float 0.020927
	.float 0.643686
	.float -0.911564
	.float 0.728424
	.float -0.248841
	.float -0.265264
	.float 0.591340
	.float -0.650422
	.float 0.512274
	.float -0.311760
	.float 0.145275
	.float -0.022621
	.float -0.101573
	.float 0.256550
	.float -0.410044
	.float 0.484162
	.float -0.413945
	.float 0.198390
	.float 0.091928
	.float -0.350366
	.float 0.484630
	.float -0.454039
	.float 0.281752
	.float -0.043651
	.float -0.160602
	.float 0.247576
	.float -0.189026
	.float 0.031234
	.float 0.121918
	.float -0.160957
	.float 0.033306
	.float 0.220755
	.float -0.484267
	.float 0.626924
	.float -0.580369
	.float 0.379867
	.float -0.143963
	.float 0.001853
	.float -0.012014
	.float 0.124643
	.float -0.213517
	.float 0.156830
	.float 0.087664
	.float -0.461010
	.float 0.841965
	.float -1.111846
	.float 1.201999
	.float -1.106392
	.float 0.871131
	.float -0.577978
	.float 0.322543
	.float -0.179228
	.float 0.159486
	.float -0.193982
	.float 0.168202
	.float -0.002706
	.float -0.275154
	.float 0.529176
	.float -0.596204
	.float 0.399720
	.float -0.012351
	.float -0.379643
	.float 0.583421
	.float -0.502468
	.float 0.173073
	.float 0.269266
	.float -0.651647
	.float 0.815087
	.float -0.651939
	.float 0.146515
	.float 0.585969
	.float -1.301756
	.float 1.710530
	.float -1.621321
	.float 1.070444
	.float -0.335467
	.float -0.197865
	.float 0.248138
	.float 0.200763
	.float -0.895208
	.float 1.468546
	.float -1.656685
	.float 1.433379
	.float -0.984046
	.float 0.549914
	.float -0.261890
	.float 0.082302
	.float 0.114978
	.float -0.402643
	.float 0.716105
	.float -0.894111
	.float 0.804011
	.float -0.443994
	.float -0.060199
	.float 0.551273
	.float -0.937918
	.float 1.210833
	.float -1.377856
	.float 1.397482
	.float -1.189210
	.float 0.721008
	.float -0.093434
	.float -0.467400
	.float 0.723169
	.float -0.568840
	.float 0.107172
	.float 0.401210
	.float -0.680277
	.float 0.585373
	.float -0.171671
	.float -0.346274
	.float 0.715473
	.float -0.780305
	.float 0.563914
	.float -0.251622
	.float 0.080348
	.float -0.190749
	.float 0.528136
	.float -0.860747
	.float 0.916420
	.float -0.560152
	.float -0.101873
	.float 0.768001
	.float -1.116889
	.float 1.002728
	.float -0.540606
	.float 0.024456
	.float 0.264831
	.float -0.227902
	.float -0.019195
	.float 0.254432
	.float -0.309829
	.float 0.165590
	.float 0.073030
	.float -0.274699
	.float 0.370624
	.float -0.375277
	.float 0.344465
	.float -0.319548
	.float 0.301731
	.float -0.267739
	.float 0.204799
	.float -0.133848
	.float 0.100682
	.float -0.139376
	.float 0.233551
	.float -0.307316
	.float 0.261345
	.float -0.038250
	.float -0.324269
	.float 0.692798
	.float -0.899079
	.float 0.829485
	.float -0.488168
	.float -0.006553
	.float 0.488204
	.float -0.825044
	.float 0.966497
	.float -0.932240
	.float 0.768505
	.float -0.514977
	.float 0.206209
	.float 0.108126
	.float -0.357567
	.float 0.476753
	.float -0.443741
	.float 0.295385
	.float -0.103523
	.float -0.068001
	.float 0.187888
	.float -0.244348
	.float 0.214863
	.float -0.060907
	.float -0.232150
	.float 0.598460
	.float -0.879933
	.float 0.897461
	.float -0.575257
	.float 0.027946
	.float 0.471916
	.float -0.646944
	.float 0.393344
	.float 0.142319
	.float -0.648005
	.float 0.836868
	.float -0.613199
	.float 0.108153
	.float 0.420547
	.float -0.739970
	.float 0.744438
	.float -0.468264
	.float 0.036653
	.float 0.393684
	.float -0.679299
	.float 0.725076
	.float -0.515874
	.float 0.128204
	.float 0.299591
	.float -0.633734
	.float 0.806050
	.float -0.825417
	.float 0.735791
	.float -0.564152
	.float 0.309063
	.float 0.022513
	.float -0.371992
	.float 0.629940
	.float -0.690405
	.float 0.518244
	.float -0.177053
	.float -0.201355
	.float 0.481492
	.float -0.581916
	.float 0.500746
	.float -0.307575
	.float 0.110659
	.float -0.009833
	.float 0.049651
	.float -0.196147
	.float 0.355218
	.float -0.427024
	.float 0.363283
	.float -0.191326
	.float -0.006235
	.float 0.136308
	.float -0.135759
	.float -0.006783
	.float 0.245616
	.float -0.486448
	.float 0.614015
	.float -0.539921
	.float 0.252288
	.float 0.167200
	.float -0.580417
	.float 0.867227
	.float -0.986619
	.float 0.977901
	.float -0.899950
	.float 0.758616
	.float -0.489542
	.float 0.025487
	.float 0.593888
	.float -1.163041
	.float 1.378646
	.float -1.024107
	.float 0.157319
	.float 0.846021
	.float -1.464543
	.float 1.338758
	.float -0.517770
	.float -0.535399
	.float 1.206056
	.float -1.096714
	.float 0.259094
	.float 0.862285
	.float -1.727185
	.float 2.026507
	.float -1.821755
	.float 1.424443
	.float -1.128829
	.float 1.000749
	.float -0.865674
	.float 0.484529
	.float 0.224767
	.float -1.082986
	.float 1.734356
	.float -1.860668
	.float 1.383748
	.float -0.527486
	.float -0.297695
	.float 0.717548
	.float -0.591963
	.float 0.074411
	.float 0.495458
	.float -0.794638
	.float 0.689651
	.float -0.281890
	.float -0.184008
	.float 0.471653
	.float -0.463973
	.float 0.182596
	.float 0.262884
	.float -0.737404
	.float 1.115777
	.float -1.296382
	.float 1.218612
	.float -0.891267
	.float 0.408437
	.float 0.075222
	.float -0.409242
	.float 0.515728
	.float -0.416732
	.float 0.205662
	.float 0.011587
	.float -0.162215
	.float 0.215066
	.float -0.165594
	.float 0.027317
	.float 0.157987
	.float -0.312851
	.float 0.349153
	.float -0.225664
	.float -0.004432
	.float 0.206237
	.float -0.244998
	.float 0.085047
	.float 0.170890
	.float -0.341586
	.float 0.292040
	.float -0.036896
	.float -0.254084
	.float 0.357659
	.float -0.141082
	.float -0.346110
	.float 0.890966
	.float -1.232895
	.float 1.204393
	.float -0.817161
	.float 0.254007
	.float 0.220630
	.float -0.384466
	.float 0.161691
	.float 0.335908
	.float -0.853675
	.float 1.114934
	.float -0.965952
	.float 0.465704
	.float 0.141280
	.float -0.564396
	.float 0.635564
	.float -0.397395
	.float 0.052718
	.float 0.183098
	.float -0.216561
	.float 0.104524
	.float 0.027496
	.float -0.094821
	.float 0.097947
	.float -0.076742
	.float 0.032878
	.float 0.096939
	.float -0.387270
	.float 0.837160
	.float -1.330270
	.float 1.680931
	.float -1.734055
	.float 1.445852
	.float -0.895664
	.float 0.236220
	.float 0.371417
	.float -0.802596
	.float 0.992645
	.float -0.953756
	.float 0.780343
	.float -0.616963
	.float 0.579481
	.float -0.672537
	.float 0.775607
	.float -0.730471
	.float 0.474827
	.float -0.113104
	.float -0.142861
	.float 0.121538
	.float 0.190152
	.float -0.648571
	.float 1.060138
	.float -1.295666
	.float 1.327256
	.float -1.186638
	.float 0.911454
	.float -0.535370
	.float 0.112888
	.float 0.273400
	.float -0.550668
	.float 0.704902
	.float -0.781717
	.float 0.824818
	.float -0.810509
	.float 0.655164
	.float -0.306848
	.float -0.159010
	.float 0.543012
	.float -0.645394
	.float 0.416067
	.float -0.000561
	.float -0.363412
	.float 0.513457
	.float -0.455451
	.float 0.315676
	.float -0.213297
	.float 0.174481
	.float -0.152540
	.float 0.109288
	.float -0.061208
	.float 0.044211
	.float -0.044246
	.float -0.019322
	.float 0.223260
	.float -0.540466
	.float 0.808920
	.float -0.818109
	.float 0.461919
	.float 0.156809
	.float -0.757045
	.float 1.035081
	.float -0.841374
	.float 0.259239
	.float 0.462530
	.float -1.067345
	.float 1.425797
	.float -1.562907
	.float 1.580468
	.float -1.551918
	.float 1.474942
	.float -1.306676
	.float 1.034127
	.float -0.708249
	.float 0.408971
	.float -0.175059
	.float -0.035027
	.float 0.310979
	.float -0.708532
	.float 1.181520
	.float -1.582301
	.float 1.733444
	.float -1.524370
	.float 0.975615
	.float -0.239826
	.float -0.454575
	.float 0.888859
	.float -0.937691
	.float 0.623416
	.float -0.116785
	.float -0.328117
	.float 0.488761
	.float -0.287689
	.float -0.161743
	.float 0.614579
	.float -0.832081
	.float 0.714725
	.float -0.345073
	.float -0.085067
	.float 0.405967
	.float -0.563437
	.float 0.613020
	.float -0.635165
	.float 0.652532
	.float -0.619890
	.float 0.487804
	.float -0.273749
	.float 0.070915
	.float 0.017567
	.float 0.038300
	.float -0.168100
	.float 0.255381
	.float -0.229167
	.float 0.118074
	.float -0.024960
	.float 0.046302
	.float -0.202016
	.float 0.428407
	.float -0.631195
	.float 0.748583
	.float -0.772713
	.float 0.720448
	.float -0.591525
	.float 0.362091
	.float -0.024843
	.float -0.362148
	.float 0.672078
	.float -0.771438
	.float 0.608928
	.float -0.262960
	.float -0.093550
	.float 0.289234
	.float -0.243699
	.float -0.007063
	.float 0.352315
	.float -0.670448
	.float 0.867862
	.float -0.884964
	.float 0.696360
	.float -0.327822
	.float -0.123536
	.float 0.503926
	.float -0.670200
	.float 0.574837
	.float -0.302288
	.float 0.017522
	.float 0.141910
	.float -0.147807
	.float 0.073994
	.float -0.013877
	.float 0.001322
	.float -0.004996
	.float -0.009954
	.float 0.026152
	.float 0.010246
	.float -0.115177
	.float 0.214633
	.float -0.183674
	.float -0.042166
	.float 0.380183
	.float -0.627803
	.float 0.600550
	.float -0.280470
	.float -0.143763
	.float 0.385485
	.float -0.248332
	.float -0.235391
	.float 0.813230
	.float -1.165643
	.float 1.104487
	.float -0.687269
	.float 0.173081
	.float 0.148283
	.float -0.138511
	.float -0.118008
	.float 0.396519
	.float -0.503708
	.float 0.413436
	.float -0.271968
	.float 0.274566
	.float -0.507163
	.float 0.868744
	.float -1.128811
	.float 1.078542
	.float -0.671577
	.float 0.061310
	.float 0.486147
	.float -0.742509
	.float 0.635135
	.float -0.264476
	.float -0.175826
	.float 0.513007
	.float -0.668057
	.float 0.654422
	.float -0.525451
	.float 0.324576
	.float -0.074659
	.float -0.198231
	.float 0.441261
	.float -0.581969
	.float 0.566599
	.float -0.403204
	.float 0.176694
	.float -0.019834
	.float 0.048714
	.float -0.293368
	.float 0.662522
	.float -0.971657
	.float 1.032181
	.float -0.759754
	.float 0.236682
	.float 0.318684
	.float -0.666266
	.float 0.675872
	.float -0.393258
	.float 0.001146
	.float 0.293707
	.float -0.371095
	.float 0.240403
	.float -0.005233
	.float -0.210815
	.float 0.325300
	.float -0.319000
	.float 0.224362
	.float -0.099995
	.float 0.003516
	.float 0.032292
	.float -0.014679
	.float -0.013223
	.float 0.001238
	.float 0.066866
	.float -0.146865
	.float 0.145610
	.float 0.029287
	.float -0.408458
	.float 0.924839
	.float -1.427114
	.float 1.740498
	.float -1.747219
	.float 1.445775
	.float -0.954084
	.float 0.448638
	.float -0.069172
	.float -0.153140
	.float 0.294384
	.float -0.459299
	.float 0.679893
	.float -0.869564
	.float 0.876460
	.float -0.605584
	.float 0.121939
	.float 0.348366
	.float -0.532747
	.float 0.274837
	.float 0.359146
	.float -1.100565
	.float 1.615709
	.float -1.680785
	.float 1.296033
	.float -0.678212
	.float 0.139470
	.float 0.078868
	.float 0.073101
	.float -0.443106
	.float 0.777577
	.float -0.870455
	.float 0.668105
	.float -0.270481
	.float -0.158876
	.float 0.498936
	.float -0.716728
	.float 0.834460
	.float -0.869436
	.float 0.813680
	.float -0.670290
	.float 0.496934
	.float -0.392775
	.float 0.420935
	.float -0.532726
	.float 0.575555
	.float -0.400483
	.float -0.006920
	.float 0.482425
	.float -0.774335
	.float 0.711033
	.float -0.321774
	.float -0.179431
	.float 0.534639
	.float -0.604973
	.float 0.442543
	.float -0.229181
	.float 0.136609
	.float -0.211356
	.float 0.360631
	.float -0.435995
	.float 0.343353
	.float -0.098563
	.float -0.200525
	.float 0.448733
	.float -0.590234
	.float 0.621538
	.float -0.558143
	.float 0.409195
	.float -0.184612
	.float -0.083349
	.float 0.339937
	.float -0.539593
	.float 0.680059
	.float -0.799403
	.float 0.930490
	.float -1.053634
	.float 1.096979
	.float -0.993047
	.float 0.745376
	.float -0.444653
	.float 0.215319
	.float -0.134077
	.float 0.186983
	.float -0.298142
	.float 0.400745
	.float -0.485056
	.float 0.580506
	.float -0.690521
	.float 0.746229
	.float -0.635272
	.float 0.297169
	.float 0.190066
	.float -0.615452
	.float 0.750363
	.float -0.500152
	.float -0.020325
	.float 0.548251
	.float -0.829309
	.float 0.756920
	.float -0.402429
	.float -0.066435
	.float 0.501163
	.float -0.835196
	.float 1.066117
	.float -1.198020
	.float 1.206440
	.float -1.055748
	.float 0.747356
	.float -0.351585
	.float -0.009124
	.float 0.217764
	.float -0.223522
	.float 0.065681
	.float 0.152729
	.float -0.323521
	.float 0.388340
	.float -0.361337
	.float 0.311063
	.float -0.313882
	.float 0.403874
	.float -0.546397
	.float 0.654740
	.float -0.647850
	.float 0.517007
	.float -0.352092
	.float 0.295012
	.float -0.439282
	.float 0.744414
	.float -1.036899
	.float 1.111652
	.float -0.870431
	.float 0.398232
	.float 0.080968
	.float -0.341255
	.float 0.291388
	.float -0.021371
	.float -0.264450
	.float 0.376338
	.float -0.246418
	.float -0.043998
	.float 0.321476
	.float -0.420640
	.float 0.271925
	.float 0.063934
	.float -0.426109
	.float 0.631764
	.float -0.563905
	.float 0.226765
	.float 0.257089
	.float -0.703584
	.float 0.945902
	.float -0.896707
	.float 0.571514
	.float -0.074102
	.float -0.441619
	.float 0.819542
	.float -0.949294
	.float 0.803156
	.float -0.446814
	.float 0.013441
	.float 0.353510
	.float -0.564107
	.float 0.620245
	.float -0.605750
	.float 0.630837
	.float -0.759003
	.float 0.959988
	.float -1.122486
	.float 1.126191
	.float -0.928955
	.float 0.606910
	.float -0.311066
	.float 0.165709
	.float -0.182336
	.float 0.256508
	.float -0.251878
	.float 0.105457
	.float 0.129072
	.float -0.331825
	.float 0.415591
	.float -0.390373
	.float 0.342951
	.float -0.352977
	.float 0.417892
	.float -0.449091
	.float 0.344524
	.float -0.084223
	.float -0.223595
	.float 0.387222
	.float -0.249470
	.float -0.191158
	.float 0.740277
	.float -1.093033
	.float 1.011172
	.float -0.485948
	.float -0.228237
	.float 0.751486
	.float -0.811597
	.float 0.420291
	.float 0.134449
	.float -0.483632
	.float 0.430293
	.float -0.083213
	.float -0.226027
	.float 0.186309
	.float 0.262136
	.float -0.876663
	.float 1.279000
	.float -1.219244
	.float 0.744008
	.float -0.148546
	.float -0.245280
	.float 0.313825
	.float -0.191454
	.float 0.130375
	.float -0.280944
	.float 0.568238
	.float -0.757510
	.float 0.649063
	.float -0.244747
	.float -0.244051
	.float 0.550004
	.float -0.544353
	.float 0.324123
	.float -0.128677
	.float 0.152991
	.float -0.401004
	.float 0.689779
	.float -0.797576
	.float 0.638121
	.float -0.323840
	.float 0.069487
	.float -0.015664
	.float 0.115259
	.float -0.173864
	.float 0.010077
	.float 0.395052
	.float -0.877912
	.float 1.213757
	.float -1.279736
	.float 1.132638
	.float -0.947932
	.float 0.876115
	.float -0.931194
	.float 0.993164
	.float -0.914417
	.float 0.641436
	.float -0.256756
	.float -0.087100
	.float 0.283605
	.float -0.342611
	.float 0.362175
	.float -0.433000
	.float 0.561404
	.float -0.673812
	.float 0.689946
	.float -0.593900
	.float 0.444295
	.float -0.325995
	.float 0.294232
	.float -0.354241
	.float 0.474991
	.float -0.607604
	.float 0.692014
	.float -0.665706
	.float 0.491631
	.float -0.194405
	.float -0.132894
	.float 0.375682
	.float -0.475239
	.float 0.474526
	.float -0.484028
	.float 0.581606
	.float -0.722370
	.float 0.740569
	.float -0.461630
	.float -0.146759
	.float 0.899690
	.float -1.468107
	.float 1.565953
	.float -1.129136
	.float 0.361787
	.float 0.383580
	.float -0.808807
	.float 0.820469
	.float -0.539477
	.float 0.187641
	.float 0.052701
	.float -0.112359
	.float 0.018670
	.float 0.165486
	.float -0.385306
	.float 0.597915
	.float -0.758881
	.float 0.824064
	.float -0.771059
	.float 0.616155
	.float -0.404417
	.float 0.179743
	.float 0.035119
	.float -0.228192
	.float 0.370824
	.float -0.409966
	.float 0.302449
	.float -0.069583
	.float -0.181194
	.float 0.304571
	.float -0.215291
	.float -0.036423
	.float 0.278766
	.float -0.324528
	.float 0.097911
	.float 0.310845
	.float -0.703960
	.float 0.905019
	.float -0.865910
	.float 0.680203
	.float -0.502599
	.float 0.439726
	.float -0.490061
	.float 0.567723
	.float -0.581451
	.float 0.502975
	.float -0.373283
	.float 0.248463
	.float -0.136624
	.float -0.015087
	.float 0.267204
	.float -0.611434
	.float 0.941873
	.float -1.111304
	.float 1.040833
	.float -0.797928
	.float 0.570915
	.float -0.543104
	.float 0.752473
	.float -1.045668
	.float 1.173360
	.float -0.967630
	.float 0.473734
	.float 0.066213
	.float -0.373730
	.float 0.324919
	.float -0.031691
	.float -0.247970
	.float 0.303301
	.float -0.121344
	.float -0.118774
	.float 0.199139
	.float -0.039914
	.float -0.241879
	.float 0.436671
	.float -0.422246
	.float 0.270990
	.float -0.196646
	.float 0.382862
	.float -0.829041
	.float 1.332323
	.float -1.616767
	.float 1.512543
	.float -1.061145
	.float 0.484627
	.float -0.051708
	.float -0.068607
	.float -0.117445
	.float 0.454015
	.float -0.735580
	.float 0.819703
	.float -0.691066
	.float 0.444740
	.float -0.205116
	.float 0.036617
	.float 0.089911
	.float -0.251240
	.float 0.483030
	.float -0.723255
	.float 0.842200
	.float -0.743666
	.float 0.458372
	.float -0.146618
	.float -0.005274
	.float -0.076549
	.float 0.287380
	.float -0.409597
	.float 0.269584
	.float 0.127662
	.float -0.588550
	.float 0.858098
	.float -0.794840
	.float 0.467469
	.float -0.104028
	.float -0.067218
	.float -0.032096
	.float 0.294971
	.float -0.523683
	.float 0.573475
	.float -0.437434
	.float 0.222476
	.float -0.055473
	.float 0.001443
	.float -0.047650
	.float 0.142321
	.float -0.238497
	.float 0.306643
	.float -0.320302
	.float 0.244613
	.float -0.049413
	.float -0.258300
	.float 0.608811
	.float -0.878425
	.float 0.942213
	.float -0.751811
	.float 0.392036
	.float -0.065691
	.float -0.008689
	.float -0.261624
	.float 0.756911
	.float -1.188936
	.float 1.265841
	.float -0.874455
	.float 0.153300
	.float 0.596374
	.float -1.096583
	.float 1.242230
	.float -1.117449
	.float 0.888561
	.float -0.671246
	.float 0.473024
	.float -0.236842
	.float -0.070071
	.float 0.402921
	.float -0.661277
	.float 0.761471
	.float -0.700306
	.float 0.563496
	.float -0.474485
	.float 0.518795
	.float -0.690405
	.float 0.891434
	.float -0.983459
	.float 0.860744
	.float -0.505842
	.float 0.001439
	.float 0.502710
	.float -0.848051
	.float 0.924619
	.float -0.708365
	.float 0.268152
	.float 0.258955
	.float -0.717348
	.float 0.989525
	.float -1.035701
	.float 0.896841
	.float -0.660111
	.float 0.408005
	.float -0.181530
	.float -0.022892
	.float 0.227326
	.float -0.440874
	.float 0.647143
	.float -0.816276
	.float 0.925352
	.float -0.966727
	.float 0.939301
	.float -0.839673
	.float 0.672778
	.float -0.479614
	.float 0.351710
	.float -0.400602
	.float 0.685654
	.float -1.148047
	.float 1.610034
	.float -1.857965
	.float 1.762601
	.float -1.356638
	.float 0.815543
	.float -0.355329
	.float 0.117126
	.float -0.110735
	.float 0.242131
	.float -0.391365
	.float 0.480767
	.float -0.492874
	.float 0.441771
	.float -0.335818
	.float 0.168065
	.float 0.061005
	.float -0.316845
	.float 0.534496
	.float -0.657611
	.float 0.681654
	.float -0.660236
	.float 0.661810
	.float -0.708052
	.float 0.744476
	.float -0.672048
	.float 0.420544
	.float -0.011319
	.float -0.437318
	.float 0.768514
	.float -0.871421
	.float 0.737752
	.float -0.457314
	.float 0.161120
	.float 0.046650
	.float -0.127072
	.float 0.101825
	.float -0.022713
	.float -0.058883
	.float 0.110805
	.float -0.130405
	.float 0.147075
	.float -0.206727
	.float 0.332954
	.float -0.486615
	.float 0.567085
	.float -0.476994
	.float 0.214114
	.float 0.089358
	.float -0.233273
	.float 0.088688
	.float 0.296904
	.float -0.720349
	.float 0.962790
	.float -0.941563
	.float 0.754264
	.float -0.584741
	.float 0.554194
	.float -0.640461
	.float 0.724472
	.float -0.712126
	.float 0.620745
	.float -0.557306
	.float 0.614203
	.float -0.778090
	.float 0.930547
	.float -0.936732
	.float 0.744301
	.float -0.413656
	.float 0.065651
	.float 0.199211
	.float -0.343624
	.float 0.378585
	.float -0.324746
	.float 0.196423
	.float -0.019139
	.float -0.149136
	.float 0.229253
	.float -0.165955
	.float -0.029778
	.float 0.282195
	.float -0.499831
	.float 0.632146
	.float -0.684348
	.float 0.679186
	.float -0.606615
	.float 0.418458
	.float -0.084862
	.float -0.335702
	.float 0.687892
	.float -0.804837
	.float 0.635540
	.float -0.310911
	.float 0.077829
	.float -0.130298
	.float 0.455231
	.float -0.813811
	.float 0.887685
	.float -0.498740
	.float -0.248934
	.float 1.008287
	.float -1.389796
	.float 1.192313
	.float -0.514566
	.float -0.318183
	.float 0.952042
	.float -1.190915
	.float 1.059768
	.float -0.731061
	.float 0.393613
	.float -0.162610
	.float 0.073560
	.float -0.125353
	.float 0.308350
	.float -0.588258
	.float 0.877435
	.float -1.048344
	.float 1.005193
	.float -0.764243
	.float 0.465648
	.float -0.286417
	.float 0.309557
	.float -0.454453
	.float 0.533799
	.float -0.399478
	.float 0.060673
	.float 0.325002
	.float -0.580002
	.float 0.644807
	.float -0.606913
	.float 0.600180
	.float -0.669845
	.float 0.728677
	.float -0.644097
	.float 0.373483
	.float -0.019117
	.float -0.250317
	.float 0.338164
	.float -0.287081
	.float 0.212169
	.float -0.167897
	.float 0.085066
	.float 0.151311
	.float -0.550609
	.float 0.941172
	.float -1.062051
	.float 0.762529
	.float -0.145081
	.float -0.476586
	.float 0.782212
	.float -0.656842
	.float 0.249517
	.float 0.155616
	.float -0.344691
	.float 0.295568
	.float -0.136616
	.float 0.000079
	.float 0.095419
	.float -0.237689
	.float 0.508492
	.float -0.874389
	.float 1.182450
	.float -1.268380
	.float 1.088002
	.float -0.763361
	.float 0.504400
	.float -0.464840
	.float 0.639135
	.float -0.872172
	.float 0.968250
	.float -0.817665
	.float 0.454015
	.float -0.011875
	.float -0.371629
	.float 0.632730
	.float -0.782680
	.float 0.849326
	.float -0.823194
	.float 0.663598
	.float -0.361084
	.float -0.004888
	.float 0.275107
	.float -0.293523
	.float 0.007560
	.float 0.486317
	.float -0.982744
	.float 1.266756
	.float -1.215098
	.float 0.851422
	.float -0.334400
	.float -0.116360
	.float 0.327640
	.float -0.262197
	.float 0.035446
	.float 0.162042
	.float -0.192680
	.float 0.060609
	.float 0.107752
	.float -0.177073
	.float 0.116724
	.float -0.019191
	.float 0.009279
	.float -0.124799
	.float 0.273726
	.float -0.305850
	.float 0.139373
	.float 0.161277
	.float -0.417713
	.float 0.453463
	.float -0.206922
	.float -0.234423
	.float 0.691418
	.float -0.993444
	.float 1.055885
	.float -0.899505
	.float 0.619860
	.float -0.337872
	.float 0.157089
	.float -0.135402
	.float 0.270454
	.float -0.501646
	.float 0.733377
	.float -0.875048
	.float 0.878693
	.float -0.752202
	.float 0.541268
	.float -0.294908
	.float 0.040890
	.float 0.211533
	.float -0.445449
	.float 0.609929
	.float -0.621526
	.float 0.406885
	.float 0.030291
	.float -0.563446
	.float 0.966766
	.float -1.019219
	.float 0.639194
	.float 0.039313
	.float -0.716642
	.float 1.089901
	.float -1.031475
	.float 0.663998
	.float -0.276973
	.float 0.137029
	.float -0.317900
	.float 0.661435
	.float -0.890305
	.float 0.791851
	.float -0.351454
	.float -0.243595
	.float 0.719950
	.float -0.871760
	.float 0.659634
	.float -0.208807
	.float -0.274301
	.float 0.607825
	.float -0.704613
	.float 0.581421
	.float -0.321089
	.float 0.022406
	.float 0.232352
	.float -0.385074
	.float 0.397928
	.float -0.255364
	.float -0.024572
	.float 0.382910
	.float -0.731046
	.float 0.980607
	.float -1.074587
	.float 1.001360
	.float -0.788969
	.float 0.492767
	.float -0.189597
	.float -0.025795
	.float 0.058859
	.float 0.144786
	.float -0.555738
	.float 1.049137
	.float -1.447578
	.float 1.603358
	.float -1.472846
	.float 1.135970
	.float -0.749275
	.float 0.463096
	.float -0.353451
	.float 0.403475
	.float -0.534747
	.float 0.659363
	.float -0.719375
	.float 0.697656
	.float -0.606883
	.float 0.473984
	.float -0.330319
	.float 0.204267
	.float -0.108569
	.float 0.026102
	.float 0.089507
	.float -0.283461
	.float 0.550317
	.float -0.803257
	.float 0.902125
	.float -0.741490
	.float 0.345269
	.float 0.109967
	.float -0.383455
	.float 0.327542
	.float -0.005404
	.float -0.329413
	.float 0.396349
	.float -0.089013
	.float -0.432478
	.float 0.834355
	.float -0.830031
	.float 0.374195
	.float 0.306219
	.float -0.861493
	.float 1.037835
	.float -0.814166
	.float 0.377581
	.float 0.022306
	.float -0.226964
	.float 0.233856
	.float -0.153895
	.float 0.113070
	.float -0.169285
	.float 0.287214
	.float -0.371736
	.float 0.332003
	.float -0.139319
	.float -0.151842
	.float 0.431038
	.float -0.593131
	.float 0.597557
	.float -0.488296
	.float 0.361632
	.float -0.302771
	.float 0.331357
	.float -0.389380
	.float 0.378075
	.float -0.223436
	.float -0.066241
	.float 0.386614
	.float -0.584550
	.float 0.549056
	.float -0.291769
	.float -0.043468
	.float 0.262464
	.float -0.245317
	.float 0.023169
	.float 0.253411
	.float -0.429438
	.float 0.449645
	.float -0.370153
	.float 0.281378
	.float -0.223802
	.float 0.174976
	.float -0.107736
	.float 0.045356
	.float -0.045464
	.float 0.123527
	.float -0.197990
	.float 0.128607
	.float 0.166854
	.float -0.613011
	.float 0.989542
	.float -1.065118
	.float 0.761551
	.float -0.225937
	.float -0.249028
	.float 0.406768
	.float -0.186314
	.float -0.250725
	.float 0.642160
	.float -0.805600
	.float 0.745269
	.float -0.609780
	.float 0.541405
	.float -0.543831
	.float 0.480371
	.float -0.207855
	.float -0.264839
	.float 0.731648
	.float -0.909195
	.float 0.639424
	.float -0.022377
	.float -0.625672
	.float 0.963907
	.float -0.834862
	.float 0.346521
	.float 0.218888
	.float -0.595083
	.float 0.685207
	.float -0.580539
	.float 0.449935
	.float -0.396456
	.float 0.392793
	.float -0.337452
	.float 0.175059
	.float 0.026325
	.float -0.110581
	.float -0.044698
	.float 0.419936
	.float -0.849121
	.float 1.124263
	.float -1.127079
	.float 0.889107
	.float -0.544827
	.float 0.226651
	.float 0.013295
	.float -0.203850
	.float 0.394250
	.float -0.591331
	.float 0.744691
	.float -0.786263
	.float 0.687624
	.float -0.487769
	.float 0.267096
	.float -0.084754
	.float -0.071941
	.float 0.279399
	.float -0.604350
	.float 1.012364
	.float -1.333787
	.float 1.334639
	.float -0.867412
	.float 0.007856
	.float 0.926348
	.float -1.512889
	.float 1.453679
	.float -0.759909
	.float -0.227922
	.float 1.010835
	.float -1.200345
	.float 0.727413
	.float 0.133779
	.float -0.938308
	.float 1.328308
	.float -1.215128
	.float 0.781881
	.float -0.325932
	.float 0.062912
	.float -0.023474
	.float 0.091642
	.float -0.128436
	.float 0.076900
	.float 0.018543
	.float -0.067613
	.float 0.004164
	.float 0.179010
	.float -0.435637
	.float 0.686691
	.float -0.839968
	.float 0.814434
	.float -0.578476
	.float 0.186503
	.float 0.222032
	.float -0.481274
	.float 0.490636
	.float -0.278246
	.float -0.013988
	.float 0.219472
	.float -0.250847
	.float 0.146733
	.float -0.030022
	.float 0.009373
	.float -0.095946
	.float 0.195514
	.float -0.182480
	.float 0.002016
	.float 0.274729
	.float -0.485313
	.float 0.479224
	.float -0.218704
	.float -0.190811
	.float 0.560105
	.float -0.724859
	.float 0.635567
	.float -0.377068
	.float 0.111464
	.float 0.018104
	.float 0.033567
	.float -0.196127
	.float 0.335061
	.float -0.339568
	.float 0.192495
	.float 0.020247
	.float -0.166046
	.float 0.151671
	.float 0.015045
	.float -0.227620
	.float 0.349555
	.float -0.309540
	.float 0.162419
	.float -0.067427
	.float 0.183904
	.float -0.544290
	.float 0.994287
	.float -1.258214
	.float 1.105414
	.float -0.512781
	.float -0.292026
	.float 0.947387
	.float -1.163802
	.float 0.883366
	.float -0.290193
	.float -0.323676
	.float 0.733622
	.float -0.878723
	.float 0.831643
	.float -0.692697
	.float 0.505702
	.float -0.256139
	.float -0.067059
	.float 0.415126
	.float -0.681764
	.float 0.758482
	.float -0.593933
	.float 0.215360
	.float 0.289564
	.float -0.804384
	.float 1.209608
	.float -1.407082
	.float 1.352009
	.float -1.080977
	.float 0.707086
	.float -0.367256
	.float 0.148420
	.float -0.045573
	.float -0.013275
	.float 0.093590
	.float -0.191989
	.float 0.236783
	.float -0.151495
	.float -0.069763
	.float 0.336194
	.float -0.506355
	.float 0.475406
	.float -0.242769
	.float -0.086033
	.float 0.364085
	.float -0.489995
	.float 0.459174
	.float -0.346941
	.float 0.240092
	.float -0.169583
	.float 0.097919
	.float 0.027815
	.float -0.201106
	.float 0.327834
	.float -0.282027
	.float 0.013024
	.float 0.382400
	.float -0.695537
	.float 0.740313
	.float -0.490549
	.float 0.107082
	.float 0.179196
	.float -0.244655
	.float 0.168422
	.float -0.161486
	.float 0.376698
	.float -0.750169
	.float 1.009428
	.float -0.859519
	.float 0.218120
	.float 0.675154
	.float -1.366834
	.float 1.455390
	.float -0.844802
	.float -0.178929
	.float 1.100174
	.float -1.463997
	.float 1.129672
	.float -0.337219
	.float -0.449160
	.float 0.821012
	.float -0.655778
	.float 0.157689
	.float 0.305069
	.float -0.447720
	.float 0.230893
	.float 0.162324
	.float -0.494502
	.float 0.646172
	.float -0.664284
	.float 0.670772
	.float -0.728930
	.float 0.788644
	.float -0.749820
	.float 0.575722
	.float -0.347326
	.float 0.209037
	.float -0.255769
	.float 0.461245
	.float -0.705551
	.float 0.868586
	.float -0.902337
	.float 0.824559
	.float -0.658582
	.float 0.396271
	.float -0.032286
	.float -0.363307
	.float 0.620879
	.float -0.550466
	.float 0.086116
	.float 0.616069
	.float -1.220141
	.float 1.387083
	.float -0.975910
	.float 0.133783
	.float 0.785017
	.float -1.414489
	.float 1.557650
	.float -1.247034
	.float 0.670975
	.float -0.040498
	.float -0.507270
	.float 0.921540
	.float -1.190074
	.float 1.291157
	.float -1.188042
	.float 0.863710
	.float -0.360717
	.float -0.207620
	.float 0.684295
	.float -0.919734
	.float 0.824049
	.float -0.402092
	.float -0.238186
	.float 0.908062
	.float -1.389655
	.float 1.507044
	.float -1.194849
	.float 0.535104
	.float 0.261317
	.float -0.930148
	.float 1.259382
	.float -1.178954
	.float 0.789833
	.float -0.314428
	.float -0.011166
	.float 0.050171
	.float 0.175765
	.float -0.513204
	.float 0.772225
	.float -0.833676
	.float 0.706675
	.float -0.507887
	.float 0.381589
	.float -0.409835
	.float 0.561449
	.float -0.705188
	.float 0.681696
	.float -0.401421
	.float -0.082686
	.float 0.576789
	.float -0.837324
	.float 0.710067
	.float -0.233516
	.float -0.368341
	.float 0.809871
	.float -0.909490
	.float 0.690235
	.float -0.351120
	.float 0.133937
	.float -0.177437
	.float 0.451589
	.float -0.803329
	.float 1.068877
	.float -1.170853
	.float 1.137696
	.float -1.044785
	.float 0.932344
	.float -0.769590
	.float 0.494463
	.float -0.094502
	.float -0.343630
	.float 0.666773
	.float -0.753167
	.float 0.600818
	.float -0.335124
	.float 0.128621
	.float -0.095423
	.float 0.237342
	.float -0.469463
	.float 0.689204
	.float -0.831643
	.float 0.883745
	.float -0.870956
	.float 0.840602
	.float -0.846808
	.float 0.927018
	.float -1.072855
	.float 1.219903
	.float -1.277897
	.float 1.188638
	.float -0.965568
	.float 0.678078
	.float -0.392015
	.float 0.122417
	.float 0.151870
	.float -0.419507
	.float 0.579636
	.float -0.467194
	.float -0.031593
	.float 0.848152
	.float -1.695624
	.float 2.187110
	.float -2.057549
	.float 1.348272
	.float -0.415814
	.float -0.264992
	.float 0.389833
	.float -0.015146
	.float -0.484332
	.float 0.669473
	.float -0.332027
	.float -0.369769
	.float 1.026026
	.float -1.256339
	.float 0.959556
	.float -0.362717
	.float -0.154227
	.float 0.325276
	.float -0.168101
	.float -0.054618
	.float 0.044605
	.float 0.303716
	.float -0.814368
	.float 1.139555
	.float -0.993307
	.float 0.351394
	.float 0.517767
	.float -1.213331
	.float 1.444746
	.float -1.191508
	.float 0.675860
	.float -0.182964
	.float -0.127229
	.float 0.277431
	.float -0.377500
	.float 0.479820
	.float -0.521686
	.float 0.402366
	.float -0.117559
	.float -0.180628
	.float 0.266415
	.float -0.010229
	.float -0.500450
	.float 0.993316
	.float -1.183419
	.float 0.961815
	.float -0.463365
	.float -0.031085
	.float 0.279003
	.float -0.210950
	.float -0.069059
	.float 0.391392
	.float -0.636121
	.float 0.771116
	.float -0.809081
	.float 0.749206
	.float -0.567484
	.float 0.261937
	.float 0.099722
	.float -0.386936
	.float 0.476413
	.float -0.336286
	.float 0.057593
	.float 0.196155
	.float -0.287966
	.float 0.184497
	.float 0.041628
	.float -0.277885
	.float 0.448742
	.float -0.545330
	.float 0.595751
	.float -0.616263
	.float 0.593280
	.float -0.509675
	.float 0.382996
	.float -0.272158
	.float 0.240902
	.float -0.308958
	.float 0.434269
	.float -0.543253
	.float 0.585373
	.float -0.569275
	.float 0.554030
	.float -0.604475
	.float 0.744250
	.float -0.938293
	.float 1.111965
	.float -1.189407
	.float 1.125696
	.float -0.919519
	.float 0.610492
	.float -0.272209
	.float 0.002632
	.float 0.098273
	.float 0.028965
	.float -0.356342
	.float 0.753257
	.float -1.032238
	.float 1.044180
	.float -0.766305
	.float 0.320216
	.float 0.097587
	.float -0.326162
	.float 0.314898
	.float -0.117923
	.float -0.171154
	.float 0.481790
	.float -0.779941
	.float 1.040026
	.float -1.221360
	.float 1.283151
	.float -1.224412
	.float 1.102565
	.float -1.001008
	.float 0.966256
	.float -0.969505
	.float 0.930157
	.float -0.784441
	.float 0.541167
	.float -0.278471
	.float 0.088025
	.float -0.015863
	.float 0.044279
	.float -0.117144
	.float 0.177575
	.float -0.189493
	.float 0.142643
	.float -0.055567
	.float -0.021480
	.float 0.019122
	.float 0.113477
	.float -0.365930
	.float 0.655560
	.float -0.866139
	.float 0.912062
	.float -0.779297
	.float 0.515970
	.float -0.189766
	.float -0.144137
	.float 0.438582
	.float -0.630578
	.float 0.638855
	.float -0.404566
	.float -0.049005
	.float 0.590246
	.float -1.021726
	.float 1.174153
	.float -0.992085
	.float 0.553753
	.float -0.015347
	.float -0.476902
	.float 0.846340
	.float -1.085275
	.float 1.211051
	.float -1.224058
	.float 1.104234
	.float -0.846879
	.float 0.506093
	.float -0.204618
	.float 0.088955
	.float -0.246220
	.float 0.631359
	.float -1.059688
	.float 1.286871
	.float -1.141934
	.float 0.636640
	.float 0.022161
	.float -0.533975
	.float 0.664743
	.float -0.371694
	.float -0.179002
	.float 0.706461
	.float -0.960641
	.float 0.837169
	.float -0.408417
	.float -0.129407
	.float 0.553151
	.float -0.706279
	.float 0.556191
	.float -0.200242
	.float -0.181405
	.float 0.412464
	.float -0.410113
	.float 0.226056
	.float -0.004905
	.float -0.121139
	.float 0.129506
	.float -0.120357
	.float 0.228260
	.float -0.496409
	.float 0.814935
	.float -0.980887
	.float 0.845154
	.float -0.439691
	.float -0.014921
	.float 0.238550
	.float -0.073756
	.float -0.405177
	.float 0.934806
	.float -1.227905
	.float 1.145427
	.float -0.757620
	.float 0.263865
	.float 0.154446
	.float -0.432394
	.float 0.608382
	.float -0.732045
	.float 0.785249
	.float -0.685955
	.float 0.368836
	.float 0.127535
	.float -0.642053
	.float 0.963621
	.float -0.950820
	.float 0.619988
	.float -0.141106
	.float -0.259774
	.float 0.431092
	.float -0.375327
	.float 0.227319
	.float -0.150504
	.float 0.227000
	.float -0.416205
	.float 0.602159
	.float -0.684280
	.float 0.641358
	.float -0.529075
	.float 0.425140
	.float -0.369763
	.float 0.342283
	.float -0.283140
	.float 0.141029
	.float 0.083571
	.float -0.321971
	.float 0.458608
	.float -0.386135
	.float 0.071950
	.float 0.400551
	.float -0.849407
	.float 1.073958
	.float -0.958939
	.float 0.540657
	.float 0.010166
	.float -0.482752
	.float 0.739708
	.float -0.778510
	.float 0.705399
	.float -0.645102
	.float 0.651989
	.float -0.684751
	.float 0.660031
	.float -0.542469
	.float 0.398286
	.float -0.363567
	.float 0.542237
	.float -0.909472
	.float 1.301592
	.float -1.512373
	.float 1.430282
	.float -1.113029
	.float 0.740626
	.float -0.482469
	.float 0.382311
	.float -0.348903
	.float 0.255528
	.float -0.066630
	.float -0.110694
	.float 0.095619
	.float 0.221139
	.float -0.758705
	.float 1.246790
	.float -1.364718
	.float 0.944984
	.float -0.112956
	.float -0.742175
	.float 1.172308
	.float -0.941983
	.float 0.195625
	.float 0.602958
	.float -0.943506
	.float 0.591939
	.float 0.249761
	.float -1.063995
	.float 1.348015
	.float -0.935515
	.float 0.091753
	.float 0.675347
	.float -0.947476
	.float 0.640902
	.float -0.013962
	.float -0.534505
	.float 0.713950
	.float -0.477733
	.float -0.005841
	.float 0.484684
	.float -0.757391
	.float 0.748989
	.float -0.520414
	.float 0.227066
	.float -0.042952
	.float 0.072088
	.float -0.286913
	.float 0.536759
	.float -0.634256
	.float 0.470854
	.float -0.083193
	.float -0.376934
	.float 0.745219
	.float -0.941688
	.float 0.992431
	.float -0.968810
	.float 0.903750
	.float -0.758753
	.float 0.469817
	.float -0.031890
	.float -0.454152
	.float 0.819227
	.float -0.926455
	.float 0.759096
	.float -0.429205
	.float 0.104477
	.float 0.085948
	.float -0.097911
	.float -0.046344
	.float 0.301251
	.float -0.615571
	.float 0.918080
	.float -1.109855
	.float 1.099537
	.float -0.868276
	.float 0.508623
	.float -0.190724
	.float 0.067247
	.float -0.180891
	.float 0.440653
	.float -0.682578
	.float 0.772529
	.float -0.683824
	.float 0.504984
	.float -0.378356
	.float 0.409624
	.float -0.601366
	.float 0.849079
	.float -1.002809
	.float 0.959201
	.float -0.727488
	.float 0.427384
	.float -0.218573
	.float 0.205987
	.float -0.378639
	.float 0.615956
	.float -0.753525
	.float 0.669840
	.float -0.351212
	.float -0.092963
	.float 0.470941
	.float -0.590684
	.float 0.351296
	.float 0.197342
	.float -0.859314
	.float 1.367400
	.float -1.498803
	.float 1.178901
	.float -0.521519
	.float -0.217375
	.float 0.752205
	.float -0.892227
	.float 0.615601
	.float -0.058798
	.float -0.566301
	.float 1.077088
	.float -1.389363
	.float 1.519789
	.float -1.533418
	.float 1.479216
	.float -1.359508
	.float 1.150741
	.float -0.852784
	.float 0.519502
	.float -0.237259
	.float 0.062584
	.float 0.028870
	.float -0.131956
	.float 0.338513
	.float -0.655715
	.float 0.984118
	.float -1.177628
	.float 1.138831
	.float -0.872905
	.float 0.461222
	.float 0.012002
	.float -0.505756
	.float 0.998153
	.float -1.424154
	.float 1.652670
	.float -1.548512
	.float 1.080539
	.float -0.382850
	.float -0.294111
	.float 0.715080
	.float -0.778713
	.float 0.544222
	.float -0.165111
	.float -0.204948
	.float 0.469266
	.float -0.594970
	.float 0.596726
	.float -0.522035
	.float 0.435169
	.float -0.387595
	.float 0.383914
	.float -0.373867
	.float 0.289402
	.float -0.106203
	.float -0.120503
	.float 0.280578
	.float -0.280081
	.float 0.105703
	.float 0.165614
	.float -0.414553
	.float 0.544591
	.float -0.518163
	.float 0.351120
	.float -0.090199
	.float -0.195994
	.float 0.411188
	.float -0.440016
	.float 0.197879
	.float 0.292668
	.float -0.857448
	.float 1.217045
	.float -1.127830
	.float 0.544609
	.float 0.306559
	.float -1.017252
	.float 1.218085
	.float -0.804551
	.float 0.016142
	.float 0.698628
	.float -0.957434
	.float 0.681463
	.float -0.132834
	.float -0.275750
	.float 0.267230
	.float 0.116471
	.float -0.556781
	.float 0.687719
	.float -0.347016
	.float -0.319119
	.float 0.955100
	.float -1.219369
	.float 0.982905
	.float -0.386972
	.float -0.258202
	.float 0.656117
	.float -0.674620
	.float 0.384358
	.float 0.017924
	.float -0.336668
	.float 0.471963
	.float -0.434919
	.float 0.298375
	.float -0.134468
	.float -0.017895
	.float 0.150417
	.float -0.268541
	.float 0.379834
	.float -0.487828
	.float 0.584696
	.float -0.645996
	.float 0.640303
	.float -0.556975
	.float 0.431989
	.float -0.342569
	.float 0.360580
	.float -0.491253
	.float 0.644830
	.float -0.672915
	.float 0.458256
	.float -0.004891
	.float -0.532464
	.float 0.909511
	.float -0.918381
	.float 0.508095
	.float 0.174444
	.float -0.852971
	.float 1.262977
	.float -1.283098
	.float 0.981105
	.float -0.555103
	.float 0.214436
	.float -0.076333
	.float 0.133017
	.float -0.293571
	.float 0.459123
	.float -0.578089
	.float 0.652571
	.float -0.706192
	.float 0.748578
	.float -0.767012
	.float 0.745213
	.float -0.681711
	.float 0.582050
	.float -0.431146
	.float 0.183677
	.float 0.196343
	.float -0.664901
	.float 1.062480
	.float -1.173181
	.float 0.865185
	.float -0.217261
	.float -0.479900
	.float 0.878112
	.float -0.790915
	.float 0.323402
	.float 0.189893
	.float -0.403618
	.float 0.185474
	.float 0.312708
	.float -0.781616
	.float 0.978777
	.float -0.882949
	.float 0.671595
	.float -0.554448
	.float 0.602594
	.float -0.705554
	.float 0.679627
	.float -0.430639
	.float 0.039356
	.float 0.292221
	.float -0.383965
	.float 0.199260
	.float 0.138043
	.float -0.429855
	.float 0.522440
	.float -0.379190
	.float 0.075996
	.float 0.257599
	.float -0.504003
	.float 0.596547
	.float -0.527501
	.float 0.338700
	.float -0.105386
	.float -0.087240
	.float 0.176908
	.float -0.156807
	.float 0.084569
	.float -0.052066
	.float 0.127173
	.float -0.306717
	.float 0.517767
	.float -0.669264
	.float 0.714374
	.float -0.673416
	.float 0.600186
	.float -0.523129
	.float 0.415021
	.float -0.220157
	.float -0.081489
	.float 0.427256
	.float -0.685573
	.float 0.728611
	.float -0.516712
	.float 0.135937
	.float 0.239949
	.float -0.441226
	.float 0.390543
	.float -0.134354
	.float -0.196638
	.float 0.466107
	.float -0.597411
	.float 0.590696
	.float -0.494481
	.float 0.362705
	.float -0.228291
	.float 0.103231
	.float 0.006882
	.float -0.091209
	.float 0.133030
	.float -0.117004
	.float 0.037794
	.float 0.093914
	.float -0.248816
	.float 0.383068
	.float -0.452328
	.float 0.433986
	.float -0.345821
	.float 0.245902
	.float -0.206767
	.float 0.274816
	.float -0.438039
	.float 0.623019
	.float -0.726975
	.float 0.671974
	.float -0.455633
	.float 0.170340
	.float 0.027633
	.float 0.005590
	.float -0.313641
	.float 0.792480
	.float -1.222448
	.float 1.374395
	.float -1.134694
	.float 0.574730
	.float 0.081104
	.float -0.574611
	.float 0.753638
	.float -0.652267
	.float 0.462885
	.float -0.413284
	.float 0.619064
	.float -1.004308
	.float 1.348361
	.float -1.435006
	.float 1.202971
	.float -0.785351
	.float 0.404459
	.float -0.202938
	.float 0.150220
	.float -0.103319
	.float -0.031795
	.float 0.185307
	.float -0.166074
	.float -0.165676
	.float 0.743386
	.float -1.298459
	.float 1.534629
	.float -1.340040
	.float 0.869760
	.float -0.433163
	.float 0.271194
	.float -0.389714
	.float 0.566987
	.float -0.523013
	.float 0.125250
	.float 0.512131
	.float -1.097710
	.float 1.347696
	.float -1.160165
	.float 0.666990
	.float -0.135977
	.float -0.205654
	.float 0.308088
	.float -0.308717
	.float 0.415242
	.float -0.746378
	.float 1.238170
	.float -1.675673
	.float 1.824798
	.float -1.577789
	.float 1.022524
	.float -0.395544
	.float -0.051676
	.float 0.195515
	.float -0.108728
	.float 0.011249
	.float -0.126561
	.float 0.526768
	.float -1.064987
	.float 1.447003
	.float -1.407959
	.float 0.886752
	.float -0.083960
	.float -0.641763
	.float 0.979358
	.float -0.844802
	.float 0.419599
	.float -0.024861
	.float -0.085804
	.float -0.120933
	.float 0.455371
	.float -0.645176
	.float 0.517666
	.float -0.102240
	.float -0.404721
	.float 0.771930
	.float -0.861522
	.float 0.672903
	.float -0.297177
	.float -0.156068
	.float 0.594395
	.float -0.930982
	.float 1.072554
	.float -0.953386
	.float 0.603035
	.float -0.179388
	.float -0.092401
	.float 0.056950
	.float 0.255301
	.float -0.630932
	.float 0.806306
	.float -0.636816
	.float 0.179102
	.float 0.366723
	.float -0.797466
	.float 1.017779
	.float -1.050460
	.float 0.967356
	.float -0.820502
	.float 0.631013
	.float -0.424967
	.float 0.259557
	.float -0.201311
	.float 0.275473
	.float -0.438430
	.float 0.603536
	.float -0.697820
	.float 0.699874
	.float -0.631016
	.float 0.520163
	.float -0.384457
	.float 0.243632
	.float -0.142331
	.float 0.141261
	.float -0.269827
	.float 0.480797
	.float -0.658466
	.float 0.689624
	.float -0.547587
	.float 0.318433
	.float -0.141698
	.float 0.108603
	.float -0.197935
	.float 0.299799
	.float -0.306285
	.float 0.196430
	.float -0.051603
	.float -0.005523
	.float -0.102212
	.float 0.357111
	.float -0.664072
	.float 0.913615
	.float -1.041572
	.float 1.046905
	.float -0.965332
	.float 0.828645
	.float -0.644908
	.float 0.412300
	.float -0.148760
	.float -0.093780
	.float 0.247661
	.float -0.269971
	.float 0.175756
	.float -0.038300
	.float -0.046347
	.float 0.011751
	.float 0.139493
	.float -0.331583
	.float 0.451699
	.float -0.409019
	.float 0.186042
	.float 0.147044
	.float -0.464101
	.float 0.644315
	.float -0.628962
	.float 0.445148
	.float -0.187609
	.float -0.028076
	.float 0.117112
	.float -0.059935
	.float -0.093498
	.float 0.251884
	.float -0.332596
	.float 0.310738
	.float -0.238502
	.float 0.217012
	.float -0.329658
	.float 0.575171
	.float -0.847383
	.float 0.983215
	.float -0.854891
	.float 0.448561
	.float 0.121661
	.float -0.671055
	.float 1.032291
	.float -1.118218
	.float 0.931563
	.float -0.534997
	.float 0.016319
	.float 0.528208
	.float -0.997560
	.float 1.294585
	.float -1.348901
	.float 1.143957
	.float -0.731160
	.float 0.222488
	.float 0.234115
	.float -0.490326
	.float 0.443336
	.float -0.087539
	.float -0.450617
	.float 0.933474
	.float -1.109870
	.float 0.856816
	.float -0.278703
	.float -0.320377
	.float 0.600219
	.float -0.392581
	.float -0.184795
	.float 0.792775
	.float -1.078590
	.float 0.891658
	.float -0.367557
	.float -0.170034
	.float 0.419394
	.float -0.285533
	.float -0.074787
	.float 0.368568
	.float -0.361877
	.float 0.027602
	.float 0.447756
	.float -0.797460
	.float 0.854092
	.float -0.652135
	.float 0.386385
	.float -0.263234
	.float 0.356589
	.float -0.571508
	.float 0.732772
	.float -0.721256
	.float 0.551333
	.float -0.337750
	.float 0.191116
	.float -0.133482
	.float 0.100760
	.float -0.020266
	.float -0.110220
	.float 0.212712
	.float -0.196796
	.float 0.045362
	.float 0.156907
	.float -0.279767
	.float 0.245301
	.float -0.089101
	.float -0.066183
	.float 0.106616
	.float -0.018100
	.float -0.099877
	.float 0.111920
	.float 0.042397
	.float -0.292237
	.float 0.480326
	.float -0.476043
	.float 0.267466
	.float 0.038760
	.float -0.303746
	.float 0.453076
	.float -0.506319
	.float 0.527063
	.float -0.550350
	.float 0.554454
	.float -0.491745
	.float 0.336695
	.float -0.102712
	.float -0.177327
	.float 0.471471
	.float -0.741389
	.float 0.922324
	.float -0.932410
	.float 0.727225
	.float -0.359755
	.float -0.019123
	.float 0.242438
	.float -0.236658
	.float 0.068406
	.float 0.116297
	.float -0.211929
	.float 0.230169
	.float -0.269737
	.float 0.411203
	.float -0.632897
	.float 0.818556
	.float -0.842745
	.float 0.658198
	.float -0.321148
	.float -0.048441
	.float 0.329080
	.float -0.443449
	.float 0.378552
	.float -0.186632
	.float -0.034900
	.float 0.189858
	.float -0.241721
	.float 0.243057
	.float -0.300854
	.float 0.489682
	.float -0.775479
	.float 1.016128
	.float -1.049015
	.float 0.804122
	.float -0.356813
	.float -0.119902
	.float 0.464739
	.float -0.615523
	.float 0.614713
	.float -0.542809
	.float 0.443619
	.float -0.302211
	.float 0.084996
	.float 0.200063
	.float -0.477742
	.float 0.636300
	.float -0.592952
	.float 0.348453
	.float 0.006047
	.float -0.335112
	.float 0.530783
	.float -0.567323
	.float 0.505148
	.float -0.441857
	.float 0.442728
	.float -0.497977
	.float 0.536392
	.float -0.483381
	.float 0.318797
	.float -0.090035
	.float -0.127046
	.float 0.284581
	.float -0.387944
	.float 0.469767
	.float -0.538374
	.float 0.550338
	.float -0.436701
	.float 0.164894
	.float 0.215338
	.float -0.582548
	.float 0.805996
	.float -0.813474
	.float 0.617976
	.float -0.294293
	.float -0.063946
	.float 0.369873
	.float -0.544877
	.float 0.521180
	.float -0.269659
	.float -0.156295
	.float 0.605494
	.float -0.879584
	.float 0.838066
	.float -0.491470
	.float 0.007104
	.float 0.392474
	.float -0.577084
	.float 0.597030
	.float -0.640121
	.float 0.879739
	.float -1.321149
	.float 1.763558
	.float -1.917622
	.float 1.605307
	.float -0.902033
	.float 0.112808
	.float 0.412062
	.float -0.499753
	.float 0.260543
	.float 0.000308
	.float -0.002730
	.float -0.313787
	.float 0.758592
	.float -1.037474
	.float 0.964641
	.float -0.583793
	.float 0.119072
	.float 0.193622
	.float -0.261680
	.float 0.166991
	.float -0.066193
	.float 0.052666
	.float -0.093591
	.float 0.085478
	.float 0.028234
	.float -0.183966
	.float 0.235883
	.float -0.076959
	.float -0.256931
	.float 0.589113
	.float -0.715029
	.float 0.542159
	.float -0.151910
	.float -0.260258
	.float 0.517093
	.float -0.565195
	.float 0.481930
	.float -0.389860
	.float 0.350917
	.float -0.321095
	.float 0.196385
	.float 0.086565
	.float -0.470610
	.float 0.781732
	.float -0.822329
	.float 0.498922
	.float 0.100423
	.float -0.736432
	.float 1.144497
	.float -1.177553
	.float 0.874759
	.float -0.416890
	.float 0.008950
	.float 0.224910
	.float -0.271494
	.float 0.186376
	.float -0.033402
	.float -0.142627
	.float 0.303418
	.float -0.397961
	.float 0.371256
	.float -0.199713
	.float -0.080380
	.float 0.384612
	.float -0.630324
	.float 0.785291
	.float -0.872267
	.float 0.924094
	.float -0.930613
	.float 0.831938
	.float -0.574432
	.float 0.186338
	.float 0.197824
	.float -0.400846
	.float 0.318612
	.float -0.002565
	.float -0.359623
	.float 0.558760
	.float -0.495273
	.float 0.232978
	.float 0.061189
	.float -0.244282
	.float 0.294561
	.float -0.306064
	.float 0.388200
	.float -0.554701
	.float 0.698708
	.float -0.682351
	.float 0.470628
	.float -0.190903
	.float 0.051240
	.float -0.168513
	.float 0.446486
	.float -0.619252
	.float 0.447666
	.float 0.076257
	.float -0.682754
	.float 0.986687
	.float -0.746822
	.float 0.032943
	.float 0.819861
	.float -1.430199
	.float 1.601105
	.float -1.406376
	.float 1.093451
	.float -0.894457
	.float 0.884043
	.float -0.966489
	.float 0.973433
	.float -0.786561
	.float 0.404715
	.float 0.070410
	.float -0.500904
	.float 0.780784
	.float -0.869650
	.float 0.785988
	.float -0.578607
	.float 0.302014
	.float -0.011123
	.float -0.231001
	.float 0.353704
	.float -0.304735
	.float 0.093983
	.float 0.178901
	.float -0.349406
	.float 0.271373
	.float 0.082535
	.float -0.571591
	.float 0.939897
	.float -0.961386
	.float 0.596174
	.float -0.049579
	.float -0.328790
	.float 0.264182
	.float 0.244481
	.float -0.893598
	.float 1.256184
	.float -1.066328
	.float 0.408357
	.float 0.333678
	.float -0.739943
	.float 0.644503
	.float -0.239399
	.float -0.081504
	.float 0.017250
	.float 0.429444
	.float -0.975293
	.float 1.279170
	.float -1.182942
	.float 0.790900
	.float -0.349263
	.float 0.042600
	.float 0.127054
	.float -0.297638
	.float 0.596982
	.float -1.016283
	.float 1.403607
	.float -1.570078
	.float 1.418879
	.float -1.003080
	.float 0.484550
	.float -0.039302
	.float -0.220412
	.float 0.268987
	.float -0.147325
	.float -0.065253
	.float 0.269418
	.float -0.365012
	.float 0.286745
	.float -0.047054
	.float -0.248088
	.float 0.439217
	.float -0.398620
	.float 0.109492
	.float 0.317009
	.float -0.704642
	.float 0.917838
	.float -0.942138
	.float 0.884728
	.float -0.892227
	.float 1.039486
	.float -1.266476
	.float 1.412328
	.float -1.328201
	.float 0.990279
	.float -0.526580
	.float 0.131144
	.float 0.075091
	.float -0.131132
	.float 0.200092
	.float -0.434227
	.float 0.842984
	.float -1.267725
	.float 1.486807
	.float -1.375466
	.float 1.001643
	.float -0.584658
	.float 0.343675
	.float -0.344882
	.float 0.458390
	.float -0.457222
	.float 0.186782
	.float 0.318442
	.float -0.854283
	.float 1.184754
	.float -1.195496
	.float 0.954817
	.float -0.649206
	.float 0.452203
	.float -0.423712
	.float 0.500173
	.float -0.563464
	.float 0.527689
	.float -0.386045
	.float 0.199671
	.float -0.047235
	.float -0.029588
	.float 0.055340
	.float -0.108244
	.float 0.267085
	.float -0.541176
	.float 0.827947
	.float -0.941077
	.float 0.715631
	.float -0.137602
	.float -0.592800
	.float 1.131192
	.float -1.174501
	.float 0.654070
	.float 0.196114
	.float -0.955824
	.float 1.255439
	.float -0.984026
	.float 0.338441
	.float 0.309441
	.float -0.632625
	.float 0.518479
	.float -0.097479
	.float -0.363495
	.float 0.624071
	.float -0.593194
	.float 0.351466
	.float -0.072777
	.float -0.099448
	.float 0.140831
	.float -0.140958
	.float 0.210442
	.float -0.373363
	.float 0.534693
	.float -0.553950
	.float 0.366431
	.float -0.047867
	.float -0.235360
	.float 0.349883
	.float -0.287930
	.float 0.154288
	.float -0.067433
	.float 0.066396
	.float -0.100643
	.float 0.099684
	.float -0.049625
	.float 0.005946
	.float -0.036481
	.float 0.152300
	.float -0.290223
	.float 0.360407
	.float -0.314305
	.float 0.174789
	.float -0.008670
	.float -0.126361
	.float 0.210641
	.float -0.247277
	.float 0.229306
	.float -0.132349
	.float -0.051772
	.float 0.272765
	.float -0.420103
	.float 0.381625
	.float -0.126843
	.float -0.250682
	.float 0.574596
	.float -0.690730
	.float 0.564468
	.float -0.299704
	.float 0.063945
	.float 0.027382
	.float 0.015773
	.float -0.078001
	.float 0.033452
	.float 0.155994
	.float -0.410697
	.float 0.588580
	.float -0.581740
	.float 0.384892
	.float -0.093447
	.float -0.157950
	.float 0.269934
	.float -0.221670
	.float 0.067310
	.float 0.101174
	.float -0.200713
	.float 0.192863
	.float -0.095752
	.float -0.032531
	.float 0.130935
	.float -0.171451
	.float 0.170920
	.float -0.172133
	.float 0.211454
	.float -0.299382
	.float 0.424887
	.float -0.570083
	.float 0.714338
	.float -0.823432
	.float 0.840847
	.float -0.701415
	.float 0.368562
	.float 0.127648
	.float -0.679308
	.float 1.130396
	.float -1.337393
	.float 1.232716
	.float -0.858160
	.float 0.347636
	.float 0.136230
	.float -0.477847
	.float 0.652308
	.float -0.711247
	.float 0.725318
	.float -0.729276
	.float 0.709936
	.float -0.639349
	.float 0.516015
	.float -0.372669
	.float 0.242367
	.float -0.116681
	.float -0.059282
	.float 0.341511
	.float -0.723887
	.float 1.112189
	.float -1.365362
	.float 1.382046
	.float -1.170773
	.float 0.850665
	.float -0.579469
	.float 0.460023
	.float -0.490636
	.float 0.589295
	.float -0.663962
	.float 0.671532
	.float -0.625278
	.float 0.558579
	.float -0.485813
	.float 0.393851
	.float -0.262195
	.float 0.084371
	.float 0.128959
	.float -0.358249
	.float 0.574983
	.float -0.730152
	.float 0.753200
	.float -0.583117
	.float 0.220894
	.float 0.238128
	.float -0.629773
	.float 0.798572
	.float -0.678981
	.float 0.329568
	.float 0.094666
	.float -0.407475
	.float 0.460399
	.float -0.197181
	.float -0.313873
	.float 0.884317
	.float -1.264595
	.float 1.251707
	.float -0.796271
	.float 0.040467
	.float 0.747436
	.float -1.306888
	.float 1.504764
	.float -1.372095
	.float 1.050466
	.float -0.697221
	.float 0.411153
	.float -0.210804
	.float 0.058669
	.float 0.095863
	.float -0.280922
	.float 0.486308
	.float -0.668308
	.float 0.767736
	.float -0.732954
	.float 0.542389
	.float -0.224265
	.float -0.132728
	.float 0.391526
	.float -0.414068
	.float 0.134996
	.float 0.377008
	.float -0.920700
	.float 1.247958
	.float -1.197514
	.float 0.796021
	.float -0.254103
	.float -0.150464
	.float 0.234040
	.float -0.009538
	.float -0.335571
	.float 0.568644
	.float -0.559178
	.float 0.345278
	.float -0.082191
	.float -0.079176
	.float 0.088590
	.float -0.000591
	.float -0.101137
	.float 0.182407
	.float -0.268828
	.float 0.385890
	.float -0.497759
	.float 0.516998
	.float -0.386957
	.float 0.159729
	.float 0.016202
	.float -0.005015
	.float -0.200274
	.float 0.462733
	.float -0.610737
	.float 0.579797
	.float -0.460691
	.float 0.411156
	.float -0.513520
	.float 0.709808
	.float -0.870029
	.float 0.922348
	.float -0.916211
	.float 0.956948
	.float -1.075711
	.float 1.162487
	.float -1.034655
	.float 0.590207
	.float 0.080894
	.float -0.721112
	.float 1.051775
	.float -0.939286
	.float 0.473218
	.float 0.083611
	.float -0.433718
	.float 0.392823
	.float 0.024744
	.float -0.619350
	.float 1.111110
	.float -1.289300
	.float 1.129395
	.float -0.806238
	.float 0.582416
	.float -0.630068
	.float 0.898781
	.float -1.126289
	.float 0.999208
	.float -0.367387
	.float -0.628527
	.float 1.605617
	.float -2.139401
	.float 1.996750
	.float -1.263662
	.float 0.298598
	.float 0.454790
	.float -0.688092
	.float 0.367209
	.float 0.272162
	.float -0.859981
	.float 1.084494
	.float -0.845896
	.float 0.296341
	.float 0.252938
	.float -0.508119
	.float 0.356127
	.float 0.079175
	.float -0.521746
	.float 0.717289
	.float -0.585942
	.float 0.257143
	.float 0.031460
	.float -0.097498
	.float -0.071109
	.float 0.321014
	.float -0.444796
	.float 0.317029
	.float 0.033511
	.float -0.454206
	.float 0.770412
	.float -0.887238
	.float 0.827870
	.float -0.693835
	.float 0.586267
	.float -0.548457
	.float 0.564912
	.float -0.601539
	.float 0.640339
	.float -0.675237
	.float 0.681466
	.float -0.602296
	.float 0.382424
	.float -0.029613
	.float -0.350551
	.float 0.589170
	.float -0.547959
	.float 0.213230
	.float 0.276604
	.float -0.694714
	.float 0.845893
	.float -0.671044
	.float 0.274075
	.float 0.142313
	.float -0.390337
	.float 0.391499
	.float -0.201118
	.float -0.040947
	.float 0.195181
	.float -0.192922
	.float 0.062268
	.float 0.093901
	.float -0.151419
	.float 0.028397
	.float 0.265111
	.float -0.616233
	.float 0.852375
	.float -0.828803
	.float 0.518321
	.float -0.046238
	.float -0.363885
	.float 0.514360
	.float -0.356118
	.float 0.029158
	.float 0.213892
	.float -0.158454
	.float -0.241917
	.float 0.839875
	.float -1.386529
	.float 1.675712
	.float -1.645910
	.float 1.383364
	.float -1.041906
	.float 0.745090
	.float -0.533003
	.float 0.374406
	.float -0.220202
	.float 0.056074
	.float 0.079228
	.float -0.118485
	.float 0.016993
	.float 0.204222
	.float -0.456256
	.float 0.630372
	.float -0.668203
	.float 0.603083
	.float -0.536246
	.float 0.559854
	.float -0.682772
	.float 0.817790
	.float -0.843184
	.float 0.693853
	.float -0.413686
	.float 0.130638
	.float 0.027249
	.float -0.014985
	.float -0.102604
	.float 0.195808
	.float -0.154525
	.float -0.042193
	.float 0.313235
	.float -0.525537
	.float 0.574774
	.float -0.447899
	.float 0.229956
	.float -0.053000
	.float 0.019497
	.float -0.146202
	.float 0.358878
	.float -0.535754
	.float 0.571925
	.float -0.430484
	.float 0.157833
	.float 0.141846
	.float -0.361504
	.float 0.449195
	.float -0.436025
	.float 0.410583
	.float -0.449008
	.float 0.546761
	.float -0.607339
	.float 0.506665
	.float -0.190934
	.float -0.268058
	.float 0.708183
	.float -0.979820
	.float 1.037242
	.float -0.948868
	.float 0.823617
	.float -0.719664
	.float 0.613577
	.float -0.453189
	.float 0.243409
	.float -0.082397
	.float 0.104140
	.float -0.364374
	.float 0.762621
	.float -1.075112
	.float 1.090184
	.float -0.751385
	.float 0.198962
	.float 0.326129
	.float -0.644562
	.float 0.743272
	.float -0.745451
	.float 0.778987
	.float -0.857579
	.float 0.873957
	.float -0.707063
	.float 0.348092
	.float 0.064266
	.float -0.331643
	.float 0.335839
	.float -0.118388
	.float -0.159010
	.float 0.334057
	.float -0.344509
	.float 0.238423
	.float -0.105104
	.float -0.000139
	.float 0.073667
	.float -0.123613
	.float 0.127430
	.float -0.037670
	.float -0.164981
	.float 0.422228
	.float -0.604359
	.float 0.579752
	.float -0.303480
	.float -0.136613
	.float 0.550844
	.float -0.739749
	.float 0.594469
	.float -0.150651
	.float -0.429435
	.float 0.932541
	.float -1.188074
	.float 1.138065
	.float -0.856760
	.float 0.513395
	.float -0.291600
	.float 0.296761
	.float -0.494898
	.float 0.722755
	.float -0.778978
	.float 0.556862
	.float -0.139401
	.float -0.218504
	.float 0.233280
	.float 0.214264
	.float -0.964992
	.float 1.640781
	.float -1.857863
	.float 1.460081
	.float -0.612814
	.float -0.307140
	.float 0.944782
	.float -1.157259
	.float 1.038857
	.float -0.790173
	.float 0.551750
	.float -0.329318
	.float 0.047578
	.float 0.334325
	.float -0.747972
	.float 1.037555
	.float -1.055065
	.float 0.756935
	.float -0.238081
	.float -0.312085
	.float 0.699024
	.float -0.804461
	.float 0.620069
	.float -0.227833
	.float -0.247692
	.float 0.682453
	.float -0.974944
	.float 1.055697
	.float -0.901550
	.float 0.555229
	.float -0.127789
	.float -0.239880
	.float 0.449830
	.float -0.507389
	.float 0.516557
	.float -0.600550
	.float 0.799818
	.float -1.027877
	.float 1.127842
	.float -0.994031
	.float 0.667679
	.float -0.329002
	.float 0.183187
	.float -0.316889
	.float 0.626423
	.float -0.870309
	.float 0.816455
	.float -0.392754
	.float -0.251674
	.float 0.813412
	.float -0.994219
	.float 0.664943
	.float 0.058310
	.float -0.869546
	.float 1.430908
	.float -1.543600
	.float 1.234454
	.float -0.711468
	.float 0.223828
	.float 0.079570
	.float -0.204294
	.float 0.254835
	.float -0.326349
	.float 0.432442
	.float -0.519755
	.float 0.542803
	.float -0.523013
	.float 0.534926
	.float -0.632652
	.float 0.786894
	.float -0.893795
	.float 0.851401
	.float -0.639942
	.float 0.341836
	.float -0.090868
	.float -0.006272
	.float -0.074786
	.float 0.265922
	.float -0.434904
	.float 0.440552
	.float -0.203348
	.float -0.233902
	.float 0.698676
	.float -0.964757
	.float 0.885095
	.float -0.498159
	.float 0.023808
	.float 0.263771
	.float -0.208369
	.float -0.126142
	.float 0.492230
	.float -0.609911
	.float 0.337297
	.float 0.240781
	.float -0.854232
	.float 1.193079
	.float -1.075493
	.float 0.546916
	.float 0.144598
	.float -0.683314
	.float 0.853317
	.float -0.640801
	.float 0.214307
	.float 0.194649
	.float -0.426627
	.float 0.460295
	.float -0.382039
	.float 0.300777
	.float -0.276325
	.float 0.303614
	.float -0.345064
	.float 0.372889
	.float -0.388450
	.float 0.411513
	.float -0.455174
	.float 0.507350
	.float -0.531653
	.float 0.487423
	.float -0.357281
	.float 0.164841
	.float 0.031137
	.float -0.166289
	.float 0.207269
	.float -0.170575
	.float 0.108812
	.float -0.073227
	.float 0.080714
	.float -0.111126
	.float 0.135690
	.float -0.150214
	.float 0.181676
	.float -0.260201
	.float 0.380314
	.float -0.485962
	.float 0.495044
	.float -0.348131
	.float 0.049684
	.float 0.323306
	.float -0.648648
	.float 0.809093
	.float -0.743639
	.float 0.478169
	.float -0.119730
	.float -0.187021
	.float 0.322484
	.float -0.242859
	.float -0.007397
	.float 0.325619
	.float -0.604141
	.float 0.777607
	.float -0.841810
	.float 0.838546
	.float -0.817456
	.float 0.797615
	.float -0.751928
	.float 0.626021
	.float -0.381750
	.float 0.037902
	.float 0.320692
	.float -0.575070
	.float 0.628339
	.float -0.454626
	.float 0.114798
	.float 0.267323
	.float -0.555997
	.float 0.659560
	.float -0.569141
	.float 0.363781
	.float -0.176682
	.float 0.132858
	.float -0.283326
	.float 0.568650
	.float -0.835875
	.float 0.909025
	.float -0.683568
	.float 0.195386
	.float 0.380546
	.float -0.812363
	.float 0.934285
	.float -0.737562
	.float 0.367939
	.float -0.027865
	.float -0.150371
	.float 0.170267
	.float -0.130245
	.float 0.114510
	.float -0.109964
	.float 0.021591
	.float 0.225078
	.float -0.583448
	.float 0.879760
	.float -0.917621
	.float 0.615586
	.float -0.070870
	.float -0.499637
	.float 0.892624
	.float -1.023964
	.float 0.937423
	.float -0.731520
	.float 0.480839
	.float -0.216133
	.float -0.037950
	.float 0.222935
	.float -0.255791
	.float 0.085888
	.float 0.251259
	.float -0.633418
	.float 0.909860
	.float -0.976560
	.float 0.818335
	.float -0.498936
	.float 0.119370
	.float 0.221914
	.float -0.449744
	.float 0.519886
	.float -0.426371
	.float 0.209149
	.float 0.049930
	.float -0.252211
	.float 0.320225
	.float -0.227686
	.float 0.005400
	.float 0.275529
	.float -0.529254
	.float 0.678706
	.float -0.677472
	.float 0.531128
	.float -0.307718
	.float 0.118432
	.float -0.063847
	.float 0.172314
	.float -0.375330
	.float 0.546147
	.float -0.580449
	.float 0.462220
	.float -0.267175
	.float 0.103564
	.float -0.035840
	.float 0.044634
	.float -0.046052
	.float -0.047637
	.float 0.265731
	.float -0.551196
	.float 0.782445
	.float -0.835595
	.float 0.656857
	.float -0.303838
	.float -0.073462
	.float 0.308997
	.float -0.312407
	.float 0.118511
	.float 0.139630
	.float -0.316982
	.float 0.342924
	.float -0.248159
	.float 0.117080
	.float -0.008131
	.float -0.090506
	.float 0.232289
	.float -0.435551
	.float 0.628396
	.float -0.672003
	.float 0.455696
	.float 0.006084
	.float -0.554153
	.float 0.967716
	.float -1.097051
	.float 0.954152
	.float -0.697603
	.float 0.522232
	.float -0.529701
	.float 0.667643
	.float -0.776227
	.float 0.706216
	.float -0.425355
	.float 0.040846
	.float 0.270332
	.float -0.366619
	.float 0.208192
	.float 0.147153
	.float -0.590115
	.float 0.997366
	.float -1.243461
	.float 1.216857
	.float -0.870687
	.float 0.288131
	.float 0.306380
	.float -0.639853
	.float 0.551914
	.float -0.112794
	.float -0.402488
	.float 0.681055
	.float -0.566757
	.float 0.144952
	.float 0.335952
	.float -0.637701
	.float 0.671041
	.float -0.513955
	.float 0.321762
	.float -0.214422
	.float 0.220521
	.float -0.296023
	.float 0.377575
	.float -0.421692
	.float 0.411746
	.float -0.348244
	.float 0.243389
	.float -0.124209
	.float 0.033544
	.float -0.019568
	.float 0.115058
	.float -0.316436
	.float 0.574101
	.float -0.802086
	.float 0.908983
	.float -0.840132
	.float 0.609396
	.float -0.298232
	.float 0.018068
	.float 0.142071
	.float -0.150074
	.float 0.029760
	.float 0.165555
	.float -0.379917
	.float 0.566331
	.float -0.687132
	.float 0.716606
	.float -0.650911
	.float 0.516882
	.float -0.367873
	.float 0.264311
	.float -0.248535
	.float 0.326752
	.float -0.466381
	.float 0.608808
	.float -0.692154
	.float 0.674820
	.float -0.550481
	.float 0.347511
	.float -0.113927
	.float -0.103560
	.float 0.275590
	.float -0.395282
	.float 0.473057
	.float -0.524354
	.float 0.553172
	.float -0.537018
	.float 0.425155
	.float -0.163046
	.float -0.259030
	.float 0.761647
	.float -1.179476
	.float 1.333161
	.float -1.138974
	.float 0.681183
	.float -0.183242
	.float -0.118400
	.float 0.116834
	.float 0.107203
	.float -0.353329
	.float 0.444880
	.float -0.343687
	.float 0.159539
	.float -0.057649
	.float 0.137452
	.float -0.366759
	.float 0.608072
	.float -0.710526
	.float 0.604663
	.float -0.344775
	.float 0.080877
	.float 0.019002
	.float 0.144641
	.float -0.546675
	.float 1.037451
	.float -1.404012
	.float 1.471127
	.float -1.195478
	.float 0.698002
	.float -0.206430
	.float -0.065662
	.float 0.032185
	.float 0.229213
	.float -0.535098
	.float 0.704106
	.float -0.646425
	.float 0.390909
	.float -0.050467
	.float -0.243816
	.float 0.404742
	.float -0.420386
	.float 0.340957
	.float -0.227560
	.float 0.096254
	.float 0.096738
	.float -0.406518
	.float 0.820454
	.float -1.220350
	.float 1.436267
	.float -1.365937
	.float 1.065628
	.float -0.726501
	.float 0.541861
	.float -0.566992
	.float 0.688989
	.float -0.735401
	.float 0.632408
	.float -0.477465
	.float 0.461499
	.float -0.700276
	.float 1.110424
	.float -1.432276
	.float 1.388648
	.float -0.869403
	.float 0.014048
	.float 0.862434
	.float -1.450600
	.float 1.616216
	.float -1.452546
	.float 1.189332
	.float -1.028876
	.float 1.025791
	.float -1.089695
	.float 1.093555
	.float -0.990279
	.float 0.839470
	.float -0.729127
	.float 0.672301
	.float -0.581552
	.float 0.352223
	.float 0.017972
	.float -0.387828
	.float 0.559881
	.float -0.432555
	.float 0.090784
	.float 0.244417
	.float -0.369685
	.float 0.234436
	.float 0.044443
	.float -0.287027
	.float 0.379873
	.float -0.330111
	.float 0.219072
	.float -0.113922
	.float 0.017323
	.float 0.113027
	.float -0.305826
	.float 0.535143
	.float -0.727395
	.float 0.805284
	.float -0.733058
	.float 0.534872
	.float -0.277296
	.float 0.027632
	.float 0.188655
	.float -0.403848
	.float 0.678984
	.float -1.039957
	.float 1.421427
	.float -1.671444
	.float 1.634510
	.float -1.267754
	.float 0.702714
	.float -0.189614
	.float -0.055417
	.float -0.002393
	.float 0.186632
	.float -0.230580
	.float -0.030640
	.float 0.534529
	.float -1.026074
	.float 1.231405
	.float -1.047358
	.float 0.614039
	.float -0.223272
	.float 0.131204
	.float -0.404459
	.float 0.894468
	.float -1.341512
	.float 1.528298
	.float -1.387611
	.float 1.014453
	.float -0.595170
	.float 0.303376
	.float -0.215460
	.float 0.280859
	.float -0.359221
	.float 0.307483
	.float -0.071212
	.float -0.276581
	.float 0.579311
	.float -0.697689
	.float 0.597977
	.float -0.365975
	.float 0.143438
	.float -0.042910
	.float 0.105091
	.float -0.315271
	.float 0.639773
	.float -1.034023
	.float 1.416736
	.float -1.653901
	.float 1.598419
	.float -1.180930
	.float 0.488725
	.float 0.239690
	.float -0.724767
	.float 0.802950
	.float -0.529638
	.float 0.154500
	.float 0.025297
	.float 0.152211
	.float -0.609738
	.float 1.075493
	.float -1.254724
	.float 1.022357
	.float -0.509961
	.float 0.022679
	.float 0.165122
	.float 0.002425
	.float -0.327202
	.float 0.505762
	.float -0.356694
	.float -0.043532
	.float 0.421903
	.float -0.520429
	.float 0.291301
	.float 0.077693
	.float -0.322049
	.float 0.307307
	.float -0.112292
	.float -0.071774
	.float 0.125677
	.float -0.100430
	.float 0.142820
	.float -0.324594
	.float 0.544016
	.float -0.603461
	.float 0.399729
	.float -0.049123
	.float -0.182087
	.float 0.097178
	.float 0.248947
	.float -0.571615
	.float 0.577373
	.float -0.207165
	.float -0.298524
	.float 0.568933
	.float -0.374967
	.float -0.204482
	.float 0.841166
	.float -1.184376
	.float 1.080637
	.float -0.634959
	.float 0.095995
	.float 0.323911
	.float -0.557059
	.float 0.661923
	.float -0.727872
	.float 0.795273
	.float -0.842871
	.float 0.826040
	.float -0.718302
	.float 0.527507
	.float -0.290193
	.float 0.058699
	.float 0.115425
	.float -0.203594
	.float 0.219537
	.float -0.217870
	.float 0.263906
	.float -0.390638
	.float 0.572012
	.float -0.730993
	.float 0.775896
	.float -0.643662
	.float 0.329837
	.float 0.104444
	.float -0.550534
	.float 0.890352
	.float -1.041957
	.float 0.992702
	.float -0.802855
	.float 0.576521
	.float -0.413117
	.float 0.361853
	.float -0.399058
	.float 0.440078
	.float -0.384513
	.float 0.178662
	.float 0.137904
	.float -0.436093
	.float 0.562534
	.float -0.433980
	.float 0.098361
	.float 0.286572
	.float -0.549414
	.float 0.610054
	.float -0.518414
	.float 0.403177
	.float -0.376943
	.float 0.473719
	.float -0.657581
	.float 0.876964
	.float -1.105673
	.float 1.336597
	.float -1.547170
	.float 1.681360
	.float -1.670842
	.float 1.476417
	.float -1.115154
	.float 0.657933
	.float -0.209290
	.float -0.117419
	.float 0.233243
	.float -0.120655
	.float -0.127425
	.float 0.323795
	.float -0.282915
	.float -0.048757
	.float 0.527790
	.float -0.886555
	.float 0.910360
	.float -0.589894
	.float 0.127526
	.float 0.209692
	.float -0.273495
	.float 0.113123
	.float 0.097228
	.float -0.204798
	.float 0.175696
	.float -0.081559
	.float 0.013918
	.float -0.012168
	.float 0.057040
	.float -0.111802
	.float 0.157049
	.float -0.184987
	.float 0.168835
	.float -0.050747
	.float -0.224367
	.float 0.647802
	.float -1.111846
	.float 1.445241
	.float -1.512484
	.float 1.312294
	.float -0.995712
	.float 0.774576
	.float -0.774576
	.float 0.937295
	.float -1.048806
	.float 0.883187
	.float -0.365283
	.float -0.357716
	.float 0.984789
	.float -1.227870
	.float 0.976983
	.float -0.368294
	.float -0.283112
	.float 0.650112
	.float -0.569186
	.float 0.126251
	.float 0.399308
	.float -0.702544
	.float 0.633597
	.float -0.280262
	.float -0.096718
	.float 0.231313
	.float -0.014654
	.float -0.446176
	.float 0.899875
	.float -1.098797
	.float 0.931531
	.float -0.469647
	.float -0.083875
	.float 0.504933
	.float -0.655393
	.float 0.536443
	.float -0.268999
	.float 0.017788
	.float 0.098817
	.float -0.065266
	.float -0.036700
	.float 0.088016
	.float -0.007403
	.float -0.203520
	.float 0.467644
	.float -0.681353
	.float 0.771676
	.float -0.728284
	.float 0.595030
	.float -0.429629
	.float 0.259264
	.float -0.065897
	.float -0.183628
	.float 0.482004
	.float -0.749496
	.float 0.865215
	.float -0.750372
	.float 0.439545
	.float -0.072454
	.float -0.199031
	.float 0.320031
	.float -0.368848
	.float 0.489420
	.float -0.773900
	.float 1.186042
	.float -1.576903
	.float 1.770854
	.float -1.657674
	.float 1.239756
	.float -0.625121
	.float -0.016098
	.float 0.511305
	.float -0.745067
	.float 0.699304
	.float -0.452745
	.float 0.135618
	.float 0.134946
	.float -0.297336
	.float 0.343422
	.float -0.287571
	.float 0.144757
	.float 0.061235
	.float -0.275421
	.float 0.412053
	.float -0.395067
	.float 0.213829
	.float 0.054220
	.float -0.280990
	.float 0.362717
	.float -0.276385
	.float 0.076515
	.float 0.156723
	.float -0.366908
	.float 0.527659
	.float -0.613956
	.float 0.585606
	.float -0.416017
	.float 0.146361
	.float 0.094049
	.float -0.142553
	.float -0.089627
	.float 0.534854
	.float -0.982741
	.float 1.195627
	.float -1.055119
	.float 0.638917
	.float -0.171278
	.float -0.122927
	.float 0.160367
	.float -0.038110
	.float -0.054832
	.float -0.017120
	.float 0.245519
	.float -0.505690
	.float 0.667780
	.float -0.691126
	.float 0.625475
	.float -0.532786
	.float 0.415468
	.float -0.225160
	.float -0.058255
	.float 0.362041
	.float -0.545307
	.float 0.503789
	.float -0.263781
	.float -0.023322
	.float 0.188465
	.float -0.165943
	.float 0.028079
	.float 0.089971
	.float -0.105661
	.float 0.048592
	.float -0.023624
	.float 0.120098
	.float -0.344286
	.float 0.618832
	.float -0.833962
	.float 0.904522
	.float -0.801576
	.float 0.557607
	.float -0.256141
	.float 0.006345
	.float 0.101411
	.float -0.046310
	.float -0.100771
	.float 0.213123
	.float -0.189105
	.float 0.021132
	.float 0.203849
	.float -0.374514
	.float 0.437262
	.float -0.421039
	.float 0.388263
	.float -0.361602
	.float 0.295241
	.float -0.114432
	.float -0.213976
	.float 0.639731
	.float -1.045596
	.float 1.304044
	.float -1.334299
	.float 1.132662
	.float -0.772618
	.float 0.382147
	.float -0.103820
	.float 0.043295
	.float -0.220509
	.float 0.547175
	.float -0.850092
	.float 0.941736
	.float -0.713447
	.float 0.206881
	.float 0.381309
	.float -0.780010
	.float 0.780516
	.float -0.357012
	.float -0.305537
	.float 0.902724
	.float -1.171598
	.float 1.024748
	.float -0.579731
	.float 0.076852
	.float 0.254265
	.float -0.300720
	.float 0.099172
	.float 0.202155
	.float -0.421933
	.float 0.430138
	.float -0.208329
	.float -0.139771
	.float 0.440010
	.float -0.543947
	.float 0.416681
	.float -0.157433
	.float -0.066270
	.float 0.127663
	.float -0.014575
	.float -0.183159
	.float 0.355549
	.float -0.452191
	.float 0.498269
	.float -0.545128
	.float 0.609670
	.float -0.658111
	.float 0.641331
	.float -0.541378
	.float 0.385020
	.float -0.218475
	.float 0.074925
	.float 0.033438
	.float -0.098296
	.float 0.101429
	.float -0.028166
	.float -0.100052
	.float 0.209697
	.float -0.206007
	.float 0.042020
	.float 0.224138
	.float -0.439160
	.float 0.443854
	.float -0.188898
	.float -0.210058
	.float 0.531602
	.float -0.593456
	.float 0.382227
	.float -0.070690
	.float -0.096585
	.float -0.028289
	.float 0.390966
	.float -0.763683
	.float 0.887599
	.float -0.636121
	.float 0.099934
	.float 0.453705
	.float -0.722728
	.float 0.535513
	.float 0.048561
	.float -0.760520
	.float 1.259585
	.float -1.315779
	.float 0.933882
	.float -0.341910
	.float -0.151277
	.float 0.339377
	.float -0.223829
	.float -0.024048
	.float 0.207055
	.float -0.240687
	.float 0.186435
	.float -0.167086
	.float 0.243384
	.float -0.355624
	.float 0.372466
	.float -0.200636
	.float -0.135332
	.float 0.501878
	.float -0.740503
	.float 0.761844
	.float -0.589337
	.float 0.336104
	.float -0.140904
	.float 0.101539
	.float -0.233195
	.float 0.462682
	.float -0.659324
	.float 0.693999
	.float -0.505267
	.float 0.139813
	.float 0.260177
	.float -0.524032
	.float 0.540824
	.float -0.317748
	.float -0.026415
	.float 0.327840
	.float -0.462646
	.float 0.401880
	.float -0.212667
	.float 0.015245
	.float 0.074611
	.float 0.006984
	.float -0.247659
	.float 0.560969
	.float -0.816356
	.float 0.892326
	.float -0.734927
	.float 0.391619
	.float 0.004169
	.float -0.297295
	.float 0.391789
	.float -0.300962
	.float 0.134360
	.float -0.028216
	.float 0.062496
	.float -0.217330
	.float 0.395174
	.float -0.490409
	.float 0.456864
	.float -0.327521
	.float 0.176723
	.float -0.057331
	.float -0.038054
	.float 0.162636
	.float -0.359218
	.float 0.605807
	.float -0.806557
	.float 0.839977
	.float -0.634548
	.float 0.221538
	.float 0.271379
	.float -0.683395
	.float 0.901145
	.float -0.907487
	.float 0.771602
	.float -0.592055
	.float 0.433661
	.float -0.299185
	.float 0.150165
	.float 0.044288
	.float -0.269373
	.float 0.464524
	.float -0.558450
	.float 0.511472
	.float -0.336140
	.float 0.087031
	.float 0.169066
	.float -0.381905
	.float 0.531412
	.float -0.621019
	.float 0.655676
	.float -0.619404
	.float 0.473427
	.float -0.187967
	.float -0.205553
	.float 0.584616
	.float -0.770481
	.float 0.628047
	.float -0.171833
	.float -0.406113
	.float 0.827059
	.float -0.890010
	.float 0.600228
	.float -0.168913
	.float -0.120550
	.float 0.088454
	.float 0.241413
	.float -0.675830
	.float 0.980598
	.float -1.007804
	.float 0.746616
	.float -0.292002
	.float -0.219485
	.float 0.656070
	.float -0.907797
	.float 0.896740
	.float -0.600722
	.float 0.081773
	.float 0.512259
	.float -0.994138
	.float 1.217730
	.float -1.146697
	.float 0.868008
	.float -0.540204
	.float 0.307900
	.float -0.231947
	.float 0.270547
	.float -0.314329
	.float 0.252040
	.float -0.034348
	.float -0.292838
	.float 0.603831
	.float -0.757051
	.float 0.679520
	.float -0.421137
	.float 0.134729
	.float 0.016475
	.float 0.035403
	.float -0.222123
	.float 0.396987
	.float -0.445702
	.float 0.360968
	.float -0.224004
	.float 0.119024
	.float -0.064002
	.float 0.019852
	.float 0.039233
	.float -0.073452
	.float 0.005324
	.float 0.190575
	.float -0.422067
	.float 0.512814
	.float -0.324478
	.float -0.126471
	.float 0.658585
	.float -1.041671
	.float 1.155456
	.float -1.066871
	.float 0.961460
	.float -0.979489
	.float 1.086900
	.float -1.090440
	.float 0.795684
	.float -0.189312
	.float -0.503020
	.float 0.944868
	.float -0.920598
	.float 0.498209
	.float 0.007272
	.float -0.252429
	.float 0.105932
	.float 0.270892
	.float -0.563529
	.float 0.552346
	.float -0.273774
	.float -0.028555
	.float 0.116223
	.float 0.043900
	.float -0.253577
	.float 0.249248
	.float 0.074605
	.float -0.562030
	.float 0.891661
	.float -0.798578
	.float 0.258114
	.float 0.495378
	.float -1.117008
	.float 1.355720
	.float -1.179661
	.float 0.759140
	.float -0.344062
	.float 0.127849
	.float -0.170680
	.float 0.398554
	.float -0.651781
	.float 0.754965
	.float -0.594040
	.float 0.182700
	.float 0.319980
	.float -0.677034
	.float 0.710496
	.float -0.422204
	.float -0.002264
	.float 0.327419
	.float -0.441637
	.float 0.424541
	.float -0.445023
	.float 0.579341
	.float -0.719497
	.float 0.666555
	.float -0.332918
	.float -0.133014
	.float 0.427730
	.float -0.326624
	.float -0.123113
	.float 0.619347
	.float -0.827241
	.float 0.629910
	.float -0.208288
	.float -0.107783
	.float 0.090542
	.float 0.233688
	.float -0.640503
	.float 0.906602
	.float -0.978470
	.float 0.978288
	.float -1.061718
	.float 1.265996
	.float -1.482101
	.float 1.565241
	.float -1.473520
	.float 1.304885
	.float -1.200482
	.float 1.205185
	.float -1.213799
	.float 1.053697
	.float -0.634354
	.float 0.037883
	.float 0.524041
	.float -0.850340
	.float 0.876708
	.float -0.695770
	.float 0.469290
	.float -0.313706
	.float 0.249139
	.float -0.236359
	.float 0.246680
	.float -0.288525
	.float 0.368207
	.float -0.438442
	.float 0.408312
	.float -0.226764
	.float -0.034406
	.float 0.193474
	.float -0.085309
	.float -0.290974
	.float 0.733622
	.float -0.957583
	.float 0.788081
	.float -0.278800
	.float -0.334271
	.float 0.798268
	.float -0.993703
	.float 0.962447
	.float -0.817522
	.float 0.632116
	.float -0.405773
	.float 0.122327
	.float 0.172236
	.float -0.357895
	.float 0.317319
	.float -0.041198
	.float -0.328212
	.float 0.561312
	.float -0.476237
	.float 0.053680
	.float 0.547557
	.float -1.083683
	.float 1.364578
	.float -1.347118
	.float 1.129428
	.float -0.862428
	.float 0.649262
	.float -0.502608
	.float 0.378910
	.float -0.248291
	.float 0.135653
	.float -0.098563
	.float 0.164891
	.float -0.288808
	.float 0.368916
	.float -0.318597
	.float 0.131077
	.float 0.116784
	.float -0.327717
	.float 0.460921
	.float -0.555419
	.float 0.677213
	.float -0.835676
	.float 0.945482
	.float -0.874905
	.float 0.549142
	.float -0.028840
	.float -0.499324
	.float 0.818356
	.float -0.799350
	.float 0.466399
	.float 0.028380
	.float -0.496263
	.float 0.808330
	.float -0.939018
	.float 0.940395
	.float -0.878875
	.float 0.788224
	.float -0.671473
	.float 0.536699
	.float -0.419069
	.float 0.356184
	.float -0.334489
	.float 0.264074
	.float -0.024095
	.float -0.440975
	.float 1.048106
	.float -1.593150
	.float 1.859231
	.float -1.743845
	.float 1.315218
	.float -0.761191
	.float 0.272920
	.float 0.053093
	.float -0.233589
	.float 0.341162
	.float -0.426890
	.float 0.483304
	.float -0.468053
	.float 0.359024
	.float -0.190154
	.float 0.036595
	.float 0.038943
	.float -0.034178
	.float 0.007452
	.float -0.027085
	.float 0.109639
	.float -0.199945
	.float 0.212378
	.float -0.100733
	.float -0.101669
	.float 0.304064
	.float -0.420228
	.float 0.416458
	.float -0.311238
	.float 0.141028
	.float 0.065558
	.float -0.281777
	.float 0.461812
	.float -0.540180
	.float 0.463549
	.float -0.231805
	.float -0.087217
	.float 0.382248
	.float -0.545316
	.float 0.511490
	.float -0.276672
	.float -0.105287
	.float 0.537933
	.float -0.906507
	.float 1.109792
	.float -1.092792
	.float 0.865662
	.float -0.497482
	.float 0.085556
	.float 0.284444
	.float -0.566441
	.float 0.757054
	.float -0.876502
	.float 0.941825
	.float -0.948820
	.float 0.871531
	.float -0.679231
	.float 0.363936
	.float 0.034040
	.float -0.419689
	.float 0.671911
	.float -0.704964
	.float 0.531099
	.float -0.275428
	.float 0.114800
	.float -0.168253
	.float 0.415054
	.float -0.708425
	.float 0.883062
	.float -0.876434
	.float 0.766800
	.float -0.696041
	.float 0.741046
	.float -0.841571
	.float 0.846957
	.float -0.646672
	.float 0.279433
	.float 0.070237
	.float -0.193319
	.float 0.009838
	.float 0.359680
	.float -0.662567
	.float 0.679836
	.float -0.375691
	.float -0.073140
	.float 0.388450
	.float -0.364726
	.float -0.009489
	.float 0.556158
	.float -1.022104
	.float 1.219751
	.float -1.107271
	.float 0.775378
	.float -0.371155
	.float 0.019761
	.float 0.211905
	.float -0.306204
	.float 0.269216
	.float -0.118573
	.float -0.109494
	.float 0.352503
	.float -0.533480
	.float 0.592335
	.float -0.513439
	.float 0.326323
	.float -0.078696
	.float -0.193374
	.float 0.470819
	.float -0.727968
	.float 0.904608
	.float -0.907490
	.float 0.654749
	.float -0.142537
	.float -0.512644
	.float 1.096672
	.float -1.389518
	.float 1.280702
	.float -0.835753
	.float 0.263363
	.float 0.204089
	.float -0.440993
	.float 0.481709
	.float -0.462536
	.float 0.499559
	.float -0.596201
	.float 0.648553
	.float -0.539852
	.float 0.246524
	.float 0.128942
	.float -0.424118
	.float 0.529015
	.float -0.454241
	.float 0.300243
	.float -0.155831
	.float 0.016846
	.float 0.197908
	.float -0.541453
	.float 0.937810
	.float -1.187136
	.float 1.093409
	.float -0.623064
	.float -0.034501
	.float 0.562736
	.float -0.708124
	.float 0.429095
	.float 0.098163
	.float -0.611649
	.float 0.931981
	.float -1.050386
	.float 1.087895
	.float -1.171235
	.float 1.323277
	.float -1.445542
	.float 1.399649
	.float -1.124176
	.float 0.699236
	.float -0.307701
	.float 0.113617
	.float -0.140039
	.float 0.235917
	.float -0.167384
	.float -0.217795
	.float 0.862059
	.float -1.500884
	.float 1.807121
	.float -1.589761
	.float 0.918980
	.float -0.096824
	.float -0.507306
	.float 0.654183
	.float -0.350303
	.float -0.176186
	.float 0.614784
	.float -0.743704
	.float 0.540249
	.float -0.173538
	.float -0.112935
	.float 0.159110
	.float 0.011894
	.float -0.218817
	.float 0.257893
	.float -0.053950
	.float -0.283478
	.float 0.540964
	.float -0.555065
	.float 0.319223
	.float 0.034843
	.float -0.354002
	.float 0.573219
	.float -0.727711
	.float 0.870339
	.float -0.982553
	.float 0.967815
	.float -0.736229
	.float 0.302530
	.float 0.194175
	.float -0.571055
	.float 0.716797
	.float -0.648475
	.float 0.470118
	.float -0.277540
	.float 0.094214
	.float 0.112520
	.float -0.359328
	.float 0.592404
	.float -0.705358
	.float 0.619425
	.float -0.359412
	.float 0.058975
	.float 0.116921
	.float -0.078936
	.float -0.127938
	.float 0.356887
	.float -0.459162
	.float 0.379968
	.float -0.184788
	.float 0.002120
	.float 0.070746
	.float -0.030215
	.float -0.045479
	.float 0.067553
	.float -0.009740
	.float -0.072730
	.float 0.089127
	.float 0.015822
	.float -0.221799
	.float 0.448391
	.float -0.604320
	.float 0.627672
	.float -0.496311
	.float 0.222820
	.float 0.143953
	.float -0.513529
	.float 0.771873
	.float -0.836168
	.float 0.715950
	.float -0.523752
	.float 0.407856
	.float -0.445988
	.float 0.580437
	.float -0.650621
	.float 0.505535
	.float -0.117186
	.float -0.384424
	.float 0.779118
	.float -0.883488
	.float 0.659056
	.float -0.237047
	.float -0.153784
	.float 0.312472
	.float -0.170301
	.float -0.185587
	.float 0.576786
	.float -0.838513
	.float 0.898707
	.float -0.791738
	.float 0.614871
	.float -0.465841
	.float 0.398885
	.float -0.414550
	.float 0.477292
	.float -0.543497
	.float 0.581114
	.float -0.569681
	.float 0.485897
	.float -0.296316
	.float -0.022267
	.float 0.439908
	.float -0.844876
	.float 1.071553
	.float -0.989480
	.float 0.602055
	.float -0.078091
	.float -0.324347
	.float 0.406029
	.float -0.151168
	.float -0.258167
	.float 0.551580
	.float -0.533194
	.float 0.193823
	.float 0.293129
	.float -0.679925
	.float 0.784391
	.float -0.580506
	.float 0.197937
	.float 0.156852
	.float -0.308642
	.float 0.195122
	.float 0.112502
	.float -0.451702
	.float 0.648464
	.float -0.597247
	.float 0.309069
	.float 0.090769
	.float -0.417203
	.float 0.514599
	.float -0.342721
	.float 0.009963
	.float 0.276881
	.float -0.329115
	.float 0.091279
	.float 0.321563
	.float -0.692145
	.float 0.829166
	.float -0.669801
	.float 0.296175
	.float 0.129787
	.float -0.458393
	.float 0.616742
	.float -0.626155
	.float 0.582786
	.float -0.613959
	.float 0.814157
	.float -1.172657
	.float 1.531821
	.float -1.627670
	.float 1.227277
	.float -0.301257
	.float -0.887405
	.float 1.870897
	.float -2.220026
	.float 1.800018
	.float -0.861099
	.float -0.112366
	.float 0.700690
	.float -0.791383
	.float 0.601369
	.float -0.476473
	.float 0.626760
	.float -0.990800
	.float 1.311815
	.float -1.347309
	.float 1.046684
	.float -0.574751
	.float 0.183179
	.float -0.037147
	.float 0.118769
	.float -0.260685
	.float 0.272240
	.float -0.069551
	.float -0.268283
	.float 0.543614
	.float -0.555273
	.float 0.221254
	.float 0.355576
	.float -0.917463
	.float 1.170099
	.float -0.935983
	.float 0.262319
	.float 0.580944
	.float -1.221012
	.float 1.360304
	.float -0.918893
	.float 0.069141
	.float 0.847610
	.float -1.473523
	.float 1.583371
	.float -1.170311
	.float 0.439101
	.float 0.288182
	.float -0.715646
	.float 0.703820
	.float -0.323274
	.float -0.196012
	.float 0.590935
	.float -0.695758
	.float 0.507267
	.float -0.158287
	.float -0.172640
	.float 0.355540
	.float -0.354878
	.float 0.211243
	.float 0.013418
	.float -0.277623
	.float 0.557085
	.float -0.808118
	.float 0.946057
	.float -0.878130
	.float 0.578917
	.float -0.146655
	.float -0.220206
	.float 0.327428
	.float -0.104054
	.float -0.347952
	.float 0.808449
	.float -1.058382
	.float 0.984082
	.float -0.609479
	.float 0.058049
	.float 0.509106
	.float -0.936502
	.float 1.095704
	.float -0.913502
	.float 0.422082
	.float 0.201207
	.float -0.667387
	.float 0.710621
	.float -0.263321
	.float -0.455571
	.float 1.035126
	.float -1.117521
	.float 0.632867
	.float 0.150632
	.float -0.806551
	.float 1.031019
	.float -0.818455
	.float 0.414297
	.float -0.102945
	.float 0.008983
	.float -0.056771
	.float 0.089069
	.float -0.019309
	.float -0.113983
	.float 0.217791
	.float -0.255188
	.float 0.286005
	.float -0.402933
	.float 0.626995
	.float -0.861782
	.float 0.953655
	.float -0.811340
	.float 0.486332
	.float -0.144919
	.float -0.048147
	.float 0.041884
	.float 0.083257
	.float -0.202329
	.float 0.257419
	.float -0.292462
	.float 0.379765
	.float -0.510390
	.float 0.561195
	.float -0.387687
	.float -0.028018
	.float 0.510429
	.float -0.785625
	.float 0.681058
	.float -0.271609
	.float -0.157960
	.float 0.318105
	.float -0.130196
	.float -0.219811
	.float 0.433587
	.float -0.334605
	.float -0.004690
	.float 0.339747
	.float -0.460473
	.float 0.350524
	.float -0.172243
	.float 0.104460
	.float -0.181969
	.float 0.272314
	.float -0.198216
	.float -0.108156
	.float 0.548505
	.float -0.934830
	.float 1.123622
	.float -1.099039
	.float 0.952126
	.float -0.791189
	.float 0.661101
	.float -0.527305
	.float 0.323765
	.float -0.021756
	.float -0.329848
	.float 0.617470
	.float -0.720794
	.float 0.582059
	.float -0.246050
	.float -0.154919
	.float 0.464873
	.float -0.579475
	.float 0.485748
	.float -0.243311
	.float -0.072448
	.float 0.415975
	.float -0.766311
	.float 1.079204
	.float -1.250098
	.float 1.144181
	.float -0.696813
	.float 0.017003
	.float 0.603315
	.float -0.820359
	.float 0.451541
	.float 0.372532
	.float -1.243583
	.float 1.704625
	.float -1.531255
	.float 0.869251
	.float -0.124495
	.float -0.320284
	.float 0.356580
	.float -0.188065
	.float 0.136267
	.float -0.369924
	.float 0.766723
	.float -1.008948
	.float 0.834513
	.float -0.249024
	.float -0.461719
	.float 0.927534
	.float -0.950728
	.float 0.634813
	.float -0.293613
	.float 0.212864
	.float -0.442772
	.float 0.770302
	.float -0.883739
	.float 0.602475
	.float -0.005494
	.float -0.626658
	.float 1.005103
	.float -1.019210
	.float 0.788379
	.float -0.551950
	.float 0.483825
	.float -0.568173
	.float 0.624304
	.float -0.459278
	.float 0.031740
	.float 0.497521
	.float -0.869167
	.float 0.906483
	.float -0.638983
	.float 0.277763
	.float -0.066116
	.float 0.121226
	.float -0.381256
	.float 0.681520
	.float -0.883193
	.float 0.949771
	.float -0.926652
	.float 0.867838
	.float -0.789031
	.float 0.684491
	.float -0.572566
	.float 0.507171
	.float -0.534037
	.float 0.636083
	.float -0.731467
	.float 0.737994
	.float -0.647131
	.float 0.531927
	.float -0.470163
	.float 0.448370
	.float -0.342691
	.float 0.014691
	.float 0.542496
	.float -1.130957
	.float 1.429007
	.float -1.192116
	.float 0.438731
	.float 0.517332
	.float -1.226123
	.float 1.358262
	.float -0.896331
	.float 0.140865
	.float 0.470023
	.float -0.613148
	.float 0.253723
	.float 0.355814
	.float -0.840403
	.float 0.926637
	.float -0.594875
	.float 0.073878
	.float 0.312377
	.float -0.348485
	.float 0.055062
	.float 0.336602
	.float -0.540264
	.float 0.395568
	.float 0.041262
	.float -0.543819
	.float 0.853344
	.float -0.812762
	.float 0.424335
	.float 0.176138
	.float -0.785246
	.float 1.195120
	.float -1.244107
	.float 0.868893
	.float -0.155246
	.float -0.649769
	.float 1.208526
	.float -1.242858
	.float 0.689290
	.float 0.244410
	.float -1.173369
	.float 1.731083
	.float -1.745306
	.float 1.290772
	.float -0.605724
	.float -0.052815
	.float 0.519046
	.float -0.745964
	.float 0.767870
	.float -0.645483
	.float 0.430818
	.float -0.161104
	.float -0.127059
	.float 0.380597
	.float -0.527620
	.float 0.502152
	.float -0.289377
	.float -0.039187
	.float 0.337914
	.float -0.456471
	.float 0.330242
	.float -0.027189
	.float -0.290929
	.float 0.473653
	.float -0.479653
	.float 0.393568
	.float -0.348447
	.float 0.414711
	.float -0.545381
	.float 0.622697
	.float -0.567896
	.float 0.420449
	.float -0.314350
	.float 0.363096
	.float -0.544696
	.float 0.686849
	.float -0.578047
	.float 0.129176
	.float 0.536529
	.float -1.140491
	.float 1.418834
	.float -1.286731
	.float 0.882010
	.float -0.463821
	.float 0.244994
	.float -0.275972
	.float 0.447836
	.float -0.591036
	.float 0.587364
	.float -0.422788
	.float 0.165198
	.float 0.097214
	.float -0.308148
	.float 0.459049
	.float -0.571055
	.float 0.662981
	.float -0.727848
	.float 0.732754
	.float -0.643570
	.float 0.459043
	.float -0.228849
	.float 0.036626
	.float 0.046792
	.float -0.010565
	.float -0.082454
	.float 0.127794
	.float -0.038358
	.float -0.204346
	.float 0.534729
	.float -0.829444
	.float 0.962831
	.float -0.867647
	.float 0.574423
	.float -0.207115
	.float -0.069787
	.float 0.130045
	.float 0.052198
	.float -0.393189
	.float 0.745952
	.float -0.972223
	.float 0.999944
	.float -0.844257
	.float 0.592818
	.float -0.366365
	.float 0.266425
	.float -0.326245
	.float 0.489369
	.float -0.635665
	.float 0.647894
	.float -0.479557
	.float 0.178348
	.float 0.148727
	.float -0.398176
	.float 0.513335
	.float -0.485176
	.float 0.327771
	.float -0.061757
	.float -0.278905
	.float 0.633779
	.float -0.921945
	.float 1.072894
	.float -1.060743
	.float 0.914116
	.float -0.694059
	.float 0.457597
	.float -0.233314
	.float 0.022595
	.float 0.178319
	.float -0.352211
	.float 0.448710
	.float -0.398232
	.float 0.153124
	.float 0.262419
	.float -0.728057
	.float 1.059735
	.float -1.096395
	.float 0.793857
	.float -0.262133
	.float -0.284287
	.float 0.633111
	.float -0.669559
	.float 0.408730
	.float 0.035367
	.float -0.506927
	.float 0.858414
	.float -0.987024
	.float 0.864309
	.float -0.551732
	.float 0.182300
	.float 0.097889
	.float -0.201232
	.float 0.137938
	.float 0.002279
	.float -0.110462
	.float 0.118194
	.float -0.023187
	.float -0.123967
	.float 0.253261
	.float -0.307602
	.float 0.263479
	.float -0.139076
	.float -0.008854
	.float 0.101321
	.float -0.068647
	.float -0.109004
	.float 0.372639
	.float -0.595232
	.float 0.644610
	.float -0.471686
	.float 0.162581
	.float 0.098761
	.float -0.149194
	.float -0.033140
	.float 0.303418
	.float -0.451022
	.float 0.356789
	.float -0.085310
	.float -0.160291
	.float 0.185205
	.float 0.062208
	.float -0.464062
	.float 0.820413
	.float -0.973511
	.float 0.881584
	.float -0.610764
	.float 0.275749
	.float 0.021457
	.float -0.227232
	.float 0.344375
	.float -0.417161
	.float 0.495202
	.float -0.587912
	.float 0.639433
	.float -0.555100
	.float 0.276615
	.float 0.143326
	.float -0.531277
	.float 0.673729
	.float -0.445252
	.float -0.100045
	.float 0.739210
	.float -1.191064
	.float 1.260005
	.float -0.928353
	.float 0.348637
	.float 0.250975
	.float -0.687648
	.float 0.901270
	.float -0.949685
	.float 0.933834
	.float -0.909579
	.float 0.851657
	.float -0.697626
	.float 0.437545
	.float -0.170975
	.float 0.068988
	.float -0.251196
	.float 0.665536
	.float -1.075466
	.float 1.188262
	.float -0.849961
	.float 0.169127
	.float 0.527993
	.float -0.889455
	.float 0.748530
	.float -0.213571
	.float -0.413668
	.float 0.822740
	.float -0.856372
	.float 0.561795
	.float -0.130217
	.float -0.213025
	.float 0.302866
	.float -0.085286
	.float -0.372803
	.float 0.907520
	.float -1.315853
	.float 1.439379
	.float -1.242903
	.float 0.841592
	.float -0.447371
	.float 0.252242
	.float -0.313554
	.float 0.516181
	.float -0.644911
	.float 0.528422
	.float -0.163684
	.float -0.264492
	.float 0.487682
	.float -0.318782
	.float -0.225725
	.float 0.922100
	.float -1.455363
	.float 1.585401
	.float -1.267924
	.float 0.665229
	.float -0.045562
	.float -0.367626
	.float 0.508748
	.float -0.482162
	.float 0.473105
	.float -0.619920
	.float 0.930330
	.float -1.288793
	.float 1.538551
	.float -1.576051
	.float 1.398451
	.float -1.086715
	.float 0.750336
	.float -0.475283
	.float 0.300100
	.float -0.217965
	.float 0.190153
	.float -0.162971
	.float 0.091201
	.float 0.032036
	.float -0.155600
	.float 0.187214
	.float -0.053977
	.float -0.226235
	.float 0.520181
	.float -0.636640
	.float 0.440001
	.float 0.055834
	.float -0.680229
	.float 1.190468
	.float -1.389554
	.float 1.206768
	.float -0.710970
	.float 0.073905
	.float 0.485989
	.float -0.767909
	.float 0.661288
	.float -0.209154
	.float -0.381136
	.float 0.815581
	.float -0.861341
	.float 0.483399
	.float 0.123430
	.float -0.641757
	.float 0.818774
	.float -0.614421
	.float 0.214816
	.float 0.096311
	.float -0.120493
	.float -0.137275
	.float 0.485903
	.float -0.679419
	.float 0.570360
	.float -0.189817
	.float -0.282898
	.float 0.627058
	.float -0.693650
	.float 0.469197
	.float -0.072251
	.float -0.304491
	.float 0.482109
	.float -0.383703
	.float 0.084720
	.float 0.211873
	.float -0.281854
	.float 0.018323
	.float 0.486043
	.float -0.979674
	.float 1.202077
	.float -1.046812
	.float 0.625323
	.float -0.187865
	.float -0.040879
	.float -0.002952
	.float 0.202690
	.float -0.358503
	.float 0.326272
	.float -0.105805
	.float -0.169961
	.float 0.326123
	.float -0.254237
	.float -0.026582
	.float 0.385392
	.float -0.656150
	.float 0.727959
	.float -0.597697
	.float 0.357871
	.float -0.130399
	.float -0.011024
	.float 0.080330
	.float -0.154221
	.float 0.299209
	.float -0.502161
	.float 0.658362
	.float -0.635913
	.float 0.378764
	.float 0.025061
	.float -0.370243
	.float 0.453586
	.float -0.212643
	.float -0.214342
	.float 0.558635
	.float -0.582852
	.float 0.228550
	.float 0.349624
	.float -0.884624
	.float 1.163539
	.float -1.149835
	.float 0.986309
	.float -0.883521
	.float 0.969281
	.float -1.195463
	.float 1.361892
	.float -1.246334
	.float 0.764112
	.float -0.055391
	.float -0.565404
	.float 0.779843
	.float -0.455869
	.float -0.263084
	.float 1.030363
	.float -1.484619
	.float 1.435325
	.float -0.937468
	.float 0.229544
	.float 0.404798
	.float -0.761292
	.float 0.770731
	.float -0.487491
	.float 0.044140
	.float 0.399866
	.float -0.705703
	.float 0.795892
	.float -0.678304
	.float 0.438296
	.float -0.196430
	.float 0.049091
	.float -0.024415
	.float 0.077131
	.float -0.123667
	.float 0.094169
	.float 0.029409
	.float -0.209111
	.float 0.377917
	.float -0.477057
	.float 0.478526
	.float -0.381023
	.float 0.188175
	.float 0.106154
	.float -0.503926
	.float 0.963091
	.float -1.364590
	.float 1.529627
	.float -1.303895
	.float 0.671458
	.float 0.180658
	.float -0.914068
	.float 1.202941
	.float -0.920753
	.float 0.227744
	.float 0.509192
	.float -0.922536
	.float 0.846951
	.float -0.391184
	.float -0.158734
	.float 0.529293
	.float -0.611905
	.float 0.486514
	.float -0.322055
	.float 0.241644
	.float -0.251004
	.float 0.268479
	.float -0.217274
	.float 0.100400
	.float -0.001002
	.float 0.012350
	.float -0.153948
	.float 0.338891
	.float -0.419489
	.float 0.282426
	.float 0.070242
	.float -0.509383
	.float 0.846531
	.float -0.939375
	.float 0.769587
	.float -0.445807
	.float 0.134364
	.float 0.035481
	.float -0.031243
	.float -0.089888
	.float 0.239107
	.float -0.356249
	.float 0.428729
	.float -0.464241
	.float 0.452480
	.float -0.358759
	.float 0.160440
	.float 0.107230
	.float -0.345094
	.float 0.442898
	.float -0.357316
	.float 0.153065
	.float 0.030364
	.float -0.066149
	.float -0.081000
	.float 0.338572
	.float -0.577305
	.float 0.686924
	.float -0.626825
	.float 0.431411
	.float -0.181456
	.float -0.036446
	.float 0.168298
	.float -0.219357
	.float 0.253686
	.float -0.354050
	.float 0.554191
	.float -0.789219
	.float 0.913815
	.float -0.794331
	.float 0.418181
	.float 0.063995
	.float -0.407394
	.float 0.417096
	.float -0.072653
	.float -0.451854
	.float 0.887783
	.float -1.029272
	.float 0.849285
	.float -0.504727
	.float 0.230367
	.float -0.191427
	.float 0.388722
	.float -0.674394
	.float 0.861904
	.float -0.851463
	.float 0.685743
	.float -0.504167
	.float 0.437116
	.float -0.518306
	.float 0.672435
	.float -0.775965
	.float 0.740089
	.float -0.558438
	.float 0.295834
	.float -0.037611
	.float -0.158481
	.float 0.277468
	.float -0.329989
	.float 0.328957
	.float -0.285260
	.float 0.223102
	.float -0.189490
	.float 0.232528
	.float -0.354589
	.float 0.482311
	.float -0.495828
	.float 0.314270
	.float 0.023850
	.float -0.360634
	.float 0.518521
	.float -0.433655
	.float 0.215646
	.float -0.075375
	.float 0.167570
	.float -0.469227
	.float 0.791291
	.float -0.916151
	.float 0.754124
	.float -0.398846
	.float 0.045539
	.float 0.155969
	.float -0.195087
	.float 0.173997
	.float -0.195248
	.float 0.265187
	.float -0.294556
	.float 0.190864
	.float 0.040969
	.float -0.278410
	.float 0.359948
	.float -0.199387
	.float -0.151140
	.float 0.530258
	.float -0.757346
	.float 0.719047
	.float -0.409212
	.float -0.077331
	.float 0.577028
	.float -0.905952
	.float 0.926824
	.float -0.622280
	.float 0.131628
	.float 0.295665
	.float -0.429813
	.float 0.203910
	.float 0.229554
	.float -0.580920
	.float 0.598085
	.float -0.218375
	.float -0.401866
	.float 0.989510
	.float -1.309299
	.float 1.270204
	.float -0.935173
	.float 0.456945
	.float 0.002355
	.float -0.325965
	.float 0.463704
	.float -0.430609
	.float 0.290419
	.float -0.126366
	.float 0.006522
	.float 0.039298
	.float -0.017169
	.float -0.053602
	.float 0.160581
	.float -0.295321
	.float 0.430123
	.float -0.500182
	.float 0.417856
	.float -0.120792
	.float -0.373101
	.float 0.943655
	.float -1.402293
	.float 1.572662
	.float -1.378583
	.float 0.890215
	.float -0.296440
	.float -0.188431
	.float 0.432833
	.float -0.443369
	.float 0.329753
	.float -0.205747
	.float 0.103494
	.float 0.028538
	.float -0.244132
	.float 0.509940
	.float -0.696574
	.float 0.669750
	.float -0.408807
	.float 0.047678
	.float 0.204486
	.float -0.204151
	.float -0.033954
	.float 0.358971
	.float -0.592338
	.float 0.634068
	.float -0.497241
	.float 0.269619
	.float -0.050669
	.float -0.092563
	.float 0.142127
	.float -0.128093
	.float 0.112497
	.float -0.152213
	.float 0.251781
	.float -0.343129
	.float 0.325178
	.float -0.147563
	.float -0.126994
	.float 0.344828
	.float -0.363963
	.float 0.158853
	.float 0.160668
	.float -0.435256
	.float 0.577558
	.float -0.629871
	.float 0.713482
	.float -0.913141
	.float 1.190346
	.float -1.393655
	.float 1.359633
	.float -1.031874
	.float 0.513842
	.float -0.016819
	.float -0.263072
	.float 0.256614
	.float -0.047203
	.float -0.202463
	.float 0.364157
	.float -0.412819
	.float 0.404855
	.float -0.396122
	.float 0.377929
	.float -0.288544
	.float 0.088214
	.float 0.172897
	.float -0.359993
	.float 0.337258
	.float -0.067939
	.float -0.345794
	.float 0.715408
	.float -0.874431
	.float 0.768311
	.float -0.469382
	.float 0.116580
	.float 0.170363
	.float -0.343326
	.float 0.420225
	.float -0.442859
	.float 0.440537
	.float -0.423408
	.float 0.394879
	.float -0.357936
	.float 0.308395
	.float -0.233829
	.float 0.133378
	.float -0.041670
	.float 0.017559
	.float -0.086059
	.float 0.181358
	.float -0.164247
	.float -0.066746
	.float 0.448683
	.float -0.735559
	.float 0.642929
	.float -0.070567
	.float -0.769623
	.float 1.443212
	.float -1.560892
	.float 1.040860
	.float -0.174584
	.float -0.556573
	.float 0.787169
	.float -0.483703
	.float -0.070042
	.float 0.490892
	.float -0.550940
	.float 0.293865
	.float 0.045680
	.float -0.233733
	.float 0.190788
	.float -0.011675
	.float -0.133790
	.float 0.128250
	.float 0.024133
	.float -0.213799
	.float 0.297240
	.float -0.176097
	.float -0.151448
	.float 0.584461
	.float -0.962635
	.float 1.146777
	.float -1.098634
	.float 0.908375
	.float -0.738960
	.float 0.712395
	.float -0.815012
	.float 0.898391
	.float -0.788146
	.float 0.426413
	.float 0.061450
	.float -0.436406
	.float 0.509520
	.float -0.282784
	.float -0.037288
	.float 0.166295
	.float 0.078322
	.float -0.663518
	.float 1.360015
	.float -1.869860
	.float 1.976438
	.float -1.635079
	.float 0.974527
	.float -0.230375
	.float -0.349302
	.float 0.593614
	.float -0.471266
	.float 0.104407
	.float 0.282763
	.float -0.470816
	.float 0.359781
	.float -0.025011
	.float -0.326144
	.float 0.476482
	.float -0.328624
	.float -0.035533
	.float 0.400068
	.float -0.538612
	.float 0.346634
	.float 0.091991
	.float -0.545640
	.float 0.767393
	.float -0.647683
	.float 0.292950
	.float 0.028837
	.float -0.052656
	.float -0.310267
	.float 0.906733
	.float -1.430884
	.float 1.609149
	.float -1.356250
	.float 0.804545
	.float -0.203457
	.float -0.227116
	.float 0.391160
	.float -0.318633
	.float 0.107345
	.float 0.136444
	.float -0.327491
	.float 0.411412
	.float -0.375459
	.float 0.259018
	.float -0.142119
	.float 0.101485
	.float -0.157588
	.float 0.254094
	.float -0.291458
	.float 0.193728
	.float 0.038301
	.float -0.322394
	.float 0.537370
	.float -0.582911
	.float 0.423945
	.float -0.103308
	.float -0.275738
	.float 0.585620
	.float -0.717381
	.float 0.620242
	.float -0.328728
	.float -0.034011
	.float 0.290151
	.float -0.282528
	.float -0.031659
	.float 0.524267
	.float -0.934484
	.float 1.008626
	.float -0.667998
	.float 0.085750
	.float 0.401275
	.float -0.504009
	.float 0.173853
	.float 0.363349
	.float -0.760249
	.float 0.780173
	.float -0.444647
	.float -0.001927
	.float 0.274155
	.float -0.238265
	.float -0.016688
	.float 0.264381
	.float -0.306997
	.float 0.098155
	.float 0.253099
	.float -0.578810
	.float 0.763218
	.float -0.789315
	.float 0.705474
	.float -0.561595
	.float 0.375718
	.float -0.151210
	.float -0.087214
	.float 0.285969
	.float -0.398223
	.float 0.429226
	.float -0.440299
	.float 0.494197
	.float -0.583489
	.float 0.611905
	.float -0.463680
	.float 0.117642
	.float 0.289616
	.float -0.521224
	.float 0.393759
	.float 0.082545
	.float -0.686772
	.float 1.111742
	.float -1.141540
	.float 0.758300
	.float -0.118716
	.float -0.558209
	.float 1.096961
	.float -1.401595
	.float 1.432762
	.float -1.182599
	.float 0.684763
	.float -0.043792
	.float -0.563794
	.float 0.943467
	.float -0.968727
	.float 0.645039
	.float -0.109222
	.float -0.435047
	.float 0.808086
	.float -0.924619
	.float 0.814485
	.float -0.592025
	.float 0.393583
	.float -0.312413
	.float 0.358747
	.float -0.460405
	.float 0.501023
	.float -0.376991
	.float 0.047098
	.float 0.444385
	.float -0.978387
	.float 1.400272
	.float -1.574877
	.float 1.439623
	.float -1.034831
	.float 0.493768
	.float 0.009360
	.float -0.332123
	.float 0.419787
	.float -0.314466
	.float 0.116934
	.float 0.070132
	.float -0.182699
	.float 0.204466
	.float -0.153666
	.float 0.064870
	.float 0.025649
	.float -0.091961
	.float 0.127847
	.float -0.147236
	.float 0.172217
	.float -0.215409
	.float 0.269918
	.float -0.313501
	.float 0.321742
	.float -0.281239
	.float 0.199589
	.float -0.111662
	.float 0.076564
	.float -0.154961
	.float 0.368720
	.float -0.667622
	.float 0.935876
	.float -1.048594
	.float 0.946981
	.float -0.679100
	.float 0.373685
	.float -0.162579
	.float 0.104298
	.float -0.157232
	.float 0.214000
	.float -0.168993
	.float -0.024124
	.float 0.334513
	.float -0.678510
	.float 0.965278
	.float -1.135132
	.float 1.170877
	.float -1.082560
	.float 0.885464
	.float -0.593441
	.float 0.232527
	.float 0.143563
	.float -0.461377
	.float 0.664090
	.float -0.749364
	.float 0.771852
	.float -0.799907
	.float 0.858527
	.float -0.907231
	.float 0.874318
	.float -0.719032
	.float 0.469531
	.float -0.206978
	.float 0.013523
	.float 0.072839
	.float -0.067091
	.float 0.014114
	.float 0.042529
	.float -0.081310
	.float 0.108155
	.float -0.147270
	.float 0.219686
	.float -0.318755
	.float 0.400754
	.float -0.405359
	.float 0.297958
	.float -0.103232
	.float -0.098477
	.float 0.212762
	.float -0.182765
	.float 0.018886
	.float 0.205460
	.float -0.382963
	.float 0.412962
	.float -0.243480
	.float -0.095656
	.float 0.487101
	.float -0.764028
	.float 0.784227
	.float -0.503115
	.float 0.000139
	.float 0.558370
	.float -0.994925
	.float 1.188495
	.float -1.103647
	.float 0.784480
	.float -0.334608
	.float -0.106292
	.float 0.396015
	.float -0.438811
	.float 0.232599
	.float 0.119139
	.float -0.450209
	.float 0.611074
	.float -0.539131
	.float 0.281319
	.float 0.035451
	.float -0.261537
	.float 0.281087
	.float -0.053319
	.float -0.365781
	.float 0.829774
	.float -1.147632
	.float 1.165384
	.float -0.850340
	.float 0.325509
	.float 0.180877
	.float -0.455690
	.float 0.423903
	.float -0.194841
	.float -0.005026
	.float -0.023078
	.float 0.319217
	.float -0.734414
	.float 1.023699
	.float -1.003068
	.float 0.666823
	.float -0.189613
	.float -0.184363
	.float 0.286858
	.float -0.108992
	.float -0.225451
	.float 0.563362
	.float -0.817745
	.float 0.985161
	.float -1.085132
	.float 1.089725
	.float -0.920303
	.float 0.525755
	.float 0.025374
	.float -0.533206
	.float 0.769369
	.float -0.626417
	.float 0.194569
	.float 0.301123
	.float -0.655614
	.float 0.805972
	.float -0.828695
	.float 0.830314
	.float -0.839100
	.float 0.792393
	.float -0.619347
	.float 0.332933
	.float -0.044431
	.float -0.109877
	.float 0.064667
	.float 0.131462
	.float -0.348554
	.float 0.449005
	.float -0.352110
	.float 0.063684
	.float 0.328048
	.float -0.683264
	.float 0.864160
	.float -0.799609
	.float 0.529549
	.float -0.194113
	.float -0.039781
	.float 0.075635
	.float 0.054175
	.float -0.211116
	.float 0.243477
	.float -0.091083
	.float -0.167631
	.float 0.361954
	.float -0.345502
	.float 0.107517
	.float 0.202887
	.float -0.369992
	.float 0.266627
	.float 0.041626
	.float -0.329124
	.float 0.366309
	.float -0.085947
	.float -0.367048
	.float 0.739764
	.float -0.847458
	.float 0.688202
	.float -0.418044
	.float 0.220856
	.float -0.181769
	.float 0.254405
	.float -0.327500
	.float 0.320841
	.float -0.234024
	.float 0.125238
	.float -0.056767
	.float 0.056989
	.float -0.116958
	.float 0.204939
	.float -0.278406
	.float 0.294633
	.float -0.231028
	.float 0.110428
	.float -0.004224
	.float -0.007703
	.float -0.098023
	.float 0.250010
	.float -0.313438
	.float 0.181952
	.float 0.131803
	.float -0.477131
	.float 0.642655
	.float -0.488842
	.float 0.050910
	.float 0.461293
	.float -0.779214
	.float 0.742161
	.float -0.406667
	.float 0.016910
	.float 0.155676
	.float -0.000178
	.float -0.350303
	.float 0.603855
	.float -0.507660
	.float 0.020792
	.float 0.657262
	.float -1.215566
	.float 1.422095
	.float -1.245541
	.float 0.839524
	.float -0.420347
	.float 0.133754
	.float 0.004133
	.float -0.071098
	.float 0.152303
	.float -0.269983
	.float 0.372317
	.float -0.379601
	.float 0.250200
	.float -0.020538
	.float -0.208383
	.float 0.331193
	.float -0.306812
	.float 0.187243
	.float -0.081438
	.float 0.075825
	.float -0.169702
	.float 0.277518
	.float -0.298384
	.float 0.196537
	.float -0.024885
	.float -0.127061
	.float 0.211512
	.float -0.253686
	.float 0.307236
	.float -0.379005
	.float 0.400813
	.float -0.285034
	.float 0.019624
	.float 0.288044
	.float -0.473889
	.float 0.450483
	.float -0.303138
	.float 0.254798
	.float -0.503505
	.float 1.044711
	.float -1.622341
	.float 1.869976
	.float -1.560600
	.float 0.787610
	.float 0.066129
	.float -0.566301
	.float 0.510209
	.float -0.052574
	.float -0.415889
	.float 0.544916
	.float -0.253675
	.float -0.244619
	.float 0.620194
	.float -0.659613
	.float 0.387881
	.float -0.015852
	.float -0.219260
	.float 0.196559
	.float 0.045557
	.float -0.363719
	.float 0.604126
	.float -0.679082
	.float 0.597101
	.float -0.443893
	.float 0.326007
	.float -0.302684
	.float 0.344480
	.float -0.351624
	.float 0.230046
	.float 0.024023
	.float -0.297229
	.float 0.420336
	.float -0.280791
	.float -0.094207
	.float 0.547628
	.float -0.888940
	.float 1.005118
	.float -0.905961
	.float 0.679592
	.float -0.408306
	.float 0.122334
	.float 0.173889
	.float -0.442615
	.float 0.595504
	.float -0.552177
	.float 0.327986
	.float -0.062181
	.float -0.058812
	.float -0.066762
	.float 0.376946
	.float -0.691662
	.float 0.850825
	.float -0.833262
	.float 0.759495
	.float -0.778767
	.float 0.935325
	.float -1.122269
	.float 1.157447
	.float -0.917236
	.float 0.425560
	.float 0.162110
	.float -0.654618
	.float 0.922115
	.float -0.931575
	.float 0.720308
	.float -0.357156
	.float -0.066906
	.float 0.426547
	.float -0.575606
	.float 0.416473
	.float 0.008327
	.float -0.484362
	.float 0.713995
	.float -0.495005
	.float -0.128507
	.float 0.863773
	.float -1.337098
	.float 1.323233
	.float -0.874961
	.float 0.262816
	.float 0.220628
	.float -0.440242
	.float 0.455326
	.float -0.411910
	.float 0.399979
	.float -0.395410
	.float 0.316207
	.float -0.121493
	.float -0.142173
	.float 0.379813
	.float -0.522804
	.float 0.565857
	.float -0.539635
	.float 0.458691
	.float -0.304178
	.float 0.060408
	.float 0.232462
	.float -0.468279
	.float 0.529400
	.float -0.371450
	.float 0.071703
	.float 0.202461
	.float -0.291424
	.float 0.143756
	.float 0.149546
	.float -0.411668
	.float 0.489381
	.float -0.341413
	.float 0.048555
	.float 0.252989
	.float -0.459293
	.float 0.542925
	.float -0.533099
	.float 0.466080
	.float -0.359275
	.float 0.228647
	.float -0.119022
	.float 0.099798
	.float -0.213356
	.float 0.416279
	.float -0.572876
	.float 0.524762
	.float -0.197860
	.float -0.329151
	.float 0.850966
	.float -1.149361
	.float 1.123869
	.float -0.853517
	.float 0.545542
	.float -0.402721
	.float 0.496695
	.float -0.731458
	.float 0.919081
	.float -0.911815
	.float 0.697337
	.float -0.393714
	.float 0.153241
	.float -0.049087
	.float 0.028989
	.float 0.029885
	.float -0.206349
	.float 0.450370
	.float -0.600636
	.float 0.500772
	.float -0.130724
	.float -0.351457
	.float 0.700634
	.float -0.749230
	.float 0.525862
	.float -0.238705
	.float 0.134691
	.float -0.336501
	.float 0.770263
	.float -1.225584
	.float 1.494648
	.float -1.489987
	.float 1.269200
	.float -0.968685
	.float 0.707903
	.float -0.531269
	.float 0.413469
	.float -0.305239
	.float 0.178207
	.float -0.043445
	.float -0.055462
	.float 0.064447
	.float 0.051362
	.float -0.276475
	.float 0.529254
	.float -0.684748
	.float 0.639686
	.float -0.385357
	.float 0.031896
	.float 0.247605
	.float -0.324284
	.float 0.197277
	.float 0.008385
	.float -0.127287
	.float 0.058035
	.float 0.185825
	.float -0.501732
	.float 0.764630
	.float -0.879599
	.float 0.797529
	.float -0.510951
	.float 0.056948
	.float 0.473245
	.float -0.943959
	.float 1.220872
	.float -1.233044
	.float 1.006179
	.float -0.640977
	.float 0.255097
	.float 0.065322
	.float -0.276978
	.float 0.366729
	.float -0.345451
	.float 0.255558
	.float -0.167835
	.float 0.146827
	.float -0.203967
	.float 0.286835
	.float -0.328084
	.float 0.315214
	.float -0.309572
	.float 0.383792
	.float -0.529942
	.float 0.631728
	.float -0.543161
	.float 0.215363
	.float 0.240436
	.float -0.615962
	.float 0.746941
	.float -0.616745
	.float 0.343717
	.float -0.076939
	.float -0.100842
	.float 0.186424
	.float -0.197044
	.float 0.117551
	.float 0.083575
	.float -0.387035
	.float 0.683603
	.float -0.823512
	.float 0.729279
	.float -0.475274
	.float 0.251541
	.float -0.224634
	.float 0.403710
	.float -0.627511
	.float 0.692539
	.float -0.523421
	.float 0.244548
	.float -0.088265
	.float 0.207503
	.float -0.540404
	.float 0.836024
	.float -0.826675
	.float 0.422145
	.float 0.214091
	.float -0.758464
	.float 0.924801
	.float -0.633561
	.float 0.048290
	.float 0.532321
	.float -0.846754
	.float 0.797117
	.float -0.464905
	.float 0.030631
	.float 0.330859
	.float -0.512900
	.float 0.481161
	.float -0.251377
	.float -0.121481
	.float 0.537534
	.float -0.857213
	.float 0.941622
	.float -0.718344
	.float 0.231827
	.float 0.360395
	.float -0.851001
	.float 1.074212
	.float -0.978235
	.float 0.644604
	.float -0.246828
	.float -0.031258
	.float 0.079424
	.float 0.092535
	.float -0.369215
	.float 0.597942
	.float -0.675338
	.float 0.603548
	.float -0.482821
	.float 0.442844
	.float -0.553717
	.float 0.774999
	.float -0.980303
	.float 1.045024
	.float -0.934878
	.float 0.727199
	.float -0.545187
	.float 0.457180
	.float -0.425539
	.float 0.349943
	.float -0.165946
	.float -0.091533
	.float 0.319807
	.float -0.445523
	.float 0.493592
	.float -0.558963
	.float 0.703835
	.float -0.877212
	.float 0.937149
	.float -0.763539
	.float 0.365999
	.float 0.107190
	.float -0.468279
	.float 0.616224
	.float -0.588801
	.float 0.505023
	.float -0.453854
	.float 0.425659
	.float -0.340963
	.float 0.144320
	.float 0.125612
	.float -0.356950
	.float 0.459290
	.float -0.443372
	.float 0.405844
	.float -0.427101
	.float 0.478255
	.float -0.435473
	.float 0.204060
	.float 0.156009
	.float -0.429438
	.float 0.394620
	.float -0.010655
	.float -0.517439
	.float 0.864592
	.float -0.815444
	.float 0.421104
	.float 0.040263
	.float -0.268743
	.float 0.156501
	.float 0.149311
	.float -0.372907
	.float 0.321232
	.float -0.020189
	.float -0.317673
	.float 0.457579
	.float -0.310103
	.float -0.016849
	.float 0.306878
	.float -0.388084
	.float 0.238694
	.float 0.018315
	.float -0.210795
	.float 0.226866
	.float -0.069226
	.float -0.163699
	.float 0.340203
	.float -0.358589
	.float 0.186123
	.float 0.129617
	.float -0.473528
	.float 0.699871
	.float -0.690092
	.float 0.413227
	.float 0.042550
	.float -0.493288
	.float 0.734680
	.float -0.635323
	.float 0.199527
	.float 0.431909
	.float -1.042356
	.float 1.430196
	.float -1.487296
	.float 1.231697
	.float -0.784486
	.float 0.306929
	.float 0.068809
	.float -0.283316
	.float 0.352607
	.float -0.338566
	.float 0.309170
	.float -0.308327
	.float 0.344274
	.float -0.395469
	.float 0.429667
	.float -0.427566
	.float 0.397928
	.float -0.370034
	.float 0.363567
	.float -0.357284
	.float 0.287183
	.float -0.086920
	.float -0.251955
	.float 0.645945
	.float -0.945545
	.float 1.012590
	.float -0.802089
	.float 0.394972
	.float 0.039599
	.float -0.328987
	.float 0.378830
	.float -0.207807
	.float -0.077498
	.float 0.346909
	.float -0.511675
	.float 0.556498
	.float -0.525418
	.float 0.473930
	.float -0.419295
	.float 0.323822
	.float -0.127332
	.float -0.189216
	.float 0.556340
	.float -0.829086
	.float 0.866065
	.float -0.627252
	.float 0.218635
	.float 0.156573
	.float -0.315033
	.float 0.201338
	.float 0.085303
	.float -0.360443
	.float 0.468920
	.float -0.369897
	.float 0.145084
	.float 0.062669
	.float -0.136232
	.float 0.047301
	.float 0.132462
	.float -0.273587
	.float 0.262715
	.float -0.071417
	.float -0.220450
	.float 0.466825
	.float -0.544254
	.float 0.431822
	.float -0.226026
	.float 0.076885
	.float -0.089266
	.float 0.259597
	.float -0.489459
	.float 0.658085
	.float -0.694816
	.float 0.602833
	.float -0.430559
	.float 0.227526
	.float -0.022080
	.float -0.170533
	.float 0.329443
	.float -0.421707
	.float 0.413507
	.float -0.288104
	.float 0.059042
	.float 0.225660
	.float -0.488752
	.float 0.641248
	.float -0.614364
	.float 0.396018
	.float -0.049701
	.float -0.303746
	.float 0.537754
	.float -0.576292
	.float 0.420681
	.float -0.133556
	.float -0.203660
	.float 0.529412
	.float -0.815850
	.float 1.057783
	.float -1.251207
	.float 1.378625
	.float -1.410152
	.float 1.319838
	.float -1.107381
	.float 0.811024
	.float -0.499494
	.float 0.243966
	.float -0.085868
	.float 0.021536
	.float -0.013634
	.float 0.019295
	.float -0.013619
	.float -0.006284
	.float 0.034355
	.float -0.070265
	.float 0.122524
	.float -0.199922
	.float 0.301504
	.float -0.414843
	.float 0.522664
	.float -0.609557
	.float 0.661390
	.float -0.659482
	.float 0.581036
	.float -0.414953
	.float 0.187352
	.float 0.026246
	.float -0.125462
	.float 0.045406
	.float 0.183619
	.float -0.428043
	.float 0.519075
	.float -0.364166
	.float 0.025680
	.float 0.297319
	.float -0.383750
	.float 0.129991
	.float 0.379002
	.float -0.914208
	.float 1.232439
	.float -1.209635
	.float 0.900081
	.float -0.494263
	.float 0.206403
	.float -0.156185
	.float 0.307710
	.float -0.497542
	.float 0.536022
	.float -0.323920
	.float -0.085792
	.float 0.519818
	.float -0.788894
	.float 0.794560
	.float -0.569630
	.float 0.234052
	.float 0.090039
	.float -0.338602
	.float 0.506137
	.float -0.604275
	.float 0.625860
	.float -0.545339
	.float 0.347871
	.float -0.055644
	.float -0.270452
	.float 0.550186
	.float -0.706729
	.float 0.683728
	.float -0.460831
	.float 0.070608
	.float 0.394775
	.float -0.804500
	.float 1.038243
	.float -1.036181
	.float 0.815677
	.float -0.446701
	.float 0.014009
	.float 0.398366
	.float -0.697272
	.float 0.780683
	.float -0.581710
	.float 0.140021
	.float 0.365259
	.float -0.679183
	.float 0.614981
	.float -0.184991
	.float -0.384638
	.float 0.780361
	.float -0.789154
	.float 0.422002
	.float 0.105789
	.float -0.514643
	.float 0.622474
	.float -0.428439
	.float 0.083502
	.float 0.214575
	.float -0.329801
	.float 0.243965
	.float -0.045717
	.float -0.127253
	.float 0.159529
	.float -0.011944
	.float -0.263800
	.float 0.556987
	.float -0.760684
	.float 0.828234
	.float -0.785398
	.float 0.690214
	.float -0.574804
	.float 0.421474
	.float -0.196139
	.float -0.091012
	.float 0.357075
	.float -0.484821
	.float 0.403082
	.float -0.145127
	.float -0.163470
	.float 0.379688
	.float -0.424720
	.float 0.315846
	.float -0.132826
	.float -0.049114
	.float 0.207846
	.float -0.371793
	.float 0.572810
	.float -0.793025
	.float 0.949717
	.float -0.934714
	.float 0.685424
	.float -0.238333
	.float -0.275543
	.float 0.694112
	.float -0.906891
	.float 0.904355
	.float -0.765754
	.float 0.598991
	.float -0.475772
	.float 0.403055
	.float -0.343311
	.float 0.260728
	.float -0.154715
	.float 0.055467
	.float 0.009991
	.float -0.046706
	.float 0.086337
	.float -0.151632
	.float 0.226382
	.float -0.262625
	.float 0.220795
	.float -0.103136
	.float -0.053266
	.float 0.216150
	.float -0.387190
	.float 0.587239
	.float -0.812097
	.float 1.008039
	.float -1.100732
	.float 1.056031
	.float -0.913430
	.float 0.753075
	.float -0.621446
	.float 0.485375
	.float -0.265824
	.float -0.069828
	.float 0.438624
	.float -0.668895
	.float 0.619246
	.float -0.302831
	.float -0.086213
	.float 0.279175
	.float -0.105011
	.float -0.393088
	.float 0.979519
	.float -1.369916
	.float 1.395819
	.float -1.084083
	.float 0.614027
	.float -0.199517
	.float -0.021200
	.float 0.031001
	.float 0.086841
	.float -0.203516
	.float 0.202667
	.float -0.028367
	.float -0.283707
	.float 0.606841
	.float -0.771256
	.float 0.651006
	.float -0.243614
	.float -0.315933
	.float 0.828275
	.float -1.145180
	.float 1.242888
	.float -1.198002
	.float 1.092145
	.float -0.933897
	.float 0.671324
	.float -0.283531
	.float -0.139723
	.float 0.419692
	.float -0.413877
	.float 0.148505
	.float 0.159790
	.float -0.232522
	.float -0.073002
	.float 0.643131
	.float -1.164588
	.float 1.330693
	.float -1.053628
	.float 0.526187
	.float -0.082336
	.float -0.043508
	.float -0.121032
	.float 0.323321
	.float -0.290015
	.float -0.063074
	.float 0.574673
	.float -0.967097
	.float 1.047083
	.float -0.823146
	.float 0.468387
	.float -0.184968
	.float 0.085494
	.float -0.162772
	.float 0.334325
	.float -0.502033
	.float 0.587149
	.float -0.542746
	.float 0.360607
	.float -0.072941
	.float -0.261702
	.float 0.586935
	.float -0.868819
	.float 1.088956
	.float -1.220672
	.float 1.220240
	.float -1.052740
	.float 0.733994
	.float -0.347278
	.float 0.010938
	.float 0.185067
	.float -0.227024
	.float 0.174992
	.float -0.114511
	.float 0.100716
	.float -0.134524
	.float 0.181463
	.float -0.210437
	.float 0.216942
	.float -0.213489
	.float 0.200834
	.float -0.151833
	.float 0.028536
	.float 0.178057
	.float -0.419856
	.float 0.604278
	.float -0.645564
	.float 0.520789
	.float -0.291205
	.float 0.073026
	.float 0.024481
	.float 0.043026
	.float -0.230822
	.float 0.423638
	.float -0.486928
	.float 0.331404
	.float 0.034114
	.float -0.489375
	.float 0.848522
	.float -0.956695
	.float 0.786450
	.float -0.465922
	.float 0.203736
	.float -0.150470
	.float 0.294424
	.float -0.473391
	.float 0.496653
	.float -0.283098
	.float -0.090682
	.float 0.460769
	.float -0.694583
	.float 0.756270
	.float -0.677133
	.float 0.481787
	.float -0.157521
	.float -0.296450
	.float 0.791267
	.float -1.134521
	.float 1.123109
	.float -0.689174
	.float -0.014637
	.float 0.670361
	.float -0.967380
	.float 0.779059
	.float -0.225254
	.float -0.413254
	.float 0.858581
	.float -0.963839
	.float 0.737022
	.float -0.280149
	.float -0.281668
	.float 0.826108
	.float -1.223408
	.float 1.341679
	.float -1.097289
	.float 0.520125
	.float 0.230803
	.float -0.932499
	.float 1.403998
	.float -1.575410
	.float 1.475505
	.float -1.168582
	.float 0.712234
	.float -0.173115
	.float -0.333556
	.float 0.650183
	.float -0.654651
	.float 0.356872
	.float 0.075763
	.float -0.404900
	.float 0.465961
	.float -0.263857
	.float -0.050779
	.float 0.299889
	.float -0.395240
	.float 0.373009
	.float -0.341621
	.float 0.404932
	.float -0.620075
	.float 0.994484
	.float -1.483847
	.float 1.970358
	.float -2.254605
	.float 2.115260
	.float -1.441212
	.float 0.356464
	.float 0.774025
	.float -1.503301
	.float 1.547304
	.float -0.955216
	.float 0.081510
	.float 0.628736
	.float -0.897285
	.float 0.741389
	.float -0.400340
	.float 0.133900
	.float -0.049873
	.float 0.077770
	.float -0.080892
	.float -0.004840
	.float 0.121050
	.float -0.152303
	.float 0.035162
	.float 0.185896
	.float -0.393479
	.float 0.480654
	.float -0.410580
	.float 0.216472
	.float 0.037467
	.float -0.291325
	.float 0.500862
	.float -0.637317
	.float 0.692768
	.float -0.687892
	.float 0.662353
	.float -0.641987
	.float 0.605077
	.float -0.482782
	.float 0.206391
	.float 0.225152
	.float -0.707408
	.float 1.058421
	.float -1.107754
	.float 0.799755
	.float -0.246509
	.float -0.312443
	.float 0.633695
	.float -0.609136
	.float 0.331088
	.float -0.032875
	.float -0.061399
	.float -0.122660
	.float 0.475111
	.float -0.791419
	.float 0.915004
	.float -0.830180
	.float 0.649575
	.float -0.519448
	.float 0.516119
	.float -0.598374
	.float 0.637466
	.float -0.501932
	.float 0.148726
	.float 0.331324
	.float -0.747350
	.float 0.913171
	.float -0.765462
	.float 0.415111
	.float -0.085737
	.float -0.029844
	.float -0.100291
	.float 0.323756
	.float -0.406745
	.float 0.192101
	.float 0.295271
	.float -0.863144
	.float 1.269757
	.float -1.361743
	.float 1.145534
	.float -0.757081
	.float 0.362982
	.float -0.064526
	.float -0.134703
	.float 0.287444
	.float -0.430466
	.float 0.543006
	.float -0.567761
	.float 0.473015
	.float -0.298762
	.float 0.143205
	.float -0.095893
	.float 0.169213
	.float -0.283389
	.float 0.319935
	.float -0.206729
	.float -0.026709
	.float 0.265453
	.float -0.388257
	.float 0.354297
	.float -0.233079
	.float 0.151548
	.float -0.194940
	.float 0.336444
	.float -0.453386
	.float 0.421101
	.float -0.214554
	.float -0.061663
	.float 0.241093
	.float -0.214774
	.float 0.017200
	.float 0.184095
	.float -0.195232
	.float -0.066587
	.float 0.495428
	.float -0.837998
	.float 0.839899
	.float -0.409537
	.float -0.307996
	.float 1.002496
	.float -1.375009
	.float 1.305657
	.float -0.904501
	.float 0.417975
	.float -0.061745
	.float -0.103241
	.float 0.172810
	.float -0.291097
	.float 0.520593
	.float -0.788101
	.float 0.940713
	.float -0.862214
	.float 0.560158
	.float -0.164278
	.float -0.153537
	.float 0.275633
	.float -0.191993
	.float -0.008699
	.float 0.192184
	.float -0.244464
	.float 0.123627
	.float 0.122782
	.float -0.386719
	.float 0.564873
	.float -0.622083
	.float 0.607625
	.float -0.609858
	.float 0.683967
	.float -0.811239
	.float 0.920101
	.float -0.944782
	.float 0.866932
	.float -0.708809
	.float 0.496290
	.float -0.238456
	.float -0.052727
	.float 0.327071
	.float -0.494651
	.float 0.479850
	.float -0.295185
	.float 0.065672
	.float 0.036139
	.float 0.088239
	.float -0.376168
	.float 0.629547
	.float -0.648860
	.float 0.382102
	.float 0.026640
	.float -0.332918
	.float 0.365906
	.float -0.151349
	.float -0.108120
	.float 0.180010
	.float 0.032278
	.float -0.422675
	.float 0.756130
	.float -0.826228
	.float 0.589426
	.float -0.192129
	.float -0.121510
	.float 0.162012
	.float 0.086544
	.float -0.454733
	.float 0.694640
	.float -0.640887
	.float 0.320380
	.float 0.066340
	.float -0.282663
	.float 0.216032
	.float 0.053277
	.float -0.320636
	.float 0.407111
	.float -0.279976
	.float 0.062616
	.float 0.062086
	.float 0.021157
	.float -0.288631
	.float 0.599688
	.float -0.786415
	.float 0.748250
	.float -0.497607
	.float 0.140535
	.float 0.183777
	.float -0.365951
	.float 0.363945
	.float -0.209950
	.float -0.006947
	.float 0.176246
	.float -0.214575
	.float 0.110841
	.float 0.061710
	.float -0.189249
	.float 0.201494
	.float -0.138376
	.float 0.136683
	.float -0.326686
	.float 0.705724
	.float -1.091290
	.float 1.210678
	.float -0.882082
	.float 0.161972
	.float 0.655474
	.float -1.199224
	.float 1.238239
	.float -0.808413
	.float 0.171037
	.float 0.355308
	.float -0.567529
	.float 0.450152
	.float -0.129540
	.float -0.227183
	.float 0.492019
	.float -0.603673
	.float 0.561142
	.float -0.412112
	.float 0.240303
	.float -0.137205
	.float 0.154640
	.float -0.263347
	.float 0.353442
	.float -0.289898
	.float -0.005070
	.float 0.493262
	.float -1.025242
	.float 1.408713
	.float -1.502749
	.float 1.283998
	.float -0.847571
	.float 0.344843
	.float 0.099724
	.float -0.437068
	.float 0.677291
	.float -0.830314
	.float 0.860759
	.float -0.703936
	.float 0.336581
	.float 0.157535
	.float -0.592076
	.float 0.766639
	.float -0.586079
	.float 0.127020
	.float 0.399290
	.float -0.767611
	.float 0.865460
	.float -0.744199
	.float 0.565094
	.float -0.481426
	.float 0.538830
	.float -0.659295
	.float 0.712612
	.float -0.617494
	.float 0.398328
	.float -0.161764
	.float 0.018854
	.float -0.013955
	.float 0.107229
	.float -0.211504
	.float 0.246738
	.float -0.173925
	.float -0.001797
	.float 0.242544
	.float -0.485179
	.float 0.645698
	.float -0.637257
	.float 0.411194
	.float -0.003215
	.float -0.453806
	.float 0.778084
	.float -0.833935
	.float 0.616987
	.float -0.266505
	.float -0.014670
	.float 0.086201
	.float 0.042047
	.float -0.223849
	.float 0.284065
	.float -0.143128
	.float -0.130813
	.float 0.376642
	.float -0.455603
	.float 0.337714
	.float -0.099213
	.float -0.154444
	.float 0.367635
	.float -0.551536
	.float 0.734790
	.float -0.901541
	.float 0.975677
	.float -0.865695
	.float 0.533817
	.float -0.037620
	.float -0.483724
	.float 0.869289
	.float -1.008862
	.float 0.891217
	.float -0.604108
	.float 0.285753
	.float -0.054518
	.float -0.041275
	.float 0.024807
	.float 0.049241
	.float -0.137226
	.float 0.216155
	.float -0.260909
	.float 0.223657
	.float -0.048396
	.float -0.282960
	.float 0.711551
	.float -1.108454
	.float 1.331265
	.float -1.296143
	.float 1.020226
	.float -0.611157
	.float 0.212662
	.float 0.063829
	.float -0.188817
	.float 0.224181
	.float -0.285679
	.float 0.472366
	.float -0.795639
	.float 1.150994
	.float -1.359794
	.float 1.269176
	.float -0.854497
	.float 0.255133
	.float 0.290216
	.float -0.576563
	.float 0.549774
	.float -0.328257
	.float 0.113577
	.float -0.053268
	.float 0.152942
	.float -0.295232
	.float 0.340295
	.float -0.223509
	.float -0.021339
	.float 0.313113
	.float -0.584249
	.float 0.789726
	.float -0.867957
	.float 0.719506
	.float -0.260437
	.float -0.471158
	.float 1.253233
	.float -1.750957
	.float 1.709049
	.float -1.139415
	.float 0.353943
	.float 0.207743
	.float -0.252768
	.float -0.176176
	.float 0.731535
	.float -0.989206
	.float 0.715941
	.float 0.000174
	.float -0.824842
	.float 1.385221
	.float -1.465985
	.float 1.085701
	.float -0.442001
	.float -0.209243
	.float 0.662198
	.float -0.814461
	.float 0.668752
	.float -0.307456
	.float -0.138853
	.float 0.522917
	.float -0.716684
	.float 0.652633
	.float -0.357698
	.float -0.044336
	.float 0.379369
	.float -0.507499
	.float 0.401663
	.float -0.169281
	.float -0.005420
	.float -0.031733
	.float 0.312344
	.float -0.723458
	.float 1.066844
	.float -1.162717
	.float 0.940502
	.float -0.473585
	.float -0.052524
	.float 0.420413
	.float -0.474166
	.float 0.186762
	.float 0.328892
	.float -0.872628
	.float 1.248205
	.float -1.345258
	.float 1.170487
	.float -0.820997
	.float 0.428371
	.float -0.111984
	.float -0.042639
	.float -0.008661
	.float 0.258769
	.float -0.639027
	.float 1.029108
	.float -1.300265
	.float 1.376607
	.float -1.274350
	.float 1.086604
	.float -0.918133
	.float 0.814330
	.float -0.737442
	.float 0.609837
	.float -0.390784
	.float 0.123472
	.float 0.089304
	.float -0.163196
	.float 0.098791
	.float 0.020503
	.float -0.097237
	.float 0.095526
	.float -0.059989
	.float 0.066869
	.float -0.155102
	.float 0.296218
	.float -0.420547
	.float 0.466691
	.float -0.409224
	.float 0.250631
	.float -0.001233
	.float -0.322287
	.float 0.675777
	.float -0.971821
	.float 1.099841
	.float -0.984112
	.float 0.644425
	.float -0.210030
	.float -0.137397
	.float 0.267102
	.float -0.184600
	.float 0.036451
	.float -0.020695
	.float 0.254307
	.float -0.685120
	.float 1.111438
	.float -1.302244
	.float 1.141528
	.float -0.702416
	.float 0.203506
	.float 0.121411
	.float -0.153660
	.float -0.061286
	.float 0.368201
	.float -0.611512
	.float 0.721318
	.float -0.724555
	.float 0.690175
	.float -0.662883
	.float 0.637203
	.float -0.581823
	.float 0.480857
	.float -0.350944
	.float 0.223177
	.float -0.114049
	.float 0.016644
	.float 0.081411
	.float -0.176578
	.float 0.250509
	.float -0.293817
	.float 0.325387
	.float -0.381059
	.float 0.474956
	.float -0.567881
	.float 0.577680
	.float -0.434371
	.float 0.142621
	.float 0.198032
	.float -0.439348
	.float 0.472380
	.float -0.298524
	.float 0.031048
	.float 0.177083
	.float -0.228643
	.float 0.131413
	.float 0.031257
	.float -0.177321
	.float 0.282488
	.float -0.372758
	.float 0.472559
	.float -0.566954
	.float 0.616468
	.float -0.604934
	.float 0.565231
	.float -0.552036
	.float 0.585999
	.float -0.625293
	.float 0.595113
	.float -0.451580
	.float 0.225899
	.float -0.013306
	.float -0.082414
	.float 0.007923
	.float 0.211695
	.float -0.482550
	.float 0.675675
	.float -0.671032
	.float 0.404095
	.float 0.095060
	.float -0.690697
	.float 1.179437
	.float -1.375257
	.float 1.203469
	.float -0.747925
	.float 0.216811
	.float 0.157175
	.float -0.223976
	.float -0.029100
	.float 0.495810
	.float -1.015821
	.float 1.440267
	.float -1.670642
	.float 1.672353
	.float -1.476572
	.float 1.171211
	.float -0.869927
	.float 0.657560
	.float -0.539873
	.float 0.440135
	.float -0.259895
	.float -0.031386
	.float 0.349514
	.float -0.540171
	.float 0.493384
	.float -0.242362
	.float -0.038892
	.float 0.150304
	.float -0.013545
	.float -0.263168
	.float 0.461180
	.float -0.417108
	.float 0.150400
	.float 0.150751
	.float -0.278061
	.float 0.169430
	.float 0.041005
	.float -0.130525
	.float -0.031596
	.float 0.372937
	.float -0.662347
	.float 0.675976
	.float -0.361650
	.float -0.115493
	.float 0.475072
	.float -0.498167
	.float 0.160803
	.float 0.358533
	.float -0.793940
	.float 0.950424
	.float -0.807615
	.float 0.515162
	.float -0.296022
	.float 0.320850
	.float -0.619499
	.float 1.066808
	.float -1.444228
	.float 1.549739
	.float -1.304715
	.float 0.799782
	.float -0.245048
	.float -0.153724
	.float 0.316106
	.float -0.321917
	.float 0.335067
	.float -0.474318
	.float 0.728400
	.float -0.976181
	.float 1.088855
	.float -1.028682
	.float 0.867325
	.float -0.714839
	.float 0.621213
	.float -0.533215
	.float 0.342775
	.float 0.008289
	.float -0.448453
	.float 0.787103
	.float -0.818055
	.float 0.452411
	.float 0.205992
	.float -0.895729
	.float 1.328520
	.float -1.340958
	.float 0.978199
	.float -0.460152
	.float 0.052085
	.float 0.081105
	.float 0.050513
	.float -0.296826
	.float 0.478434
	.float -0.493551
	.float 0.353922
	.float -0.140701
	.float -0.070227
	.float 0.250086
	.float -0.399395
	.float 0.499646
	.float -0.489703
	.float 0.298819
	.float 0.085951
	.float -0.576929
	.float 1.013103
	.float -1.246775
	.float 1.227181
	.float -1.017890
	.float 0.737705
	.float -0.478383
	.float 0.267459
	.float -0.098846
	.float -0.013091
	.float 0.021328
	.float 0.102767
	.float -0.304595
	.float 0.442573
	.float -0.371954
	.float 0.060294
	.float 0.361427
	.float -0.664829
	.float 0.667691
	.float -0.351767
	.float -0.128306
	.float 0.545935
	.float -0.736924
	.float 0.678686
	.float -0.476827
	.float 0.287394
	.float -0.232410
	.float 0.350727
	.float -0.593164
	.float 0.849034
	.float -0.989480
	.float 0.915573
	.float -0.598910
	.float 0.098301
	.float 0.457442
	.float -0.917206
	.float 1.166216
	.float -1.169515
	.float 0.979626
	.float -0.703316
	.float 0.443717
	.float -0.249836
	.float 0.104834
	.float 0.039744
	.float -0.211673
	.float 0.391151
	.float -0.532833
	.float 0.613944
	.float -0.658853
	.float 0.710106
	.float -0.770395
	.float 0.775619
	.float -0.637177
	.float 0.326203
	.float 0.074452
	.float -0.404712
	.float 0.528723
	.float -0.422863
	.float 0.179826
	.float 0.070378
	.float -0.250659
	.float 0.364473
	.float -0.448623
	.float 0.508942
	.float -0.507100
	.float 0.410428
	.float -0.250480
	.float 0.122918
	.float -0.117295
	.float 0.236464
	.float -0.383035
	.float 0.434597
	.float -0.348274
	.float 0.204588
	.float -0.148875
	.float 0.273478
	.float -0.534008
	.float 0.764446
	.float -0.779539
	.float 0.490022
	.float 0.045317
	.float -0.657047
	.float 1.158705
	.float -1.435677
	.float 1.481040
	.float -1.367132
	.float 1.178665
	.float -0.952302
	.float 0.660868
	.float -0.251950
	.float -0.285888
	.float 0.877590
	.float -1.374524
	.float 1.624859
	.float -1.559304
	.float 1.236832
	.float -0.820267
	.float 0.496230
	.float -0.386182
	.float 0.494803
	.float -0.716129
	.float 0.888439
	.float -0.871257
	.float 0.613062
	.float -0.179661
	.float -0.274142
	.float 0.581218
	.float -0.647271
	.float 0.491202
	.float -0.213042
	.float -0.085809
	.float 0.368115
	.float -0.660874
	.float 0.994108
	.float -1.334973
	.float 1.578424
	.float -1.607906
	.float 1.379689
	.float -0.963124
	.float 0.502456
	.float -0.128013
	.float -0.115254
	.float 0.268144
	.float -0.390528
	.float 0.488478
	.float -0.501935
	.float 0.367021
	.float -0.097732
	.float -0.193348
	.float 0.367379
	.float -0.373041
	.float 0.303582
	.float -0.335896
	.float 0.586601
	.float -0.995307
	.float 1.333888
	.float -1.348039
	.float 0.934788
	.float -0.230513
	.float -0.453097
	.float 0.801886
	.float -0.670298
	.float 0.151542
	.float 0.481542
	.float -0.919907
	.float 0.967138
	.float -0.625243
	.float 0.083390
	.float 0.382758
	.float -0.554394
	.float 0.383562
	.float -0.014251
	.float -0.305912
	.float 0.373384
	.float -0.145236
	.float -0.247714
	.float 0.595244
	.float -0.741708
	.float 0.668027
	.float -0.471632
	.float 0.270841
	.float -0.113662
	.float -0.038620
	.float 0.248572
	.float -0.520616
	.float 0.772695
	.float -0.882040
	.float 0.762449
	.float -0.411010
	.float -0.099032
	.float 0.653575
	.float -1.125166
	.float 1.388943
	.float -1.350206
	.float 0.992764
	.float -0.416136
	.float -0.185014
	.float 0.607768
	.float -0.743451
	.float 0.625234
	.float -0.389887
	.float 0.187598
	.float -0.104454
	.float 0.138393
	.float -0.223124
	.float 0.269864
	.float -0.204867
	.float -0.000403
	.float 0.308449
	.float -0.616844
	.float 0.795270
	.float -0.750500
	.float 0.483274
	.float -0.096993
	.float -0.252861
	.float 0.438814
	.float -0.421116
	.float 0.253654
	.float -0.039257
	.float -0.133276
	.float 0.232987
	.float -0.290421
	.float 0.364115
	.float -0.491411
	.float 0.653086
	.float -0.773908
	.float 0.761844
	.float -0.564629
	.float 0.210063
	.float 0.195731
	.float -0.513115
	.float 0.633996
	.float -0.534434
	.float 0.289227
	.float -0.040145
	.float -0.070839
	.float -0.025900
	.float 0.286271
	.float -0.569988
	.float 0.713733
	.float -0.622155
	.float 0.323044
	.float 0.047311
	.float -0.318746
	.float 0.375685
	.float -0.209980
	.float -0.082995
	.float 0.351060
	.float -0.446140
	.float 0.277998
	.float 0.148400
	.float -0.719959
	.float 1.241243
	.float -1.505175
	.float 1.386598
	.float -0.907052
	.float 0.224241
	.float 0.453788
	.float -0.973078
	.float 1.284823
	.float -1.415264
	.float 1.394669
	.float -1.216809
	.float 0.865966
	.float -0.380192
	.float -0.120116
	.float 0.481846
	.float -0.618665
	.float 0.579057
	.float -0.516289
	.float 0.570867
	.float -0.753102
	.float 0.924231
	.float -0.901905
	.float 0.613267
	.float -0.171126
	.float -0.197687
	.float 0.323068
	.float -0.225573
	.float 0.099633
	.float -0.153643
	.float 0.434990
	.float -0.785717
	.float 0.967791
	.float -0.854822
	.float 0.532878
	.float -0.231058
	.float 0.146676
	.float -0.311408
	.float 0.597438
	.float -0.835694
	.float 0.929975
	.float -0.876708
	.float 0.702863
	.float -0.410369
	.float -0.006358
	.float 0.492469
	.float -0.898686
	.float 1.039599
	.float -0.814556
	.float 0.295968
	.float 0.292473
	.float -0.701018
	.float 0.796316
	.float -0.622960
	.float 0.348089
	.float -0.137222
	.float 0.053397
	.float -0.046321
	.float 0.025411
	.float 0.050455
	.float -0.139380
	.float 0.161350
	.float -0.079133
	.float -0.053127
	.float 0.113791
	.float 0.005911
	.float -0.321104
	.float 0.726135
	.float -1.039400
	.float 1.094950
	.float -0.830382
	.float 0.323041
	.float 0.244693
	.float -0.669792
	.float 0.814458
	.float -0.648914
	.float 0.239925
	.float 0.289417
	.float -0.794417
	.float 1.127356
	.float -1.158595
	.float 0.820252
	.float -0.161538
	.float -0.628092
	.float 1.268926
	.float -1.509086
	.float 1.251460
	.float -0.611485
	.float -0.135917
	.float 0.693937
	.float -0.888049
	.float 0.737893
	.float -0.424180
	.float 0.179773
	.float -0.169360
	.float 0.416968
	.float -0.807340
	.float 1.150527
	.float -1.275730
	.float 1.111816
	.float -0.716558
	.float 0.237696
	.float 0.175028
	.float -0.454197
	.float 0.638419
	.float -0.818702
	.float 1.048594
	.float -1.288534
	.float 1.428032
	.float -1.366351
	.float 1.087603
	.float -0.675589
	.float 0.265058
	.float 0.027721
	.float -0.146744
	.float 0.094722
	.float 0.091339
	.float -0.357099
	.float 0.628670
	.float -0.806157
	.float 0.779834
	.float -0.480267
	.float -0.059203
	.float 0.675404
	.float -1.125365
	.float 1.207301
	.float -0.887062
	.float 0.339580
	.float 0.140410
	.float -0.314138
	.float 0.145895
	.float 0.181862
	.float -0.397174
	.float 0.318976
	.float 0.037248
	.float -0.494028
	.float 0.847222
	.float -0.995280
	.float 0.973850
	.float -0.888844
	.float 0.816386
	.float -0.752297
	.float 0.643266
	.float -0.463719
	.float 0.268658
	.float -0.176233
	.float 0.288590
	.float -0.604913
	.float 0.986744
	.float -1.205483
	.float 1.055831
	.float -0.480007
	.float -0.366207
	.float 1.155441
	.float -1.535961
	.float 1.316637
	.float -0.584190
	.float -0.326832
	.float 1.005905
	.float -1.182191
	.float 0.853883
	.float -0.257862
	.float -0.289643
	.float 0.572289
	.float -0.566259
	.float 0.409135
	.float -0.287800
	.float 0.324779
	.float -0.523326
	.float 0.786218
	.float -0.983555
	.float 1.028429
	.float -0.921904
	.float 0.746071
	.float -0.609524
	.float 0.576858
	.float -0.625982
	.float 0.663032
	.float -0.588258
	.float 0.370854
	.float -0.080808
	.float -0.147076
	.float 0.196416
	.float -0.045165
	.float -0.217214
	.float 0.442242
	.float -0.506456
	.float 0.370329
	.float -0.081256
	.float -0.263153
	.float 0.551858
	.float -0.677243
	.float 0.549578
	.float -0.135233
	.float -0.489423
	.float 1.118561
	.float -1.479114
	.float 1.363189
	.float -0.754625
	.float -0.139358
	.float 0.980825
	.float -1.463839
	.float 1.449271
	.float -1.000844
	.float 0.322430
	.float 0.347365
	.float -0.820607
	.float 0.998707
	.float -0.876702
	.float 0.534273
	.float -0.116853
	.float -0.206093
	.float 0.307829
	.float -0.168090
	.float -0.110538
	.float 0.356124
	.float -0.424615
	.float 0.279666
	.float -0.005281
	.float -0.249932
	.float 0.352321
	.float -0.237603
	.float -0.076956
	.float 0.505815
	.float -0.912995
	.float 1.136575
	.float -1.035793
	.float 0.560629
	.float 0.191504
	.float -0.982267
	.float 1.521768
	.float -1.603245
	.float 1.205737
	.float -0.501512
	.float -0.236376
	.float 0.768779
	.float -0.989510
	.float 0.940883
	.float -0.754351
	.float 0.565553
	.float -0.455177
	.float 0.436815
	.float -0.478973
	.float 0.534729
	.float -0.561744
	.float 0.532419
	.float -0.439947
	.float 0.301245
	.float -0.151359
	.float 0.027797
	.float 0.046660
	.float -0.068910
	.float 0.043315
	.float 0.035294
	.float -0.182276
	.float 0.398545
	.float -0.638634
	.float 0.806712
	.float -0.801651
	.float 0.589200
	.float -0.244693
	.float -0.079552
	.float 0.250261
	.float -0.242553
	.float 0.150166
	.float -0.105794
	.float 0.174980
	.float -0.306801
	.float 0.374508
	.float -0.267277
	.float -0.036005
	.float 0.453463
	.float -0.841446
	.float 1.057581
	.float -1.016692
	.float 0.723589
	.float -0.273156
	.float -0.185922
	.float 0.511785
	.float -0.625687
	.float 0.534568
	.float -0.312198
	.float 0.056351
	.float 0.150989
	.float -0.264261
	.float 0.275208
	.float -0.201805
	.float 0.074342
	.float 0.074390
	.float -0.211758
	.float 0.304148
	.float -0.321506
	.float 0.251861
	.float -0.118507
	.float -0.017994
	.float 0.083637
	.float -0.030960
	.float -0.130627
	.float 0.336033
	.float -0.497616
	.float 0.548773
	.float -0.471278
	.float 0.293005
	.float -0.063032
	.float -0.176250
	.float 0.401946
	.float -0.602210
	.float 0.756726
	.float -0.824022
	.float 0.750953
	.float -0.503356
	.float 0.100286
	.float 0.372958
	.float -0.787416
	.float 1.021553
	.float -1.015669
	.float 0.800906
	.float -0.486511
	.float 0.209699
	.float -0.071095
	.float 0.087421
	.float -0.187837
	.float 0.258510
	.float -0.212937
	.float 0.045982
	.float 0.162479
	.float -0.297053
	.float 0.275582
	.float -0.092902
	.float -0.183760
	.float 0.454355
	.float -0.627564
	.float 0.642807
	.float -0.476961
	.float 0.152022
	.float 0.255122
	.float -0.620745
	.float 0.818243
	.float -0.783571
	.float 0.556984
	.float -0.261402
	.float 0.025906
	.float 0.089450
	.float -0.110053
	.float 0.097334
	.float -0.084506
	.float 0.057797
	.float 0.003877
	.float -0.078430
	.float 0.099680
	.float -0.019292
	.float -0.120845
	.float 0.179562
	.float 0.001951
	.float -0.477835
	.float 1.126844
	.float -1.694769
	.float 1.930164
	.float -1.725718
	.float 1.173795
	.float -0.506313
	.float -0.0357