/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import sun.tools.jconsole.inspector.Utils;

class XArrayDataViewer {
    private XArrayDataViewer() {
    }

    public static boolean isViewableValue(Object object) {
        return Utils.isSupportedDataStructure(object);
    }

    public static Component loadArray(Object object) {
        JScrollPane jScrollPane = null;
        if (XArrayDataViewer.isViewableValue(object)) {
            JScrollPane jScrollPane2;
            Object[] objectArray;
            if (object instanceof Collection) {
                objectArray = ((Collection)object).toArray();
            } else if (object instanceof Map) {
                objectArray = ((Map)object).entrySet().toArray();
            } else if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                int n = Array.getLength(object);
                objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Array.get(object, i);
                }
            }
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            Color color = jEditorPane.getBackground();
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            String string = "rgb(" + n + "," + n2 + "," + n3 + ")";
            Color color2 = new Color(n < 20 ? n + 20 : n - 20, n2 < 20 ? n2 + 20 : n2 - 20, n3 < 20 ? n3 + 20 : n3 - 20);
            String string2 = "rgb(" + color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue() + ")";
            Color color3 = jEditorPane.getForeground();
            String string3 = String.format("%06x", color3.getRGB() & 0xFFFFFF);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body text=#" + string3 + "><table width=\"100%\">");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i % 2 == 0) {
                    stringBuilder.append("<tr style=\"background-color: " + string + "\"><td><pre>" + (objectArray[i] == null ? objectArray[i] : XArrayDataViewer.htmlize(objectArray[i].toString())) + "</pre></td></tr>");
                    continue;
                }
                stringBuilder.append("<tr style=\"background-color: " + string2 + "\"><td><pre>" + (objectArray[i] == null ? objectArray[i] : XArrayDataViewer.htmlize(objectArray[i].toString())) + "</pre></td></tr>");
            }
            if (objectArray.length == 0) {
                stringBuilder.append("<tr style=\"background-color: " + string + "\"><td></td></tr>");
            }
            stringBuilder.append("</table></body></html>");
            jEditorPane.setText(stringBuilder.toString());
            jScrollPane = jScrollPane2 = new JScrollPane(jEditorPane);
        }
        return jScrollPane;
    }

    private static String htmlize(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;");
    }
}

