/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.tools.jdi.EventSetImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.TargetVM;
import java.util.LinkedList;

public class EventQueueImpl
extends MirrorImpl
implements EventQueue {
    LinkedList eventSets = new LinkedList();
    TargetVM target;
    boolean closed = false;

    EventQueueImpl(VirtualMachine virtualMachine, TargetVM targetVM) {
        super(virtualMachine);
        this.target = targetVM;
        targetVM.addEventQueue(this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    synchronized void enqueue(EventSet eventSet) {
        this.eventSets.add(eventSet);
        this.notifyAll();
    }

    synchronized int size() {
        return this.eventSets.size();
    }

    synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.enqueue(new EventSetImpl((VirtualMachine)this.vm, 100));
        }
    }

    public EventSet remove() throws InterruptedException {
        return this.remove(0L);
    }

    public EventSet remove(long l) throws InterruptedException {
        EventSet eventSet;
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        while (true) {
            EventSetImpl eventSetImpl;
            if ((eventSetImpl = this.removeUnfiltered(l)) == null) {
                eventSet = null;
                break;
            }
            eventSet = eventSetImpl.userFilter();
            if (!eventSet.isEmpty()) break;
            if (eventSetImpl.suspendPolicy() == 0) continue;
            eventSetImpl.resume();
        }
        if (eventSet != null && eventSet.suspendPolicy() == 2) {
            this.vm.notifySuspend();
        }
        return eventSet;
    }

    EventSet removeInternal() throws InterruptedException {
        EventSet eventSet;
        while ((eventSet = this.removeUnfiltered(0L).internalFilter()) == null || eventSet.isEmpty()) {
        }
        return eventSet;
    }

    private TimerThread startTimerThread(long l) {
        TimerThread timerThread = new TimerThread(l);
        timerThread.setDaemon(true);
        timerThread.start();
        return timerThread;
    }

    private boolean shouldWait(TimerThread timerThread) {
        return !this.closed && this.eventSets.isEmpty() && (timerThread == null || !timerThread.timedOut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventSetImpl removeUnfiltered(long l) throws InterruptedException {
        EventSetImpl eventSetImpl = null;
        this.vm.waitInitCompletion();
        EventQueueImpl eventQueueImpl = this;
        synchronized (eventQueueImpl) {
            if (!this.eventSets.isEmpty()) {
                eventSetImpl = (EventSetImpl)this.eventSets.removeFirst();
            } else {
                TimerThread timerThread = null;
                try {
                    if (l > 0L) {
                        timerThread = this.startTimerThread(l);
                    }
                    while (this.shouldWait(timerThread)) {
                        this.wait();
                    }
                }
                finally {
                    if (timerThread != null && !timerThread.timedOut()) {
                        timerThread.interrupt();
                    }
                }
                if (this.eventSets.isEmpty()) {
                    if (this.closed) {
                        throw new VMDisconnectedException();
                    }
                } else {
                    eventSetImpl = (EventSetImpl)this.eventSets.removeFirst();
                }
            }
        }
        if (eventSetImpl != null) {
            this.target.notifyDequeueEventSet();
            eventSetImpl.build();
        }
        return eventSetImpl;
    }

    private class TimerThread
    extends Thread {
        private boolean timedOut;
        private long timeout;

        TimerThread(long l) {
            super(EventQueueImpl.this.vm.threadGroupForJDI(), "JDI Event Queue Timer");
            this.timedOut = false;
            this.timeout = l;
        }

        boolean timedOut() {
            return this.timedOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                EventQueueImpl eventQueueImpl;
                Thread.sleep(this.timeout);
                EventQueueImpl eventQueueImpl2 = eventQueueImpl = EventQueueImpl.this;
                synchronized (eventQueueImpl2) {
                    this.timedOut = true;
                    eventQueueImpl.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

