/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.util.ObjectIdentifier;

abstract class Krb5Token {
    public static final int TBD = -1;
    public static final int AP_REQ_ID = 256;
    public static final int AP_REP_ID = 512;
    public static final int ERR_ID = 768;
    public static final int MIC_ID = 257;
    public static final int WRAP_ID = 513;
    public static final int MIC_ID_v2 = 1028;
    public static final int WRAP_ID_v2 = 1284;
    public static ObjectIdentifier OID;

    Krb5Token() {
    }

    public static final void writeBigEndian(int n, byte[] byArray) {
        Krb5Token.writeBigEndian(n, byArray, 0);
    }

    public static final void writeBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
    }

    public static final int readBigEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 -= 8;
            ++n;
            --n2;
        }
        return n3;
    }

    public static final void writeLittleEndian(int n, byte[] byArray) {
        Krb5Token.writeLittleEndian(n, byArray, 0);
    }

    public static final void writeLittleEndian(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 24);
    }

    public static final int readLittleEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 += 8;
            ++n;
            --n2;
        }
        return n3;
    }

    public static final void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >>> 8);
        outputStream.write(n);
    }

    public static final int writeInt(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        return n2;
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        return (0xFF & inputStream.read()) << 8 | 0xFF & inputStream.read();
    }

    public static final int readInt(byte[] byArray, int n) {
        return (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1];
    }

    public static final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        Krb5Token.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static final void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException("Cannot read all " + n2 + " bytes needed to form this token!");
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static final void debug(String string) {
        System.err.print(string);
    }

    public static final String getHexBytes(byte[] byArray) {
        return Krb5Token.getHexBytes(byArray, 0, byArray.length);
    }

    public static final String getHexBytes(byte[] byArray, int n) {
        return Krb5Token.getHexBytes(byArray, 0, n);
    }

    public static final String getHexBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            int n3 = byArray[i] >> 4 & 0xF;
            int n4 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String getTokenName(int n) {
        String string = null;
        switch (n) {
            case 256: 
            case 512: {
                string = "Context Establishment Token";
                break;
            }
            case 257: {
                string = "MIC Token";
                break;
            }
            case 1028: {
                string = "MIC Token (new format)";
                break;
            }
            case 513: {
                string = "Wrap Token";
                break;
            }
            case 1284: {
                string = "Wrap Token (new format)";
                break;
            }
            default: {
                string = "Kerberos GSS-API Mechanism Token";
            }
        }
        return string;
    }

    static {
        try {
            OID = new ObjectIdentifier(Krb5MechFactory.GSS_KRB5_MECH_OID.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

