/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import sun.awt.X11.FileDialogFilter;
import sun.awt.X11.Separator;
import sun.awt.X11.XChoicePeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XToolkit;

class XFileDialogPeer
extends XDialogPeer
implements FileDialogPeer,
ActionListener,
ItemListener,
KeyEventDispatcher {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XFileDialogPeer");
    FileDialog target;
    String file;
    String dir;
    String title;
    int mode;
    FilenameFilter filter;
    private static final int PATH_CHOICE_WIDTH = 20;
    String savedFile;
    String savedDir;
    Dialog fileDialog;
    GridBagLayout gbl;
    GridBagLayout gblButtons;
    GridBagConstraints gbc;
    TextField filterField;
    TextField selectionField;
    List directoryList;
    List fileList;
    Panel buttons;
    Button openButton;
    Button filterButton;
    Button cancelButton;
    Choice pathChoice;
    TextField pathField;
    Panel pathPanel;
    String cancelButtonText = null;
    String enterFileNameLabelText = null;
    String filesLabelText = null;
    String foldersLabelText = null;
    String pathLabelText = null;
    String filterLabelText = null;
    String openButtonText = null;
    String saveButtonText = null;
    String actionButtonText = null;

    void installStrings() {
        Locale locale = this.target.getLocale();
        UIDefaults uIDefaults = XToolkit.getUIDefaults();
        this.cancelButtonText = uIDefaults.getString("FileChooser.cancelButtonText", locale);
        this.enterFileNameLabelText = uIDefaults.getString("FileChooser.enterFileNameLabelText", locale);
        this.filesLabelText = uIDefaults.getString("FileChooser.filesLabelText", locale);
        this.foldersLabelText = uIDefaults.getString("FileChooser.foldersLabelText", locale);
        this.pathLabelText = uIDefaults.getString("FileChooser.pathLabelText", locale);
        this.filterLabelText = uIDefaults.getString("FileChooser.filterLabelText", locale);
        this.openButtonText = uIDefaults.getString("FileChooser.openButtonText", locale);
        this.saveButtonText = uIDefaults.getString("FileChooser.saveButtonText", locale);
    }

    XFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
        this.target = fileDialog;
    }

    private void init(FileDialog fileDialog) {
        this.fileDialog = fileDialog;
        this.title = fileDialog.getTitle();
        this.mode = fileDialog.getMode();
        this.target = fileDialog;
        this.filter = fileDialog.getFilenameFilter();
        this.savedFile = fileDialog.getFile();
        this.savedDir = fileDialog.getDirectory();
        if (this.savedDir == null) {
            this.savedDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        this.installStrings();
        this.gbl = new GridBagLayout();
        this.gblButtons = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.fileDialog.setLayout(this.gbl);
        this.buttons = new Panel();
        this.buttons.setLayout(this.gblButtons);
        this.actionButtonText = fileDialog.getMode() == 1 ? this.saveButtonText : this.openButtonText;
        this.openButton = new Button(this.actionButtonText);
        this.filterButton = new Button(this.filterLabelText);
        this.cancelButton = new Button(this.cancelButtonText);
        this.directoryList = new List();
        this.fileList = new List();
        this.filterField = new TextField();
        this.selectionField = new TextField();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 8, 0, 8);
        Insets insets3 = new Insets(0, 8, 0, 4);
        Insets insets4 = new Insets(0, 4, 0, 8);
        Insets insets5 = new Insets(8, 0, 0, 0);
        Insets insets6 = new Insets(0, 8, 0, 0);
        Insets insets7 = new Insets(10, 8, 10, 8);
        Font font = new Font("Dialog", 0, 12);
        Label label = new Label(this.pathLabelText);
        label.setFont(font);
        this.addComponent(label, this.gbl, this.gbc, 0, 0, 1, 17, this.fileDialog, 1, 0, 0, insets6);
        this.pathField = new TextField(this.savedDir);
        this.pathChoice = new Choice(){

            public Dimension getPreferredSize() {
                return new Dimension(20, XFileDialogPeer.this.pathField.getPreferredSize().height);
            }
        };
        this.pathPanel = new Panel();
        this.pathPanel.setLayout(new BorderLayout());
        this.pathPanel.add((Component)this.pathField, "Center");
        this.pathPanel.add((Component)this.pathChoice, "East");
        this.addComponent(this.pathPanel, this.gbl, this.gbc, 0, 1, 2, 17, this.fileDialog, 1, 0, 2, insets2);
        label = new Label(this.filterLabelText);
        label.setFont(font);
        this.addComponent(label, this.gbl, this.gbc, 0, 2, 1, 17, this.fileDialog, 1, 0, 0, insets6);
        this.addComponent(this.filterField, this.gbl, this.gbc, 0, 3, 2, 17, this.fileDialog, 1, 0, 2, insets2);
        label = new Label(this.foldersLabelText);
        label.setFont(font);
        this.addComponent(label, this.gbl, this.gbc, 0, 4, 1, 17, this.fileDialog, 1, 0, 0, insets6);
        label = new Label(this.filesLabelText);
        label.setFont(font);
        this.addComponent(label, this.gbl, this.gbc, 1, 4, 1, 17, this.fileDialog, 1, 0, 0, insets6);
        this.addComponent(this.directoryList, this.gbl, this.gbc, 0, 5, 1, 17, this.fileDialog, 1, 1, 1, insets3);
        this.addComponent(this.fileList, this.gbl, this.gbc, 1, 5, 1, 17, this.fileDialog, 1, 1, 1, insets4);
        label = new Label(this.enterFileNameLabelText);
        label.setFont(font);
        this.addComponent(label, this.gbl, this.gbc, 0, 6, 1, 17, this.fileDialog, 1, 0, 0, insets6);
        this.addComponent(this.selectionField, this.gbl, this.gbc, 0, 7, 2, 17, this.fileDialog, 1, 0, 2, insets2);
        this.addComponent(new Separator(this.fileDialog.size().width, 2, 0), this.gbl, this.gbc, 0, 8, 15, 17, this.fileDialog, 1, 0, 2, insets5);
        this.addComponent(this.openButton, this.gblButtons, this.gbc, 0, 0, 1, 17, this.buttons, 1, 0, 0, insets);
        this.addComponent(this.filterButton, this.gblButtons, this.gbc, 1, 0, 1, 10, this.buttons, 1, 0, 0, insets);
        this.addComponent(this.cancelButton, this.gblButtons, this.gbc, 2, 0, 1, 13, this.buttons, 1, 0, 0, insets);
        this.addComponent(this.buttons, this.gbl, this.gbc, 0, 9, 2, 17, this.fileDialog, 1, 0, 2, insets7);
        this.fileDialog.setSize(400, 400);
        XChoicePeer xChoicePeer = (XChoicePeer)this.pathChoice.getPeer();
        xChoicePeer.setDrawSelectedItem(false);
        xChoicePeer.setAlignUnder(this.pathField);
        this.filterField.addActionListener(this);
        this.selectionField.addActionListener(this);
        this.directoryList.addActionListener(this);
        this.directoryList.addItemListener(this);
        this.fileList.addItemListener(this);
        this.fileList.addActionListener(this);
        this.openButton.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pathChoice.addItemListener(this);
        this.pathField.addActionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    void addComponent(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, Container container, int n5, int n6, int n7, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    String getFileName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    void handleFilter(String string) {
        if (string == null) {
            return;
        }
        this.setFilterEntry(this.dir, string);
    }

    void handleSelection(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            this.savedDir = this.dir;
            this.savedFile = string;
        } else {
            this.savedDir = string.substring(0, n + 1);
            this.savedFile = string.substring(n + 1);
        }
        this.target.setDirectory(this.savedDir);
        this.target.setFile(this.savedFile);
    }

    void handleCancel() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.setSelectionField(null);
        this.setFilterField(null);
        this.directoryList.clear();
        this.fileList.clear();
        this.target.setFile(null);
        this.target.setDirectory(this.savedDir);
        this.handleQuitButton();
    }

    void handleQuitButton() {
        this.dir = null;
        this.file = null;
        this.target.hide();
    }

    void setFilterEntry(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory() && file.canRead()) {
            Object[] objectArray;
            this.setSelectionField(string);
            if (string2.equals("")) {
                string2 = "*";
                this.setFilterField(string2);
            } else {
                this.setFilterField(string2);
            }
            if (string2.equals("*")) {
                objectArray = file.list();
            } else {
                FileDialogFilter fileDialogFilter = new FileDialogFilter(string2);
                objectArray = file.list(fileDialogFilter);
            }
            this.directoryList.clear();
            this.fileList.clear();
            this.directoryList.setVisible(false);
            this.fileList.setVisible(false);
            this.directoryList.addItem("..");
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                File file2 = new File(string + (String)objectArray[i]);
                if (file2.isDirectory()) {
                    this.directoryList.addItem((String)objectArray[i] + "/");
                    continue;
                }
                if (this.filter != null) {
                    if (!this.filter.accept(new File((String)objectArray[i]), (String)objectArray[i])) continue;
                    this.fileList.addItem((String)objectArray[i]);
                    continue;
                }
                this.fileList.addItem((String)objectArray[i]);
            }
            this.dir = string;
            this.pathField.setText(this.dir);
            this.pathChoice.removeAll();
            String[] stringArray = this.getDirList(this.dir);
            for (int i = 0; i < stringArray.length; ++i) {
                this.pathChoice.addItem(stringArray[i]);
            }
            this.target.setDirectory(this.dir);
            this.directoryList.setVisible(true);
            this.fileList.setVisible(true);
        }
    }

    String[] getDirList(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '/') continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            stringArray[n2++] = new String(cArray, 0, i + 1);
        }
        return stringArray;
    }

    void setSelectionField(String string) {
        this.selectionField.setText(string);
    }

    void setFilterField(String string) {
        this.filterField.setText(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Choice) {
            String string = this.pathChoice.getSelectedItem();
            this.target.setDirectory(string);
        } else if (itemEvent.getID() == 701) {
            Object object2 = itemEvent.getItem();
            switch (itemEvent.getStateChange()) {
                case 1: {
                    if (this.directoryList == (List)object) {
                        int n = (Integer)object2;
                        this.setFilterField(this.getFileName(this.filterField.getText()));
                        break;
                    }
                    if (this.fileList != (List)object) break;
                    int n = (Integer)object2;
                    this.setSelectionField(this.fileList.getItem(n));
                    break;
                }
                case 2: {
                    if (this.directoryList == (List)object) {
                        this.setFilterField(this.getFileName(this.filterField.getText()));
                        break;
                    }
                    if (this.fileList != (List)object) break;
                    this.setSelectionField(this.dir);
                }
            }
        }
    }

    void checkForUpDir(String string) {
        if (string.equals("..")) {
            String string2 = this.dir;
            if (!this.dir.equals("/")) {
                if (this.dir.endsWith("/")) {
                    string2 = string2.substring(0, string2.lastIndexOf("/"));
                }
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            }
            this.dir = string2;
        } else {
            this.dir = this.dir + string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getID()) {
            case 1001: {
                String string = actionEvent.getActionCommand();
                Object object = actionEvent.getSource();
                if (string.equals(this.actionButtonText)) {
                    this.handleSelection(this.selectionField.getText());
                    this.handleQuitButton();
                    break;
                }
                if (string.equals(this.filterLabelText)) {
                    this.handleFilter(this.filterField.getText());
                    break;
                }
                if (string.equals(this.cancelButtonText)) {
                    this.handleCancel();
                    break;
                }
                if (object instanceof TextField) {
                    if (this.selectionField == (TextField)object) {
                        this.handleFilter(this.selectionField.getText());
                        this.handleQuitButton();
                        break;
                    }
                    if (this.filterField == (TextField)object) {
                        this.handleFilter(this.filterField.getText());
                        break;
                    }
                    if (this.pathField != (TextField)object) break;
                    this.target.setDirectory(this.pathField.getText());
                    break;
                }
                if (!(object instanceof List)) break;
                if (this.directoryList == (List)object) {
                    this.checkForUpDir(string);
                    this.handleFilter(this.getFileName(this.filterField.getText()));
                    break;
                }
                if (this.fileList != (List)object) break;
                this.handleSelection(string);
                this.handleQuitButton();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        int n2 = keyEvent.getKeyCode();
        if (n == 401 && n2 == 27) {
            Object object = this.target.getTreeLock();
            synchronized (object) {
                for (Component component = (Component)keyEvent.getSource(); component != null; component = component.getParent()) {
                    if (component.getPeer() != this) continue;
                    this.handleCancel();
                    return true;
                }
            }
        }
        return false;
    }

    public void setFile(String string) {
        if (string == null) {
            this.file = null;
            return;
        }
        if (this.dir == null) {
            String string2 = "./";
            File file = new File(string2, string);
            if (file.isFile()) {
                this.file = string;
                this.setDirectory(string2);
            }
        } else {
            File file = new File(this.dir, string);
            if (file.isFile()) {
                this.file = string;
            }
        }
        this.selectionField.setText(string);
    }

    public void setDirectory(String string) {
        if (string == null) {
            this.dir = null;
            return;
        }
        if (string.equals(this.dir)) {
            return;
        }
        int n = string.indexOf("~");
        if (n != -1) {
            string = string.substring(0, n) + System.getProperty("user.home") + string.substring(n + 1, string.length());
        }
        File file = new File(string).getAbsoluteFile();
        log.fine("Current directory : " + file);
        if (!file.isDirectory() && !(file = new File(string = "./").getAbsoluteFile()).isDirectory()) {
            return;
        }
        try {
            string = this.dir = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = this.dir = file.getAbsolutePath();
        }
        this.pathField.setText(this.dir);
        if (string.endsWith("/")) {
            this.dir = string;
            this.handleFilter("");
        } else {
            this.dir = string + "/";
            this.handleFilter("");
        }
        this.pathChoice.removeAll();
        String[] stringArray = this.getDirList(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.pathChoice.addItem(stringArray[n]);
        }
        this.pathPanel.validate();
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }

    public void show() {
        if (this.fileDialog == null) {
            this.init(this.target);
        }
        if (this.savedDir != null) {
            this.setDirectory(this.savedDir);
        }
        if (this.savedFile != null) {
            this.setFile(this.savedFile);
        }
        super.show();
    }

    public void dispose() {
        FileDialog fileDialog = (FileDialog)this.fileDialog;
        if (fileDialog != null) {
            fileDialog.removeAll();
        }
        super.dispose();
    }
}

