/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class X400Address
implements GeneralNameInterface {
    byte[] nameValue = null;

    public X400Address(byte[] byArray) {
        this.nameValue = byArray;
    }

    public X400Address(DerValue derValue) throws IOException {
        this.nameValue = derValue.toByteArray();
    }

    public int getType() {
        return 3;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerValue derValue = new DerValue(this.nameValue);
        derOutputStream.putDerValue(derValue);
    }

    public String toString() {
        return "X400Address: <DER-encoded value>";
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 3) {
            n2 = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and match are not supported for X400Address.");
        }
        return n2;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth not supported for X400Address");
    }
}

