/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.BaseRow;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.CachedRowSetWriter;
import com.sun.rowset.internal.InsertRow;
import com.sun.rowset.internal.Row;
import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRowSetImpl
extends BaseRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    private SyncProvider provider;
    private RowSetReader rowSetReader;
    private RowSetWriter rowSetWriter;
    private transient Connection conn;
    private transient ResultSetMetaData RSMD;
    private RowSetMetaDataImpl RowSetMD;
    private int[] keyCols;
    private String tableName;
    private Vector rvh;
    private int cursorPos;
    private int absolutePos;
    private int numDeleted;
    private int numRows;
    private InsertRow insertRow;
    private boolean onInsertRow;
    private int currentRow;
    private boolean lastValueNull;
    private SQLWarning sqlwarn;
    private String strMatchColumn = "";
    private int iMatchColumn = -1;
    private RowSetWarning rowsetWarning;
    private String DEFAULT_SYNC_PROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private boolean dbmslocatorsUpdateCopy;
    private ResultSet resultSet;
    private int endPos;
    private int prevEndPos;
    private int startPos;
    private int startPrev;
    private int pageSize;
    private int maxRowsreached;
    private boolean pagenotend = true;
    private boolean onFirstPage;
    private boolean onLastPage;
    private int populatecallcount;
    private int totalRows;
    private boolean callWithCon;
    private CachedRowSetReader crsReader;
    private Vector iMatchColumns;
    private Vector strMatchColumns;
    private boolean tXWriter = false;
    private TransactionalWriter tWriter = null;
    private transient JdbcRowSetResourceBundle resBundle;

    public CachedRowSetImpl() throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.provider = SyncFactory.getInstance(this.DEFAULT_SYNC_PROVIDER);
        if (!(this.provider instanceof RIOptimisticProvider)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidp").toString());
        }
        this.rowSetReader = (CachedRowSetReader)this.provider.getRowSetReader();
        this.rowSetWriter = (CachedRowSetWriter)this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
        this.sqlwarn = new SQLWarning();
        this.rowsetWarning = new RowSetWarning();
    }

    public CachedRowSetImpl(Hashtable hashtable) throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (hashtable == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nullhash").toString());
        }
        String string = (String)hashtable.get(SyncFactory.ROWSET_SYNC_PROVIDER);
        this.provider = SyncFactory.getInstance(string);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
    }

    private void initContainer() {
        this.rvh = new Vector(100);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
    }

    private void initProperties() throws SQLException {
        int n2;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1008);
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.checkTransactionalWriter();
        this.iMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.iMatchColumns.add(n2, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.strMatchColumns.add(n2, null);
        }
    }

    private void checkTransactionalWriter() {
        Class<? extends Object> clazz;
        if (this.rowSetWriter != null && (clazz = this.rowSetWriter.getClass()) != null) {
            Class[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2].getName().indexOf("TransactionalWriter") <= 0) continue;
                this.tXWriter = true;
                this.establishTransactionalWriter();
            }
        }
    }

    private void establishTransactionalWriter() {
        this.tWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    @Override
    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        if (!this.buildTableName(string).equals("")) {
            this.setTableName(this.buildTableName(string));
        }
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        if (resultSet == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.populate").toString());
        }
        this.RSMD = resultSet.getMetaData();
        this.RowSetMD = new RowSetMetaDataImpl();
        this.initMetaData(this.RowSetMD, this.RSMD);
        this.RSMD = null;
        int n2 = this.RowSetMD.getColumnCount();
        int n3 = this.getMaxRows();
        int n4 = 0;
        Row row = null;
        while (resultSet.next()) {
            row = new Row(n2);
            if (n4 > n3 && n3 > 0) {
                this.rowsetWarning.setNextWarning(new RowSetWarning("Populating rows setting has exceeded max row setting"));
            }
            for (int i2 = 1; i2 <= n2; ++i2) {
                Object object = map == null ? resultSet.getObject(i2) : resultSet.getObject(i2, map);
                if (object instanceof Struct) {
                    object = new SerialStruct((Struct)object, map);
                } else if (object instanceof SQLData) {
                    object = new SerialStruct((SQLData)object, map);
                } else if (object instanceof Blob) {
                    object = new SerialBlob((Blob)object);
                } else if (object instanceof Clob) {
                    object = new SerialClob((Clob)object);
                } else if (object instanceof Array) {
                    object = new SerialArray((Array)object, map);
                }
                row.initColumnObject(i2, object);
            }
            ++n4;
            this.rvh.add(row);
        }
        this.numRows = n4;
        this.notifyRowSetChanged();
    }

    private void initMetaData(RowSetMetaDataImpl rowSetMetaDataImpl, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        rowSetMetaDataImpl.setColumnCount(n2);
        for (int i2 = 1; i2 <= n2; ++i2) {
            rowSetMetaDataImpl.setAutoIncrement(i2, resultSetMetaData.isAutoIncrement(i2));
            rowSetMetaDataImpl.setCaseSensitive(i2, resultSetMetaData.isCaseSensitive(i2));
            rowSetMetaDataImpl.setCurrency(i2, resultSetMetaData.isCurrency(i2));
            rowSetMetaDataImpl.setNullable(i2, resultSetMetaData.isNullable(i2));
            rowSetMetaDataImpl.setSigned(i2, resultSetMetaData.isSigned(i2));
            rowSetMetaDataImpl.setSearchable(i2, resultSetMetaData.isSearchable(i2));
            rowSetMetaDataImpl.setColumnDisplaySize(i2, resultSetMetaData.getColumnDisplaySize(i2));
            rowSetMetaDataImpl.setColumnLabel(i2, resultSetMetaData.getColumnLabel(i2));
            rowSetMetaDataImpl.setColumnName(i2, resultSetMetaData.getColumnName(i2));
            rowSetMetaDataImpl.setSchemaName(i2, resultSetMetaData.getSchemaName(i2));
            rowSetMetaDataImpl.setPrecision(i2, resultSetMetaData.getPrecision(i2));
            rowSetMetaDataImpl.setScale(i2, resultSetMetaData.getScale(i2));
            rowSetMetaDataImpl.setTableName(i2, resultSetMetaData.getTableName(i2));
            rowSetMetaDataImpl.setCatalogName(i2, resultSetMetaData.getCatalogName(i2));
            rowSetMetaDataImpl.setColumnType(i2, resultSetMetaData.getColumnType(i2));
            rowSetMetaDataImpl.setColumnTypeName(i2, resultSetMetaData.getColumnTypeName(i2));
            if (this.conn == null) continue;
            try {
                this.dbmslocatorsUpdateCopy = this.conn.getMetaData().locatorsUpdateCopy();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        this.setConnection(connection);
        if (this.getPageSize() != 0) {
            this.crsReader = (CachedRowSetReader)this.provider.getRowSetReader();
            this.crsReader.setStartPosition(1);
            this.callWithCon = true;
            this.crsReader.readData(this);
        } else {
            this.rowSetReader.readData(this);
        }
        this.RowSetMD = (RowSetMetaDataImpl)this.getMetaData();
        if (connection != null) {
            try {
                this.dbmslocatorsUpdateCopy = connection.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException sQLException) {}
        } else {
            CachedRowSetReader cachedRowSetReader = (CachedRowSetReader)this.rowSetReader;
            Connection connection2 = cachedRowSetReader.connect(this);
            try {
                this.dbmslocatorsUpdateCopy = connection2.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection2 = null;
        }
    }

    private void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        if (this.onInsertRow) {
            throw new SyncProviderException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        int n2 = this.cursorPos;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (this.rowSetWriter != null) {
                n2 = this.cursorPos;
                bl3 = this.rowSetWriter.writeData(this);
                this.cursorPos = n2;
            }
            if (this.tXWriter) {
                if (!bl3) {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.rollback();
                    bl2 = false;
                } else {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.commit();
                    bl2 = true;
                }
            }
            if (bl2) {
                this.setOriginal();
            } else if (!bl2) {
            }
        }
        catch (SyncProviderException syncProviderException) {
            throw syncProviderException;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SyncProviderException(sQLException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new SyncProviderException(securityException.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        try {
            this.setConnection(connection);
            this.acceptChanges();
        }
        catch (SyncProviderException syncProviderException) {
            throw syncProviderException;
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    @Override
    public void restoreOriginal() throws SQLException {
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.getInserted()) {
                iterator.remove();
                --this.numRows;
                continue;
            }
            if (row.getDeleted()) {
                row.clearDeleted();
            }
            if (!row.getUpdated()) continue;
            row.clearUpdated();
        }
        this.cursorPos = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void release() throws SQLException {
        this.initContainer();
        this.notifyRowSetChanged();
    }

    @Override
    public void undoDelete() throws SQLException {
        if (!this.getShowDeleted()) {
            return;
        }
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getDeleted()) {
            row.clearDeleted();
            --this.numDeleted;
            this.notifyRowChanged();
        }
    }

    @Override
    public void undoInsert() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getInserted()) {
            this.rvh.remove(this.cursorPos);
            --this.numRows;
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.illegalop").toString());
        }
        this.notifyRowChanged();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.moveToCurrentRow();
        this.undoDelete();
        this.undoInsert();
    }

    @Override
    public RowSet createShared() throws SQLException {
        RowSet rowSet;
        try {
            rowSet = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException(cloneNotSupportedException.getMessage());
        }
        return rowSet;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        ObjectInputStream objectInputStream;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + iOException.getMessage());
        }
        try {
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream((InputStream)object);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new SQLException("Clone failed: " + streamCorruptedException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Clone failed: " + iOException.getMessage());
        }
        try {
            object = (CachedRowSetImpl)objectInputStream.readObject();
            ((CachedRowSetImpl)object).resBundle = this.resBundle;
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + classNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + iOException.getMessage());
        }
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        int n2 = this.numRows;
        this.numRows = 0;
        CachedRowSet cachedRowSet = this.createCopy();
        this.numRows = n2;
        return cachedRowSet;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        cachedRowSetImpl.initProperties();
        try {
            cachedRowSetImpl.unsetMatchColumn(cachedRowSetImpl.getMatchColumnIndexes());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            cachedRowSetImpl.unsetMatchColumn(cachedRowSetImpl.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return cachedRowSetImpl;
    }

    public Collection toCollection() throws SQLException {
        boolean bl2 = false;
        int n2 = this.RowSetMD.getColumnCount();
        TreeMap treeMap = new TreeMap();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            treeMap.put(new Integer(i2), this.rvh.get(i2));
        }
        return treeMap.values();
    }

    public Collection toCollection(int n2) throws SQLException {
        int n3;
        Vector<Object> vector = new Vector<Object>(n3);
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        for (n3 = this.numRows; n3 != 0; --n3) {
            cachedRowSetImpl.next();
            vector.add(cachedRowSetImpl.getObject(n2));
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColIdxByName(string));
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.provider;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.provider = SyncFactory.getInstance(string);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    @Override
    public void execute() throws SQLException {
        this.execute(null);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos >= this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean bl2 = this.internalNext();
        this.notifyCursorMoved();
        return bl2;
    }

    protected boolean internalNext() throws SQLException {
        boolean bl2 = false;
        do {
            if (this.cursorPos < this.numRows) {
                ++this.cursorPos;
                bl2 = true;
                continue;
            }
            if (this.cursorPos != this.numRows) continue;
            ++this.cursorPos;
            bl2 = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl2 ? ++this.absolutePos : 0;
        return bl2;
    }

    @Override
    public void close() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        this.initProperties();
        this.rvh.clear();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueNull;
    }

    private void setLastValueNull(boolean bl2) {
        this.lastValueNull = bl2;
    }

    private void checkIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.RowSetMD.getColumnCount()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString());
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
    }

    private int getColIdxByName(String string) throws SQLException {
        int n2 = this.RowSetMD.getColumnCount();
        for (int i2 = 1; i2 <= n2; ++i2) {
            String string2 = this.RowSetMD.getColumnName(i2);
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            return i2;
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalcolnm").toString());
    }

    protected BaseRow getCurrentRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return (BaseRow)this.rvh.get(this.cursorPos - 1);
    }

    protected void removeCurrentRow() {
        ((Row)this.getCurrentRow()).setDeleted();
        this.rvh.remove(this.cursorPos);
        --this.numRows;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        try {
            Double d2 = new Double(object.toString());
            return d2.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.boolfail").toString() + object.toString().trim() + n2);
        }
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.bytefail").toString() + object.toString() + n2);
        }
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Short(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.shortfail").toString() + object.toString() + n2);
        }
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Integer(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.intfail").toString() + object.toString() + n2);
        }
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return new Long(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.longfail").toString() + object.toString().trim() + n2);
        }
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return new Float(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.floatfail").toString() + object.toString().trim() + n2);
        }
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return new Double(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString() + object.toString().trim() + n2);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return new BigDecimal(0);
        }
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        BigDecimal bigDecimal2 = bigDecimal.setScale(n3);
        return bigDecimal2;
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return (byte[])this.getCurrentRow().getColumnObject(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 91: {
                long l2 = ((Date)object).getTime();
                return new Date(l2);
            }
            case 93: {
                long l3 = ((Timestamp)object).getTime();
                return new Date(l3);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    return (Date)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.datefail").toString() + object.toString().trim() + n2);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.datefail").toString() + object.toString().trim() + n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 92: {
                return (Time)object;
            }
            case 93: {
                long l2 = ((Timestamp)object).getTime();
                return new Time(l2);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Time)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n2);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 93: {
                return (Timestamp)object;
            }
            case 92: {
                long l2 = ((Time)object).getTime();
                return new Timestamp(l2);
            }
            case 91: {
                long l3 = ((Date)object).getTime();
                return new Timestamp(l3);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Timestamp)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n2);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n2);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        this.asciiStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.RowSetMD.getColumnType(n2))) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
            }
            this.asciiStream = new ByteArrayInputStream(((String)object).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        return this.asciiStream;
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.unicodeStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2)) && !this.isString(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.unicodeStream = new StringBufferInputStream(object.toString());
        return this.unicodeStream;
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        this.binaryStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.binaryStream = new ByteArrayInputStream((byte[])object);
        return this.binaryStream;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getColIdxByName(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColIdxByName(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColIdxByName(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColIdxByName(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColIdxByName(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColIdxByName(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColIdxByName(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColIdxByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColIdxByName(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColIdxByName(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColIdxByName(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColIdxByName(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColIdxByName(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColIdxByName(string));
    }

    @Override
    public SQLWarning getWarnings() {
        return this.sqlwarn;
    }

    @Override
    public void clearWarnings() {
        this.sqlwarn = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.posupdate").toString());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.RowSetMD;
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct) {
            Struct struct = (Struct)object;
            Map<String, Class<?>> map = this.getTypeMap();
            Class<?> clazz = map.get(struct.getSQLTypeName());
            if (clazz != null) {
                SQLData sQLData = null;
                try {
                    sQLData = (SQLData)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + illegalAccessException.getMessage());
                }
                Object[] objectArray = struct.getAttributes(map);
                SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
                sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
                return sQLData;
            }
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getColIdxByName(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.getColIdxByName(string);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.isBinary(this.RowSetMD.getColumnType(n2))) {
            Object object = this.getCurrentRow().getColumnObject(n2);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])object));
        } else if (this.isString(this.RowSetMD.getColumnType(n2))) {
            Object object = this.getCurrentRow().getColumnObject(n2);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(object.toString());
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return this.charStream;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColIdxByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return new BigDecimal(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString() + object.toString().trim() + n2);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string));
    }

    @Override
    public int size() {
        return this.numRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        int n2 = this.cursorPos;
        int n3 = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == n2) {
            return true;
        }
        this.cursorPos = n2;
        this.absolutePos = n3;
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        int n2 = this.cursorPos;
        int n3 = this.absolutePos;
        boolean bl2 = this.getShowDeleted();
        this.setShowDeleted(true);
        this.internalLast();
        if (this.cursorPos == n2) {
            this.setShowDeleted(bl2);
            return true;
        }
        this.setShowDeleted(bl2);
        this.cursorPos = n2;
        this.absolutePos = n3;
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.beforefirst").toString());
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.beforefirst").toString());
        }
        boolean bl2 = this.internalFirst();
        this.notifyCursorMoved();
        return bl2;
    }

    protected boolean internalFirst() throws SQLException {
        boolean bl2 = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            bl2 = !this.getShowDeleted() && this.rowDeleted() ? this.internalNext() : true;
        }
        this.absolutePos = bl2 ? 1 : 0;
        return bl2;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        boolean bl2 = this.internalLast();
        this.notifyCursorMoved();
        return bl2;
    }

    protected boolean internalLast() throws SQLException {
        boolean bl2 = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            bl2 = !this.getShowDeleted() && this.rowDeleted() ? this.internalPrevious() : true;
        }
        this.absolutePos = bl2 ? this.numRows - this.numDeleted : 0;
        return bl2;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1 && !this.getShowDeleted() && !this.rowDeleted()) {
            return this.absolutePos;
        }
        if (this.getShowDeleted()) {
            return this.cursorPos;
        }
        return 0;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        if (n2 == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.absolute").toString());
        }
        if (n2 > 0) {
            if (n2 > this.numRows) {
                this.afterLast();
                return false;
            }
            if (this.absolutePos <= 0) {
                this.internalFirst();
            }
        } else {
            if (this.cursorPos + n2 < 0) {
                this.beforeFirst();
                return false;
            }
            if (this.absolutePos >= 0) {
                this.internalLast();
            }
        }
        while (this.absolutePos != n2 && !(this.absolutePos < n2 ? !this.internalNext() : !this.internalPrevious())) {
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast() || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.relative").toString());
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 > 0) {
            if (this.cursorPos + n2 > this.numRows) {
                this.afterLast();
            } else {
                for (int i2 = 0; i2 < n2 && this.internalNext(); ++i2) {
                }
            }
        } else if (this.cursorPos + n2 < 0) {
            this.beforeFirst();
        } else {
            for (int i3 = n2; i3 < 0 && this.internalPrevious(); ++i3) {
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean bl2 = this.internalPrevious();
        this.notifyCursorMoved();
        return bl2;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean bl2 = false;
        do {
            if (this.cursorPos > 1) {
                --this.cursorPos;
                bl2 = true;
                continue;
            }
            if (this.cursorPos != 1) continue;
            --this.cursorPos;
            bl2 = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl2 ? --this.absolutePos : 0;
        return bl2;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getUpdated();
    }

    @Override
    public boolean columnUpdated(int n2) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getColUpdated(n2 - 1);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColIdxByName(string));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst() || this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        return ((Row)this.getCurrentRow()).getDeleted();
    }

    private boolean isNumeric(int n2) {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int n2) {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int n2) {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int n2) {
        switch (n2) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private Object convertNumeric(Object object, int n2, int n3) throws SQLException {
        if (n2 == n3) {
            return object;
        }
        if (!this.isNumeric(n3) && !this.isString(n3)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n3);
        }
        try {
            switch (n3) {
                case -7: {
                    Integer n4 = new Integer(object.toString().trim());
                    return n4.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(object.toString().trim());
                }
                case 5: {
                    return new Short(object.toString().trim());
                }
                case 4: {
                    return new Integer(object.toString().trim());
                }
                case -5: {
                    return new Long(object.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(object.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(object.toString().trim());
                }
                case 8: {
                    return new Double(object.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n3);
        }
    }

    private Object convertTemporal(Object object, int n2, int n3) throws SQLException {
        if (n2 == n3) {
            return object;
        }
        if (this.isNumeric(n3) || !this.isString(n3) && !this.isTemporal(n3)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        try {
            switch (n3) {
                case 91: {
                    if (n2 == 93) {
                        return new Date(((Timestamp)object).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case 93: {
                    if (n2 == 92) {
                        return new Timestamp(((Time)object).getTime());
                    }
                    return new Timestamp(((Date)object).getTime());
                }
                case 92: {
                    if (n2 == 93) {
                        return new Time(((Timestamp)object).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException("Data Type Mismatch");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        BaseRow baseRow = this.getCurrentRow();
        baseRow.setColumnObject(n2, null);
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Boolean(bl2), -7, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Byte(by), -6, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Short(s2), 5, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Integer(n3), 4, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Long(l2), -5, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Float(f2), 7, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Double(d2), 8, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(bigDecimal, 2, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.getCurrentRow().setColumnObject(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(date, 91, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(time, 92, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(timestamp, 93, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(n2)) && !this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] byArray = new byte[n3];
        try {
            int n4 = 0;
            while ((n4 += inputStream.read(byArray, n4, n3 - n4)) != n3) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.asciistream").toString());
        }
        String string = new String(byArray);
        this.getCurrentRow().setColumnObject(n2, string);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] byArray = new byte[n3];
        try {
            int n4 = 0;
            while ((n4 += inputStream.read(byArray, n4, n3 - n4)) != -1) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        this.getCurrentRow().setColumnObject(n2, byArray);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(n2)) && !this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        char[] cArray = new char[n3];
        try {
            int n4 = 0;
            while ((n4 += reader.read(cArray, n4, n3 - n4)) != n3) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        String string = new String(cArray);
        this.getCurrentRow().setColumnObject(n2, string);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        int n4 = this.RowSetMD.getColumnType(n2);
        if (n4 == 3 || n4 == 2) {
            ((BigDecimal)object).setScale(n3);
        }
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColIdxByName(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.getColIdxByName(string), bl2);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColIdxByName(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColIdxByName(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColIdxByName(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColIdxByName(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColIdxByName(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColIdxByName(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColIdxByName(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColIdxByName(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColIdxByName(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColIdxByName(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColIdxByName(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColIdxByName(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColIdxByName(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColIdxByName(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.onInsertRow || !this.insertRow.isCompleteRow(this.RowSetMD)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.failedins").toString());
        }
        Object[] objectArray = this.getParams();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.insertRow.setColumnObject(i2 + 1, objectArray[i2]);
        }
        Row row = new Row(this.RowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        row.setInserted();
        int n2 = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.rvh.add(n2, row);
        ++this.numRows;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.updateins").toString());
        }
        ((Row)this.getCurrentRow()).setUpdated();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkCursor();
        ((Row)this.getCurrentRow()).setDeleted();
        ++this.numDeleted;
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        row.clearUpdated();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getUpdated()) {
            row.clearUpdated();
            this.notifyRowChanged();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins").toString());
        }
        if (this.insertRow == null) {
            if (this.RowSetMD == null) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins1").toString());
            }
            int n2 = this.RowSetMD.getColumnCount();
            if (n2 > 0) {
                this.insertRow = new InsertRow(n2);
            } else {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins2").toString());
            }
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (!this.onInsertRow) {
            return;
        }
        this.cursorPos = this.currentRow;
        this.onInsertRow = false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        Struct struct;
        Class<?> clazz;
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct && (clazz = map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2006) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Ref ref = (Ref)this.getCurrentRow().getColumnObject(n2);
        if (ref == null) {
            this.setLastValueNull(true);
            return null;
        }
        return ref;
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2004) {
            System.out.println(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString() + this.RowSetMD.getColumnType(n2));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Blob blob = (Blob)this.getCurrentRow().getColumnObject(n2);
        if (blob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2005) {
            System.out.println(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString() + this.RowSetMD.getColumnType(n2));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Clob clob = (Clob)this.getCurrentRow().getColumnObject(n2);
        if (clob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return clob;
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Array array = (Array)this.getCurrentRow().getColumnObject(n2);
        if (array == null) {
            this.setLastValueNull(true);
            return null;
        }
        return array;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.getColIdxByName(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColIdxByName(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColIdxByName(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColIdxByName(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColIdxByName(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 91);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        return new Date(calendar.getTime().getTime());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColIdxByName(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 92);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Time(calendar.getTime().getTime());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColIdxByName(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 93);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Timestamp(calendar.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string), calendar);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.RowSetMD = (RowSetMetaDataImpl)rowSetMetaData;
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.RowSetMD = this.RowSetMD;
        cachedRowSetImpl.numRows = this.numRows;
        cachedRowSetImpl.cursorPos = 0;
        int n2 = this.RowSetMD.getColumnCount();
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = new Row(n2, ((Row)iterator.next()).getOrigRow());
            cachedRowSetImpl.rvh.add(row);
        }
        return cachedRowSetImpl;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.RowSetMD = this.RowSetMD;
        cachedRowSetImpl.numRows = 1;
        cachedRowSetImpl.cursorPos = 0;
        Row row = new Row(this.RowSetMD.getColumnCount(), this.getCurrentRow().getOrigRow());
        cachedRowSetImpl.rvh.add(row);
        return cachedRowSetImpl;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        Row row = (Row)this.getCurrentRow();
        this.makeRowOriginal(row);
        if (row.getDeleted()) {
            this.removeCurrentRow();
            --this.numRows;
        }
    }

    private void makeRowOriginal(Row row) {
        if (row.getInserted()) {
            row.clearInserted();
        }
        if (row.getUpdated()) {
            row.moveCurrentToOrig();
        }
    }

    public void setOriginal() throws SQLException {
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.makeRowOriginal(row);
            if (!row.getDeleted()) continue;
            iterator.remove();
            --this.numRows;
        }
        this.numDeleted = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public void setTableName(String string) throws SQLException {
        if (string == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.tablename").toString());
        }
        this.tableName = new String(string);
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyCols;
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.RowSetMD != null && nArray.length > (n2 = this.RowSetMD.getColumnCount())) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.keycols").toString());
        }
        this.keyCols = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (this.RowSetMD != null && (nArray[i2] <= 0 || nArray[i2] > n2)) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString() + nArray[i2]);
            }
            this.keyCols[i2] = nArray[i2];
        }
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, new SerialRef(ref));
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColIdxByName(string), ref);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(n2, new SerialClob(clob));
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColIdxByName(string), clob);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(n2, new SerialBlob(blob));
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColIdxByName(string), blob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, new SerialArray(array));
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColIdxByName(string), array);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 70) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        URL uRL = (URL)this.getCurrentRow().getColumnObject(n2);
        if (uRL == null) {
            this.setLastValueNull(true);
            return null;
        }
        return uRL;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColIdxByName(string));
    }

    @Override
    public RowSetWarning getRowSetWarnings() {
        try {
            this.notifyCursorMoved();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.rowsetWarning;
    }

    private String buildTableName(String string) throws SQLException {
        String string2 = "";
        if ((string = string.trim()).toLowerCase().startsWith("select")) {
            int n2 = string.toLowerCase().indexOf("from");
            int n3 = string.indexOf(",", n2);
            if (n3 == -1) {
                string2 = string.substring(n2 + "from".length(), string.length()).trim();
                String string3 = string2;
                int n4 = string3.toLowerCase().indexOf("where");
                if (n4 != -1) {
                    string3 = string3.substring(0, n4).trim();
                }
                string2 = string3;
            }
        } else if (string.toLowerCase().startsWith("insert") || string.toLowerCase().startsWith("update")) {
            // empty if block
        }
        return string2;
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = Integer.parseInt(this.iMatchColumns.get(n2).toString());
            if (nArray[n2] == n3) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.iMatchColumns.set(n2, new Integer(-1));
        }
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals(this.strMatchColumns.get(n2))) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.strMatchColumns.set(n2, null);
        }
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        Object[] objectArray = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.strMatchColumns.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] objectArray = new Integer[this.iMatchColumns.size()];
        int[] nArray = new int[this.iMatchColumns.size()];
        int n2 = (Integer)this.iMatchColumns.get(0);
        if (n2 == -1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.iMatchColumns.copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArray[i2] = (Integer)objectArray[i2];
        }
        return nArray;
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.iMatchColumns.add(n2, new Integer(nArray[n2]));
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null && !stringArray[n2].equals("")) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.strMatchColumns.add(n2, stringArray[n2]);
        }
    }

    @Override
    public void setMatchColumn(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
        }
        this.iMatchColumns.set(0, new Integer(n2));
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        if ((string = string.trim()) == "" || string.equals(null)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
        }
        this.strMatchColumns.set(0, string);
    }

    @Override
    public void unsetMatchColumn(int n2) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(n2))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch1").toString());
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        string = string.trim();
        if (!this.strMatchColumns.get(0).equals(string)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch2").toString());
        }
        this.strMatchColumns.set(0, null);
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        if (n2 < 0 || n2 < this.getFetchSize()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.numrows").toString());
        }
        if (this.size() % n2 == 0) {
            RowSetEvent rowSetEvent2;
            rowSetEvent = rowSetEvent2 = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public void populate(ResultSet resultSet, int n2) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        this.cursorPos = 0;
        if (this.populatecallcount == 0) {
            if (n2 < 0) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.startpos").toString());
            }
            if (this.getMaxRows() == 0) {
                resultSet.absolute(n2);
                while (resultSet.next()) {
                    ++this.totalRows;
                }
                ++this.totalRows;
            }
            this.startPos = n2;
        }
        ++this.populatecallcount;
        this.resultSet = resultSet;
        if (this.endPos - this.startPos >= this.getMaxRows() && this.getMaxRows() > 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        if ((this.maxRowsreached != this.getMaxRows() || this.maxRowsreached != this.totalRows) && this.pagenotend) {
            this.startPrev = n2 - this.getPageSize();
        }
        if (this.pageSize == 0) {
            this.prevEndPos = this.endPos;
            this.endPos = n2 + this.getMaxRows();
        } else {
            this.prevEndPos = this.endPos;
            this.endPos = n2 + this.getPageSize();
        }
        if (n2 == 1) {
            this.resultSet.beforeFirst();
        } else {
            this.resultSet.absolute(n2 - 1);
        }
        this.rvh = this.pageSize == 0 ? new Vector(this.getMaxRows()) : new Vector(this.getPageSize());
        if (resultSet == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.populate").toString());
        }
        this.RSMD = resultSet.getMetaData();
        this.RowSetMD = new RowSetMetaDataImpl();
        this.initMetaData(this.RowSetMD, this.RSMD);
        this.RSMD = null;
        int n3 = this.RowSetMD.getColumnCount();
        int n4 = this.getMaxRows();
        int n5 = 0;
        Row row = null;
        if (!resultSet.next() && n4 == 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        resultSet.previous();
        while (resultSet.next()) {
            row = new Row(n3);
            if (this.pageSize == 0) {
                if (n5 >= n4 && n4 > 0) {
                    this.rowsetWarning.setNextException(new SQLException("Populating rows setting has exceeded max row setting"));
                    break;
                }
            } else if (n5 >= this.pageSize || this.maxRowsreached >= n4 && n4 > 0) {
                this.rowsetWarning.setNextException(new SQLException("Populating rows setting has exceeded max row setting"));
                break;
            }
            for (int i2 = 1; i2 <= n3; ++i2) {
                Object object = map == null ? resultSet.getObject(i2) : resultSet.getObject(i2, map);
                if (object instanceof Struct) {
                    object = new SerialStruct((Struct)object, map);
                } else if (object instanceof SQLData) {
                    object = new SerialStruct((SQLData)object, map);
                } else if (object instanceof Blob) {
                    object = new SerialBlob((Blob)object);
                } else if (object instanceof Clob) {
                    object = new SerialClob((Clob)object);
                } else if (object instanceof Array) {
                    object = new SerialArray((Array)object, map);
                }
                row.initColumnObject(i2, object);
            }
            ++n5;
            ++this.maxRowsreached;
            this.rvh.add(row);
        }
        this.numRows = n5;
        this.notifyRowSetChanged();
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.populatecallcount == 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nextpage").toString());
        }
        if (this.populatecallcount == 1) {
            ++this.populatecallcount;
            return this.pagenotend;
        }
        this.onFirstPage = false;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.endPos);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.endPos);
        }
        return this.pagenotend;
    }

    @Override
    public void setPageSize(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize").toString());
        }
        if (n2 > this.getMaxRows() && this.getMaxRows() != 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize1").toString());
        }
        this.pageSize = n2;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean previousPage() throws SQLException {
        int n2 = this.getPageSize();
        int n3 = this.maxRowsreached;
        if (this.populatecallcount == 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nextpage").toString());
        }
        if (!this.callWithCon && this.resultSet.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.fwdonly").toString());
        }
        this.pagenotend = true;
        if (this.startPrev < this.startPos) {
            this.onFirstPage = true;
            return false;
        }
        if (this.onFirstPage) {
            return false;
        }
        int n4 = n3 % n2;
        if (n4 == 0) {
            this.maxRowsreached -= 2 * n2;
            if (this.callWithCon) {
                this.crsReader.setStartPosition(this.startPrev);
                this.crsReader.readData(this);
                this.resultSet = null;
            } else {
                this.populate(this.resultSet, this.startPrev);
            }
            return true;
        }
        this.maxRowsreached -= n2 + n4;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.startPrev);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.startPrev);
        }
        return true;
    }
}

